/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "xip.h"
#include "xipshcut.h"

extern char			*pcap_dev;
extern char			hard_filter[];
extern int			pcap_snaplen;
extern int			pcap_promisc;
extern int			pcap_to_ms;
extern int			pcap_optimize;
extern t_dict			*extravars;

t_vec				*shortcuts_vec = NULL;

t_assoc				shortcuts_assocs[] =
{
  {"",
   "<b>%Date%</b> %Layer% %ether.shost% %ether.dhost% %ether.Type% %Len%"},
  {"arp[6:2] = 1",
   "<b>%Date%</b> arp who-has %arpethip.Tpa% tell %arpethip.Spa%"},
  {"arp[6:2] = 2",
   "<b>%Date%</b> %arpethip.Spa% tells %arpethip.Tpa% he has %arpethip.sha%"},
  {"ip",
   "<b>%Date%</b> ip hl=%ip.hl% v=%ip.v% tos=%ip.Tos% len=%ip.len% id=%ip.id% off=%ip.off% ttl=%ip.ttl% p=%ip.P% sum=%ip.sum% src=%ip.Src% dst=%ip.Dst% %data.len%"},
  {"icmp",
   "<b>%Date%</b> icmp %ip.Src% > %ip.Dst% %icmp.Type% %icmp.Code% %data.len%"},
  {"udp",
   "<b>%Date%</b> udp %ip.Src%.%udp.Sport% > %ip.Dst%.%udp.Dport% %data.len%"},
  {"tcp",
   "<b>%Date%</b> tcp %ip.Src%.%tcp.Sport% > %ip.Dst%.%tcp.Dport% seq %tcp.Seq% ack %tcp.Ack% win %tcp.win% [%tcp.Flags%] %data.len%"},
  {NULL,NULL},
};

/* destroys shortcuts context */
VOID_FUNC		shortcuts_destroy(VOID_DECL)
{
  vec_ptr_delete(shortcuts_vec);
}

extern pcap_t		*pcap;

/* adds a shortcut to shortcuts.
   It is intended to be used by plugins.
   Returns 0 if OK. -ERR_SUBROUTINE if pcap compilation fails. Might
   return various errors. */
t_status		shortcut_add(assoc)
t_assoc			*assoc;
{
  t_status		status;
  t_shortcut		*shortcut;
  struct bpf_program	bp;

  if (pcap_compile(pcap,&bp,assoc->left,pcap_optimize,0) < 0)
    {
      err_print(ERR_SUBROUTINE,"pcap_compile %s",assoc->left);
      return (-ERR_SUBROUTINE);
    }
  if ((shortcut = XIP_ALLOC_PROC(sizeof (t_shortcut),
				 "xip",
				 "shortcut_add:ptr",
				 &status)) == NULL)
    return (status);
  shortcut->bpf_filter = assoc->left;
  shortcut->format = assoc->right;
  FBCOPY(&bp,&(shortcut->bp),sizeof (bp));
  if ((status = vec_add(shortcuts_vec,
			shortcut)) < 0)
    {
      XIP_FREE_PROC(shortcut,
		    "xip",
		    "*:ptr");
      return (status);
    }
  return (0);
}

/* initializes shortcuts context.
   Returns 0 if OK. Might return various errors */
t_status		shortcuts_init(VOID_DECL)
{
  t_status		status;
  t_assoc		*assoc;

  if ((shortcuts_vec = XIP_VEC_NEW(VEC_BASE,
				   &status)) == NULL)
    {
      err_print(-status,"XIP_VEC_NEW");
      exit(1);
    }
  assoc = shortcuts_assocs;
  while (assoc->left)
    {
      if ((status = shortcut_add(assoc)) < 0)
	return (status);
      assoc++;
    }
  return (0);
}

/* catenates an HTML shortcut to string by matching pcap filters.
   Returns 0 if OK. Might return various errors such as -ERR_BO. */
t_status		shortcuts_do(pkt,str,max_len)
t_pkt			*pkt;
char			*str;
int			max_len;
{
  t_status		status;
  char			tmpl[STR_BUFSIZ];
  char			htmlize[STR_BUFSIZ];
  
  VEC_FOR_REV(shortcuts_vec,t_shortcut *shortcut)
    {
      if (bpf_filter(shortcut->bp.bf_insns,
		     (unsigned char *)(pkt->buf),
		     pkt->netlen,
		     pkt->len))
	{
	  tmpl[0] = 0;
	  if ((status = str_cat_str(tmpl,
				    sizeof (tmpl),
				    shortcut->format)) < 0)
	    break ;
	  str[0] = 0;
	  if ((status = str_cat_str(str,
				    max_len,
				    "<html><body>")) < 0)
	    return (status);
	  if ((status = pkt_format_html_permissive(pkt,
						   tmpl,
						   NULL,
						   extravars,
						   str,
						   max_len,
						   htmlize,
						   sizeof (htmlize))) < 0)
	    return (status);
	  if ((status = str_cat_str(str,
				    max_len,
				    "</body><html>")) < 0)
	    return (status);
	  break ;
	}
    }
  VEC_ENDFOR;
  return (0);
}
