/************************************************/
/* XNews 2.0					*/
/* X version of the old UNIX "news" program	*/
/* (c) 1996 by James Gritton			*/
/************************************************/

#include	<dirent.h>
#include	<errno.h>
#include	<fcntl.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<time.h>
#include	<utime.h>
#include	<sys/types.h>
#include	<sys/stat.h>

#ifdef	MOTIF
#include	<Xm/Form.h>
#include	<Xm/LabelG.h>
#include	<Xm/MessageB.h>
#include	<Xm/PushB.h>
#include	<Xm/Text.h>
#else
#include	<X11/Intrinsic.h>
#include	<X11/Shell.h>
#include	<X11/StringDefs.h>
#include	<X11/Xaw/AsciiText.h>
#include	<X11/Xaw/Command.h>
#include	<X11/Xaw/Dialog.h>
#endif

#ifdef	HAS_MMAP
#include	<sys/mman.h>
#endif

#define	DEFWIDTH	80
#define	DEFHEIGHT	24

typedef	struct
{
    time_t	time;
    char	name[MAXNAMLEN+1];
} item_t, *item_p;

static	void	add_item();
static	void	button_callback();
static	void	error_callback();
static	char	*item_text();
static	char	*list_items();
static	int	sort_items();

static	int		nitems, curitem;
static	item_p		items;
static	Boolean		all, named;
static	Widget		form, ok, cancel, prev, text, name, date;

#ifdef	MOTIF
static	Widget		message;
static	XmString	okstring, nextstring;
#endif

main( argc, argv)
int	argc;
char	*argv[];
{
    int				geoflags, geox, geoy;
    unsigned			geowidth, geoheight;
    char			*ct, *em;
    Dimension			dialog_width, dialog_height;
    Dimension			text_width, text_height;
    String			geometry;
    XtAppContext		app;
    Widget			top;
    char			geostring[25];	/* fits +-X+-Y where	*/
						/* X,Y are 10 digits	*/

#ifdef	MOTIF
    short			columns, rows;
    Dimension			width_inc, height_inc;
    Arg				args[14];
    XmString			xms;
#else
    int				hdist;
    Dimension			left_margin, right_margin, top_margin,
				bottom_margin;
    Position			y;
    XFontStruct			*font;
#endif

    static XrmOptionDescRec	aioptions[2] =
    {
	"-all",
	"*.all",
	XrmoptionNoArg,
	(XPointer) "True",
	"-latest",
	"*.all",
	XrmoptionNoArg,
	(XPointer) "False"
    };
    static XtCallbackRec	cb[2] =
    {
	(XtCallbackProc) button_callback,
	NULL
    };
    static XtResource		airesource =
    {
	"all",
	"All",
	XtRBoolean,
	sizeof( Boolean),
	0,
	XtRBoolean,
	(XtPointer) False
    };
    static XtResource		georesource =
    {
	XtNgeometry,
	XtCGeometry,
	XtRString,
	sizeof( String),
	0,
	XtRImmediate,
	(XtPointer) NULL
    };

    /* Initialize the toolkit					*/
    /* If the user specified a top-level geometry,		*/
    /* get it for the text widget, and make the shell ignore it	*/

    XtSetLanguageProc (NULL, NULL, NULL);
    top = XtAppInitialize( &app, "XNews", aioptions, 2, &argc, argv, NULL,
	NULL, 0);
    geowidth = DEFWIDTH;
    geoheight = DEFHEIGHT;
    XtGetApplicationResources( top, (XtPointer) &geometry, &georesource, 1,
	NULL, 0);
    if (geometry)
    {
	geoflags =
	    XParseGeometry( geometry, &geox, &geoy, &geowidth, &geoheight);
	if (geoflags & XValue)
	    sprintf( geostring, "%c%d", (geoflags & XNegative) ? '-' : '+',
		 geox);
	else
	    geostring[0] = 0;
	if (geoflags & YValue)
	    sprintf( strchr( geostring, 0), "%c%d",
		 (geoflags & YNegative) ? '-' : '+', geoy);
	XtVaSetValues( top, XtNgeometry, geostring[0] ? geostring : NULL,
	    NULL);
    }

    /* Read the news items. If there's an error,	*/
    /* turn the lop-level into an error dialog		*/

    XtGetApplicationResources( top, (XtPointer) &all, &airesource, 1,
	NULL, 0);
    named = argc > 1;
    if (em = list_items( argc, argv))
    {
#ifdef	MOTIF
	xms = XmStringCreateLtoR( em, XmFONTLIST_DEFAULT_TAG);
	message = XtVaCreateWidget( "error", xmMessageBoxWidgetClass, top,
	    XmNdialogType, XmDIALOG_ERROR,
	    XtVaTypedArg, XmNsymbolPixmap, XmRString, "xm_error", 9,
	    XmNmessageString, xms, XmNokCallback, cb, NULL);
	XmStringFree( xms);
       
	XtUnmanageChild(
	    XmMessageBoxGetChild( message, XmDIALOG_CANCEL_BUTTON));
	XtUnmanageChild(
	    XmMessageBoxGetChild( message, XmDIALOG_HELP_BUTTON));
	XtManageChild( message);
#else
	form = XtVaCreateWidget( "error", dialogWidgetClass, top,
	    XtNlabel, em, NULL);

	cb[0].callback = (XtCallbackProc) error_callback;
	ok = XtVaCreateManagedWidget( "ok", commandWidgetClass, form,
	    XtNlabel, "OK", XtNcallback, cb, NULL);

	XtManageChild( form);
#endif
	XtRealizeWidget( top);
	XtAppMainLoop( app);
	return 1;
    }

    /* If there's no news, there's nothing else to do */

    if (!items)
	return 0;

    /* Set up all our widgets */

#ifdef	MOTIF
    okstring = XmStringCreateLocalized( "OK");
    nextstring = XmStringCreateLocalized( "Next");
    XtSetArg( args[0], XmNdialogType, XmDIALOG_TEMPLATE);
    XtSetArg( args[1], XmNokCallback, cb);
    XtSetArg( args[2], XmNcancelCallback, cb);
    XtSetArg( args[3], XmNokLabelString, nitems > 1 ? nextstring : okstring);
    message = XmCreateMessageBox( top, "message", args, 4);
    form = XmCreateForm( message, "form", NULL, 0);
#else
    form = XtVaCreateWidget( "form", formWidgetClass, top, NULL);
#endif

#ifdef	MOTIF
    xms = XmStringCreateLocalized( items[0].name);
    XtSetArg( args[0], XmNlabelString, xms);
    XtSetArg( args[1], XmNleftAttachment, XmATTACH_FORM);
    name = XmCreateLabelGadget( form, "name", args, 2);
    XmStringFree( xms);
#else
    name = XtVaCreateManagedWidget( "name", labelWidgetClass, form,
	XtNborderWidth, 0, XtNlabel, items[0].name, XtNleft, XtChainLeft,
	XtNright, XtChainLeft, XtNtop, XtChainTop, XtNbottom, XtChainTop,
	XtNresizable, True, NULL);
#endif

    ct = ctime( &items[0].time);
    ct[24] = 0;
#ifdef	MOTIF
    xms = XmStringCreateLocalized( ct);
    XtSetArg( args[0], XmNlabelString, xms);
    XtSetArg( args[1], XmNrightAttachment, XmATTACH_FORM);
    date = XmCreateLabelGadget( form, "date", args, 2);
    XmStringFree( xms);
#else
    date = XtVaCreateManagedWidget( "date", labelWidgetClass, form,
	XtNborderWidth, 0, XtNlabel, ct, XtNleft, XtChainRight,
	XtNright, XtChainRight, XtNtop, XtChainTop, XtNbottom, XtChainTop,
	XtNresizable, True, NULL);
#endif

#ifdef	MOTIF
    XtSetArg( args[0], XmNcolumns, geowidth);
    XtSetArg( args[1], XmNcursorPositionVisible, False);
    XtSetArg( args[2], XmNeditable, False);
    XtSetArg( args[3], XmNeditMode, XmMULTI_LINE_EDIT);
    XtSetArg( args[4], XmNrows, geoheight);
    XtSetArg( args[5], XmNscrollHorizontal, False);
    XtSetArg( args[6], XmNvalue, item_text( 0));
    XtSetArg( args[7], XmNwordWrap, True);
    XtSetArg( args[8], XmNtopAttachment, XmATTACH_WIDGET);
    XtSetArg( args[9], XmNtopOffset, 10);
    XtSetArg( args[10], XmNtopWidget, name);
    XtSetArg( args[11], XmNbottomAttachment, XmATTACH_FORM);
    XtSetArg( args[12], XmNleftAttachment, XmATTACH_FORM);
    XtSetArg( args[13], XmNrightAttachment, XmATTACH_FORM);
    text = XmCreateScrolledText( form, "text", args, 14);
#else
    text = XtVaCreateManagedWidget( "text", asciiTextWidgetClass, form,
	XtNdisplayCaret, False, XtNeditType, XawtextRead,
	XtNscrollHorizontal, XawtextScrollWhenNeeded,
	XtNscrollVertical, XawtextScrollAlways, XtNuseStringInPlace, True,
	XtNstring, item_text( 0), XtNfromVert, name, XtNleft, XtChainLeft,
	XtNright, XtChainRight, XtNtop, XtChainTop, XtNbottom, XtChainBottom,
	NULL);
#endif

#ifdef	MOTIF
    ok = XmMessageBoxGetChild( message, XmDIALOG_OK_BUTTON);
#else
    ok = XtVaCreateManagedWidget( "ok", commandWidgetClass, form,
	XtNlabel, nitems > 1 ? "Next" : "OK", XtNcallback, cb,
	XtNfromVert, text, XtNleft, XtChainLeft, XtNright, XtChainLeft,
	XtNtop, XtChainBottom, XtNbottom, XtChainBottom, NULL);
#endif

    if (nitems > 1)
    {
#ifdef	MOTIF
	xms = XmStringCreateLocalized( "Previous");
	XtSetArg( args[0], XmNlabelString, xms);
	XtSetArg( args[1], XmNactivateCallback, cb);
	XtSetArg( args[2], XmNsensitive, False);
	prev = XmCreatePushButton( message, "previous", args, 3);
	XmStringFree( xms);
	if (prev)
	    XtManageChild( prev);
#else
	prev = XtVaCreateManagedWidget( "prev", commandWidgetClass, form,
	    XtNlabel, "Previous", XtNcallback, cb, XtNsensitive, False,
	    XtNfromHoriz, ok, XtNfromVert, text, XtNleft, XtChainLeft,
	    XtNright, XtChainLeft, XtNtop, XtChainBottom,
	    XtNbottom, XtChainBottom, NULL);
#endif
    }

#ifdef	MOTIF
    cancel = XmMessageBoxGetChild( message, XmDIALOG_CANCEL_BUTTON);
#else
    cancel = XtVaCreateManagedWidget( "cancel", commandWidgetClass, form,
	XtNlabel, "Cancel", XtNcallback, cb, XtNfromHoriz, prev ? prev : ok,
	XtNfromVert, text, XtNleft, XtChainLeft, XtNright, XtChainLeft,
	XtNtop, XtChainBottom, XtNbottom, XtChainBottom,
	NULL);
#endif

    /* Do some ugly fiddling around to find the width/height increment sizes */

#ifdef	MOTIF
    XtVaGetValues( text, XmNwidth, &text_width, XmNheight, &text_height,
	XmNcolumns, &columns, XmNrows, &rows, NULL);
    XtVaSetValues( text, XmNcolumns, columns + 1, XmNrows, rows + 1, NULL);
    XtVaGetValues( text, XmNwidth, &width_inc, XmNheight, &height_inc, NULL);
    XtVaSetValues( text, XmNcolumns, columns, XmNrows, rows, NULL);
    XtVaGetValues( text, XmNwidth, &dialog_width,  XmNheight,
	&dialog_height, NULL);
    width_inc -= dialog_width;
    height_inc -= dialog_height;
    if (dialog_width != text_width || dialog_height != text_height)
	XtVaSetValues( text, XmNwidth, text_width, XmNheight, text_height,
	    NULL);
#else
    XtVaGetValues( text, XtNleftMargin, &left_margin,
	XtNrightMargin, &right_margin, XtNtopMargin, &top_margin,
	XtNbottomMargin, &bottom_margin, XtNfont, &font, NULL);
    XtVaSetValues( text, XtNwidth, font->per_char['0'].width * geowidth +
	left_margin + right_margin, XtNheight, (font->ascent + font->descent) *
	geoheight + top_margin + bottom_margin, NULL);
#endif

#ifdef	MOTIF
    XtManageChild( name);
    XtManageChild( date);
    XtManageChild( text);
#endif
    XtManageChild( form);
#ifdef	MOTIF
    XtManageChild( message);
#endif
    XtRealizeWidget( top);

    /* Now that things are realized, and geometries are final,	*/
    /* find the base height for the window manager		*/
    /* I'd prefer to do this before the top-level window is	*/
    /* mapped, but this is the first chance I have		*/

#ifdef	MOTIF
    XtVaGetValues( text, XmNcolumns, &columns, XmNrows, &rows, NULL);
    XtVaGetValues( message, XmNwidth, &dialog_width, XmNheight,
	&dialog_height, NULL);
    XtVaSetValues( top, XmNbaseWidth, dialog_width - columns * width_inc,
	XmNbaseHeight, dialog_height - rows * height_inc, XmNwidthInc,
	width_inc, XmNheightInc, height_inc, NULL);
#else
    XtVaGetValues( text, XtNwidth, &text_width, XtNheight, &text_height, NULL);
    XtVaGetValues( form, XtNwidth, &dialog_width, XtNheight, &dialog_height,
	NULL);
    XtVaSetValues( top, XtNbaseWidth, dialog_width - (text_width - left_margin
	- right_margin), XtNbaseHeight, dialog_height - (text_height -
	top_margin - bottom_margin), XtNwidthInc, font->per_char['0'].width,
	XtNheightInc, font->ascent + font->descent, NULL);
    XtVaGetValues( date, XtNwidth, &text_width, XtNborderWidth, &text_height,
	XtNy, &y, XtNhorizDistance, &hdist, NULL);
    XtMoveWidget( date, dialog_width - text_width - (text_height << 1) - hdist,
	y);
#endif

    XtAppMainLoop( app);
}

/********************************/
/* add_item			*/
/* Add a news item to the list	*/
/********************************/

static void add_item( name)
char	*name;
{
    struct stat	st;
    item_p	ip;

    if (stat( name, &st) >= 0)
    {
	items = (item_p) XtRealloc( items,
	    ++nitems * sizeof( item_t) + strlen( name));
	items[nitems - 1].time = st.st_mtime;
	strcpy( items[nitems - 1].name, name);
    }
}

/************************************************/
/* button_callback				*/
/* The callback function for all three buttons	*/
/************************************************/

static void button_callback(w, client_data, call_data)
Widget			w;
XtPointer		client_data;
#ifdef	MOTIF
XmAnyCallbackStruct	*call_data;
#else
XtPointer		*call_data;
#endif
{
    char		*home, *ct;
    char		fname[BUFSIZ];
    struct utimbuf	ut;

#ifdef	MOTIF
    XmString		xms;
#else
    int			hdist;
    Dimension		dialog_width, date_width, border_width;
    Position		y;
#endif

#ifdef	MOTIF
    switch (call_data->reason)
    {
    case XmCR_OK:
#else
    if (w == ok)
    {
#endif
	/* "Next" or "OK"				*/
	/* Go to the next news item,			*/
	/* or quit and update .news_time if done	*/

	if (++curitem < nitems)
	    goto newitem;
	if (!all && !named && (home = getenv( "HOME")))
	{
	    sprintf( fname, "%s/.news_time", home);
	    ut.actime = ut.modtime = time( NULL);
	    if (utime( fname, &ut) < 0 && errno == ENOENT)
		creat( fname, 0666);
	}
	exit( 0);
#ifdef	MOTIF
    case XmCR_CANCEL:
#else
    }
    else if (w == cancel)
    {
#endif
	/* "Cancel"						*/
	/* Quit without updating time for the current item	*/

	exit( 0);
#ifdef	MOTIF
    case XmCR_ACTIVATE:
#else
    }
    else if (w == prev)
    {
#endif
	/* "Prev"			*/
	/* Go to the previous item	*/

	if (curitem > 0)
	    curitem--;
    }

    /* The item number has changed: load the new item	*/
    /* into the widget resources			*/

 newitem:
#ifdef	MOTIF
    XtVaSetValues( ok, XmNlabelString,
	curitem == nitems - 1 ? okstring : nextstring, NULL);
    if (prev && nitems > 1 && (curitem == 0 ||
	(curitem == 1 && call_data->reason == XmCR_OK)))
	XtVaSetValues( prev, XmNsensitive, curitem > 0, NULL);
    if (curitem == 0)
	XmProcessTraversal( ok, XmTRAVERSE_CURRENT);
    xms = XmStringCreateLocalized( items[curitem].name);
    XtVaSetValues( name, XmNlabelString, xms, NULL);
    XmStringFree( xms);
#else
    XtVaSetValues( ok, XtNlabel, curitem == nitems - 1 ? "OK" : "Next", NULL);
    if (prev && nitems > 1 && (curitem == 0 || (curitem == 1 && w == ok)))
	XtVaSetValues( prev, XtNsensitive, curitem > 0, NULL);
    XtVaSetValues( name, XtNlabel, items[curitem].name, NULL);
#endif
    ct = ctime( &items[curitem].time);
    ct[24] = 0;
#ifdef	MOTIF
    xms = XmStringCreateLocalized( ct);
    XtVaSetValues( date, XmNlabelString, xms, NULL);
    XtVaSetValues( text, XmNvalue, item_text( curitem), NULL);
    XmStringFree( xms);
#else
    XtVaSetValues( date, XtNlabel, ct, NULL);
    XtVaSetValues( text, XtNstring, item_text( curitem), NULL);
    XtVaGetValues( form, XtNwidth, &dialog_width, NULL);
    XtVaGetValues( date, XtNwidth, &date_width, XtNborderWidth, &border_width,
	XtNy, &y, XtNhorizDistance, &hdist, NULL);
    XtMoveWidget( date, dialog_width - date_width - (border_width << 1) -
	hdist, y);
#endif
    return;
}

/************************************************/
/* error_callback				*/
/* The callback function for the error dialog	*/
/************************************************/

static void error_callback(w, client_data, call_data)
Widget		w;
XtPointer	client_data;
XtPointer	*call_data;
{
    exit( 1);
}

/************************************************/
/* item_text					*/
/* Return a pointer to the text of the item	*/
/************************************************/

static char *item_text( n)
int	n;
{
    int			fd;
    struct stat		st;
    static char		*text;
    static size_t	len;

    if (text)
#ifdef	HAS_MMAP
	munmap( text, len);
#else
	XtFree( text);
#endif

    /* At this point, we should already be in NEWSDIR */

    if (stat( items[n].name, &st) >= 0 &&
	(fd = open( items[n].name, O_RDONLY)) >= 0)
    {
	len = st.st_size + 1;
#ifdef	HAS_MMAP
	text = mmap( NULL, len, PROT_WRITE,
	    MAP_FILE | MAP_PRIVATE | MAP_VARIABLE, fd, 0);
	if (text == (char *) -1)
	    text = NULL;
#else
	text = XtMalloc( len);
	if (read( fd, text, len - 1) != len - 1)
	{
	    XtFree( text);
	    text = NULL;
	}
#endif
	else
	    text[len - (len >= 2 && text[len - 2] == '\n' ? 2 : 1)] = 0;
	close( fd);
    }
    else
	text = NULL;
    return text ? text : "";
}

/************************************************/
/* list_items					*/
/* Make a list of all news items of interest	*/
/************************************************/

static char *list_items( argc, argv)
int	argc;
char	**argv;
{
    int			i;
    char		*home;
    time_t		newstime;
    struct dirent	*de;
    struct stat		st;
    DIR			*d;
    char		fname[BUFSIZ];

    /* Get the .news_time timestamp for latest news */

    if (!all && !named)
    {
	if (!(home = getenv( "HOME")))
	    return "No home directory;\ncannot find .news_time";
	sprintf( fname, "%s/.news_time", home);
	newstime = stat( fname, &st) >= 0 ? st.st_mtime : 0;
    }

    /* Get the news items in NEWSDIR */

    if (chdir( NEWSDIR) < 0 || !(d = opendir( ".")))
	return "No news directory";
    while (de = readdir( d))
	if (stat( de->d_name, &st) >= 0 &&
	    (st.st_mode & S_IFMT) == S_IFREG)
	{
	    if (named)
	    {
		for (i = 1; i < argc; i++)
		    if (!strcmp( argv[i], de->d_name))
		    {
			add_item( de->d_name);
			break;
		    }
	    }
	    else if (all || st.st_mtime > newstime)
		add_item( de->d_name);
	}
    closedir( d);
    qsort( items, nitems, sizeof( item_t), sort_items);
    return NULL;
}

/************************************************************************/
/* sort_items								*/
/* Comparison function for qsort to sort news items oldest-newest	*/
/************************************************************************/

static int sort_items( a, b)
item_p	a, b;
{
    return a->time - b->time;
}
