/*
 * Copyright 1994 Enns/Moar
 */

/*
 * xcolor.c - Show all the pretty colors.
 */

// Include files required for all Toolkit programs
#include <X11/Intrinsic.h>		// Intrinsics Definitions 
#include <X11/Shell.h>

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>

#include "icon.h"
#include "init.h"
#include "types.h"

// Global vars
int rgb[3];
Widget list;

// An instance of the Colorlib class to sort and hold the contents of the
// file which contains the color definitions to be used in the pick list.
Colorlib colorlist;

int build_list(String color_path) {
    int i = 0;
    FILE *fp;
    char line[512], *name;
	colorstruct color;

    if ((fp = fopen(color_path, "r")) == NULL) {
        perror("fopen");
        exit(1);
        }

    while((fgets(line, sizeof(line)-1, fp)) != NULL) {
		if(line[0] == '!') continue;

        color.red   = atoi(strtok(line, " "));
        color.green = atoi(strtok(NULL, " "));
        color.blue  = atoi(strtok(NULL, "\t"));
        name = strtok(NULL, "\t");

		color.name = (String)malloc(strlen(name));
		strcpy(color.name, name);
		color.name[strlen(name)-1] = '\0';

		colorlist.add(color);
		i++;
        }

	fclose(fp);

	colorlist.sort();

	return i;
	}

main(int argc, char *argv[]) {

// variable declarations

	XtAppContext app_context;
	static XtActionsRec actions[] = { 
		{"ReturnAction", ReturnAction},
		};
	static XrmOptionDescRec options[] = { {"-geometry", ".geometry", XrmoptionSepArg, NULL}, };
	Widget topLevel;
	String color_path = NULL;
	int c;
	extern char *optarg;
	Pixmap icon_pixmap;
	
// Beginning of mainline

    topLevel = XtVaAppInitialize(
        &app_context,       // Application context
        "XRgb",           // Application class
        options, XtNumber(options),            // command line option list
        &argc, argv,        // command line args
        NULL,               // for missing app-defaults file
        NULL);              // terminate varargs list

	icon_pixmap = XCreateBitmapFromData(XtDisplay(topLevel), RootWindowOfScreen(XtScreen(topLevel)), icon_bits, icon_width, icon_height);
	XtVaSetValues(topLevel, XtNiconPixmap, icon_pixmap, NULL);

	while ((c = getopt(argc, argv, "f:")) != EOF)
        switch(c) {
            case 'f':
                color_path = optarg;
                break;
        }

	if (color_path == NULL) {
		color_path = (char *)malloc(strlen("/usr/X11R6/lib/X11/rgb.txt") + 1);
		sprintf(color_path, "/usr/X11R6/lib/X11/rgb.txt");
	}

	if (build_list(color_path) <= 0) {
		fprintf(stderr, "Color file contained no entries.\n");
		exit(1);
	}

    XtSetLanguageProc(NULL, NULL, NULL);

	Init(topLevel);

	XtAppAddActions(app_context, actions, XtNumber(actions));

	// Create windows for widgets and map them.
	XtRealizeWidget(topLevel);

	// Loop for events.
	XtAppMainLoop(app_context);
}

