#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include <sys/param.h>

#if defined(__FreeBSD__)
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#else
#include <malloc.h>
#endif

#if defined(SOLARIS2)
#include <netdb.h>
#include <string.h>
#endif

/* If this hasn't been set, then set it.  64 is the value on sunos 4.1.1
 * systems - hopefully, this is a sane value for other systems that
 * lack a definition
 */

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

/* Font is a nice small font. */
#define FONT "-adobe-times-medium-r-normal--10-100-75-75-p-54-iso8859-1"
#define	DEFAULT_SIZE	64	/* default width & height of the window */
#define	TEXT_WIDTH	60	/* How many pixels (width) is the minimum
				 * to display the text at the bottom.
				 * Number is sort of arbitrarily chosen.
				 * It must be less than DEFAULT_SIZE however.
				 */
#define PTSSCALELINE	5	/* If scale lines (by -scale arguement)
				 * are closer than this many pixels together,
				 * fewer scale lines are drawn.  If you always
				 * want scale lines drawn, even if they are
				 * right next to each other, set this to 0.
				 * If the lines would be within this range,
				 * -scale value is doubled, then quadrapuled,
				 * and so on until it it can be drawn properly.
				 */

#define CPU		0	/* % of cpu being used */
#define PACKETS		1	/* average number of incoming packets */
#define PAGE		2
#define SWAP		3
#define INT		4
#define DISK		5
#define CONTEXT		6
#define LOAD1		7	/* LOAD1, LOAD5 and LOAD15 need to be */
#define LOAD5		8	/* number consecutively. */
#define LOAD15		9
#define COLL		10
#define ERRORS		11
#define NUM_TYPES	11	/* should be the same as the last graph type
				 * above
				 */
#define INSIDE_BORDER_WIDTH	1	/* Default spacing between the
					 * edge of the window and the
					 * graphs, as well as how much
					 * space between windows in
					 * -split mode.
					 */
#define DOWNSCALE_OCCURANCE	30	/* How many ticks between each
					 * downscale attempt */
#define LOAD_FACTOR 100               /* internal representation of load is
				       * this many times bigger */

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

struct graph_info {
	int	scale,true_scale;	/* true_scale is the scale that would
					 * be used if this graph was not
					 * synced with another graph.
					 */
	int	link;			/* This points to the position in the
					 * graphs array that this graph is
					 * linked to.  If it points to its
					 * own position, it is not linked.
					 * linking means the graphs keep
					 * the same scale.
					 */
	unsigned char	type;
	unsigned long	color_pixel;
	char	name[MAXHOSTNAMELEN + 10];
	short	name_len;
	int	max_scale;
	int	min_scale;
	int	scale_mult;		/* How much to multiply the
					 * scale by for it to correspond
					 * to the point values.  This is used
					 * only for load to give good
					 * resolution.
					 */
	int	scale_lines;	/* Dashed horizontal lines.  will be
				 * drawn at the value this variable
				 * holds.  Ie, if this is 32, and the
				 * scale of the graph is 64, there will
				 * be 1 line in the center of the window.
				 * if the scale is 128, there will be
				 * 3 lines, equally spaced.
				 */
	int	running_avg;	/* use this as a guide for re-sizes */
	short	host_offset;
	short	window;		/* What window to put this graph in */
} *graphs;

struct Xss_Window {
	short	x, y;		/* Upper left corner of window */
	short	width,height;
	short	label_lines;	/* how many lines are needed to print out */
				/* the graph labels */
	short	num_graphs;	/* Number of graphs in this window */
	char	redraw_needed;	/* This window needs to be redrawn because
				 * of graph rescaling
				 */
	short	xpos;		/* Drawing position of this window */
};

extern struct Xss_Window **windows;

extern int	num_hosts,point_pos,num_graphs,**points,sleep_time,
	hide_labels,split_width, graph_spacing;
extern char	**hosts;

void set_first_values();
void set_values();
