.TH XSysStats 1 "August 26, 1993"
.br
.SH NAME
xsysstats - displays system statistics in a strip graph.
.SH SYNOPSIS
.B xsysstats -type \fItype\fR -geometry \fIgeometry\fR
-display \fIdisplay\fR
-name \fIname\fR -title \fItitle\fR
-border \fIvalue\fR
-background \fIcolor\fR -baseline \fIcolor\fR -color \fIcolor\fR 
-foreground \fIcolor\fR -host \fIhostname\fR -min \fImin\fR 
-max \fImax\fR -sample \fIsample_time\fR -allnames -samescale
-hidelabels -hidehosts -scale \fIvalue\fR -ruler \fIseconds\fR
-solid -showmax
-split\fIwidth\fRx\fIheight\fR -window \fInumber\fR
-defcolor \fIgraphtype color\fR
-wtitle \fIname\fR

.SH DESCRIPTION
XSysStats is a tool to show various system statistics.  It shows them in
the form of a strip graph in a window.

It can show multiple graphs in one window, and the graphs can be
detailing information about several machines.

At the bottom of the window, what graph types and their scale is displayed.
These are displayed in the color of the graph.

While XSysStats is running, graphs will be downscaled and upscaled
as require.  And upscale doubles the graph scale, and only occurs when
a new point is beyond the graph bounds.

Downscaling occurs when the running average falls below the scale, and
all points on the graph are less than half the present scale.  Downscaling
halves the scale of the graph.

Upscaling and Downscaling by default do not occur on graphs of cpu time.
Scaling can further be controlled by the -min and -max arguments.

A black and white display system will not likely be able to make much sense
of multiple graphs in the same window.  However, using the -split
option can be used to create several windows, each
detailing a different statistic.

.SH COMMAND LINE OPTIONS
Note: unlike many programs, the order the command line arguments are given
in is relevant.  The -host, -color, -min and -max operate on the last -type
argument given.  Also, at least one -type argument needs to
be supplied before -host, -color, -min or -max can be used, otherwise an
error will result.
.TP 8
-type \fItype\fR
This is the type of graph to display. The types are:

collisions: number of incoming ethernet collisions since last update

context: number of context switches per second

cpu: percentage of cpu time being used

scpu, ucpu, ncpu, icpu:  Displays percentage of system, user, and niced cpu
that is being used.  Note that \fBicpu\fR is the same as just \fBcpu\fR but
 that \fBicpu\fR is inverted - if the system is 80% idle, the graph will
show 20% use.

disk: number of disk transfers per second

errors: number of incoming ethernet errors since last update

interrupts: average number of device interrupts, per second

load1, load5, load15: The average number of jobs in the load queue for the
last 1, 5, and 15 minutes.

packets: number of incoming + outgoing ethernet packets per second

packetsi: number of incoming ethernet packets per second.  This was formerly
just known as 'packets'

packetso: number of outgoing ethernet packets per second

pagei: page ins since last update.  This was formally called just 'page'

apagei: average page ins per second.

pageo: page outs since last update

apageo: average page outs per second.

swap: swap ins and outs since last update

swapi: swap ins since last update.  This was formally just called 'swap'.

swapo: swap outs since last update.

Instead of just the type name, a host name can be appended to graph
information from that host (see -host below.)  Syntax would be
-type page@host to graph page information from 'host'.

Note: Unlike perfmeter, collisions, errors, page and swap are not
averaged over the sample time.  This is a personal preference on my part,
to be able to see the activity in these fields more clearly. For this
reason, the scale of these graphs may appear different than perfmeter
if the sample time is not one second.

Multiple graphs are selected by specifying multiple -type arguments.
The graphs are graphed in the order of the -type arguments.  This means
that the first -type graph given will be drawn first, and graphs
specified later will overwrite this graph data.  The graph
which you want to see most clearly should be the last -type argument.
.TP
-geometry \fIgeometry\fR
The geometry of the window.
.TP
-allnames
This forces the hostname for all hosts to be displayed along with the
graph type at the bottom of the window, including the localhost.
.TP
-display \fIdisplay\fR
what screen/system to display the window on.
.TP
-name \fIname\fR
Set the application resource name to \fIname\fR.  Default is the name of
the executable.
.TP
-title \fItitle\fR
Set the window manager title to \fItitle\fR.
.TP
-background \fIcolor\fR
background color of the window.
.TP
-baseline \fIcolor\fR
this tells XSysStats to draw a baseline of color \fIcolor\fR.  The baseline
is a zero line, the minimum value any graph can have.
.TP
-border \fIvlaue\fR
this sets border width between graphs (when using -split mode) as well
as spacing between graphs and the window edge.  By default, this value
is 1.  This is a global value, and can not be set on a graph by graph
bases.
.TP
-color \fIcolor\fR
this sets the color of the last graph specified with the -type argument.
.TP
-defclor \fIgraphtype color\fR
this sets the default color for all graphs of \fIgraphtype\fR to \fIcolor\fR.
This can be very useful for situation where you are displaying information for
many systems in -split mode.  The -color option can be used to override
individual graph colors.
.TP
-foreground \fIcolor\fR
this sets the default foreground color.  Any graphs that do not have a
-color argument specified will use this color instead.
.TP
-hidehosts
Don't show hostnames for any host when displaying labels.  Removes
clutter if all graphs are of the same host.
.TP
-hidelabels
Prevent all graph labels and scale from being drawn at the bottom of the screen.
Makes better use of space.  Limited use if you need to know the scale of
the graph and the graphs scale changes.  Certain keys can toggle the labels
on or off while running.  See the section below on KEYBOARD CONTROL
for more information.
.TP
-host \fIhost\fR
this specifies the host to report information on.  It applies to the last
-type argument given.  There is no checking done to see if this is a valid
host.  If no hosts exists with the \fIhost\fR name, then the graph for
which this host applied will not be graphed in any reasonable fashion.
This option is now obsolete, -type graph@host can now be used instead.
.TP
-min \fImin\fR
this is the minimum value the last graph specified by -type will downscale to.
.TP
-max \fImax\fR
this is the maximum value the graph specified by -type will scale to.
If points are beyond
this scale, they will be drawn out of bounds.

If both min and max are the same, the graph will never change scale.  By
default, most graphs have a min value of 2 and a very large max value.
The cpu graph is the one exception, both its min and max value is 100.
.TP
-ruler \fIseconds\fR
This causes XSysStats to draw a ruler below the graph and above the labels,
with a mark and a label every \fIseconds\fR seconds.  This is useful to
see how long ago an event happened.  The minimum value that is useful
with a 2 second sample time is about 30 seconds.  Depending on the width
and value of \fIseconds\fR, the left most value may have a digit or two
cut off.  This is togglable at run time by pressing 'r'.
.TP
-sample \fIsample_time\fR
This is how long the program sleeps between each update.  The minimum
value is 1.  By default, it is 2.
.TP
-samescale
Graphs of similar type will always have the same scale.  This can be useful
if the same -type is being used to graph information on multiple hosts.  It
allows for easy comparison of the graph data.
.TP
-scale \fIvalue\fR
Causes dotted horizontal scale lines every \fIvalue\fR points on the graph.
Thus, if \fIvalue\fR is 32 and the scale of the graph is 64, a dotted
line will be drawn in the middle of the window.  This operates on the
last -type argument given.  If scale lines become too close together
in the window, \fIvalue\fR will doubled until the lines are adequately
spread out.  The threshold value is about 5 pixels.  If two of these
lines would be drawn closer together than that, the doubling will
occur.  The value of the lines are not drawn anyplace in the window.
.TP
-solid
This causes the graphs to be drawn as solid lines (histograms) instead of
curves.  Thus, a line is drawn from the baseline to the present value.  Use
of this with multiple graphs in one window is not suggested, as they will be
drawn over each other.  I also recommend using the -baseline option in
conjunction with -solid.
.TP
-showmax
Shows the maximum value seen so far for each graph since xsysstats was
invoked.  The value is shown on the labels line (so if you have
-hidelabels set you won't see this value) next to the current scale; the
format is "\fIscale\fP/\fImax\fP".
.TP
-split \fIwidth\fRx\fIheight\fR
This splits the XSysStats display into several smaller windows for
graphing.  All of the windows will be the same size.  By using this
option, one XSysStats program can be used to graph many different things.
By default, if no -window options are used (see below), the graphs are
positioned from left to right, then top to bottom.  Thus, if the split
is 3x1, the first graph would be in the upper left, second in top center,
third in top right, fourth in bottom left, etc.  This needs to be
specified before any -type or -window options are given for it to work
properly.
.TP
-window \fIwindow\fR
This specifies the window to plot all the following graphs in.  If the
window has not been split (via -split), this options has no use.  Otherwise,
all following graphs specified will be plotted in the window specified until
another -window option is given.  The windows are numbers the same way
graphs are plotted above with -split - top left would be window 1, then next
on the top row would be 2, and so on.  If a window value of 0 is specified,
then windows will be plotted as was described in the -split command above -
from left to right, top to bottom, starting at the last window plotted before
a -window options was specified.
.TP
-wtitle \fItitle\fR
This sets up a default title for the bottom of the window.  This can be
useful if you are displaying multiple graph types but know what the colors
mean.

.SH X DEFAULTS
XSysStats does not support any standard resource values.  This is based
some on ease of programming and on usefulness of having resources.

It seems to me that very seldom will people want to have XSysStats run
with all the same resources more than once.  If X Defaults were supported,
then there would also need to be a way not to use them.

.SH KEYBOARD CONTROL
While XSysStats is running, the following keys will cause various
events to happen:
.TP
l,L
This will toggle through the label modes.  As of now, there are three modes -
None, in which case nothing is displayed.  Minimal, in which the window title
(if specified) and just the scale values are displayed, but the graph types are
not, and Normal, in which case graph types with scale is displayed.

-hidelabels sets the initial state to None, and -wtitle sets it to Minimal.
.TP
m,M
This will toggle display of maximum values on or off.  This is the same
behavior as the -showmax command line option.  Note that maximum values
aren't displayed unless labels are turned on (see above).
.TP
r,R
This will toggle the ruler on or off.  If -ruler was not specified
on the command line, a default value of 30 seconds will be used for the
ruler markings.
.TP
q,Q
If XSysStats was compiled with the KEYQUIT option, this will cause xsysstats
 to exit.  Otherwise, it does nothing.
.TP
C-l
(CTRL-L) Causes the window to redraw.


.SH BUGS
Valid host name checking should be done when the -host argument
is specified.

Timeouts of rstat on remote hosts will pretty much stop all the graphs.

.SH AUTHOR
Mark Wedel (mwedel@scruz.net)
