
/*************************************************
Xwmdialog Copyright (C)  charles vidal 05.1996
This source is free software; 
you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; 
See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*************************************************/

#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/cursorfont.h>
/* I got this function from the source of xwininfo 
 of  Mark Lillibridge, MIT Project Athena 
so , thank's to him
*/
Window Select_Window(dpy)
Display *dpy;
{
	int status;
	Cursor cursor;
	XEvent event;
	int screen =  DefaultScreen(dpy);
	Window target_win = None, root = RootWindow(dpy,screen);
	int buttons = 0;

	/* Make the target cursor */
	cursor = XCreateFontCursor(dpy, XC_crosshair);

	/* Grab the pointer using target cursor, letting it room all over */
	status = XGrabPointer(dpy, root, False,
	    ButtonPressMask|ButtonReleaseMask, GrabModeSync,
	    GrabModeAsync, root, cursor, CurrentTime);
	if (status != GrabSuccess) {
		printf("Can't grab the mouse.");
		return(root);
	}

	/* Let the user select a window... */
	while ((target_win == None) || (buttons != 0)) {
		/* allow one more event */
		XAllowEvents(dpy, SyncPointer, CurrentTime);
		XWindowEvent(dpy, root, ButtonPressMask|ButtonReleaseMask, &event);
		switch (event.type) {
		case ButtonPress:
			if (target_win == None) {
				target_win = event.xbutton.subwindow; /* window selected */
				if (target_win == None) target_win = root;
			}
			buttons++;
			break;
		case ButtonRelease:
			if (buttons > 0) /* there may have been some down before we started */
				buttons--;
			break;
		}
	}

	XUngrabPointer(dpy, CurrentTime);      /* Done with pointer */

	return(target_win);
}
