
/*************************************************
Xwmdialog Copyright (C)  charles vidal 05.1996
This source is free software; 
you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; 
See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*************************************************/

#include <stdio.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xproto.h>
#include <Xm/XmAll.h>
#include <stdio.h>
#include <sys/time.h>
#define MAXFEN 200
#define ICON 4
#define POP  5
#define UNMAP 6 
#define KILL 7
#define CHANGEICON 8
#define EXIT 9
#define CURSOR 10
#define GRAB 11


void downtree(Window top,Boolean all,Widget forD);


Display *display;
Window root;
int screen,tox,toy,towidth,toheight,warpx,warpy,toiconx,toicony;
Colormap cmap;
char **names;   /* -> argv list of names to avoid */
int numnames;
int keys[256];
static char *wmname;
static char *wmiconname;
static int nrows;
static int ncolumns;
static char *bitmapname;
static char *maskname;
Window window = 0;
char *displayname = 0;
XmString TabXmStr[MAXFEN];
int ID[MAXFEN];
static int fenetreSel=-1;

/* Widget */
Widget main_widget, ScrolledList0, PushButton0, PushButton1;
Widget PushButton2, PushButton3,PushButton4, PushButton5,PushButton6, PushButton7;
Widget PushButton9,PushButton8,PushButton10,PushButton11;
Widget PromptDialog0;
Widget WarningDialog1;
extern Affiche_curdialog(Window choi);
extern Setup_Dailog2(Widget father);
extern void AfficheDialogIcon(Window win);
extern Setup_Icon(Widget dady);
extern void AfficheDialog(Window win);
extern void Setup_Dialogcur();
extern Widget dialogcur;
/*Ressource string */
char *r_ScrolledList0[BUFSIZ];
char *r_PushButton0="Change";
char *r_PushButton1="Hide";
char *r_PromptDialog0="PATH/name(.PS|.EPS|.EPSI|.GIF|.PCX|.PICT|.PPM)";
int nb_window=0;
int WhatICanDo;

void ShowWarning(char *s)
{
	Arg args[3];
	XmString label_str;
	label_str=XmStringCreateSimple(s);
	XtSetArg(args[0],XmNmessageString,label_str);
	XtSetArg(args[1],XmNdialogTitle,label_str);
	XtSetValues(WarningDialog1, args, 2);
	XtManageChild(WarningDialog1);
}

/*----------------------------------------------------------*/
/* CallBack */

void  DoubleClickProc(Widget w,XtPointer closure,XtPointer call_data)
{
	int screen = DefaultScreen(display);
	XWindowAttributes a;
	XmListCallbackStruct *cb =  (XmListCallbackStruct *)call_data;
	fenetreSel=cb->item_position-1;
	XGetWindowAttributes(XtDisplay(w), ID[fenetreSel], &a);
	if (a.map_state==IsUnmapped)
	{
		XMapSubwindows(XtDisplay(w),ID[fenetreSel]);
		XMapRaised(XtDisplay(w),ID[fenetreSel]);
	}
	else 
		if (a.map_state==IsViewable)
		{
			if(XIconifyWindow(XtDisplay(w), ID[fenetreSel], screen)==0)
				pexit("iconify failed");
		}
}

/*----------------------------------------------------------*/
void f_ScrolledList0(Widget w,XtPointer client_data,XtPointer call_data)
{
	int i;
	int screen = DefaultScreen(display);
	char tmp2[200];
	i= (( XmListCallbackStruct *) call_data)->item_position-1;
	/*XSetInputFocus(XtDisplay(w),(Window) ID[i],RevertToNone,CurrentTime);*/
	/*XMapRaised(XtDisplay(w),ID[i]);
if(XIconifyWindow(display, ID[i], screen)==0)
   pexit("iconify failed");*/
	fenetreSel=i;
}
/*----------------------------------------------------------*/
int recherche_fenetre(Window w)
{
	int i;
	for (i=0;i<nb_window;i++)
		if (ID[i]==w) return i;
	return -1;
}
/*----------------------------------------------------------*/
void f_PushButton0(Widget w,XtPointer client_data,XtPointer call_data)
{
	Window grab_result;
	Arg args[5];
	int ac=0,resultat;
	char *name;
	XmString SelectedItems;
	int what = (int ) client_data;
	if (what==EXIT) {
		WhatICanDo=EXIT;
		ShowWarning("EXIT ???");
		return;
	}
	if (what==GRAB) {
		grab_result=Select_Window(XtDisplay(w));
		if (grab_result ) {
			Window root;
			int dummyi;
			unsigned int dummy;
			if (XGetGeometry (XtDisplay(w), grab_result, &root, &dummyi, &dummyi,
			    &dummy, &dummy, &dummy, &dummy) &&
			    grab_result != root)
				grab_result = XmuClientWindow (XtDisplay(w), grab_result);
		}
		resultat=recherche_fenetre(grab_result);
		if (resultat==-1) ShowWarning("Window not found into list");
		else {
			XmListSelectPos(ScrolledList0,resultat+1,0);
			XmListSetPos(ScrolledList0,resultat+1);
			fenetreSel=resultat;
		}
		return;
	}
	if (fenetreSel==-1 && (what==0 || what>=ICON)) return;
	switch (what) {
	case 0:
		AfficheDialog(ID[fenetreSel]);
		break;
	case 1:
		nb_window=0;
		downtree(root,False,w);
		ac=0;
		XtSetArg(args[ac],XmNitems, TabXmStr);
		ac++;
		XtSetArg(args[ac],XmNitemCount,nb_window);
		ac++;
		XtSetValues(ScrolledList0,args,ac);
		break;
	case 2:
		nb_window=0;
		downtree(root,True,w);
		ac=0;
		XtSetArg(args[ac],XmNitems, TabXmStr);
		ac++;
		XtSetArg(args[ac],XmNitemCount,nb_window);
		ac++;
		XtSetValues(ScrolledList0,args,ac);
		break;
	case 3:
		XtManageChild(PromptDialog0);
		break;
	case POP:
		XMapSubwindows(XtDisplay(w),ID[fenetreSel]);
		XMapRaised(XtDisplay(w),ID[fenetreSel]);
		break;
	case UNMAP:
		XUnmapWindow(XtDisplay(w),ID[fenetreSel]);
		break;
	case ICON:
		if(XIconifyWindow(XtDisplay(w), ID[fenetreSel], screen)==0)
			pexit("iconify failed");
		break;
	case KILL:
		WhatICanDo=KILL;
		ShowWarning("XKill ???");
		break;
	case CHANGEICON:
		AfficheDialogIcon(ID[fenetreSel]);
		break;
	case CURSOR:
		Affiche_curdialog(ID[fenetreSel]);
		break;
	case GRAB:
		break;
	default:
		fprintf(stderr,"error DEFAULT\n");
		break;

	}
}
/*----------------------------------------------------------*/
void f_PromptDialog0(Widget w,XtPointer client_data,XtPointer call_data)
{
	char *text;
	char tmp[BUFSIZ];
	XmSelectionBoxCallbackStruct *scb =
	    (XmSelectionBoxCallbackStruct *) call_data;
	XmStringGetLtoR(scb->value,  XmSTRING_DEFAULT_CHARSET, &text);
	/*******************************/
	/*** capture ecran          ****/
	/*******************************/
	sprintf(tmp,"xwpick  -window %d %s\n",ID[fenetreSel],text);
	XtUnmanageChild(w);
	system(tmp);
	XFree(text);
}

/*----------------------------------------------------------*/
void f_PushButton1(Widget w,XtPointer client_data,XtPointer call_data)
{
}

/*----------------------------------------------------------*/
void f_WarningDialog0(Widget w,XtPointer client_data,XtPointer call_data)
{
	char tmp[BUFSIZ];
	switch (WhatICanDo) {
	case KILL:
		sprintf(tmp,"xkill -id %d \n",ID[fenetreSel]);
		system(tmp);
		downtree(root,False,w);
		break;
	case EXIT:
		exit(0);
		break;
	}
}
/******************** end callback  *******************************/
char *progname;
pexit(str)char *str;
{
	fprintf(stderr,"%s: %s\n",progname,str);
	exit(1);
}

/*
 * find all windows below this and if name matches call doit on it
 */

void downtree(Window top,Boolean all,Widget forD)
{
	char tmp[BUFSIZ];
	Window *child, dummy;
	unsigned int children, i;
	XWindowAttributes a;
	char **cpp, *name;
	if (XQueryTree(XtDisplay(forD), top, &dummy, &dummy, &child, &children)==0)
		pexit("XQueryTree failed");
	for (i=0; i<children; i++)
		if(XFetchName (XtDisplay(forD), child[i], &name)){
			if (XGetWindowAttributes(XtDisplay(forD), child[i], &a) == 0)
				pexit("XGetWindowAttributes");
			strcpy(tmp,name);
			if (all) {
				if (a.map_state==IsUnviewable) strcat (tmp," IsUnViewable");
				if (a.map_state==IsUnmapped) strcat(tmp," IsUnmapped");
			}
			if (!all && a.map_state==IsViewable && a.map_state!=IsUnmapped &&  a.map_state!=IsUnviewable) {
				TabXmStr[nb_window]=XmStringCreate(tmp,XmSTRING_DEFAULT_CHARSET);
				ID[nb_window]=child[i];
				nb_window++;
			}
			else {
				if (all) {
					TabXmStr[nb_window]=XmStringCreate(tmp,XmSTRING_DEFAULT_CHARSET);
					ID[nb_window]=child[i];
					nb_window++;
				}
			}
			XFree(name);
		}
		else downtree(child[i],all,forD);  /* dont go down if found a name */
	if(child)XFree((char *)child);
}

/*----------------------------------------------------------*/
/* Setu Widget */
void Setup_Widget(Widget father)
{
	Arg args[15];
	int i,ac=0;
	XmString label_str,label_str2;
	Widget Frame;
	Widget RowF;
	/*XtSetArg(args[ac], XmNwidth, 320); ac++;
XtSetArg(args[ac],XmNheight, 291); ac++;
XtSetValues(father, args, ac);*/

	downtree(root,False,father);

	ac=0;
	XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_FORM); 
	ac++;
	XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); 
	ac++;
	XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); 
	ac++;
	Frame=XmCreateFrame(father,"Frame",args,ac);
	XtManageChild(Frame);

	XtSetArg(args[ac], XmNvisibleItemCount, 6); 
	ac++;
	XtSetArg(args[ac], XmNtopAttachment, XmATTACH_FORM); 
	ac++;
	XtSetArg(args[ac], XmNrightAttachment, XmATTACH_FORM); 
	ac++;
	XtSetArg(args[ac], XmNleftAttachment, XmATTACH_FORM); 
	ac++;
	XtSetArg(args[ac], XmNbottomAttachment, XmATTACH_WIDGET); 
	ac++;
	XtSetArg(args[ac], XmNbottomWidget, Frame); 
	ac++;

	XtSetArg(args[ac],XmNitems, TabXmStr);
	ac++;
	XtSetArg(args[ac],XmNitemCount,nb_window);
	ac++;
	ScrolledList0=XmCreateScrolledList(father,"ScrolledList0",args,ac);
	XtAddCallback(ScrolledList0,XmNbrowseSelectionCallback,f_ScrolledList0,NULL);
	XtAddCallback(ScrolledList0, XmNdefaultActionCallback, DoubleClickProc,NULL);
	XtManageChild(ScrolledList0);

	ac=0;
	XtSetArg (args[ac], XmNorientation, XmHORIZONTAL);
	ac++;
	XtSetArg (args[ac], XmNnumColumns, 3);
	ac++;
	XtSetArg (args[ac], XmNpacking, XmPACK_COLUMN);
	ac++;
	RowF=XmCreateRowColumn(Frame,"RowF",args,ac);
	XtManageChild(RowF);

	PushButton0=XmCreatePushButton(RowF,"Change",NULL,0);
	XtAddCallback(PushButton0,XmNactivateCallback,f_PushButton0,(XtPointer) 0);
	XtManageChild(PushButton0);

	PushButton1=XmCreatePushButton(RowF,"Check",NULL,0);
	XtAddCallback(PushButton1,XmNactivateCallback,f_PushButton0,(XtPointer) 1);
	XtManageChild(PushButton1);

	PushButton2=XmCreatePushButton(RowF,"CheckAll",NULL,0);
	XtAddCallback(PushButton2,XmNactivateCallback,f_PushButton0,(XtPointer) 2);
	XtManageChild(PushButton2);

	PushButton3=XmCreatePushButton(RowF,"Capture",NULL,0);
	XtAddCallback(PushButton3,XmNactivateCallback,f_PushButton0,(XtPointer) 3);
	XtManageChild(PushButton3);

	PushButton8=XmCreatePushButton(RowF,"changeIcon",NULL,0);
	XtAddCallback(PushButton8,XmNactivateCallback,f_PushButton0,(XtPointer) CHANGEICON);
	XtManageChild(PushButton8);

	PushButton10=XmCreatePushButton(RowF,"changeCursor",NULL,0);
	XtAddCallback(PushButton10,XmNactivateCallback,f_PushButton0,(XtPointer) CURSOR);
	XtManageChild(PushButton10);

	PushButton11=XmCreatePushButton(RowF,"GrabWindow",NULL,0);
	XtAddCallback(PushButton11,XmNactivateCallback,f_PushButton0,(XtPointer) GRAB);
	XtManageChild(PushButton11);

	PushButton4=XmCreatePushButton(RowF,"Iconify",NULL,0);
	XtAddCallback(PushButton4,XmNactivateCallback,f_PushButton0,(XtPointer) ICON);
	XtManageChild(PushButton4);

	PushButton5=XmCreatePushButton(RowF,"PopUp",NULL,0);
	XtAddCallback(PushButton5,XmNactivateCallback,f_PushButton0,(XtPointer) POP);
	XtManageChild(PushButton5);

	PushButton6=XmCreatePushButton(RowF,"UnMap",NULL,0);
	XtAddCallback(PushButton6,XmNactivateCallback,f_PushButton0,(XtPointer) UNMAP);
	XtManageChild(PushButton6);

	PushButton7=XmCreatePushButton(RowF,"Kill",NULL,0);
	XtAddCallback(PushButton7,XmNactivateCallback,f_PushButton0,(XtPointer) KILL);
	XtManageChild(PushButton7);

	PushButton9=XmCreatePushButton(RowF,"exit",NULL,0);
	XtAddCallback(PushButton9,XmNactivateCallback,f_PushButton0,(XtPointer) EXIT);
	XtManageChild(PushButton9);

	ac=0;
	label_str=XmStringCreate(r_PromptDialog0,XmSTRING_DEFAULT_CHARSET);
	XtSetArg(args[ac],XmNselectionLabelString, label_str); 
	ac++;
	label_str2=XmStringCreate("capture",XmSTRING_DEFAULT_CHARSET);
	XtSetArg(args[ac],XmNdialogTitle, label_str2); 
	ac++;
	PromptDialog0=XmCreatePromptDialog(main_widget,"PromptDialog0",args,ac);
	XtAddCallback(PromptDialog0,XmNokCallback,f_PromptDialog0,NULL);
	ac=0;
	WarningDialog1=XmCreateWarningDialog(main_widget,"WarningDialog1",args,ac);
	XtAddCallback(WarningDialog1,XmNokCallback,f_WarningDialog0,NULL);
}
main(int argc,char **argv)
{
	Widget form;
	main_widget = XtInitialize(argv[0],"test",NULL,0,&argc,argv);
	display = XOpenDisplay(displayname);
	if(display==0)pexit("could not open display");
	root = DefaultRootWindow(display);
	/*creation Widget */
	form=XmCreateForm(main_widget,"form",NULL,0);
	Setup_Widget(form);
	Setup_Dialogcur();
	Setup_Dialog2(main_widget);
	Setup_icon(main_widget);
	XtManageChild(form);
	XtRealizeWidget(main_widget);
	XtMainLoop();
}
