 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                   D   D  E      C      O   O  D   D  E                      % O %                   D   D  EEE    C      O   O  D   D  EEE                    % O %                   D   D  E      C      O   O  D   D  E                      % O %                   DDDD   EEEEE   CCCC   OOO   DDDD   EEEEE                  % O %                                                                             % O %                                                                             % O %                    Utility Routines to Read Image Formats                   % O %                                                                             % O %                                                                             % O %                             Software Design                                 % O %                               John Cristy                                   % O %                              January 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright 1997 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortious action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Functions in this library convert to and from `alien' image formats to the  %  MIFF image format.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "XWDFile.h" #include "plug-ins.h"    /*   Define declarations. */- #define LoadImageText  "  Loading image...  " & #define PrematureExit(message,image) \ { \ %   Warning(message,image->filename); \    DestroyImages(image); \    return((Image *) NULL); \  }    /*   Function prototypes. */ static Image$   *ReadMIFFImage(const ImageInfo *),#   *ReadPNMImage(const ImageInfo *), "   *ReadPSImage(const ImageInfo *),"   *ReadXCImage(const ImageInfo *);   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d A V S I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadAVSImage reads a AVS X image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadAVSImage routine is:  % % %      image=ReadAVSImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadAVSImage returns a pointer to the image after N %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadAVSImage(const ImageInfo *image_info)  {    typedef struct _AVSHeader    {      int        width,
       height;    } AVSHeader;     AVSHeader      avs_header;      Image      *image;   	   Quantum 	     blue, 
     green,     red;     register int     x,     y;     register RunlengthPacket     *q;      unsigned int     packets,     status;      unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read AVS image.    */J   status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),     image->file);    if (status == False)0     PrematureExit("Not a AVS image file",image);   do   {      /*!       Initialize image structure.      */$     image->columns=avs_header.width;"     image->rows=avs_header.height;     image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert AVS raster image to runlength-encoded packets.     */     q=image->pixels;     q->length=MaxRunlength; #     for (y=0; y < image->rows; y++)      { (       for (x=0; x < image->columns; x++)       { *         index=UpScale(fgetc(image->file));+         image->matte|=index != Transparent; (         red=UpScale(fgetc(image->file));*         green=UpScale(fgetc(image->file));)         blue=UpScale(fgetc(image->file)); J         if ((red == q->red) && (green == q->green) && (blue == q->blue) &&D             (index == q->index) && ((int) q->length < MaxRunlength))           q->length++;         else           { $             if (image->packets != 0)               q++;             image->packets++; *             if (image->packets == packets)               {                  packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket)); >                 if (image->pixels == (RunlengthPacket *) NULL)C                   PrematureExit("Unable to allocate memory",image); 1                 q=image->pixels+image->packets-1;                }              q->red=red;              q->green=green;              q->blue=blue;              q->index=index;              q->length=0;           }        } 3       ProgressMonitor(LoadImageText,y,image->rows);      } %     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); L     status=ReadData((char *) &avs_header,1,(unsigned int) sizeof(AVSHeader),       image->file);      if (status == True)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d B M P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadBMPImage reads a Microsoft Windows bitmap image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadBMPImage routine is:  % % %      image=ReadBMPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadBMPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadBMPImage(const ImageInfo *image_info)  {    typedef struct _BMPHeader    {      unsigned long        file_size;       unsigned short       reserved[2];       unsigned long        offset_bits,       size,        width,
       height;        unsigned short
       planes,        bit_count;       unsigned long        compression,       image_size,        x_pixels,        y_pixels,        number_colors,       colors_important;    } BMPHeader;     BMPHeader      bmp_header;      Image      *image;      long     start_position;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *bmp_data,     *bmp_pixels,     magick[12];      unsigned int     bytes_per_line,      image_size,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a BMP file.   */3   status=ReadData((char *) magick,1,2,image->file);    do   {      /*       Verify BMP identifier.     */(     start_position=ftell(image->file)-2;D     if ((status == False) || (strncmp((char *) magick,"BM",2) != 0))2       PrematureExit("Not a BMP image file",image);7     bmp_header.file_size=LSBFirstReadLong(image->file); :     bmp_header.reserved[0]=LSBFirstReadShort(image->file);:     bmp_header.reserved[1]=LSBFirstReadShort(image->file);9     bmp_header.offset_bits=LSBFirstReadLong(image->file); 2     bmp_header.size=LSBFirstReadLong(image->file);     if (bmp_header.size == 12)       { 
         /*           OS/2 BMP image file.
         */H         bmp_header.width=(unsigned long) LSBFirstReadShort(image->file);I         bmp_header.height=(unsigned long) LSBFirstReadShort(image->file); 9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);         bmp_header.x_pixels=0;         bmp_header.y_pixels=0;#         bmp_header.number_colors=0; !         bmp_header.compression=0;           bmp_header.image_size=0;       }      else       { 
         /*+           Microsoft Windows BMP image file. 
         */7         bmp_header.width=LSBFirstReadLong(image->file); 8         bmp_header.height=LSBFirstReadLong(image->file);9         bmp_header.planes=LSBFirstReadShort(image->file); <         bmp_header.bit_count=LSBFirstReadShort(image->file);=         bmp_header.compression=LSBFirstReadLong(image->file); <         bmp_header.image_size=LSBFirstReadLong(image->file);:         bmp_header.x_pixels=LSBFirstReadLong(image->file);:         bmp_header.y_pixels=LSBFirstReadLong(image->file);?         bmp_header.number_colors=LSBFirstReadLong(image->file); B         bmp_header.colors_important=LSBFirstReadLong(image->file);6         for (i=0; i < ((int) bmp_header.size-40); i++)$           (void) fgetc(image->file);       } "     if (bmp_header.bit_count < 24)       {          unsigned char            *bmp_colormap;           unsigned int           packet_size;  
         /*#           Read BMP raster colormap. 
         */!         image->class=PseudoClass; >         image->colors=(unsigned int) bmp_header.number_colors;         if (image->colors == 0) 2           image->colors=1 << bmp_header.bit_count;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));&         bmp_colormap=(unsigned char *)8           malloc(4*image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (bmp_colormap == (unsigned char *) NULL)) ;           PrematureExit("Unable to allocate memory",image);          packet_size=4;"         if (bmp_header.size == 12)           packet_size=3;H         (void) ReadData((char *) bmp_colormap,packet_size,image->colors,           image->file);          p=bmp_colormap; )         for (i=0; i < image->colors; i++) 	         { 0           image->colormap[i].blue=UpScale(*p++);1           image->colormap[i].green=UpScale(*p++); /           image->colormap[i].red=UpScale(*p++); $           if (bmp_header.size != 12)             p++;	         } $         free((char *) bmp_colormap);       }      /*       Read image data.     */H     while (ftell(image->file) < (start_position+bmp_header.offset_bits))        (void) fgetc(image->file);     image_size= J       ((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height;M     if ((bmp_header.image_size == 0) || (bmp_header.image_size > image_size)) '       bmp_header.image_size=image_size;      bmp_data=(unsigned char *):       malloc(bmp_header.image_size*sizeof(unsigned char));+     if (bmp_data == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image); M     (void) ReadData((char *) bmp_data,1,(unsigned int) bmp_header.image_size,        image->file);      bmp_pixels=bmp_data;$     if (bmp_header.compression != 0)       {          unsigned int           packets;  
         /*3           Convert run-length encoded raster pixels. 
         */         packets=(unsigned int)P           (((bmp_header.width*bmp_header.bit_count+31)/32)*4*bmp_header.height);(         if (bmp_header.compression == 2)           packets<<=1;K         bmp_pixels=(unsigned char *) malloc(packets*sizeof(unsigned char)); 1         if (bmp_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); 2         (void) BMPDecodeImage(bmp_data,bmp_pixels,P           (unsigned int) bmp_header.compression,(unsigned int) bmp_header.width,,           (unsigned int) bmp_header.height);(         if (bmp_header.compression == 2)#           bmp_header.bit_count<<=1;           free((char *) bmp_data);       }      /*!       Initialize image structure.      */3     image->columns=(unsigned int) bmp_header.width; 1     image->rows=(unsigned int) bmp_header.height; /     image->units=PixelsPerCentimeterResolution; 2     image->x_resolution=bmp_header.x_pixels/100.0;2     image->y_resolution=bmp_header.y_pixels/100.0;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert BMP raster image to runlength-encoded packets.     */C     bytes_per_line=((image->columns*bmp_header.bit_count+31)/32)*4; !     switch (bmp_header.bit_count)      { 
       case 1:        { 
         /*E           Convert bitmap scanline to runlength-encoded color packets. 
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 7           for (x=0; x < ((int) image->columns-7); x+=8)            { '             for (bit=0; bit < 8; bit++) 
             { <               q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);               q->length=0;               q++;
             }              p++;           } (           if ((image->columns % 8) != 0)
             { <               for (bit=0; bit < (image->columns % 8); bit++)               { >                 q->index=((*p) & (0x80 >> bit) ? 0x01 : 0x00);                 q->length=0;                 q++;               }                p++;
             } E           ProgressMonitor(LoadImageText,image->rows-y-1,image->rows); 	         }          SyncImage(image);          break;       } 
       case 4:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); 7           for (x=0; x < ((int) image->columns-1); x+=2)            { %             q->index=(*p >> 4) & 0xf;              q->length=0;             q++;              q->index=(*p) & 0xf;             q->length=0;             p++;             q++;           } (           if ((image->columns % 2) != 0)
             { '               q->index=(*p >> 4) & 0xf;                q->length=0;               q++;               p++;
             } E           ProgressMonitor(LoadImageText,image->rows-y-1,image->rows); 	         }          SyncImage(image);          break;       } 
       case 8:        { 
         /*J           Convert PseudoColor scanline to runlength-encoded color packets.
         */(         if (bmp_header.compression == 1)(           bytes_per_line=image->columns;*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } E           ProgressMonitor(LoadImageText,image->rows-y-1,image->rows); 	         }          SyncImage(image);          break;       }        case 24:       { 
         /*J           Convert DirectColor scanline to runlength-encoded color packets.
         */*         for (y=image->rows-1; y >= 0; y--)	         { 8           p=bmp_pixels+(image->rows-y-1)*bytes_per_line;-           q=image->pixels+(y*image->columns); ,           for (x=0; x < image->columns; x++)           {              q->index=0;              if (image->matte) %               q->index=UpScale(*p++); "             q->blue=UpScale(*p++);#             q->green=UpScale(*p++); !             q->red=UpScale(*p++);              q->length=0;             q++;           } E           ProgressMonitor(LoadImageText,image->rows-y-1,image->rows); 	         }          break;       }        default:4         PrematureExit("Not a BMP image file",image);     }      free((char *) bmp_pixels);     CompressImage(image);      /*       Proceed to next image.     */5     status=ReadData((char *) magick,1,2,image->file); C     if ((status == True) && (strncmp((char *) magick,"BM",2) == 0))        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } G   } while ((status == True) && (strncmp((char *) magick,"BM",2) == 0)); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d C G M I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Function ReadCGMImage reads a Computer Graphic Meta image file G %  and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % - %  The format of the ReadCGMImage routine is:  % % %      image=ReadCGMImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadCGMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadCGMImage(const ImageInfo *image_info)  {    char     filename[MaxTextExtent];     Image      *image,      *next_image,     *proxy_image;      /*     Allocate image structure.    */(   proxy_image=AllocateImage(image_info);$   if (proxy_image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   OpenImage(image_info,proxy_image,ReadBinaryType); )   if (proxy_image->file == (FILE *) NULL) 5     PrematureExit("Unable to open file",proxy_image);    CloseImage(proxy_image);   DestroyImage(proxy_image);   /*.     Use ralcgm to convert Macintosh CGM image.   *//   (void) strcpy(filename,image_info->filename); ;   (void) sprintf(image_info->filename,CGMCommand,filename);     image=ReadPSImage(image_info);   if (image == (Image *) NULL)     { =       Warning("CGM translation failed",image_info->filename);        return((Image *) NULL);      }    /*     Assign proper filename.    */   do   { ,     (void) strcpy(image->filename,filename);     next_image=image->next; %     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d C M Y K I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function ReadCMYKImage reads an image of raw cyan, magenta, yellow, andM %  black bytes and returns it.  It allocates the memory necessary for the new : %  Image structure and returns a pointer to the new image. % . %  The format of the ReadCMYKImage routine is: % & %      image=ReadCMYKImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadCMYKImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadCMYKImage(const ImageInfo *image_info) {    Image      *image;      int 
     count,     x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *scanline;     unsigned int
     black,	     cyan,      height,      magenta,     packet_size,     yellow, 
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; 
   x_offset=0; 
   y_offset=0;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height); 2   if (image_info->interlace != PartitionInterlace)     {        /*         Open image file.       */1       OpenImage(image_info,image,ReadBinaryType); '       if (image->file == (FILE *) NULL) 3         PrematureExit("Unable to open file",image);        for (i=0; i < x; i++) "         (void) fgetc(image->file);     }    /*#     Allocate memory for a scanline.    */$   packet_size=4*(QuantumDepth >> 3);M   scanline=(unsigned char *) malloc(packet_size*width*sizeof(unsigned char)); )   if (scanline == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);     if (image_info->subrange != 0)/     while (image->scene < image_info->subimage)      {        /*         Skip to next image.        */       image->scene++;         for (y=0; y < height; y++)I         (void) ReadData((char *) scanline,packet_size,width,image->file);      }    do   {      /*!       Initialize image structure.      */     image->columns=width;      image->rows=height; "     if (image_info->subrange == 0),       if (image_info->tile != (char *) NULL)C         (void) XParseGeometry(image_info->tile,&x_offset,&y_offset, (           &image->columns,&image->rows);.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*8       Convert raster image to runlength-encoded packets.     */"     switch (image_info->interlace)     {        case NoneInterlace:        default:       { 
         /*2           No interlacing:  CMYKCMYKCMYKCMYKCMYK...
         */$         for (y=0; y < y_offset; y++)K           (void) ReadData((char *) scanline,packet_size,width,image->file);          q=image->pixels;'         for (y=0; y < image->rows; y++) 	         { =           if ((y > 0) || (image->previous == (Image *) NULL)) M             (void) ReadData((char *) scanline,packet_size,width,image->file); *           p=scanline+packet_size*x_offset;,           for (x=0; x < image->columns; x++)           { "             ReadQuantum(q->red,p);$             ReadQuantum(q->green,p);#             ReadQuantum(q->blue,p); $             ReadQuantum(q->index,p);             q->length=0;             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }          break;       }        case LineInterlace:        { 
         /*M           Line interlacing:  CCC...MMM...YYY...KKK...CCC...MMM...YYY...KKK... 
         */&         packet_size=image->depth >> 3;$         for (y=0; y < y_offset; y++)K           (void) ReadData((char *) scanline,packet_size,width,image->file); '         for (y=0; y < image->rows; y++) 	         { =           if ((y > 0) || (image->previous == (Image *) NULL)) M             (void) ReadData((char *) scanline,packet_size,width,image->file); *           p=scanline+packet_size*x_offset;+           q=image->pixels+y*image->columns; ,           for (x=0; x < image->columns; x++)           { "             ReadQuantum(q->red,p);             q->length=0;             q++;           } K           (void) ReadData((char *) scanline,packet_size,width,image->file); *           p=scanline+packet_size*x_offset;+           q=image->pixels+y*image->columns; ,           for (x=0; x < image->columns; x++)           { $             ReadQuantum(q->green,p);             q++;           } K           (void) ReadData((char *) scanline,packet_size,width,image->file); *           p=scanline+packet_size*x_offset;+           q=image->pixels+y*image->columns; ,           for (x=0; x < image->columns; x++)           { #             ReadQuantum(q->blue,p);              q++;           } K           (void) ReadData((char *) scanline,packet_size,width,image->file); *           p=scanline+packet_size*x_offset;+           q=image->pixels+y*image->columns; ,           for (x=0; x < image->columns; x++)           { $             ReadQuantum(q->index,p);             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }          break;       }        case PlaneInterlace:       case PartitionInterlace:       { 
         /*B           Plane interlacing:  CCCCCC...MMMMMM...YYYYYY...KKKKKK...
         */8         if (image_info->interlace == PartitionInterlace)           { 3             AppendImageFormat("C",image->filename); 7             OpenImage(image_info,image,ReadBinaryType); -             if (image->file == (FILE *) NULL) 9               PrematureExit("Unable to open file",image);            } &         packet_size=image->depth >> 3;$         for (y=0; y < y_offset; y++)K           (void) ReadData((char *) scanline,packet_size,width,image->file);          i=0;         q=image->pixels;'         for (y=0; y < image->rows; y++) 	         { =           if ((y > 0) || (image->previous == (Image *) NULL)) M             (void) ReadData((char *) scanline,packet_size,width,image->file); *           p=scanline+packet_size*x_offset;,           for (x=0; x < image->columns; x++)           { "             ReadQuantum(q->red,p);             q->length=0;             q++;           } >           ProgressMonitor(LoadImageText,i++,image->rows << 2);	         } 8         if (image_info->interlace == PartitionInterlace)           {              CloseImage(image);3             AppendImageFormat("M",image->filename); 7             OpenImage(image_info,image,ReadBinaryType); -             if (image->file == (FILE *) NULL) 9               PrematureExit("Unable to open file",image);            }          q=image->pixels;0         for (y=0; y < (height-image->rows); y++)K           (void) ReadData((char *) scanline,packet_size,width,image->file); '         for (y=0; y < image->rows; y++) 	         { K           (void) ReadData((char *) scanline,packet_size,width,image->file); *           p=scanline+packet_size*x_offset;,           for (x=0; x < image->columns; x++)           { $             ReadQuantum(q->green,p);             q++;           } >           ProgressMonitor(LoadImageText,i++,image->rows << 2);	         } 8         if (image_info->interlace == PartitionInterlace)           {              CloseImage(image);3             AppendImageFormat("Y",image->filename); 7             OpenImage(image_info,image,ReadBinaryType); -             if (image->file == (FILE *) NULL) 9               PrematureExit("Unable to open file",image);            }          q=image->pixels;0         for (y=0; y < (height-image->rows); y++)K           (void) ReadData((char *) scanline,packet_size,width,image->file); '         for (y=0; y < image->rows; y++) 	         { K           (void) ReadData((char *) scanline,packet_size,width,image->file); *           p=scanline+packet_size*x_offset;,           for (x=0; x < image->columns; x++)           { #             ReadQuantum(q->blue,p);              q++;           } >           ProgressMonitor(LoadImageText,i++,image->rows << 2);	         } 8         if (image_info->interlace == PartitionInterlace)           {              CloseImage(image);3             AppendImageFormat("K",image->filename); 7             OpenImage(image_info,image,ReadBinaryType); -             if (image->file == (FILE *) NULL) 9               PrematureExit("Unable to open file",image);            }          q=image->pixels;0         for (y=0; y < (height-image->rows); y++)K           (void) ReadData((char *) scanline,packet_size,width,image->file); '         for (y=0; y < image->rows; y++) 	         { K           (void) ReadData((char *) scanline,packet_size,width,image->file); *           p=scanline+packet_size*x_offset;,           for (x=0; x < image->columns; x++)           { $             ReadQuantum(q->index,p);             q++;           } >           ProgressMonitor(LoadImageText,i++,image->rows << 2);	         } 8         if (image_info->interlace == PartitionInterlace)>           (void) strcpy(image->filename,image_info->filename);         break;       }      }      /*'       Transform image from CMYK to RGB.      */     q=image->pixels;#     for (y=0; y < image->rows; y++)      { (       for (x=0; x < image->columns; x++)       {          cyan=q->red;         magenta=q->green;          yellow=q->blue;          black=q->index; "         if ((cyan+black) > MaxRGB)           q->red=0;          else%           q->red=MaxRGB-(cyan+black); %         if ((magenta+black) > MaxRGB)            q->green=0;          else*           q->green=MaxRGB-(magenta+black);$         if ((yellow+black) > MaxRGB)           q->blue=0;         else(           q->blue=MaxRGB-(yellow+black);         q->index=0;          q->length=0;         q++;       }      }      CompressImage(image); "     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;     /*       Proceed to next image.     */D     count=ReadData((char *) scanline,packet_size,width,image->file);     if (count > 0)       { 
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (count > 0);+   while (image->previous != (Image *) NULL)      image=image->previous;   free((char *) scanline);   CloseImage(image);   return(image); }  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d D P S I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % P %  Function ReadDPSImage reads a Adobe Postscript image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadDPSImage routine is:  % % %      image=ReadDPSImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadDPSImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasDPS 7 static Image *ReadDPSImage(const ImageInfo *image_info)  { 	   Display 
     *display;      float      pixels_per_point;      Image      *image;      int 	     sans,      status,      x,     y;     Pixmap     pixmap;      register int     i;     register RunlengthPacket     *p;      register unsigned long
     pixel;     Screen     *screen;     XColor     *colors;     XImage     *dps_image;      XRectangle     bounding_box,      pixel_size;      XResourceInfo      resource_info;  
   XrmDatabase      resource_database;     XStandardColormap      *map_info;  
   XVisualInfo      *visual_info;      /*     Open X server connection.    */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     return((Image *) NULL);    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)      return((Image *) NULL);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);    /*     Allocate standard colormap.    */$   map_info=XAllocStandardColormap();-   if (map_info == (XStandardColormap *) NULL) M     Warning("Unable to create standard colormap","Memory allocation failed");    else     {        /*         Initialize visual info.        */*       resource_info.visual_type="default";C       visual_info=XBestVisualInfo(display,map_info,&resource_info); )       map_info->colormap=(Colormap) NULL;      } 1   if ((map_info == (XStandardColormap *) NULL) || ,       (visual_info == (XVisualInfo *) NULL))     {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*7     Create a pixmap the appropriate size for the image.    */6   screen=ScreenOfDisplay(display,visual_info->screen);.   pixels_per_point=XDPSPixelsPerPoint(screen);+   if (image_info->density != (char *) NULL)      {        float          x_resolution,          y_resolution;   	       int          count;  3       x_resolution=72.0*XDPSPixelsPerPoint(screen); L       count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2) "         y_resolution=x_resolution;;       pixels_per_point=Min(x_resolution,y_resolution)/72.0;      } F   status=XDPSCreatePixmapForEPSF((DPSContext) NULL,screen,image->file,K     visual_info->depth,pixels_per_point,&pixmap,&pixel_size,&bounding_box); L   if ((status == dps_status_failure) || (status == dps_status_no_extension))     {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*'     Rasterize the file into the pixmap.    */O   status=XDPSImageFileIntoDrawable((DPSContext) NULL,screen,pixmap,image->file, G     pixel_size.height,visual_info->depth,&bounding_box,-bounding_box.x, <     -bounding_box.y,pixels_per_point,True,False,True,&sans);#   if (status != dps_status_success)      {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*     Initialize DPS X image.    */L   dps_image=XGetImage(display,pixmap,0,0,pixel_size.width,pixel_size.height,     AllPlanes,ZPixmap);    XFreePixmap(display,pixmap);#   if (dps_image == (XImage *) NULL)      {        DestroyImage(image);F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    /*     Get the colormap colors.   */F   colors=(XColor *) malloc(visual_info->colormap_size*sizeof(XColor));    if (colors == (XColor *) NULL)     {        DestroyImage(image);       XDestroyImage(dps_image); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      } ,   if ((visual_info->class != DirectColor) &&(       (visual_info->class != TrueColor))2     for (i=0; i < visual_info->colormap_size; i++)     {        colors[i].pixel=i;       colors[i].pad=0;     }    else     {        unsigned long 
         blue,          blue_bit,          green,         green_bit,         red,         red_bit;         /*(         DirectColor or TrueColor visual.       */       red=0;       green=0;
       blue=0; C       red_bit=visual_info->red_mask & (~(visual_info->red_mask)+1); I       green_bit=visual_info->green_mask & (~(visual_info->green_mask)+1); F       blue_bit=visual_info->blue_mask & (~(visual_info->blue_mask)+1);4       for (i=0; i < visual_info->colormap_size; i++)       { +         colors[i].pixel=red | green | blue;          colors[i].pad=0;         red+=red_bit; (         if (red > visual_info->red_mask)           red=0;         green+=green_bit; ,         if (green > visual_info->green_mask)           green=0;         blue+=blue_bit; *         if (blue > visual_info->blue_mask)           blue=0;        }      } L   XQueryColors(display,XDefaultColormap(display,visual_info->screen),colors,      visual_info->colormap_size);   /*#     Convert X image to MIFF format.    */*   if ((visual_info->class != TrueColor) &&*       (visual_info->class != DirectColor))     image->class=PseudoClass; "   image->columns=dps_image->width;    image->rows=dps_image->height;,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)     {        DestroyImage(image);       free((char *) colors);       XDestroyImage(dps_image); F       XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,B         (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);       return((Image *) NULL);      }    p=image->pixels;   switch (image->class)    {      case DirectClass:      default:     {        register unsigned long         color,         index;         unsigned long          blue_mask,         blue_shift,          green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */%       red_mask=visual_info->red_mask;        red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;          red_shift++;       } )       green_mask=visual_info->green_mask;        green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;          green_shift++;       } '       blue_mask=visual_info->blue_mask;        blue_shift=0; %       while ((blue_mask & 0x01) == 0)        {          blue_mask>>=1;         blue_shift++;        }        /*/         Convert X image to DirectClass packets.        */-       if ((visual_info->colormap_size > 0) && .           (visual_info->class == DirectColor))'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { +             pixel=XGetPixel(dps_image,x,y); 2             index=(pixel >> red_shift) & red_mask;1             p->red=XDownScale(colors[index].red); 6             index=(pixel >> green_shift) & green_mask;5             p->green=XDownScale(colors[index].green); 4             index=(pixel >> blue_shift) & blue_mask;3             p->blue=XDownScale(colors[index].blue);              p->index=0;              p->length=0;             p++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         } 
       else'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { +             pixel=XGetPixel(dps_image,x,y); 2             color=(pixel >> red_shift) & red_mask;7             p->red=XDownScale((color*65535L)/red_mask); 6             color=(pixel >> green_shift) & green_mask;;             p->green=XDownScale((color*65535L)/green_mask); 4             color=(pixel >> blue_shift) & blue_mask;9             p->blue=XDownScale((color*65535L)/blue_mask);              p->index=0;              p->length=0;             p++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }        break;     }      case PseudoClass:      {        /*         Create colormap.       *//       image->colors=visual_info->colormap_size; P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)	         {            DestroyImage(image);            free((char *) colors);#           XDestroyImage(dps_image); J           XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,F             (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);!           return((Image *) NULL); 	         } '       for (i=0; i < image->colors; i++)        { G         image->colormap[colors[i].pixel].red=XDownScale(colors[i].red); K         image->colormap[colors[i].pixel].green=XDownScale(colors[i].green); I         image->colormap[colors[i].pixel].blue=XDownScale(colors[i].blue);        }        /*/         Convert X image to PseudoClass packets.        */%       for (y=0; y < image->rows; y++)        { *         for (x=0; x < image->columns; x++)	         { =           p->index=(unsigned short) XGetPixel(dps_image,x,y);            p->length=0;           p++;	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }        SyncImage(image);        break;     }    } "   if (image->class == PseudoClass)     CompressColormap(image);   free((char *) colors);   XDestroyImage(dps_image);    /*     Rasterize matte image.   */H   status=XDPSCreatePixmapForEPSF((DPSContext) NULL,screen,image->file,1,8     pixels_per_point,&pixmap,&pixel_size,&bounding_box);L   if ((status != dps_status_failure) && (status != dps_status_no_extension))     { G       status=XDPSImageFileIntoDrawable((DPSContext) NULL,screen,pixmap, F         image->file,pixel_size.height,1,&bounding_box,-bounding_box.x,?         -bounding_box.y,pixels_per_point,True,True,True,&sans); '       if (status == dps_status_success) 	         {            XImage             *matte_image;              /*#             Initialize image matte.            */D           matte_image=XGetImage(display,pixmap,0,0,pixel_size.width,1             pixel_size.height,AllPlanes,ZPixmap); &           XFreePixmap(display,pixmap);-           if (matte_image != (XImage *) NULL) 
             { '               image->class=DirectClass;                 image->matte=True;               p=image->pixels;-               for (y=0; y < image->rows; y++) 2                 for (x=0; x < image->columns; x++)                 { "                   p->index=Opaque;2                   if (!XGetPixel(matte_image,x,y)))                     p->index=Transparent;                    p++;                 } )               XDestroyImage(matte_image); 
             } 	         }      }    /*     Free resources.    */B   XFreeResources(display,visual_info,map_info,(XPixelInfo *) NULL,>     (XFontStruct *) NULL,&resource_info,(XWindowInfo *) NULL);   CompressImage(image);    CloseImage(image);   return(image); }  #else 7 static Image *ReadDPSImage(const ImageInfo *image_info)  { 9   Warning("Cannot read DPS images",image_info->filename);    return((Image *) NULL);  }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d F A X I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadFAXImage reads a Group 3 FAX image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadFAXImage routine is:  % % %      image=ReadFAXImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadFAXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadFAXImage(const ImageInfo *image_info)  {    Image      *image;      int      x,     y;     unsigned int     height,      status, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */
   width=2592;    height=3508;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Initialize image structure.    */   image->class=PseudoClass;    image->columns=width;    image->rows=height; <   image->packets=Max((image->columns*image->rows+8) >> 4,1);#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Monochrome colormap.   */    image->colormap[0].red=MaxRGB;"   image->colormap[0].green=MaxRGB;!   image->colormap[0].blue=MaxRGB;    image->colormap[1].red=0;    image->colormap[1].green=0;    image->colormap[1].blue=0;#   status=HuffmanDecodeImage(image);    if (status == False)5     PrematureExit("Unable to read image data",image);    CloseImage(image);-   TransformImage(&image,"0x0",(char *) NULL);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d F I T S I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadFITSImage reads a FITS image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadFITSImage routine is: % & %      image=ReadFITSImage(image_info) % + %  A description of each parameter follows:  % I %    o image: Function ReadFITSImage returns a pointer to the image after O %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.  %  %  */8 static Image *ReadFITSImage(const ImageInfo *image_info) {    typedef struct _FITSHeader   {      unsigned int
       simple;        int        bits_per_pixel;        unsigned int       number_of_axis,        columns,       rows,        depth;  
     double       min_data,        max_data,        zero,        scale;   } FITSHeader;      char     long_quantum[8],     keyword[MaxTextExtent],      value[MaxTextExtent];      double
     pixel,
     scale,     scaled_pixel;      FITSHeader     fits_header;     Image      *image;      int      j,     packet_size,     y;     long
     count,     quantum;     register int     c,     i,     x;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *fits_pixels;      unsigned int     status,      value_expected;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image header.   */   fits_header.simple=False;    fits_header.bits_per_pixel=8;    fits_header.columns=1;   fits_header.rows=1;    fits_header.depth=1;   fits_header.min_data=0.0;    fits_header.max_data=0.0;    fits_header.zero=0.0;    fits_header.scale=1.0;   /*     Decode image header.   */   c=fgetc(image->file); 
   count=1;   if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      } 
   for ( ; ; )    {      if (!isalnum(c))       {          c=fgetc(image->file);          count++;       }      else       {          register char 
           *p;   
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         { .           if ((p-keyword) < (MaxTextExtent-1))             *p++=(char) c;           c=fgetc(image->file);            count++;+         } while (isalnum(c) || (c == '_'));          *p='\0';'         if (strcmp(keyword,"END") == 0)            break;         value_expected=False; (         while (isspace(c) || (c == '='))	         {            if (c == '=')               value_expected=True;           c=fgetc(image->file);            count++;	         } $         if (value_expected == False)           continue;          p=value;D         while (isalnum(c) || (c == '-') || (c == '+') || (c == '.'))	         { ,           if ((p-value) < (MaxTextExtent-1))             *p++=(char) c;           c=fgetc(image->file);            count++;	         }          *p='\0';
         /*2           Assign a value to the specified keyword.
         */*         if (strcmp(keyword,"SIMPLE") == 0)@           fits_header.simple=(*value == 'T') || (*value == 't');*         if (strcmp(keyword,"BITPIX") == 0)@           fits_header.bits_per_pixel=(unsigned int) atoi(value);)         if (strcmp(keyword,"NAXIS") == 0) @           fits_header.number_of_axis=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS1") == 0)9           fits_header.columns=(unsigned int) atoi(value); *         if (strcmp(keyword,"NAXIS2") == 0)6           fits_header.rows=(unsigned int) atoi(value);*         if (strcmp(keyword,"NAXIS3") == 0)7           fits_header.depth=(unsigned int) atoi(value); +         if (strcmp(keyword,"DATAMAX") == 0) +           fits_header.max_data=atof(value); +         if (strcmp(keyword,"DATAMIN") == 0) +           fits_header.min_data=atof(value); )         if (strcmp(keyword,"BZERO") == 0) '           fits_header.zero=atof(value); *         if (strcmp(keyword,"BSCALE") == 0)(           fits_header.scale=atof(value);       }      while (isspace(c))     {        c=fgetc(image->file);        count++;     }    }    while (count > 2880)     count-=2880;    for ( ; count < 2880; count++)     (void) fgetc(image->file);   /*6     Verify that required image information is defined.   */B   if ((!fits_header.simple) || (fits_header.number_of_axis < 1) ||)       (fits_header.number_of_axis > 4) || 2       (fits_header.columns*fits_header.rows) == 0)4     PrematureExit("image type not supported",image);   /*     Create linear colormap.    */%   image->columns=fits_header.columns;    image->rows=fits_header.rows;    image->class=PseudoClass;    image->colors=MaxRGB+1; L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)/     PrematureExit("Unable to open file",image); #   for (i=0; i < image->colors; i++)    { 0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);    }    /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); +   packet_size=fits_header.bits_per_pixel/8;    if (packet_size < 0)     packet_size=(-packet_size);    fits_pixels=(unsigned char *) =     malloc(image->packets*packet_size*sizeof(unsigned char)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||.       (fits_pixels == (unsigned char *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*5     Convert FITS pixels to runlength-encoded packets.    */B   status=ReadData((char *) fits_pixels,(unsigned int) packet_size,      image->packets,image->file);   if (status == False)?     Warning("Insufficient image data in file",image->filename); E   if ((fits_header.min_data == 0.0) && (fits_header.max_data == 0.0))      {        /*0         Determine minimum and maximum intensity.       */       p=fits_pixels;       long_quantum[0]=(*p);        quantum=(*p++); )       for (j=0; j < (packet_size-1); j++)        {          long_quantum[j+1]=(*p); (         quantum=(quantum << 8) | (*p++);       }        pixel=(double) quantum; ,       if (fits_header.bits_per_pixel == -32)/         pixel=(double) (*((float *) &quantum)); ,       if (fits_header.bits_per_pixel == -64)4         pixel=(double) (*((double *) long_quantum));D       fits_header.min_data=pixel*fits_header.scale+fits_header.zero;D       fits_header.max_data=pixel*fits_header.scale+fits_header.zero;(       for (i=1; i < image->packets; i++)       {          long_quantum[0]=(*p);          quantum=(*p++); +         for (j=0; j < (packet_size-1); j++) 	         { !           long_quantum[j+1]=(*p); *           quantum=(quantum << 8) | (*p++);	         }          pixel=(double) quantum; .         if (fits_header.bits_per_pixel == -32)1           pixel=(double) (*((float *) &quantum)); .         if (fits_header.bits_per_pixel == -64)6           pixel=(double) (*((double *) long_quantum));>         scaled_pixel=pixel*fits_header.scale+fits_header.zero;0         if (scaled_pixel < fits_header.min_data),           fits_header.min_data=scaled_pixel;0         if (scaled_pixel > fits_header.max_data),           fits_header.max_data=scaled_pixel;       }      }    /*5     Convert FITS pixels to runlength-encoded packets.    */   scale=1.0;3   if (fits_header.min_data != fits_header.max_data) A     scale=(MaxRGB+1)/(fits_header.max_data-fits_header.min_data);    p=fits_pixels;   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     {        long_quantum[0]=(*p);        quantum=(*p++); )       for (j=0; j < (packet_size-1); j++)        {          long_quantum[j+1]=(*p); (         quantum=(quantum << 8) | (*p++);       }        pixel=(double) quantum; ,       if (fits_header.bits_per_pixel == -32)/         pixel=(double) (*((float *) &quantum)); ,       if (fits_header.bits_per_pixel == -64)4         pixel=(double) (*((double *) long_quantum));       scaled_pixel=scale* H         (pixel*fits_header.scale+fits_header.zero-fits_header.min_data);       while (scaled_pixel < 0)!         scaled_pixel+=(MaxRGB+1); #       while (scaled_pixel > MaxRGB) !         scaled_pixel-=(MaxRGB+1); -       q->index=(unsigned short) scaled_pixel;        q->length=0;
       q++;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    free((char *) fits_pixels);    SyncImage(image);    CompressColormap(image);   CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G I F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGIFImage reads a Compuserve Graphics image file and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % - %  The format of the ReadGIFImage routine is:  % % %      image=ReadGIFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadGIFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or %      an error occurs.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */1 static Image *ReadGIFImage(ImageInfo *image_info)  { 5 #define BitSet(byte,bit)  (((byte) & (bit)) == (bit)) . #define LSBFirstOrder(x,y)  (((y) << 8) | (x))     char     *comments,     geometry[MaxTextExtent];     Image      *image;      int      status,      x,     y;     RectangleInfo      page_info;     register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      short int      transparency_index;      unsigned char      background,      c,	     flag,      *global_colormap,      header[MaxTextExtent],     magick[12];      unsigned int
     delay,     dispose,     global_colors,     image_count,     iterations;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*$     Determine if this is a GIF file.   */3   status=ReadData((char *) magick,1,6,image->file); H   if ((status == False) || ((strncmp((char *) magick,"GIF87",5) != 0) &&1       (strncmp((char *) magick,"GIF89",5) != 0))) 0     PrematureExit("Not a GIF image file",image);   global_colors=0;)   global_colormap=(unsigned char *) NULL; 1   page_info.width=LSBFirstReadShort(image->file); 2   page_info.height=LSBFirstReadShort(image->file);2   (void) ReadData((char *) &flag,1,1,image->file);8   (void) ReadData((char *) &background,1,1,image->file);?   (void) ReadData((char *) &c,1,1,image->file);  /* reserved */    if (BitSet(flag,0x80))     {        /*         Read global colormap.        */+       global_colors=1 << ((flag & 0x07)+1); '       global_colormap=(unsigned char *) 6         malloc(3*global_colors*sizeof(unsigned char));4       if (global_colormap == (unsigned char *) NULL)B         PrematureExit("Unable to read image colormap file",image);L       (void) ReadData((char *) global_colormap,3,global_colors,image->file);     }    comments=(char *) NULL; 
   delay=0;   dispose=0;   iterations=1;    transparency_index=(-1);   image_count=0;
   for ( ; ; )    { 1     status=ReadData((char *) &c,1,1,image->file);      if (status == False)       break;     if (c == ';')        break;  /* terminator */     if (c == '!')        { 
         /*           GIF Extension block.
         */5         status=ReadData((char *) &c,1,1,image->file);          if (status == False)@           PrematureExit("Unable to read extention block",image);         switch (c)	         {            case 0xf9:           {              /*.               Read Graphics Control extension.             */C             while (ReadDataBlock((char *) header,image->file) > 0); #             dispose=header[0] >> 2; /             delay=(header[2] << 8) | header[1]; (             if ((header[0] & 0x01) == 1)+               transparency_index=header[3];              break;           }            case 0xfe:           {              int                length;                /*%               Read Comment extension.              */             for ( ; ; ) 
             { @               length=ReadDataBlock((char *) header,image->file);               if (length <= 0)                 break;,               if (comments != (char *) NULL)<                 comments=(char *) realloc((char *) comments,<                   (Extent(comments)+length+1)*sizeof(char));               else                 { D                   comments=(char *) malloc((length+1)*sizeof(char));0                   if (comments != (char *) NULL)#                     *comments='\0';                  } ,               if (comments == (char *) NULL)A                 PrematureExit("Unable to allocate memory",image); "               header[length]='\0';6               (void) strcat(comments,(char *) header);
             }              break;           }            case 0xff:           {              /*+               Read Netscape Loop extension.              */C             while (ReadDataBlock((char *) header,image->file) > 0); 4             iterations=(header[2] << 8) | header[1];             break;           }            default:           { C             while (ReadDataBlock((char *) header,image->file) > 0);              break;           } 	         }        }      if (c != ',')        continue;      if (image_count != 0)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }      image_count++;     /*       Read image attributes.     */     image->class=PseudoClass; /     page_info.x=LSBFirstReadShort(image->file); /     page_info.y=LSBFirstReadShort(image->file); 2     image->columns=LSBFirstReadShort(image->file);/     image->rows=LSBFirstReadShort(image->file); .     image->packets=image->columns*image->rows;     if (image->packets == 0)-       PrematureExit("image size is 0",image);      /*       Allocate image.      */2     if (image->pixels != (RunlengthPacket *) NULL)#       free((char *) image->pixels); %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      image->comments=comments;      comments=(char *) NULL; K     (void) sprintf(geometry,"%ux%u%+d%+d",page_info.width,page_info.height,        page_info.x,page_info.y); -     image->page=PostscriptGeometry(geometry);      image->dispose=dispose;      dispose=0;     image->delay=delay;      delay=0;!     image->iterations=iterations;      iterations=1;      /*       Inititialize colormap.     */4     (void) ReadData((char *) &flag,1,1,image->file);H     image->interlace=BitSet(flag,0x40) ? PlaneInterlace : NoneInterlace;N     image->colors=!BitSet(flag,0x80) ? global_colors : 1 << ((flag & 0x07)+1);N     image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));0     if (image->colormap == (ColorPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      if (!BitSet(flag,0x80))        { 
         /*           Use global colormap.
         */         p=global_colormap;)         for (i=0; i < image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         } <         image->background_color=image->colormap[background];       }      else       {          unsigned char            *colormap;  
         /*           Read local colormap.
         */"         colormap=(unsigned char *)8           malloc(3*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); G         (void) ReadData((char *) colormap,3,image->colors,image->file);          p=colormap; )         for (i=0; i < image->colors; i++) 	         { /           image->colormap[i].red=UpScale(*p++); 1           image->colormap[i].green=UpScale(*p++); 0           image->colormap[i].blue=UpScale(*p++);	         }           free((char *) colormap);       }      /*       Decode image.      */!     status=GIFDecodeImage(image); *     if (image->interlace != NoneInterlace)       { 
         Image            *interlaced_image;           int            pass;             register RunlengthPacket
           *p;            static int-           interlace_rate[4] = { 8, 8, 4, 2 }, .           interlace_start[4] = { 0, 4, 2, 1 };  
         /*           Interlace image.
         */,         image_info->interlace=LineInterlace;         image->orphan=True; J         interlaced_image=CopyImage(image,image->columns,image->rows,True);         image->orphan=False;/         if (interlaced_image == (Image *) NULL) ;           PrematureExit("Unable to allocate memory",image); #         p=interlaced_image->pixels;          q=image->pixels;&         for (pass=0; pass < 4; pass++)	         { "           y=interlace_start[pass];!           while (y < image->rows)            { /             q=image->pixels+(y*image->columns); .             for (x=0; x < image->columns; x++)
             {                *q=(*p);               p++;               q++;
             } $             y+=interlace_rate[pass];           } 	         } '         DestroyImage(interlaced_image);        }       if (transparency_index >= 0)       { 
         /*           Create matte channel. 
         */         q=image->pixels;*         for (i=0; i < image->packets; i++)	         { >           if (q->index != (unsigned short) transparency_index)             q->index=Opaque;           else!             q->index=Transparent;            q++;	         }           transparency_index=(-1);!         image->class=DirectClass;          image->matte=True;       }      if (status == False)       { 5         Warning("Corrupt GIF image",image->filename);          break;       }      CompressImage(image); "     if (image_info->subrange != 0)2       if ((image->scene+1) < image_info->subimage)	         {            Image              subimage;              /*             Destroy image.           */           subimage=(*image);$           image->file=(FILE *) NULL;           DestroyImage(image);*           image=AllocateImage(image_info);&           if (image == (Image *) NULL)#             return((Image *) NULL); $           image->file=subimage.file;(           image->scene=subimage.scene+1;           image_count=0;	         } 
       elseN         if ((image->scene+1) >= (image_info->subimage+image_info->subrange-1))           break;   } 0   if (global_colormap != (unsigned char *) NULL)#     free((char *) global_colormap); 0   if (image->pixels == (RunlengthPacket *) NULL)C     PrematureExit("Corrupt GIF image or subimage not found",image); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G R A D A T I O N I m a g e                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function ReadGRADATIONImage creates a gradation image and initializes it toK %  the X server color range as specified by the filename.  It allocates the L %  memory necessary for the new Image structure and returns a pointer to the
 %  new image.  % 3 %  The format of the ReadGRADATIONImage routine is:  % + %      image=ReadGRADATIONImage(image_info)  % + %  A description of each parameter follows:  % O %    o image:  Function ReadGRADATIONImage returns a pointer to the image after L %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */= static Image *ReadGRADATIONImage(const ImageInfo *image_info)  {    char     colorname[MaxTextExtent];      double     brightness,      brightness_step,     hue,
     hue_step,      saturation,      saturation_step;     Image      *image;      int      x,     y;     register RunlengthPacket     *q;      unsigned int     height, 
     width;     XColor
     color;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Initialize Image structure.    */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*5     Determine (Hue, Saturation, Brightness) gradient.    */0   (void) strcpy(colorname,image_info->filename);8   (void) sscanf(image_info->filename,"%[^-]",colorname);/   (void) XQueryColorDatabase(colorname,&color); =   TransformHSL(XDownScale(color.red),XDownScale(color.green), 9     XDownScale(color.blue),&hue,&saturation,&brightness); #   (void) strcpy(colorname,"white");    if (Intensity(color) > 32767) %     (void) strcpy(colorname,"black"); <   (void) sscanf(image_info->filename,"%*[^-]-%s",colorname);/   (void) XQueryColorDatabase(colorname,&color); =   TransformHSL(XDownScale(color.red),XDownScale(color.green), H     XDownScale(color.blue),&hue_step,&saturation_step,&brightness_step);2   hue_step=(hue_step-hue)/(double) image->packets;G   saturation_step=(saturation_step-saturation)/(double) image->packets; G   brightness_step=(brightness_step-brightness)/(double) image->packets;    /*     Initialize image pixels.   */   q=image->pixels;!   for (y=0; y < image->rows; y++)    { &     for (x=0; x < image->columns; x++)     { I       HSLTransform(hue,saturation,brightness,&q->red,&q->green,&q->blue);        q->index=0;        q->length=0;
       q++;       hue+=hue_step;"       saturation+=saturation_step;"       brightness+=brightness_step;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    CompressImage(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d G R A Y I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadGRAYImage reads an image of raw grayscale bytes and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % . %  The format of the ReadGRAYImage routine is: % & %      image=ReadGRAYImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadGRAYImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadGRAYImage(const ImageInfo *image_info) {    Image      *image;      int 
     count,     x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *scanline;     unsigned int     height,      packet_size,     packets,
     width;     unsigned short
     index,
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; 
   x_offset=0; 
   y_offset=0; (   if (image_info->size != (char *) NULL)     { 
       x=0;C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height);        for (i=0; i < x; i++) "         (void) fgetc(image->file);     }    /*#     Allocate memory for a scanline.    */    packet_size=image->depth >> 3;M   scanline=(unsigned char *) malloc(packet_size*width*sizeof(unsigned char)); )   if (scanline == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image);     if (image_info->subrange != 0)/     while (image->scene < image_info->subimage)      {        /*         Skip to next image.        */       image->scene++;         for (y=0; y < height; y++)I         (void) ReadData((char *) scanline,packet_size,width,image->file);      }    do   {      /*!       Initialize image structure.      */     image->columns=width;      image->rows=height; "     if (image_info->subrange == 0),       if (image_info->tile != (char *) NULL)C         (void) XParseGeometry(image_info->tile,&x_offset,&y_offset, (           &image->columns,&image->rows);     image->packets=0; 7     packets=Max((image->columns*image->rows+2) >> 2,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*       Create linear colormap.      */     image->class=PseudoClass; $     image->colors=1 << image->depth;N     image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));0     if (image->colormap == (ColorPacket *) NULL)7       PrematureExit("Unable to allocate memory",image); %     for (i=0; i < image->colors; i++)      { )       image->colormap[i].red=(Quantum) i; +       image->colormap[i].green=(Quantum) i; *       image->colormap[i].blue=(Quantum) i;     }      /*8       Convert raster image to runlength-encoded packets.     */      for (y=0; y < y_offset; y++)G       (void) ReadData((char *) scanline,packet_size,width,image->file);      q=image->pixels;     q->length=MaxRunlength; #     for (y=0; y < image->rows; y++)      { 9       if ((y > 0) || (image->previous == (Image *) NULL)) I         (void) ReadData((char *) scanline,packet_size,width,image->file); &       p=scanline+packet_size*x_offset;(       for (x=0; x < image->columns; x++)       {          ReadQuantum(index,p); D         if ((index == q->index) && ((int) q->length < MaxRunlength))           q->length++;         else           { $             if (image->packets != 0)               q++;             image->packets++; *             if (image->packets == packets)               {                  packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket)); >                 if (image->pixels == (RunlengthPacket *) NULL)                   { ,                     free((char *) scanline);E                     PrematureExit("Unable to allocate memory",image);                    } 1                 q=image->pixels+image->packets-1;                }              q->index=index;              q->length=0;           }        } 3       ProgressMonitor(LoadImageText,y,image->rows);      } %     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));      SyncImage(image);      CompressColormap(image);"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;     /*       Proceed to next image.     */D     count=ReadData((char *) scanline,packet_size,width,image->file);     if (count > 0)       { 
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (count > 0);+   while (image->previous != (Image *) NULL)      image=image->previous;   free((char *) scanline);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H D F I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function ReadHDFImage reads a Hierarchical Data Format image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadHDFImage routine is:  % % %      image=ReadHDFImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadHDFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */
 #ifdef HasHDF 1 static Image *ReadHDFImage(ImageInfo *image_info)  {  #include "hdf.h"
 #undef BSD #undef LOCAL     ClassType 
     class;     Image      *image;      int      interlace,     is_palette,      status,      y;     int32      height,      length, 
     width;     register int     i,     x;     register unsigned char     *p;      register RunlengthPacket     *q;      uint16     reference;     unsigned char      *hdf_pixels;     unsigned int     packet_size;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    CloseImage(image);   /*     Read HDF image.    */   class=DirectClass;@   status=DF24getdims(image->filename,&width,&height,&interlace);   if (status == -1)      {        class=PseudoClass;E       status=DFR8getdims(image->filename,&width,&height,&is_palette);      }    if (status == -1) I     PrematureExit("Image file or does not contain any image data",image);    do   {      /*!       Initialize image structure.      */     image->class=class;      image->columns=width;      image->rows=height; .     image->packets=image->columns*image->rows;     packet_size=1;$     if (image->class == DirectClass)       packet_size=3;      hdf_pixels=(unsigned char *)?       malloc(packet_size*image->packets*sizeof(unsigned char)); %     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 1     if ((hdf_pixels == (unsigned char *) NULL) || 4         (image->pixels == (RunlengthPacket *) NULL))7       PrematureExit("Unable to allocate memory",image);      q=image->pixels;$     if (image->class == PseudoClass)       {          unsigned char            *hdf_palette;   
         /*           Create colormap.
         */H         hdf_palette=(unsigned char *) malloc(768*sizeof(unsigned char));         image->colors=256;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));6         if ((hdf_palette == (unsigned char *) NULL) ||6             (image->colormap == (ColorPacket *) NULL));           PrematureExit("Unable to allocate memory",image); L         (void) DFR8getimage(image->filename,hdf_pixels,(int) image->columns,)           (int) image->rows,hdf_palette);           reference=DFR8lastref();
         /*L           Convert HDF raster image to PseudoClass runlength-encoded packets.
         */         p=hdf_palette;         if (is_palette) !           for (i=0; i < 256; i++)            { 1             image->colormap[i].red=UpScale(*p++); 3             image->colormap[i].green=UpScale(*p++); 2             image->colormap[i].blue=UpScale(*p++);           }          else+           for (i=0; i < image->colors; i++)            { 8             image->colormap[i].red=(Quantum) UpScale(i);:             image->colormap[i].green=(Quantum) UpScale(i);9             image->colormap[i].blue=(Quantum) UpScale(i);            } #         free((char *) hdf_palette);          p=hdf_pixels; '         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }          SyncImage(image);        }      else       {          int            y;  
         /*L           Convert HDF raster image to DirectClass runlength-encoded packets.
         */O         (void) DF24getimage(image->filename,(void *) hdf_pixels,image->columns,            image->rows);           reference=DF24lastref();         p=hdf_pixels; D         image->interlace=interlace ? PlaneInterlace : NoneInterlace;         q=image->pixels;'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           { !             q->red=UpScale(*p++); #             q->green=UpScale(*p++); "             q->blue=UpScale(*p++);             q->index=0;              q->length=0;             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows); 	         }        } >     length=DFANgetlablen(image->filename,DFTAG_RIG,reference);     if (length > 0)        { 
         /*           Read the image label. 
         */         length+=MaxTextExtent;:         image->label=(char *) malloc(length*sizeof(char));*         if (image->label != (char *) NULL)P           DFANgetlabel(image->filename,DFTAG_RIG,reference,image->label,length);       } ?     length=DFANgetdesclen(image->filename,DFTAG_RIG,reference);      if (length > 0)        { 
         /*"           Read the image comments.
         */         length+=MaxTextExtent;=         image->comments=(char *) malloc(length*sizeof(char)); -         if (image->comments != (char *) NULL) J           DFANgetdesc(image->filename,DFTAG_RIG,reference,image->comments,             length);       }      free((char *) hdf_pixels);     CompressImage(image);      class=DirectClass;B     status=DF24getdims(image->filename,&width,&height,&interlace);     if (status == -1)        {          class=PseudoClass;G         status=DFR8getdims(image->filename,&width,&height,&is_palette);        }      if (status != -1)        { 
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status != -1); +   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }  #else 7 static Image *ReadHDFImage(const ImageInfo *image_info)  { ?   Warning("HDF library is not available",image_info->filename); $   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H I S T O G R A M I m a g e                                        % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadHISTOGRAMImage reads a HISTOGRAM image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % 3 %  The format of the ReadHISTOGRAMImage routine is:  % + %      image=ReadHISTOGRAMImage(image_info)  % + %  A description of each parameter follows:  % O %    o image:  Function ReadHISTOGRAMImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */= static Image *ReadHISTOGRAMImage(const ImageInfo *image_info)  {    Image      *image;   "   image=ReadMIFFImage(image_info);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d H T M L I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadHTMLImage reads a HTML image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadHTMLImage routine is: % & %      image=ReadHTMLImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadHTMLImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadHTMLImage(const ImageInfo *image_info) {    Image      *image;   :   Warning("Cannot read HTML images",image_info->filename);"   image=ReadMIFFImage(image_info);   return(image); }    #ifdef HasJBIG /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J B I G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadJBIGImage reads a JBIG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadJBIGImage routine is: % & %      image=ReadJBIGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJBIGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadJBIGImage(const ImageInfo *image_info) {  #define MaxBufferSize  8192      Image      *image;      int      status,      x,     y;     long     length;      register RunlengthPacket     *q;      register unsigned char     *p;      register unsigned short 
     index;     size_t
     count;     struct jbg_dec_state     jbig_info;     unsigned char      bit,     buffer[MaxBufferSize];     unsigned int	     byte,      height,      packets,
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*5     Determine maximum width and height, e.g. 640x512.    */   width=65535L;    height=65535L;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Read JBIG file.    */   jbg_dec_init(&jbig_info); K   jbg_dec_maxsize(&jbig_info,(unsigned long) width,(unsigned long) height);    status=JBG_EAGAIN;   do   { <     length=(long) fread(buffer,1,MaxBufferSize,image->file);     if (length == 0)       break;
     p=buffer;      count=0;K     while ((length > 0) && ((status == JBG_EAGAIN) || (status == JBG_EOK)))      { 4       status=jbg_dec_in(&jbig_info,p,length,&count);       p+=count;        length-=count;     } :   } while ((status == JBG_EAGAIN) || (status == JBG_EOK));   /*     Initialize image structure.    */=   image->columns=(unsigned int) jbg_dec_getwidth(&jbig_info); ;   image->rows=(unsigned int) jbg_dec_getheight(&jbig_info);    image->packets=0; 5   packets=Max((image->columns*image->rows+8) >> 4,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*     Create colormap.   */   image->class=PseudoClass;    image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    image->colormap[0].red=0;    image->colormap[0].green=0;    image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;    image->x_resolution=300;   image->y_resolution=300;   /*8     Convert X bitmap image to runlength-encoded packets.   */	   byte=0; #   p=jbg_dec_getimage(&jbig_info,0);    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { 
     bit=0;&     for (x=0; x < image->columns; x++)     {        if (bit == 0)          byte=(*p++);"       index=(byte & 0x80) ? 0 : 1;B       if ((index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;O               image->pixels=(RunlengthPacket *) realloc((char *) image->pixels, 1                 packets*sizeof(RunlengthPacket)); <               if (image->pixels == (RunlengthPacket *) NULL)                 { +                   jbg_dec_free(&jbig_info); C                   PrematureExit("Unable to allocate memory",image);                  } /               q=image->pixels+image->packets-1; 
             }            q->index=index;            q->length=0;	         }        bit++;       byte<<=1;        if (bit == 8)          bit=0;     } 1     ProgressMonitor(LoadImageText,y,image->rows);    }    jbg_dec_free(&jbig_info);    SyncImage(image); #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    CloseImage(image);   return(image); }  #else 8 static Image *ReadJBIGImage(const ImageInfo *image_info) { @   Warning("JBIG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   #ifdef HasJPEG static Image	   *image;    static jmp_buf   error_recovery;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d J P E G I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function ReadJPEGImage reads a JPEG image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % . %  The format of the ReadJPEGImage routine is: % & %      image=ReadJPEGImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadJPEGImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % ? %    o filename:  Specifies the name of the jpeg image to read.  %  %  */  < static unsigned int GetCharacter(j_decompress_ptr jpeg_info) {    struct jpeg_source_mgr
     *data;     data=jpeg_info->src;!   if (data->bytes_in_buffer == 0) +     (*data->fill_input_buffer) (jpeg_info);    data->bytes_in_buffer--;.   return(GETJOCTET(*data->next_input_byte++)); }   9 static boolean CommentHandler(j_decompress_ptr jpeg_info)  { 
   long int     length;      register char      *p;      /*      Determine length of comment.   */&   length=GetCharacter(jpeg_info) << 8;"   length+=GetCharacter(jpeg_info);   length-=2;'   if (image->comments != (char *) NULL) >     image->comments=(char *) realloc((char *) image->comments,F       (unsigned int) (Extent(image->comments)+length+1)*sizeof(char));   else     {        image->comments=(char *)7         malloc((unsigned int) (length+1)*sizeof(char)); +       if (image->comments != (char *) NULL)          *image->comments='\0';     } '   if (image->comments == (char *) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);        return(False);     }    /*     Read comment.    */,   p=image->comments+Extent(image->comments);   while (--length >= 0) !     *p++=GetCharacter(jpeg_info); 
   *p='\0';   return(True);  }   9 static void EmitMessage(j_common_ptr jpeg_info,int level)  {    char     message[JMSG_LENGTH_MAX];      struct jpeg_error_mgr      *jpeg_error;     jpeg_error=jpeg_info->err;3   (jpeg_error->format_message) (jpeg_info,message);    if (level < 0)     { L       if ((jpeg_error->num_warnings == 0) || (jpeg_error->trace_level >= 3))2         Warning((char *) message,image->filename);!       jpeg_error->num_warnings++;      }    else)     if (jpeg_error->trace_level >= level) 0       Warning((char *) message,image->filename); }   - static void ErrorExit(j_common_ptr jpeg_info)  {    EmitMessage(jpeg_info,0);    longjmp(error_recovery,1); }   8 static Image *ReadJPEGImage(const ImageInfo *image_info) {    int      x,     y;  	   JSAMPLE      *jpeg_pixels;   
   JSAMPROW     scanline[1];  	   Quantum 	     blue, 
     green,     red;     register int     i;     register JSAMPLE     *p;      register RunlengthPacket     *q;      struct jpeg_decompress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int     packets;     unsigned short
     index;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Initialize image structure.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;&   jpeg_info.err->error_exit=ErrorExit;)   image->pixels=(RunlengthPacket *) NULL;    jpeg_pixels=(JSAMPLE *) NULL;    if (setjmp(error_recovery))      {        /*         JPEG image is corrupt.       */*       if (jpeg_pixels != (JSAMPLE *) NULL)	         { %           free((char *) jpeg_pixels); .           jpeg_destroy_decompress(&jpeg_info);	         }        DestroyImage(image);       return((Image *) NULL);      } %   jpeg_create_decompress(&jpeg_info); @   jpeg_set_marker_processor(&jpeg_info,JPEG_COM,CommentHandler);)   jpeg_stdio_src(&jpeg_info,image->file); +   (void) jpeg_read_header(&jpeg_info,True);     if (jpeg_info.saw_JFIF_marker)     {        /*         Set image resolution.        */.       image->x_resolution=jpeg_info.X_density;.       image->y_resolution=jpeg_info.Y_density;&       if (jpeg_info.density_unit == 1)-         image->units=PixelsPerInchResolution; &       if (jpeg_info.density_unit == 2)3         image->units=PixelsPerCentimeterResolution;      } (   if (image_info->size != (char *) NULL)     {        unsigned int         height,          width;         unsigned long          scale_factor;          /*.         Let the JPEG library subsample for us.       */.       jpeg_calc_output_dimensions(&jpeg_info);3       image->magick_columns=jpeg_info.output_width; 1       image->magick_rows=jpeg_info.output_height; #       width=jpeg_info.output_width; %       height=jpeg_info.output_height; G       (void) ParseImageGeometry(image_info->size,&x,&y,&width,&height);        if (width == 0)          width=1;9       scale_factor=UpShift(jpeg_info.output_width)/width;        if (height == 0)         height=1; C       if (scale_factor > (UpShift(jpeg_info.output_height)/height)) =         scale_factor=UpShift(jpeg_info.output_height)/height; 4       jpeg_info.scale_denom=DownShift(scale_factor);.       jpeg_calc_output_dimensions(&jpeg_info);     }  #if (JPEG_LIB_VERSION >= 61)"   jpeg_info.dct_method=JDCT_FLOAT;O   image->interlace=jpeg_info.progressive_mode ? PlaneInterlace : NoneInterlace;  #endif$   jpeg_start_decompress(&jpeg_info);(   image->columns=jpeg_info.output_width;&   image->rows=jpeg_info.output_height;   image->packets=0; 5   packets=Max((image->columns*image->rows+2) >> 2,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   jpeg_pixels=(JSAMPLE *) G     malloc(jpeg_info.output_components*image->columns*sizeof(JSAMPLE)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||(       (jpeg_pixels == (JSAMPLE *) NULL))5     PrematureExit("Unable to allocate memory",image); 1   if (jpeg_info.out_color_space == JCS_GRAYSCALE)      {        /*&         Initialize grayscale colormap.       */       image->class=PseudoClass;        image->colors=256;P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image); '       for (i=0; i < image->colors; i++)        { *         image->colormap[i].red=UpScale(i);,         image->colormap[i].green=UpScale(i);+         image->colormap[i].blue=UpScale(i);        }      }    /*5     Convert JPEG pixels to runlength-encoded packets.    */   red=0;
   green=0;	   blue=0; 
   index=0;%   scanline[0]=(JSAMPROW) jpeg_pixels;    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { 6     (void) jpeg_read_scanlines(&jpeg_info,scanline,1);     p=jpeg_pixels;&     for (x=0; x < image->columns; x++)     { 2       if (jpeg_info.data_precision > QuantumDepth)	         { 9           if (jpeg_info.out_color_space == JCS_GRAYSCALE) (             index=GETJSAMPLE(*p++) >> 4;           else
             { 4               red=(Quantum) (GETJSAMPLE(*p++) >> 4);6               green=(Quantum) (GETJSAMPLE(*p++) >> 4);5               blue=(Quantum) (GETJSAMPLE(*p++) >> 4); 8               if (jpeg_info.out_color_space == JCS_CMYK)8                 index=(Quantum) (GETJSAMPLE(*p++) >> 4);
             } 
          }        else 8          if (jpeg_info.out_color_space == JCS_GRAYSCALE)"            index=GETJSAMPLE(*p++);
          else             {5              red=(Quantum) UpScale(GETJSAMPLE(*p++)); 7              green=(Quantum) UpScale(GETJSAMPLE(*p++)); 6              blue=(Quantum) UpScale(GETJSAMPLE(*p++));7              if (jpeg_info.out_color_space == JCS_CMYK) 9                index=(Quantum) UpScale(GETJSAMPLE(*p++));             }0       if (jpeg_info.out_color_space == JCS_CMYK)	         { !           index=MAXJSAMPLE-index; $           if ((int) (red-index) < 0)             red=0;           else             red-=index; &           if ((int) (green-index) < 0)             green=0;           else             green-=index; %           if ((int) (blue-index) < 0)              blue=0;            else             blue-=index;           index=0;	         } H       if ((red == q->red) && (green == q->green) && (blue == q->blue) &&B           (index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;/               image->pixels=(RunlengthPacket *) P                 realloc((char *) image->pixels,packets*sizeof(RunlengthPacket));<               if (image->pixels == (RunlengthPacket *) NULL)                 { -                   free((char *) jpeg_pixels); 6                   jpeg_destroy_decompress(&jpeg_info);C                   PrematureExit("Unable to allocate memory",image);                  } /               q=image->pixels+image->packets-1; 
             }            q->red=red;            q->green=green;            q->blue=blue;            q->index=index;            q->length=0;	         }      } 1     ProgressMonitor(LoadImageText,y,image->rows);    } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket)); "   if (image->class == PseudoClass)     {        SyncImage(image);        CompressColormap(image);     }    /*     Free memory.   */   free((char *) jpeg_pixels); ,   (void) jpeg_finish_decompress(&jpeg_info);&   jpeg_destroy_decompress(&jpeg_info);   CloseImage(image);   return(image); }  #else 8 static Image *ReadJPEGImage(const ImageInfo *image_info) { @   Warning("JPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d L O G O I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadLOGOImage reads a LOGO image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadLOGOImage routine is: % & %      image=ReadLOGOImage(image_info) % + %  A description of each parameter follows:  % J %    o image:  Function ReadLOGOImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */2 static Image *ReadLOGOImage(ImageInfo *image_info) {  #include "logo.h"      char     *filename,!     logo_filename[MaxTextExtent];      FILE
     *file;     Image      *image;      register int     i;     register unsigned char     *p;      unsigned int     extent;      /*     Open temporary output file.    */#   TemporaryFilename(logo_filename); ,   file=fopen(logo_filename,WriteBinaryType);   if (file == (FILE *) NULL)     { 4       Warning("Unable to write file",logo_filename);&       return(ReadXCImage(image_info));     }    p=LogoImage;   extent=LogoImageExtent; 0   if (strcmp(image_info->magick,"GRANITE") == 0)     {        p=GraniteImage;         extent=GraniteImageExtent;     } 1   if (strcmp(image_info->magick,"NETSCAPE") == 0)      {        p=NetscapeImage;!       extent=NetscapeImageExtent;      } %   for (i=0; i < LogoImageExtent; i++)    { !     (void) fputc((char) *p,file);      p++;   }    if (ferror(file))      { E       Warning("An error has occurred writing to file",logo_filename);        (void) fclose(file);#       (void) remove(logo_filename); &       return(ReadXCImage(image_info));     }    (void) fclose(file);    filename=image_info->filename;%   image_info->filename=logo_filename; !   image=ReadGIFImage(image_info);     image_info->filename=filename;   if (image != (Image *) NULL)8     (void) strcpy(image->filename,image_info->filename);   (void) remove(logo_filename);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A P I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function ReadMAPImage reads an image of raw RGB colormap and colormap indexM %  bytes and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % - %  The format of the ReadMAPImage routine is:  % % %      image=ReadMAPImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadMAPImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadMAPImage(const ImageInfo *image_info)  {    Image      *image;      int      colors;      register int     i;     register unsigned char     *p;      unsigned char      *colormap;     unsigned int     height,      packet_size,     status, 
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*D     Determine width, height, and number of colors, e.g. 640x512+256.   */   width=512;
   height=512; 
   colors=256; (   if (image_info->size != (char *) NULL)K     (void) XParseGeometry(image_info->size,&colors,&colors,&width,&height);    /*     Initialize image structure.    */   image->class=PseudoClass; #   image->compression=NoCompression;    image->columns=width;    image->rows=height;    image->colors=colors; ,   image->packets=image->columns*image->rows;$   packet_size=3*(image->depth >> 3);   colormap=(unsigned char *)<     malloc(packet_size*image->colors*sizeof(unsigned char));L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));(   image->packed_pixels=(unsigned char *);     malloc(image->packets*packet_size*(image->depth >> 3)); -   if ((colormap == (unsigned char *) NULL) || 0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Read image colormap.   */M   (void) ReadData((char *) colormap,1,image->colors*packet_size,image->file); 
   p=colormap; #   for (i=0; i < image->colors; i++)    { *     ReadQuantum(image->colormap[i].red,p);,     ReadQuantum(image->colormap[i].green,p);+     ReadQuantum(image->colormap[i].blue,p);    }    free((char *) colormap);   /*6     Convert raster image to runlength-encoded packets.   */   packet_size=1;   if (image->colors > 256)     packet_size++;5   if (image->packed_pixels != (unsigned char *) NULL) (     free((char *) image->packed_pixels);(   image->packed_pixels=(unsigned char *)'     malloc(image->packets*packet_size); 5   if (image->packed_pixels == (unsigned char *) NULL) 5     PrematureExit("Unable to allocate memory",image); K   (void) ReadData((char *) image->packed_pixels,packet_size,image->packets,      image->file); %   status=RunlengthDecodeImage(image);    if (status == False)     {        DestroyImages(image);        return((Image *) NULL);      }    CompressImage(image);    CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d M A T T E I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadMATTEImage reads an image of raw matte bytes and returns it.N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % / %  The format of the ReadMATTEImage routine is:  % ' %      image=ReadMATTEImage(image_info)  % + %  A description of each parameter follows:  % K %    o image:  Function ReadMATTEImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */9 static Image *ReadMATTEImage(const ImageInfo *image_info)  {    Image      *image;      int      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *q;      register unsigned char     *p;      unsigned char      *scanline;     unsigned int     height,      packet_size,     packets,
     width;     unsigned short
     index,
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; 
   x_offset=0; 
   y_offset=0; (   if (image_info->size != (char *) NULL)     { 
       x=0;C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height);        for (i=0; i < x; i++) "         (void) fgetc(image->file);     }    /*     Initialize image structure.    */   image->matte=True;   image->columns=width;    image->rows=height;     packet_size=image->depth >> 3;   scanline=(unsigned char *)=     malloc(packet_size*image->columns*sizeof(unsigned char)); (   if (image_info->tile != (char *) NULL)O     (void) XParseGeometry(image_info->tile,&x_offset,&y_offset,&image->columns,        &image->rows);   image->packets=0; 5   packets=Max((image->columns*image->rows+2) >> 2,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));-   if ((scanline == (unsigned char *) NULL) || 2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*6     Convert raster image to runlength-encoded packets.   */   for (y=0; y < y_offset; y++)E     (void) ReadData((char *) scanline,packet_size,width,image->file);    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    { E     (void) ReadData((char *) scanline,packet_size,width,image->file); $     p=scanline+packet_size*x_offset;&     for (x=0; x < image->columns; x++)     {        ReadQuantum(index,p); B       if ((index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         { "           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {                packets<<=1;O               image->pixels=(RunlengthPacket *) realloc((char *) image->pixels, 1                 packets*sizeof(RunlengthPacket)); <               if (image->pixels == (RunlengthPacket *) NULL)                 { *                   free((char *) scanline);C                   PrematureExit("Unable to allocate memory",image);                  } /               q=image->pixels+image->packets-1; 
             }            q->red=0;            q->green=0;            q->blue=0;           q->index=index;            q->length=0;	         }      } 1     ProgressMonitor(LoadImageText,y,image->rows);    } #   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    free((char *) scanline);   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d M I F F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function ReadMIFFImage reads a MIFF image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMIFFImage routine is: % $ %      image=ReadMIFFImage(filename) % + %  A description of each parameter follows:  % I %    o image: Function ReadMIFFImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadMIFFImage(const ImageInfo *image_info) {    char     keyword[MaxTextExtent],      value[MaxTextExtent];      Image      *image;      register int     c,     i;     register unsigned char     *p;      unsigned int     length,      packet_size,     status;      unsigned long 
     count,     packets;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    image->depth=8;    /*G     Decode image header;  header terminates one character beyond a ':'.    */   c=fgetc(image->file);    if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      }    do   {      /*I       Decode image header;  header terminates one character beyond a ':'.      */%     image->compression=NoCompression; $     while (isgraph(c) && (c != ':'))     {        register char          *p;          if (c == '{') 	         {            /*0             Read comment-- any text between { }.           *//           if (image->comments != (char *) NULL) 
             { -               length=Extent(image->comments); '               p=image->comments+length; 
             }            else
             { #               length=MaxTextExtent; C               image->comments=(char *) malloc(length*sizeof(char));                 p=image->comments;
             } 8           for ( ; image->comments != (char *) NULL; p++)           { !             c=fgetc(image->file); )             if ((c == EOF) || (c == '}'))                break;0             if ((p-image->comments+1) >= length)               {                  *p='\0';                 length<<=1; (                 image->comments=(char *)H                   realloc((char *) image->comments,length*sizeof(char));5                 if (image->comments == (char *) NULL)                    break;:                 p=image->comments+Extent(image->comments);               } !             *p=(unsigned char) c;            } /           if (image->comments == (char *) NULL) =             PrematureExit("Unable to allocate memory",image);            *p='\0';           c=fgetc(image->file); 	         } 
       else         if (isalnum(c))            {              /*0               Determine a keyword and its value.             */             p=keyword;             do
             { 2               if ((p-keyword) < (MaxTextExtent-1))                 *p++=(char) c;#               c=fgetc(image->file); !             } while (isalnum(c));              *p='\0';,             while (isspace(c) || (c == '='))#               c=fgetc(image->file);              p=value;             if (c != '"') /               while (!isspace(c) && (c != EOF))                { 2                 if ((p-value) < (MaxTextExtent-1))                    *p++=(char) c;%                 c=fgetc(image->file);                }              else               { %                 c=fgetc(image->file); 0                 while ((c != '"') && (c != EOF))                 { 4                   if ((p-value) < (MaxTextExtent-1))"                     *p++=(char) c;'                   c=fgetc(image->file);                  }                }              *p='\0';             /*6               Assign a value to the specified keyword.             */-             if (strcmp(keyword,"class") == 0) 3               if (strcmp(value,"PseudoClass") == 0) )                 image->class=PseudoClass;                else5                 if (strcmp(value,"DirectClass") == 0) +                   image->class=DirectClass;                  else.                   image->class=UndefinedClass;.             if (strcmp(keyword,"colors") == 0)7               image->colors=(unsigned int) atoi(value); 3             if (strcmp(keyword,"compression") == 0) L               if ((strcmp(value,"Zip") == 0) || (strcmp(value,"Zlib") == 0))2                 image->compression=ZipCompression;               else:                 if (strcmp(value,"RunlengthEncoded") == 0)A                   image->compression=RunlengthEncodedCompression;                  else:                   image->compression=UndefinedCompression;/             if (strcmp(keyword,"columns") == 0) 8               image->columns=(unsigned int) atoi(value);-             if (strcmp(keyword,"delay") == 0) '               image->delay=atoi(value); -             if (strcmp(keyword,"depth") == 0) 5               image->depth=atoi(value) <= 8 ? 8 : 16; -             if (strcmp(keyword,"gamma") == 0) '               image->gamma=atof(value); *             if (strcmp(keyword,"id") == 0)3               if (strcmp(value,"ImageMagick") == 0) (                 image->id=ImageMagickId;               else&                 image->id=UndefinedId;-             if (strcmp(keyword,"label") == 0)                { K                 image->label=(char *) malloc(Extent(value)+1*sizeof(char)); 2                 if (image->label == (char *) NULL)C                   PrematureExit("Unable to allocate memory",image); 2                 (void) strcpy(image->label,value);               } 1             if ((strcmp(keyword,"matte") == 0) || /                 (strcmp(keyword,"alpha") == 0)) M               if ((strcmp(value,"True") == 0) || (strcmp(value,"true") == 0)) "                 image->matte=True;               else#                 image->matte=False; /             if (strcmp(keyword,"montage") == 0)                { M                 image->montage=(char *) malloc(Extent(value)+1*sizeof(char)); 4                 if (image->montage == (char *) NULL)C                   PrematureExit("Unable to allocate memory",image); 4                 (void) strcpy(image->montage,value);               } /             if (strcmp(keyword,"packets") == 0) 8               image->packets=(unsigned int) atoi(value);,             if (strcmp(keyword,"rows") == 0)5               image->rows=(unsigned int) atoi(value); -             if (strcmp(keyword,"scene") == 0) 6               image->scene=(unsigned int) atoi(value);1             if (strcmp(keyword,"signature") == 0)                { )                 image->signature=(char *) 9                   malloc((Extent(value)+1)*sizeof(char)); 6                 if (image->signature == (char *) NULL)C                   PrematureExit("Unable to allocate memory",image);%6                 (void) strcpy(image->signature,value);               }            }          else           c=fgetc(image->file);        while (isspace(c))         c=fgetc(image->file);      }      (void) fgetc(image->file);     /*8       Verify that required image information is defined.     */I     if ((image->id == UndefinedId) || (image->class == UndefinedClass) || P         (image->compression == UndefinedCompression) || (image->columns == 0) ||         (image->rows == 0)) <       PrematureExit("Incorrect image header in file",image);(     if (image->montage != (char *) NULL)       {          register char 
           *p;   
         /*           Image directory.
         */E         image->directory=(char *) malloc(MaxTextExtent*sizeof(char)); .         if (image->directory == (char *) NULL);           PrematureExit("Unable to read image data",image);          p=image->directory;U
         do	         {            *p='\0';B           if (((Extent(image->directory)+1) % MaxTextExtent) == 0)
             {                /*=                 Allocate more memory for the image directory.                */J               image->directory=(char *) realloc((char *) image->directory,I                 (Extent(image->directory)+MaxTextExtent+1)*sizeof(char)); 4               if (image->directory == (char *) NULL)A                 PrematureExit("Unable to read image data",image); :               p=image->directory+Extent(image->directory);
             }            c=fgetc(image->file); !           *p++=(unsigned char) c;1         } while (c != '\0');       }y$     if (image->class == PseudoClass)       {          unsigned int           colors;            unsigned short           value;  
         /*3           PseudoClass image cannot have matte data.c
         */         if (image->matte)aB           PrematureExit("Matte images must be DirectClass",image);
         /*            Create image colormap.
         */         colors=image->colors;i         if (colors == 0)           colors=256;nK         image->colormap=(ColorPacket *) malloc(colors*sizeof(ColorPacket));C4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);p         if (image->colors == 0) $           for (i=0; i < colors; i++)           {C8             image->colormap[i].red=(Quantum) UpScale(i);:             image->colormap[i].green=(Quantum) UpScale(i);9             image->colormap[i].blue=(Quantum) UpScale(i);              image->colors++;           }          else           {              unsigned char                *colormap;               /*,               Read image colormap from file.             */.             packet_size=3*(image->depth >> 3);&             colormap=(unsigned char *)F               malloc(packet_size*image->colors*sizeof(unsigned char));3             if (colormap == (unsigned char *) NULL) ?               PrematureExit("Unable to allocate memory",image);aJ             (void) ReadData((char *) colormap,1,packet_size*image->colors,               image->file);              p=colormap;c-             for (i=0; i < image->colors; i++)r
             { 4               ReadQuantum(image->colormap[i].red,p);6               ReadQuantum(image->colormap[i].green,p);5               ReadQuantum(image->colormap[i].blue,p); 
             }h$             free((char *) colormap);           }s       }      /*#       Determine packed packet size.      */$     if (image->class == PseudoClass)       {u         image->packet_size=1;i          if (image->colors > 256)           image->packet_size++;"       }      else       {n1         image->packet_size=3*(image->depth >> 3);e         if (image->matte)            image->packet_size++;u       } :     if (image->compression == RunlengthEncodedCompression)       image->packet_size++;t#     packet_size=image->packet_size; -     if (image->compression == ZipCompression)*       packet_size=1;     /*       Allocate image pixels.     */,     if (image->compression == NoCompression)0       image->packets=image->columns*image->rows;     packets=image->packets;      if (image->packets == 0))       packets=image->columns*image->rows; *     image->packed_pixels=(unsigned char *)G       malloc((unsigned int) packets*packet_size*sizeof(unsigned char));d7     if (image->packed_pixels == (unsigned char *) NULL) 7       PrematureExit("Unable to allocate memory",image);      /*"       Read image pixels from file.     */>     if ((image->compression != RunlengthEncodedCompression) ||         (image->packets != 0))D       (void) ReadData((char *) image->packed_pixels,1,(unsigned int))         packets*packet_size,image->file);%     else       { 
         /*5           Number of runlength packets is unspecified. 
         */         count=0;         p=image->packed_pixels;t
         do	         { @           (void) ReadData((char *) p,1,packet_size,image->file);           image->packets++;a           p+=(packet_size-1);            count+=(*p+1);           p++;	         } 5         while (count < (image->columns*image->rows));        } .     if (image->compression ==  ZipCompression)       {          int            status;            unsigned chara           *compressed_pixels;i  
         /*4           Uncompress image pixels with Zip encoding.
         *//         compressed_pixels=image->packed_pixels;t>         packets=image->columns*image->rows*image->packet_size;.         image->packed_pixels=(unsigned char *)4           malloc((packets+8)*sizeof(unsigned char));;         if (image->packed_pixels == (unsigned char *) NULL)e;           PrematureExit("Unable to allocate memory",image);t         status=True;
 #ifdef HasPNG J         status=uncompress(image->packed_pixels,&packets,compressed_pixels,           image->packets); #endifC         image->packets=(unsigned int) (packets/image->packet_size);.)         free((char *) compressed_pixels);n         if (status)g@           PrematureExit("Unable to Zip uncompress image",image);       }      /*J       Unpack the packed image pixels into runlength-encoded pixel packets.     */'     status=RunlengthDecodeImage(image);      if (status == False)       {E         DestroyImages(image);e         return((Image *) NULL);t       }a     /*       Proceed to next image.     */     do     {        c=fgetc(image->file);i(     } while (!isgraph(c) && (c != EOF));     if (c != EOF)*       {w
         /*#           Allocate image structure.t
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {(!             DestroyImages(image); #             return((Image *) NULL);a           }tB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (c != EOF);=+   while (image->previous != (Image *) NULL)g     image=image->previous;   CloseImage(image);   return(image); }S e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%=O %                                                                             %)O %                                                                             %eO %                                                                             %gO %  R e a d M O N O I m a g e                                                  % O %                                                                             %-O %                                                                             %(O %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function ReadMONOImage reads an image of raw bites in LSB order and returnsI %  it.  It allocates the memory necessary for the new Image structure and & %  returns a pointer to the new image. %,. %  The format of the ReadMONOImage routine is: %h& %      image=ReadMONOImage(image_info) %i+ %  A description of each parameter follows:  % J %    o image:  Function ReadMONOImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.n %  %( */8 static Image *ReadMONOImage(const ImageInfo *image_info) {    Image      *image;g     int)     x,
     x_offset,      y,
     y_offset;n     register int     i;     register RunlengthPacket     *q;m     unsigned char      bit,	     byte;a     unsigned int     height,x     packets,
     width;     unsigned short
     index;     /*     Allocate image structure.i   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);%#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; 
   x_offset=0; 
   y_offset=0; (   if (image_info->size != (char *) NULL)     { 
       x=0;C       (void) XParseGeometry(image_info->size,&x,&y,&width,&height);        for (i=0; i < x; i++) "         (void) fgetc(image->file);     }    /*     Initialize image structure.    */   image->columns=width;    image->rows=height; (   if (image_info->tile != (char *) NULL)O     (void) XParseGeometry(image_info->tile,&x_offset,&y_offset,&image->columns,%       &image->rows);   image->packets=0;t5   packets=Max((image->columns*image->rows+8) >> 4,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   image->class=PseudoClass;p   image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image); #   for (i=0; i < image->colors; i++)f   {e8     image->colormap[i].red=(MaxRGB*i)/(image->colors-1);:     image->colormap[i].green=(MaxRGB*i)/(image->colors-1);9     image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);c   }I   /*8     Convert bi-level image to runlength-encoded packets.   */8   for (y=0; y < ((y_offset*image->columns+7) >> 3); y++)     (void) fgetc(image->file);	   byte=0;    q=image->pixels;   q->length=MaxRunlength; !   for (y=0; y < image->rows; y++)    {n
     bit=0;+     for (x=0; y < ((x_offset+7) >> 3); x++)e        (void) fgetc(image->file);&     for (x=0; x < image->columns; x++)     {r       if (bit == 0)r          byte=fgetc(image->file);"       index=(byte & 0x01) ? 0 : 1;B       if ((index == q->index) && ((int) q->length < MaxRunlength))         q->length++;
       else	         {n"           if (image->packets != 0)             q++;           image->packets++; (           if (image->packets == packets)
             {i               packets<<=1;@               image->pixels=(RunlengthPacket *) realloc((char *)?                 image->pixels,packets*sizeof(RunlengthPacket));=<               if (image->pixels == (RunlengthPacket *) NULL)A                 PrematureExit("Unable to allocate memory",image); /               q=image->pixels+image->packets-1;r
             }o           q->index=index;            q->length=0;	         }.       bit++;       if (bit == 8)m         bit=0;       byte>>=1;      } 1     ProgressMonitor(LoadImageText,y,image->rows);_   }i   SyncImage(image);-   CloseImage(image);   return(image); }c #ifdef HasMPEG 2 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %aO %                                                                             %eO %                                                                             %dO %  R e a d M P E G I m a g e                                                  % O %                                                                             %iO %                                                                             %dO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%x %xE %  Function ReadMPEGImage reads a MPEG image file and returns it.  ItsK %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the ReadMPEGImage routine is: % & %      image=ReadMPEGImage(image_info) %s+ %  A description of each parameter follows:h %hJ %    o image:  Function ReadMPEGImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. %sA %    o image_info: Specifies a pointer to an ImageInfo structure.d %g %a */8 static Image *ReadMPEGImage(const ImageInfo *image_info) {i   Image      *image;r     ImageDescr     mpeg_info;     int      y;     register int     x;     register unsigned char     *p;      register RunlengthPacket     *q;e     unsigned char;     *mpeg_pixels;      unsigned int     number_frames,     status;i     unsigned longe     lsb_first;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);s#   if (image->file == (FILE *) NULL)=/     PrematureExit("Unable to open file",image);    /*     Allocate MPEG pixels.    */*   (void) OpenMPEG(image->file,&mpeg_info);   number_frames=(unsigned int)9     (8*image->filesize/mpeg_info.Width/mpeg_info.Height); M   mpeg_pixels=(unsigned char *) malloc(mpeg_info.Size*sizeof(unsigned char));n,   if (mpeg_pixels == (unsigned char *) NULL)5     PrematureExit("Unable to allocate memory",image);=   /*     Read MPEG image.   */,   status=GetMPEGFrame((char *) mpeg_pixels);    if (image_info->subrange != 0)/     while (image->scene < image_info->subimage)k     {=       /*         Skip to next image.p       */       image->scene++;r0       status=GetMPEGFrame((char *) mpeg_pixels);       if (status == False)         break;@       ProgressMonitor(LoadImageText,image->scene,number_frames);     }    if (status == False)     {S!       free((char *) mpeg_pixels);r0       PrematureExit("Corrupt MPEG image",image);     }    while (status == True)   {      /*!       Initialize image structure.      */#     image->columns=mpeg_info.Width; #     image->rows=mpeg_info.Height-8;s.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)e5       malloc(image->packets*sizeof(RunlengthPacket));22     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*=       Convert MPEG raster image to runlength-encoded packets.      */     p=mpeg_pixels;     q=image->pixels;     lsb_first=1;     if (*(char *) &lsb_first) %       for (y=0; y < image->rows; y++)t       {,*         for (x=0; x < image->columns; x++)	         {g           q->red=UpScale(*p++); !           q->green=UpScale(*p++);s            q->blue=UpScale(*p++);           q->length=0;           p++;           q++;	         }        }      else%       for (y=0; y < image->rows; y++)i       { *         for (x=0; x < image->columns; x++)	         {b           p++;            q->blue=UpScale(*p++);!           q->green=UpScale(*p++);e           q->red=UpScale(*p++);            q->length=0;           q++;	         }m       }k     if (image_info->verbose)(       DescribeImage(image,stderr,False);     CompressImage(image);r"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;.     status=GetMPEGFrame((char *) mpeg_pixels);     if (status == True)n       {a
         /*#           Allocate image structure.=
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {e!             DestroyImages(image);l#             return((Image *) NULL);            }rB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }*=     if ((status == False) || (image->scene == number_frames))l#       number_frames=image->scene+1;k>     ProgressMonitor(LoadImageText,image->scene,number_frames);   }m   free((char *) mpeg_pixels);e+   while (image->previous != (Image *) NULL)t     image=image->previous;   CloseImage(image);   return(image); }a #elseu8 static Image *ReadMPEGImage(const ImageInfo *image_info) {b@   Warning("MPEG library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }c #endif p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %aO %                                                                             % O %                                                                             %iO %  R e a d M T V I m a g e                                                    % O %                                                                             %oO %                                                                             % O %                                                                             %0O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadMTVImage reads a MTV image file and returns it.  It allocates-L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  %e- %  The format of the ReadMTVImage routine is:s %o% %      image=ReadMTVImage(image_info)o %a+ %  A description of each parameter follows:s % I %    o image:  Function ReadMTVImage returns a pointer to the image afterrL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.t %; %  */7 static Image *ReadMTVImage(const ImageInfo *image_info)  {l   Image      *image;+     int 
     count,     y;  	   Quantum 	     blue,e
     green,     red;     register int     x;     register RunlengthPacket     *q;      unsigned int     columns,     packets,	     rows;;     /*     Allocate image structure.i   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);;   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);c#   if (image->file == (FILE *) NULL)k/     PrematureExit("Unable to open file",image);i   /*     Read MTV image.e   */5   count=fscanf(image->file,"%u %u\n",&columns,&rows);    if (count == 0) 0     PrematureExit("Not a MTV image file",image);   do   {      /*!       Initialize image structure.      */     image->columns=columns;      image->rows=rows;      image->packets=0;;7     packets=Max((image->columns*image->rows+4) >> 3,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);o     /*<       Convert MTV raster image to runlength-encoded packets.     */     q=image->pixels;     q->length=MaxRunlength; #     for (y=0; y < image->rows; y++)-     {t(       for (x=0; x < image->columns; x++)       {o(         red=UpScale(fgetc(image->file));*         green=UpScale(fgetc(image->file));)         blue=UpScale(fgetc(image->file)); J         if ((red == q->red) && (green == q->green) && (blue == q->blue) &&-             ((int) q->length < MaxRunlength))            q->length++;         else           { $             if (image->packets != 0)               q++;             image->packets++;g*             if (image->packets == packets)               {l                 packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket)); >                 if (image->pixels == (RunlengthPacket *) NULL)C                   PrematureExit("Unable to allocate memory",image); 1                 q=image->pixels+image->packets-1;u               }              q->red=red;a             q->green=green;              q->blue=blue;)             q->index=0;              q->length=0;           }        }n3       ProgressMonitor(LoadImageText,y,image->rows);p     }-%     image->pixels=(RunlengthPacket *) M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));+     /*       Proceed to next image.     */7     count=fscanf(image->file,"%u %u\n",&columns,&rows);r     if (count > 0)       {c
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {%!             DestroyImages(image);%#             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }G   } while (count > 0);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %tO %  R e a d N U L L I m a g e                                                  %rO %                                                                             % O %                                                                             %rO %                                                                             %hO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %tE %  Function ReadNULLImage reads a NULL image file and returns it.  IteK %  allocates the memory necessary for the new Image structure and returns aG %  pointer to the new image. %o. %  The format of the ReadNULLImage routine is: %m& %      image=ReadNULLImage(image_info) %p+ %  A description of each parameter follows:c %eJ %    o image:  Function ReadNULLImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.a %nA %    o image_info: Specifies a pointer to an ImageInfo structure.r %i %U */8 static Image *ReadNULLImage(const ImageInfo *image_info) { "   return(ReadXCImage(image_info)); }s a /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %dO %                                                                             %tO %                                                                             % O %  R e a d P C D I m a g e                                                    %fO %                                                                             % O %                                                                             %hO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%H %  Function ReadPCDImage reads a Photo CD image file and returns it.  ItK %  allocates the memory necessary for the new Image structure and returns a F %  pointer to the new image.  Much of the PCD decoder was derived from. %  the program hpcdtoppm(1) by Hadmut Danisch. %Y- %  The format of the ReadPCDImage routine is:  % % %      image=ReadPCDImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadPCDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.% %%A %    o image_info: Specifies a pointer to an ImageInfo structure.  %d %K */E static Image *OverviewImage(const ImageInfo *image_info,Image *image)r {r   char     *commands[3],m     *resource_value;  	   Displaye
     *display;r     Imagei     *montage_image;.     ImageInfor     local_info;Y     XMontageInfo     montage_info;R     XResourceInfoi     resource_info;  
   XrmDatabaser     resource_database;     /*%     Initialize to the default values.o   */!   XGetMontageInfo(&montage_info); '   resource_database=(XrmDatabase) NULL; 7   resource_info.background_color=DefaultTileBackground; :   resource_info.border_width=atoi(DefaultTileBorderwidth);)   resource_info.colorspace=RGBColorspace;M   resource_info.dither=False;i7   resource_info.foreground_color=DefaultTileForeground; !   resource_info.font=DefaultFont;_3   resource_info.image_geometry=DefaultTileGeometry;e&   resource_info.gravity=CenterGravity;-   resource_info.matte_color=DefaultTileMatte;a!   resource_info.monochrome=False;,    resource_info.number_colors=0;*   resource_info.server_name=(char *) NULL;$   resource_info.title=(char *) NULL;   resource_info.tree_depth=0;r   /*     Open X server connection.(   */0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {t       /*(         Set our forgiving error handler.       */       XSetErrorHandler(XError);        /*3         Get user defaults from X resource database.X       */B       resource_database=XGetResourceDatabase(display,client_name);E       XGetResourceInfo(resource_database,client_name,&resource_info);.L       resource_info.background_color=XGetResourceInstance(resource_database,8         client_name,"background",DefaultTileBackground);E       resource_value=XGetResourceClass(resource_database,client_name,e.         "borderWidth",DefaultTileBorderwidth);6       resource_info.border_width=atoi(resource_value);L       resource_info.foreground_color=XGetResourceInstance(resource_database,8         client_name,"foreground",DefaultTileForeground);       resource_value= H         XGetResourceClass(resource_database,client_name,"frame","True");0       montage_info.frame=IsTrue(resource_value);J       resource_info.image_geometry=XGetResourceInstance(resource_database,9         client_name,"imageGeometry",DefaultTileGeometry); G       resource_info.matte_color=XGetResourceInstance(resource_database, 3         client_name,"mattecolor",DefaultTileMatte);-E       resource_value=XGetResourceClass(resource_database,client_name,e&         "pointsize",DefaultPointSize);2       montage_info.pointsize=atoi(resource_value);       resource_value=fI         XGetResourceClass(resource_database,client_name,"shadow","True");>1       montage_info.shadow=IsTrue(resource_value);aO       montage_info.tile=XGetResourceClass(resource_database,client_name,"tile",p         montage_info.tile);N       XCloseDisplay(display);l     }l   /*     Create image tiles.    */   local_info=(*image_info);n   commands[0]=client_name;   commands[1]="-label";>   commands[2]=DefaultTileLabel;n/   MogrifyImages(&local_info,3,commands,&image);*   /*"     Create the PCD Overview image.   */<   (void) strcpy(montage_info.filename,image_info->filename);C   montage_image=XMontageImages(&resource_info,&montage_info,image); &   if (montage_image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image);(   DestroyImage(image);   CompressImage(montage_image);    return(montage_image); }s  7 static Image *ReadPCDImage(const ImageInfo *image_info)i {p   Imagee     *image;   
   long int     offset;-     register int     i;     register RunlengthPacket     *p;      register unsigned char     *c1,     *c2,     *y;n     unsigned char 
     *chroma1,u
     *chroma2,p     *header,
     *luma;     unsigned int     height,      number_images,
     overview,m     rotate,g     status, 
     subimage, 
     width;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);)#   if (image->file == (FILE *) NULL)s/     PrematureExit("Unable to open file",image);    /*$     Determine if this is a PCD file.   */A   header=(unsigned char *) malloc(3*0x800*sizeof(unsigned char)); '   if (header == (unsigned char *) NULL)k5     PrematureExit("Unable to allocate memory",image);e9   status=ReadData((char *) header,1,3*0x800,image->file);s5   overview=strncmp((char *) header,"PCD_OPA",7) == 0;    if ((status == False) ||C       ((strncmp((char *) header+0x800,"PCD",3) != 0) && !overview)) 0     PrematureExit("Not a PCD image file",image);   rotate=header[0x0e02] & 0x03; /   number_images=(header[10] << 8) | header[11];    free((char *) header);
   subimage=3;     if (image_info->subrange != 0)"     subimage=image_info->subimage;(   if (image_info->size != (char *) NULL)     { 	       int 
         x,
         y;         /*.         Determine which image size to extract.       */       width=768;       height=512;gC       (void) XParseGeometry(image_info->size,&x,&y,&width,&height); 1       for (subimage=1; subimage <= 6; subimage++),       { .         if ((width <= 192) && (height <= 128))           break;         width>>=1;         height>>=1;        }=     }e   if (overview)f     subimage=1;=   /*     Initialize image structure.    */   width=192;
   height=128;+%   for (i=1; i < Min(subimage,3); i++)u   {i     width<<=1;     height<<=1;    }    image->columns=width;o   image->rows=height;-   for ( ; i < subimage; i++)   {;     image->columns<<=1;a     image->rows<<=1;   }r   /*$     Allocate luma and chroma memory.   */,   image->packets=image->columns*image->rows;M   chroma1=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char));)M   chroma2=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char)); J   luma=(unsigned char *) malloc((image->packets+1)*sizeof(unsigned char));,   if ((chroma1 == (unsigned char *) NULL) ||N       (chroma2 == (unsigned char *) NULL) || (luma == (unsigned char *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Advance to image data.   */   offset=93;   if (overview) 
     offset=2;    else     if (subimage == 2)       offset=20;     else       if (subimage == 1)         offset=1;-$   for (i=0; i < (offset*0x800); i++)     (void) fgetc(image->file);   if (overview)z     {,       Image          *overview_image;         MonitorHandler         handler;         register int
         j;         /*,         Read thumbnails from overview image.       */(       for (j=1; j <= number_images; j++)       {i9         handler=SetMonitorHandler((MonitorHandler) NULL); ?         (void) sprintf(image->filename,"images/img%04d.pcd",j); F         (void) sprintf(image->magick_filename,"images/img%04d.pcd",j);         image->scene=j;          image->columns=width;B         image->rows=height;(2         image->packets=image->columns*image->rows;)         image->pixels=(RunlengthPacket *) 9           malloc(image->packets*sizeof(RunlengthPacket));h6         if (image->pixels == (RunlengthPacket *) NULL);           PrematureExit("Unable to allocate memory",image);y         y=luma;w         c1=chroma1;          c2=chroma2;D#         for (i=0; i < height; i+=2)t	         {l:           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;:           (void) ReadData((char *) y,1,width,image->file);           y+=image->columns;@           (void) ReadData((char *) c1,1,width >> 1,image->file);           c1+=image->columns;o@           (void) ReadData((char *) c2,1,width >> 1,image->file);           c2+=image->columns;e	         }aN         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);N         Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);
         /*6           Transfer luminance and chrominance channels.
         */         p=image->pixels;         y=luma;          c1=chroma1;t         c2=chroma2;a*         for (i=0; i < image->packets; i++)	         {m           p->red=UpScale(*y++); "           p->green=UpScale(*c1++);!           p->blue=UpScale(*c2++);            p->index=0;p           p->length=0;           p++;	         }-/         TransformRGBImage(image,YCCColorspace);n         CompressImage(image);+         if (j < number_images)           {o             /*'               Allocate image structure.f             */2             image->next=AllocateImage(image_info);.             if (image->next == (Image *) NULL)               {-%                 DestroyImages(image);g'                 return((Image *) NULL);                } *             image->next->file=image->file;(             image->next->previous=image;             image=image->next;           } *         (void) SetMonitorHandler(handler);9         ProgressMonitor(LoadImageText,j-1,number_images);g       }        free(chroma2);       free(chroma1);       free(luma); /       while (image->previous != (Image *) NULL)i         image=image->previous;5       overview_image=OverviewImage(image_info,image);        return(overview_image);      }    /*     Allocate image pixels.   */#   image->pixels=(RunlengthPacket *)r3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);m   /*     Read interleaved image.r   */	   y=luma; 
   c1=chroma1; 
   c2=chroma2;m   for (i=0; i < height; i+=2)    {=4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;4     (void) ReadData((char *) y,1,width,image->file);     y+=image->columns;:     (void) ReadData((char *) c1,1,width >> 1,image->file);     c1+=image->columns;>:     (void) ReadData((char *) c2,1,width >> 1,image->file);     c2+=image->columns;    }    if (subimage >= 4)     {B       /*5         Recover luminance deltas for 1536x1024 image.G       */,       Upsample(768,512,image->columns,luma);/       Upsample(384,256,image->columns,chroma1);-/       Upsample(384,256,image->columns,chroma2);        image->rows=1024; #       for (i=0; i < (4*0x800); i++)p"         (void) fgetc(image->file);8       status=PCDDecodeImage(image,luma,chroma1,chroma2);$       if ((subimage >= 5) && status)	         {;           /*9             Recover luminance deltas for 3072x2048 image.*           */2           Upsample(1536,1024,image->columns,luma);3           Upsample(768,512,image->columns,chroma1);u3           Upsample(768,512,image->columns,chroma2);(           image->rows=2048;g-           offset=ftell(image->file)/0x800+12; 3           (void) fseek(image->file,offset*0x800,0);g<           status=PCDDecodeImage(image,luma,chroma1,chroma2);(           if ((subimage >= 6) && status)
             {l               /*I                 Recover luminance deltas for 6144x4096 image (vaporware).g               */6               Upsample(3072,2048,image->columns,luma);9               Upsample(1536,1024,image->columns,chroma1);i9               Upsample(1536,1024,image->columns,chroma2);e               image->rows=4096;%
             }%	         }%     }%H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma1);H   Upsample(image->columns >> 1,image->rows >> 1,image->columns,chroma2);   /*0     Transfer luminance and chrominance channels.   */   p=image->pixels;	   y=luma; 
   c1=chroma1; 
   c2=chroma2; $   for (i=0; i < image->packets; i++)   {      p->red=UpScale(*y++);      p->green=UpScale(*c1++);     p->blue=UpScale(*c2++);      p->index=0;      p->length=0;     p++;     if (QuantumTick(i,image)) 6       ProgressMonitor(LoadImageText,i,image->packets);   }    free(chroma2);   free(chroma1);
   free(luma); )   TransformRGBImage(image,YCCColorspace);%%   if ((rotate == 1) || (rotate == 3))%     {        double         degrees;         Images         *rotated_image;r         /*         Rotate image.        */)       degrees=rotate == 1 ? -90.0 : 90.0;        image->orphan=True;.:       rotated_image=RotateImage(image,degrees,False,True);       image->orphan=False;*       if (rotated_image != (Image *) NULL)	         {s           DestroyImage(image);           image=rotated_image;	         }      }    CompressImage(image);m   CloseImage(image);   return(image); }t   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             %eO %                                                                             %iO %                                                                             % O %  R e a d P C L I m a g e                                                    %nO %                                                                             %sO %                                                                             % O %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%V %aM %  Function ReadPCLImage reads a Page Control Language image file and returnspI %  it.  It allocates the memory necessary for the new Image structure andL& %  returns a pointer to the new image. % - %  The format of the ReadPCLImage routine is:r %H% %      image=ReadPCLImage(image_info)a %s+ %  A description of each parameter follows:_ %oI %    o image:  Function ReadPCLImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.e %nA %    o image_info: Specifies a pointer to an ImageInfo structure.a %e %  */7 static Image *ReadPCLImage(const ImageInfo *image_info)_ {e   Imaget     *image;r  9   Warning("Cannot read PCL images",image_info->filename);o"   image=ReadMIFFImage(image_info);   return(image); }C r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %nO %  R e a d P C X I m a g e                                                    %NO %                                                                             %eO %                                                                             % O %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i %eM %  Function ReadPCXImage reads a ZSoft IBM PC Paintbrush file and returns it.pL %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %e- %  The format of the ReadPCXImage routine is:  % % %      image=ReadPCXImage(image_info)* %S+ %  A description of each parameter follows:i %eI %    o image:  Function ReadPCXImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.s %PA %    o image_info: Specifies a pointer to an ImageInfo structure.u %i %- */7 static Image *ReadPCXImage(const ImageInfo *image_info)  {f   typedef struct _PCXHeaderr   {      unsigned charu       identifier,        version,       encoding,        bits_per_pixel;s  
     short intm       left,e
       top,       right,
       bottom,U       horizontal_resolution,       vertical_resolution;       unsigned char        reserved,r
       planes;t  
     short int        bytes_per_line,i       palette_info;n       unsigned charm       colormap_signature;_   } PCXHeader;     PCXHeader&     pcx_header;n     Image      *image;n     inti	     bits,i
     count,     id,a	     mask,(     packets,     pcx_packets;  	   Quantum 	     blue,e
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;*     register unsigned char     *p,      *r;      unsigned char)     packet,      *pcx_colormap,     *pcx_pixels,     *scanline;     unsigned int     status;0     unsigned longi     *page_table;     unsigned short
     index;     /*     Allocate image structure.g   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);p   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);n#   if (image->file == (FILE *) NULL)N/     PrematureExit("Unable to open file",image);.   /*$     Determine if this is a PCX file.   */$   page_table=(unsigned long *) NULL;,   if (strcmp(image_info->magick,"DCX") == 0)     {i       unsigned longy         magic;         /*          Read the DCX page table.       */*       magic=LSBFirstReadLong(image->file);       if (magic != 987654321)o4         PrematureExit("Not a DCX image file",image);F       page_table=(unsigned long *) malloc(1024*sizeof(unsigned long));/       if (page_table == (unsigned long *) NULL)r9         PrematureExit("Unable to allocate memory",image);o!       for (id=0; id < 1024; id++)        {n5         page_table[id]=LSBFirstReadLong(image->file);           if (page_table[id] == 0)           break;       }      } +   if (page_table != (unsigned long *) NULL) 5     (void) fseek(image->file,(long) page_table[0],0); C   status=ReadData((char *) &pcx_header.identifier,1,1,image->file);    for (id=1; id < 1024; id++)e   {s     /*       Verify PCX identifier.     */B     (void) ReadData((char *) &pcx_header.version,1,1,image->file);?     if ((status == False) || (pcx_header.identifier != 0x0a) || A         ((pcx_header.version != 2) && (pcx_header.version != 5))) 2       PrematureExit("Not a PCX image file",image);C     (void) ReadData((char *) &pcx_header.encoding,1,1,image->file);(I     (void) ReadData((char *) &pcx_header.bits_per_pixel,1,1,image->file);t3     pcx_header.left=LSBFirstReadShort(image->file); 2     pcx_header.top=LSBFirstReadShort(image->file);4     pcx_header.right=LSBFirstReadShort(image->file);5     pcx_header.bottom=LSBFirstReadShort(image->file); D     pcx_header.horizontal_resolution=LSBFirstReadShort(image->file);B     pcx_header.vertical_resolution=LSBFirstReadShort(image->file);     /*       Read PCX raster colormap.>     */8     image->columns=(pcx_header.right-pcx_header.left)+1;5     image->rows=(pcx_header.bottom-pcx_header.top)+1;*)     image->units=PixelsPerInchResolution;g9     image->x_resolution=pcx_header.horizontal_resolution;L7     image->y_resolution=pcx_header.vertical_resolution;*.     image->packets=image->columns*image->rows;     image->colors=16;lD     image->colormap=(ColorPacket *) malloc(256*sizeof(ColorPacket));G     pcx_colormap=(unsigned char *) malloc(3*256*sizeof(unsigned char)); 4     if ((image->colormap == (ColorPacket *) NULL) ||1         (pcx_colormap == (unsigned char *) NULL)) 7       PrematureExit("Unable to allocate memory",image);nG     (void) ReadData((char *) pcx_colormap,3,image->colors,image->file);      p=pcx_colormap; %     for (i=0; i < image->colors; i++)      { +       image->colormap[i].red=UpScale(*p++);f-       image->colormap[i].green=UpScale(*p++); ,       image->colormap[i].blue=UpScale(*p++);     }fC     (void) ReadData((char *) &pcx_header.reserved,1,1,image->file);kA     (void) ReadData((char *) &pcx_header.planes,1,1,image->file);oE     if ((pcx_header.bits_per_pixel != 8) || (pcx_header.planes == 1))=       image->class=PseudoClass;k=     pcx_header.bytes_per_line=LSBFirstReadShort(image->file);l;     pcx_header.palette_info=LSBFirstReadShort(image->file);m     for (i=0; i < 58; i++)        (void) fgetc(image->file);     /*       Read image data.     */     image->packets=0;D7     packets=Max((image->columns*image->rows+4) >> 3,1);o'     if (pcx_header.bits_per_pixel == 1)n9       packets=Max((image->columns*image->rows+8) >> 4,1);wN     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));H     pcx_packets=image->rows*pcx_header.bytes_per_line*pcx_header.planes;K     pcx_pixels=(unsigned char *) malloc(pcx_packets*sizeof(unsigned char));      scanline=(unsigned char *)E       malloc(image->columns*pcx_header.planes*sizeof(unsigned char));r6     if ((image->pixels == (RunlengthPacket *) NULL) ||1         (pcx_pixels == (unsigned char *) NULL) ||b-         (scanline == (unsigned char *) NULL))-7       PrematureExit("Unable to allocate memory",image);g     /*       Uncompress image data.     */     p=pcx_pixels;e     while (pcx_packets > 0)-     {y        packet=fgetc(image->file);"       if ((packet & 0xc0) != 0xc0)	         {            *p++=packet;           pcx_packets--;           continue;e	         }r       count=packet & 0x3f;9       for (packet=fgetc(image->file); count > 0; count--)p       {r         *p++=packet;         pcx_packets--;         if (pcx_packets == 0)n           break;       }=     }>$     if (image->class == DirectClass))       image->matte=pcx_header.planes > 3;s     else"       if (pcx_header.version == 5)	         {            /*&             Initialize image colormap.           */K           image->colors=1 << (pcx_header.bits_per_pixel*pcx_header.planes); "           if (image->colors > 256)D             PrematureExit("PCX colormap exceeded 256 colors",image);!           if (image->colors > 16)*
             {>               /*M                 256 color images have their color map at the end of the file.                */J               (void) ReadData((char *) &pcx_header.colormap_signature,1,1,                 image->file);dD               (void) ReadData((char *) pcx_colormap,3,image->colors,                 image->file);i               p=pcx_colormap;e/               for (i=0; i < image->colors; i++)0               {r5                 image->colormap[i].red=UpScale(*p++);i7                 image->colormap[i].green=UpScale(*p++);r6                 image->colormap[i].blue=UpScale(*p++);               }c
             }i           elseO             if (Intensity(image->colormap[0]) == Intensity(image->colormap[1]))C%               if (image->colors == 2)0                 {y                   /*(                     Monochrome colormap.                   */0                   image->colormap[0].red=MaxRGB;2                   image->colormap[0].green=MaxRGB;1                   image->colormap[0].blue=MaxRGB;)+                   image->colormap[1].red=0; -                   image->colormap[1].green=0;u,                   image->colormap[1].blue=0;                 } &           free((char *) pcx_colormap);	         }a     /*<       Convert PCX raster image to runlength-encoded packets.     */
     red=0;     green=0;     blue=0;m     index=0;     q=image->pixels;     q->length=MaxRunlength;r#     for (y=0; y < image->rows; y++)i     { C       p=pcx_pixels+(y*pcx_header.bytes_per_line*pcx_header.planes);,       r=scanline;m&       if (image->class == DirectClass)3         for (i=0; i < (int) pcx_header.planes; i++)p	         {u           r=scanline+i; 7           for (x=0; x < pcx_header.bytes_per_line; x++)            {              switch (i)
             {                case 0:i               { !                 *r=UpScale(*p++);t                 break;               },               case 1:e               {,!                 *r=UpScale(*p++);i                 break;               }                case 2:                { !                 *r=UpScale(*p++);                  break;               }                case 3:;               default:               {;!                 *r=UpScale(*p++);                  break;               } 
             } !             r+=pcx_header.planes;            }P	         }i
       else"         if (pcx_header.planes > 1)           { .             for (x=0; x < image->columns; x++)               *r++=0;_7             for (i=0; i < (int) pcx_header.planes; i++)r
             {                r=scanline;l;               for (x=0; x < pcx_header.bytes_per_line; x++)t               {e                  bits=(*p++); 5                  for (mask=0x80; mask != 0; mask>>=1)i                  {#                    if (bits & mask)e                       *r|=1 << i;                    r++;i                  }                }
             }            }          else,           switch (pcx_header.bits_per_pixel)           {%             case 1: 
             {                register int                 bit;  ;               for (x=0; x < ((int) image->columns-7); x+=8)                { ,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               } ,               if ((image->columns % 8) != 0)                 { E                   for (bit=7; bit >= (8-(image->columns % 8)); bit--) >                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }                break;
             }%             case 2:%
             {%;               for (x=0; x < ((int) image->columns-3); x+=4)s               {a%                 *r++=(*p >> 6) & 0x3;t%                 *r++=(*p >> 4) & 0x3;g%                 *r++=(*p >> 2) & 0x3;t                  *r++=(*p) & 0x3;                 p++;               } ,               if ((image->columns % 4) != 0)                 {a?                   for (i=3; i >= (4-(image->columns % 4)); i--)r.                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }                break;
             }              case 4: 
             {a;               for (x=0; x < ((int) image->columns-1); x+=2)                {a%                 *r++=(*p >> 4) & 0xf;_                  *r++=(*p) & 0xf;                 p++;               }d,               if ((image->columns % 2) != 0)'                 *r++=(*p++ >> 4) & 0xf;                break;
             };             case 8:g
             { 0               for (x=0; x < image->columns; x++)                 *r++=(*p++);               break;
             }g             default:               break;           }o       /*          Transfer image scanline.       */       r=scanline; (       for (x=0; x < image->columns; x++)       {n(         if (image->class == PseudoClass)           index=(*r++);i         else           {              red=UpScale(*r++);              green=UpScale(*r++);             blue=UpScale(*r++);              if (image->matte)g"               index=UpScale(*r++);           }4J         if ((red == q->red) && (green == q->green) && (blue == q->blue) &&D             (index == q->index) && ((int) q->length < MaxRunlength))           q->length++;         else           { $             if (image->packets != 0)               q++;             image->packets++;t*             if (image->packets == packets)               {g                 packets<<=1;B                 image->pixels=(RunlengthPacket *) realloc((char *)A                   image->pixels,packets*sizeof(RunlengthPacket));a>                 if (image->pixels == (RunlengthPacket *) NULL)                   {H,                     free((char *) scanline);E                     PrematureExit("Unable to allocate memory",image);a                   }r1                 q=image->pixels+image->packets-1;e               }%             q->red=red;%             q->green=green;%             q->blue=blue;              q->index=index;              q->length=0;           }        } 3       ProgressMonitor(LoadImageText,y,image->rows);      } $     if (image->class == PseudoClass)       {          SyncImage(image);           CompressColormap(image);       }      free((char *) scanline);     free((char *) pcx_pixels);E     image->pixels=(RunlengthPacket *) realloc((char *) image->pixels, .       image->packets*sizeof(RunlengthPacket));     /*       Proceed to next image.     */-     if (page_table == (unsigned long *) NULL)        break;     if (page_table[id] == 0)       break;6     (void) fseek(image->file,(long) page_table[id],0);E     status=ReadData((char *) &pcx_header.identifier,1,1,image->file);I<     if ((status == True) && (pcx_header.identifier == 0x0a))       {e
         /*#           Allocate image structure.e
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {r!             DestroyImages(image); #             return((Image *) NULL);t           }gB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }g   }s+   if (page_table != (unsigned long *) NULL)t     free((char *) page_table);+   while (image->previous != (Image *) NULL)p     image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %TO %                                                                             % O %                                                                             %nO %  R e a d P D F I m a g e                                                    %iO %                                                                             %iO %                                                                             %dO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%u %(H %  Function ReadPDFImage reads a Portable Document Format image file andM %  returns it.  It allocates the memory necessary for the new Image structurei* %  and returns a pointer to the new image. %t- %  The format of the ReadPDFImage routine is:e %l% %      image=ReadPDFImage(image_info)  %i+ %  A description of each parameter follows:  %iI %    o image:  Function ReadPDFImage returns a pointer to the image after0L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.) % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %u */7 static Image *ReadPDFImage(const ImageInfo *image_info)i {n #define MediaBox  "/MediaBox ["(     char     command[MaxTextExtent],      density[MaxTextExtent],      *device,     filename[MaxTextExtent],     options[MaxTextExtent],w'     postscript_filename[MaxTextExtent];=     FILE
     *file;     float      dx_resolution,     dy_resolution,     lower_x,     lower_y,     upper_x,     upper_y,     x_resolution,      y_resolution;      Imagei     *image,(     *next_image;     ImageInfo      local_info;k     intN
     count,     status;a  
   long int
     filesize;l     register char      *p;c     register int     c,     i;     unsigned int     height, 
     width;     /*     Allocate image structure.l   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Open temporary output file.    */)   TemporaryFilename(postscript_filename); 2   file=fopen(postscript_filename,WriteBinaryType);   if (file == (FILE *) NULL)0     PrematureExit("Unable to write file",image);   /*     Set the page geometry.   */   *options='\0';(   if (image_info->page != (char *) NULL)     {a#       (void) strcat(options," -g");i.       (void) strcat(options,image_info->page);     }    else     for (p=command; ; )s     {n       c=fgetc(image->file);        if (c == EOF)A         break;       (void) fputc(c,file);u
       *p++=c;oJ       if ((c != '\n') && (c != '\r') && ((p-command) < (MaxTextExtent-1)))         continue;t       *p='\0';       p=command;       /*5         Continue unless this is a MediaBox statement.n       */:       if (strncmp(MediaBox,command,Extent(MediaBox)) != 0)         continue;_G       count=sscanf(command,"/MediaBox [ %f %f %f %f",&lower_x,&lower_y,          &upper_x,&upper_y);a       if (count != 4)c         continue; 5       if ((lower_x > upper_x) || (lower_y > upper_y))          continue;d       /*         Determine bounding box.l       */       dx_resolution=72.0;i       dy_resolution=72.0;=       x_resolution=72.0;/       (void) strcpy(density,PSDensityGeometry); @       count=sscanf(density,"%fx%f",&x_resolution,&y_resolution);/       if (image_info->density != (char *) NULL)iN         count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2) "         y_resolution=x_resolution;,       if (image_info->page != (char *) NULL)         continue;r       /*'         Set Postscript render geometry.*       *//       width=(unsigned int) (upper_x-lower_x+1);_-       if ((float) ((int) upper_x) != upper_x)s         width++;0       height=(unsigned int) (upper_y-lower_y+1);-       if ((float) ((int) upper_y) != upper_y)s         height++;)'       (void) sprintf(options,"-g%ux%u", B         (unsigned int) (((width*x_resolution)/dx_resolution)+0.5),D         (unsigned int) (((height*y_resolution)/dy_resolution)+0.5));       break;     }m
   for ( ; ; )]   {n     c=fgetc(image->file);      if (c == EOF)b       break;     (void) fputc(c,file);    }t   if (ferror(file))e     {/K       Warning("An error has occurred writing to file",postscript_filename);k       (void) fclose(file);       return((Image *) NULL);      }k   (void) fclose(file);   CloseImage(image);   filesize=image->filesize;s   DestroyImage(image);   /*2     Determine if the density options is specified.   */   (void) strcat(options," -r"); +   if (image_info->density == (char *) NULL)L-     (void) strcat(options,PSDensityGeometry);U   else/     (void) strcat(options,image_info->density);)    if (image_info->subrange != 0)     {eO       (void) sprintf(options,"%s -dFirstPage=%u",options,image_info->subimage);tM       (void) sprintf(options,"%s -dLastPage=%u",options,image_info->subimage+a          image_info->subrange-1);     }m   /*0     Use Ghostscript to convert Postscript image.   */   device=PostscriptColorDevice;    if (image_info->monochrome)i      device=PostscriptMonoDevice;/   (void) strcpy(filename,image_info->filename);=   for (i=0; i < 50; i++)   {      /*$       Ghostscript eats % characters.     */,     TemporaryFilename(image_info->filename);:     if (strchr(image_info->filename,'%') == (char *) NULL)       break;   }fO   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,m     postscript_filename);.    status=SystemCommand(command);
   if (status)(     {        /*7         Pre GS 3.51 does not support the pnmraw device.a       */@       (void) sprintf(command,PostscriptCommand,"ppmraw",options,2         image_info->filename,postscript_filename);$       status=SystemCommand(command);     } 
   if (status)u     {)K       Warning("Portable Document translation failed",image_info->filename);q)       (void) remove(postscript_filename);t       return((Image *) NULL);      }    local_info=(*image_info);    image=ReadImage(&local_info);l%   (void) remove(postscript_filename);f&   (void) remove(image_info->filename);   if (image == (Image *) NULL)     { K       Warning("Portable Document translation failed",image_info->filename);_       return((Image *) NULL);      }    do   {p,     (void) strcpy(image->filename,filename);     image->filesize=filesize;      next_image=image->next;_%     if (next_image != (Image *) NULL).       image=next_image; )   } while (next_image != (Image *) NULL);l+   while (image->previous != (Image *) NULL)l     image=image->previous;   return(image); }. _ /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%pO %                                                                             %0O %                                                                             %*O %                                                                             %mO %  R e a d P I C T I m a g e                                                  %uO %                                                                             %lO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s %eL %  Function ReadPICTImage reads an Apple Macintosh QuickDraw/PICT image fileG %  and returns it.  It allocates the memory necessary for the new Imageo4 %  structure and returns a pointer to the new image. % . %  The format of the ReadPICTImage routine is: % & %      image=ReadPICTImage(image_info) %y+ %  A description of each parameter follows:  %oJ %    o image:  Function ReadPICTImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 static Image *ReadPICTImage(const ImageInfo *image_info) {    char     filename[MaxTextExtent];     Image      *image,      *next_image,     *proxy_image;      /*     Allocate image structure.    */(   proxy_image=AllocateImage(image_info);$   if (proxy_image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   OpenImage(image_info,proxy_image,ReadBinaryType); )   if (proxy_image->file == (FILE *) NULL) 5     PrematureExit("Unable to open file",proxy_image);%   CloseImage(proxy_image);   DestroyImage(proxy_image);   /*2     Use picttoppm to convert Macintosh PICT image.   *//   (void) strcpy(filename,image_info->filename);r<   (void) sprintf(image_info->filename,PICTCommand,filename);!   image=ReadPNMImage(image_info);    if (image == (Image *) NULL)     {g>       Warning("PICT translation failed",image_info->filename);       return((Image *) NULL);I     }t   /*     Assign proper filename.    */   do   {A,     (void) strcpy(image->filename,filename);     next_image=image->next; %     if (next_image != (Image *) NULL)i       image=next_image;n)   } while (next_image != (Image *) NULL);e+   while (image->previous != (Image *) NULL)n     image=image->previous;   return(image); }  f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%xO %                                                                             % O %                                                                             %hO %                                                                             %pO %  R e a d P L A S M A I m a g e                                              %oO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %.I %  Function ReadPLASMAImage creates a plasma fractal image.  The image is=E %  initialized to to the X server color as specified by the filename.* % 0 %  The format of the ReadPLASMAImage routine is: %a( %      image=ReadPLASMAImage(image_info) %f+ %  A description of each parameter follows:i %"L %    o image:  Function ReadPLASMAImage returns a pointer to the image afterL %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. %iA %    o image_info: Specifies a pointer to an ImageInfo structure.a %o %i */: static Image *ReadPLASMAImage(const ImageInfo *image_info) { 7 #define PlasmaImageText  "  Applying image plasma...  "  #define PlasmaPixel(x,y) \ { \m   p=PixelOffset(x,y); \*+   p->red=(Quantum) (rand() % (MaxRGB+1)); \*-   p->green=(Quantum) (rand() % (MaxRGB+1)); \ ,   p->blue=(Quantum) (rand() % (MaxRGB+1)); \ }l     Imagea     *image;h     register int     i;  
   SegmentInfoo     segment_info;      unsigned int
     depth,     max_depth;     /**     Recursively apply plasma to the image.   */'   image=ReadGRADATIONImage(image_info);c   if (image == (Image *) NULL)     return(image);   if (!UncompressImage(image))     return(image);   image->class=DirectClass; $   for (i=0; i < image->packets; i++)5     image->pixels[i].index=(Opaque-Transparent) >> 1;    segment_info.x1=0;   segment_info.y1=0;#   segment_info.x2=image->columns-1;'    segment_info.y2=image->rows-1;   srand(time(0)); 2   if (strcmp(image_info->filename,"fractal") == 0)     {        register RunlengthPacket         *p;,         /*%         Seed pixels before recursion.        */3       PlasmaPixel(segment_info.x1,segment_info.y1); G       PlasmaPixel(segment_info.x1,(segment_info.y1+segment_info.y2)/2); 3       PlasmaPixel(segment_info.x1,segment_info.y2);.G       PlasmaPixel((segment_info.x1+segment_info.x2)/2,segment_info.y1);>6       PlasmaPixel((segment_info.x1+segment_info.x2)/2,-         (segment_info.y1+segment_info.y2)/2); G       PlasmaPixel((segment_info.x1+segment_info.x2)/2,segment_info.y2);h3       PlasmaPixel(segment_info.x2,segment_info.y1); G       PlasmaPixel(segment_info.x2,(segment_info.y1+segment_info.y2)/2); 3       PlasmaPixel(segment_info.x2,segment_info.y2);      } )   i=Max(image->columns,image->rows) >> 1; (   for (max_depth=0; i != 0; max_depth++)
     i>>=1;   for (depth=1; ; depth++)   {f5     ProgressMonitor(PlasmaImageText,depth,max_depth);f1     if (PlasmaImage(image,&segment_info,0,depth))n       break;   }(   return(image); }   
 #ifdef HasPNGt /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %iO %  R e a d P N G I m a g e                                                    % O %                                                                             %aO %                                                                             % O %                                                                             %kO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %rI %  Function ReadPNGImage reads a Portable Network Graphics image file and M %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % - %  The format of the ReadPNGImage routine is:_ %n% %      image=ReadPNGImage(image_info)  %l+ %  A description of each parameter follows:  %gI %    o image:  Function ReadPNGImage returns a pointer to the image afterLL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.v %)A %    o image_info: Specifies a pointer to an ImageInfo structure.- %x %f */  > static void PNGError(png_struct *ping,png_const_charp message) {g!   Warning(message,(char *) NULL);m   longjmp(ping->jmpbuf,1); }   @ static void PNGWarning(png_struct *ping,png_const_charp message) {-!   Warning(message,(char *) NULL);. }S  7 static Image *ReadPNGImage(const ImageInfo *image_info)d {r #define PNGTextChunk(i,value) \m { \B*   length=ping_info->text[i].text_length; \   if (value != (char *) NULL) \ D     value=(char *) realloc((char *) value,strlen(value)+length+1); \   else \     { \m(       value=(char *) malloc(length+1); \#       if (value != (char *) NULL) \          *value='\0'; \     } \P   if (value == (char *) NULL) \*7     PrematureExit("Unable to allocate memory",image); \ 9   (void) strncat(value,ping_info->text[i].text,length); \    value[length]='\0'; \u }n  
   ColorPacket)     transparent_color;     Imagel     *image;,     register int     i,     x,     y;     register unsigned char     *p;i     register RunlengthPacket     *q;i  
   png_info     *end_info,     *ping_info;,     png_struct
     *ping;     unsigned chart     *png_pixels,     **scanlines;     unsigned int     length,m     packets;     unsigned short
     index,
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);i   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);B#   if (image->file == (FILE *) NULL)</     PrematureExit("Unable to open file",image);a   /*     Allocate the PNG structureso   */K   ping=png_create_read_struct(PNG_LIBPNG_VER_STRING,(void *) NULL,PNGError,U     PNGWarning);"   if (ping == (png_struct *) NULL)5     PrematureExit("Unable to allocate memory",image);c)   ping_info=png_create_info_struct(ping);r%   if (ping_info == (png_info *) NULL)r     { K       png_destroy_read_struct(&ping,(png_info **) NULL,(png_info **) NULL);g7       PrematureExit("Unable to allocate memory",image);l     }](   end_info=png_create_info_struct(ping);$   if (end_info == (png_info *) NULL)     {rC       png_destroy_read_struct(&ping,&ping_info,(png_info **) NULL); 7       PrematureExit("Unable to allocate memory",image);.     } )   image->pixels=(RunlengthPacket *) NULL; $   png_pixels=(unsigned char *) NULL;$   scanlines=(unsigned char **) NULL;   if (setjmp(ping->jmpbuf))      {        /*         PNG image is corrupt.y       */:       png_destroy_read_struct(&ping,&ping_info,&end_info);/       if (scanlines != (unsigned char **) NULL) !         free((char *) scanlines); /       if (png_pixels != (unsigned char *) NULL)*"         free((char *) png_pixels);       CloseImage(image);6       if ((image->columns == 0) || (image->rows == 0))	         {            DestroyImage(image);!           return((Image *) NULL); 	         }t       return(image);     }    /*     Prepare PNG for reading.   */    png_init_io(ping,image->file);    png_read_info(ping,ping_info);$   image->depth=ping_info->bit_depth;   if (ping_info->bit_depth < 8)p     { >       if ((ping_info->color_type != PNG_COLOR_TYPE_PALETTE) &&9           (ping_info->color_type != PNG_COLOR_TYPE_GRAY))          png_set_packing(ping);       image->depth=8;g     }>'   if (ping_info->valid & PNG_INFO_gAMA)o"     image->gamma=ping_info->gamma;'   if (ping_info->valid & PNG_INFO_pHYs)r     {e       /*         Set image resolution.        */7       image->x_resolution=ping_info->x_pixels_per_unit;U7       image->y_resolution=ping_info->y_pixels_per_unit;i<       if (ping_info->phys_unit_type == PNG_RESOLUTION_METER)	         {p5           image->units=PixelsPerCentimeterResolution; A           image->x_resolution=ping_info->x_pixels_per_unit/100.0;gA           image->y_resolution=ping_info->y_pixels_per_unit/100.0;l	         }      } '   if (ping_info->valid & PNG_INFO_bKGD)      {;       /*#         Set image background color.        */<       image->background_color.red=ping_info->background.red;@       image->background_color.green=ping_info->background.green;>       image->background_color.blue=ping_info->background.blue;.       if (ping_info->bit_depth > QuantumDepth)	         {-L           image->background_color.red=XDownScale(ping_info->background.red);P           image->background_color.green=XDownScale(ping_info->background.green);N           image->background_color.blue=XDownScale(ping_info->background.blue);	         }c     }r'   if (ping_info->valid & PNG_INFO_tRNS)      {        /*+         Image has a transparent background.r       */8       transparent_color.red=ping_info->trans_values.red;<       transparent_color.green=ping_info->trans_values.green;:       transparent_color.blue=ping_info->trans_values.blue;;       transparent_color.index=ping_info->trans_values.gray; .       if (ping_info->bit_depth > QuantumDepth)	         {iH           transparent_color.red=XDownScale(ping_info->trans_values.red);L           transparent_color.green=XDownScale(ping_info->trans_values.green);J           transparent_color.blue=XDownScale(ping_info->trans_values.blue);K           transparent_color.index=XDownScale(ping_info->trans_values.gray); 	         }      }l'   png_read_update_info(ping,ping_info);e   /*     Initialize image structure.)   */1   image->columns=(unsigned int) ping_info->width;n/   image->rows=(unsigned int) ping_info->height;a   image->packets=0;x5   packets=Max((image->columns*image->rows+4) >> 3,1);r    if (ping_info->bit_depth == 1)7     packets=Max((image->columns*image->rows+8) >> 4,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));   png_pixels=(unsigned char *)<     malloc(ping_info->rowbytes*image->rows*sizeof(Quantum));K   scanlines=(unsigned char **) malloc(image->rows*sizeof(unsigned char *)); 4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (png_pixels == (unsigned char *) NULL) || -       (scanlines == (unsigned char **) NULL)) 5     PrematureExit("Unable to allocate memory",image); :   if ((ping_info->color_type == PNG_COLOR_TYPE_PALETTE) ||5       (ping_info->color_type == PNG_COLOR_TYPE_GRAY))      {        /*"         Initialize image colormap.       */       image->class=PseudoClass; @       image->colors=1 << Min(ping_info->bit_depth,QuantumDepth);:       if (ping_info->color_type == PNG_COLOR_TYPE_PALETTE)-         image->colors=ping_info->num_palette;TP       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image);n'       for (i=0; i < image->colors; i++)        {aA         image->colormap[i].red=(MaxRGB*i)/Max(image->colors-1,1);AC         image->colormap[i].green=(MaxRGB*i)/Max(image->colors-1,1);sB         image->colormap[i].blue=(MaxRGB*i)/Max(image->colors-1,1);       }m:       if (ping_info->color_type == PNG_COLOR_TYPE_PALETTE))         for (i=0; i < image->colors; i++)t	         {nD           image->colormap[i].red=UpScale(ping_info->palette[i].red);H           image->colormap[i].green=UpScale(ping_info->palette[i].green);F           image->colormap[i].blue=UpScale(ping_info->palette[i].blue);	         }t     }    /*     Read image scanlines.    */!   for (i=0; i < image->rows; i++)a4     scanlines[i]=png_pixels+(i*ping_info->rowbytes);!   png_read_image(ping,scanlines);k   png_read_end(ping,ping_info);    /*4     Convert PNG pixels to runlength-encoded packets.   */   q=image->pixels;   q->length=MaxRunlength;g"   if (image->class == DirectClass)     {L
       Quantum(
         blue,          green,         red;         /*?         Convert image to DirectClass runlength-encoded packets.o       */@       if ((ping_info->color_type == PNG_COLOR_TYPE_RGB_ALPHA) ||A           (ping_info->color_type == PNG_COLOR_TYPE_GRAY_ALPHA) ||v-           (ping_info->valid & PNG_INFO_tRNS))e         image->matte=True;%       for (y=0; y < image->rows; y++)e       {>         p=scanlines[y];m*         for (x=0; x < image->columns; x++)	         {k           ReadQuantum(red,p);            green=red;           blue=red;NA           if (ping_info->color_type != PNG_COLOR_TYPE_GRAY_ALPHA) 
             {H#               ReadQuantum(green,p); "               ReadQuantum(blue,p);
             }a           index=Opaque;gD           if ((ping_info->color_type == PNG_COLOR_TYPE_RGB_ALPHA) ||C               (ping_info->color_type == PNG_COLOR_TYPE_GRAY_ALPHA))o!             ReadQuantum(index,p);u/           if (ping_info->valid & PNG_INFO_tRNS)p1             if ((red == transparent_color.red) &&75                 (green == transparent_color.green) &&s1                 (blue == transparent_color.blue))                 index=Transparent;L           if ((red == q->red) && (green == q->green) && (blue == q->blue) &&F               (index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             { &               if (image->packets != 0)                 q++;               image->packets++;h,               if (image->packets == packets)                 {a                   packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket));r@                   if (image->pixels == (RunlengthPacket *) NULL)                     {;0                       free((char *) png_pixels);G                       PrematureExit("Unable to allocate memory",image);(                     }r3                   q=image->pixels+image->packets-1;e                 }%               q->red=red;%               q->green=green;%               q->blue=blue;                q->index=index;                q->length=0;
             } 	         } 5         ProgressMonitor(LoadImageText,y,image->rows);        }      }    else     { 
       Quantum          *quantum_scanline;         register Quantum         *r;e         /*?         Convert image to PseudoClass runlength-encoded packets.        */J       quantum_scanline=(Quantum *) malloc(image->columns*sizeof(Quantum));/       if (quantum_scanline == (Quantum *) NULL) 9         PrematureExit("Unable to allocate memory",image); %       for (y=0; y < image->rows; y++)%       {%         p=scanlines[y];%         r=quantum_scanline; %         switch (ping_info->bit_depth)n	         {a           case 1:n           {              register int               bit;  9             for (x=0; x < ((int) image->columns-7); x+=8)g
             {f*               for (bit=7; bit >= 0; bit--):                 *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);               p++;
             } *             if ((image->columns % 8) != 0)               {iC                 for (bit=7; bit >= (8-(image->columns % 8)); bit--) <                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               }t             break;           }            case 2:*           {(9             for (x=0; x < ((int) image->columns-3); x+=4) 
             {n#               *r++=(*p >> 6) & 0x3; #               *r++=(*p >> 4) & 0x3;;#               *r++=(*p >> 2) & 0x3;q               *r++=(*p) & 0x3;               p++;
             }s*             if ((image->columns % 4) != 0)               { =                 for (i=3; i >= (4-(image->columns % 4)); i--)u,                   *r++=(*p >> (i*2)) & 0x03;                 p++;               }              break;           }            case 4:N           { 9             for (x=0; x < ((int) image->columns-1); x+=2)a
             { #               *r++=(*p >> 4) & 0xf;                *r++=(*p) & 0xf;               p++;
             }n*             if ((image->columns % 2) != 0)%               *r++=(*p++ >> 4) & 0xf;0             break;           }n           case 8:)           { .             for (x=0; x < image->columns; x++)               *r++=(*p++);             break;           }+           case 16:           {i.             for (x=0; x < image->columns; x++)
             {                 ReadQuantum(*r,p);               r++;
             }(             break;           }            default:             break;	         } 
         /*"           Transfer image scanline.
         */         r=quantum_scanline;)*         for (x=0; x < image->columns; x++)	         {            index=(*r++);pF           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             {a&               if (image->packets != 0)                 q++;               image->packets++; ,               if (image->packets == packets)                 {                    packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket));n@                   if (image->pixels == (RunlengthPacket *) NULL)                     {>6                       free((char *) quantum_scanline);G                       PrematureExit("Unable to allocate memory",image);e                     }t3                   q=image->pixels+image->packets-1;                  }                q->index=index;c               q->length=0;
             }i	         };5         ProgressMonitor(LoadImageText,y,image->rows);o       }(&       if (image->class == PseudoClass)         SyncImage(image); &       free((char *) quantum_scanline);+       if (ping_info->valid & PNG_INFO_tRNS)r	         {            /*/             Image has a transparent background.c           */#           image->class=DirectClass;a           image->matte=True;           q=image->pixels;,           for (i=0; i < image->packets; i++)           {0             index=q->index;v             q->index=Opaque;@             if (ping_info->color_type == PNG_COLOR_TYPE_PALETTE)               {h1                 if (index < ping_info->num_trans) <                   q->index=UpScale(ping_info->trans[index]);               }t             else3               if (index == transparent_color.index)p%                 q->index=Transparent;              q++;           } 	         }e     }u#   image->pixels=(RunlengthPacket *)-K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));    if (ping_info->num_text > 0)+     for (i=0; i < ping_info->num_text; i++)      { 8       if (strcmp(ping_info->text[i].key,"Comment") == 0)(         PNGTextChunk(i,image->comments);6       if (strcmp(ping_info->text[i].key,"Delay") == 0)	         {e           char             *delay;g             delay=(char *) NULL;            PNGTextChunk(i,delay);#           image->delay=atoi(delay);L           free(delay);	         } <       if (strcmp(ping_info->text[i].key,"Description") == 0)(         PNGTextChunk(i,image->comments);:       if (strcmp(ping_info->text[i].key,"Directory") == 0))         PNGTextChunk(i,image->directory); 6       if (strcmp(ping_info->text[i].key,"Label") == 0)%         PNGTextChunk(i,image->label);o8       if (strcmp(ping_info->text[i].key,"Montage") == 0)'         PNGTextChunk(i,image->montage);)6       if (strcmp(ping_info->text[i].key,"Scene") == 0)	         {m           char             *scene;a             scene=(char *) NULL;            PNGTextChunk(i,scene);#           image->scene=atoi(scene);r           free(scene);	         } :       if (strcmp(ping_info->text[i].key,"Signature") == 0))         PNGTextChunk(i,image->signature);;6       if (strcmp(ping_info->text[i].key,"Title") == 0)%         PNGTextChunk(i,image->label);/     }    /*     Free memory.   */6   png_destroy_read_struct(&ping,&ping_info,&end_info);   free((char *) png_pixels);   CloseImage(image);   return(image); }g #elseL7 static Image *ReadPNGImage(const ImageInfo *image_info)l {m?   Warning("PNG library is not available",image_info->filename); $   return(ReadMIFFImage(image_info)); }; #endif m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%0O %                                                                             %rO %                                                                             %%O %                                                                             % O %  R e a d P N M I m a g e                                                    % O %                                                                             % O %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadPNMImage reads a Portable Anymap image file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %%- %  The format of the ReadPNMImage routine is:  %F% %      image=ReadPNMImage(image_info)a %a+ %  A description of each parameter follows:a %cI %    o image:  Function ReadPNMImage returns a pointer to the image afteriL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.o % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %n %o */  D static unsigned int PNMInteger(Image *image,const unsigned int base) {m   intr     c;     unsigned int
     value;     /*      Skip any leading whitespace.   */   do   {e     c=fgetc(image->file);t     if (c == EOF)c       return(0);     if (c == '#')t       {e         register charo
           *p;            unsigned int           length;C  
         /*           Read comment.g
         */-         if (image->comments != (char *) NULL)            { +             length=Extent(image->comments);h%             p=image->comments+length;,           }          else           { !             length=MaxTextExtent; A             image->comments=(char *) malloc(length*sizeof(char));p             p=image->comments;           } 6         for ( ; image->comments != (char *) NULL; p++)	         {m.           if ((p-image->comments+2) >= length)
             {)               *p='\0';               length<<=1;m&               image->comments=(char *)F                 realloc((char *) image->comments,length*sizeof(char));3               if (image->comments == (char *) NULL)H                 break;8               p=image->comments+Extent(image->comments);
             }r           c=fgetc(image->file); (           if ((c == EOF) || (c == '\n'))             break;           *p=(unsigned char) c;t	         } -         if (image->comments == (char *) NULL)e           { =             Warning("Memory allocation error",(char *) NULL);              return(0);           }          *p++='\n';         *p='\0';       }d   } while (!isdigit(c));   if (base == 2)     return(c-'0');   /*     Evaluate number.   */
   value=0;   do   {=     value*=10;     value+=c-'0';;     c=fgetc(image->file);c     if (c == EOF)c       return(0);   }k   while (isdigit(c));r   return(value); }l  7 static Image *ReadPNMImage(const ImageInfo *image_info)R {e #define MaxRawValue  255     char     format;c     Image)     *image;      inti     y;  	   Quantumk     *scale;      register int     i,     x;     register RunlengthPacket     *q;x     unsigned int     max_value,     packets,     status;      unsigned short	     blue,p
     green,
     index,     red;     /*     Allocate image structure.d   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);g   /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL)e/     PrematureExit("Unable to open file",image);e   /*     Read PNM image.*   */4   status=ReadData((char *) &format,1,1,image->file);   do   {      /*       Verify PNM identifier.     */-     if ((status == False) || (format != 'P')) 2       PrematureExit("Not a PNM image file",image);     /*!       Initialize image structure.      */     format=fgetc(image->file);     if (format == '7')"       (void) PNMInteger(image,10);(     image->columns=PNMInteger(image,10);%     image->rows=PNMInteger(image,10);m*     if ((image->columns*image->rows) == 0)M       PrematureExit("Unable to read image: image dimensions are zero",image);b     image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1);l+     if ((format == '1') || (format == '4'))c9       packets=Max((image->columns*image->rows+8) >> 4,1);lN     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);0+     if ((format == '1') || (format == '4'))         max_value=1;  /* bitmap */     else%       max_value=PNMInteger(image,10);      scale=(Quantum *) NULL; +     if ((format != '3') && (format != '6'))o       {d
         /*           Create colormap.
         */!         image->class=PseudoClass; .         image->colors=Min(max_value,MaxRGB)+1;'         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);e         if (format != '7')+           for (i=0; i < image->colors; i++)i           {a@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);)           }          else           {              /*&               Initialize 332 colormap.             */             i=0;'             for (red=0; red < 8; red++)r/               for (green=0; green < 8; green++) .                 for (blue=0; blue < 4; blue++)                 {GB                   image->colormap[i].red=(Quantum) (red*MaxRGB)/7;F                   image->colormap[i].green=(Quantum) (green*MaxRGB)/7;D                   image->colormap[i].blue=(Quantum) (blue*MaxRGB)/3;                   i++;                 }N           }e       }e     if (max_value != MaxRGB)       {h
         /*&           Compute pixel scaling table.
         */@         scale=(Quantum *) malloc((max_value+1)*sizeof(Quantum));&         if (scale == (Quantum *) NULL);           PrematureExit("Unable to allocate memory",image);a&         for (i=0; i <= max_value; i++)E           scale[i]=(Quantum) ((i*MaxRGB+(max_value >> 1))/max_value);-       },     /*;       Convert PNM pixels to runlength-encoded MIFF packets.      */     q=image->pixels;     q->length=MaxRunlength;      switch (format);     {t       case '1':i       {e
         /*9           Convert PBM image to runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++)a	         {e,           for (x=0; x < image->columns; x++)           { '             index=!PNMInteger(image,2);oH             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;v.                 if (image->packets == packets)                   {g                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);n5                     q=image->pixels+image->packets-1;i                   }l                 q->index=index;i                 q->length=0;               }%           }%7           ProgressMonitor(LoadImageText,y,image->rows); 	         }          break;       }        case '2':        { 
         /*9           Convert PGM image to runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++) 	         { ,           for (x=0; x < image->columns; x++)           {G'             index=PNMInteger(image,10); *             if (scale != (Quantum *) NULL)!               index=scale[index]; H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;%.                 if (image->packets == packets)                   {H                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));aB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);i5                     q=image->pixels+image->packets-1;                    }                  q->index=index;r                 q->length=0;               }i           }a7           ProgressMonitor(LoadImageText,y,image->rows);r	         }e         break;       }        case '3':*       {G
         /*9           Convert PNM image to runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++) 	         {%,           for (x=0; x < image->columns; x++)           {%%             red=PNMInteger(image,10); '             green=PNMInteger(image,10); &             blue=PNMInteger(image,10);*             if (scale != (Quantum *) NULL)               {                  red=scale[red]; #                 green=scale[green]; !                 blue=scale[blue];g               } N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))                q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;%.                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));gB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);l5                     q=image->pixels+image->packets-1;n                   }a                 q->red=red;n                 q->green=green;                  q->blue=blue;i                 q->index=0;                  q->length=0;
             }            }s7           ProgressMonitor(LoadImageText,y,image->rows); 	         }i$         (void) IsPseudoClass(image);         break;       }d       case '4':g       {i         unsigned charI           bit,           byte;a           unsigned int           x,           y;  
         /*=           Convert PBM raw image to runlength-encoded packets. 
         */'         for (y=0; y < image->rows; y++) 	         {            bit=0;           byte=0; ,           for (x=0; x < image->columns; x++)           {              if (bit == 0) &               byte=fgetc(image->file);(             index=(byte & 0x80) ? 0 : 1;H             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {%                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));eB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);I5                     q=image->pixels+image->packets-1;r                   }o                 q->index=index;e                 q->length=0;               }i             bit++;             if (bit == 8)e               bit=0;             byte<<=1;b           } 7           ProgressMonitor(LoadImageText,y,image->rows);r	         }          break;       }e       case '5':        case '7':i       { 
         /*=           Convert PGM raw image to runlength-encoded packets.s
         */'         for (y=0; y < image->rows; y++)t	         {h,           for (x=0; x < image->columns; x++)           { )             if (max_value <= MaxRawValue)i'               index=fgetc(image->file);e             else3               index=LSBFirstReadShort(image->file);eH             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {m(                 if (image->packets != 0)                   q++;!                 image->packets++;f.                 if (image->packets == packets)                   {g                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));5B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image); 5                     q=image->pixels+image->packets-1;j                   }n                 q->index=index;                  q->length=0;               }(           }u7           ProgressMonitor(LoadImageText,y,image->rows); 	         };         break;       }n       case '6':(       {0
         /*@           Convert PNM raster image to runlength-encoded packets.
         */'         for (y=0; y < image->rows; y++)t	         {e,           for (x=0; x < image->columns; x++)           {()             if (max_value <= MaxRawValue)i               { '                 red=fgetc(image->file);_)                 green=fgetc(image->file);u(                 blue=fgetc(image->file);               }e             else               {n3                 red=LSBFirstReadShort(image->file);h5                 green=LSBFirstReadShort(image->file);f4                 blue=LSBFirstReadShort(image->file);               } *             if (scale != (Quantum *) NULL)               {/                 red=scale[red]; #                 green=scale[green];C!                 blue=scale[blue];s               })N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))d               q->length++;             else               {=(                 if (image->packets != 0)                   q++;!                 image->packets++;a.                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);=7                       q=image->pixels+image->packets-1;(                   }R                 q->red=red;+                 q->green=green;                  q->blue=blue;                  q->index=0;g                 q->length=0;               }            } 7           ProgressMonitor(LoadImageText,y,image->rows);g	         }R$         (void) IsPseudoClass(image);         break;       }        default:4         PrematureExit("Not a PNM image file",image);     }u"     if (scale != (Quantum *) NULL)       free((char *) scale);_$     if (image->class == PseudoClass)       {t         SyncImage(image);           CompressColormap(image);       } %     image->pixels=(RunlengthPacket *)1M       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));      /*       Proceed to next image.     */>     if ((format == '1') || (format == '2') || (format == '3'))       do       {)
         /*           Skip to end of line.
         */1         status=ReadData(&format,1,1,image->file);l         if (status == False)           break;       } while (format != '\n');e6     status=ReadData((char *) &format,1,1,image->file);,     if ((status == True) && (format == 'P'))       {(
         /*#           Allocate image structure.a
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {f!             DestroyImages(image);%#             return((Image *) NULL);%           }%B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } 0   } while ((status == True) && (format == 'P'));+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %%O %                                                                             %lO %  R e a d P S I m a g e                                                      %tO %                                                                             %EO %                                                                             %iO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i % O %  Function ReadPSImage reads a Adobe Postscript image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % , %  The format of the ReadPSImage routine is: %t$ %      image=ReadPSImage(image_info) %>+ %  A description of each parameter follows:t %fH %    o image:  Function ReadPSImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.. %  %  */6 static Image *ReadPSImage(const ImageInfo *image_info) {j% #define BoundingBox  "%%BoundingBox:"c) #define DocumentMedia  "%%DocumentMedia:"e- #define PageBoundingBox  "%%PageBoundingBox:"      char     command[MaxTextExtent],m     density[MaxTextExtent],;     *device,     filename[MaxTextExtent],     options[MaxTextExtent],d'     postscript_filename[MaxTextExtent],f&     translate_geometry[MaxTextExtent];     FILE
     *file;     float      dx_resolution,     dy_resolution,     lower_x,     lower_y,     upper_x,     upper_y,     x_resolution,      y_resolution;      Image      *image,e     *next_image;     ImageInfox     local_info;n     inth     c,
     count,     status;t  
   long int
     filesize;'     register char)     *p;      register int     i;     unsigned int     height, 
     width;     /*     Allocate image structure.t   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);(   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);g#   if (image->file == (FILE *) NULL)=/     PrematureExit("Unable to open file",image);e   /*     Open temporary output file.+   */)   TemporaryFilename(postscript_filename);e2   file=fopen(postscript_filename,WriteBinaryType);   if (file == (FILE *) NULL)0     PrematureExit("Unable to write file",image);O   (void) sprintf(translate_geometry,"%f %f translate\n              ",0.0,0.0);g(   (void) fputs(translate_geometry,file);   /*     Set the page geometry.   */   lower_x=0;   lower_y=0;   dx_resolution=72.0;n   dy_resolution=72.0;r   x_resolution=72.0;+   (void) strcpy(density,PSDensityGeometry); <   count=sscanf(density,"%fx%f",&x_resolution,&y_resolution);+   if (image_info->density != (char *) NULL)tJ     count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);   if (count != 2)e     y_resolution=x_resolution;   *options='\0';(   if (image_info->page != (char *) NULL)     {=	       intN
         x,
         y;         /*         Set page geometry.       */A       (void) XParseGeometry(PSPageGeometry,&x,&y,&width,&height);IC       (void) XParseGeometry(image_info->page,&x,&y,&width,&height); '       (void) sprintf(options,"-g%ux%u", B         (unsigned int) (((width*x_resolution)/dx_resolution)+0.5),D         (unsigned int) (((height*y_resolution)/dy_resolution)+0.5));     }R   else     for (p=command; ; )p     {J       c=fgetc(image->file);p       if (c == EOF)          break;       (void) fputc(c,file);.
       *p++=c; J       if ((c != '\n') && (c != '\r') && ((p-command) < (MaxTextExtent-1)))         continue;        *p='\0';       p=command;       /*'         Parse a bounding box statement.        */       count=0;@       if (strncmp(BoundingBox,command,Extent(BoundingBox)) == 0)N         count=sscanf(command,"%%%%BoundingBox: %f %f %f %f",&lower_x,&lower_y,           &upper_x,&upper_y);eD       if (strncmp(DocumentMedia,command,Extent(DocumentMedia)) == 0)         count=M           sscanf(command,"%%%%DocumentMedia: %*s %f %f",&upper_x,&upper_y)+2;sH       if (strncmp(PageBoundingBox,command,Extent(PageBoundingBox)) == 0)@         count=sscanf(command,"%%%%PageBoundingBox: %f %f %f %f",/           &lower_x,&lower_y,&upper_x,&upper_y);        if (count != 4)e         continue; 5       if ((lower_x > upper_x) || (lower_y > upper_y))          continue;i       /*'         Set Postscript render geometry.n       */O       (void) sprintf(translate_geometry,"%f %f translate\n",-lower_x,-lower_y);./       width=(unsigned int) (upper_x-lower_x+1);e-       if ((float) ((int) upper_x) != upper_x).         width++;0       height=(unsigned int) (upper_y-lower_y+1);-       if ((float) ((int) upper_y) != upper_y)g         height++;_'       (void) sprintf(options,"-g%ux%u",(B         (unsigned int) (((width*x_resolution)/dx_resolution)+0.5),D         (unsigned int) (((height*y_resolution)/dy_resolution)+0.5));       break;     }t
   for ( ; ; )    {t     c=fgetc(image->file);r     if (c == EOF)f       break;     (void) fputc(c,file);_   }r   if (ferror(file))t     {gK       Warning("An error has occurred writing to file",postscript_filename);g       (void) fclose(file);       return((Image *) NULL);_     }    (void) fseek(file,0,0);h(   (void) fputs(translate_geometry,file);   (void) fclose(file);   CloseImage(image);   filesize=image->filesize;t   DestroyImage(image);   /*.     Determine if density options is specified.   */   (void) strcat(options," -r");p+   if (image_info->density == (char *) NULL)g-     (void) strcat(options,PSDensityGeometry);h   else/     (void) strcat(options,image_info->density);g   /*0     Use Ghostscript to convert Postscript image.   */   device=PostscriptColorDevice;    if (image_info->monochrome)g      device=PostscriptMonoDevice;/   (void) strcpy(filename,image_info->filename);U   for (i=0; i < 50; i++)   {)     /*$       Ghostscript eats % characters.     */,     TemporaryFilename(image_info->filename);:     if (strchr(image_info->filename,'%') == (char *) NULL)       break;   }5O   (void) sprintf(command,PostscriptCommand,device,options,image_info->filename,)     postscript_filename);a    status=SystemCommand(command);
   if (status)(     {        /*7         Pre GS 3.51 does not support the pnmraw device.+       */@       (void) sprintf(command,PostscriptCommand,"ppmraw",options,2         image_info->filename,postscript_filename);$       status=SystemCommand(command);     } *   if (!IsAccessible(image_info->filename))     {s       /*1         Ghostscript requires a showpage operator.n       */*       file=fopen(postscript_filename,"a");        if (file == (FILE *) NULL)4         PrematureExit("Unable to write file",image);&       (void) fputs("showpage\n",file);       (void) fclose(file);$       status=SystemCommand(command);     }f*   if (!IsAccessible(image_info->filename))     {        /*:         It's possible that the -g option caused a problem.       */"       (void) strcpy(options,"-r");/       if (image_info->density == (char *) NULL) 1         (void) strcat(options,PSDensityGeometry);t
       else3         (void) strcat(options,image_info->density);A>       (void) sprintf(command,PostscriptCommand,device,options,2         image_info->filename,postscript_filename);$       status=SystemCommand(command);     }}%   (void) remove(postscript_filename);o
   if (status)=     {R       /*F         Ghostscript has failed-- try the Display Postscript Extension.       */3       (void) strcpy(image_info->filename,filename);g%       image=ReadDPSImage(image_info);)"       if (image != (Image *) NULL)         return(image);D       Warning("Postscript translation failed",image_info->filename);       return((Image *) NULL);S     }p   local_info=(*image_info);f   image=ReadImage(&local_info);S&   (void) remove(image_info->filename);   if (image == (Image *) NULL)     {dD       Warning("Postscript translation failed",image_info->filename);       return((Image *) NULL);n     }    do   { ,     (void) strcpy(image->filename,filename);     image->filesize=filesize;t     next_image=image->next; %     if (next_image != (Image *) NULL)        image=next_image; )   } while (next_image != (Image *) NULL);r+   while (image->previous != (Image *) NULL)e     image=image->previous;   return(image); }l t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%-O %                                                                             %gO %                                                                             % O %                                                                             %sO %  R e a d R A D I A N C E I m a g e                                          %PO %                                                                             % O %                                                                             %tO %                                                                             %=O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %-I %  Function ReadRADIANCEImage reads a RADIANCE image file and returns it. L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %R2 %  The format of the ReadRADIANCEImage routine is: %i* %      image=ReadRADIANCEImage(image_info) %(+ %  A description of each parameter follows:y %mN %    o image:  Function ReadRADIANCEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.n %;A %    o image_info: Specifies a pointer to an ImageInfo structure.* %d %G */< static Image *ReadRADIANCEImage(const ImageInfo *image_info) {t   char     command[MaxTextExtent],      filename[MaxTextExtent];     Imagee     *image,      *next_image;     int%     status;%     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);e   CloseImage(image);   /*)     Use ra_ppm to convert RADIANCE image.    *//   (void) strcpy(filename,image_info->filename); *   TemporaryFilename(image_info->filename);N   (void) sprintf(command,"ra_ppm -g 1.0 %s %s",filename,image_info->filename);    status=SystemCommand(command);
   if (status)%7     PrematureExit("RADIANCE translation failed",image);%   DestroyImage(image);!   image=ReadPNMImage(image_info); &   (void) remove(image_info->filename);   if (image == (Image *) NULL)7     PrematureExit("RADIANCE translation failed",image);    /*     Assign proper filename.f   */   do   {e,     (void) strcpy(image->filename,filename);     next_image=image->next;i%     if (next_image != (Image *) NULL)        image=next_image;O)   } while (next_image != (Image *) NULL);r+   while (image->previous != (Image *) NULL)f     image=image->previous;   return(image); }m   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %"O %                                                                             % O %                                                                             %gO %  R e a d R G B I m a g e                                                    %tO %                                                                             %eO %                                                                             %oO %                                                                             %=O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%) % M %  Function ReadRGBImage reads an image of raw red, green, and blue bytes and M %  returns it.  It allocates the memory necessary for the new Image structure;* %  and returns a pointer to the new image. % - %  The format of the ReadRGBImage routine is:  %i% %      image=ReadRGBImage(image_info)  % + %  A description of each parameter follows:A %rI %    o image:  Function ReadRGBImage returns a pointer to the image aftereL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %eA %    o image_info: Specifies a pointer to an ImageInfo structure.  %m %= */7 static Image *ReadRGBImage(const ImageInfo *image_info)  {f   Image=     *image;L     intv
     count,     x,
     x_offset,n     y,
     y_offset;)     register int     i;     register RunlengthPacket     *q;%     register unsigned char     *p;%     unsigned char%     *scanline;     unsigned int     height,      packet_size,
     width;     unsigned short
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; 
   x_offset=0; 
   y_offset=0;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height); 2   if (image_info->interlace != PartitionInterlace)     {        /*         Open image file.       */1       OpenImage(image_info,image,ReadBinaryType);%'       if (image->file == (FILE *) NULL)I3         PrematureExit("Unable to open file",image);i       for (i=0; i < x; i++)."         (void) fgetc(image->file);     }    /*#     Allocate memory for a scanline.t   */$   packet_size=3*(image->depth >> 3);-   if (strcmp(image_info->magick,"RGBA") == 0)R     {m       image->matte=True;(       packet_size=4*(image->depth >> 3);     } M   scanline=(unsigned char *) malloc(packet_size*width*sizeof(unsigned char));r)   if (scanline == (unsigned char *) NULL)i5     PrematureExit("Unable to allocate memory",image);     if (image_info->subrange != 0)/     while (image->scene < image_info->subimage)      {        /*         Skip to next image.n       */       image->scene++;         for (y=0; y < height; y++)I         (void) ReadData((char *) scanline,packet_size,width,image->file);n     }    do   {r     /*!       Initialize image structure.a     */     image->columns=width;;     image->rows=height; "     if (image_info->subrange == 0),       if (image_info->tile != (char *) NULL)C         (void) XParseGeometry(image_info->tile,&x_offset,&y_offset, (           &image->columns,&image->rows);.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)t5       malloc(image->packets*sizeof(RunlengthPacket));m2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*8       Convert raster image to runlength-encoded packets.     */"     switch (image_info->interlace)     {)       case NoneInterlace:a       default:       {m
         /*0           No interlacing:  RGBRGBRGBRGBRGBRGB...
         */$         for (y=0; y < y_offset; y++)K           (void) ReadData((char *) scanline,packet_size,width,image->file);a         q=image->pixels;'         for (y=0; y < image->rows; y++) 	         {e=           if ((y > 0) || (image->previous == (Image *) NULL))=M             (void) ReadData((char *) scanline,packet_size,width,image->file);e*           p=scanline+packet_size*x_offset;,           for (x=0; x < image->columns; x++)           {("             ReadQuantum(q->red,p);$             ReadQuantum(q->green,p);#             ReadQuantum(q->blue,p);c             q->index=0;*             if (image->matte)/&               ReadQuantum(q->index,p);             q->length=0;             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows);u	         }l         break;       }d       case LineInterlace:g       { 
         /*A           Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB... 
         */&         packet_size=image->depth >> 3;$         for (y=0; y < y_offset; y++)K           (void) ReadData((char *) scanline,packet_size,width,image->file);s'         for (y=0; y < image->rows; y++)m	         {_=           if ((y > 0) || (image->previous == (Image *) NULL))iM             (void) ReadData((char *) scanline,packet_size,width,image->file);U*           p=scanline+packet_size*x_offset;+           q=image->pixels+y*image->columns;i,           for (x=0; x < image->columns; x++)           {-"             ReadQuantum(q->red,p);             q->index=0;s             q->length=0;             q++;           }eK           (void) ReadData((char *) scanline,packet_size,width,image->file);;*           p=scanline+packet_size*x_offset;+           q=image->pixels+y*image->columns;%,           for (x=0; x < image->columns; x++)           { $             ReadQuantum(q->green,p);             q++;           } K           (void) ReadData((char *) scanline,packet_size,width,image->file); *           p=scanline+packet_size*x_offset;+           q=image->pixels+y*image->columns;g,           for (x=0; x < image->columns; x++)           { #             ReadQuantum(q->blue,p);              q++;           }            if (image->matte) 
             { O               (void) ReadData((char *) scanline,packet_size,width,image->file); .               p=scanline+packet_size*x_offset;/               q=image->pixels+y*image->columns;%0               for (x=0; x < image->columns; x++)               {m(                 ReadQuantum(q->index,p);                 q++;               }t
             }r7           ProgressMonitor(LoadImageText,y,image->rows); 	         }          break;       }t       case PlaneInterlace:       case PartitionInterlace:       {r         unsigned int           span;   
         /*9           Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...e
         */8         if (image_info->interlace == PartitionInterlace)           { 3             AppendImageFormat("R",image->filename);i7             OpenImage(image_info,image,ReadBinaryType); -             if (image->file == (FILE *) NULL)e9               PrematureExit("Unable to open file",image);            }f&         packet_size=image->depth >> 3;$         for (y=0; y < y_offset; y++)K           (void) ReadData((char *) scanline,packet_size,width,image->file);          i=0;0         span=image->rows*(image->matte ? 4 : 3);         q=image->pixels;'         for (y=0; y < image->rows; y++)u	         { =           if ((y > 0) || (image->previous == (Image *) NULL))gM             (void) ReadData((char *) scanline,packet_size,width,image->file); *           p=scanline+packet_size*x_offset;,           for (x=0; x < image->columns; x++)           { "             ReadQuantum(q->red,p);             q->index=0;*             q->length=0;             q++;           } 2           ProgressMonitor(LoadImageText,i++,span);	         }f8         if (image_info->interlace == PartitionInterlace)           {X             CloseImage(image);3             AppendImageFormat("G",image->filename); 7             OpenImage(image_info,image,ReadBinaryType);t-             if (image->file == (FILE *) NULL)T9               PrematureExit("Unable to open file",image);a           }g         q=image->pixels;0         for (y=0; y < (height-image->rows); y++)K           (void) ReadData((char *) scanline,packet_size,width,image->file); '         for (y=0; y < image->rows; y++)&	         {_K           (void) ReadData((char *) scanline,packet_size,width,image->file);t*           p=scanline+packet_size*x_offset;,           for (x=0; x < image->columns; x++)           {o$             ReadQuantum(q->green,p);             q++;           } 2           ProgressMonitor(LoadImageText,i++,span);	         }r8         if (image_info->interlace == PartitionInterlace)           {a             CloseImage(image);3             AppendImageFormat("B",image->filename);a7             OpenImage(image_info,image,ReadBinaryType); -             if (image->file == (FILE *) NULL) 9               PrematureExit("Unable to open file",image);t           }a         q=image->pixels;0         for (y=0; y < (height-image->rows); y++)K           (void) ReadData((char *) scanline,packet_size,width,image->file); '         for (y=0; y < image->rows; y++) 	         { K           (void) ReadData((char *) scanline,packet_size,width,image->file);m*           p=scanline+packet_size*x_offset;,           for (x=0; x < image->columns; x++)           {k#             ReadQuantum(q->blue,p);a             q++;           }-2           ProgressMonitor(LoadImageText,i++,span);	         }          if (image->matte)f           {k             /*!               Read matte channel.t             */<             if (image_info->interlace == PartitionInterlace)               { "                 CloseImage(image);7                 AppendImageFormat("A",image->filename);m;                 OpenImage(image_info,image,ReadBinaryType);r1                 if (image->file == (FILE *) NULL);=                   PrematureExit("Unable to open file",image);                }g             q=image->pixels;4             for (y=0; y < (height-image->rows); y++)O               (void) ReadData((char *) scanline,packet_size,width,image->file); +             for (y=0; y < image->rows; y++)e
             {aO               (void) ReadData((char *) scanline,packet_size,width,image->file);%.               p=scanline+packet_size*x_offset;0               for (x=0; x < image->columns; x++)               { (                 ReadQuantum(q->index,p);                 q++;               } 6               ProgressMonitor(LoadImageText,i++,span);
             }            } 8         if (image_info->interlace == PartitionInterlace)>           (void) strcpy(image->filename,image_info->filename);         break;       }      }      CompressImage(image); "     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;     /*       Proceed to next image.     */D     count=ReadData((char *) scanline,packet_size,width,image->file);     if (count > 0)       { 
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image);m#             return((Image *) NULL);m           } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }i   } while (count > 0);+   while (image->previous != (Image *) NULL)e     image=image->previous;   free((char *) scanline);   CloseImage(image);   return(image); }x t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             % O %                                                                             %uO %                                                                             % O %  R e a d R L A I m a g e                                                    %nO %                                                                             %iO %                                                                             %eO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%L % L %  Function ReadRLAImage reads a run-length encoded Wavefront RLA image fileG %  and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. %iO %  Note:  This module was contributed by Lester Vecsey (master@internexus.net).  % - %  The format of the ReadRLAImage routine is:  %/% %      image=ReadRLAImage(image_info)r % + %  A description of each parameter follows:E %nI %    o image:  Function ReadRLAImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.l %(A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadRLAImage(const ImageInfo *image_info)  {    typedef struct _WindowFramef   { 	     short        left,O       right,
       bottom, 
       top;   } WindowFrame;     typedef struct _RLAHeader    {      WindowFrame 
       window,0       active_window;  	     short        frame,       storage_type,        number_channels,       number_matte_channels,        number_auxillary_channels,       revision;c       char       gamma[16],       red_primary[24],       green_primary[24],       blue_primary[24],m       white_point[24];       long       job_number;)       char       name[128],       description[128],h       program[64],       machine[32],       user[32],t       date[20],        aspect[24],;       aspect_ratio[8],       chan[32];   	     shortl       field;       char       time[12],        filter[32];   	     shorte       bits_per_channel,a       matte_type,/       matte_bits,w       auxillary_type,        auxillary_bits;        char       auxillary[32],       space[36];       long       next;    } RLAHeader;     Imagel     *image;      intl     length,)     runlength,     y;     long     *scanlines;e     register int     i;     register RunlengthPacket     *q;      RLAHeader      rla_header;=     unsigned char 	     byte;s     unsigned int     channel;     /*     Allocate image structure.e   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);l#   if (image->file == (FILE *) NULL)'/     PrematureExit("Unable to open file",image); 8   rla_header.window.left=MSBFirstReadShort(image->file);9   rla_header.window.right=MSBFirstReadShort(image->file); :   rla_header.window.bottom=MSBFirstReadShort(image->file);7   rla_header.window.top=MSBFirstReadShort(image->file);c?   rla_header.active_window.left=MSBFirstReadShort(image->file);l@   rla_header.active_window.right=MSBFirstReadShort(image->file);A   rla_header.active_window.bottom=MSBFirstReadShort(image->file); >   rla_header.active_window.top=MSBFirstReadShort(image->file);2   rla_header.frame=MSBFirstReadShort(image->file);9   rla_header.storage_type=MSBFirstReadShort(image->file); <   rla_header.number_channels=MSBFirstReadShort(image->file);&   if (rla_header.number_channels == 0)!     rla_header.number_channels=3;eB   rla_header.number_matte_channels=MSBFirstReadShort(image->file);F   rla_header.number_auxillary_channels=MSBFirstReadShort(image->file);5   rla_header.revision=MSBFirstReadShort(image->file);l>   (void) ReadData((char *) rla_header.gamma,16,1,image->file);D   (void) ReadData((char *) rla_header.red_primary,24,1,image->file);F   (void) ReadData((char *) rla_header.green_primary,24,1,image->file);E   (void) ReadData((char *) rla_header.blue_primary,24,1,image->file);iD   (void) ReadData((char *) rla_header.white_point,24,1,image->file);=   rla_header.job_number=(long) MSBFirstReadLong(image->file);e>   (void) ReadData((char *) rla_header.name,128,1,image->file);E   (void) ReadData((char *) rla_header.description,128,1,image->file);g@   (void) ReadData((char *) rla_header.program,64,1,image->file);@   (void) ReadData((char *) rla_header.machine,32,1,image->file);=   (void) ReadData((char *) rla_header.user,32,1,image->file); =   (void) ReadData((char *) rla_header.date,20,1,image->file);e?   (void) ReadData((char *) rla_header.aspect,24,1,image->file);*D   (void) ReadData((char *) rla_header.aspect_ratio,8,1,image->file);=   (void) ReadData((char *) rla_header.chan,32,1,image->file); 2   rla_header.field=MSBFirstReadShort(image->file);=   (void) ReadData((char *) rla_header.time,12,1,image->file);(?   (void) ReadData((char *) rla_header.filter,32,1,image->file);r=   rla_header.bits_per_channel=MSBFirstReadShort(image->file);07   rla_header.matte_type=MSBFirstReadShort(image->file);-7   rla_header.matte_bits=MSBFirstReadShort(image->file);m;   rla_header.auxillary_type=MSBFirstReadShort(image->file); ;   rla_header.auxillary_bits=MSBFirstReadShort(image->file);aB   (void) ReadData((char *) rla_header.auxillary,32,1,image->file);>   (void) ReadData((char *) rla_header.space,36,1,image->file);7   rla_header.next=(long) MSBFirstReadLong(image->file);p   /*     Initialize image structure.    */N   image->columns=rla_header.active_window.right-rla_header.active_window.left;K   image->rows=rla_header.active_window.top-rla_header.active_window.bottom; ,   image->packets=image->columns*image->rows;   image->depth=QuantumDepth;.   image->matte=rla_header.number_channels > 3;6   scanlines=(long *) malloc(image->rows*sizeof(long));#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);N&   if (*rla_header.description != '\0')     {o       /*         RLA image comment.       */       image->comments=(char *)@         malloc((Extent(rla_header.description)+1)*sizeof(char));+       if (image->comments == (char *) NULL) 8         PrematureExit("Unable to allocate memory",image)<       (void) strcpy(image->comments,rla_header.description);     }e   /*'     Read offsets to each scanline data.I   */!   for (i=0; i < image->rows; i++) 6     scanlines[i]=(long) MSBFirstReadLong(image->file);   /*     Read image data.   */   q=image->pixels;!   for (y=0; y < image->rows; y++)i   {h;     (void) fseek(image->file,scanlines[image->rows-y-1],0);LD     for (channel=0; channel < rla_header.number_channels; channel++)     { ,       length=MSBFirstReadShort(image->file);)       q=image->pixels+(y*image->columns);o       while (length > 0)       {c8         (void) ReadData((char *) &byte,1,1,image->file);         runlength=byte;          if (byte > 127)o           runlength=byte-256;          length--;          if (length == 0)           break;         if (runlength < 0)           { !             while (runlength < 0)a
             {f>               (void) ReadData((char *) &byte,1,1,image->file);               length--;o               switch (channel)               {t                 case 0:T                 {('                   q->red=UpScale(byte);o                   q->index=0;                    q->length=0;                   break;                 }g                 case 1:-                 { )                   q->green=UpScale(byte);                    break;                 }                  case 2:                  {c(                   q->blue=UpScale(byte);                   break;                 }i                 case 3:u                 default:                 { )                   q->index=UpScale(byte);                    break;                 }(               }t               q++;               runlength++;
             }l             continue;            }a8         (void) ReadData((char *) &byte,1,1,image->file);         length--;-         runlength++;
         do	         {f           switch (channel)           {r             case 0:)
             { #               q->red=UpScale(byte);e               q->index=0;(               q->length=0;               break;
             }              case 1:m
             {]%               q->green=UpScale(byte);                break;
             }S             case 2: 
             {[$               q->blue=UpScale(byte);               break;
             }              case 3:              default:
             { %               q->index=UpScale(byte);                break;
             }m           }            q++;           runlength--;	         }>         while (runlength > 0);       }      } 1     ProgressMonitor(LoadImageText,y,image->rows);n   }d   CompressImage(image);(   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             % O %                                                                             % O %                                                                             %(O %  R e a d R L E I m a g e                                                    %)O %                                                                             % O %                                                                             %uO %                                                                             %5O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %cG %  Function ReadRLEImage reads a run-length encoded Utah Raster ToolkitmL %  image file and returns it.  It allocates the memory necessary for the new: %  Image structure and returns a pointer to the new image. %g- %  The format of the ReadRLEImage routine is:  %C% %      image=ReadRLEImage(image_info)  % + %  A description of each parameter follows:( %gI %    o image:  Function ReadRLEImage returns a pointer to the image after-L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %gA %    o image_info: Specifies a pointer to an ImageInfo structure.k %* %k */7 static Image *ReadRLEImage(const ImageInfo *image_info)s {  #define SkipLinesOp  0x01  #define SetColorOp  0x02 #define SkipPixelsOp  0x03 #define ByteDataOp  0x05 #define RunDataOp  0x06/ #define EOFOp  0x07p     char     magick[12];C     Image      *image;i     intk     opcode,      operand,     status,)     x,     y;     register int     i,     j;     register RunlengthPacket     *q;l     register unsigned char     *p;u     unsigned chara     background_color[256],     *colormap,
     pixel,
     plane,     *rle_pixels;     unsigned int     bits_per_pixel,i
     flags,     map_length,e     number_colormaps,      number_planes;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);s   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)n/     PrematureExit("Unable to open file",image);    /*$     Determine if this is a RLE file.   */3   status=ReadData((char *) magick,1,2,image->file);m?   if ((status == False) || (strncmp(magick,"\122\314",2) != 0))i0     PrematureExit("Not a RLE image file",image);   do   {a     /*       Read image header.     */*     (void) LSBFirstReadShort(image->file);*     (void) LSBFirstReadShort(image->file);2     image->columns=LSBFirstReadShort(image->file);/     image->rows=LSBFirstReadShort(image->file);t.     image->packets=image->columns*image->rows;     flags=fgetc(image->file);g     image->matte=flags & 0x04;%     number_planes=fgetc(image->file);a&     bits_per_pixel=fgetc(image->file);(     number_colormaps=fgetc(image->file);'     map_length=1 << fgetc(image->file);pP     if ((number_planes == 0) || (number_planes == 2) || (bits_per_pixel != 8) ||         (image->columns == 0))8       PrematureExit("Unsupported RLE image file",image);     if (flags & 0x02))       {E
         /*4           No background color-- initialize to black.
         */)         for (i=0; i < number_planes; i++)/0           background_color[i]=(unsigned char) 0;"         (void) fgetc(image->file);       }f     else       { 
         /*&           Initialize background color.
         */         p=background_color;e)         for (i=0; i < number_planes; i++) 2           *p++=(unsigned char) fgetc(image->file);       }m$     if ((number_planes & 0x01) == 0)        (void) fgetc(image->file);$     colormap=(unsigned char *) NULL;     if (number_colormaps != 0)       {l
         /*           Read image colormaps.a
         */"         colormap=(unsigned char *)D           malloc(number_colormaps*map_length*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL)g;           PrematureExit("Unable to allocate memory",image);S         p=colormap;%,         for (i=0; i < number_colormaps; i++)(           for (j=0; j < map_length; j++)<             *p++=XDownScale(LSBFirstReadShort(image->file));       }      if (flags & 0x08)        {          unsigned int           length;   
         /*           Read image comment. 
         */.         length=LSBFirstReadShort(image->file);=         image->comments=(char *) malloc(length*sizeof(char)); -         if (image->comments == (char *) NULL) ;           PrematureExit("Unable to allocate memory",image); I         (void) ReadData((char *) image->comments,1,length-1,image->file); '         image->comments[length-1]='\0'; !         if ((length & 0x01) == 0)%$           (void) fgetc(image->file);       }%     /*       Allocate RLE pixels.     */     if (image->matte)n       number_planes++;      rle_pixels=(unsigned char *)A       malloc(image->packets*number_planes*sizeof(unsigned char));h-     if (rle_pixels == (unsigned char *) NULL)I7       PrematureExit("Unable to allocate memory",image);f*     if ((flags & 0x01) && !(flags & 0x02))       { 
         /*           Set background color.u
         */         p=rle_pixels; *         for (i=0; i < image->packets; i++)	         {            if (!image->matte)-             for (j=0; j < number_planes; j++)f'               *p++=background_color[j];r           else
             {a3               for (j=0; j < (number_planes-1); j++) )                 *p++=background_color[j]; 5               *p++=0;  /* initialize matte channel */ 
             }t	         }h       }      /*#       Read runlength-encoded image.e     */     plane=0;     x=0;     y=0;     opcode=fgetc(image->file);     do     {e       switch (opcode & 0x3f)       {e         case SkipLinesOp:m	         {n%           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);o           x=0;           y+=operand;f           break;	         }r         case SetColorOp:	         {g%           operand=fgetc(image->file);g           plane=operand;           if (plane == 255) "             plane=number_planes-1;           x=0;           break;	         }          case SkipPixelsOp:	         {(%           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);            x+=operand;c           break;	         }s         case ByteDataOp:	         {f%           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file); H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;           operand++;%           for (i=0; i < operand; i++);           {a%             pixel=fgetc(image->file); >             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;>             p+=number_planes;U           }            if (operand & 0x01)t&             (void) fgetc(image->file);           x+=operand;)           break;	         }l         case RunDataOp:g	         {[%           operand=fgetc(image->file);            if (opcode & 0x40)3             operand=LSBFirstReadShort(image->file);u#           pixel=fgetc(image->file);I$           (void) fgetc(image->file);           operand++;H           p=rle_pixels+((image->rows-y-1)*image->columns*number_planes)+"             x*number_planes+plane;%           for (i=0; i < operand; i++)R           { >             if ((y < image->rows) && ((x+i) < image->columns))               *p=pixel;;             p+=number_planes;e           }            x+=operand;l           break;	         }(         default:           break;       }         opcode=fgetc(image->file);<     } while (((opcode & 0x3f) != EOFOp) && (opcode != EOF));     if (number_colormaps != 0)       {          unsigned int           mask;s  
         /*1           Apply colormap transformation to image. 
         */         mask=(map_length-1);         p=rle_pixels;k"         if (number_colormaps == 1),           for (i=0; i < image->packets; i++)           {g3             *p=(unsigned char) colormap[*p & mask];              p++;           }l         else>           if ((number_planes >= 3) && (number_colormaps >= 3)).             for (i=0; i < image->packets; i++)/               for (j=0; j < number_planes; j++)i               { F                 *p=(unsigned char) colormap[j*map_length+(*p & mask)];                 p++;               }g       }o     /*!       Initialize image structure.y     */%     image->pixels=(RunlengthPacket *)n5       malloc(image->packets*sizeof(RunlengthPacket));%2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      q=image->pixels;     if (number_planes >= 3)        { 
         /*H           Convert raster image to DirectClass runlength-encoded packets.
         */         p=rle_pixels; '         for (y=0; y < image->rows; y++)g	         { ,           for (x=0; x < image->columns; x++)           { !             q->red=UpScale(*p++); #             q->green=UpScale(*p++); "             q->blue=UpScale(*p++);             q->index=0;              if (image->matte) %               q->index=UpScale(*p++);              q->length=0;             q++;           }%7           ProgressMonitor(LoadImageText,y,image->rows);t	         }G       }d     else       { 
         /*           Create colormap.
         */!         image->class=PseudoClass; "         if (number_colormaps == 0)           map_length=256;t!         image->colors=map_length; '         image->colormap=(ColorPacket *) 4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image);          p=colormap;h"         if (number_colormaps == 0)+           for (i=0; i < image->colors; i++)a           {n             /*               Grayscale.             */@             image->colormap[i].red=(MaxRGB*i)/(image->colors-1);B             image->colormap[i].green=(MaxRGB*i)/(image->colors-1);A             image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);a           }e         else$           if (number_colormaps == 1)-             for (i=0; i < image->colors; i++)n
             {                /*                 Pseudocolor.               */:               image->colormap[i].red=(Quantum) UpScale(i);<               image->colormap[i].green=(Quantum) UpScale(i);;               image->colormap[i].blue=(Quantum) UpScale(i);g
             }E           else-             for (i=0; i < image->colors; i++) 
             {e1               image->colormap[i].red=UpScale(*p);,@               image->colormap[i].green=UpScale(*(p+map_length));A               image->colormap[i].blue=UpScale(*(p+map_length*2));r               p++;
             }s         p=rle_pixels;p         if (!image->matte)           {              /*L               Convert raster image to PseudoClass runlength-encoded packets.             */+             for (y=0; y < image->rows; y++)n
             {h0               for (x=0; x < image->columns; x++)               { 1                 q->index=(unsigned short) (*p++);e                 q->length=0;                 q++;               }t;               ProgressMonitor(LoadImageText,y,image->rows);T
             }e             SyncImage(image);(           }s         else           {r             /*A               Image has a matte channel-- promote to DirectClass.l             */+             for (y=0; y < image->rows; y++)c
             { 0               for (x=0; x < image->columns; x++)               {g1                 q->red=image->colormap[*p++].red;w5                 q->green=image->colormap[*p++].green;c3                 q->blue=image->colormap[*p++].blue;m'                 q->index=UpScale(*p++);                  q->length=0;                 q++;               } ;               ProgressMonitor(LoadImageText,y,image->rows); 
             }g"             free(image->colormap);1             image->colormap=(ColorPacket *) NULL; %             image->class=DirectClass;              image->colors=0;           }+       }      if (number_colormaps != 0)       free((char *) colormap);     free((char *) rle_pixels);     CompressImage(image);l     /*       Proceed to next image.     */     (void) fgetc(image->file);5     status=ReadData((char *) magick,1,2,image->file);o@     if ((status == True) && (strncmp(magick,"\122\314",2) == 0))       {b
         /*(           Allocate next image structure.
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {>!             DestroyImages(image);,#             return((Image *) NULL);g           }(B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }oD   } while ((status == True) && (strncmp(magick,"\122\314",2) == 0));+   while (image->previous != (Image *) NULL)g     image=image->previous;   CloseImage(image);   return(image); }  e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             %sO %                                                                             %nO %                                                                             % O %  R e a d S G I I m a g e                                                    %eO %                                                                             %!O %                                                                             %aO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%I %eG %  Function ReadSGIImage reads a SGI RGB image file and returns it.  It%K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadSGIImage routine is:  % % %      image=ReadSGIImage(image_info)  % + %  A description of each parameter follows:  % I %    o image:  Function ReadSGIImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  C static void SGIDecode(unsigned char *packets,unsigned char *pixels)  {    unsigned char%
     count,
     pixel;     for ( ; ;)   {%     pixel=(*packets++);      count=pixel & 0x7f;a     if (count == 0)f       break;     if (pixel & 0x80) "       for ( ; count != 0; count--)       {t         *pixels=(*packets++);          pixels+=4;       }f     else       {V         pixel=(*packets++); $         for ( ; count != 0; count--)	         {p           *pixels=pixel;           pixels+=4;	         }o       }I   }r }r  7 static Image *ReadSGIImage(const ImageInfo *image_info)m {    typedef struct _SGIHeadere   {s     unsigned short       magic;       unsigned char        storage,       bytes_per_pixel;       unsigned short       dimension,       columns,       rows,t       depth;       unsigned longg       minimum_value,       maximum_value;       unsigned char        filler[492];   } SGIHeader;     Image      *image;e     SGIHeaderh     iris_header;     register int     i,     x,     y,     z;     register RunlengthPacket     *q;c     register unsigned char     *p;m     unsigned charm     *iris_pixels;L     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);*   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);a#   if (image->file == (FILE *) NULL)e/     PrematureExit("Unable to open file",image);    /*     Read SGI raster header.f   */3   iris_header.magic=MSBFirstReadShort(image->file);r   do   {      /*       Verify SGI identifier.     */$     if (iris_header.magic != 0x01DA)1       PrematureExit("Not a SGI RGB image",image);,+     iris_header.storage=fgetc(image->file);a3     iris_header.bytes_per_pixel=fgetc(image->file);-)     if (iris_header.bytes_per_pixel != 1) F       PrematureExit("Image must have 1 byte per pixel channel",image);9     iris_header.dimension=MSBFirstReadShort(image->file); 7     iris_header.columns=MSBFirstReadShort(image->file); 4     iris_header.rows=MSBFirstReadShort(image->file);5     iris_header.depth=MSBFirstReadShort(image->file);(<     iris_header.minimum_value=MSBFirstReadLong(image->file);<     iris_header.maximum_value=MSBFirstReadLong(image->file);2     (void) ReadData((char *) iris_header.filler,1,=       (unsigned int) sizeof(iris_header.filler),image->file);      /*       Allocate SGI pixels.     */!     iris_pixels=(unsigned char *) K       malloc(4*iris_header.columns*iris_header.rows*sizeof(unsigned char));-.     if (iris_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);e$     if (iris_header.storage != 0x01)       {          unsigned char*           *scanline;  
         /*%           Read standard image format.P
         */"         scanline=(unsigned char *)<           malloc(iris_header.columns*sizeof(unsigned char));/         if (scanline == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); 3         for (z=0; z < (int) iris_header.depth; z++) 	         {=           p=iris_pixels+z;4           for (y=0; y < (int) iris_header.rows; y++)           {mD             (void) ReadData((char *) scanline,1,iris_header.columns,               image->file);g9             for (x=0; x < (int) iris_header.columns; x++) 
             {f               *p=scanline[x];,               p+=4;n
             }c           } 	         }l          free((char *) scanline);       }      else       {l         unsigned char;           *packets;n           unsigned int           data_order;            unsigned long            offset,(           *offsets,            *runlength;)  
         /*.           Read runlength-encoded image format.
         */!         offsets=(unsigned long *)nK           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));g!         packets=(unsigned char *) H           malloc(((iris_header.columns << 1)+10)*sizeof(unsigned char));#         runlength=(unsigned long *) K           malloc(iris_header.rows*iris_header.depth*sizeof(unsigned long));%2         if ((offsets == (unsigned long *) NULL) ||2             (packets == (unsigned char *) NULL) ||2             (runlength == (unsigned long *) NULL));           PrematureExit("Unable to allocate memory",image); F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)3           offsets[i]=MSBFirstReadLong(image->file); F         for (i=0; i < (int) (iris_header.rows*iris_header.depth); i++)5           runlength[i]=MSBFirstReadLong(image->file); 
         /*           Check data order. 
         */         offset=0;          data_order=0; E         for (y=0; ((y < (int) iris_header.rows) && !data_order); y++)%H           for (z=0; ((z < (int) iris_header.depth) && !data_order); z++)           {L7             if (offsets[y+z*iris_header.rows] < offset)                data_order=1;t1             offset=offsets[y+z*iris_header.rows];.           }fA         offset=512+4*((iris_header.rows*iris_header.depth) << 1);a         if (data_order == 1)           {h7             for (z=0; z < (int) iris_header.depth; z++)L
             {                p=iris_pixels;8               for (y=0; y < (int) iris_header.rows; y++)               { <                 if (offset != offsets[y+z*iris_header.rows])                   { 9                     offset=offsets[y+z*iris_header.rows];L=                     (void) fseek(image->file,(int) offset,0);a                   }*3                 (void) ReadData((char *) packets,1,%N                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];'                 SGIDecode(packets,p+z); +                 p+=(iris_header.columns*4);                } 
             }            }          else           {e             p=iris_pixels;6             for (y=0; y < (int) iris_header.rows; y++)
             { 9               for (z=0; z < (int) iris_header.depth; z++)                { <                 if (offset != offsets[y+z*iris_header.rows])                   { 9                     offset=offsets[y+z*iris_header.rows];%=                     (void) fseek(image->file,(int) offset,0);%                   }I3                 (void) ReadData((char *) packets,1, N                   (unsigned int) runlength[y+z*iris_header.rows],image->file);8                 offset+=runlength[y+z*iris_header.rows];'                 SGIDecode(packets,p+z);y               } )               p+=(iris_header.columns*4);n
             }            }P         free(runlength);         free(packets);         free(offsets);       }i     /*!       Initialize image structure.t     */(     image->matte=iris_header.depth == 4;'     image->columns=iris_header.columns;o!     image->rows=iris_header.rows;t.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket));a2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert SGI raster image to runlength-encoded packets.     */     q=image->pixels;     if (iris_header.depth >= 3)r       { 
         /*E           Convert SGI image to DirectClass runlength-encoded packets.u
         */'         for (y=0; y < image->rows; y++)o	         {s?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4);i,           for (x=0; x < image->columns; x++)           {l             q->red=UpScale(*p);o%             q->green=UpScale(*(p+1));f$             q->blue=UpScale(*(p+2));%             q->index=UpScale(*(p+3));              q->length=0;             p+=4;i             q++;           }e7           ProgressMonitor(LoadImageText,y,image->rows);r	         }t       }e     else       {          unsigned short           index;  
         /*           Create grayscale map.r
         */!         image->class=PseudoClass;a         image->colors=256;'         image->colormap=(ColorPacket *)o4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image); )         for (i=0; i < image->colors; i++) 	         { 6           image->colormap[i].red=(Quantum) UpScale(i);8           image->colormap[i].green=(Quantum) UpScale(i);7           image->colormap[i].blue=(Quantum) UpScale(i);_	         }r
         /*E           Convert SGI image to PseudoClass runlength-encoded packets.b
         */'         for (y=0; y < image->rows; y++)k	         { ?           p=iris_pixels+((image->rows-1)-y)*(image->columns*4);e,           for (x=0; x < image->columns; x++)           {e(             index=(unsigned short) (*p);             q->index=index;e             q->length=0;             p+=4;t             q++;           }r7           ProgressMonitor(LoadImageText,y,image->rows); 	         }t         SyncImage(image);b       }t     free((char *) iris_pixels);t     CompressImage(image);r     /*       Proceed to next image.     */5     iris_header.magic=MSBFirstReadShort(image->file);t$     if (iris_header.magic == 0x01DA)       { 
         /*#           Allocate image structure.e
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {s!             DestroyImages(image); #             return((Image *) NULL);            }oB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }((   } while (iris_header.magic == 0x01DA);+   while (image->previous != (Image *) NULL)a     image=image->previous;   CloseImage(image);   return(image); }o i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %eO %                                                                             %>O %                                                                             % O %  R e a d S U N I m a g e                                                    %oO %                                                                             %mO %                                                                             %pO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c % M %  Function ReadSUNImage reads a SUN image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.t % - %  The format of the ReadSUNImage routine is:a %i% %      image=ReadSUNImage(image_info)e %g+ %  A description of each parameter follows:) % I %    o image:  Function ReadSUNImage returns a pointer to the image aftermL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.g % A %    o image_info: Specifies a pointer to an ImageInfo structure.n %c %  */7 static Image *ReadSUNImage(const ImageInfo *image_info)u {g #define RMT_EQUAL_RGB  1 #define RMT_NONE  0o #define RMT_RAW  2 #define RT_STANDARD  1 #define RT_ENCODED  2x #define RT_FORMAT_RGB  3     typedef struct _SUNHeaderC   {"     unsigned longs       magic,       width,
       height,)       depth,
       length,&       type,        maptype,       maplength;   } SUNHeader;     Imageh     *image;      register int     bit,     i,     x,     y;     register RunlengthPacket     *q;i     register unsigned char     *p;!     SUNHeadera     sun_header;b     unsigned char_     *sun_data,     *sun_pixels;     unsigned int     bytes_per_line,      status;      /*     Allocate image structure.r   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);y   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*     Read SUN raster header.e   */1   sun_header.magic=MSBFirstReadLong(image->file);e   do   {c     /*       Verify SUN identifier.     */'     if (sun_header.magic != 0x59a66a95)i4       PrematureExit("Not a SUN raster image",image);3     sun_header.width=MSBFirstReadLong(image->file);u4     sun_header.height=MSBFirstReadLong(image->file);3     sun_header.depth=MSBFirstReadLong(image->file);a4     sun_header.length=MSBFirstReadLong(image->file);2     sun_header.type=MSBFirstReadLong(image->file);5     sun_header.maptype=MSBFirstReadLong(image->file); 7     sun_header.maplength=MSBFirstReadLong(image->file);      switch (sun_header.maptype)(     {>       case RMT_NONE:       {)"         if (sun_header.depth < 24)           {              /*'               Create linear color ramp.s             */0             image->colors=1 << sun_header.depth;+             image->colormap=(ColorPacket *) 8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)?               PrematureExit("Unable to allocate memory",image);e-             for (i=0; i < image->colors; i++) 
             {zB               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);1
             }m           }          break;       }e       case RMT_EQUAL_RGB:d       {)         unsigned charn           *sun_colormap;  
         /*#           Read SUN raster colormap.a
         */<         image->colors=(unsigned int) sun_header.maplength/3;'         image->colormap=(ColorPacket *)w4           malloc(image->colors*sizeof(ColorPacket));&         sun_colormap=(unsigned char *)6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||5             (sun_colormap == (unsigned char *) NULL))c;           PrematureExit("Unable to allocate memory",image); K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file); )         for (i=0; i < image->colors; i++)e:           image->colormap[i].red=UpScale(sun_colormap[i]);K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file); )         for (i=0; i < image->colors; i++)i<           image->colormap[i].green=UpScale(sun_colormap[i]);K         (void) ReadData((char *) sun_colormap,1,image->colors,image->file);s)         for (i=0; i < image->colors; i++)u;           image->colormap[i].blue=UpScale(sun_colormap[i]);p$         free((char *) sun_colormap);         break;       }m       case RMT_RAW:        {n         unsigned charm           *sun_colormap;  
         /*#           Read SUN raster colormap. 
         */&         sun_colormap=(unsigned char *)=           malloc(sun_header.maplength*sizeof(unsigned char));S3         if (sun_colormap == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image); >         (void) ReadData((char *) sun_colormap,1,(unsigned int),           sun_header.maplength,image->file);$         free((char *) sun_colormap);         break;       }        default:>         PrematureExit("Colormap type is not supported",image);     }mO     sun_data=(unsigned char *) malloc(sun_header.length*sizeof(unsigned char));L+     if (sun_data == (unsigned char *) NULL)I7       PrematureExit("Unable to allocate memory",image); I     status=ReadData((char *) sun_data,1,(unsigned int) sun_header.length,m       image->file);m=     if ((status == False) && (sun_header.type != RT_ENCODED))i7       PrematureExit("Unable to read image data",image);o     sun_pixels=sun_data;&     if (sun_header.type == RT_ENCODED)       {e         unsigned int           width,           height;s  
         /*0           Read run-length encoded raster pixels.
         */P         width=(unsigned int) (sun_header.width*(((sun_header.depth-1) >> 3)+1));0         height=(unsigned int) sun_header.height;C         bytes_per_line=2*(sun_header.width*sun_header.depth+15)/16;)$         sun_pixels=(unsigned char *)>           malloc(bytes_per_line*height*sizeof(unsigned char));1         if (sun_pixels == (unsigned char *) NULL) ;           PrematureExit("Unable to allocate memory",image);gI         (void) SUNDecodeImage(sun_data,sun_pixels,bytes_per_line,height);           free((char *) sun_data);       }a     /*!       Initialize image structure.>     */*     image->matte=(sun_header.depth == 32);E     image->class=(sun_header.depth < 24 ? PseudoClass : DirectClass);)3     image->columns=(unsigned int) sun_header.width;s1     image->rows=(unsigned int) sun_header.height; .     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)i5       malloc(image->packets*sizeof(RunlengthPacket));u2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);      /*<       Convert SUN raster image to runlength-encoded packets.     */     p=sun_pixels;r     q=image->pixels;     if (sun_header.depth == 1)%       for (y=0; y < image->rows; y++)e       {i
         /*E           Convert bitmap scanline to runlength-encoded color packets.e
         */1         for (x=0; x < (image->columns >> 3); x++)o	         { &           for (bit=7; bit >= 0; bit--)           { :             q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);             q->length=0;             q++;           }x           p++;	         }P&         if ((image->columns % 8) != 0)           { ?             for (bit=7; bit >= (8-(image->columns % 8)); bit--) 
             { <               q->index=((*p) & (0x01 << bit) ? 0x00 : 0x01);               q->length=0;               q++;
             },             p++;           }1I         if ((((image->columns/8)+(image->columns % 8 ? 1 : 0)) % 2) != 0)>           p++;5         ProgressMonitor(LoadImageText,y,image->rows);        }      else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++)e	         {u           /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {2             q->index=(*p++);             q->length=0;             q++;           } (           if ((image->columns % 2) != 0)             p++;7           ProgressMonitor(LoadImageText,y,image->rows);T	         })
       else'         for (y=0; y < image->rows; y++)e	         {            /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {              q->index=0;              if (image->matte) %               q->index=UpScale(*p++); /             if (sun_header.type == RT_STANDARD)                {e&                 q->blue=UpScale(*p++);'                 q->green=UpScale(*p++);a%                 q->red=UpScale(*p++);m               }              else               {e%                 q->red=UpScale(*p++); '                 q->green=UpScale(*p++); &                 q->blue=UpScale(*p++);               }%#             if (image->colors != 0)%               {%3                 q->red=image->colormap[q->red].red; 9                 q->green=image->colormap[q->green].green; 6                 q->blue=image->colormap[q->blue].blue;               }              q->length=0;             q++;           } E           if (((image->columns % 2) != 0) && (image->matte == False))              p++;7           ProgressMonitor(LoadImageText,y,image->rows); 	         }      free((char *) sun_pixels);$     if (image->class == PseudoClass)       {          SyncImage(image);           CompressColormap(image);       }      CompressImage(image);      /*       Proceed to next image.     */3     sun_header.magic=MSBFirstReadLong(image->file);n'     if (sun_header.magic == 0x59a66a95)a       {a
         /*#           Allocate image structure.m
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {P!             DestroyImages(image);a#             return((Image *) NULL);A           }oB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       } +   } while (sun_header.magic == 0x59a66a95);I+   while (image->previous != (Image *) NULL)e     image=image->previous;   CloseImage(image);   return(image); }r   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%gO %                                                                             %%O %                                                                             % O %                                                                             % O %  R e a d T G A I m a g e                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function ReadTGAImage reads a Truevision TGA image file and returns it.L %  It allocates the memory necessary for the new Image structure and returns %  a pointer to the new image. %e- %  The format of the ReadTGAImage routine is:y %r% %      image=ReadTGAImage(image_info)  %p+ %  A description of each parameter follows:f %eI %    o image:  Function ReadTGAImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.g %fA %    o image_info: Specifies a pointer to an ImageInfo structure.o %s %t */7 static Image *ReadTGAImage(const ImageInfo *image_info)e {f #define TGAColormap 1t #define TGARGB 2 #define TGAMonochrome 3t #define TGARLEColormap  9t #define TGARLERGB  10  #define TGARLEMonochrome  11     typedef struct _TGAHeader    {      unsigned char        id_length,       colormap_type,       image_type;h       unsigned short       colormap_index,h       colormap_length;       unsigned charo       colormap_size;       unsigned short       x_origin,e       y_origin,l       width,
       height;        unsigned char        pixel_size,        attributes;m   } TGAHeader;     Image_     *image;e  	   Quantuma	     blue,c
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;t     TGAHeaderk     tga_header;      unsigned charr     j,     k,     runlength;     unsigned int	     base, 	     flag,n     offset, 	     real, 	     skip,u     status;      unsigned short
     index;     /*     Allocate image structure.,   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);;   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)f/     PrematureExit("Unable to open file",image);N   /*      Read TGA header information.   */B   status=ReadData((char *) &tga_header.id_length,1,1,image->file);.   tga_header.colormap_type=fgetc(image->file);+   tga_header.image_type=fgetc(image->file);s   do   {.<     if ((status == False) || (tga_header.image_type == 0) ||%         (tga_header.image_type > 11)) 2       PrematureExit("Not a TGA image file",image);=     tga_header.colormap_index=LSBFirstReadShort(image->file);d>     tga_header.colormap_length=LSBFirstReadShort(image->file);0     tga_header.colormap_size=fgetc(image->file);7     tga_header.x_origin=LSBFirstReadShort(image->file);n7     tga_header.y_origin=LSBFirstReadShort(image->file); 4     tga_header.width=LSBFirstReadShort(image->file);5     tga_header.height=LSBFirstReadShort(image->file); -     tga_header.pixel_size=fgetc(image->file); -     tga_header.attributes=fgetc(image->file);r     /*!       Initialize image structure.      */-     image->matte=tga_header.pixel_size == 32;($     image->columns=tga_header.width;"     image->rows=tga_header.height;.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *)e5       malloc(image->packets*sizeof(RunlengthPacket));d2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);_"     if (tga_header.id_length != 0)       {=
         /*           TGA image comment.
         */          image->comments=(char *)8           malloc((tga_header.id_length+1)*sizeof(char));-         if (image->comments == (char *) NULL)g;           PrematureExit("Unable to allocate memory",image);)L         (void) ReadData(image->comments,1,tga_header.id_length,image->file);3         image->comments[tga_header.id_length]='\0';=       }e
     red=0;     green=0;     blue=0;h&     if (tga_header.colormap_type != 0)       {e
         /*#           Read TGA raster colormap.a
         */8         if ((tga_header.image_type == TGARLEColormap) ||1             (tga_header.image_type == TGARLERGB))e#           image->class=PseudoClass;o1         image->colors=tga_header.colormap_length;r'         image->colormap=(ColorPacket *)=4           malloc(image->colors*sizeof(ColorPacket));4         if (image->colormap == (ColorPacket *) NULL);           PrematureExit("Unable to allocate memory",image); )         for (i=0; i < image->colors; i++)s	         {P+           switch (tga_header.colormap_size)m           {i             case 8:              default:
             {a               /*                 Gray scale.i               */.               red=UpScale(fgetc(image->file));               green=red;               blue=red;r               break;
             }              case 15:             case 16:
             {                /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file);]#               k=fgetc(image->file);iB               red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);               green=(Quantum)dP                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);>               blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);               break;
             }(             case 32:             case 24:
             {r               /*3                 8 bits each of blue, green and red.>               *//               blue=UpScale(fgetc(image->file));00               green=UpScale(fgetc(image->file));.               red=UpScale(fgetc(image->file));               break;
             }n           }+%           image->colormap[i].red=red;g)           image->colormap[i].green=green;P'           image->colormap[i].blue=blue;_	         }s       }*     /*6       Convert TGA pixels to runlength-encoded packets.     */     base=0;e     flag=0;      index=0;     skip=False;      real=0;a     runlength=0;
     offset=0;e     q=image->pixels;&     for (i=0; i < image->packets; i++)     {U       q->red=0;p       q->green=0;n       q->blue=0;       q->index=0;n       q->length=0;
       q++;     }r#     for (y=0; y < image->rows; y++)y     {)       real=offset;E       if (((unsigned char) (tga_header.attributes & 0x20) >> 5) == 0)s          real=image->rows-real-1;,       q=image->pixels+(real*image->columns);(       for (x=0; x < image->columns; x++)       { 8         if ((tga_header.image_type == TGARLEColormap) ||3             (tga_header.image_type == TGARLERGB) ||l8             (tga_header.image_type == TGARLEMonochrome))           if (runlength != 0) 
             {                runlength--;               skip=flag != 0;c
             }l           else
             {aC               status=ReadData((char *) &runlength,1,1,image->file); "               if (status == False)A                 PrematureExit("Unable to read image data",image);($               flag=runlength & 0x80;               if (flag != 0)                 runlength-=128;t               skip=False;d
             }i         if (!skip)(           switch (tga_header.pixel_size)           {*             case 8:              default:
             {t               /*                 Gray scale.                */'               index=fgetc(image->file);r0               if (tga_header.colormap_type == 0)                 {(/                   red=(Quantum) UpScale(index); 1                   green=(Quantum) UpScale(index);e0                   blue=(Quantum) UpScale(index);                 }                else                 {U1                   red=image->colormap[index].red;g5                   green=image->colormap[index].green;]3                   blue=image->colormap[index].blue;i                 }                break;
             }a             case 15:             case 16:
             {(               /*2                 5 bits each of red green and blue.               */#               j=fgetc(image->file);/#               k=fgetc(image->file);]B               red=(Quantum) ((MaxRGB*((int) (k & 0x7c) >> 2))/31);               green=(Quantum)[P                 ((MaxRGB*(((int) (k & 0x03) << 3)+((int) (j & 0xe0) >> 5)))/31);>               blue=(Quantum) ((MaxRGB*((int) (j & 0x1f)))/31);0               index=((unsigned short) k << 8)+j;               break;
             }              case 24:             case 32:
             {k               /*2                 8 bits each of blue green and red.               *//               blue=UpScale(fgetc(image->file)); 0               green=UpScale(fgetc(image->file));.               red=UpScale(fgetc(image->file));.               if (tga_header.pixel_size == 32)9                 index=Opaque-UpScale(fgetc(image->file));i               break;
             }e           }          if (status == False);           PrematureExit("Unable to read image data",image);          q->red=red;          q->green=green;          q->blue=blue;r         q->index=index;          q->length=0;         q++;       } E       if (((unsigned char) (tga_header.attributes & 0xc0) >> 6) == 4)          offset+=4;
       elseG         if (((unsigned char) (tga_header.attributes & 0xc0) >> 6) == 2)*           offset+=2;         else           offset++;         if (offset >= image->rows)	         {            base++;            offset=base;	         }        if (feof(image->file))         break;3       ProgressMonitor(LoadImageText,y,image->rows);      }      (void) IsGrayImage(image);$     if (image->class == PseudoClass)       SyncImage(image);g     CompressImage(image);      /*       Proceed to next image.     */D     status=ReadData((char *) &tga_header.id_length,1,1,image->file);0     tga_header.colormap_type=fgetc(image->file);-     tga_header.image_type=fgetc(image->file);bL     status&=((tga_header.image_type != 0) && (tga_header.image_type <= 11));     if (status == True)        {b
         /*#           Allocate image structure. 
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {w!             DestroyImages(image); #             return((Image *) NULL);            } B         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }    } while (status == True);;+   while (image->previous != (Image *) NULL)>     image=image->previous;   CloseImage(image);   return(image); }i = /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%0O %                                                                             % O %                                                                             %(O %                                                                             %&O %  R e a d T E X T I m a g e                                                  %0O %                                                                             % O %                                                                             % O %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadTEXTImage reads a text file and returns it as an image.  It(K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %(. %  The format of the ReadTEXTImage routine is: % & %      image=ReadTEXTImage(image_info) %)+ %  A description of each parameter follows:  % J %    o image:  Function ReadTEXTImage returns a pointer to the image afterN %      reading. A null image is returned if there is a a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %r %f */8 static Image *ReadTEXTImage(const ImageInfo *image_info) {    AnnotateInfo     annotate_info;     char     *background_color,     *foreground_color,     geometry[MaxTextExtent],     text[MaxTextExtent],     *text_status;   	   Displayp
     *display;      Imagel     *image;+     int      offset,m     x,     y;     register int     i;     register RunlengthPacket     *p;=     RunlengthPacket=     background;u     unsigned int     height,i
     width;     XColor
     color;     /*     Allocate image structure.+   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);m   /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL);/     PrematureExit("Unable to open file",image);*   /*     Initialize Image structure.m   */?   (void) XParseGeometry(TextPageGeometry,&x,&y,&width,&height);g(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    else     { 
       char         density[MaxTextExtent];m         float          dx_resolution,         dy_resolution,         x_resolution,          y_resolution;   	       int          count;         /*         Determine bounding box.        */       dx_resolution=72.0;        dy_resolution=72.0;        x_resolution=72.0;/       (void) strcpy(density,PSDensityGeometry); @       count=sscanf(density,"%fx%f",&x_resolution,&y_resolution);/       if (image_info->density != (char *) NULL) N         count=sscanf(image_info->density,"%fx%f",&x_resolution,&y_resolution);       if (count != 2)l"         y_resolution=x_resolution;F       width=(unsigned int) (((width*x_resolution)/dx_resolution)+0.5);H       height=(unsigned int) (((height*y_resolution)/dy_resolution)+0.5);     }    image->columns=width;    image->rows=height;),   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)d3     malloc(image->packets*sizeof(RunlengthPacket));T0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);    /*.     Initialize text image to background color.   */)   background_color=DefaultTextBackground; )   foreground_color=DefaultTextForeground; 0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {n       XrmDatabasee         resource_database;         /*%         Set background and pen color.e       */       XSetErrorHandler(XError);mB       resource_database=XGetResourceDatabase(display,client_name);J       background_color=XGetResourceInstance(resource_database,client_name,'         "background",background_color);mJ       foreground_color=XGetResourceInstance(resource_database,client_name,'         "foreground",foreground_color);%       XCloseDisplay(display);      }    /*%     Initialize image annotation info.    */"   GetAnnotateInfo(&annotate_info);4   annotate_info.server_name=image_info->server_name;&   annotate_info.font=image_info->font;   annotate_info.text=text;"   annotate_info.geometry=geometry;%   annotate_info.pen=foreground_color;    /*.     Initialize text image to background color.   */6   (void) XQueryColorDatabase(background_color,&color);'   background.red=XDownScale(color.red); +   background.green=XDownScale(color.green); )   background.blue=XDownScale(color.blue);    background.index=0;    p=image->pixels;$   for (i=0; i < image->packets; i++)     *p++=background;+   if (image_info->texture != (char *) NULL)a,     TextureImage(image,image_info->texture);   /*     Annotate the text image.   */   offset=0;e
   for ( ; ; )r   {      /*       Annotate image with text.      */D     ProgressMonitor(LoadImageText,(unsigned int) ftell(image->file),&       (unsigned int) image->filesize);8     text_status=fgets(text,MaxTextExtent-1,image->file);%     if (text_status == (char *) NULL)g       break;'     if (Extent(annotate_info.text) > 0)t<       annotate_info.text[Extent(annotate_info.text)-1]='\0';?     (void) sprintf(annotate_info.geometry,"%+d%+d",x,y+offset);o(     AnnotateImage(image,&annotate_info);$     offset+=annotate_info.pointsize;@     if (((y << 1)+offset+annotate_info.pointsize) < image->rows)       continue;      /*3       Page is full-- allocate next image structure.t     */     CompressImage(image);]-     if (image_info->texture == (char *) NULL)        {          QuantizeInfo           quantize_info;  (         GetQuantizeInfo(&quantize_info);,         QuantizeImage(&quantize_info,image);       }o     image->orphan=True; B     image->next=CopyImage(image,image->columns,image->rows,False);     image->orphan=False;&     if (image->next == (Image *) NULL)       {aF         Warning("Unable to annotate image","Memory allocation error");         break;       }*>     (void) strcpy(image->next->filename,image_info->filename);"     image->next->file=image->file;*     image->next->filesize=image->filesize;&     image->next->scene=image->scene+1;      image->next->previous=image;     image=image->next;     /*0       Initialize text image to background color.     */     p=image->pixels;&     for (i=0; i < image->packets; i++)       *p++=background;-     if (image_info->texture != (char *) NULL)y.       TextureImage(image,image_info->texture);
     offset=0;    }i   CompressImage(image); +   if (image_info->texture == (char *) NULL)0     {f       QuantizeInfo         quantize_info;  %      GetQuantizeInfo(&quantize_info); )      QuantizeImage(&quantize_info,image);;    }+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseImage(image);   return(image); }  v #ifdef HasTIFF u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %oO %                                                                             %xO %                                                                             %"O %  R e a d T I F F I m a g e                                                  % O %                                                                             % O %                                                                             % O %                                                                             %.O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%" %%G %  Function ReadTIFFImage reads a Tagged image file and returns it.  It*K %  allocates the memory necessary for the new Image structure and returns ae %  pointer to the new image. % . %  The format of the ReadTIFFImage routine is: %g& %      image=ReadTIFFImage(image_info) %t+ %  A description of each parameter follows:e %eJ %    o image:  Function ReadTIFFImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %(A %    o image_info: Specifies a pointer to an ImageInfo structure.i %s %n */  E static void TIFFWarningMessage(const char *module,const char *format,l   va_list warning) {u   char     message[MaxTextExtent];d     register char;     *p;r     p=message;   if (module != (char *) NULL)     {f&       (void) sprintf(p,"%s: ",module);       p+=Extent(message);      }    vsprintf(p,format,warning);    (void) strcat(p,"."); !   Warning(message,(char *) NULL);t }l  8 static Image *ReadTIFFImage(const ImageInfo *image_info) {L   char
     *text;     Imagei     *image;I     inte
     range;  	   Quantume	     blue,e
     green,     red;     register int     i,     x,     y;     register RunlengthPacket     *q;i     register unsigned char     *p;t     TIFF
     *tiff;     uint16     extra_samples,     *sample_info;l     unsigned chara     *scanline;     unsigned int     height,n     method,!     packets,     status,s
     width;     unsigned short     bits_per_sample,
     index,     interlace,     max_sample_value,s     min_sample_value,_
     pages,     photometric,     samples_per_pixel,
     units,
     value;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image.e   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL)c/     PrematureExit("Unable to open file",image);n,   if ((image->file == stdin) || image->pipe)     {%
       FILE         *file;  	       int 
         c;         /*6         Copy standard input or pipe to temporary file.       */.       TemporaryFilename(image_info->filename);7       file=fopen(image_info->filename,WriteBinaryType);5        if (file == (FILE *) NULL)4         PrematureExit("Unable to write file",image);       c=fgetc(image->file);        while (c != EOF)       {r         (void) putc(c,file);         c=fgetc(image->file);        }t       (void) fclose(file);:       (void) strcpy(image->filename,image_info->filename);       image->temporary=True;     }l   CloseImage(image);*   TIFFSetErrorHandler(TIFFWarningMessage);,   TIFFSetWarningHandler(TIFFWarningMessage);0   tiff=TIFFOpen(image->filename,ReadBinaryType);   if (tiff == (TIFF *) NULL)/     PrematureExit("Unable to open file",image);a    if (image_info->subrange != 0)/     while (image->scene < image_info->subimage)(     {)       /*         Skip to next image.)       */       image->scene++;;%       status=TIFFReadDirectory(tiff);e       if (status == False)7         PrematureExit("Unable to read subimage",image);e     }    do   {_     if (image_info->verbose),       TIFFPrintDirectory(tiff,stderr,False);1     TIFFGetField(tiff,TIFFTAG_IMAGEWIDTH,&width); 3     TIFFGetField(tiff,TIFFTAG_IMAGELENGTH,&height);%@     TIFFGetFieldDefaulted(tiff,TIFFTAG_PLANARCONFIG,&interlace);G     TIFFGetFieldDefaulted(tiff,TIFFTAG_BITSPERSAMPLE,&bits_per_sample); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MINSAMPLEVALUE,&min_sample_value); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_MAXSAMPLEVALUE,&max_sample_value);IA     TIFFGetFieldDefaulted(tiff,TIFFTAG_PHOTOMETRIC,&photometric); K     TIFFGetFieldDefaulted(tiff,TIFFTAG_SAMPLESPERPIXEL,&samples_per_pixel); >     TIFFGetFieldDefaulted(tiff,TIFFTAG_RESOLUTIONUNIT,&units);I     TIFFGetFieldDefaulted(tiff,TIFFTAG_XRESOLUTION,&image->x_resolution); I     TIFFGetFieldDefaulted(tiff,TIFFTAG_YRESOLUTION,&image->y_resolution);%     /*5       Allocate memory for the image and pixel buffer.      */     image->columns=width;P     image->rows=height;t     if (units == RESUNIT_INCH)+       image->units=PixelsPerInchResolution;a$     if (units == RESUNIT_CENTIMETER)1       image->units=PixelsPerCentimeterResolution;:!     image->depth=bits_per_sample;a     if (bits_per_sample < 8)       image->depth=8;o     image->packets=0; 7     packets=Max((image->columns*image->rows+4) >> 3,1);t     if (bits_per_sample == 1)g9       packets=Max((image->columns*image->rows+8) >> 4,1); N     image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));2     if (image->pixels == (RunlengthPacket *) NULL)       {o         TIFFClose(tiff);9         PrematureExit("Unable to allocate memory",image);        } A     TIFFGetFieldDefaulted(tiff,TIFFTAG_PAGENUMBER,&value,&pages);r     image->scene=value;m     text=(char *) NULL;n.     TIFFGetField(tiff,TIFFTAG_PAGENAME,&text);     if (text != (char *) NULL)       {i         image->label=(char *)m?           malloc((unsigned int) (Extent(text)+1)*sizeof(char));=*         if (image->label == (char *) NULL)           {,             TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);o           }t)         (void) strcpy(image->label,text);p       }e     text=(char *) NULL; 6     TIFFGetField(tiff,TIFFTAG_IMAGEDESCRIPTION,&text);     if (text != (char *) NULL)       {           image->comments=(char *)?           malloc((unsigned int) (Extent(text)+1)*sizeof(char));e-         if (image->comments == (char *) NULL)*           {p             TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);a           }t,         (void) strcpy(image->comments,text);       }=,     range=max_sample_value-min_sample_value;     if (range < 0)       range=max_sample_value;U     q=image->pixels;     q->length=MaxRunlength; 
     method=0;%5     if ((samples_per_pixel > 1) || TIFFIsTiled(tiff))%       {%         method=2; K         if ((samples_per_pixel >= 3) && (photometric == PHOTOMETRIC_RGB) && /             (interlace == PLANARCONFIG_CONTIG))            method=1;        }      switch (method)      { 
       case 0:        {          Quantum            *quantum_scanline;           register Quantum
           *r;   
         /*7           Convert TIFF image to PseudoClass MIFF image. 
         */!         image->class=PseudoClass;          image->colors=range+1;+         if (bits_per_sample > QuantumDepth) !           image->colors=MaxRGB+1; '         image->colormap=(ColorPacket *)%4           malloc(image->colors*sizeof(ColorPacket));C         quantum_scanline=(Quantum *) malloc(width*sizeof(Quantum));aD         scanline=(unsigned char *) malloc(TIFFScanlineSize(tiff)+1);8         if ((image->colormap == (ColorPacket *) NULL) ||5             (quantum_scanline == (Quantum *) NULL) ||e1             (scanline == (unsigned char *) NULL))o           {              TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);            }i
         /*           Create colormap.
         */         switch (photometric)	         {o&           case PHOTOMETRIC_MINISBLACK:           {c-             for (i=0; i < image->colors; i++)g
             {fB               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);a
             }1             break;           }(&           case PHOTOMETRIC_MINISWHITE:           {              unsigned int               colors;n  !             colors=image->colors;,-             for (i=0; i < image->colors; i++) 
             {mK               image->colormap[colors-i-1].red=(MaxRGB*i)/(image->colors-1);)M               image->colormap[colors-i-1].green=(MaxRGB*i)/(image->colors-1); L               image->colormap[colors-i-1].blue=(MaxRGB*i)/(image->colors-1);
             }x             break;           }e#           case PHOTOMETRIC_PALETTE:;           {n             long               range;               unsigned short               *blue_colormap,f               *green_colormap,               *red_colormap;  M             TIFFGetField(tiff,TIFFTAG_COLORMAP,&red_colormap,&green_colormap,/               &blue_colormap);@             range=256L;  /* might be old style 8-bit colormap */-             for (i=0; i < image->colors; i++)eK               if ((red_colormap[i] >= 256) || (green_colormap[i] >= 256) ||e,                   (blue_colormap[i] >= 256))                 {.                   range=65535L;s                   break;                 }l-             for (i=0; i < image->colors; i++)e
             {h.               image->colormap[i].red=(Quantum)8                 ((long) (MaxRGB*red_colormap[i])/range);0               image->colormap[i].green=(Quantum):                 ((long) (MaxRGB*green_colormap[i])/range);/               image->colormap[i].blue=(Quantum)a9                 ((long) (MaxRGB*blue_colormap[i])/range); 
             }o             break;           })           default:             break;	         })
         /*A           Convert image to PseudoClass runlength-encoded packets.%
         */'         for (y=0; y < image->rows; y++)%	         {%7           TIFFReadScanline(tiff,(char *) scanline,y,0);            p=scanline;            r=quantum_scanline; "           switch (bits_per_sample)           {              case 1: 
             {                register int                 bit;  2               for (x=0; x < ((int) width-7); x+=8)               { ,                 for (bit=7; bit >= 0; bit--)<                   *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                 p++;               } #               if ((width % 8) != 0)                  { <                   for (bit=7; bit >= (8-(width % 8)); bit--)>                     *r++=((*p) & (0x01 << bit) ? 0x01 : 0x00);                   p++;                 }P               break;
             }n             case 2:t
             {m2               for (x=0; x < ((int) width-3); x+=4)               {r%                 *r++=(*p >> 6) & 0x3;f%                 *r++=(*p >> 4) & 0x3; %                 *r++=(*p >> 2) & 0x3;                   *r++=(*p) & 0x3;                 p++;               } #               if ((width % 4) != 0)                  { 6                   for (i=3; i >= (4-(width % 4)); i--).                     *r++=(*p >> (i*2)) & 0x03;                   p++;                 }i               break;
             }              case 4: 
             {r2               for (x=0; x < ((int) width-1); x+=2)               {L%                 *r++=(*p >> 4) & 0xf;                   *r++=(*p) & 0xf;                 p++;               }a#               if ((width % 2) != 0) '                 *r++=(*p++ >> 4) & 0xf;o               break;
             }u             case 8: 
             {n'               for (x=0; x < width; x++)=                 *r++=(*p++);               break;
             }n             case 16:
             { 0               for (x=0; x < image->columns; x++)               {h"                 ReadQuantum(*r,p);                 r++;               }U               break;
             }a             default:               break;           }n           /*$             Transfer image scanline.           */           r=quantum_scanline;o,           for (x=0; x < image->columns; x++)           {              index=(*r++);sH             if ((index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {e                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));aB                     if (image->pixels == (RunlengthPacket *) NULL)                       { 0                         free((char *) scanline);8                         free((char *) quantum_scanline);(                         TIFFClose(tiff);I                         PrematureExit("Unable to allocate memory",image);l                       } 5                     q=image->pixels+image->packets-1;f                   }L                 q->index=index;d                 q->length=0;               }N           } 7           ProgressMonitor(LoadImageText,y,image->rows);]	         }o          free((char *) scanline);(         free((char *) quantum_scanline);(         if (image->class == PseudoClass)           {n             SyncImage(image);E$             CompressColormap(image);           }          break;       }a
       case 1:        {e
         /*7           Convert TIFF image to DirectClass MIFF image.f
         */K         scanline=(unsigned char *) malloc((TIFFScanlineSize(tiff) << 1)+1); /         if (scanline == (unsigned char *) NULL)n           {f             TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);i           }gG         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,i           &sample_info);,         image->matte=(extra_samples == 1) &&6           ((*sample_info == EXTRASAMPLE_ASSOCALPHA) ||5            (*sample_info == EXTRASAMPLE_UNASSALPHA)); '         for (y=0; y < image->rows; y++)/	         {t7           TIFFReadScanline(tiff,(char *) scanline,y,0); #           if (bits_per_sample == 4) 
             {-$               register unsigned char                 *r;!  +               width=TIFFScanlineSize(tiff);n!               p=scanline+width-1;A(               r=scanline+(width << 1)-1;-               for (x=0; x < (int) width; x++)l               {A'                 *r--=((*p) & 0xf) << 4; ,                 *r--=((*p >> 4) & 0xf) << 4;                 p--;               }n
             }            p=scanline;=,           for (x=0; x < image->columns; x++)           {i             ReadQuantum(red,p); !             ReadQuantum(green,p);P              ReadQuantum(blue,p);             index=0;'             if (samples_per_pixel == 4) #               ReadQuantum(index,p);xN             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&H                 (index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;g.                 if (image->packets == packets)                   {o                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));cB                     if (image->pixels == (RunlengthPacket *) NULL)                       {o(                         TIFFClose(tiff);0                         free((char *) scanline);I                         PrematureExit("Unable to allocate memory",image);u                       }n5                     q=image->pixels+image->packets-1;r                   }=                 q->red=red;;                 q->green=green;n                 q->blue=blue;                  q->index=index;f                 q->length=0;               }t           }t7           ProgressMonitor(LoadImageText,y,image->rows);w	         }_          free((char *) scanline);         break;       }=
       case 2:_       default:       {;         register uint32o
           *p,c           *pixels;  
         /*7           Convert TIFF image to DirectClass MIFF image.>
         */G         TIFFGetFieldDefaulted(tiff,TIFFTAG_EXTRASAMPLES,&extra_samples,            &sample_info);         image->matte=gO           ((extra_samples == 1) && (sample_info[0] == EXTRASAMPLE_ASSOCALPHA));n         pixels=(uint32 *)eM           malloc((image->columns*image->rows+image->columns)*sizeof(uint32));-&         if (pixels == (uint32 *) NULL)           {g             TIFFClose(tiff);=             PrematureExit("Unable to allocate memory",image);e           }iK         status=TIFFReadRGBAImage(tiff,image->columns,image->rows,pixels,0);n         if (status == False)           {o"             free((char *) pixels);             TIFFClose(tiff);8             PrematureExit("Unable to read image",image);           }L
         /*A           Convert image to DirectClass runlength-encoded packets.l
         */*         for (y=image->rows-1; y >= 0; y--)	         {_$           p=pixels+y*image->columns;,           for (x=0; x < image->columns; x++)           { &             red=UpScale(TIFFGetR(*p));(             green=UpScale(TIFFGetG(*p));'             blue=UpScale(TIFFGetB(*p));_;             index=image->matte ? UpScale(TIFFGetA(*p)) : 0;CN             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&H                 (index == q->index) && ((int) q->length < MaxRunlength))               q->length++;             else               {r(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));GB                     if (image->pixels == (RunlengthPacket *) NULL)                       {-.                         free((char *) pixels);(                         TIFFClose(tiff);I                         PrematureExit("Unable to allocate memory",image);c                       }.5                     q=image->pixels+image->packets-1;n                   }0                 q->red=red;                  q->green=green;n                 q->blue=blue;e                 q->index=index;d                 q->length=0;               }s             p++;           } E           ProgressMonitor(LoadImageText,image->rows-y-1,image->rows);s	         }l         free((char *) pixels);$         (void) IsPseudoClass(image);         break;       }      } %     image->pixels=(RunlengthPacket *)pM       realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));A     /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;#     status=TIFFReadDirectory(tiff);=     if (status == True)o       { 
         /*#           Allocate image structure.d
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           {R!             DestroyImages(image); #             return((Image *) NULL);            }nB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       })   } while (status == True);v   TIFFClose(tiff);   if (image->temporary)=(     (void) remove(image_info->filename);+   while (image->previous != (Image *) NULL)      image=image->previous;   return(image); }  #else 8 static Image *ReadTIFFImage(const ImageInfo *image_info) {r@   Warning("TIFF library is not available",image_info->filename);$   return(ReadMIFFImage(image_info)); }g #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%!O %                                                                             %mO %                                                                             % O %                                                                             % O %  R e a d T I L E I m a g e                                                  %-O %                                                                             % O %                                                                             %cO %                                                                             %mO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %eH %  Function ReadTILEImage tiles a texture on an image.  It allocates theL %  memory necessary for the new Image structure and returns a pointer to the
 %  new image., %m. %  The format of the ReadTILEImage routine is: % & %      image=ReadTILEImage(image_info) % + %  A description of each parameter follows:* % J %    o image:  Function ReadTILEImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %LA %    o image_info: Specifies a pointer to an ImageInfo structure.  %o %y */2 static Image *ReadTILEImage(ImageInfo *image_info) {]   Image      *image,c     *tiled_image;w     intg     x,     y;     unsigned int     height,1
     width;  $   tiled_image=ReadImage(image_info);$   if (tiled_image == (Image *) NULL)     return((Image *) NULL);+   /*     Allocate image structure.o   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);+   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512; (   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);0   /*     Initialize Image structure.    */   tiled_image->orphan=True; 2   image=CopyImage(tiled_image,width,height,False);   tiled_image->orphan=False;   if (image == (Image *) NULL);     PrematureExit("Unable to allocate memory",tiled_image);r6   (void) strcpy(image->filename,image_info->filename);   /*     Tile texture onto image.   */2   for (y=0; y < image->rows; y+=tiled_image->rows)   {u:     for (x=0; x < image->columns; x+=tiled_image->columns)?       CompositeImage(image,ReplaceCompositeOp,tiled_image,x,y);>4     ProgressMonitor(LoadImageText,y,image->columns);   }    DestroyImage(tiled_image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  R e a d U Y V Y I m a g e                                                  %pO %                                                                             % O %                                                                             %(O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %sI %  Function ReadUYVYImage reads an image in the UYVY (16bit/pixel) formatmG %  and returns it.  It allocates the memory necessary for the new Imagei4 %  structure and returns a pointer to the new image. % . %  The format of the ReadUYVYImage routine is: % & %      image=ReadUYVYImage(image_info) % + %  A description of each parameter follows:c %sJ %    o image:  Function ReadUYVYImage returns a pointer to the image afterL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %mA %    o image_info: Specifies a pointer to an ImageInfo structure.f %m %- */8 static Image *ReadUYVYImage(const ImageInfo *image_info) {    Image      *image;(     intu     x,     y;     register int     i;     register RunlengthPacket     *q;,     register unsigned char     *p;      unsigned charg     *uyvy_pixels;c     unsigned int     height, 
     width;     /*     Allocate image structure.t   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */6   (void) strcpy(image->filename,image_info->filename);-   OpenImage(image_info,image,ReadBinaryType);I#   if (image->file == (FILE *) NULL) .     PrematureExit("Unable to open file",image)   /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    for (i=0; i < x; i++)      (void) fgetc(image->file);   /*     Read data.   */   image->columns=width;    image->rows=height; ,   image->packets=image->columns*image->rows;   uyvy_pixels=(unsigned char *)e3     malloc((2*width*height)*sizeof(unsigned char)); #   image->pixels=(RunlengthPacket *)x3     malloc(image->packets*sizeof(RunlengthPacket)); 0   if ((uyvy_pixels == (unsigned char *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))5     PrematureExit("Unable to allocate memory",image); E   (void) ReadData((char *) uyvy_pixels,1,2*width*height,image->file);i   /*1     Accumulate UYVY, then unpack into two pixels.m   */   p=uyvy_pixels;   q=image->pixels;+   for (i=0; i < (image->packets >> 1); i++)i   {,     q->red=UpScale(p[1]);      q->green=UpScale(p[0]);d     q->blue=UpScale(p[2]);     q->index=0;      q->length=0;     q++;     q->red=UpScale(p[3]);o     q->green=UpScale(p[0]);l     q->blue=UpScale(p[2]);     q->index=0;>     q->length=0;     q++;	     p+=4;      if (QuantumTick(i,image))s;       ProgressMonitor(LoadImageText,i,image->packets >> 1);)   }    free((char *) uyvy_pixels);t+   TransformRGBImage(image,YCbCrColorspace);e   CompressImage(image);    return(image); }> e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             % O %                                                                             %eO %   R e a d V I C A R I m a g e                                               % O %                                                                             %eO %                                                                             %mO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %eG %  Function ReadVICARImage reads a VICAR image file and returns it.  ItoK %  allocates the memory necessary for the new Image structure and returns a; %  pointer to the new image. %%/ %  The format of the ReadVICARImage routine is:% %%' %      image=ReadVICARImage(image_info)  % + %  A description of each parameter follows:r % J %    o image: Function ReadVICARImage returns a pointer to the image afterO %      reading.  A null image is returned if there is a a memory shortage or if   %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.  %  %  */9 static Image *ReadVICARImage(const ImageInfo *image_info)  {    char     keyword[MaxTextExtent],      value[MaxTextExtent];      Image      *image;      int      c,     y;     long
     count;     register int     i,     x;     register RunlengthPacket     *q;%     register unsigned char     *p;t     unsigned chara     *vicar_pixels;     unsigned int     header_length,     status,e     value_expected;e     /*     Allocate image structure.p   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);m   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);a#   if (image->file == (FILE *) NULL)p/     PrematureExit("Unable to open file",image);l   /*     Decode image header.   */   c=fgetc(image->file);i
   count=1;   if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);e     }    header_length=0;;   while (isgraph(c) && ((image->columns*image->rows) == 0))m   {n     if (!isalnum(c))       {          c=fgetc(image->file);l         count++;       }      else       {t         register charf
           *p;   
         /*,           Determine a keyword and its value.
         */         p=keyword;
         do	         { .           if ((p-keyword) < (MaxTextExtent-1))             *p++=(char) c;           c=fgetc(image->file);L           count++;+         } while (isalnum(c) || (c == '_'));          *p='\0';         value_expected=False; (         while (isspace(c) || (c == '='))	         {e           if (c == '=')m              value_expected=True;           c=fgetc(image->file);=           count++;	         } $         if (value_expected == False)           continue;          p=value;         while (isalnum(c))	         { ,           if ((p-value) < (MaxTextExtent-1))             *p++=(char) c;           c=fgetc(image->file);            count++;	         }i         *p='\0';
         /*2           Assign a value to the specified keyword.
         */1         if (strcmp(keyword,"LABEL_RECORDS") == 0)t3           header_length=(unsigned int) atoi(value); +         if (strcmp(keyword,"LBLSIZE") == 0)O3           header_length=(unsigned int) atoi(value);(0         if (strcmp(keyword,"RECORD_BYTES") == 0)4           image->columns=(unsigned int) atoi(value);&         if (strcmp(keyword,"NS") == 0)4           image->columns=(unsigned int) atoi(value);)         if (strcmp(keyword,"LINES") == 0)d1           image->rows=(unsigned int) atoi(value);e&         if (strcmp(keyword,"NL") == 0)1           image->rows=(unsigned int) atoi(value);        }'     while (isspace(c))     {c       c=fgetc(image->file);e       count++;     }    }g   /*      Read the rest of the header.   */   while (count < header_length)m   {n     c=fgetc(image->file);u     count++;   }    /*6     Verify that required image information is defined.   */(   if ((image->columns*image->rows) == 0).     PrematureExit("image size is zero",image);   /*     Create linear colormap.    */   image->class=PseudoClass;n   image->colors=256;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));.   if (image->colormap == (ColorPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);*#   for (i=0; i < image->colors; i++)m   {m0     image->colormap[i].red=(Quantum) UpScale(i);2     image->colormap[i].green=(Quantum) UpScale(i);1     image->colormap[i].blue=(Quantum) UpScale(i);R   }t   /*     Initialize image structure.    */,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)m3     malloc(image->packets*sizeof(RunlengthPacket));lN   vicar_pixels=(unsigned char *) malloc(image->packets*sizeof(unsigned char));4   if ((image->pixels == (RunlengthPacket *) NULL) ||/       (vicar_pixels == (unsigned char *) NULL))e5     PrematureExit("Unable to read image data",image);    /*6     Convert VICAR pixels to runlength-encoded packets.   */F   status=ReadData((char *) vicar_pixels,1,image->packets,image->file);   if (status == False);     PrematureExit("Insufficient image data in file",image);'   /*6     Convert VICAR pixels to runlength-encoded packets.   */   p=vicar_pixels;    q=image->pixels;!   for (y=0; y < image->rows; y++)(   {n&     for (x=0; x < image->columns; x++)     {t#       q->index=(unsigned short) *p;(       q->length=0;
       p++;
       q++;     }a1     ProgressMonitor(LoadImageText,y,image->rows);    }t   free((char *) vicar_pixels);   SyncImage(image);)   CompressColormap(image);   CompressImage(image);'   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%mO %                                                                             % O %                                                                             %=O %                                                                             %)O %  R e a d V I D I m a g e                                                    % O %                                                                             % O %                                                                             %cO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function ReadVIDImage reads one of more images and creates a Visual ImageG %  Directory file.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. %r- %  The format of the ReadVIDImage routine is:  %g% %      image=ReadVIDImage(image_info)a %B+ %  A description of each parameter follows:u %QI %    o image:  Function ReadVIDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  %/A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadVIDImage(const ImageInfo *image_info)l {o #define ClientName  "montage"      char     *commands[5],      **filelist,c     **list,u     *resource_value;  	   Display_
     *display;      Image      *image,      *montage_image,t     *next_image;     ImageInfo      local_info;l     int-     number_files;h     register int     i;     XMontageInfo     montage_info;      XResourceInfo      resource_info;  
   XrmDatabased     resource_database;     /*     Expand the filename.   */(   list=(char **) malloc(sizeof(char *));   if (list == (char **) NULL)      { 7       Warning("Memory allocation error",(char *) NULL);=       return((Image *) NULL);      }n:   list[0]=(char *) malloc(Extent(image_info->filename)+1);   if (list[0] == (char *) NULL)(     {p7       Warning("Memory allocation error",(char *) NULL);g       return((Image *) NULL);      }g.   (void) strcpy(list[0],image_info->filename);   number_files=1;a   filelist=list;+   ExpandFilenames(&number_files,&filelist);*   if (number_files == 0)     { =       Warning("VID translation failed",image_info->filename);        return((Image *) NULL);      }l   /*     Open X server connection.    */7   resource_info.background_color=DefaultTileBackground; :   resource_info.border_width=atoi(DefaultTileBorderwidth);7   resource_info.foreground_color=DefaultTileForeground; &   resource_info.gravity=CenterGravity;3   resource_info.image_geometry=DefaultTileGeometry;m-   resource_info.matte_color=DefaultTileMatte; $   resource_info.title=(char *) NULL;0   display=XOpenDisplay(image_info->server_name);"   if (display != (Display *) NULL)     {0       /*(         Set our forgiving error handler.       */       XSetErrorHandler(XError);G       /*3         Get user defaults from X resource database.l       */B       resource_database=XGetResourceDatabase(display,client_name);D       XGetResourceInfo(resource_database,ClientName,&resource_info);L       resource_info.background_color=XGetResourceInstance(resource_database,7         ClientName,"background",DefaultTileBackground);gD       resource_value=XGetResourceClass(resource_database,ClientName,.         "borderWidth",DefaultTileBorderwidth);6       resource_info.border_width=atoi(resource_value);*       resource_info.font=image_info->font;L       resource_info.foreground_color=XGetResourceInstance(resource_database,7         ClientName,"foreground",DefaultTileForeground); J       resource_info.image_geometry=XGetResourceInstance(resource_database,8         ClientName,"imageGeometry",DefaultTileGeometry);G       resource_info.matte_color=XGetResourceInstance(resource_database, 2         ClientName,"mattecolor",DefaultTileMatte);       XCloseDisplay(display);      } 4   resource_info.server_name=image_info->server_name;   /*/     Read each image and convert them to a tile.d   */   image=(Image *) NULL;    local_info=(*image_info);+   commands[0]=client_name;   commands[1]="-label";s   commands[2]=DefaultTileLabel; "   for (i=0; i < number_files; i++)   {r)     if (local_info.size == (char *) NULL)e3       local_info.size=resource_info.image_geometry;n$     local_info.filename=filelist[i];     *local_info.magick='\0';&     next_image=ReadImage(&local_info);     free((char *) filelist[i]); %     if (next_image != (Image *) NULL)        {&:         MogrifyImages(&local_info,3,commands,&next_image);$         if (image == (Image *) NULL)           image=next_image;          else           { #             image->next=next_image;e(             image->next->previous=image;             image=image->next;           }f       }p2     ProgressMonitor(LoadImageText,i,number_files);   }    free((char *) filelist);   if (image == (Image *) NULL)     {t=       Warning("VID translation failed",image_info->filename);t       return((Image *) NULL);      } +   while (image->previous != (Image *) NULL)e     image=image->previous;   /*&     Create the visual image directory.   */!   XGetMontageInfo(&montage_info);p"   montage_info.texture="granite:";<   (void) strcpy(montage_info.filename,image_info->filename);C   montage_image=XMontageImages(&resource_info,&montage_info,image);x&   if (montage_image == (Image *) NULL)     { =       Warning("VID translation failed",image_info->filename);g       return((Image *) NULL);      }I   DestroyImages(image);    free((char *) list[0]);    free((char *) list);   return(montage_image); }  i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*O %                                                                             % O %                                                                             %eO %                                                                             %(O %   R e a d V I F F I m a g e                                                 %0O %                                                                             %hO %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function ReadVIFFImage reads a Khoros Visualization image file and returnseI %  it.  It allocates the memory necessary for the new Image structure andh& %  returns a pointer to the new image. %p. %  The format of the ReadVIFFImage routine is: % & %      image=ReadVIFFImage(image_info) %o+ %  A description of each parameter follows:x %+I %    o image: Function ReadVIFFImage returns a pointer to the image after O %      reading.  A null image is returned if there is a a memory shortage or iff  %      the image cannot be read. % 9 %    o filename: Specifies the name of the image to read.o %o %m */8 static Image *ReadVIFFImage(const ImageInfo *image_info) {  #define VFF_CM_genericRGB  15i #define VFF_CM_ntscRGB  1  #define VFF_CM_NONE  0 #define VFF_DEP_DECORDER  0x4s #define VFF_DEP_NSORDER  0x8 #define VFF_DES_RAW  0 #define VFF_LOC_IMPLICIT  1  #define VFF_MAPTYP_NONE  0 #define VFF_MAPTYP_1_BYTE  1 #define VFF_MS_NONE  0 #define VFF_MS_ONEPERBAND  1 #define VFF_MS_SHARED  3 #define VFF_TYP_BIT  0 #define VFF_TYP_1_BYTE  1m #define VFF_TYP_2_BYTE  2f #define VFF_TYP_4_BYTE  4i     typedef struct _ViffHeader   {      unsigned char;       identifier,        file_type,       release,       version,       machine_dependency,        reserve[3];        char       comment[512];        unsigned longs       rows,        columns,       subrows;       long       x_offset,        y_offset;g  	     floatn       x_pixel_size,o       y_pixel_size;        unsigned longx       location_type,       location_dimension,        number_of_images,l       number_data_bands,       data_storage_type,       data_encode_scheme,a       map_scheme,g       map_storage_type,        map_rows,m       map_columns,       map_subrows,       map_enable,i       maps_per_cycle,        color_space_model;   } ViffHeader;      Image      *image;s     register int     bit,     i,     x,     y;     register Quantum     *p;      register RunlengthPacket     *q;      unsigned chart     buffer[7],     *viff_pixels;t     unsigned int     bytes_per_pixel,     status;+     unsigned long      packets;     ViffHeader     viff_header;     /*     Allocate image structure.x   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);g   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType); #   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);    /*"     Read VIFF header (1024 bytes).   */D   status=ReadData((char *) &viff_header.identifier,1,1,image->file);   do   {      /*       Verify VIFF identifier.      */N     if ((status == False) || ((unsigned char) viff_header.identifier != 0xab))/       PrematureExit("Not a VIFF raster",image);      /*       Initialize VIFF image.     */5     (void) ReadData((char *) buffer,1,7,image->file);)$     viff_header.file_type=buffer[0];"     viff_header.release=buffer[1];"     viff_header.version=buffer[2];-     viff_header.machine_dependency=buffer[3];;D     (void) ReadData((char *) viff_header.comment,1,512,image->file);"     viff_header.comment[511]='\0';(     if (Extent(viff_header.comment) > 4)       {           image->comments=(char *)N           malloc((unsigned int) (Extent(viff_header.comment)+1)*sizeof(char));-         if (image->comments == (char *) NULL)x;           PrematureExit("Unable to allocate memory",image);t;         (void) strcpy(image->comments,viff_header.comment);        }m?     if ((viff_header.machine_dependency == VFF_DEP_DECORDER) || <         (viff_header.machine_dependency == VFF_DEP_NSORDER))       {b7         viff_header.rows=LSBFirstReadLong(image->file); :         viff_header.columns=LSBFirstReadLong(image->file);:         viff_header.subrows=LSBFirstReadLong(image->file);B         viff_header.x_offset=(long) LSBFirstReadLong(image->file);B         viff_header.y_offset=(long) LSBFirstReadLong(image->file);G         viff_header.x_pixel_size=(float) LSBFirstReadLong(image->file);fG         viff_header.y_pixel_size=(float) LSBFirstReadLong(image->file); @         viff_header.location_type=LSBFirstReadLong(image->file);E         viff_header.location_dimension=LSBFirstReadLong(image->file);fC         viff_header.number_of_images=LSBFirstReadLong(image->file); D         viff_header.number_data_bands=LSBFirstReadLong(image->file);D         viff_header.data_storage_type=LSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=LSBFirstReadLong(image->file); =         viff_header.map_scheme=LSBFirstReadLong(image->file); C         viff_header.map_storage_type=LSBFirstReadLong(image->file);=;         viff_header.map_rows=LSBFirstReadLong(image->file);l>         viff_header.map_columns=LSBFirstReadLong(image->file);>         viff_header.map_subrows=LSBFirstReadLong(image->file);=         viff_header.map_enable=LSBFirstReadLong(image->file); A         viff_header.maps_per_cycle=LSBFirstReadLong(image->file);-D         viff_header.color_space_model=LSBFirstReadLong(image->file);       }      else       {-7         viff_header.rows=MSBFirstReadLong(image->file);g:         viff_header.columns=MSBFirstReadLong(image->file);:         viff_header.subrows=MSBFirstReadLong(image->file);B         viff_header.x_offset=(long) MSBFirstReadLong(image->file);B         viff_header.y_offset=(long) MSBFirstReadLong(image->file);G         viff_header.x_pixel_size=(float) MSBFirstReadLong(image->file); G         viff_header.y_pixel_size=(float) MSBFirstReadLong(image->file); @         viff_header.location_type=MSBFirstReadLong(image->file);E         viff_header.location_dimension=MSBFirstReadLong(image->file); C         viff_header.number_of_images=MSBFirstReadLong(image->file); D         viff_header.number_data_bands=MSBFirstReadLong(image->file);D         viff_header.data_storage_type=MSBFirstReadLong(image->file);E         viff_header.data_encode_scheme=MSBFirstReadLong(image->file); =         viff_header.map_scheme=MSBFirstReadLong(image->file);%C         viff_header.map_storage_type=MSBFirstReadLong(image->file); ;         viff_header.map_rows=MSBFirstReadLong(image->file); >         viff_header.map_columns=MSBFirstReadLong(image->file);>         viff_header.map_subrows=MSBFirstReadLong(image->file);=         viff_header.map_enable=MSBFirstReadLong(image->file);iA         viff_header.maps_per_cycle=MSBFirstReadLong(image->file);rD         viff_header.color_space_model=MSBFirstReadLong(image->file);       }a     for (i=0; i < 420; i++)n        (void) fgetc(image->file);     /*.       Verify that we can read this VIFF image.     */4     if ((viff_header.columns*viff_header.rows) == 0)G       PrematureExit("Image column or row size is not supported",image);a9     if ((viff_header.data_storage_type != VFF_TYP_BIT) &&n<         (viff_header.data_storage_type != VFF_TYP_1_BYTE) &&<         (viff_header.data_storage_type != VFF_TYP_2_BYTE) &&:         (viff_header.data_storage_type != VFF_TYP_4_BYTE))@       PrematureExit("Data storage type is not supported",image);6     if (viff_header.data_encode_scheme != VFF_DES_RAW)C       PrematureExit("Data encoding scheme is not supported",image);s<     if ((viff_header.map_storage_type != VFF_MAPTYP_NONE) &&<         (viff_header.map_storage_type != VFF_MAPTYP_1_BYTE))?       PrematureExit("Map storage type is not supported",image);n9     if ((viff_header.color_space_model != VFF_CM_NONE) &&e<         (viff_header.color_space_model != VFF_CM_ntscRGB) &&=         (viff_header.color_space_model != VFF_CM_genericRGB))a?       PrematureExit("Colorspace model is not supported",image); 6     if (viff_header.location_type != VFF_LOC_IMPLICIT)       { B         Warning("Location type is not supported",image->filename);         DestroyImages(image);I         return((Image *) NULL);U       }o*     if (viff_header.number_of_images != 1)?       PrematureExit("Number of images is not supported",image); #     switch (viff_header.map_scheme)e     {y       case VFF_MS_NONE:        { .         if (viff_header.number_data_bands < 3)           {r             /*'               Create linear color ramp.,             */=             if (viff_header.data_storage_type == VFF_TYP_BIT)o               image->colors=2;             elseN               image->colors=1 << (viff_header.number_data_bands*QuantumDepth);+             image->colormap=(ColorPacket *)n8               malloc(image->colors*sizeof(ColorPacket));8             if (image->colormap == (ColorPacket *) NULL)?               PrematureExit("Unable to allocate memory",image);2-             for (i=0; i < image->colors; i++)'
             {gB               image->colormap[i].red=(MaxRGB*i)/(image->colors-1);D               image->colormap[i].green=(MaxRGB*i)/(image->colors-1);C               image->colormap[i].blue=(MaxRGB*i)/(image->colors-1);X
             }m           }e         break;       }        case VFF_MS_ONEPERBAND:g       case VFF_MS_SHARED:        {i         unsigned chars           *viff_colormap;s  
         /*$           Read VIFF raster colormap.
         */=         image->colors=(unsigned int) viff_header.map_columns;-'         image->colormap=(ColorPacket *)r4           malloc(image->colors*sizeof(ColorPacket));'         viff_colormap=(unsigned char *)-6           malloc(image->colors*sizeof(unsigned char));8         if ((image->colormap == (ColorPacket *) NULL) ||6             (viff_colormap == (unsigned char *) NULL));           PrematureExit("Unable to allocate memory",image); L         (void) ReadData((char *) viff_colormap,1,image->colors,image->file);)         for (i=0; i < image->colors; i++)t	         {e;           image->colormap[i].red=UpScale(viff_colormap[i]); =           image->colormap[i].green=UpScale(viff_colormap[i]);x<           image->colormap[i].blue=UpScale(viff_colormap[i]);	         }d%         if (viff_header.map_rows > 1)m           {eP             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++)fA               image->colormap[i].green=UpScale(viff_colormap[i]);            } %         if (viff_header.map_rows > 2)            { P             (void) ReadData((char *) viff_colormap,1,image->colors,image->file);-             for (i=0; i < image->colors; i++) @               image->colormap[i].blue=UpScale(viff_colormap[i]);           }i%         free((char *) viff_colormap);f         break;       }        default:>         PrematureExit("Colormap type is not supported",image);     }s     /*       Allocate VIFF pixels.r     */     bytes_per_pixel=1;8     if (viff_header.data_storage_type == VFF_TYP_2_BYTE)       bytes_per_pixel=2;8     if (viff_header.data_storage_type == VFF_TYP_4_BYTE)       bytes_per_pixel=4;5     if (viff_header.data_storage_type == VFF_TYP_BIT)g>       packets=((viff_header.columns+7) >> 3)*viff_header.rows;     else       packets=K         viff_header.columns*viff_header.rows*viff_header.number_data_bands;,!     viff_pixels=(unsigned char *)o6       malloc(bytes_per_pixel*packets*sizeof(Quantum));.     if (viff_pixels == (unsigned char *) NULL)7       PrematureExit("Unable to allocate memory",image);fP     (void) ReadData((char *) viff_pixels,bytes_per_pixel,(unsigned int) packets,       image->file);s*     switch (viff_header.data_storage_type)     {i	       intp         max_value,         min_value,         value;         register Quantum         *q;e         unsigned longi         scale_factor;>         case VFF_TYP_1_BYTE:       {D         register unsigned char
           *p;l           if (QuantumDepth == 8)           break;
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=viff_pixels;"         q=(Quantum *) viff_pixels;         p+=packets-1;          q+=packets-1;s#         for (i=0; i < packets; i++)c	         {m           value=UpScale(*p);           *q=(Quantum) value;s           p--;           q--;	         }          break;       }S       case VFF_TYP_2_BYTE:       {i         register short int
           *p;d  
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) ||>@             (viff_header.machine_dependency == VFF_DEP_NSORDER))3           MSBFirstOrderShort((char *) &viff_header,_6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor. 
         */$         p=(short int *) viff_pixels;         max_value=(*p);t         min_value=(*p);d#         for (i=0; i < packets; i++)_	         {a           if (*p > max_value)              max_value=(*p);i           else             if (*p < min_value)p               min_value=(*p);g           p++;	         } 1         if ((min_value == 0) && (max_value == 0))e           scale_factor=0;          else%           if (min_value == max_value)v
             {m5               scale_factor=UpShift(MaxRGB)/min_value;n               min_value=0;
             }t           else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value);f
         /*.           Scale integer pixels to [0..MaxRGB].
         */$         p=(short int *) viff_pixels;"         q=(Quantum *) viff_pixels;#         for (i=0; i < packets; i++)P	         {e7           value=DownShift((*p-min_value)*scale_factor);u           if (value > MaxRGB)s             value=MaxRGB;m           else             if (value < 0)               value=0;           *q=(Quantum) value;=           p++;           q++;	         }m         break;       }f       case VFF_TYP_4_BYTE:       {          register int
           *p;a  
         /*F           Ensure the header byte-order is most-significant byte first.
         */C         if ((viff_header.machine_dependency == VFF_DEP_DECORDER) ||t@             (viff_header.machine_dependency == VFF_DEP_NSORDER))2           MSBFirstOrderLong((char *) &viff_header,6             (unsigned int) (bytes_per_pixel*packets));
         /*!           Determine scale factor.;
         */         p=(int *) viff_pixels;         max_value=(*p);%         min_value=(*p); #         for (i=0; i < packets; i++) 	         {            if (*p > max_value)              max_value=(*p);            else             if (*p < min_value)                min_value=(*p);            p++;	         } 1         if ((min_value == 0) && (max_value == 0))I           scale_factor=0;          else%           if (min_value == max_value) 
             { 5               scale_factor=UpShift(MaxRGB)/min_value;                min_value=0;
             }            else?             scale_factor=UpShift(MaxRGB)/(max_value-min_value); 
         /*.           Scale integer pixels to [0..MaxRGB].
         */         p=(int *) viff_pixels;"         q=(Quantum *) viff_pixels;#         for (i=0; i < packets; i++)t	         {l7           value=DownShift((*p-min_value)*scale_factor);a           if (value > MaxRGB)              value=MaxRGB;a           else             if (value < 0)               value=0;#           *q=(unsigned char) value;i           p++;           q++;	         }i         break;       }N     }      /*!       Initialize image structure.      */6     image->matte=(viff_header.number_data_bands == 4);     image->class=hF       (viff_header.number_data_bands < 3 ? PseudoClass : DirectClass);3     image->columns=(unsigned int) viff_header.rows;e3     image->rows=(unsigned int) viff_header.columns;h.     image->packets=image->columns*image->rows;%     image->pixels=(RunlengthPacket *) 5       malloc(image->packets*sizeof(RunlengthPacket)); 2     if (image->pixels == (RunlengthPacket *) NULL)7       PrematureExit("Unable to allocate memory",image);u     /*=       Convert VIFF raster image to runlength-encoded packets.g     */     p=(Quantum *) viff_pixels;     q=image->pixels;5     if (viff_header.data_storage_type == VFF_TYP_BIT)e       {I         unsigned int           polarity;r  
         /*E           Convert bitmap scanline to runlength-encoded color packets.r
         */H         polarity=(viff_header.machine_dependency == VFF_DEP_DECORDER) ||>           (viff_header.machine_dependency == VFF_DEP_NSORDER);'         for (y=0; y < image->rows; y++) 	         {            /*G             Convert bitmap scanline to runlength-encoded color packets.r           */3           for (x=0; x < (image->columns >> 3); x++)r           {R'             for (bit=0; bit < 8; bit++)*
             {oE               q->index=((*p) & (0x01 << bit) ? polarity : !polarity);e               q->length=0;               q++;
             }a             p++;           }i(           if ((image->columns % 8) != 0)
             {l<               for (bit=0; bit < (image->columns % 8); bit++)               {aG                 q->index=((*p) & (0x01 << bit) ? polarity : !polarity);%                 q->length=0;                 q++;               }                p++;
             }"7           ProgressMonitor(LoadImageText,y,image->rows); 	         }        }      else&       if (image->class == PseudoClass)'         for (y=0; y < image->rows; y++)e	         {I           /*L             Convert PseudoColor scanline to runlength-encoded color packets.           */,           for (x=0; x < image->columns; x++)           {              q->index=(*p++);             q->length=0;             q++;           } 7           ProgressMonitor(LoadImageText,y,image->rows);%	         }%
       else	         {%           unsigned long%             offset;              /*L             Convert DirectColor scanline to runlength-encoded color packets.           */,           offset=image->columns*image->rows;)           for (y=0; y < image->rows; y++)m           {T.             for (x=0; x < image->columns; x++)
             {a               q->red=(*p);%               q->green=(*(p+offset));o&               q->blue=(*(p+offset*2));%               if (image->colors != 0)f                 {g5                   q->red=image->colormap[q->red].red;t;                   q->green=image->colormap[q->green].green;e8                   q->blue=image->colormap[q->blue].blue;                 }aM               q->index=(unsigned short) (image->matte ? (*(p+offset*3)) : 0);                q->length=0;               p++;               q++;
             } 9             ProgressMonitor(LoadImageText,y,image->rows);r           }r	         }      free((char *) viff_pixels);;$     if (image->class == PseudoClass)       {z         SyncImage(image);d          CompressColormap(image);       }a     CompressImage(image);g     /*       Proceed to next image.     */F     status=ReadData((char *) &viff_header.identifier,1,1,image->file);=     if ((status == True) && (viff_header.identifier == 0xab))        {t
         /*#           Allocate image structure.i
         */.         image->next=AllocateImage(image_info);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }nB         (void) strcpy(image->next->filename,image_info->filename);&         image->next->file=image->file;*         image->next->scene=image->scene+1;$         image->next->previous=image;         image=image->next;       }aA   } while ((status == True) && (viff_header.identifier == 0xab));3+   while (image->previous != (Image *) NULL)=     image=image->previous;   CloseImage(image);   return(image); }t > /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hO %                                                                             %aO %                                                                             %nO %                                                                             % O %   R e a d X I m a g e                                                       %DO %                                                                             %*O %                                                                             %gO %                                                                             %!O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%s % 8 %  Procedure ReadXImage reads an image from an X window. %s+ %  The format of the ReadXImage routine is:l %R@ %      image=ReadXImage(image_info,frame,borders,screen,descend) %t+ %  A description of each parameter follows:e %)A %    o image_info: Specifies a pointer to an ImageInfo structure.  %*L %    o frame: Specifies whether to include the window manager frame with the
 %      image.n %lE %    o borders: Specifies whether borders pixels are to be saved with  %      the image.o %tN %    o screen: Specifies whether the GetImage request used to obtain the imageO %      should be done on the root window, rather than directly on the specified  %      window. %xO %    o descend: If this option is zero, check to see if the WM_COLORMAP_WINDOWS J %      property is set or if XListInstalledColormaps returns more than oneG %      colormap.  If so, the image is obtained by descending the window_= %      hierarchy and reading each subwindow and its colormap.  %  %  */H Export Image *ReadXImage(ImageInfo *image_info,const unsigned int frame,L   const unsigned int borders,const unsigned int screen,unsigned int descend) {m
   Colormap     *colormaps;e  	   Displayi
     *display;      Imagen     *image;      int;     status,      x;     RectangleInfo(     crop_info;     Window     *children,     client,;     prior_target,a	     root,r     target;      XTextProperty      window_name;     /*     Open X server connection.B   */0   display=XOpenDisplay(image_info->server_name);"   if (display == (Display *) NULL)     { .       Warning("Unable to connect to X server",/         XDisplayName(image_info->server_name));m       return((Image *) NULL);      }    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);t   /*     Select target window.i   */   crop_info.x=0;   crop_info.y=0;   crop_info.width=0;   crop_info.height=0;l4   root=XRootWindow(display,XDefaultScreen(display));   target=(Window) NULL;-0   if ((image_info->filename != (char *) NULL) &&&       (*image_info->filename != '\0'))8     if (Latin1Compare(image_info->filename,"root") == 0)       target=root;     else       {g
         /*&           Select window by ID or name.
         */+         if (isdigit(*image_info->filename)) O           target=XWindowByID(display,root,(Window) strtol(image_info->filename,e             (char **) NULL,0)); $         if (target == (Window) NULL)B           target=XWindowByName(display,root,image_info->filename);$         if (target == (Window) NULL)M           Warning("No window with specified id exists",image_info->filename);        }      /*>     If target window is not defined, interactively select one.   */   prior_target=target;   if (target == (Window) NULL)-     target=XSelectWindow(display,&crop_info);,!   client=target;   /* obsolete */n   if (target != root)e     {        unsigned int
         d;  B       status=XGetGeometry(display,target,&root,&x,&x,&d,&d,&d,&d);       if (status != 0)	         {n           for ( ; ; )            {;             Window               parent;                /*(               Find window manager frame.             */I             status=XQueryTree(display,target,&root,&parent,&children,&d); 8             if (status && (children != (Window *) NULL))'               XFree((char *) children);GI             if (!status || (parent == (Window) NULL) || (parent == root))i               break;             target=parent;           }m           /*             Get client window.           *//           client=XClientWindow(display,target);I           if (!frame)              target=client;%           if (!frame && prior_target)               target=prior_target;'           XRaiseWindow(display,target); +           XDelay(display,SuspendTime << 4);k	         }t     }-
   if (screen)      { 	       intn
         y;         Window         child;         XWindowAttributes          window_attributes;         /*1         Obtain window image directly from screen.(       */E       status=XGetWindowAttributes(display,target,&window_attributes);,       if (status == False)	         {cM           Warning("Unable to read X window attributes",image_info->filename); !           XCloseDisplay(display); !           return((Image *) NULL); 	         }=B       XTranslateCoordinates(display,target,root,0,0,&x,&y,&child);       crop_info.x=x;       crop_info.y=y;.       crop_info.width=window_attributes.width;0       crop_info.height=window_attributes.height;       if (borders)	         {g           /*$             Include border in image.           */6           crop_info.x-=window_attributes.border_width;6           crop_info.y-=window_attributes.border_width;?           crop_info.width+=window_attributes.border_width << 1; @           crop_info.height+=window_attributes.border_width << 1;	         }t       target=root;     }    if (descend)     {m	       inty         number_colormaps,          number_windows;s         /*N         If WM_COLORMAP_WINDOWS property is set or multiple colormaps, descend.       */       descend=False;       number_windows=0; M       status=XGetWMColormapWindows(display,target,&children,&number_windows);g3       if ((status == True) && (number_windows > 0)) 	         {g           descend=True;i$           XFree ((char *) children);	         }aJ       colormaps=XListInstalledColormaps(display,target,&number_colormaps);       if (number_colormaps > 0)B	         { #           if (number_colormaps > 1)E             descend=True;r$           XFree((char *) colormaps);	         }      }    /*+     Alert the user not to alter the screen.i   */   XBell(display,0);    /*     Get image by window id.l   */   XGrabServer(display);l8   image=XGetWindowImage(display,target,borders,descend);   XUngrabServer(display);(   if (image == (Image *) NULL)B     Warning("Unable to read X window image",image_info->filename);   else     { :       (void) strcpy(image->filename,image_info->filename);<       if ((crop_info.width != 0) && (crop_info.height != 0))	         {o           Image+             *cropped_image;              /*<             Crop image as defined by the cropping rectangle.           */4           cropped_image=CropImage(image,&crop_info);.           if (cropped_image != (Image *) NULL)
             {i"               DestroyImage(image);"               image=cropped_image;
             }m	         }n5       status=XGetWMName(display,target,&window_name);f       if (status == True) 	         { 8           if ((image_info->filename != (char *) NULL) &&.               (*image_info->filename == '\0'))
             {                /**                 Initialize image filename.               */H               (void) strncpy(image->filename,(char *) window_name.value,*                 (int) window_name.nitems);7               image->filename[window_name.nitems]='\0'; 
             }c,           XFree((void *) window_name.value);	         }      }c   /*     Alert the user we're done.   */   XBell(display,0);d   XBell(display,0);    CompressImage(image);    XCloseDisplay(display);o   return(image); }p ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%cO %                                                                             %;O %                                                                             %)O %                                                                             % O %  R e a d X B M I m a g e                                                    %*O %                                                                             % O %                                                                             %oO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function ReadXBMImage reads an X11 bitmap image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. %;- %  The format of the ReadXBMImage routine is:l %c% %      image=ReadXBMImage(image_info)  %a+ %  A description of each parameter follows:r %(I %    o image:  Function ReadXBMImage returns a pointer to the image after%L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static int XBMInteger(FILE *file,short int *hex_digits)  {    int      c,	     flag, 
     value;  
   value=0;	   flag=0;R
   for ( ; ; )m   {e     c=fgetc(file);     if (c == EOF)        {          value=(-1);          break;       }      c&=0xff;     if (isxdigit(c))       { )         value=(value << 4)+hex_digits[c];          flag++;          continue;        } $     if ((hex_digits[c]) < 0 && flag)       break;   }    return(value); }%  7 static Image *ReadXBMImage(const ImageInfo *image_info)% {%   char     buffer[MaxTextExtent],     name[MaxTextExtent];     Image      *image;      register int     x,     y;     register RunlengthPacket     *q;      register unsigned char     *p;h     short inti     hex_digits[256];     unsigned chary     bit,
     *data;     unsigned int	     byte,e     bytes_per_line,A     packets,     padding,
     value,     version;     /*     Allocate image structure.p   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);i#   if (image->file == (FILE *) NULL) /     PrematureExit("Unable to open file",image);o   /*     Read X bitmap header.I   */D   while (fgets(buffer,MaxTextExtent-1,image->file) != (char *) NULL)A     if (sscanf(buffer,"#define %s %u",name,&image->columns) == 2)mM       if ((strlen(name) >= 6) && (strcmp(name+strlen(name)-6,"_width") == 0))d           break;D   while (fgets(buffer,MaxTextExtent-1,image->file) != (char *) NULL)>     if (sscanf(buffer,"#define %s %u",name,&image->rows) == 2)N       if ((strlen(name) >= 7) && (strcmp(name+strlen(name)-7,"_height") == 0))           break;   /*     Scan until hex digits.   */
   version=11;]D   while (fgets(buffer,MaxTextExtent-1,image->file) != (char *) NULL)   { 7     if (sscanf(buffer,"static short %s = {",name) == 1),       version=10;,     elseA       if (sscanf(buffer,"static unsigned char %s = {",name) == 1)8         version=11; 
       else:         if (sscanf(buffer,"static char %s = {",name) == 1)           version=11;          else           continue;y*     p=(unsigned char *) strrchr(name,'_');$     if (p == (unsigned char *) NULL)       p=(unsigned char *) name;p     else
       p++;)     if (strcmp("bits[]",(char *) p) == 0)        break;   }lG   if ((image->columns == 0) || (image->rows == 0) || feof(image->file))eA     PrematureExit("XBM file is not in the correct format",image);H   /*     Initialize image structure.c   */,   image->packets=image->columns*image->rows;   image->class=PseudoClass;c   image->colors=2;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));#   image->pixels=(RunlengthPacket *)l3     malloc(image->packets*sizeof(RunlengthPacket));)   padding=0;O   if ((image->columns % 16) && ((image->columns % 16) < 9)  && (version == 10))l     padding=1;.   bytes_per_line=(image->columns+7)/8+padding;%   packets=bytes_per_line*image->rows;-A   data=(unsigned char *) malloc(packets*sizeof(unsigned char *));;2   if ((image->colormap == (ColorPacket *) NULL) ||4       (image->pixels == (RunlengthPacket *) NULL) ||'       (data == (unsigned char *) NULL))i5     PrematureExit("Unable to allocate memory",image);r   /*     Initialize colormap.   */   image->colormap[0].red=0;r   image->colormap[0].green=0;S   image->colormap[0].blue=0;    image->colormap[1].red=MaxRGB;"   image->colormap[1].green=MaxRGB;!   image->colormap[1].blue=MaxRGB;l   /*     Initialize hex values.   */   hex_digits['0']=0;   hex_digits['1']=1;   hex_digits['2']=2;   hex_digits['3']=3;   hex_digits['4']=4;   hex_digits['5']=5;   hex_digits['6']=6;   hex_digits['7']=7;   hex_digits['8']=8;   hex_digits['9']=9;   hex_digits['A']=10;d   hex_digits['B']=11;d   hex_digits['C']=12;    hex_digits['D']=13;)   hex_digits['E']=14;i   hex_digits['F']=15;R   hex_digits['a']=10;a   hex_digits['b']=11;a   hex_digits['c']=12;a   hex_digits['d']=13;e   hex_digits['e']=14;a   hex_digits['f']=15;a   hex_digits['x']=0;   hex_digits[' ']=(-1);g   hex_digits[',']=(-1);D   hex_digits['}']=(-1);h   hex_digits['\n']=(-1);   hex_digits['\t']=(-1);   /*     Read hex image data.   */	   p=data;)   if (version == 10)"     for (x=0; x < packets; (x+=2))     {R/       value=XBMInteger(image->file,hex_digits);g       *p++=value;)/       if (!padding || ((x+2) % bytes_per_line))>         *p++=value >> 8;     })   else     for (x=0; x < packets; x++)      {R/       value=XBMInteger(image->file,hex_digits);)       *p++=value;t     }    /*8     Convert X bitmap image to runlength-encoded packets.   */	   byte=0;e	   p=data;g   q=image->pixels;!   for (y=0; y < image->rows; y++)t   {o
     bit=0;&     for (x=0; x < image->columns; x++)     {h       if (bit == 0)          byte=(*p++);#       q->index=byte & 0x01 ? 0 : 1;i       q->length=0;
       q++;       bit++;       byte>>=1;i       if (bit == 8)r         bit=0;     }m1     ProgressMonitor(LoadImageText,y,image->rows);t   }h   SyncImage(image);    CompressImage(image);F   CloseImage(image);   free((char *) data);   return(image); }h ( /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %rO %                                                                             %cO %                                                                             % O %  R e a d X C I m a g e                                                      %nO %                                                                             %tO %                                                                             %;O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %tJ %  Function ReadXCImage creates a constant image and initializes it to theH %  X server color as specified by the filename.  It allocates the memoryI %  necessary for the new Image structure and returns a pointer to the new 	 %  image.m % , %  The format of the ReadXCImage routine is: %)$ %      image=ReadXCImage(image_info) %i+ %  A description of each parameter follows:m %tH %    o image:  Function ReadXCImage returns a pointer to the image afterL %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. %IA %    o image_info: Specifies a pointer to an ImageInfo structure.  %F %t */6 static Image *ReadXCImage(const ImageInfo *image_info) {m   Imagel     *image;0     intg     x,     y;     register int     i;     register RunlengthPacket     *q;L     unsigned int     height, 
     width;     XColor
     color;     /*     Allocate image structure.o   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*-     Determine width and height, e.g. 640x512.    */   width=512;
   height=512;((   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);    /*     Initialize Image structure.    */6   (void) strcpy(image->filename,image_info->filename);   image->columns=width;a   image->rows=height;iL   image->packets=((Max(image->columns*image->rows,1)-1)/(MaxRunlength+1))+1;#   image->pixels=(RunlengthPacket *) 3     malloc(image->packets*sizeof(RunlengthPacket));    image->class=PseudoClass;    image->colors=1;L   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));4   if ((image->pixels == (RunlengthPacket *) NULL) ||0       (image->colormap == (ColorPacket *) NULL))5     PrematureExit("Unable to allocate memory",image);    /*     Initialize colormap.   */:   (void) XQueryColorDatabase(image_info->filename,&color);/   image->colormap[0].red=XDownScale(color.red); 3   image->colormap[0].green=XDownScale(color.green);t1   image->colormap[0].blue=XDownScale(color.blue);    q=image->pixels;$   for (i=0; i < image->packets; i++)   {;     q->index=0;      q->length=MaxRunlength;      q++;     if (QuantumTick(i,image))&6       ProgressMonitor(LoadImageText,i,image->packets);   }+   q--;M   q->length=image->columns*image->rows-(MaxRunlength+1)*(image->packets-1)-1;0   SyncImage(image);    return(image); }S e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %SO %                                                                             % O %                                                                             % O %  R e a d X P M I m a g e                                                    %dO %                                                                             % O %                                                                             % O %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%K %  Function ReadXPMImage reads an X11 pixmap image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadXPMImage routine is:  % % %      image=ReadXPMImage(image_info)  % + %  A description of each parameter follows:e % I %    o image:  Function ReadXPMImage returns a pointer to the image after L %      creating it. A null image is returned if there is a a memory shortage& %      or if the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */  # static char *ParseColor(char *data)% {% #define NumberTargets  6  
   static char%F     *targets[NumberTargets] = { "c ", "g ", "g4 ", "m ", "b ", "s " };     register char       *p,      *q,      *r;     register int     i;  #   for (i=0; i < NumberTargets; i++)e   {r     r=data;t'     for (q=targets[i]; *r != '\0'; r++)f     {a       if (*r != *q)          continue;R       if (!isspace(*(r-1)))          continue; 
       p=r;       for ( ; ; )        {e         if (*q == '\0')r           return(r);         if (*p++ != *q++)i           break;       }e       q=targets[i];o     }t   }r   return((char *) NULL); }b  7 static Image *ReadXPMImage(const ImageInfo *image_info)I {e   char     key[MaxTextExtent],t     target[MaxTextExtent],     **textlist,_     *xpm_buffer;     ImageO     *image;f     intl
     count,     length,i     x,     y;     register charx     *p,n     *q;O     register int     i,     j;     register RunlengthPacket     *r;      unsigned int
     width;     XColor
     color;     /*     Allocate image structure.i   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);n   /*     Open image file.   */"   OpenImage(image_info,image,"r");#   if (image->file == (FILE *) NULL)i/     PrematureExit("Unable to open file",image);a   /*     Read XPM file.   */   length=MaxTextExtent; 2   xpm_buffer=(char *) malloc(length*sizeof(char));   p=xpm_buffer;g"   if (xpm_buffer != (char *) NULL)A     while (fgets(p,MaxTextExtent-1,image->file) != (char *) NULL)/     {n       if (*p == '#')         continue; )       if ((*p == '}') && (*(p+1) == ';'))r         break;       p+=Extent(p);g0       if ((p-xpm_buffer+MaxTextExtent) < length)         continue;D       *p='\0';       length<<=1;)K       xpm_buffer=(char *) realloc((char *) xpm_buffer,length*sizeof(char));m&       if (xpm_buffer == (char *) NULL)         break;&       p=xpm_buffer+Extent(xpm_buffer);     }i"   if (xpm_buffer == (char *) NULL)5     PrematureExit("Unable to allocate memory",image);c   /*     Remove comments.   */
   *p='\0';%   for (p=xpm_buffer; *p != '\0'; p++))   { '     if ((*p != '/') || (*(p+1) != '*'))w       continue;t      for (q=p+2; *q != '\0'; q++))       if ((*q == '*') && (*(q+1) == '/'))g         break;     (void) strcpy(p,q+2);>   };   /*     Remove unquoted characters.e   */   i=0;%   for (p=xpm_buffer; *p != '\0'; p++)(   {e     if (*p != '"')       continue;)      for (q=p+1; *q != '\0'; q++)       if (*q == '"')         break;+     (void) strncpy(xpm_buffer+i,p+1,q-p-1);;
     i+=q-p-1;      xpm_buffer[i++]='\n';      p+=q-p;    }c   xpm_buffer[i]='\0';i$   textlist=StringToList(xpm_buffer);   free(xpm_buffer);e!   if (textlist == (char **) NULL)r5     PrematureExit("Unable to allocate memory",image);e   /*     Read hints.    */F   count=sscanf(textlist[0],"%u %u %u %u",&image->columns,&image->rows,     &image->colors,&width); $   if ((count != 4) || (width > 2) ||8       ((image->columns*image->rows*image->colors) == 0))     { 2       for (i=0; textlist[i] != (char *) NULL; i++)#         free((char *) textlist[i]);n       free((char *) textlist);2       PrematureExit("Not a XPM image file",image);     }e   /*     Initialize image structure.m   */   image->class=PseudoClass;lL   image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));,   image->packets=image->columns*image->rows;#   image->pixels=(RunlengthPacket *)g3     malloc(image->packets*sizeof(RunlengthPacket));b2   if ((image->colormap == (ColorPacket *) NULL) ||2       (image->pixels == (RunlengthPacket *) NULL))     {g2       for (i=0; textlist[i] != (char *) NULL; i++)#         free((char *) textlist[i]);e       free((char *) textlist);7       PrematureExit("Unable to allocate memory",image);R     }t   /*     Read image colormap.   */   i=1;#   for (j=0; j < image->colors; j++)    {f     p=textlist[i++];     if (p == (char *) NULL)m       break;'     image->colormap[j].key[width]='\0'; 3     (void) strncpy(image->colormap[j].key,p,width);m     /*       Parse color.     */!     (void) strcpy(target,"gray");n     q=ParseColor(p+width);     if (q != (char *) NULL)        { ,         while (!isspace(*q) && (*q != '\0'))           q++;          (void) strcpy(target,q);         q=ParseColor(target);          if (q != (char *) NULL)p           *q='\0';       }h     Strip(target);?     image->colormap[j].flags=Latin1Compare(target,"none") == 0;c!     if (image->colormap[j].flags)s       {&!         image->class=DirectClass;          image->matte=True;%         (void) strcpy(target,"gray");i       } .     (void) XQueryColorDatabase(target,&color);1     image->colormap[j].red=XDownScale(color.red); 5     image->colormap[j].green=XDownScale(color.green);g3     image->colormap[j].blue=XDownScale(color.blue);    }    if (j < image->colors)     {12       for (i=0; textlist[i] != (char *) NULL; i++)#         free((char *) textlist[i]);e       free((char *) textlist);4       PrematureExit("Corrupt XPM image file",image);     }d   /*     Read image pixels.   */   j=0;   key[width]='\0';   r=image->pixels;!   for (y=0; y < image->rows; y++)e   {3     p=textlist[i++];     if (p == (char *) NULL)n       break;&     for (x=0; x < image->columns; x++)     {e"       (void) strncpy(key,p,width);2       if (strcmp(key,image->colormap[j].key) != 0)-         for (j=0; j < (image->colors-1); j++) 6           if (strcmp(key,image->colormap[j].key) == 0)             break;$       r->red=image->colormap[j].red;(       r->green=image->colormap[j].green;&       r->blue=image->colormap[j].blue;&       if (image->class == PseudoClass)         r->index=j; 
       else%         if (image->colormap[j].flags)p           r->index=Transparent;=         else           r->index=Opaque;       r->length=0;
       r++;       p+=width;      }e   }D   if (y < image->rows)     {p2       for (i=0; textlist[i] != (char *) NULL; i++)#         free((char *) textlist[i]);d       free((char *) textlist);4       PrematureExit("Corrupt XPM image file",image);     }+   /*     Free resources.e   */.   for (i=0; textlist[i] != (char *) NULL; i++)     free((char *) textlist[i]);    free((char *) textlist);   CompressImage(image);(   CloseImage(image);   return(image); }s   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%(O %                                                                             % O %                                                                             %rO %                                                                             %rO %  R e a d X W D I m a g e                                                    %)O %                                                                             %yO %                                                                             % O %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % L %  Function ReadXWDImage reads an X Window System window dump image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. %;- %  The format of the ReadXWDImage routine is:  % % %      image=ReadXWDImage(image_info)  %*+ %  A description of each parameter follows:i %eI %    o image:  Function ReadXWDImage returns a pointer to the image after L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.c %)A %    o image_info: Specifies a pointer to an ImageInfo structure.e %  %  */7 static Image *ReadXWDImage(const ImageInfo *image_info)  {    Imagei     *image;-     int      status,      x,     y;     register int     i;     register RunlengthPacket     *q;n     register unsigned long
     pixel;     unsigned long      lsb_first;     unsigned int     packets;     unsigned short
     index;     XColor     *colors;     XImage     *ximage;     XWDFileHeader>     header;f     /*     Allocate image structure.x   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);-   /*     Open image file.   */-   OpenImage(image_info,image,ReadBinaryType);a#   if (image->file == (FILE *) NULL)n/     PrematureExit("Unable to open file",image);    /*       Read in header information.   */?   status=ReadData((char *) &header,sz_XWDheader,1,image->file);    if (status == False);     PrematureExit("Unable to read dump file header",image);    /*@     Ensure the header byte-order is most-significant byte first.   */   lsb_first=1;   if (*(char *) &lsb_first) 5     MSBFirstOrderLong((char *) &header,sz_XWDheader);    /*:     Check to see if the dump file is in the proper format.   */.   if (header.file_version != XWD_FILE_VERSION)<     PrematureExit("XWD file format version mismatch",image);(   if (header.header_size < sz_XWDheader)8     PrematureExit("XWD header size is too small",image);,   packets=(header.header_size-sz_XWDheader);<   image->comments=(char *) malloc((packets+1)*sizeof(char));'   if (image->comments == (char *) NULL) 5     PrematureExit("Unable to allocate memory",image);eB   status=ReadData((char *) image->comments,1,packets,image->file);    image->comments[packets]='\0';   if (status == False)F     PrematureExit("Unable to  read window name from dump file",image);   /*     Initialize the X image.B   */+   ximage=(XImage *) malloc(sizeof(XImage));[    if (ximage == (XImage *) NULL)5     PrematureExit("Unable to allocate memory",image);m$   ximage->depth=header.pixmap_depth;&   ximage->format=header.pixmap_format;!   ximage->xoffset=header.xoffset;g   ximage->data=(char *) NULL; $   ximage->width=header.pixmap_width;&   ximage->height=header.pixmap_height;'   ximage->bitmap_pad=header.bitmap_pad;a/   ximage->bytes_per_line=header.bytes_per_line;u'   ximage->byte_order=header.byte_order;c)   ximage->bitmap_unit=header.bitmap_unit; 3   ximage->bitmap_bit_order=header.bitmap_bit_order; /   ximage->bits_per_pixel=header.bits_per_pixel; #   ximage->red_mask=header.red_mask;,'   ximage->green_mask=header.green_mask;U%   ximage->blue_mask=header.blue_mask;    status=XInitImage(ximage);   if (status == False).     PrematureExit("Invalid XWD header",image);   /*     Read colormap.   */   colors=(XColor *) NULL;    if (header.ncolors != 0)     {t       XWDColor         color;  M       colors=(XColor *) malloc((unsigned int) header.ncolors*sizeof(XColor)); $       if (colors == (XColor *) NULL)9         PrematureExit("Unable to allocate memory",image); (       for (i=0; i < header.ncolors; i++)       { C         status=ReadData((char *) &color,sz_XWDColor,1,image->file);          if (status == False)I           PrematureExit("Unable to read color map from dump file",image); $         colors[i].pixel=color.pixel;          colors[i].red=color.red;$         colors[i].green=color.green;"         colors[i].blue=color.blue;$         colors[i].flags=color.flags;       }        /*D         Ensure the header byte-order is most-significant byte first.       */       lsb_first=1;       if (*(char *) &lsb_first)n*         for (i=0; i < header.ncolors; i++)	         {=M           MSBFirstOrderLong((char *) &colors[i].pixel,sizeof(unsigned long)); O           MSBFirstOrderShort((char *) &colors[i].red,3*sizeof(unsigned short));e	         }o     }T   /*     Allocate the pixel buffer.   */    if (ximage->format == ZPixmap)2     packets=ximage->bytes_per_line*ximage->height;   else@     packets=ximage->bytes_per_line*ximage->height*ximage->depth;>   ximage->data=(char *) malloc(packets*sizeof(unsigned char));$   if (ximage->data == (char *) NULL)5     PrematureExit("Unable to allocate memory",image);c6   status=ReadData(ximage->data,1,packets,image->file);   if (status == False)6     PrematureExit("Unable to read dump pixmap",image);   /*!     Convert image to MIFF format.0   */   image->columns=ximage->width;o   image->rows=ximage->height; ?   if ((colors == (XColor *) NULL) || (ximage->red_mask != 0) ||f<       (ximage->green_mask != 0) || (ximage->blue_mask != 0))     image->class=DirectClass;    else     image->class=PseudoClass;(   image->colors=header.ncolors;x   image->packets=0;o5   packets=Max((image->columns*image->rows+4) >> 3,1); L   image->pixels=(RunlengthPacket *) malloc(packets*sizeof(RunlengthPacket));0   if (image->pixels == (RunlengthPacket *) NULL)5     PrematureExit("Unable to allocate memory",image);)   q=image->pixels;   q->length=MaxRunlength;g   switch (image->class)u   {      case DirectClass:e     default:     {        register unsigned long         color;         unsigned int
         blue,g         green,         red;         unsigned long          blue_mask,         blue_shift,          green_mask,          green_shift,         red_mask,          red_shift;         /*:         Determine shift and mask for red, green, and blue.       */        red_mask=ximage->red_mask;       red_shift=0;$       while ((red_mask & 0x01) == 0)       {          red_mask>>=1;          red_shift++;       } $       green_mask=ximage->green_mask;       green_shift=0;&       while ((green_mask & 0x01) == 0)       {          green_mask>>=1;          green_shift++;       }%"       blue_mask=ximage->blue_mask;       blue_shift=0;%%       while ((blue_mask & 0x01) == 0)r       {I         blue_mask>>=1;         blue_shift++;t       }m       /*/         Convert X image to DirectClass packets.        */       if (image->colors != 0)r'         for (y=0; y < image->rows; y++) 	         {e,           for (x=0; x < image->columns; x++)           {r(             pixel=XGetPixel(ximage,x,y);E             index=(unsigned short) ((pixel >> red_shift) & red_mask); .             red=XDownScale(colors[index].red);I             index=(unsigned short) ((pixel >> green_shift) & green_mask);S2             green=XDownScale(colors[index].green);G             index=(unsigned short) ((pixel >> blue_shift) & blue_mask);e0             blue=XDownScale(colors[index].blue);N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))0               q->length++;             else               {l(                 if (image->packets != 0)                   q++;!                 image->packets++; .                 if (image->packets == packets)                   {;                      packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket)); B                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);t5                     q=image->pixels+image->packets-1;u                   }u                 q->red=red;                  q->green=green;                  q->blue=blue;H                 q->index=0;                  q->length=0;               }            }n7           ProgressMonitor(LoadImageText,y,image->rows);p	         }i
       else'         for (y=0; y < image->rows; y++)i	         {u,           for (x=0; x < image->columns; x++)           { (             pixel=XGetPixel(ximage,x,y);2             color=(pixel >> red_shift) & red_mask;4             red=XDownScale((color*65535L)/red_mask);6             color=(pixel >> green_shift) & green_mask;8             green=XDownScale((color*65535L)/green_mask);4             color=(pixel >> blue_shift) & blue_mask;6             blue=XDownScale((color*65535L)/blue_mask);N             if ((red == q->red) && (green == q->green) && (blue == q->blue) &&1                 ((int) q->length < MaxRunlength))l               q->length++;             else               { (                 if (image->packets != 0)                   q++;!                 image->packets++;".                 if (image->packets == packets)                   {                       packets<<=1;F                     image->pixels=(RunlengthPacket *) realloc((char *)E                       image->pixels,packets*sizeof(RunlengthPacket));hB                     if (image->pixels == (RunlengthPacket *) NULL)G                       PrematureExit("Unable to allocate memory",image);)5                     q=image->pixels+image->packets-1;s                   }-                 q->red=red;a                 q->green=green;p                 q->blue=blue;                  q->index=0;i                 q->length=0;               }f           } 7           ProgressMonitor(LoadImageText,y,image->rows);o	         }e       break;     }f     case PseudoClass:=     {        /*/         Convert X image to PseudoClass packets.        */P       image->colormap=(ColorPacket *) malloc(image->colors*sizeof(ColorPacket));2       if (image->colormap == (ColorPacket *) NULL)9         PrematureExit("Unable to allocate memory",image);U'       for (i=0; i < image->colors; i++)a       {e9         image->colormap[i].red=XDownScale(colors[i].red);t=         image->colormap[i].green=XDownScale(colors[i].green); ;         image->colormap[i].blue=XDownScale(colors[i].blue);        })%       for (y=0; y < image->rows; y++)e       {,*         for (x=0; x < image->columns; x++)	         { &           pixel=XGetPixel(ximage,x,y);'           index=(unsigned short) pixel;,F           if ((index == q->index) && ((int) q->length < MaxRunlength))             q->length++;           else
             { &               if (image->packets != 0)                 q++;               image->packets++; ,               if (image->packets == packets)                 {                    packets<<=1;D                   image->pixels=(RunlengthPacket *) realloc((char *)C                     image->pixels,packets*sizeof(RunlengthPacket));s@                   if (image->pixels == (RunlengthPacket *) NULL)E                     PrematureExit("Unable to allocate memory",image);n3                   q=image->pixels+image->packets-1;                  }e               q->index=index;e               q->length=0;
             }=	         } 5         ProgressMonitor(LoadImageText,y,image->rows);r       }        SyncImage(image);h       CompressColormap(image);       break;     }(   }l#   image->pixels=(RunlengthPacket *) K     realloc((char *) image->pixels,image->packets*sizeof(RunlengthPacket));f   /*     Free image and colormap.   */   if (header.ncolors != 0)     free((char *) colors);   free(ximage->data);    free(ximage);B   CloseImage(image);   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %zO %                                                                             % O %                                                                             % O %  R e a d Y U V I m a g e                                                    %4O %                                                                             % O %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %)O %  Function ReadYUVImage reads an image with digital YUV (CCIR 601 4:1:1) bytesLG %  and returns it.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. %c- %  The format of the ReadYUVImage routine is:e %h% %      image=ReadYUVImage(image_info)  % + %  A description of each parameter follows:o %;I %    o image:  Function ReadYUVImage returns a pointer to the image after.L %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.; % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 static Image *ReadYUVImage(const ImageInfo *image_info)  {    char     filename[MaxTextExtent];     Imager     *image,s     *zoomed_image;     int      x,     y;     register int     i;     register RunlengthPacket     *q;)     register unsigned char     *p;      unsigned charI     *uv_pixels,      *y_pixels;     unsigned int     height, 
     width;     /*     Allocate image structure.w   */)   zoomed_image=AllocateImage(image_info);t%   if (zoomed_image == (Image *) NULL)      return((Image *) NULL);    /*-     Determine width and height, e.g. 640x512.*   */   width=512;
   height=512;    x=0;(   if (image_info->size != (char *) NULL)A     (void) XParseGeometry(image_info->size,&x,&y,&width,&height);r2   if (image_info->interlace != PartitionInterlace)     {        /*         Open image file.       */8       OpenImage(image_info,zoomed_image,ReadBinaryType);.       if (zoomed_image->file == (FILE *) NULL)9         PrematureExit("Unable to open file",zoomed_image)a       for (i=0; i < x; i++)l)         (void) fgetc(zoomed_image->file);t     }(   /*     Read Y channel.,   */2   if (image_info->interlace == PartitionInterlace)     {o4       AppendImageFormat("Y",zoomed_image->filename);8       OpenImage(image_info,zoomed_image,ReadBinaryType);.       if (zoomed_image->file == (FILE *) NULL):         PrematureExit("Unable to open file",zoomed_image);     } #   zoomed_image->columns=width >> 1;m!   zoomed_image->rows=height >> 1;iA   zoomed_image->packets=zoomed_image->columns*zoomed_image->rows;    uv_pixels=(unsigned char *) 8     malloc(zoomed_image->packets*sizeof(unsigned char));   y_pixels=(unsigned char *):     malloc(4*zoomed_image->packets*sizeof(unsigned char));*   zoomed_image->pixels=(RunlengthPacket *):     malloc(zoomed_image->packets*sizeof(RunlengthPacket));.   if ((uv_pixels == (unsigned char *) NULL) ||-       (y_pixels == (unsigned char *) NULL) || 9       (zoomed_image->pixels == (RunlengthPacket *) NULL))-<     PrematureExit("Unable to allocate memory",zoomed_image);P   (void) ReadData((char *) y_pixels,4,zoomed_image->packets,zoomed_image->file);   /*     Read U channel.a   */2   if (image_info->interlace == PartitionInterlace)     {l       CloseImage(zoomed_image);o4       AppendImageFormat("U",zoomed_image->filename);8       OpenImage(image_info,zoomed_image,ReadBinaryType);.       if (zoomed_image->file == (FILE *) NULL):         PrematureExit("Unable to open file",zoomed_image);     }r)   ProgressMonitor(LoadImageText,100,400);o=   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,o     zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels;(+   for (i=0; i < zoomed_image->packets; i++)    {o     q->green=UpScale(*p);      q->index=0;e     q->length=0;     p++;     q++;   }    /*     Read V channel.e   */2   if (image_info->interlace == PartitionInterlace)     {        CloseImage(zoomed_image);o4       AppendImageFormat("V",zoomed_image->filename);8       OpenImage(image_info,zoomed_image,ReadBinaryType);.       if (zoomed_image->file == (FILE *) NULL):         PrematureExit("Unable to open file",zoomed_image);     }e)   ProgressMonitor(LoadImageText,200,400);.=   (void) ReadData((char *) uv_pixels,1,zoomed_image->packets,e     zoomed_image->file);   p=uv_pixels;   q=zoomed_image->pixels;o+   for (i=0; i < zoomed_image->packets; i++))   {      q->blue=UpScale(*p);     p++;     q++;   }    CloseImage(zoomed_image);    free((char *) uv_pixels);)   /*     Scale image.   */)   ProgressMonitor(LoadImageText,300,400);-   zoomed_image->orphan=True;#   image=MagnifyImage(zoomed_image);    zoomed_image->orphan=False;;   DestroyImage(zoomed_image);    if (image == (Image *) NULL)5     PrematureExit("Unable to allocate memory",image); 
   p=y_pixels;g   q=image->pixels;2   for (i=0; i < (image->columns*image->rows); i++)   {%     q->red=UpScale(*p);%     p++;     q++;   }%   free((char *) y_pixels);+   TransformRGBImage(image,YCbCrColorspace); *   (void) strcpy(image->filename,filename);   CompressImage(image); 2   if (image_info->interlace == PartitionInterlace)8     (void) strcpy(image->filename,image_info->filename);)   ProgressMonitor(LoadImageText,400,400);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   R e a d I m a g e                                                         %eO %                                                                             % O %                                                                             %oO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r % B %  Function ReadImage reads an image and returns it.  It allocatesL %  the memory necessary for the new Image structure and returns a pointer toJ %  the new image.  By default, the image format is determined by its magicM %  number. To specify a particular image format, precede the filename with an M %  explicit image format name and a colon (i.e.  ps:image) or as the filenameT %  suffix  (i.e. image.ps).A %G* %  The format of the ReadImage routine is: % " %      image=ReadImage(image_info) %t+ %  A description of each parameter follows:h % E %    o image: Function ReadImage returns a pointer to the image aftergL %      reading.  A null image is returned if there is a a memory shortage or# %      if the image cannot be read.e %tA %    o image_info: Specifies a pointer to an ImageInfo structure.n %n %c */. Export Image *ReadImage(ImageInfo *image_info) {t   char      magic_number[MaxTextExtent];     Imageo     decode_image,e     *image;m     ImageInfog     decode_info;     register char      *p;      register int     i;  +   assert(image_info != (ImageInfo *) NULL);g0   assert(image_info->filename != (char *) NULL);!   SetImageInfo(image_info,False);t   decode_info=(*image_info);?   decode_image.temporary=strcmp(decode_info.magick,"TMP") == 0;m4   if ((strncmp(decode_info.magick,"FILE",4) == 0) ||3       (strncmp(decode_info.magick,"FTP",3) == 0) ||_6       (strncmp(decode_info.magick,"GOPHER",6) == 0) ||2       (strncmp(decode_info.magick,"HTTP",4) == 0))     {a
       char         command[MaxTextExtent],S          filename[MaxTextExtent];         /*H         Retrieve image as specified with a WWW uniform resource locator.       */"       decode_image.temporary=True;"       TemporaryFilename(filename);P       (void) sprintf(command,WWWCommand,decode_info.magick,decode_info.filename,         filename);$       (void) SystemCommand(command);'       SetImageInfo(&decode_info,False); 3       (void) strcpy(decode_info.filename,filename);      } J   if (!decode_info.affirm || (strncmp(decode_info.magick,"SGI",3) == 0) ||1       (strncmp(decode_info.magick,"PCD",3) == 0))l     {C       /*/         Determine type from image magic number.o       *//       for (i=0 ; i < sizeof(magic_number); i++)e         magic_number[i]='\0';t@       (void) strcpy(decode_image.filename,decode_info.filename);9       OpenImage(image_info,&decode_image,ReadBinaryType);m-       if (decode_image.file != (FILE *) NULL)1>         if ((decode_image.file == stdin) || decode_image.pipe)           {              FILE               *file;               int-               c;               /*<               Copy standard input or pipe to temporary file.             */(             decode_image.temporary=True;5             TemporaryFilename(decode_image.filename);/7             decode_info.filename=decode_image.filename;t>             file=fopen(decode_image.filename,WriteBinaryType);&             if (file == (FILE *) NULL)               {pE                 Warning("Unable to write file",decode_info.filename);)'                 return((Image *) NULL);r               }|'             c=fgetc(decode_image.file);c             while (c != EOF)
             {l"               (void) putc(c,file);)               c=fgetc(decode_image.file);,
             }m              (void) fclose(file);&             CloseImage(&decode_image);?             OpenImage(image_info,&decode_image,ReadBinaryType);t           }n-       if (decode_image.file != (FILE *) NULL) 	         {            /*             Read magic number.           */C           (void) ReadData(magic_number,(unsigned int) sizeof(char),rC             (unsigned int) sizeof(magic_number),decode_image.file);r:           if (((unsigned char) magic_number[0] == 0xff) &&8               ((unsigned char) magic_number[1] == 0xff))
             {m               register int                 i;                 /*6                 For PCD image type, skip to byte 2048.               */D               for (i=0; i < (int) (0x800-sizeof(magic_number)); i++)0                 (void) fgetc(decode_image.file);G               (void) ReadData(magic_number,(unsigned int) sizeof(char),lG                 (unsigned int) sizeof(magic_number),decode_image.file);r
             } $           CloseImage(&decode_image);	         };       /*#         Determine the image format.        */)       magic_number[MaxTextExtent-1]='\0';i,       if (strncmp(magic_number,"BM",2) == 0)0         (void) strcpy(decode_info.magick,"BMP");-       if (strncmp(magic_number,"IT0",3) == 0)u1         (void) strcpy(decode_info.magick,"FITS");E9       if (strncmp(magic_number,"\261\150\336\72",4) == 0)t0         (void) strcpy(decode_info.magick,"DCX");0       if (strncmp(magic_number,"SIMPLE",6) == 0)1         (void) strcpy(decode_info.magick,"FITS");r.       if (strncmp(magic_number,"GIF8",4) == 0)0         (void) strcpy(decode_info.magick,"GIF");:       if (strncmp(magic_number,"\016\003\023\001",4) == 0)0         (void) strcpy(decode_info.magick,"HDF");3       if ((strncmp(magic_number,"<HTML",5) == 0) || 1           (strncmp(magic_number,"<html",5) == 0))u1         (void) strcpy(decode_info.magick,"HTML");n2       if (strncmp(magic_number,"\001\332",2) == 0)0         (void) strcpy(decode_info.magick,"SGI");6       if (strncmp(magic_number,"\377\330\377",3) == 0)1         (void) strcpy(decode_info.magick,"JPEG");f9       if (strncmp(magic_number,"id=ImageMagick",14) == 0)r1         (void) strcpy(decode_info.magick,"MIFF"); A       if ((magic_number[0] == 0x00) && (magic_number[1] == 0x00)) J         if ((magic_number[2] == 0x01) && (magic_number[3] == (char) 0xb3))3           (void) strcpy(decode_info.magick,"MPEG");h.       if (strncmp(magic_number,"PCD_",4) == 0)0         (void) strcpy(decode_info.magick,"PCD");/       if (strncmp(magic_number,"\12\2",2) == 0)r0         (void) strcpy(decode_info.magick,"PCX");/       if (strncmp(magic_number,"\12\5",2) == 0)p0         (void) strcpy(decode_info.magick,"PCX");/       if (strncmp(magic_number,"%!PDF",5) == 0)p0         (void) strcpy(decode_info.magick,"PDF");=       if ((*magic_number == 'P') && isdigit(magic_number[1]))r0         (void) strcpy(decode_info.magick,"PNM");;       if (strncmp(magic_number,"\211PNG\r\n\032\n",8) == 0)_0         (void) strcpy(decode_info.magick,"PNG");,       if (strncmp(magic_number,"%!",2) == 0)/         (void) strcpy(decode_info.magick,"PS");c5       if (strncmp(magic_number,"#?RADIANCE",10) == 0)n0         (void) strcpy(decode_info.magick,"RAD");2       if (strncmp(magic_number,"\122\314",2) == 0)0         (void) strcpy(decode_info.magick,"RLE");:       if (strncmp(magic_number,"\131\246\152\225",4) == 0)0         (void) strcpy(decode_info.magick,"SUN");>       if ((strncmp(magic_number,"\115\115\000\052",4) == 0) ||<           (strncmp(magic_number,"\111\111\052\000",4) == 0))1         (void) strcpy(decode_info.magick,"TIFF"); 5       if ((strncmp(magic_number,"LBLSIZE",7) == 0) || 2           (strncmp(magic_number,"NJPL1I",6) == 0))2         (void) strcpy(decode_info.magick,"VICAR");0       if (strncmp(magic_number,"\253\1",2) == 0)1         (void) strcpy(decode_info.magick,"VIFF");m!       p=strchr(magic_number,'#');        if (p != (char *) NULL)e(         if (strncmp(p,"#define",7) == 0)2           (void) strcpy(decode_info.magick,"XBM");3       if (strncmp(magic_number,"/* XPM */",9) == 0)g0         (void) strcpy(decode_info.magick,"XPM");A       if ((magic_number[1] == 0x00) && (magic_number[2] == 0x00)) C         if ((magic_number[5] == 0x00) && (magic_number[6] == 0x00)) E           if ((magic_number[4] == 0x07) || (magic_number[7] == 0x07))e4             (void) strcpy(decode_info.magick,"XWD");     }    /*6     Call appropriate image reader based on image type.   */   switch (*decode_info.magick)   { 
     case 'A':      {-0       if (strcmp(decode_info.magick,"AVS") == 0)	         { +           image=ReadAVSImage(&decode_info);d           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'B':u     {l0       if (strcmp(decode_info.magick,"BIE") == 0)	         { ,           image=ReadJBIGImage(&decode_info);           break;	         } 0       if (strcmp(decode_info.magick,"BMP") == 0)	         { +           image=ReadBMPImage(&decode_info);-           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }%
     case 'C':      {d0       if (strcmp(decode_info.magick,"CGM") == 0)	         {e+           image=ReadCGMImage(&decode_info);            break;	         }u1       if (strcmp(decode_info.magick,"CMYK") == 0);	         { ,           image=ReadCMYKImage(&decode_info);           break;	         }m(       image=ReadMIFFImage(&decode_info);       break;     }o
     case 'D':m     {w3       if (strncmp(decode_info.magick,"DCX",3) == 0) 	         {c+           image=ReadPCXImage(&decode_info);m           break;	         }s0       if (strcmp(decode_info.magick,"DIB") == 0)	         {*+           image=ReadBMPImage(&decode_info);u           break;	         }n(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'E':*     { 3       if (strncmp(decode_info.magick,"EPS",3) == 0)m	         {l*           image=ReadPSImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }n
     case 'F':)     { 0       if (strcmp(decode_info.magick,"FAX") == 0)	         {n+           image=ReadFAXImage(&decode_info);g           break;	         }-1       if (strcmp(decode_info.magick,"FITS") == 0)u	         { ,           image=ReadFITSImage(&decode_info);           break;	         }9(       image=ReadMIFFImage(&decode_info);       break;     }m
     case 'G':      {I3       if (strncmp(decode_info.magick,"GIF",3) == 0)%	         {%+           image=ReadGIFImage(&decode_info);%           break;	         } 6       if (strcmp(decode_info.magick,"GRADATION") == 0)	         { 1           image=ReadGRADATIONImage(&decode_info);            break;	         } 4       if (strcmp(decode_info.magick,"GRANITE") == 0)	         { ,           image=ReadLOGOImage(&decode_info);           break;	         } 1       if (strcmp(decode_info.magick,"GRAY") == 0) 	         { ,           image=ReadGRAYImage(&decode_info);           break;	         } 2       if (strncmp(decode_info.magick,"G3",2) == 0)	         { +           image=ReadFAXImage(&decode_info);            break;	         }%(       image=ReadMIFFImage(&decode_info);       break;     }%
     case 'H':t     {d.       if (strcmp(decode_info.magick,"H") == 0)	         { ,           image=ReadLOGOImage(&decode_info);           break;	         }s0       if (strcmp(decode_info.magick,"HDF") == 0)	         {a+           image=ReadHDFImage(&decode_info);T           break;	         }A9       if (strncmp(decode_info.magick,"HISTOGRAM",4) == 0) 	         {e1           image=ReadHISTOGRAMImage(&decode_info);            break;	         }s1       if (strcmp(decode_info.magick,"HTML") == 0) 	         {g,           image=ReadHTMLImage(&decode_info);           break;	         }n(       image=ReadMIFFImage(&decode_info);       break;     }a
     case 'J':n     {f1       if (strcmp(decode_info.magick,"JBIG") == 0) 	         {m,           image=ReadJBIGImage(&decode_info);           break;	         }o1       if (strcmp(decode_info.magick,"JPEG") == 0) 	         {c,           image=ReadJPEGImage(&decode_info);           break;	         }i(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'L':o     { 1       if (strcmp(decode_info.magick,"LOGO") == 0)n	         {_,           image=ReadLOGOImage(&decode_info);           break;	         }i(       image=ReadMIFFImage(&decode_info);       break;     }e
     case 'M':a     {l0       if (strcmp(decode_info.magick,"MAP") == 0)	         { +           image=ReadMAPImage(&decode_info);t           break;	         }d2       if (strcmp(decode_info.magick,"MATTE") == 0)	         {n-           image=ReadMATTEImage(&decode_info);            break;	         } 1       if (strcmp(decode_info.magick,"MONO") == 0) 	         {i,           image=ReadMONOImage(&decode_info);           break;	         }(5       if ((strcmp(decode_info.magick,"MPEG") == 0) || 2           (strcmp(decode_info.magick,"MPG") == 0))	         {T,           image=ReadMPEGImage(&decode_info);           break;	         }o0       if (strcmp(decode_info.magick,"MTV") == 0)	         { +           image=ReadMTVImage(&decode_info);_           break;	         }g(       image=ReadMIFFImage(&decode_info);       break;     }t
     case 'N':-     {s5       if (strcmp(decode_info.magick,"NETSCAPE") == 0)i	         {=,           image=ReadLOGOImage(&decode_info);           break;	         }T1       if (strcmp(decode_info.magick,"NULL") == 0)e	         {e,           image=ReadNULLImage(&decode_info);           break;	         }a(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'P':o     {S4       if ((strcmp(decode_info.magick,"PBM") == 0) ||4           (strcmp(decode_info.magick,"PGM") == 0) ||4           (strcmp(decode_info.magick,"PNM") == 0) ||2           (strcmp(decode_info.magick,"PPM") == 0))	         {=+           image=ReadPNMImage(&decode_info);e           break;	         }*0       if (strcmp(decode_info.magick,"PCD") == 0)	         {e+           image=ReadPCDImage(&decode_info);l           break;	         }m0       if (strcmp(decode_info.magick,"PCL") == 0)	         {n+           image=ReadPCLImage(&decode_info);a           break;	         }>0       if (strcmp(decode_info.magick,"PCX") == 0)	         {(+           image=ReadPCXImage(&decode_info);(           break;	         }m0       if (strcmp(decode_info.magick,"PDF") == 0)	         { +           image=ReadPDFImage(&decode_info);            break;	         } 1       if (strcmp(decode_info.magick,"PICT") == 0)f	         { ,           image=ReadPICTImage(&decode_info);           break;	         }l0       if (strcmp(decode_info.magick,"PCD") == 0)	         {-+           image=ReadPCDImage(&decode_info);;           break;	         }_3       if (strcmp(decode_info.magick,"PLASMA") == 0)r	         { .           image=ReadPLASMAImage(&decode_info);           break;	         } /       if (strcmp(decode_info.magick,"PM") == 0) 	         {h+           image=ReadXPMImage(&decode_info);            break;	         }=0       if (strcmp(decode_info.magick,"PNG") == 0)	         { +           image=ReadPNGImage(&decode_info);            break;	         }a2       if (strncmp(decode_info.magick,"PS",2) == 0)	         { *           image=ReadPSImage(&decode_info);           break;	         }E(       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'R':i     { 0       if (strcmp(decode_info.magick,"RAD") == 0)	         { 0           image=ReadRADIANCEImage(&decode_info);           break;	         } 0       if (strcmp(decode_info.magick,"RAS") == 0)	         { +           image=ReadSUNImage(&decode_info);            break;	         } 3       if (strncmp(decode_info.magick,"RGB",3) == 0) 	         { +           image=ReadRGBImage(&decode_info);            break;	         } 0       if (strcmp(decode_info.magick,"RLA") == 0)	         { +           image=ReadRLAImage(&decode_info);            break;	         } 0       if (strcmp(decode_info.magick,"RLE") == 0)	         {1+           image=ReadRLEImage(&decode_info);            break;	         }x(       image=ReadMIFFImage(&decode_info);       break;     }u
     case 'S':*     {(0       if (strcmp(decode_info.magick,"SGI") == 0)	         { +           image=ReadSGIImage(&decode_info);            break;	         } 2       if (strcmp(decode_info.magick,"SHTML") == 0)	         { ,           image=ReadHTMLImage(&decode_info);           break;	         }p0       if (strcmp(decode_info.magick,"SUN") == 0)	         {m+           image=ReadSUNImage(&decode_info);            break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }n
     case 'T':      {g1       if (strcmp(decode_info.magick,"TEXT") == 0) 	         { ,           image=ReadTEXTImage(&decode_info);           break;	         } 0       if (strcmp(decode_info.magick,"TGA") == 0)	         {u+           image=ReadTGAImage(&decode_info);l           break;	         }p3       if (strncmp(decode_info.magick,"TIF",3) == 0)n	         { ,           image=ReadTIFFImage(&decode_info);           break;	         } 1       if (strcmp(decode_info.magick,"TILE") == 0)l	         { ,           image=ReadTILEImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }c
     case 'U':      {01       if (strcmp(decode_info.magick,"UYVY") == 0)t	         {m,           image=ReadUYVYImage(&decode_info);           break;	         }E(       image=ReadMIFFImage(&decode_info);       break;     }e
     case 'V':f     {n2       if (strcmp(decode_info.magick,"VICAR") == 0)	         { -           image=ReadVICARImage(&decode_info);            break;	         } 0       if (strcmp(decode_info.magick,"VID") == 0)	         { !           if (decode_info.affirm))-             image=ReadVIDImage(&decode_info);            else.             image=ReadMIFFImage(&decode_info);           break;	         } 1       if (strcmp(decode_info.magick,"VIFF") == 0)l	         { ,           image=ReadVIFFImage(&decode_info);           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     } 
     case 'X':      { .       if (strcmp(decode_info.magick,"X") == 0)	         { A           image=ReadXImage(&decode_info,False,False,False,False);_           break;	         }(/       if (strcmp(decode_info.magick,"XC") == 0) 	         { *           image=ReadXCImage(&decode_info);           break;	         })0       if (strcmp(decode_info.magick,"XBM") == 0)	         { +           image=ReadXBMImage(&decode_info);c           break;	         } 0       if (strcmp(decode_info.magick,"XPM") == 0)	         { +           image=ReadXPMImage(&decode_info);            break;	         }r/       if (strcmp(decode_info.magick,"XV") == 0) 	         {1,           image=ReadVIFFImage(&decode_info);           break;	         }e0       if (strcmp(decode_info.magick,"XWD") == 0)	         {f+           image=ReadXWDImage(&decode_info);            break;	         }((       image=ReadMIFFImage(&decode_info);       break;     }t
     case 'Y':      {(0       if (strcmp(decode_info.magick,"YUV") == 0)	         {;+           image=ReadYUVImage(&decode_info);)           break;	         } (       image=ReadMIFFImage(&decode_info);       break;     }      default:     { /       (void) strcpy(decode_info.magick,"MIFF");k(       image=ReadMIFFImage(&decode_info);     }f   }    if (decode_image.temporary)/(     (void) remove(decode_info.filename);   if (image != (Image *) NULL)O     if ((image->next != (Image *) NULL) && (image_info->tile != (char *) NULL))        {f         intp           count,           offset,e           retain;e  
         /*<           User specified subimages (e.g. image.miff[1,3,4]).
         */         for ( ; ; ) 	         {E           retain=False; 6           image_info->subimage=atoi(image_info->tile);@           for (p=image_info->tile; *p != '\0'; p+=Max(offset,1))           {              offset=0; E             count=sscanf(p,"%u%n-%u%n",&image_info->subimage,&offset, -               &image_info->subrange,&offset);n             if (count == 1)i8               image_info->subrange=image_info->subimage;>             retain|=((image->scene >= image_info->subimage) &&6               (image->scene <= image_info->subrange));           } ,           if (image->next != (Image *) NULL)
             {o                image=image->next;               if (!retain).                 DestroyImage(image->previous);               continue;g
             }m0           if (image->previous != (Image *) NULL)
             {t$               image=image->previous;               if (!retain)*                 DestroyImage(image->next);               break;
             }m           if (!retain)
             {i"               DestroyImage(image);#               image=(Image *) NULL;e
             }            break;	         }i$         if (image == (Image *) NULL)           {l?             Warning("Subimage specification returns no images",L$               image_info->filename);#             return((Image *) NULL);m           } 1         while (image->previous != (Image *) NULL)f            image=image->previous;       }g   if (image != (Image *) NULL)     {g       if (image->status)K         Warning("An error has occurred reading from file",image->filename); !       if (decode_image.temporary) <         (void) strcpy(image->filename,image_info->filename);A       (void) strcpy(image->magick_filename,image_info->filename);%+       if (image->comments == (char *) NULL)%;         CommentImage(image,"  Imported from %m image: %f"); %       if (image->magick_columns == 0) -         image->magick_columns=image->columns; "       if (image->magick_rows == 0)'         image->magick_rows=image->rows; 2       image_info->interlace=decode_info.interlace;&       if (image->class == PseudoClass)%         if (IsMonochromeImage(image))            { /             image->background_color.red=MaxRGB; 1             image->background_color.green=MaxRGB; 0             image->background_color.blue=MaxRGB;           }      }    return(image); } 