/* --------------------------------- stores.c ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Show stores (HDD_STORES).
*/

#include "fly.h"
#include "plane.h"


/* Status is:
 *
 * blank	retracted.
 * L		lowered
 * G		has ground contact
 * green	fully extended, safe
 * red		in transit, unsafe
*/
static int FAR
show_gear (int x, int y, short pos, Ushort ground, int s)
{
	int	c, color;

	c = (0 == pos) ? ' ' : (ground ? 'G' : 'L');
	color = (100 == pos) ? st.green : st.red;
	return (stroke_char (x, y, c, s, color));
}

extern void FAR
show_stores (VIEW *view, OBJECT *p, int maxx, int maxy, int orgx, int orgy,
	int ss)
{
	int	hud, hud1, knots, blink;
	Ushort	equip;
	int	xl, xr, x, y, x0, y0, tx, ty, dd;
	int	i, t, mm, hh;
	long	range;

	hud = EX->hud;
	hud1 = EX->hud1;
	knots = hud1 & HUD_KNOTS;
	equip = EX->equip;
	blink = ((int)st.present)&0x0080;

	dd = num_size (9L, ss);
	xl = orgx - maxx + 2;
	xr = orgx;
	y = orgy - maxy + ss;
	y0 = ss*3/2;

/* Show fuel status.
*/
	y += ss;
	x0 = xl;
	t = (int) (EX->fuel / EP->fuel_capacity);
	x0 += stroke_str (x0, y, "FUEL ", ss, (t < 10) ? st.red : st.green);
	stroke_num (x0, y, EX->fuel/100, ss, st.hfg);

	y += y0;
	x0 = xl;
	x0 += stroke_str  (x0, y, "TIME ", ss, st.hfg);
	t = EX->fuelRate;
	if (t) {
		mm = (int)(EX->fuel / (60L*t));
		range = p->speed/VONE * 60L * mm;
		hh = mm / 60;
		mm -= 60*hh;
		if (hh > 99)
			hh = mm = 99;
		x0 += stroke_num  (x0, y, hh, ss, st.hfg);
		x0 += stroke_char (x0, y, ':', ss, st.hfg);
		stroke_frac (x0, y, mm, 2, 0, ss, st.hfg);
	}

	y += y0;
	x0 = xl;
	x0 += stroke_str (x0, y, "RNGE ", ss, st.hfg);
	if (t) {
		range /= knots ? 1852L : 1000L;
		stroke_num (x0, y, range, ss, st.hfg);
	}

/* Show gear status.
*/
	y += y0;
	x0 = xl;
	x0 += stroke_str (x0, y, "GEAR ", ss, st.hfg);
	x0 += show_gear  (x0, y, EX->gear[0], equip & EQ_GEAR1, ss);
	x0 += show_gear  (x0, y, EX->gear[1], equip & EQ_GEAR2, ss);
	x0 += show_gear  (x0, y, EX->gear[2], equip & EQ_GEAR3, ss);
	x0 += show_gear  (x0, y, EX->gear[3], equip & EQ_GEAR4, ss);
	x0 += show_gear  (x0, y, EX->gear[4], equip & EQ_GEAR5, ss);

/* Show other digital stuff.
*/
	y = orgy + maxy - ss;

	x0 = xl;
	x0 += stroke_str (x0, y, "SPL ", ss, st.hfg);
	if (EX->spoilers)
		stroke_num (x0, y, EX->spoilers, ss, st.hfg);
	y -= y0;

	x0 = xl;
	x0 += stroke_str (x0, y, "FLP ", ss, st.hfg);
	if (EX->flaps)
		stroke_num (x0, y, EX->flaps, ss, st.hfg);
	y -= y0;

	x0 = xl;
	x0 += stroke_str (x0, y, "RDR ", ss, st.hfg);
	if (EX->rudder) {
		x0 += stroke_char (x0, y, (EX->rudder > 0) ? 'L' : 'R', ss,
			st.hfg);
		t = abs(EX->rudder);
		 stroke_num (x0, y, t , ss, st.hfg);
	}
	y -= y0;

	if (EX->brake) {
		x0 = xl;
		x0 += stroke_str (x0, y, "BRK ", ss, st.hfg);
		stroke_num (x0, y, EX->brake, ss, st.hfg);
	}
	y -= y0;

	x0 = xl;
	if (EX->flags & PF_CHASE)
		x0 += stroke_str (x0, y, EX->target ? "CHASE " :"AUTO ",
			ss, st.hfg);
	else
		x0 += 5*dd;
	if (EX->flags & PF_KILL)
		stroke_str (x0, y, "KILL", ss, st.hfg);
	y -= y0;

/* Show weapons.
*/
	y = orgy - maxy + ss;
	for (i = 1; i <= WE_LAST; ++i) {
		y += y0;
		stroke_str (xr, y, get_wname (i), ss, st.green);
		x0 = xr + 6*dd;
		x0 += stroke_num (x0, y, EX->stores[i-1], ss, st.hfg);
		if (EX->weapon == i)
			show_rect ((xr+x0)/2, y-ss/2, (x0-xr)/2+2, ss/2+2,
					st.green, 0);
	}

/* Show throttle and power
*/
	tx = maxx/32;
	ty = maxy/32;
	x = orgx + maxx - tx - 4;		/* position */
	y = orgy + maxy;			/* bottom */
	y0 = maxy + maxy - ss - ty;		/* height */

	add_line (x, y,    T_MOVE);		/* reference bar */
	add_line (x, y-y0, st.hfg);

	if (100 == EX->throttle)
		t = 75 + muldiv (EX->afterburner, 100-75, 100);
	else {
		t = muldiv (EX->throttle, 75, 100);
		if (t < 0) {
			t = -t;
		}
	}
	t = muldiv (t, y0, 100);
	if (!EX->airbrake || blink)
		show_trig (x-tx, y-t, tx, ty, st.hfg);	/* throttle */

	t = muldiv (EX->power, y0, 10000);
	add_line (x,    y-t, T_MOVE);		/* power */
	add_line (x+tx, y-t, st.hfg);
}
