/* --------------------------------- symbols.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* Paint basic HUD symbols.
*/

#include "fly.h"


extern void FAR
show_w (int x, int y, int tx, int ty, int color)
{
	int	dx, dy;

	dx = tx/4;
	dy = ty/2;

	add_line (x - dx*3, y,    T_MOVE);
	add_line (x - dx*2, y,    color);
	add_line (x - dx,   y+dy, color);
	add_line (x,        y,    color);
	add_line (x + dx,   y+dy, color);
	add_line (x + dx*2, y,    color);
	add_line (x + dx*3, y,    color);
}

extern void FAR
show_x (int x, int y, int tx, int ty, int color)
{
	add_line (x + tx, y + ty, T_MOVE);
	add_line (x - tx, y - ty, color);
	add_line (x + tx, y - ty, T_MOVE);
	add_line (x - tx, y + ty, color);
}

extern void FAR
show_rect (int x, int y, int tx, int ty, int color, int showx)
{
	add_line (x + tx, y + ty, T_MOVE);
	add_line (x + tx, y - ty, color);
	add_line (x - tx, y - ty, color);
	add_line (x - tx, y + ty, color);
	add_line (x + tx, y + ty, color);
	if (showx)
		show_x (x, y, tx, ty, color);
}

extern void FAR
show_brect (int x, int y, int tx, int ty, int ratio, int color, int showx)
{
	int	dx, dy;

	dx = fmul (tx, ratio);
	dy = fmul (ty, ratio);

	add_line (x+dx, y+ty, T_MOVE);
	add_line (x+tx, y+ty, color);
	add_line (x+tx, y+dy, color);
	add_line (x+tx, y-dy, T_MOVE);
	add_line (x+tx, y-ty, color);
	add_line (x+dx, y-ty, color);
	add_line (x-dx, y-ty, T_MOVE);
	add_line (x-tx, y-ty, color);
	add_line (x-tx, y-dy, color);
	add_line (x-tx, y+dy, T_MOVE);
	add_line (x-tx, y+ty, color);
	add_line (x-dx, y+ty, color);
	if (showx)
		show_x (x, y, tx, ty, color);
}

extern void FAR
show_diamond (int x, int y, int tx, int ty, int color, int showx)
{
	add_line (x-tx, y,    T_MOVE);
	add_line (x,    y-ty, color);
	add_line (x+tx, y,    color);
	add_line (x,    y+ty, color);
	add_line (x-tx, y,    color);
	if (showx)
		show_x (x, y, tx, ty, color);
}

extern void FAR
show_plus (int x, int y, int tx, int ty, int color)
{
	add_line (x - tx, y,      T_MOVE);
	add_line (x + tx, y,      color);
	add_line (x,      y - ty, T_MOVE);
	add_line (x,      y + ty, color);
}

extern void FAR
show_bplus (int x, int y, int tx, int ty, int ratio, int color)
{
	int	dx, dy;

	dx = fmul (tx, ratio);
	dy = fmul (ty, ratio);

	add_line (x - tx, y,      T_MOVE);
	add_line (x - dx, y,      color);
	add_line (x + dx, y,      T_MOVE);
	add_line (x + tx, y,      color);
	add_line (x,      y - ty, T_MOVE);
	add_line (x,      y - dy, color);
	add_line (x,      y + dy, T_MOVE);
	add_line (x,      y + ty, color);
}

extern void FAR
show_fpm (int x, int y, int rx, int ry, int tx, int ty, int color, int round)
{
	if (round)
		add_5op (T_ELLIPSE, x, y, rx, ry, color);
	else
		show_diamond (x, y, rx, ry, color, 0);

	add_line (x,    y-ry, T_MOVE);
	add_line (x,    y-ty, color);
	add_line (x+rx, y,    T_MOVE);
	add_line (x+tx, y,    color);
	add_line (x-rx, y,    T_MOVE);
	add_line (x-tx, y,    color);
}

extern void FAR
show_dir (int x, int y, int rx, int ry, int tx, int ty, int color)
{
	add_line (x+rx, y,    T_MOVE);
	add_line (x+tx, y,    color);
	add_line (x-rx, y,    T_MOVE);
	add_line (x-tx, y,    color);
	add_line (x,    y-ry, T_MOVE);
	add_line (x,    y-ty, color);
}

extern void FAR
show_dir1 (int x, int y, int rx, int ry, int tx, int ty, int sa, int ca,
	int color,
	int orgx, int orgy, int sx, int sy, int shifty)
{
	int	x0, y0, x1, y1, x2, y2, x3, y3;

	x0 = fmul (rx, ca);		/* wing inside */
	y0 = fmul (rx, sa);
	x1 = fmul (tx, ca);		/* wing outside */
	y1 = fmul (tx, sa);
	x2 = fmul (rx, sa);		/* tail inside */
	y2 = fmul (rx, ca);
	x3 = fmul (tx, sa);		/* tail outside */
	y3 = fmul (tx, ca);
	x3 -= x3>>2;			/* shorter tail? */
	y3 -= y3>>2;
#if 0
	add_line (x+x0,      y+y0,      T_MOVE);	/* right wing */
	add_line (x+x1,      y+y1,      color);
	add_line (x+x1-x2/4, y+y1+y2/4, color);	/* tip */


	add_line (x-x0,      y-y0,      T_MOVE);	/* left wing */
	add_line (x-x1,      y-y1,      color);
	add_line (x-x1-x2/4, y-y1+y2/4, color);	/* tip */

	add_line (x+x2,      y-y2,      T_MOVE);	/* tail */
	add_line (x+x3,      y-y3,      color);
#else
	add_segment (x+x0, y+y0, x+x1,      y+y1,      color,
		orgx, orgy, sx, sy, shifty);			/* right wing */
	add_segment (x+x1, y+y1, x+x1-x2/4, y+y1+y2/4, color,
		orgx, orgy, sx, sy, shifty);			/* tip */
	add_segment (x-x0, y-y0, x-x1,      y-y1,      color,
		orgx, orgy, sx, sy, shifty);			/* left wing */
	add_segment (x-x1, y-y1, x-x1-x2/4, y-y1+y2/4, color,
		orgx, orgy, sx, sy, shifty);			/* tip */
	add_segment (x+x2, y-y2, x+x3,      y-y3,      color,
		orgx, orgy, sx, sy, shifty);			/* tail */
#endif
}

extern void FAR
show_ptr (int x, int y, int rx, int ry, int tx, int ty, int color, int round)
{
	if (round)
		add_5op (T_ELLIPSE, x, y, rx, ry, color);
	else
		show_rect (x, y, rx, ry, color, 0);
	add_line (x+tx/4, y-ty/4, T_MOVE);
	add_line (x+tx,   y-ty,   color);
}

extern void FAR
show_trig (int x, int y, int dx, int dy, int color)
{
	add_line (x-dx, y,    T_MOVE);
	add_line (x+dx, y,    color);
	add_line (x,    y-dy, color);
	add_line (x-dx, y,    color);
}
