.TH xacursor 1 "August 1993"
.SH NAME
xacursor \- set an animated cursor in a window

.SH SYNOPSIS
.nf
xacursor    [-d display] [-r] [-fg color] [-bg color]
            [-path directory] [-cursor file] [-mask file]
            [-wait msecond] [-m swing | random | rswing | vibrate]
            [-demo] [-h]    [file]
.fi




.SH DESCRIPTION
Upon execution, the cursor will be changed to a musical note, the window then selected
by the user will have its cursor changed to an animated one, using the paths
of the cursor bitmap files listed in -\fIfile\fP.  
If the -\fIr\fP option is specified, the cursor of the root window will be
changed.

If -\fIcursor\fP file are passed in the command line, the cursor will be
changed to the one specified.  -\fIdemo\fP shows the standard demonstration.

Please note that not all windows allow you to make a cursor change.


By default,
.I xacursor
sets the cursor to be the bitmaps in the sequence listed in "file", which are
specified in the following manner:

    cursor[1]    mask[1]    foreground[1]    background[1]
    cursor[2]    mask[2]    foreground[2]    background[2]
       .            .            .                .
       .            .            .                .
    cursor[n]    mask[n]    foreground[n]    background[n]

where "cursor[i]" and "mask[i]" are the paths of the cursor file and the mask
file; "foreground[i]" and "background[i]" are the foreground and
background colors, so the cursor can have changing
colors.  If omited, the mask is defaulted to be the cursor file; the
two colors are set to be black and white respectively, unless otherwise 
specified by the user.


.I xacursor
ignores all blank lines, spaces and tabs; lines beginning with the "#"
character are comments.  All tokens "NA" are treated as place holder and will
be ignored as well, so if one does not want to specified the mask file,
the line may look like:

    e.g.  fire1.xbm    NA    goldenrod    midnightblue


.SH OPTIONS
.nf
\fB-d\fP \fIdisplay\fP          Specifies the display that should be used.


\fB-r\fP                  The cursor of the root window will be changed,
                    the user will not be asked to specified a window.


\fB-fg\fP \fIcolor\fP           The foreground color of the cursor,
                    defaulted to be black.


\fB-bg\fP \fIcolor\fP           The background color of the cursor,
                    defaulted to be white.


\fB-cursor\fP \fIfile\fP        Using this option, the user can set the
                    cursor to "file", which is not animated.


\fB-mask\fP \fIfile\fP          The path of the mask file, defaulted to
                    be the cursor file if omited.  In the
                    case of multiple cursors (as listed in
                    "file"}, it serves as the default mask file
                    for all cursors, unless it is otherwise
                    specified in the cursor list.


\fB-path\fP \fIdirectory\fP     The directory in which all the specified
                    bitmaps can be found, so the user does not need to
                    type the full path of the bitmap files.  This path
                    is optional.


\fB-mode\fP \fIswing\fP | \fIrandom\fP | \fIrswing\fP | \fIvibrate\fP
                    The way the cursors are animated.  By default,
                    the cursor will be animated in the
                    sequence "first to last" as specified in "file".

                    "swing" mode makes the cursors changes from
                    the 1st one to the last one, go back to the
                    1st one in reverse order, then start from
                    the 1st one again; and so on and so forth.

                    While "random" mode makes them appear in
                    random orders.

                    "rswing" is just swing except the cursors
                    changes from the 1st one to one that is
                    picked at random, go back to the 1st one
                    in reverse order; then start again from the
                    1st one.
                    
                    Being a little like "rswing", "vibrate" picks
                    2 random bitmap "a" and "b" when starts,
                    change the bitmap from "a" to "b"; then picks
                    another random bitmap "c", and goes from "b"
                    to "c", and so on.


\fB-wait\fP \fImsecond\fP       Wait for "msecond" number of milli-
                    seconds between successive changes of the
                    cursor.  By default, "msecond" cannot be smaller
                    then 10, otherwise 10 will be used.  The
                    default is 200 msec.


\fB-demo\fP               Show the standard demonstration, which is a
                    rotating earth.  This can be combined with other
                    options like "-fg", "-mode" and "-wait" to get
                    a unique appearance.


\fB-h\fP                  Display the help message.
.fi




.SH FILE
.nf
\fIfile\fP                The cursor list, contains relative pathnames
                    of cursors to be animated, subject to the
                    presence or absence of "-path", as
                    specified above.
.fi




.SH AUTHOR
.nf
\fBxacursor\fP is written by Kam-Hung WONG (k2wong@noether.math.uwaterloo.ca),
4th year Computer Science student at University of Waterloo, Canada.
(WWW: http://www.undergrad.math.uwaterloo.ca/~k2wong)

Thanks goes to Victor S. H. Wong and Hilda Lee, for their fine
efforts of drawing many interesting bitmaps for demonstration
purposes.

This is a small work, but I would like to dedicate it to friends
at the Faculty of Mathematics, because of whom these years become
so memorable.

Further improvements to the application will be made, if the author 
survives the Real-time Programming course. :-)
.fi


