.TH XSPRINGIES 1 "September 1, 1992"
.SH NAME
xspringies \- a mass and spring simulation system for X windows
.SH SYNTAX
\fBxspringies\fP [ \fIoptions\fP ]
.SH DESCRIPTION
.B xspringies
is a simulator which allows you to interactively create and edit a
system of masses and springs.  The parameters of the masses and springs (such
as mass elasticity and spring K) as well as those of the surrounding system
(such as air viscosity and gravity) can be changed.
.sp 0
These systems can be loaded and saved into a file.
.sp 1
I guess you could use
.B xspringies
for real work, but it's really intended to
be a time waster.
.SH OPTIONS
.IP "\-bg \fIcolor\fP"
Specifies the color of the window background.  The default is black.
.IP "\-d \fIdispname\fP"
Specifies the display screen on which \fBxspringies\fP displays its window.
If the display option is not specified, \fBxspringies\fP uses the display
screen specified by your DISPLAY environment variable.
.IP "\-display \fIdispname\fP"
This option is the same as the \fB\-d\fP option.
.IP "\-fg \fIcolor\fP"
Specifies the foreground color of the window.  The default is white.
.IP "\-geometry \fIgeom\fR"
Specifies the width, height, and location of
the
.B xspringies
window.
If the geometry option is not specified,
.B xspringies
uses default values.
The geometry option has the format
.sp 0
.in +0.5i
[=][\fIwidth\fRx\fIheight\fR][+/-\fIxoffset\fR+/-\fIyoffset\fR].
.in -0.5i
.IP \-nbb
This option turns off the bounding-box optimization.
To produce smooth animation,
.B xspringies
redraws the smallest screen region which contains all objects.  For smaller
objects, the performance improvement is very noticible -- this is the
bounding-box optimization.  By disabling it with this option, 
.B xspringies
redraws the entire display window.  On slower machines or larger window
sizes, this can produce slow results.
The main reason for using this option is if the bounding-box changes
size rapidly, causing uneven animation.
.IP "\-hl \fIcolor\fP"
Specifies the color of the button and selection highlights in the window.
This defaults to the foreground color, or to green on color displays.
.IP \-rv
Specifies that the foreground and background colors be reversed.
.IP "\-st \fIthickness\fP"
Specifies the thickness of the springs in pixels (0 is the default value)
.SH SUMMARY OF OPERATION
.ti +2m
The left side of the \fBxspringies\fR window contains the controls, and the
right side contains the display.  Masses can be created and placed with the
mouse when in \fBMass\fR mode, and springs can be created when in \fBSpring\fR
mode.  Temporary springs that connect the mouse and any mass can be used
to pull on objects.  Masses and springs can be selected in edit mode, and
moved around.  Parameters of the masses and springs (such as Mass or
Elasticity) can be set upon creation or if they are selected.
.sp 1
.ti +2m
Forces (such as gravity) can be enabled by pressing the appropriate force
button with customizable parameters.  Environment parameters such as viscosity
of the medium and stickiness of the walls can also be set.  Each of the four
walls can be disabled.
.sp 1
.ti +2m
The animation/simulation is activated by pressing the \fBGO!\fR button.
.sp 1
.ti +2m
The entire system (masses, springs and parameters) can be loaded and saved to
files.  \fBXspringies\fR comes with many demonstration files.

.SH CONTROLS
.ti +2m
There are three types of controls (widgets) in \fBxspringies\fR.  There
are push buttons, checkboxes and sliders.  The push buttons and checkboxes
act in the obvious manner.  If you click on them, they get activated.
.sp 1
.ti +2m
Sliders are a little more compilicated.  They consist of a left arrow button,
a right arrow button, and a text box.  The text box displays the current value.
Clicking on this text box causes it to become highlighted.  All text input
then goes to the text box.  After entering a value, return accepts it, and
escape cancels.
.sp 0
.ti +2m
The value displayed can also be changed by pressing the arrow buttons.
Using the
.I Left mouse button
causes the value to be incremented or decremented by one step.  The
.I Middle mouse button
is the same as the left mouse button, but holding it down causes it to scan
by one step at a time.  The
.I Right mouse button
scans like the
.I Middle mouse button
except that it scans 10 steps at a time.

.SH EDITING MODES
.ti +2m
There are three main modes in \fBxspringies\fR.
These are
.I Edit,
.I Mass
and
.I Spring.
In
.I Edit
mode, you can select, move and throw objects.  In
.I Mass
mode, you can create masses.  In
.I Spring
mode, you can create springs and tug on an object with a spring
connected to the mouse.

More specifically,
.IP "\fIEdit\fR \fBmode:\fB"
\fB-\fR
.I Left mouse button
selects objects.
.sp 0
.ti +2m
If you click on or near an object, it becomes selected, and all other
objects become unselected. If you hold down shift while clicking, the object
becomes selected (or unselected if it was already selected), and all other
objects remain the same.
.sp 0
.ti +2m
If you do not click near an object, dragging the mouse causes a selection box
to appear.  Anything within the selection box when the mouse is released 
becomes selected.  All other masses become unselected, unless the shift
key was held down for the initial click.
.sp 1
\fB-\fR
.I Middle mouse button
moves objects.
.sp 0
.ti +2m
All selected objects move with the mouse.  The masses are frozen in their
positions after the initial click.  They continue to move relative to the
mouse movement until the middle button is released.
.sp 1
\fB-\fR
.I Right mouse button
throws objects.
.sp 0
.ti +2m
This acts the same way as moving objects with the middle button, except for
the fact that the mouse velocity is transferred to all selected objects when
the right mouse button is released.
.sp 0
.ti +2m
Note: a good way to stop an object from moving is to simply select it and
click the right mouse button.
.IP "\fIMass\fR \fBmode:\fB"
.ti +2m
When you click with the mouse, a mass appears.  The mass takes on the values
of the
.I Mass
and
.I Elasticity
sliders.  The mass is placed when the mouse
button is released.
.IP "\fISpring\fR \fBmode:\fB"
.ti +2m
When you click with the mouse, if there is a mass nearby, one end of a
spring is connected to it.  The other end of the spring is connected to the
cursor until the mouse button is released.  If no mass is nearby when the
spring is released, the spring is discarded.  The new spring takes on the
values of the
.I Kspring
and
.I Kdamp
sliders.  The rest length of the spring is
equal to the length of the spring when it was created.
.sp 1
\fB-\fR
.I Left mouse button
adds a spring between two masses while actively affecting the first mass.
.sp 1
\fB-\fR
.I Middle mouse button
adds a spring between the first mass and the cursor, actively affecting
the first mass.  The spring is discarded when the mouse button
is released.
.sp 1
\fB-\fR
.I Right mouse button
adds a spring between two masses.  The first mass is not affected by the
spring until the spring is in place after the mouse is released.

.SH OPERATION
.IP "Masses and Springs"
.ti +2m
Accelerations on the masses are calculated according to gravity (and other
special forces), viscous forces, and by forces from the springs.  When a mass
collides with a wall, its velocity in the direction of the wall is reversed.
The resulting velocity is multipled by the
.I Elasticity
of the mass.  So, an
elasticity of 0.0 causes an inelastic collision (it stops on the wall),
and an elasticity of 1.0 results in an elastic collision.
.sp 0
.ti +2m
If a mass is fixed, all forces on it are ignored.  It simply does not move.
Think of it as a nail (a really good one).
.sp 0
.ti +2m
The
.I Mass
and
.I Elasticity
of a mass can be changed by selecting the mass and
changing the values on the corresponding sliders.  To make a mass fixed or
unfixed, check or uncheck the
.I Fixed Mass
checkbox while the mass is selected.
.sp 1
.ti +2m
A spring has three parameters associated with it.  \fIKspring\fR, \fIKdamp\fR
and rest length.  The spring force is calculated as follows (according to
Hooke's law):
.sp 0
.in +10m
.ti -4m
\fBF\fR = - \fIKspring\fR * (length - rest length) - \fIKdamp\fR *
(velocity in spring direction)
.in -10m
.sp 1
.ti +2m
To change the
.I Kspring
or
.I Kdamp
of a spring, change the values of the sliders
when the spring is selected.  Pressing the
.I Set Rest Length
button changes the rest length of a selected spring to its current length.

.IP "Forces and sticky stuff"
.ti +2m
There are four special forces.  They can be turned on and off by clicking
their appropriate box.  When highlighted, the force is on.
Each of these forces has two parameters associated with it (for example,
.I Magnitude
and
.I Direction
for gravity).  Only one forces's parameters are displayed at a time (below
the force buttons).  Which particular force is shown by a darker box
around that force.  This force selector box is moved to another force
whenever a force is turned on.
.sp 1
.ti +2m
Some of the forces are applied relative to some specified origin, or
center point.  By default, this center point is the center of the screen.
It can be changed to be any one particular mass by selecting a single mass,
and pushing the
.I Set Center
button.  If no masses are selected, the current center is changed to be
the center of the screen.
.sp 0
.ti +2m
Center points are marked by a box around the center mass.
.sp 1
.ti +2m
There are four forces that can be enabled.
The first one, \fIGravity\fR, acts in the familiar manner.
It accelerates masses by the value specified
by
.I Gravity
in a direction specified by
.I Direction.
The
.I Direction
is measured in degrees, with 0.0 degrees being down, increasing
counter-clockwise.
.sp 0
.ti +2m
The second force is a bit strange, and isn't real.  Its a force which
attracts the center of mass of all the objects toward the center point.
It has a
.I Magnitude
and a
.I Damping
coefficient.
.sp 0
.ti +2m
The third force is a force which attracts all masses toward the center point.
This force has a
.I Magnitude
and an
.I Exponent
associated with it.  The
.I Exponent
is simply how the force relation works.  A value of 2.0 means inverse-square
force (the force is inversely proportional to the distance squared).  A value
of 0.0 is a constant force independent of position.  If the
.I Magnitude
of this force is negative, it becomes a repulsion force.
.sp 0
.ti +2m
The fourth force is a wall repulsion force.  Masses are repelled by a force
from each wall that is on.  This force has a
.I Magnitude
and
.I Exponent
associated with it.  The
.I Exponent
behaves similarly to that of the third force.
.sp 1
.ti +2m
For the most part, most everything obeys 
.I f = ma.
The only exceptions are wall bounces and wall stickiness.  Another unphysical
aspect is found in some of the special forces (the second and third ones).
If a center point exists, that mass does not receive any force response
from other masses due to the special force.  In other words, these two special
forces are not \fIequal and opposite\fR forces.  They're pretty much just
unreal.
.sp 1
.ti +2m
.I Viscosity
is a viscous drag force which applies a resistive force on the masses
proportional to their velocity.
.sp 0
.ti +2m
.I Stickiness
is not a real force.  When a mass hits a wall, it loses part of its velocity
component in the direction of the wall (in an amount proportional to the
.I Stickiness).
If it loses all of this component, it remains stuck to the
wall.  It will remain stuck to the wall until a force (which exceeds an
amount proportional to the
.I Stickiness)
pulls it off the wall.

.IP "Numerics"
.ti +2m
The internals of
.B xspringies
consist of a fourth order Runge-Kutta (RK4) differental equation solver.
Consult a Numerical Methods text for more information.  The
.I Time Step
that is used by this solver (the \fBdt\fR) can be set using the slider.
.sp 0
.ti +2m
The solver can be selectively made into an adaptive RK4 solver using the
.I Adaptive Time Step
checkbox.  An adaptive solver chooses the best time step value according
to an error calculation.  The error is not allowed to exceed the
.I Precision
value.  Lower precision values result in smaller time steps.  While this
is more accurate, the simulation runs slower.
.sp 0
.ti +2m
You will notice that some objects will tend to "blow up" easily.  This is
because the objects are unstable, or are sensitive to small numerical errors.
An object will tend to "blow up" less with smaller time steps.
By using an adaptive solver, the simulation can be made more
accurate only when necessary.  This results in a more stable system which
runs at a reasonable speed.

.IP "Walls"
.ti +2m
There are four walls.  In case you haven't guessed by now, they are the
.I top, left, right
and
.I bottom
walls.  They are located at the window boundaries; they move with
window resizes.  Individual walls can be enabled and disabled by checking the
corresponding
.i Walls
checkboxes.
.sp 1
.ti +2m
Walls are only one-way.  An object moving from the screen toward a wall will
bounce off the wall.  But an object moving from off screen toward
the screen will pass through the walls.

.IP "Saving and Restoring State"
.ti +2m
The state of the world (at least for \fBxspringies\fR)
includes all of the masses
and springs, as well as the system parameters.  By pushing the
.I Save State
button, the current system state is saved.   By pushing the
.I Restore State button
the previously saved system state is restored (if no previous save was
made, the initial state is used).
.sp 1
.ti +2m
This is useful for temporarily saving a system configuration that you do
not feel like setting up again (or saving to a file), that you might disturb
with experimentation.  If you break it, you can
.I Restore State
any number of times you like.
.sp 0
.ti +2m
The
.I Reset
button resets
.B xspringies
to its initial configuration.  All the masses and springs are removed, and
the default system parameters are used.

.IP "Saving and Loading Files"
.ti +2m
The system state can be saved to and loaded from files.
By pushing the
.I Load File
button, a previously saved file can be loaded.  This will load up all the
masses and springs that were saved, as well as the system parameters.
Any previous state before the load is cleared.  Pushing the
.I Save File
button saves this information in the designated file.  The
.I Insert File
button is much like the
.I Load File
button, except that the current state is not cleared.  Instead, only the
masses and springs are loaded (the system paramaters are not changed), and
are added to the current collection.   If no objects are selected when
the
.I Insert File
button is pressed, then all the objects in the file are selected after they
are loaded.
.sp 1
.ti +2m
The filenames are entered in the text window, which is located at the bottom
right of the window.   For consistency, the filenames should terminate
with "\fB.xsp\fR".  When a file is loaded or saved, this extension is
automatically added if not added by the user.
Standard emacs-like editing features are present.  The following key controls
can be used:
.sp 0
.in +1.0i
.ti -0.5i
\fBcontrol-B\fR  move cursor backward
.sp 0
.ti -0.5i
\fBcontrol-F\fR  move cursor forward
.sp 0
.ti -0.5i
\fBcontrol-A\fR  goto beginning of line
.sp 0
.ti -0.5i
\fBcontrol-E\fR  goto end of line
.sp 0
.ti -0.5i
\fBcontrol-K\fR  kill to end of line
.sp 0
.ti -0.5i
\fBcontrol-Y\fR  yank from kill buffer
.sp 0
.ti -0.5i
\fBcontrol-D\fR  delete character under cursor
.sp 0
.ti -0.5i
\fBcontrol-U\fR  erase all input
.sp 0
.ti -0.5i
\fBcontrol-T\fR  transpose character under cursor with previous character
.sp 0
.ti -0.5i
\fBEscape   \fR  exit from filename edit mode
.sp 0
.sp 1
.in -1.0i
.ti +2m
.sp 0
By default, the directory which contains the 
.B xspringies
files is
present automatically.  If the environment variable
.B SPRINGDIR
is set, then the default directory is changed to reflect it.
.sp 0
.ti +2m
If a file error occurs (for example, the file does not exist), a beep is
emitted.

.IP "Other stuff"
.ti +2m
The 
.I GO!
button simply turns on and off the animation.  With
.I GO!
turned off,
.B xspringies
uses up little CPU time.
.sp 1
.ti +2m
The
.I Show Springs
checkbox controls whether or not the springs are drawn.  If there are a lot
of springs, animation may go faster with this option on.  Sometimes an object
will even look better with only the masses.
.sp 1
.ti +2m
When placing masses or springs, objects can be placed in a gridlike fashion
if the 
.I Grid Snap
checkbox is enabled.  Masses will be separated (vertically and horizontally)
by the amount specified by the
.I Grid Snap
slider.
.sp 1
.ti +2m
When the
.I Duplicate
button is pushed, all selected masses and springs are duplicated.  The copy
is left in the same place, unselected.
.sp 1
.ti +2m
By pushing the
.I Select All
button, all masses and springs are selected.
.sp 1
.ti +2m
By pushing the
.I Delete
button, or pressing the 
.I Delete
key, all selected objects are deleted.  Note that if a mass is deleted, all
attached springs are also deleted (even if they were not selected).
.sp 1
.ti +2m
The
.I Quit
button quits the program.  This same effect is found by pressing the
\fIQ\fR key.

.SH FILE FORMAT
.ti +2m
The
.B xspringies
file format is human readable.  Each line consists of a four letter command
string, followed by the parameters for that command.  The file must start
with the command "\fB#1.0\fR".  (This 1.0 refers to file format version 1.0,
and not the version of xspringies being run) Each of the commands below is
on a line by itself.  There are no blank lines allowed.  The file must end
in a newline.
.sp 1
The file consists of the following commands:
.sp 0
.in +1.0i
.ti -0.5i
\fBcmas\fR <current \fIMass\fR value>
.sp 0
.ti -0.5i
\fBelas\fR <current \fIElasticity\fR value>
.sp 0
.ti -0.5i
\fBkspr\fR <current \fIKspring\fR value>
.sp 0
.ti -0.5i
\fBkdmp\fR <current \fIKdamp\fR value>
.sp 0
.ti -0.5i
\fBfixm\fR <boolean value for \fIFixed Mass\fR>
.sp 0
.ti -0.5i
\fBshws\fR <boolean value for \fIShow Springs\fR>
.sp 0
.ti -0.5i
\fBcent\fR <mass id number of center mass>
.in -0.2i
If there is no center mass (i.e. - center of screen is to be used), then
the value of \fI-1\fR is used.
.in +0.2i
.sp 0
.ti -0.5i
\fBfrce\fR <force\ id\ number> <boolean\ active> <parameter\ #1\ value> <parameter\ #2\ value>
.in -0.2i
The <force\ id\ number> sequence is as follows:
.in +0.3i
\fB0\fR - Gravity
.sp 0
\fB1\fR - Center of mass attraction force
.sp 0
\fB2\fR - Center attraction force
.sp 0
\fB3\fR - Wall repulsion force
.sp 0
.in -0.3i
.in +0.2i
.sp 0
.ti -0.5i
\fBvisc\fR <current \fIViscosity\fR value>
.sp 0
.ti -0.5i
\fBstck\fR <current \fIStickiness\fR value>
.sp 0
.ti -0.5i
\fBstep\fR <current \fITime Step\fR value>
.sp 0
.ti -0.5i
\fBprec\fR <current \fIPrecision\fR value>
.sp 0
.ti -0.5i
\fBadpt\fR <boolean value for \fIAdaptive Time Step\fR>
.sp 0
.ti -0.5i
\fBgsnp\fR <current \fIGrid Snap\fR value> <boolean\ enable>
.sp 0
.ti -0.5i
\fBwall\fR <boolean\ top> <boolean\ left> <boolean\ right> <boolean\ bottom> 
.sp 0
.ti -0.5i
\fBmass\fR <mass\ id\ number> <x\ position\ value> <y\ position\ value> <x\ velocity\ value> <y\ velocity\ value> <mass\ value> <elasticity\ value>
.in -0.2i
For each mass, the <mass\ id\ number> must be unique.  They do not need to
be in any order.  If a mass is fixed, then the <mass\ value> field is negated.
.in +0.2i
.sp 0
.ti -0.5i
\fBspng\fR <spring\ id\ number> <mass\ #1\ id\ number> <mass\ #2\ id\ number> <Kspring\ value> <Kdamp\ value> <rest\ length\ value>
.in -0.2i
For each spring, the <spring\ id\ number> must be unique.  They do not need to
be in any order.  The order of the <mass\ id\ number>'s is not important.
.in +0.2i
.sp 1
.in -1.0i
.ti +2m
All \fIvalues\fR are floating point numbers.  All \fIid numbers\fR are
positive integers, and all \fIboolean\fR values are non-zero/zero for
True/False.  It is possible to feed \fBxspringies\fR bogus values.  It may
produce interesting or amusing side effects, but will most likely cause
an object to explode or \fBxspringies\fR to crash.
.SH AUTHOR
.PP
Douglas DeCarlo (dmd@gradient.cis.upenn.edu)
.sp 1
Please send demo files, comments, suggestions, bug reports, bug fixes and
enhancements.

.IP "With thanks to:"
.sp 0
Elliott Evans
.sp 0
.in +0.4i
Bitmap slave.
.in -0.4i
.sp 1
Nathan Loofbourrow
.sp 0
.in +0.4i
I bothered him a whole lot about the user interface.
.in -0.4i
.sp 1
Drew Olbrich
.sp 0
.in +0.4i
The blame for "stickiness" falls on him, as well as a few other things.
.in -0.4i
.sp 1
Andy Witkin
.sp 0
.in +0.4i
For teaching a really great physically based modeling course at CMU.
Many ideas (both methods and interface) came from that class.
.in -0.4i
.sp 1
And thanks to the many other people who helped in testing
.B xspringies
and make some of the neat demo files, including
James Helfrich, Brian Kelley, Patrick Lopez, Chris Newman and Jef Poskanzer.

.SH RESTRICTIONS
.B xspringies
runs faster on a monochrome display than on a color display (usually).
.sp 1
You probably don't want to run
.B xspringies
on a slow machine or a machine which does slow bit-blitting operations.
Well, I guess you could... But you would be sorry for even trying.
.sp 1
Here is a good rule:  If
.B xspringies
isn't fun to use, then your machine is either too slow, or it is overloaded.
Or maybe you just aren't a fun person.  :-)
