.\" xwit man
.TH XWIT 1X
.SH NAME
xwit \- window interface. pop or iconify this xterm window or named windows
.SH SYNOPSIS
.B
xwit
'in \n(.iu+\w'\fBxwit \fR'u
.RB [ -display
.IR display ]
.RB [ -pop ]
.RB [ -iconify ]
.RB [ -unmap ]
.br
.RB [ -resize
.IR w\ h ]
.RB [ -rows
.IR r ]
.RB [ -columns
.IR c ]
.RB [ - [ r ] move
.IR x\ y ]
.br
.RB [ - [ r ] warp 
.IR x\ y ]
.RB [ -cmap
.IR colormap ]
.RB [ - [ no ] save
.br
.RB [ -name
.IR name ]
.RB [ -iconname
.IR name ]
.br
.RB [ -bitmap
.IR file ]
.RB [ -mask
.IR file ]
.br
.RB [ - [ no ] keyrepeat
.IR "keycode ... keycode - keycode ..." ]
.br
.RB [ -root ]
.RB [ -id
.IR windowid ]
.RB [ -names
.IR initialsubstring... ]
.in
.SH DESCRIPTION
.B xwit
is an X window interface tool.
By default when used with no arguments in an xterm it
de-iconifies and raises the window.
You can specify a different function to do, such as iconifying the window,
and apply it to several windows whose name begins with one of the given
strings, or a particular window id given, or the window id found
in the environment variable
.B WINDOWID.
(This variable is set by xterm for the program, usually the shell, it runs.)
.SH OPTIONS
.TP
-display
is followed by the display to open.
.TP
-pop
is the default action.
It need only be given if it is wanted as well as some other function.
.TP
-iconify
will iconify the windows instead of popping them.
.TP
-unmap
will iconify windows by unmapping with a non ICCCM compliant window manager.
(Beware, this option is not usually what you want).
.TP
-resize w h
resize windows to the given pixel size.
.TP
-rows r
resize windows to the given number of rows.
.TP
-columns c
resize windows to the given number of columns.
.TP
-move x y
move windows to the given absolute position relative to its parent.
.TP
-rmove x y
move windows to the given relative amount.
.TP
-warp x y
move the cursor to the given position relative to the specified window.
Add -root to warp to an absolute position.
.TP
-rwarp x y
move the cursor by the given relative amount.
.TP
-colormap
install the given colormap into the given window.
.TP
-name name
set the WM_NAME property to the given string.
.TP
-iconname name
set the WM_ICON_NAME property to the given string.
.TP
-bitmap file
use the given bitmap file as the icon bitmap for the window.
.TP
-mask file
use the given bitmap file as the icon mask for the window.
.TP
-id 
is followed by a single window number, in decimal or if it begins with
0x in hexadecimal.
.TP
-names
if given must be the last option on the line and is followed by a list of strings.
All windows that have a name that begins exactly like one of the strings
will be acted upon.
By using a null string (-names ''), all names will be matched.
.TP
-keyrepeat -nokeyrepeat
is followed by a list of keycodes (decimal numbers, see xmodmap(1)).
A range can be specified as a lower number, ``-'', and upper number
as three separate arguments.
The individual setting of auto-repeat for those keycodes is set on or off.
The global setting of auto-repeat can be set with xset(1).
When off, no keys will repeat.
xset will also show the current settings for individual keys.
.SH EXAMPLES
To iconify all windows (probably not quite what you want to do)

.ta 1i
	xwit -names ''

To de-iconify and pop ``this'' xterm and warp the cursor into it

	xwit -pop -warp 50 50

To gently agitate your oclock on the screen

 	while   xwit -rmove 0 10 -names oclock
 	do      xwit -rmove 0 -10 -names oclock
 	done
	
.SH LIMITATIONS
Since each application is supposed to request these functions of the
window manager, some of them may not like other clients mapping and unmapping
for them behind their back.
The iconification is requested of the window manager using the ICCCM.
Non ICCCM compliant window managers may not react correctly.
.SH AUTHORS
Mark M Martin. CETIA France. %E%. mmm@cetia.fr
David DiGiacomo dd@mv.us.adobe.com
