/*
 * $Id: AdjRowColP.h,v 1.9 1995/03/21 00:15:53 gerd Exp $
 */

/* Copyright (C) 1995 Gerd Rausch
   Please send comments and suggestions to:
   <gerd@alf.gun.de>

AdjRowCol is free software; you can redistribute it and/or modify it under
the terms of the GNU Library General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

AdjRowCol is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU Library General Public
License along with this software; see the file COPYING.LIB.  If not,
write to the Free Software Foundation, 675 Mass Ave, Cambridge, MA
02139, USA.  */

#ifndef _AdjRowColP_h
#define _AdjRowColP_h

#include <X11/Xmu/Converters.h>
#ifdef USE_MOTIF
#include <Xm/ManagerP.h>
#endif
#include "AdjRowCol.h"

#ifdef USE_MOTIF
#define XmAdjRowColClassPart AdjRowColClassPart
#define _XmAdjRowColClassPart _AdjRowColClassPart
#endif /* USE_MOTIF */

typedef struct _AdjRowColClassPart {
    int foo;	/* empty */
} AdjRowColClassPart;

/* Class record declaration */
typedef struct _AdjRowColClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
#ifdef USE_MOTIF
    ConstraintClassPart constraint_class;
    XmManagerClassPart  manager_class;
#endif
    AdjRowColClassPart	adjRowCol_class;
}AdjRowColClassRec;

extern AdjRowColClassRec adjRowColClassRec;

typedef enum {
    DimensionIdxPreferred,
    DimensionIdxRequired,
    DimensionIdxLast
}DimensionIdx;

typedef enum {
    DirectionIdxCol,
    DirectionIdxRow,
    DirectionIdxLast
}DirectionIdx;

typedef struct {
    int alloced,n;
    Dimension *values;
}DimensionArray;

typedef struct {
    int allocedRows,allocedCols,nCols,nRows;
    DimensionArray dimensions[DimensionIdxLast][DirectionIdxLast];
    Widget *managedChildren;
    Boolean resortManagedChildren;
    int allocedManagedChildren,nManagedChildren;
}TableInfo;

typedef struct {
    /* resources */
    Boolean threeD;
    Boolean adjustable[DirectionIdxLast]; /* Is user allowed to adjust rows/cols */
    XtOrientation orientation;
    int columns;
    Dimension gripThickness, gripBorder;
    Cursor gripHorizCursor,gripVertCursor,gripCrossCursor;
#ifndef USE_MOTIF
    Dimension shadowThickness;
    Pixel foreground,topShadowColor,bottomShadowColor;
#endif

    TableInfo currentTable,intendedTable;
    Boolean gripsDisplayed;
    GC gripGC,topGC,bottomGC,clearGC,rubberGC;
    struct {
	int idx,start,last;
    }dragInfo[DirectionIdxLast];
    Boolean dragging;
    Cursor draggingCursor;
}AdjRowColPart;

typedef struct _AdjRowColRec {
    CorePart		core;
    CompositePart	composite;
#ifdef USE_MOTIF
    ConstraintPart	constraint;
    XmManagerPart	manager;
#endif
    AdjRowColPart	adjRowCol;
}AdjRowColRec;

#endif /* _AdjRowColP_h */
