/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
/*****************************************************************
 ***                                                           ***
 ***              Draw Arrows                                  ***
 ***                                                           ***
 *****************************************************************/
#define _EZ_DRAW_SPECIAL_C_

#include "EZ_Widget.h"

/*********************************************************************
 * 
 *  Functions implemented in this file:
 */
void  EZ_DrawSpecial MY_ANSIARGS(( EZ_Widget     *widget,
				  Drawable      drawable,
				  GC            tgc,
				  int           type,
				  int           x, int y,
				  int           w, int h));

/***************************************************************************
 * 
 * Draw special labels. Arrows
 */

void  EZ_DrawSpecial(widget,drawable, tgc, type, x,y, w, h)
     EZ_Widget     *widget;
     Drawable      drawable;     /* place to draw  */
     GC            tgc;
     int           type;         
     int           x,y;          /* up left corner */
     int           w,h;          /* size */
{
  XPoint c1[5], c2[5];
  GC   gc;

  /* figure the gc to use */
  if(tgc) gc = tgc;
  else
    {
      if(EZ_WidgetForeground(widget) != EZ_DEFAULT_FOREGROUND)
	{
	  XSetForeground(EZ_Display, EZ_WRITABLEGC, EZ_WidgetForeground(widget));
	  gc =  EZ_WRITABLEGC;
	}
      else gc = EZ_BUTTON_TEXTGC;
    }

  switch(type)
    {
    case EZ_DOWN_TRIANGLE:
      c1[0].x = (short)x;
      c1[0].y = (short)y;
      c1[1].x = (short) (x + (w>>1));
      c1[1].y = (short) (y +  h);
      c1[2].x = (short) (x + w);
      c1[2].y = (short) y;

      XFillPolygon(EZ_Display, drawable,gc,
		   c1, 3, Convex, CoordModeOrigin);
      break;

    case EZ_UP_TRIANGLE:
      c1[0].x = (short)(x + (w >> 1));
      c1[0].y = (short)y;
      c1[1].x = (short) x;
      c1[1].y = (short) (y +  h);
      c1[2].x = (short) (x + w);
      c1[2].y = (short) (y + h);
      c1[3].x = c1[0].x;
      c1[3].y = c1[0].y;
      
      XFillPolygon(EZ_Display, drawable,gc,
		   c1, 3, Convex, CoordModeOrigin);
      XDrawLines(EZ_Display, drawable,gc,
		 c1, 4, CoordModeOrigin);
      break;

    case EZ_LEFT_TRIANGLE:
      c1[0].x = (short)(x);
      c1[0].y = (short)(y + (h >> 1));
      c1[1].x = (short) (x + w);
      c1[1].y = (short) (y +  h);
      c1[2].x = (short) (x + w);
      c1[2].y = (short) y;
      c1[3].x = c1[0].x;
      c1[3].y = c1[0].y;
      
      XFillPolygon(EZ_Display, drawable,gc,
		   c1, 3, Convex, CoordModeOrigin);
      XDrawLines(EZ_Display, drawable,gc,
		 c1, 4, CoordModeOrigin);
      break;

    case EZ_RIGHT_TRIANGLE:
      c1[0].x = (short)(x);
      c1[0].y = (short)(y);
      c1[1].x = (short)(x);
      c1[1].y = (short)(y +  h);
      c1[2].x = (short)(x + w);
      c1[2].y = (short)(y + (h >> 1));
      c1[3].x = c1[0].x;
      c1[3].y = c1[0].y;
      
      XFillPolygon(EZ_Display, drawable,gc,
		   c1, 3, Convex, CoordModeOrigin);
      XDrawLines(EZ_Display, drawable,gc,
		 c1, 4, CoordModeOrigin);
      break;

    case EZ_DOWN_ARROW:
      {
	int h2 = (h>>1);
	int w3 = (w/3);
	int w32 = w - w3;
	c1[0].x = (short)(x + w3);
	c1[0].y = (short)(y);
	c1[1].x = (short)(x + w3);
	c1[1].y = (short)(y + h2);
	c1[2].x = (short)(x + w32);
	c1[2].y = (short)(y + h2);
	c1[3].x = (short)(x + w32);
	c1[3].y = (short)(y);
	c1[4].x = c1[0].x;
	c1[4].y = c1[0].y;	
      
	c2[0].x = (short)x;
	c2[0].y = (short)(y+h2);
	c2[1].x = (short)(x + (w>>1));
	c2[1].y = (short)(y + h);
	c2[2].x = (short)(x + w);
	c2[2].y = (short)(y + h2);
	c2[3].x = c2[0].x;
	c2[3].y = c2[0].y;

	XFillPolygon(EZ_Display, drawable,gc,
		     c1, 4, Convex, CoordModeOrigin);
	XFillPolygon(EZ_Display, drawable,gc,
		     c2, 3, Convex, CoordModeOrigin);
	XDrawLines(EZ_Display, drawable,gc,
		   c1, 5, CoordModeOrigin);
	XDrawLines(EZ_Display, drawable,gc,
		   c2, 4, CoordModeOrigin);
    
      }
    break;

    case EZ_UP_ARROW:
      {
	int h2 = (h>>1);
	int w3 = (w/3);
	int w32 = w - w3;
	c1[0].x = (short)(x + w3);
	c1[0].y = (short)(y + h2);
	c1[1].x = (short)(x + w3);
	c1[1].y = (short)(y + h);
	c1[2].x = (short)(x + w32);
	c1[2].y = (short)(y + h);
	c1[3].x = (short)(x + w32);
	c1[3].y = (short)(y + h2);
	c1[4].x = c1[0].x;
	c1[4].y = c1[0].y;	      

	c2[0].x = (short)x ;
	c2[0].y = (short)(y+h2);
	c2[1].x = (short)(x + w);
	c2[1].y = (short)(y + h2);
	c2[2].x = (short)(x + (w>>1));
	c2[2].y = (short)(y);
	c2[3].x = c2[0].x;
	c2[3].y = c2[0].y;

	XFillPolygon(EZ_Display, drawable,gc,
		     c1, 4, Convex, CoordModeOrigin);
	XFillPolygon(EZ_Display, drawable,gc,
		     c2, 3, Convex, CoordModeOrigin);
	XDrawLines(EZ_Display, drawable,gc,
		   c1, 5, CoordModeOrigin);
	XDrawLines(EZ_Display, drawable,gc,
		   c2, 4, CoordModeOrigin);
      }
    break;
    case EZ_LEFT_ARROW:
      {
	int w2 = (w>>1);
	int h3 = (h/3);
	int h32 = h - h3;
	int h2 = h >> 1;

	c1[0].x = (short)(x + w2);
	c1[0].y = (short)(y + h3);
	c1[1].x = (short)(x + w);
	c1[1].y = (short)(y + h3);
	c1[2].x = (short)(x + w);
	c1[2].y = (short)(y + h32);
	c1[3].x = (short)(x + w2);
	c1[3].y = (short)(y + h32);
	c1[4].x = c1[0].x;
	c1[4].y = c1[0].y;	            

	c2[0].x = (short)(x);
	c2[0].y = (short)(y+h2);
	c2[1].x = (short)(x + w2);
	c2[1].y = (short)(y + h);
	c2[2].x = (short)(x + w2);
	c2[2].y = (short)(y);
	c2[3].x = c2[0].x;
	c2[3].y = c2[0].y;

	XFillPolygon(EZ_Display, drawable,gc,
		     c1, 4, Convex, CoordModeOrigin);
	XFillPolygon(EZ_Display, drawable,gc,
		     c2, 3, Convex, CoordModeOrigin);
	XDrawLines(EZ_Display, drawable,gc,
		   c1, 5, CoordModeOrigin);
	XDrawLines(EZ_Display, drawable,gc,
		   c2, 4, CoordModeOrigin);
    
      }
    break;
    case EZ_RIGHT_ARROW:
      {
	int w2 = (w>>1);
	int h3 = (h/3);
	int h32 = h - h3;
	int h2 = h >> 1;

	c1[0].x = (short)(x);
	c1[0].y = (short)(y + h3);
	c1[1].x = (short)(x);
	c1[1].y = (short)(y + h32);
	c1[2].x = (short)(x + w2);
	c1[2].y = (short)(y + h32);
	c1[3].x = (short)(x + w2);
	c1[3].y = (short)(y + h3);
	c1[4].x = c1[0].x;
	c1[4].y = c1[0].y;	      
      
	c2[0].x = (short)(x + w2);
	c2[0].y = (short)(y);
	c2[1].x = (short)(x + w);
	c2[1].y = (short)(y + h2);
	c2[2].x = (short)(x + w2);
	c2[2].y = (short)(y + h);
	c2[3].x = c2[0].x;
	c2[3].y = c2[0].y;


	XFillPolygon(EZ_Display, drawable,gc,
		     c1, 4, Convex, CoordModeOrigin);
	XFillPolygon(EZ_Display, drawable,gc,
		     c2, 3, Convex, CoordModeOrigin);
	XDrawLines(EZ_Display, drawable,gc,
		   c1, 5, CoordModeOrigin);
	XDrawLines(EZ_Display, drawable,gc,
		   c2, 4, CoordModeOrigin);
      }
    break;
    case EZ_UP_ARROW_BAR:
      {
	int h8 = (h>>3) + 1;
	int hh = h - h8 - 1 ;
	
	EZ_DrawSpecial(widget,drawable, gc, EZ_UP_ARROW, x,y+h8+1, w, hh); 

	c1[0].x = (short)(x);
	c1[0].y = (short)(y);
	c1[1].x = (short)(x);
	c1[1].y = (short)(y + h8);
	c1[2].x = (short)(x + w);
	c1[2].y = (short)(y + h8);
	c1[3].x = (short)(x + w);
	c1[3].y = (short)(y);

	XFillPolygon(EZ_Display, drawable,gc,
		     c1, 4, Convex, CoordModeOrigin);
	XDrawLines(EZ_Display, drawable,gc,
		   c1, 4, CoordModeOrigin);

      }
    break;
    case EZ_DOWN_ARROW_BAR:
      {
	int h8 = (h>>3) + 1;
	int hh = h - h8 - 1;

	EZ_DrawSpecial(widget,drawable, gc, EZ_DOWN_ARROW, x,y, w, hh);

	c1[0].x = (short)(x);
	c1[0].y = (short)(y+h);
	c1[1].x = (short)(x+w);
	c1[1].y = (short)(y + h);
	c1[2].x = (short)(x + w);
	c1[2].y = (short)(y + h - h8);
	c1[3].x = (short)(x );
	c1[3].y = (short)(y + h -h8);

	XFillPolygon(EZ_Display, drawable,gc,
		     c1, 4, Convex, CoordModeOrigin);
	XDrawLines(EZ_Display, drawable,gc,
		   c1, 4, CoordModeOrigin);
      }
    break;
    case EZ_DOWN_TRIANGLE_BAR:
      {
	/* thanks to Tomi Sarvela <orava@nether.tky.hut.fi> */
	int h8 = (h>>3) + 1;
	int hh = h - h8 - 1;
	
	EZ_DrawSpecial(widget,drawable, gc, EZ_DOWN_TRIANGLE, x,y, w, hh);
	
	c1[0].x = (short)(x);
	c1[0].y = (short)(y+h);
	c1[1].x = (short)(x+w);
	c1[1].y = (short)(y + h);
	c1[2].x = (short)(x + w);
	c1[2].y = (short)(y + h - h8);
	c1[3].x = (short)(x);
	c1[3].y = (short)(y + h - h8);
	
	XFillPolygon(EZ_Display, drawable,gc,
		     c1, 4, Convex, CoordModeOrigin);
	XDrawLines(EZ_Display, drawable,gc,
		   c1, 4, CoordModeOrigin);
      }
      break;
    default:
      break;
    }
}

/***************************************************************************/
#undef _EZ_DRAW_SPECIAL_C_
