/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             COPYRIGHT (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 *  May 1997. Handling of raw rgb images added by Arno Dabekaussen.
 */
/*****************************************************************
 *
 *  Widget Header File
 *
 */
#ifndef _EZ_WIDGET_H_
#define	_EZ_WIDGET_H_

#include <X11/Xlib.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <strings.h>

#include "EZ_Args.h"    

/***********************************************************************/
typedef union EZ_WWindow_   EZ_Widget;
typedef union EZ_ItemUnion  EZ_Item;
typedef  void (*EZ_CallBack)      MY_ANSIARGS((void *object, void *data));
typedef  void (*EZ_Callback)      MY_ANSIARGS((void *object, void *data));
typedef  void (*EZ_InputCallback) MY_ANSIARGS((void *object, void *data, int fd, int mask));
typedef  void (*EZ_InputCallBack) MY_ANSIARGS((void *object, void *data, int fd, int mask));
typedef  void (*EZ_EventHandler)  MY_ANSIARGS((void *object, void *data, 
					       int etype, XEvent *event));

typedef  int  (*EZ_DnDEncoder)    MY_ANSIARGS((void *object, void *data, 
					       char **message,int *length, int *needfree));
typedef  int  (*EZ_DnDDecoder)    MY_ANSIARGS((void *object, void *data,
					       char *message,int length));

typedef  void (*EZ_WorkAreaGeometryManager)  MY_ANSIARGS((void *GMData, EZ_Item **data, int nitems, 
							  int Rx,int Ry,int Rw, int Rh, int xsp, int ysp,
							  int *w_ret, int *h_ret));

/***********************************************************************
 ***                                                                 ***
 *** The data structure of another simple hash table. Used to store  ***
 *** bitmaps                                                         ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_Bitmap_ {
  Pixmap pixmap;                   /* the stored pixmap */
  Pixmap shape;                    /* shape mask        */
  char   *name;                    /* the file_name     */
  int    width, height;            /* size of the pixmap*/
  int    ref;                      /* reference count   */
  int    bucket;                   /* saved in bucket   */
  char   type;                     /* depth = 1 or > 1  */
  char   special;                  /* special ref mark  */
  char   notused[2];
  int    x, y;                     /* special fields    */
  struct EZ_Bitmap_ *next;         /* the chain         */
} EZ_Bitmap;

typedef  EZ_Bitmap  EZ_BitmapHTEntry;
typedef  EZ_Bitmap  EZ_Pixmap;

#define EZ_BITMAP_IS_BITMAP       0
#define EZ_BITMAP_IS_PIXMAP       1

#define EZ_BitmapType(ptr)        ((ptr)->type)
#define EZ_BitmapPixmap(ptr)      ((ptr)->pixmap)
#define EZ_BitmapWidth(ptr)       ((ptr)->width)
#define EZ_BitmapHeight(ptr)      ((ptr)->height)
#define EZ_BitmapRefCount(ptr)    ((ptr)->ref)
#define EZ_BitmapName(ptr)        ((ptr)->name)
#define EZ_BitmapNext(ptr)        ((ptr)->next)
#define EZ_BitmapSpecial(ptr)     ((ptr)->special)

/******************************************************************************************************/

typedef struct EZ_CallBackStruct_ 
{
  EZ_CallBack               callback;
  void                      *data;
  int                       internal;
  struct EZ_CallBackStruct_ *next;
} EZ_CallBackStruct;
/************************************************************************/
typedef struct EZ_EventHandlerStruct_ 
{
  EZ_EventHandler               handler;
  void                          *data;
  int                           internal;
  struct EZ_EventHandlerStruct_ *next;
} EZ_EventHandlerStruct;
/************************************************************************/
typedef  int  (*EZ_DnDMsgHandler) MY_ANSIARGS((void *object, void *message));

/************************************************************************/
#include "EZ_GL.h"
#include "EZ_Timer.h"
#include "EZ_Input.h"
#include "EZ_EmbedMsg.h"
#include "EZ_MemDebug.h"
#include "EZ_WidgetConfig.h"
#include "EZ_DnD.h"
#include "EZ_Item.h"

#ifndef MAXV
#define MAXV(a,b) ((a)>(b)? (a):(b))
#endif
#ifndef MINV
#define MINV(a,b) ((a)<(b)? (a):(b))
#endif
#ifndef ABSV
#define ABSV(a) ((a)>=0? (a): -(a))
#endif
#define EZ_RingBell()   XBell(EZ_Display, 30)
/**************************************************************************/

#define EZ_EXIT_OK           0
#define EZ_EXIT_ERROR        1
#define EZ_NO                0
#define EZ_YES               1
#define EZ_NULL              NULL
#define EZ_TRUE              True
#define EZ_FALSE             False

/***********************************************************************
 ***                                                                 ***
 ***                   Border Styles                                 ***
 ***                                                                 ***
 ***********************************************************************/

#define EZ_BORDER_NONE                  0
#define EZ_BORDER_FLAT                  1
#define EZ_BORDER_FRAMED_UP             2
#define EZ_BORDER_FRAMED_DOWN           3
#define EZ_BORDER_UP                    4
#define EZ_BORDER_DOWN                  5
#define EZ_BORDER_NB_UP                 6
#define EZ_BORDER_NB_DOWN               7

#define EZ_BORDER_STYLE_BEGIN           EZ_BORDER_NONE
#define EZ_BORDER_STYLE_END             EZ_BORDER_NB_DOWN

/***********************************************************************
 ***                                                                 ***
 ***                   GRID BAG CONSTRAINS                           ***
 ***                                                                 ***
 ***********************************************************************/

#define EZ_ROW          1
#define EZ_COLUMN       2

#define EZ_ON           1
#define EZ_OFF          0

/***********************************************************************
***                                                                 ***
***                   Indicator Types                               ***
***                                                                 ***
***********************************************************************/
#define EZ_EMPTY_INDICATOR          0
#define EZ_SQUARE_INDICATOR         1
#define EZ_SUNKEN_SQUARE_INDICATOR  2
#define EZ_DIAMOND_INDICATOR        3
#define EZ_SUNKEN_DIAMOND_INDICATOR 4
#define EZ_CIRCLE_INDICATOR         5
#define EZ_CHECK_INDICATOR          6
#define EZ_RECTANGLE_INDICATOR      7

/***********************************************************************
***                                                                 ***
***                   Internal Fonts                                ***
***                                                                 ***
***********************************************************************/

#define EZ_DEFAULT_FONT                 0
#define EZ_NORMAL_FONT                  1
#define EZ_THIN_FONT                    2 
#define EZ_BOLD_FONT                    3 
#define EZ_ITALIC_FONT                  4

#define EZ_BUTTON_FONT                  EZ_BOLD_FONT
#define EZ_LABEL_FONT                   EZ_BOLD_FONT
#define EZ_SLIDER_FONT                  EZ_BOLD_FONT
#define EZ_MENU_FONT                    EZ_BOLD_FONT
#define EZ_INPUT_FONT                   EZ_THIN_FONT
#define EZ_TEXT_FONT                    EZ_THIN_FONT
#define EZ_MENU_TITLE_FONT              EZ_ITALIC_FONT

/***********************************************************************
***                                                                 ***
***                   Default GCs                                   ***
 ***                                                                 ***
 ***********************************************************************/
#define TOTAL_NUM_GCS  DARKRED+16

#define EZ_DEFAULTGC                   (DefaultGC(EZ_Display,EZ_ScreenNum))

#define EZ_BLACKGC                     (EZ_GCList[BLACK])
#define EZ_WHITEGC                     (EZ_GCList[WHITE])
#define EZ_DARKGC1                     (EZ_GCList[EZ_DARK_GRAY1])
#define EZ_DARKGC2                     (EZ_GCList[EZ_DARK_GRAY2])
#define EZ_NORMALGC1                   (EZ_GCList[EZ_NORMAL_GRAY1])
#define EZ_NORMALGC2                   (EZ_GCList[EZ_NORMAL_GRAY2])
#define EZ_BRIGHTGC1                   (EZ_GCList[EZ_BRIGHT_GRAY1])
#define EZ_BRIGHTGC2                   (EZ_GCList[EZ_BRIGHT_GRAY2])
#define EZ_GRAY3GC                     (EZ_GCList[EZ_GRAY])
#define EZ_DARKREDGC                   (EZ_GCList[DARKRED])
#define EZ_NORMAL_TEXTGC               (EZ_GCList[DARKRED+1])
#define EZ_THIN_TEXTGC                 (EZ_GCList[DARKRED+2])
#define EZ_BOLD_TEXTGC                 (EZ_GCList[DARKRED+3])
#define EZ_ITALIC_TEXTGC               (EZ_GCList[DARKRED+4])

#define EZ_BD_DARKGC                   (EZ_GCList[DARKRED+6])
#define EZ_BD_BRIGHTGC                 (EZ_GCList[DARKRED+7])
#define EZ_BD_NORMALGC                 (EZ_GCList[DARKRED+8])

#define EZ_BUTTON_TEXTGC               EZ_BOLD_TEXTGC
#define EZ_LABEL_TEXTGC                EZ_BOLD_TEXTGC
#define EZ_MENU_TEXTGC                 EZ_BOLD_TEXTGC
#define EZ_INPUT_TEXTGC                EZ_THIN_TEXTGC
#define EZ_TEXT_TEXTGC                 EZ_THIN_TEXTGC

#define EZ_WRITABLEGC                  (EZ_GCList[DARKRED+5])
#define EZ_XORGC                       (EZ_GCList[DARKRED+9])
#define EZ_TILEGC                      (EZ_GCList[DARKRED+10])
#define EZ_STIPPLEGC                   (EZ_GCList[DARKRED+11])
#define EZ_DASHEDLINEGC                (EZ_GCList[DARKRED+12])
#define EZ_DNDXORGC                    (EZ_GCList[DARKRED+13])
#define EZ_DNDXORGCB                   (EZ_GCList[DARKRED+14])
#define EZ_WRITABLEGC2                 (EZ_GCList[DARKRED+15])
/***********************************************************************
 ***                                                                 ***
 ***                   Generic Event Mask                            ***
 ***                                                                 ***
 ***********************************************************************/

#define ALL_EVENTS_MASK  KeyPressMask|ButtonReleaseMask|ExposureMask|\
                    ButtonPressMask|StructureNotifyMask|ButtonMotionMask|\
                    EnterWindowMask|LeaveWindowMask|PointerMotionMask|\
                    KeymapStateMask|FocusChangeMask

#define ALL_EVENT_MASK  ALL_EVENTS_MASK

/***********************************************************************
 ***                                                                 ***
 ***                   Default Foreground                            ***
 ***                                                                 ***
 ***********************************************************************/

#define EZ_DEFAULT_FOREGROUND  (EZ_ColorArray[BLACK])


/***********************************************************************
 ***                                                                 ***
 ***                   Special labels                                ***
 ***                                                                 ***
 ***********************************************************************/

#define EZ_UP_TRIANGLE       1
#define EZ_DOWN_TRIANGLE     2
#define EZ_LEFT_TRIANGLE     3
#define EZ_RIGHT_TRIANGLE    4
#define EZ_UP_ARROW          5
#define EZ_DOWN_ARROW        6
#define EZ_LEFT_ARROW        7
#define EZ_RIGHT_ARROW       8
#define EZ_UP_ARROW_BAR      9
#define EZ_DOWN_ARROW_BAR    10
#define EZ_DOWN_TRIANGLE_BAR 11 /* thanks to Tomi Sarvela <orava@nether.tky.hut.fi> */

/***********************************************************************
 ***                                                                 ***
 ***                   Widget Types                                  ***
 ***                                                                 ***
 ***********************************************************************/

/* if reordered, make sure the names below is also reordered correspondingly */
#define EZ_WIDGET_UNKNOWN                0
#define EZ_WIDGET_FRAME                  1
#define EZ_WIDGET_LABEL                  2
#define EZ_WIDGET_NORMAL_BUTTON          3
#define EZ_WIDGET_CHECK_BUTTON           4
#define EZ_WIDGET_RADIO_BUTTON           5
#define EZ_WIDGET_MENU_BUTTON            6
#define EZ_WIDGET_MENU_SEPARATOR         7
#define EZ_WIDGET_MENU_SUBMENU           8
#define EZ_WIDGET_MENU_NORMAL_BUTTON     9
#define EZ_WIDGET_MENU_CHECK_BUTTON      10
#define EZ_WIDGET_MENU_RADIO_BUTTON      11
#define EZ_WIDGET_VERTICAL_SLIDER        12
#define EZ_WIDGET_HORIZONTAL_SLIDER      13
#define EZ_VERTICAL_SLIDER               EZ_WIDGET_VERTICAL_SLIDER
#define EZ_HORIZONTAL_SLIDER             EZ_WIDGET_HORIZONTAL_SLIDER
#define EZ_WIDGET_ENTRY                  14
#define EZ_WIDGET_3D_CANVAS              15
#define EZ_WIDGET_VERTICAL_SCROLLBAR     16
#define EZ_WIDGET_HORIZONTAL_SCROLLBAR   17
#define EZ_WIDGET_ILIST_BOX              18
#define EZ_WIDGET_LIST_BOX               19
#define EZ_WIDGET_ITEXT                  20
#define EZ_WIDGET_TEXT                   21
#define EZ_WIDGET_NOTE_BOOK              22
#define EZ_WIDGET_NB_PAGE                23
#define EZ_WIDGET_NW_LABEL               24
#define EZ_WIDGET_PANE_HANDLE            25
#define EZ_WIDGET_SPECIAL                26
#define EZ_WIDGET_EXECUTOR               27
#define EZ_WIDGET_OPTIONAL_ENTRY         28
#define EZ_WIDGET_FILE_SELECTOR          29
#define EZ_WIDGET_ITREE                  30
#define EZ_WIDGET_TREE                   31
#define EZ_WIDGET_LIST_TREE              EZ_WIDGET_TREE
#define EZ_WIDGET_IFANCY_LIST_BOX        32
#define EZ_WIDGET_FANCY_LIST_BOX         33
#define EZ_WIDGET_IWORK_AREA             34
#define EZ_WIDGET_WORK_AREA              35
#define EZ_WIDGET_RAW_XWINDOW            36
#define EZ_WIDGET_MENU_TEAR_OFF_BAR      37
#define EZ_WIDGET_ROW_COLUMN             38
#define EZ_WIDGET_GRID_BAG               EZ_WIDGET_ROW_COLUMN

#define EZ_WIDGET_F39                    39
#define EZ_WIDGET_F40                    40
#define EZ_WIDGET_F41                    41
#define EZ_WIDGET_F42                    42
#define EZ_WIDGET_F43                    43
#define EZ_WIDGET_F44                    44
#define EZ_WIDGET_F45                    45
#define EZ_WIDGET_F46                    46
#define EZ_WIDGET_F47                    47
#define EZ_WIDGET_F48                    48
#define EZ_WIDGET_F49                    49
#define EZ_WIDGET_F50                    50
#define EZ_WIDGET_F51                    51
#define EZ_WIDGET_F52                    52
#define EZ_WIDGET_F53                    53
#define EZ_WIDGET_F54                    54
#define EZ_WIDGET_F55                    55
#define EZ_WIDGET_F56                    56
#define EZ_WIDGET_F57                    57
#define EZ_WIDGET_F58                    58
#define EZ_WIDGET_F59                    59
#define EZ_WIDGET_F60                    60
#define EZ_WIDGET_F61                    61
#define EZ_WIDGET_F62                    62
#define EZ_WIDGET_F63                    63
#define EZ_WIDGET_F64                    64
#define EZ_WIDGET_F65                    65
#define EZ_WIDGET_F66                    66
#define EZ_WIDGET_F67                    67
#define EZ_WIDGET_F68                    68
#define EZ_WIDGET_F69                    69
#define EZ_WIDGET_F70                    70
#define EZ_WIDGET_F71                    71
#define EZ_WIDGET_F72                    72
#define EZ_WIDGET_F73                    73
#define EZ_WIDGET_F74                    74
#define EZ_WIDGET_F75                    75
#define EZ_WIDGET_F76                    76
#define EZ_WIDGET_F77                    77
#define EZ_WIDGET_F78                    78
#define EZ_WIDGET_F79                    79
#define EZ_WIDGET_F80                    80
#define EZ_WIDGET_F81                    81
#define EZ_WIDGET_F82                    82
#define EZ_WIDGET_F83                    83
#define EZ_WIDGET_F84                    84
#define EZ_WIDGET_F85                    85
#define EZ_WIDGET_F86                    86
#define EZ_WIDGET_F87                    87
#define EZ_WIDGET_F88                    88
#define EZ_WIDGET_F89                    89
#define EZ_WIDGET_F90                    90
#define EZ_WIDGET_F91                    91
#define EZ_WIDGET_F92                    92
#define EZ_WIDGET_F93                    93
#define EZ_WIDGET_F94                    94
#define EZ_WIDGET_F95                    95
#define EZ_WIDGET_F96                    96
#define EZ_WIDGET_F97                    97
#define EZ_WIDGET_F98                    98
#define EZ_WIDGET_F99                    99
#define EZ_WIDGET_F100                    100
#define EZ_WIDGET_F101                    101
#define EZ_WIDGET_F102                    102
#define EZ_WIDGET_F103                    103
#define EZ_WIDGET_F104                    104
#define EZ_WIDGET_F105                    105
#define EZ_WIDGET_F106                    106
#define EZ_WIDGET_F107                    107
#define EZ_WIDGET_F108                    108
#define EZ_WIDGET_F109                    109
#define EZ_WIDGET_F110                    110
#define EZ_WIDGET_F111                    111
#define EZ_WIDGET_F112                    112
#define EZ_WIDGET_F113                    113
#define EZ_WIDGET_F114                    114
#define EZ_WIDGET_F115                    115
#define EZ_WIDGET_F116                    116
#define EZ_WIDGET_F117                    117
#define EZ_WIDGET_F118                    118
#define EZ_WIDGET_F119                    119
#define EZ_WIDGET_F120                    120
#define EZ_WIDGET_F121                    121
#define EZ_WIDGET_F122                    122
#define EZ_WIDGET_F123                    123
#define EZ_WIDGET_F124                    124
/* 
 * the following few have to be the last and
 * has to be in the given order. They are
 * special toplevel widgets. In the case 
 * when this lib grows to more than 128 widgets,
 * change the type field to unsigned char or int
 * this field is used only to identify widgets,
 * not used in arithmetic so should be ok.
 */
#define EZ_WIDGET_POPUP_MENU              125
#define EZ_WIDGET_MENU                    EZ_WIDGET_POPUP_MENU
#define EZ_WIDGET_ITOPLEVEL               126
#define EZ_WIDGET_ICON                    EZ_WIDGET_ITOPLEVEL           
#define EZ_WIDGET_FREE_LABEL              EZ_WIDGET_ITOPLEVEL           
#define EZ_WIDGET_EMBEDER                 127
#define EZ_TOTAL_NUMBER_OF_WIDGETS        128

#ifdef _EZ_WIDGET_CONFIGURE_C_
/*****************************************************************
 *
 *  Widget Names. if reordered, make sure the types above is also
 *  reordered. 
 */
static char *EZ_WidgetNames[] =
{
  "Unknown",
  "Frame",
  "Label",
  "Button", 
  "CheckButton",
  "RadioButton",  
  "MenuButton",
  "MenuSeparator",
  "SubMenu",
  "Menu:Button",
  "Menu:CheckButton", 
  "Menu:RadioButton",
  "VerticalSlider",
  "HorizontalSlider",
  "Entry",
  "3DCanvas",
  "VerticalScrollbar",
  "HorizontalScrollbar",
  "I ListBox",
  "ListBox",
  "I Text",
  "Text",
  "NoteBook",
  "NoteBookPage",
  "NWLabel/NWFrame",
  "PaneHandle",
  "SpecialWidget",
  "Executor",
  "OptionalEntry",
  "FileSelector",
  "ITree",
  "Tree",
  "IFancyListBox",
  "FancyListBox",
  "IWorkArea",
  "WorkArea",
  "RawXWindow",
  "TearOffMenu",
  "RowColumn",

  "F39",
  "F40",
  "F41",
  "F42",
  "F43",
  "F44",
  "F45",
  "F46",
  "F47",
  "F48",
  "F49",
  "F50",
  "F51",
  "F52",
  "F53",
  "F54",
  "F55",
  "F56",
  "F57",
  "F58",
  "F59",
  "F60",
  "F61",
  "F62",
  "F63",
  "F64",
  "F65",
  "F66",
  "F67",
  "F68",
  "F69",
  "F70",
  "F71",
  "F72",
  "F73",
  "F74",
  "F75",
  "F76",
  "F77",
  "F78",
  "F79",
  "F80",
  "F81",
  "F82",
  "F83",
  "F84",
  "F85",
  "F86",
  "F87",
  "F88",
  "F89",
  "F90",
  "F91",
  "F92",
  "F93",
  "F94",
  "F95",
  "F96",
  "F97",
  "F98",
  "F99",
  "F100",
  "F101",
  "F102",
  "F103",
  "F104",
  "F105",
  "F106",
  "F107",
  "F108",
  "F109",
  "F110",
  "F111",
  "F112",
  "F113",
  "F114",
  "F115",
  "F116",
  "F117",
  "F118",
  "F119",
  "F120",
  "F121",
  "F122",
  "F123",
  "F124",

  "PopupMenu",
  "Icon/FreeLabel",
  "Embeder",

  NULL,
};
#endif
/***********************************************************************
 ***                                                                 ***
 ***                   DoubleClick time interval                     ***
 ***                                                                 ***
 ***********************************************************************/
/*
 * it two Button1 click happened within 250 ms, it is regardes as a
 * double click. Used in widget listbox.
 */
#define DOUBLE_CLICK_TIME_INTERVAL        300

/***********************************************************************
 ***                                                                 ***
 ***                   Label line length                             ***
 ***                                                                 ***
 ***********************************************************************/

#define EZ_DEFAULT_LABEL_LINE_LENGTH   30
#define IS_END_OF_WORD(c) ( (c)==' ' || (c) == '\t' || (c) ==',' )
#define EZ_LABEL_SEPARATION  16

/***********************************************************************
 ***                                                                 ***
 ***                   Widget Arrangements                           ***
 ***                                                                 ***
 ***********************************************************************/
/*
 *  Policy to place children widget. (Stacking)
 */
#define EZ_HORIZONTAL              1         /* stack children horizontally, evenly spaced in parent' win */
#define EZ_HORIZONTAL_LEFT         2         /* stack children horizontally, start at the left boundary   */
#define EZ_HORIZONTAL_RIGHT        3         /* stack children horizontally, finish at the right bdy      */
#define EZ_HORIZONTAL_CENTER       4         /* stack children horizontally at the center of parent's win */

#define EZ_VERTICAL                5         /* stack children vertically, evenly spaced in parent's win  */
#define EZ_VERTICAL_TOP            6         /* stack children vertically, start at the top boundary      */
#define EZ_VERTICAL_BOTTOM         7         /* stack children vertically, finish at the bottom bdy       */
#define EZ_VERTICAL_CENTER         8         /* stack children vertically at the center of parent's win   */ 


#define EZ_WIDGET_STACKING_BEGIN   EZ_HORIZONTAL
#define EZ_WIDGET_STACKING_END     EZ_VERTICAL_CENTER

/*
 * Policy to place children widget. (Filling)
 * 
 * If the children widget are stacked vertically,
 * one can fill all its children widgets horizontally.
 * There are three different horizontal filling modes:
 *  + Do not fill (default)
 *  + Fill horizontally
 *  + Fill vertically
 *  + Fill both horizontally and vertically
 *
 * The situation is similar for vertically stacked widgets.
 *
 */
#define EZ_FILL_NONE               0
#define EZ_FILL_HORIZONTALLY       1
#define EZ_FILL_VERTICALLY         2
#define EZ_FILL_BOTH               3

#define EZ_WIDGET_FILL_BEGIN       EZ_FILL_NONE
#define EZ_WIDGET_FILL_END         EZ_FILL_BOTH
/*
 *  Policy to place children widget. (Alignment)
 *
 *  If children are stacked horizontally, one can
 *  align the children either against the top boundary
 *  or against the bottom boundary or against the
 *  horizontal center line (default).
 *
 *  If children widget are stacked vertically, one
 *  can align the children widget either against the
 *  left boundary or against the right boundary or
 *  against the vertical center line (default).
 *
 */               
#define EZ_CENTER_ALIGNED          0        /* align children widgets against the center (V or H) line      */

#define EZ_LEFT_ALIGNED            1        /* align children widgets agianst the left bdy of parent's win  */
#define EZ_RIGHT_ALIGNED           2        /* align children widgets agianst the right bdy of parent's win */

#define EZ_TOP_ALIGNED             3        /* align children widgets agianst the top bdy of parent's win   */
#define EZ_BOTTOM_ALIGNED          4        /* align children widgets agianst the bottom bdy of parent's win*/

#define EZ_WIDGET_SIDE_BEGIN       EZ_CENTER_ALIGNED
#define EZ_WIDGET_SIDE_END         EZ_BOTTOM_ALIGNED

/*
 * Policy to place LABEL on terminal widgets (buttons, sliders etc)
 */
#define EZ_CENTER                  0
#define EZ_LEFT                    1
#define EZ_RIGHT                   2
#define EZ_TOP                     3
#define EZ_BOTTOM                  4
#define EZ_TOP_LEFT                5
#define EZ_TOP_RIGHT               6
#define EZ_BOTTOM_LEFT             7
#define EZ_BOTTOM_RIGHT            8
#define EZ_LEFT_2_RIGHT            9

#define EZ_WIDGET_LABEL_POSITION_BEGIN    EZ_CENTER
#define EZ_WIDGET_LABEL_POSITION_END      EZ_LEFT_2_RIGHT

/***********************************************************************
 ***                                                                 ***
 ***                   Default Padding                               ***
 ***                                                                 ***
 ***********************************************************************/

#define EZ_WIDGET_DEFAULT_PADX                8
#define EZ_WIDGET_DEFAULT_PADY                6

/****************************************************************************
 *
 *  This structure records some of the important information about
 *  the display.
 */
typedef struct {
  Display           *TheDisplay;     /* the display connected    */
  int               TheScreenNum;    /* the screen number        */
  Visual            *TheVisual;      /* the visual               */
  Window            dummyWindow;     /* for creating gc's        */
  int               TheDepth;        /* bpp, 8, 16 or 24         */

  char              UsePrivateCmap;  /* use a private cmp if !=0 */
  char              WidgetOnly;      /* do not be greedy on clrs */
  char              BackingStore;    /* server support b store ? */
  char              hasSHMExt;       /* server has SHM extension */
  char              hasSHAPEExt;     /* server has Shape ext.    */
  char              ByteOrder;       /* byte order in ximages    */
  char              HByteOrder;      /* host byte order          */
  char              bgset;           /* bg color set by usr ?    */

  int               NColors;         /* # of colors allocated    */
  int               FreeColorStart;  /* indx of next unused clr  */
  int               AvailableColorsForGL; /* num clrs for GL     */
  int               HDimension;      /* hori size of display     */
  int               VDimension;      /* veri size of display     */
  int               spad;
  
  unsigned long     ColorArray[COLOR_TAB_SIZE]; /* pixel values  */
  XColor            xcolors[COLOR_TAB_SIZE];    /* rgb values    */
  XColor            dark[COLOR_TAB_SIZE];       /* for widget bd */
  XColor            bright[COLOR_TAB_SIZE];     /* for widget bd */
  XColor            highlight[COLOR_TAB_SIZE];  /* and highlight */
  Colormap          TheColormap;     /* the colormap             */
  Atom EZWGL_APPLICATION; /* two private atoms for communication */
  Atom EZWGL_EMBEDING_MSG;
  Atom EZWGL_WLIST;
  Atom EZWGL_WM_DELETE_WINDOW;    /* WM protocol */
  Atom EZWGL_WM_PROTOCOLS;
  long              max_req_size;
} XSInfo;

#define EZ_Display            (XServerInfo.TheDisplay)
#define EZ_ScreenNum          (XServerInfo.TheScreenNum)
#define EZ_Visual             (XServerInfo.TheVisual)
#define EZ_DummyWindow        (XServerInfo.dummyWindow)
#define EZ_Depth              (XServerInfo.TheDepth)
#define EZ_ColorArray         (XServerInfo.ColorArray)
#define EZ_ColorArrayFix      (_ColorArrayForImage_)
#define EZ_Colormap           (XServerInfo.TheColormap)
#define EZ_UsePrivateColormap (XServerInfo.UsePrivateCmap)
#define EZ_TotalNumOfColors   (XServerInfo.NColors)
#define EZ_UnusedColorIdx     (XServerInfo.FreeColorStart)
#define EZ_XColorArray        (XServerInfo.xcolors)
#define EZ_WidgetOnly         (XServerInfo.WidgetOnly)
#define EZ_UseBackingStore    (XServerInfo.BackingStore)
#define EZ_AvailableColors    (XServerInfo.AvailableColorsForGL)
#define EZ_XServerHasSHMExt   (XServerInfo.hasSHMExt)
#define EZ_XServerHasSHAPEExt (XServerInfo.hasSHAPEExt)
#define EZ_XImageByteOrder    (XServerInfo.ByteOrder)
#define EZ_HostByteOrder      (XServerInfo.HByteOrder)
#define EZ_BgSet              (XServerInfo.bgset)

#define EZ_XDisplayWidth      (XServerInfo.HDimension)
#define EZ_XDisplayHeight     (XServerInfo.VDimension)

#define EZ_DarkColor          (XServerInfo.dark)
#define EZ_BrightColor        (XServerInfo.bright)
#define EZ_HighlightColor     (XServerInfo.highlight)

#define EZ_DisplayForWidgets         EZ_Display
#define EZ_ScreenNumForWidgets       EZ_ScreenNum
#define EZ_VisualForWidgets          EZ_Visual
#define EZ_DepthForWidgets           EZ_Depth
#define EZ_ColorArrayForWidgets      EZ_ColorArray
#define EZ_ColormapForWidgets        EZ_Colormap

#define EZ_XServerDataReqSize         (XServerInfo.max_req_size)
#define EZ_APPLICATION_ATOM           (XServerInfo.EZWGL_APPLICATION)
#define EZ_WLIST_ATOM                 (XServerInfo.EZWGL_WLIST)
#define EZ_EMBEDING_MESSAGE_ATOM      (XServerInfo.EZWGL_EMBEDING_MSG)
#define EZ_WM_DELETE_WINDOW_ATOM      (XServerInfo.EZWGL_WM_DELETE_WINDOW)
#define EZ_WM_PROTOCOLS_ATOM          (XServerInfo.EZWGL_WM_PROTOCOLS)

/***********************************************************************/
#define EZ_GrabServer() { \
    if( EZ_ServerGrabed == 0) XGrabServer(EZ_Display);\
     EZ_ServerGrabed++; \
}

#define EZ_UngrabServer() { \
    if( EZ_ServerGrabed == 1) XUngrabServer(EZ_Display);\
    EZ_ServerGrabed--; \
    if( EZ_ServerGrabed < 0) EZ_ServerGrabed = 0;\
}

/***********************************************************************
 ***                                                                 ***
 ***                   HashTableSize                                 ***
 ***                                                                 ***
 ***********************************************************************/

#define EZ_WIDGET_HASH_TABLE_SIZE           499
#define EZ_SMALL_HASH_TABLE_SIZE            41

/***********************************************************************
 ***                                                                 ***
 ***               Common parts of all Widgets                       ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_WidgetCommon_ {
  int               x,y;              /* origin in its parent    */
  int               w,h;              /* actual dimension        */
  Window            win;              /* the window ID           */
  union EZ_WWindow_ *parent;          /* the parent widget       */
  union EZ_WWindow_ *sibling;         /* the sibling list        */
  union EZ_WWindow_ *children;        /* list of children        */

  /* these three fields are used for embeding */
  Window            DnDName;          /* embeding comm win       */
  Window            DnDParent;        /* embeding  parent win    */
  int               aminW, aminH;     /* computed min size       */

  EZ_Bitmap         *pixmap;          /* bitmap label            */
  unsigned long     foreground;       /* foreground color        */
  unsigned long     background;       /* background color        */
  unsigned long     *parentbg;        /* parent background color */
  XFontStruct       *font;            /* default font            */ 
  char              *bubble_string;   /* bubble help string      */

  int               flags;            /* various flags           */

  char              type;             /* widget type             */
  char              borderstyle;      /* style of border         */
  char              stacking;         /* horizontal or vertical  */
  char              alignment;        /* against left bdy or ... */
  char              fillmode;         /* fill mode               */
  char              labelposition;    /* anchor pos for label    */
  char              justification;    /* label justification     */
  char              maped;            /* true or false           */

  int               minW;             /* minimal dimension       */
  int               minH;             /* may be modified by fill */

  int               cW;
  int               cH;

  int               aW;               /* assigned width by parent*/
  int               aH;               /* assigned height         */

  int               whint;            /* user prefered width     */
  int               hhint;            /* user prefered height    */

  int               padx;             /* hori size  adjustment   */
  int               pady;             /* vertical suzeadjustment */
  int               padb;             /* h v padding outside bdr */

  int               sepx;             /* internal dist between   */
  int               sepy;             /* widgets on the same win */

  /*
   * the following 4 fields are very special. They are used only
   * in Frame, CheckButton and RadioButton widgets. The reason
   * for them to be here is to simplify the coding for the
   * geometry manager.
   */
  int               yaux;             /* special y padding Top & Bottom. For labeled frame  */
  int               hAdjust;          /* special height adjust. label height in Labled frame  */
  int               xauxL;            /* special x padding, left */
  int               xauxR;            /* special xpad, right     */

  int               numchildren;      /* number of children      */
  int               borderwidth;      /* width of border         */
  
  int               IntData;          /* extra space for usrdata */
  void              *PtrData;         /* extra space for usrdata */
  int               RetData;          /* extra space for data: menu (items) return value */

  EZ_EventHandlerStruct *eventHandler;     /* user-defined event handler */
  EZ_CallBackStruct     *callbacks;        /* array of callbacks      */
  EZ_CallBackStruct     *motionCallbacks;  /* not available to all widgets */
  EZ_CallBackStruct     *destroyCallbacks; /* callback on destruction */

  /* for Drag and Drop */
  Cursor            DnDDragCursor;         /* cursor to use if it is a drag src */
  void              *DnDtmp;               /* tmp storage for DnD  */
  EZ_DnDMsgHandler  DnDHandler;            /* Internal Msg handler: used only in 3 widgets */
  EZ_DnDDataEncoder *DnDDataEncoders;      /* list of data converters, encoding */
  EZ_DnDDataDecoder *DnDDataDecoders;      /* list of data converters, deoding */
  char              *DnDTargetHelp;        /* help info for DnDTargets  */

  /* for the gridbag geometry manager */
  int  gridX,  gridY;                      /* location of TL corner in grid */
  int  gridW,  gridH;                      /* Horizontal and vertical span  */
  char gridfill, gridanchor;               /* fill mode and anchor */
  char gridpad1, gridpad2;                 /* padding */

  /* simple resources management, to be implemented */
  char              *name;                 /* name string to identify this widget */
  /* reserved */
  void              *reserved0;   
  void              *reserved1;   
  void              *reserved2;   
  void              *reserved3;   
  void              *reserved4;   
} EZ_WidgetCommon;


#define EZ_WidgetNameString(wptr)    ((wptr)->common.name)

#define EZ_WidgetOriginX(wptr)       ((wptr)->common.x)
#define EZ_WidgetOriginY(wptr)       ((wptr)->common.y)
#define EZ_WidgetWidth(wptr)         ((wptr)->common.w)
#define EZ_WidgetHeight(wptr)        ((wptr)->common.h)
#define EZ_WidgetWindow(wptr)        ((wptr)->common.win)
#define EZ_WidgetParent(wptr)        ((wptr)->common.parent)
#define EZ_WidgetChildren(wptr)      ((wptr)->common.children)
#define EZ_WidgetSibling(wptr)       ((wptr)->common.sibling)

#define EZ_WidgetCW(wptr)            ((wptr)->common.cW)
#define EZ_WidgetCH(wptr)            ((wptr)->common.cH)

#define EZ_WidgetDnDApplName(wptr)   ((wptr)->common.DnDName)
#define EZ_WidgetDnDParent(wptr)     ((wptr)->common.DnDParent)

#define EZ_WidgetPixmap(wptr)        ((wptr)->common.pixmap)
#define EZ_WidgetForeground(wptr)    ((wptr)->common.foreground)
#define EZ_WidgetBackground(wptr)    ((wptr)->common.background)
#define EZ_WidgetParentBG(wptr)      ((wptr)->common.parentbg)
#define EZ_WidgetFont(wptr)          ((wptr)->common.font)
#define EZ_WidgetBubbleString(wptr)  ((wptr)->common.bubble_string)
#define EZ_WidgetFlags(wptr)         ((wptr)->common.flags)
#define EZ_WidgetType(wptr)          ((wptr)->common.type)
#define EZ_WidgetMinWidth(wptr)      ((wptr)->common.minW)
#define EZ_WidgetMinHeight(wptr)     ((wptr)->common.minH)
#define EZ_WidgetAMinWidth(wptr)     ((wptr)->common.aminW)
#define EZ_WidgetAMinHeight(wptr)    ((wptr)->common.aminH)
#define EZ_WidgetAWidth(wptr)        ((wptr)->common.aW)
#define EZ_WidgetAHeight(wptr)       ((wptr)->common.aH)
#define EZ_WidgetWidthHint(wptr)     ((wptr)->common.whint)
#define EZ_WidgetHeightHint(wptr)    ((wptr)->common.hhint)
#define EZ_WidgetStacking(wptr)      ((wptr)->common.stacking)
#define EZ_WidgetAlignment(wptr)     ((wptr)->common.alignment)
#define EZ_WidgetLabelPosition(wptr) ((wptr)->common.labelposition)
#define EZ_WidgetJustification(wptr) ((wptr)->common.justification)
#define EZ_WidgetFillMode(wptr)      ((wptr)->common.fillmode)
#define EZ_WidgetNumChildren(wptr)   ((wptr)->common.numchildren)
#define EZ_WidgetPadX(wptr)          ((wptr)->common.padx)
#define EZ_WidgetPadY(wptr)          ((wptr)->common.pady)
#define EZ_WidgetPadB(wptr)          ((wptr)->common.padb)
#define EZ_WidgetSepX(wptr)          ((wptr)->common.sepx)
#define EZ_WidgetSepY(wptr)          ((wptr)->common.sepy)
#define EZ_WidgetAuxXLeft(wptr)      ((wptr)->common.xauxL)
#define EZ_WidgetAuxXRight(wptr)     ((wptr)->common.xauxR)
#define EZ_WidgetAuxY(wptr)          ((wptr)->common.yaux)
#define EZ_WidgetHAdjust(wptr)       ((wptr)->common.hAdjust)
#define EZ_WidgetMaped(wptr)         ((wptr)->common.maped)
#define EZ_WidgetMapped(wptr)        ((wptr)->common.maped)
#define EZ_WidgetBorderWidth(wptr)   ((wptr)->common.borderwidth)
#define EZ_WidgetBorderStyle(wptr)   ((wptr)->common.borderstyle)
#define EZ_WidgetIntData(wptr)       ((wptr)->common.IntData)
#define EZ_WidgetPtrData(wptr)       ((wptr)->common.PtrData)
#define EZ_WidgetRetData(wptr)       ((wptr)->common.RetData)
#define EZ_WidgetCallBackFunc(wptr)  ((wptr)->common.callbacks)
#define EZ_WidgetCallbackFunc(wptr)  ((wptr)->common.callbacks)
#define EZ_WidgetCallBack(wptr)      ((wptr)->common.callbacks)
#define EZ_WidgetCallback(wptr)      ((wptr)->common.callbacks)
#define EZ_WidgetCallback(wptr)      ((wptr)->common.callbacks)
#define EZ_WidgetMotionCallBack(wptr)  ((wptr)->common.motionCallbacks)
#define EZ_WidgetMotionCallback(wptr)  ((wptr)->common.motionCallbacks)
#define EZ_WidgetDestroyCallback(wptr)  ((wptr)->common.destroyCallbacks)
#define EZ_WidgetDestroyCallBack(wptr)  ((wptr)->common.destroyCallbacks)
#define EZ_WidgetEventHandler(wptr)  ((wptr)->common.eventHandler)
#define EZ_WidgetEventHandlers(wptr) ((wptr)->common.eventHandler)

#define EZ_WidgetDnDDragCursor(wptr)     ((wptr)->common.DnDDragCursor)
#define EZ_WidgetDnDTmp(wptr)            ((wptr)->common.DnDtmp)
#define EZ_WidgetDnDHandler(wptr)        ((wptr)->common.DnDHandler)
#define EZ_WidgetDnDDataEncoders(wptr)   ((wptr)->common.DnDDataEncoders)
#define EZ_WidgetDnDDataDecoders(wptr)   ((wptr)->common.DnDDataDecoders)
#define EZ_WidgetDnDTargetHelp(wptr)     ((wptr)->common.DnDTargetHelp)

#define EZ_WidgetIsDnDSrc(wptr)          EZ_WidgetDnDDataEncoders(wptr)
#define EZ_WidgetIsDnDTarget(wptr)       EZ_WidgetDnDDataDecoders(wptr)


#define EZ_WidgetXOffset(wptr)       (((wptr)->common.w -(int) ((wptr)->common.minW))>>1)
#define EZ_WidgetYOffset(wptr)       (((wptr)->common.h -(int) ((wptr)->common.minH))>>1)

#define EZ_WidgetGBX(wptr)           ((wptr)->common.gridX)
#define EZ_WidgetGBY(wptr)           ((wptr)->common.gridY)
#define EZ_WidgetGBW(wptr)           ((wptr)->common.gridW)
#define EZ_WidgetGBH(wptr)           ((wptr)->common.gridH)
#define EZ_WidgetGBFill(wptr)        ((wptr)->common.gridfill)
#define EZ_WidgetGBAnchor(wptr)      ((wptr)->common.gridanchor)

/***********************************************************************
 *
 *    invoke callbacks 
 */
#define EZ_ExecuteWidgetCallBacks(_the_widget_) \
{ \
   if(EZ_LookupWidgetFromAllHT(_the_widget_) == (_the_widget_)) { \
    EZ_CallBackStruct *_the_callback_list = EZ_WidgetCallBackFunc((_the_widget_));\
    if(_the_callback_list) \
     {\
	while(_the_callback_list && EZ_LookupWidgetFromAllHT(_the_widget_) == (_the_widget_))\
 	{\
	   if(_the_callback_list->callback)\
	       { (_the_callback_list->callback)(_the_widget_, _the_callback_list->data); }\
	   _the_callback_list = _the_callback_list->next; \
       }\
    }\
 }\
}

#define	 EZ_HandleMotionCallBacks(_widget_, _cbcks_) \
{\
  EZ_CallBackStruct *cbks__ = _cbcks_;\
  if(cbks__) \
    {\
      while(cbks__ && EZ_LookupWidgetFromAllHT(_widget_) == (_widget_))\
	{\
	   if(cbks__->callback)\
            { (cbks__->callback)(_widget_, cbks__->data); }\
	   cbks__= cbks__->next;\
	}\
    }\
}

/***********************************************************************
 ***                                                                 ***
 ***               Common Flags for all Widgets                      ***
 ***                                                                 ***
 ***********************************************************************/

#define EZ_WIDGET_X_SET_BIT                   (1L<<0)
#define EZ_WIDGET_Y_SET_BIT                   (1L<<1)

#define EZ_WIDGET_XY_SET_BITS                 (EZ_WIDGET_X_SET_BIT | EZ_WIDGET_Y_SET_BIT)

#define EZ_WIDGET_WIDTH_SET_BIT               (1L<<2)
#define EZ_WIDGET_HEIGHT_SET_BIT              (1L<<3)
#define EZ_WIDGET_SIZE_SET_BITS               (EZ_WIDGET_HEIGHT_SET_BIT | EZ_WIDGET_WIDTH_SET_BIT)
#define EZ_WIDGET_WIDTH_HINT_BIT              (1L<<4)
#define EZ_WIDGET_HEIGHT_HINT_BIT             (1L<<5)
#define EZ_WIDGET_SIZE_COMPUTED_BIT           (1L<<6)
#define EZ_WIDGET_SIZE_MAY_BE_CHANGED_BIT     (1L<<7)
#define EZ_WIDGET_EXPAND_BIT                  (1L<<8)
#define EZ_WIDGET_NONACTIVE_BIT               (1L<<9)
#define EZ_WIDGET_TRANSIENT_BIT               (1L<<10)
#define EZ_WIDGET_DISABLED_BIT                (1L<<11)
#define EZ_WIDGET_FREEZED_BIT                 (1L<<12)
#define EZ_WIDGET_HIGHLIGHT_BIT               (1L<<13)
#define EZ_WIDGET_DO_NOT_PROPAGATE_BIT        (1L<<14)
#define EZ_WIDGET_EMBEDED_BIT                 (1L<<15)
#define EZ_WIDGET_EMBEDER_BIT                 (1L<<16)
#define EZ_WIDGET_FOCUSABLE_BIT               (1L<<17)
#define EZ_WIDGET_SHAPED_WINDOW_BIT           (1L<<18)
#define EZ_WIDGET_THIN_FONT_BIT               (1L<<19)
#define EZ_WIDGET_IS_CLONE_BIT                (1L<<20)

#define EZ_WIDGET_TMP_BITA                    (1L<<28)

/***********************************************************************************************/
#define EZ_SetWidgetThinFontFlag(wptr)       {EZ_WidgetFlags(wptr) |= EZ_WIDGET_THIN_FONT_BIT;}
#define EZ_GetWidgetThinFontFlag(wptr)       (EZ_WidgetFlags(wptr) & EZ_WIDGET_THIN_FONT_BIT)
#define EZ_ClearWidgetThinFontFlag(wptr)     {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_THIN_FONT_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetShapedWinFlag(wptr)       {EZ_WidgetFlags(wptr) |= EZ_WIDGET_SHAPED_WINDOW_BIT;}
#define EZ_GetWidgetShapedWinFlag(wptr)       (EZ_WidgetFlags(wptr) & EZ_WIDGET_SHAPED_WINDOW_BIT)
#define EZ_ClearWidgetShapedWinFlag(wptr)     {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_SHAPED_WINDOW_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetFocusableFlag(wptr)       {EZ_WidgetFlags(wptr) |= EZ_WIDGET_FOCUSABLE_BIT;}
#define EZ_GetWidgetFocusableFlag(wptr)       (EZ_WidgetFlags(wptr) & EZ_WIDGET_FOCUSABLE_BIT)
#define EZ_ClearWidgetFocusableFlag(wptr)     {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_FOCUSABLE_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetEmbederFlag(wptr)      {EZ_WidgetFlags(wptr) |= EZ_WIDGET_EMBEDER_BIT;}
#define EZ_GetWidgetEmbederFlag(wptr)      (EZ_WidgetFlags(wptr) & EZ_WIDGET_EMBEDER_BIT)
#define EZ_ClearWidgetEmbederFlag(wptr)    {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_EMBEDER_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetExpandFlag(wptr)          {EZ_WidgetFlags(wptr) |= EZ_WIDGET_EXPAND_BIT;}
#define EZ_GetWidgetExpandFlag(wptr)          (EZ_WidgetFlags(wptr) & EZ_WIDGET_EXPAND_BIT)
#define EZ_ClearWidgetExpandFlag(wptr)        {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_EXPAND_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetNonActiveFlag(wptr)       {EZ_WidgetFlags(wptr) |= EZ_WIDGET_NONACTIVE_BIT;}
#define EZ_GetWidgetNonActiveFlag(wptr)       (EZ_WidgetFlags(wptr) & EZ_WIDGET_NONACTIVE_BIT)
#define EZ_ClearWidgetNonActiveFlag(wptr)     {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_NONACTIVE_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetTransientFlag(wptr)       {EZ_WidgetFlags(wptr) |= EZ_WIDGET_TRANSIENT_BIT;}
#define EZ_GetWidgetTransientFlag(wptr)       (EZ_WidgetFlags(wptr) & EZ_WIDGET_TRANSIENT_BIT)
#define EZ_ClearWidgetTransientFlag(wptr)     {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_TRANSIENT_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetDisabledFlag(wptr)        {EZ_WidgetFlags(wptr) |= EZ_WIDGET_DISABLED_BIT;}
#define EZ_GetWidgetDisabledFlag(wptr)        (EZ_WidgetFlags(wptr) & EZ_WIDGET_DISABLED_BIT)
#define EZ_ClearWidgetDisabledFlag(wptr)      {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_DISABLED_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetFreezedFlag(wptr)         {EZ_WidgetFlags(wptr) |= EZ_WIDGET_FREEZED_BIT;}
#define EZ_GetWidgetFreezedFlag(wptr)         (EZ_WidgetFlags(wptr) & EZ_WIDGET_FREEZED_BIT)
#define EZ_ClearWidgetFreezedFlag(wptr)       {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_FREEZED_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetHighlightFlag(wptr)       {EZ_WidgetFlags(wptr) |= EZ_WIDGET_HIGHLIGHT_BIT;}
#define EZ_GetWidgetHighlightFlag(wptr) \
          (EZ_HighlightEnabled && (EZ_WidgetFlags(wptr) & EZ_WIDGET_HIGHLIGHT_BIT))
#define EZ_ClearWidgetHighlightFlag(wptr)     {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_HIGHLIGHT_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetXSetFlag(wptr)            {EZ_WidgetFlags(wptr) |= EZ_WIDGET_X_SET_BIT;}
#define EZ_SetWidgetYSetFlag(wptr)            {EZ_WidgetFlags(wptr) |= EZ_WIDGET_Y_SET_BIT;}
#define EZ_GetWidgetXSetFlag(wptr)            (EZ_WidgetFlags(wptr) & EZ_WIDGET_X_SET_BIT)
#define EZ_GetWidgetYSetFlag(wptr)            (EZ_WidgetFlags(wptr) & EZ_WIDGET_Y_SET_BIT)
#define EZ_ClearWidgetXSetFlag(wptr)          {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_X_SET_BIT;}
#define EZ_ClearWidgetYSetFlag(wptr)          {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_Y_SET_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetXYSetFlag(wptr)           {EZ_WidgetFlags(wptr) |= EZ_WIDGET_XY_SET_BITS;}
#define EZ_GetWidgetXYSetFlag(wptr)           (EZ_WidgetFlags(wptr) & EZ_WIDGET_XY_SET_BITS)
#define EZ_ClearWidgetXYSetFlag(wptr)         (EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_XY_SET_BITS)
/***********************************************************************************************/
#define EZ_SetWidgetWidthSetFlag(wptr)        {EZ_WidgetFlags(wptr) |= EZ_WIDGET_WIDTH_SET_BIT;}
#define EZ_SetWidgetHeightSetFlag(wptr)       {EZ_WidgetFlags(wptr) |= EZ_WIDGET_HEIGHT_SET_BIT;}
#define EZ_SetWidgetSizeSetFlag(wptr) \
{EZ_WidgetFlags(wptr) |= (EZ_WIDGET_WIDTH_SET_BIT | EZ_WIDGET_HEIGHT_SET_BIT);}
#define EZ_ClearWidgetWidthSetFlag(wptr)        {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_WIDTH_SET_BIT;}
#define EZ_ClearWidgetHeightSetFlag(wptr)       {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_HEIGHT_SET_BIT;}
#define EZ_GetWidgetWidthSetFlag(wptr)        (EZ_WidgetFlags(wptr) & EZ_WIDGET_WIDTH_SET_BIT)
#define EZ_GetWidgetHeightSetFlag(wptr)       (EZ_WidgetFlags(wptr) & EZ_WIDGET_HEIGHT_SET_BIT)
#define EZ_GetWidgetSizeSetFlag(wptr)  (EZ_GetWidgetWidthSetFlag(wptr) &&  EZ_GetWidgetHeightSetFlag(wptr))
/***********************************************************************************************/
#define EZ_SetWidgetWidthHintFlag(wptr)        {EZ_WidgetFlags(wptr) |= EZ_WIDGET_WIDTH_HINT_BIT;}
#define EZ_SetWidgetHeightHintFlag(wptr)       {EZ_WidgetFlags(wptr) |= EZ_WIDGET_HEIGHT_HINT_BIT;}
#define EZ_GetWidgetWidthHintFlag(wptr)        (EZ_WidgetFlags(wptr) & EZ_WIDGET_WIDTH_HINT_BIT)
#define EZ_GetWidgetHeightHintFlag(wptr)       (EZ_WidgetFlags(wptr) & EZ_WIDGET_HEIGHT_HINT_BIT)
#define EZ_ClearWidgetWidthHintFlag(wptr)      {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_WIDTH_HINT_BIT;}
#define EZ_ClearWidgetHeightHintFlag(wptr)     {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_HEIGHT_HINT_BIT;}
/***********************************************************************************************/
#define EZ_SetWidgetSizeComputedFlag(wptr)   {EZ_WidgetFlags(wptr) |= EZ_WIDGET_SIZE_COMPUTED_BIT;}
#define EZ_GetWidgetSizeComputedFlag(wptr)   (EZ_WidgetFlags(wptr) & EZ_WIDGET_SIZE_COMPUTED_BIT)
#define EZ_ClearWidgetSizeComputedFlag(wptr) \
{\
   EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_SIZE_COMPUTED_BIT;\
   EZ_WidgetFlags(wptr) |= EZ_WIDGET_SIZE_MAY_BE_CHANGED_BIT;\
}
#define EZ_WidgetSizeMayBeChandedFlag(wptr)  (EZ_WidgetFlags(wptr) & EZ_WIDGET_SIZE_MAY_BE_CHANGED_BIT)
#define EZ_SetWidgetSizeMayBeChandedFlag(wptr) \
{ EZ_WidgetFlags(wptr) |= EZ_WIDGET_SIZE_MAY_BE_CHANGED_BIT; }
#define EZ_ClearWidgetSizeMayBeChandedFlag(wptr) \
{ EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_SIZE_MAY_BE_CHANGED_BIT;}
/***********************************************************************************************/
#define EZ_GetDoNotPropagateFlag(wptr)     (EZ_WidgetFlags(wptr) & EZ_WIDGET_DO_NOT_PROPAGATE_BIT)
#define EZ_SetDoNotPropagateFlag(wptr)     {EZ_WidgetFlags(wptr) |= EZ_WIDGET_DO_NOT_PROPAGATE_BIT;}
#define EZ_ClearDoNotPropagateFlag(wptr)   {EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_DO_NOT_PROPAGATE_BIT;}
/***********************************************************************************************/
#define EZ_GetWidgetEmbededFlag(wptr)    (EZ_WidgetFlags(wptr) & EZ_WIDGET_EMBEDED_BIT)
#define EZ_SetWidgetEmbededFlag(wptr)    (EZ_WidgetFlags(wptr) |= EZ_WIDGET_EMBEDED_BIT)
#define EZ_ClearWidgetEmbededFlag(wptr)  (EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_EMBEDED_BIT)
/***********************************************************************************************/
#define EZ_GetWidgetIsCloneFlag(wptr)    (EZ_WidgetFlags(wptr) & EZ_WIDGET_IS_CLONE_BIT)
#define EZ_SetWidgetIsCloneFlag(wptr)    (EZ_WidgetFlags(wptr) |= EZ_WIDGET_IS_CLONE_BIT)
#define EZ_ClearWidgetIsCloneFlag(wptr)  (EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_IS_CLONE_BIT)
/***********************************************************************************************/
#define EZ_GetWidgetTmpFlagA(wptr)    (EZ_WidgetFlags(wptr) & EZ_WIDGET_TMP_BITA)
#define EZ_SetWidgetTmpFlagA(wptr)    (EZ_WidgetFlags(wptr) |= EZ_WIDGET_TMP_BITA)
#define EZ_ClearWidgetTmpFlagA(wptr)  (EZ_WidgetFlags(wptr) &= ~EZ_WIDGET_TMP_BITA)
/***********************************************************************************************/



/***********************************************************************
 ***                                                                 ***
 ***                 Unknown Widget, not really useful.              ***
 ***                                                                 ***
 ***********************************************************************/
typedef struct EZ_UnknownWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /* privite storage */
  char C[8];
  int  I[8];
  void *P[8];
} EZ_UnknownWidget;

#define EZ_UnknownWidgetCI(wptr,i)          ((wptr)->unknownWidget.C[i])
#define EZ_UnknownWidgetII(wptr,i)          ((wptr)->unknownWidget.I[i])
#define EZ_UnknownWidgetPI(wptr,i)          ((wptr)->unknownWidget.P[i])


/***********************************************************************
 ***                                                                 ***
 ***                        Special Widget                           ***
 ***                                                                 ***
 ***********************************************************************/
/*
 *  This one is used to implement special internal widgets
 */
typedef struct EZ_SpecialWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  void (*redrawFunc) MY_ANSIARGS((void *widget)); 
  void (*eventHandle) MY_ANSIARGS((void *widget, XEvent *event)); 
  void (*freeData) MY_ANSIARGS((void *widget)); 
  /* slots for private data */
  char C1,C2;
  char C[6];
  int  I[6];
  void *P[6];
} EZ_SpecialWidget;
#define SPECIAL_WIDGET_PRIVATE_DATA_SIZE 6

#define EZ_SpecialWidgetC1(wptr)            ((wptr)->SpecialWidget.C1)
#define EZ_SpecialWidgetC2(wptr)            ((wptr)->SpecialWidget.C2)
#define EZ_SpecialWidgetCI(wptr,i)          ((wptr)->SpecialWidget.C[i])
#define EZ_SpecialWidgetII(wptr,i)          ((wptr)->SpecialWidget.I[i])
#define EZ_SpecialWidgetPI(wptr,i)          ((wptr)->SpecialWidget.P[i])
#define EZ_SpecialWidgetRedrawFunc(wptr)  ((wptr)->SpecialWidget.redrawFunc)
#define EZ_SpecialWidgetEventHandle(wptr) ((wptr)->SpecialWidget.eventHandle)
#define EZ_SpecialWidgetFreeFunc(wptr)    ((wptr)->SpecialWidget.freeData)

/***********************************************************************
 ***                                                                 ***
 ***                        Frame Widget                             ***
 ***                                                                 ***
 ***********************************************************************/
typedef struct EZ_FrameWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------------------------------------
   * Frame data. For special purpose frames such as labeled frame
   *-------------------------------------------------------------*/
  char              *label;           /* for labeled frame,      */
  int               label_length;     /* length of label         */
  int               line_length;      /* length of a dpyed line  */
  int               nlines;           /* total # of lines        */
  int               twidth;           /* label width in pixels   */
  int               theight;          /* label height in pixels  */
  int               ascent;           /* font ascent             */
  int               xindent;          /* internal border indent  */
  int               yindent;          /* internal border indent  */

  int               internalBdWidth;  /* internal border width   */
  int               brokenIntBdLength;/* length of broken int bd */
  int               wadjust;          /* width adjustment        */
  int               spad;
  char              internalBdType;   /* internal border type    */
  char              haslabel;         /* do we have a label ?    */
  char              cpad[2];
} EZ_FrameWidget;

#define EZ_FrameIntBdWidth(wptr)        ((wptr)->frame.internalBdWidth)
#define EZ_FrameIntBdType(wptr)         ((wptr)->frame.internalBdType)
#define EZ_FrameBrokenIntBdLength(wptr) ((wptr)->frame.brokenIntBdLength)

#define EZ_FramePixmap(wptr)          ((wptr)->common.pixmap)
#define EZ_FrameBackground(wptr)      ((wptr)->common.background) 
#define EZ_FrameForeground(wptr)      ((wptr)->common.foreground) 
#define EZ_FrameFont(wptr)            ((wptr)->common.font)
#define EZ_FrameLabel(wptr)           ((wptr)->frame.label)
#define EZ_FrameLabelLength(wptr)     ((wptr)->frame.label_length)
#define EZ_FrameLineLength(wptr)      ((wptr)->frame.line_length)
#define EZ_FrameNLines(wptr)          ((wptr)->frame.nlines)
#define EZ_FrameTWidth(wptr)          ((wptr)->frame.twidth)
#define EZ_FrameTHeight(wptr)         ((wptr)->frame.theight)
#define EZ_FrameFontAscent(wptr)      ((wptr)->frame.ascent)
#define EZ_FrameXIndent(wptr)         ((wptr)->frame.xindent)
#define EZ_FrameYIndent(wptr)         ((wptr)->frame.yindent)
#define EZ_FrameHasLabel(wptr)        ((wptr)->frame.haslabel)
#define EZ_FrameWAdjust(wptr)         ((wptr)->frame.wadjust)

/***********************************************************************
 ***                                                                 ***
 ***                        Label Widget                             ***
 ***                                                                 ***
 ***********************************************************************/
typedef struct EZ_LabelWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*-----------------------------
   * Private data. Don't need much
   *----------------------------*/
  char              *label;           /* label string            */

  int               label_length;     /* length of label         */
  int               line_length;      /* length of a dpyed line  */
  int               nlines;           /* total # of lines        */
  int               twidth;           /* label width in pixels   */
  int               theight;          /* label height in pixels  */
  int               ascent;           /*  font ascent            */
  int               alwayshighlight;  /* highlight ??            */
  int               spad;             /* not used */
  /* for free label          */
  char              movable;         
  char              dontTakeFocus;
  char              ismenutitle;      /* is it a menu title ?   */
  char              cpad[2];

} EZ_LabelWidget;

#define EZ_LabelPixmap(wptr)          ((wptr)->common.pixmap)
#define EZ_LabelFont(wptr)            ((wptr)->common.font)
#define EZ_LabelForeground(wptr)      ((wptr)->common.foreground) 
#define EZ_LabelBackground(wptr)      ((wptr)->common.background) 
#define EZ_LabelString(wptr)          ((wptr)->label.label)
#define EZ_LabelStringLength(wptr)    ((wptr)->label.label_length)
#define EZ_LabelLineLength(wptr)      ((wptr)->label.line_length)
#define EZ_LabelNLines(wptr)          ((wptr)->label.nlines)
#define EZ_LabelTWidth(wptr)          ((wptr)->label.twidth)
#define EZ_LabelTHeight(wptr)         ((wptr)->label.theight)
#define EZ_LabelFontAscent(wptr)      ((wptr)->label.ascent)
#define EZ_LabelAlwaysHighlight(wptr) ((wptr)->label.alwayshighlight)
#define EZ_LabelMovable(wptr)         ((wptr)->label.movable)
#define EZ_IsNWFrame(wptr)            ((wptr)->label.alwayshighlight)
#define EZ_LabelMotionCallBack(wptr)  ((wptr)->common.motionCallbacks)
#define EZ_LabelDontTakeFocus(wptr)   ((wptr)->label.dontTakeFocus)
#define EZ_LabelIsMenuTitle(wptr)     ((wptr)->label.ismenutitle)

/***********************************************************************
 ***                                                                 ***
 ***                        Normal Button                            ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_ButtonWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*-----------------------------
   * Button data. 
   *----------------------------*/
  char              *label;           /* text on button          */

  int               label_length;     /* length of label         */
  int               line_length;      /* length of a line        */
  int               nlines;           /* number of lines in label*/
  int               twidth;           /* label width in pixels   */
  int               theight;          /* label height in pixels  */
  int               ascent;           /*  font ascent            */
  char              *label2;          /* second label, for menu  */
  int               label2_length;    /* length of label2        */
  int               label2_width;     /* length of label2 in pix */
  int               underline;        /* for shortcut character  */
  int               modifiers;        /* menu-shortcut stuff     */
  char              *shortcut;      
  char              pressed;          /* set if button is pressed*/
  char              nohighlight;      /* set if never highlight  */
  char              setbdr;           /* border has been modified? */
  char              cpad;

  /* special field used in NoteBookPage */
  union EZ_WWindow_ *companion;       /* special companion widget*/
  union EZ_WWindow_ *fsb;

} EZ_ButtonWidget;

#define EZ_ButtonFSB(wptr)            ((wptr)->button.fsb)
#define EZ_ButtonCompanion(wptr)      ((wptr)->button.companion)
#define EZ_ButtonLabel(wptr)          ((wptr)->button.label)
#define EZ_ButtonLabelLength(wptr)    ((wptr)->button.label_length)
#define EZ_ButtonFont(wptr)           ((wptr)->common.font)
#define EZ_ButtonPixmap(wptr)         ((wptr)->common.pixmap)
#define EZ_ButtonForeground(wptr)     ((wptr)->common.foreground)
#define EZ_ButtonBackground(wptr)     ((wptr)->common.background)
#define EZ_ButtonLineLength(wptr)     ((wptr)->button.line_length)
#define EZ_ButtonNLines(wptr)         ((wptr)->button.nlines)
#define EZ_ButtonTWidth(wptr)         ((wptr)->button.twidth)
#define EZ_ButtonTHeight(wptr)        ((wptr)->button.theight)
#define EZ_ButtonFontAscent(wptr)     ((wptr)->button.ascent)
#define EZ_ButtonLabel2(wptr)         ((wptr)->button.label2)
#define EZ_ButtonLabel2Length(wptr)   ((wptr)->button.label2_length)
#define EZ_ButtonLabel2Width(wptr)    ((wptr)->button.label2_width)
#define EZ_ButtonPressed(wptr)        ((wptr)->button.pressed)
#define EZ_ButtonModifiers(wptr)      ((wptr)->button.modifiers)
#define EZ_ButtonShortcut(wptr)       ((wptr)->button.shortcut)
#define EZ_ButtonUnderline(wptr)      ((wptr)->button.underline)
#define EZ_ButtonUnderLine(wptr)      ((wptr)->button.underline)
#define EZ_ButtonNoHighlight(wptr)    ((wptr)->button.nohighlight)
#define EZ_ButtonNoHighLight(wptr)    ((wptr)->button.nohighlight)
#define EZ_ButtonSetBorder(wptr)      ((wptr)->button.setbdr)

/***********************************************************************
 ***                                                                 ***
 ***                        Check Button                             ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_CButtonWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*-----------------------------
   * Check Button data. 
   *----------------------------*/
  char              *label;           /* text on button          */
  int               label_length;     /* length of label         */
  int               line_length;      /* length of a line        */
  int               nlines;           /* number of lines in label*/
  int               twidth;           /* label width in pixels   */
  int               theight;          /* label height in pixels  */
  int               ascent;           /* font ascent             */
  char              borderwidth;      /* border width of check   */
  char              borderstyle;      /* border style of check   */
  char              checksizeadjust;  /* check mark size adjust  */
  char              checkType;        /* type of indicator       */
  unsigned long     checkColor;       /* color of indicator when active */

  int               *vdat;
  /*
  int               value;      
  int               onvalue;    
  int               offvalue;   
  */

  char              *label2;          /* second label, for menu  */
  int               label2_length;    /* length of label2        */
  int               label2_width;     /* length of label2 in pix */
  int               underline;        /* for shortcut character  */
  int               modifiers;        /* menu-shortcut stuff     */
  char              *shortcut;      

} EZ_CButtonWidget;

#define EZ_CButtonLabel(wptr)          ((wptr)->cbutton.label)
#define EZ_CButtonLabelLength(wptr)    ((wptr)->cbutton.label_length)
#define EZ_CButtonPixmap(wptr)         ((wptr)->common.pixmap)
#define EZ_CButtonFont(wptr)           ((wptr)->common.font)
#define EZ_CButtonForeground(wptr)     ((wptr)->common.foreground)
#define EZ_CButtonBackground(wptr)     ((wptr)->common.background)
#define EZ_CButtonTWidth(wptr)         ((wptr)->cbutton.twidth)
#define EZ_CButtonTHeight(wptr)        ((wptr)->cbutton.theight)
#define EZ_CButtonFontAscent(wptr)     ((wptr)->cbutton.ascent)
#define EZ_CButtonLineLength(wptr)     ((wptr)->cbutton.line_length)
#define EZ_CButtonNLines(wptr)         ((wptr)->cbutton.nlines)
#define EZ_CButtonCheckBorderWidth(wptr)  ((wptr)->cbutton.borderwidth)
#define EZ_CButtonCheckBorderStyle(wptr)  ((wptr)->cbutton.borderstyle)
#define EZ_CButtonCheckSizeAdjust(wptr)   ((wptr)->cbutton.checksizeadjust)
#define EZ_CButtonCheckType(wptr)         ((wptr)->cbutton.checkType)
#define EZ_CButtonCheckColor(wptr)        ((wptr)->cbutton.checkColor)
#define EZ_CButtonData(wptr)              ((wptr)->cbutton.vdat)
#define EZ_CButtonVarValue(wptr)          (((wptr)->cbutton.vdat)[0])
#define EZ_CButtonVarOnValue(wptr)     (((wptr)->cbutton.vdat)[1])
#define EZ_CButtonVarOffValue(wptr)    (((wptr)->cbutton.vdat)[2])
#define EZ_CButtonSetOnValue(wptr)     (((wptr)->cbutton.vdat)[0] = ((wptr)->cbutton.vdat)[1])
#define EZ_CButtonSetOffValue(wptr)    (((wptr)->cbutton.vdat)[0] = ((wptr)->cbutton.vdat)[2])
#define EZ_CButtonOn(wptr)             (((wptr)->cbutton.vdat)[0] == ((wptr)->cbutton.vdat)[1])
#define EZ_CButtonCheck(wptr)          (((wptr)->cbutton.vdat)[0] == ((wptr)->cbutton.vdat)[1])

#define EZ_CButtonLabel2(wptr)         ((wptr)->cbutton.label2)
#define EZ_CButtonLabel2Length(wptr)   ((wptr)->cbutton.label2_length)
#define EZ_CButtonLabel2Width(wptr)    ((wptr)->cbutton.label2_width)
#define EZ_CButtonModifiers(wptr)      ((wptr)->cbutton.modifiers)
#define EZ_CButtonShortcut(wptr)       ((wptr)->cbutton.shortcut)
#define EZ_CButtonUnderline(wptr)      ((wptr)->cbutton.underline)
#define EZ_CButtonUnderLine(wptr)      ((wptr)->cbutton.underline)

/***********************************************************************
 ***                                                                 ***
 ***                      Radio Button                               ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_RButtonList_ {
  union EZ_WWindow_       *rbutton;
  struct EZ_RButtonList_  *next;
} EZ_RButtonList;

typedef struct EZ_RBGS_ {
  int              var;
  int              id;
  EZ_RButtonList   *list;
  struct EZ_RBGS_  *next;
} EZ_RButtonGpStruct;
  
typedef struct EZ_RButtonWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*-----------------------------
   * Radio Button data. 
   *----------------------------*/
  char              *label;           /* text on button          */
  int               label_length;     /* length of label         */
  int               line_length;      /* length of a line        */
  int               nlines;           /* number of lines in label*/
  int               twidth;           /* label width in pixels   */
  int               theight;          /* label height in pixels  */
  int               ascent;           /*  font ascent            */
  char              borderwidth;      /* border width of check   */
  char              borderstyle;      /* border style of check   */
  char              checksizeadjust;  /* check mark size adjust  */
  char              checkType;        /* indicator type          */
  unsigned long     checkColor;       /* color of indicator when active */
  int               *var;             /* the address of check var*/
  int               value;            /* val of var when checked */
  EZ_RButtonGpStruct *group;          /* the group the button belongs to */
  char              *label2;          /* second label, for menu  */
  int               label2_length;    /* length of label2        */
  int               label2_width;     /* length of label2 in pix */
  int               underline;        /* for shortcut character  */
  int               modifiers;        /* menu-shortcut stuff     */
  char              *shortcut;      
} EZ_RButtonWidget;

#define EZ_RButtonLabel(wptr)          ((wptr)->rbutton.label)
#define EZ_RButtonLabelLength(wptr)    ((wptr)->rbutton.label_length)
#define EZ_RButtonPixmap(wptr)         ((wptr)->common.pixmap)
#define EZ_RButtonFont(wptr)           ((wptr)->common.font)
#define EZ_RButtonForeground(wptr)     ((wptr)->common.foreground)
#define EZ_RButtonBackground(wptr)     ((wptr)->common.background)
#define EZ_RButtonTWidth(wptr)         ((wptr)->rbutton.twidth)
#define EZ_RButtonTHeight(wptr)        ((wptr)->rbutton.theight)
#define EZ_RButtonFontAscent(wptr)     ((wptr)->rbutton.ascent)
#define EZ_RButtonLineLength(wptr)     ((wptr)->rbutton.line_length)
#define EZ_RButtonNLines(wptr)         ((wptr)->rbutton.nlines)
#define EZ_RButtonCheckBorderWidth(wptr)  ((wptr)->rbutton.borderwidth)
#define EZ_RButtonCheckBorderStyle(wptr)  ((wptr)->rbutton.borderstyle)
#define EZ_RButtonCheckSizeAdjust(wptr)   ((wptr)->rbutton.checksizeadjust)
#define EZ_RButtonChecked(wptr)        (*((wptr)->rbutton.var) == (wptr)->rbutton.value)
#define EZ_RButtonOn(wptr)             (*((wptr)->rbutton.var) == (wptr)->rbutton.value)
#define EZ_RButtonSetValue(wptr)       (*((wptr)->rbutton.var) = (wptr)->rbutton.value)
#define EZ_RButtonGroup(wptr)          ((wptr)->rbutton.group)
#define EZ_RButtonVarValue(wptr)       ((wptr)->rbutton.value)
#define EZ_RButtonVarPtr(wptr)         ((wptr)->rbutton.var)
#define EZ_RButtonCheckType(wptr)      ((wptr)->rbutton.checkType)
#define EZ_RButtonCheckColor(wptr)     ((wptr)->rbutton.checkColor)

#define EZ_RButtonLabel2(wptr)         ((wptr)->rbutton.label2)
#define EZ_RButtonLabel2Length(wptr)   ((wptr)->rbutton.label2_length)
#define EZ_RButtonLabel2Width(wptr)    ((wptr)->rbutton.label2_width)
#define EZ_RButtonModifiers(wptr)      ((wptr)->rbutton.modifiers)
#define EZ_RButtonShortcut(wptr)       ((wptr)->rbutton.shortcut)
#define EZ_RButtonUnderline(wptr)      ((wptr)->rbutton.underline)
#define EZ_RButtonUnderLine(wptr)      ((wptr)->rbutton.underline)
/***********************************************************************
 ***                                                                 ***
 ***                     MenuButton                                  ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_MButtonWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*-----------------------------
   * Menu Button data. 
   *----------------------------*/
  char              *label;           /* text on button          */
  int               label_length;     /* length of label         */
  int               line_length;      /* length of a line        */
  int               nlines;           /* number of lines in label*/
  int               twidth;           /* label width in pixels   */
  int               theight;          /* label height in pixels  */
  int               ascent;           /*  font ascent            */

  char              *label2;          /* second label, for menu  */
  int               label2_length;    /* length of label2        */
  int               label2_width;     /* length of label2 in pix */

  int               underline;        /* for shortcut character  */
  int               modifiers;        /* menu-shortcut stuff     */
  char              *shortcut;      
  
  union EZ_WWindow_  *menu;           /* the menu                */
  union EZ_WWindow_  *lastSelection;  /* last selected item      */

} EZ_MButtonWidget;

#define EZ_MButtonLabel(wptr)          ((wptr)->mbutton.label)
#define EZ_MButtonLabelLength(wptr)    ((wptr)->mbutton.label_length)
#define EZ_MButtonPixmap(wptr)         ((wptr)->common.pixmap)
#define EZ_MButtonFont(wptr)           ((wptr)->common.font)
#define EZ_MButtonForeground(wptr)     ((wptr)->common.foreground)
#define EZ_MButtonBackground(wptr)     ((wptr)->common.background)
#define EZ_MButtonTWidth(wptr)         ((wptr)->mbutton.twidth)
#define EZ_MButtonTHeight(wptr)        ((wptr)->mbutton.theight)
#define EZ_MButtonFontAscent(wptr)     ((wptr)->mbutton.ascent)
#define EZ_MButtonLineLength(wptr)     ((wptr)->mbutton.line_length)
#define EZ_MButtonNLines(wptr)         ((wptr)->mbutton.nlines)


#define EZ_MButtonLabel2(wptr)         ((wptr)->mbutton.label2)
#define EZ_MButtonLabel2Length(wptr)   ((wptr)->mbutton.label2_length)
#define EZ_MButtonLabel2Width(wptr)    ((wptr)->mbutton.label2_width)
#define EZ_MButtonUnderLine(wptr)      ((wptr)->mbutton.underline)
#define EZ_MButtonUnderline(wptr)      ((wptr)->mbutton.underline)
#define EZ_MButtonModifiers(wptr)      ((wptr)->mbutton.modifiers)
#define EZ_MButtonShortcut(wptr)       ((wptr)->mbutton.shortcut)
#define EZ_MButtonTheMenu(wptr)        ((wptr)->mbutton.menu)
#define EZ_MButtonLSItem(wptr)         ((wptr)->mbutton.lastSelection)

/***********************************************************************
 ***                                                                 ***
 ***                     Slider Widget                               ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_SliderWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*-----------------------------
   * Slider data. 
   *----------------------------*/
  char              *label;           /* label if any            */

  int               label_length;     /* length of label         */
  int               twidth;           /* label width in pixels   */
  int               theight;          /* label height in pixels  */
  int               ascent;           /*  font ascent            */

  int               width;            /* width of slider         */
  int               length;           /* length of slider        */

  float             var;              /* tracking variable       */
  float             minvalue;         /* min value of slider     */
  float             maxvalue;         /* max value of slider     */
  float             factor;           /* from scrn coor to slider*/
  float             resolution;

  int               sliderposition;   /* center coor of slider   */
  int               sliderpositionmin;/* lowest coor of slider   */
  int               minx, maxx;       /* slider window           */
  int               miny, maxy;
  
  char              format[8];        /* printing format         */

  int               vwidth;           /* value width in pixels   */
  int               vwidtha;          /* value width in pixels   */
  int               vheight;          /* value height            */
  int               sliderlength;     /* length of slider        */  
  int               borderwidth;      /* of the little button    */
  int               spad;

  char              dispvalue;        /* whether disply value    */
  char              borderstyle;      /* of the button           */
  char              widthset;
  char              lengthset;

} EZ_SliderWidget;

#define EZ_SliderLabel(wptr)          ((wptr)->slider.label)
#define EZ_SliderLabelLength(wptr)    ((wptr)->slider.label_length)
#define EZ_SliderFont(wptr)           ((wptr)->common.font)
#define EZ_SliderForeground(wptr)     ((wptr)->common.foreground)
#define EZ_SliderBackground(wptr)     ((wptr)->common.background)
#define EZ_SliderTWidth(wptr)         ((wptr)->slider.twidth)
#define EZ_SliderTHeight(wptr)        ((wptr)->slider.theight)
#define EZ_SliderFontAscent(wptr)     ((wptr)->slider.ascent)
#define EZ_SliderWidth(wptr)          ((wptr)->slider.width)
#define EZ_SliderLength(wptr)         ((wptr)->slider.length)
#define EZ_SliderPosition(wptr)       ((wptr)->slider.sliderposition)
#define EZ_SliderPositionMin(wptr)    ((wptr)->slider.sliderpositionmin)
#define EZ_SliderValue(wptr)          ((wptr)->slider.var)
#define EZ_SliderResolution(wptr)     ((wptr)->slider.resolution)
#define EZ_SliderMinValue(wptr)       ((wptr)->slider.minvalue)
#define EZ_SliderMaxValue(wptr)       ((wptr)->slider.maxvalue)
#define EZ_SliderFactor(wptr)         ((wptr)->slider.factor)
#define EZ_SliderFormat(wptr)         ((wptr)->slider.format)
#define EZ_SliderBorderStyle(wptr)    ((wptr)->slider.borderstyle)
#define EZ_SliderBorderWidth(wptr)    ((wptr)->slider.borderwidth)
#define EZ_SliderDisplayValue(wptr)   ((wptr)->slider.dispvalue)
#define EZ_SliderVWidth(wptr)         ((wptr)->slider.vwidth)
#define EZ_SliderVWidtha(wptr)        ((wptr)->slider.vwidtha)
#define EZ_SliderVHeight(wptr)        ((wptr)->slider.vheight)
#define EZ_SliderSliderLength(wptr)   ((wptr)->slider.sliderlength)
#define EZ_SliderMinx(wptr)           ((wptr)->slider.minx)
#define EZ_SliderMaxx(wptr)           ((wptr)->slider.maxx)
#define EZ_SliderMiny(wptr)           ((wptr)->slider.miny)
#define EZ_SliderMaxy(wptr)           ((wptr)->slider.maxy)
#define EZ_SliderWidthSet(wptr)       ((wptr)->slider.widthset)
#define EZ_SliderLengthSet(wptr)      ((wptr)->slider.lengthset)


/***********************************************************************
 ***                                                                 ***
 ***                     PopupMenu Item: Separator                   ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_MenuSeparator_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  Don't need much for a separator
   *---------------------------------*/
} EZ_MenuSeparator;

/***********************************************************************
 ***                                                                 ***
 ***                     PopupMenu Item: SubMenu                     ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_MenuSubMenu_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  Walkthrough menu
   *---------------------------------*/
  char              *label;           /* text on button          */
  int               label_length;     /* length of label         */
  int               line_length;      /* length of a line        */
  int               nlines;           /* number of lines in label*/
  int               twidth;           /* label width in pixels   */
  int               theight;          /* label height in pixels  */
  int               ascent;           /*  font ascent            */
  int               arrowsize;        /* size of arrow           */
  int               arrowbwidth;      /* borderwidth of arrow    */

  char              *label2;          /* second label, for menu  */
  int               label2_length;    /* length of label2        */
  int               label2_width;     /* length of label2 in pix */
  int               underline;        /* for shortcut character  */
  int               modifiers;        /* menu-shortcut stuff     */
  char              *shortcut;      

  union EZ_WWindow_ *menu;            /* the submenu             */

} EZ_MenuSubMenu;

#define EZ_SubMenuLabel(wptr)        ((wptr)->msubmenu.label)
#define EZ_SubMenuLabelLength(wptr)  ((wptr)->msubmenu.label_length)
#define EZ_SubMenuLineLength(wptr)   ((wptr)->msubmenu.line_length)
#define EZ_SubMenuNLines(wptr)       ((wptr)->msubmenu.nlines)
#define EZ_SubMenuPixmap(wptr)       ((wptr)->common.pixmap)
#define EZ_SubMenuFont(wptr)         ((wptr)->common.font)
#define EZ_SubMenuForeground(wptr)   ((wptr)->common.foreground)
#define EZ_SubMenuBackground(wptr)   ((wptr)->common.background)
#define EZ_SubMenuTWidth(wptr)       ((wptr)->msubmenu.twidth)
#define EZ_SubMenuTHeight(wptr)      ((wptr)->msubmenu.theight)
#define EZ_SubMenuFontAscent(wptr)   ((wptr)->msubmenu.ascent)
#define EZ_SubMenuArrowSize(wptr)    ((wptr)->msubmenu.arrowsize)
#define EZ_SubMenuArrowBWidth(wptr)  ((wptr)->msubmenu.arrowbwidth)
#define EZ_SubMenuTheMenu(wptr)      ((wptr)->msubmenu.menu)

#define EZ_SubMenuLabel2(wptr)         ((wptr)->msubmenu.label2)
#define EZ_SubMenuLabel2Length(wptr)   ((wptr)->msubmenu.label2_length)
#define EZ_SubMenuLabel2Width(wptr)    ((wptr)->msubmenu.label2_width)
#define EZ_SubMenuUnderLine(wptr)      ((wptr)->msubmenu.underline)
#define EZ_SubMenuUnderline(wptr)      ((wptr)->msubmenu.underline)
#define EZ_SubMenuModifiers(wptr)      ((wptr)->msubmenu.modifiers)
#define EZ_SubMenuShortcut(wptr)       ((wptr)->msubmenu.shortcut)

/***********************************************************************
 ***                                                                 ***
 ***                     Popup Menu                                  ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_PopupMenu_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block            */
  union EZ_WWindow_  *lastSelection;    /* last selected menu item */
  /* 6-15-97 */
  int  istearoff;                    
  union EZ_WWindow_  *tearlink;  
  union EZ_WWindow_  *companion;  
  /* tmp links */
  union EZ_WWindow_  *link1;  
  union EZ_WWindow_  *link2;  
} EZ_PopupMenu;

#define EZ_PopupLSItem(wptr)         ((wptr)->popupmenu.lastSelection)
#define EZ_PopupIsTearOff(wptr)      ((wptr)->popupmenu.istearoff)
#define EZ_PopupIsTearLink(wptr)     ((wptr)->popupmenu.tearlink)
#define EZ_PopupCompanion(wptr)      ((wptr)->popupmenu.companion)
#define EZ_PopupLink1(wptr)          ((wptr)->popupmenu.link1)
#define EZ_PopupLink2(wptr)          ((wptr)->popupmenu.link2)

/***********************************************************************
 ***                                                                 ***
 ***                     Tear Off  MenuItem                          ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_MenuTearOffBar_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block            */
  union EZ_WWindow_  *tearedmenu; 
} EZ_MenuTearOffBar;

#define EZ_MenuTearOffBarMenu(wptr)     ((wptr)->tearoffbar.tearedmenu)

/***********************************************************************
 ***                                                                 ***
 ***                     Entry                                       ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_EntryWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  Data for Entry
   *---------------------------------*/
  char              *data;            /* storage for entry       */
  int               data_size;        /* size of data            */

  int               line_length;      /* size in characters      */
  int               twidth;           /* width in pixels         */
  int               theight;          /* font height in pixels   */
  int               ascent;           /* font ascent             */

  int               bgn;              /* begin index, displayed  */
  int               end;              /* end index,              */
  
  unsigned long     selBG;            /* highlight selection     */

  int               selectionbgn;     /* selected text bgn       */
  int               selectionend;     /* selected text end       */

  int               marker;           /* current marker          */

  int               position;         /* current cursor position */
  int               lastchar;         /* number of chars on entry*/

  char              selectionflag; 

  /* for optional entry */
  char              setHistory;       /* remember history ?     */
  char              editable;
  char              secrecy;
  union EZ_WWindow_ *optEntry;        /* is an optional entry ? */ 
  union EZ_WWindow_ *fse;
} EZ_EntryWidget;

#define EZ_EntryData(wptr)             ((wptr)->entry.data)
#define EZ_EntryDataSize(wptr)         ((wptr)->entry.data_size)
#define EZ_EntryForeground(wptr)       ((wptr)->common.foreground)
#define EZ_EntryBackground(wptr)       ((wptr)->common.background)
#define EZ_EntryFont(wptr)             ((wptr)->common.font)
#define EZ_EntryLineLength(wptr)       ((wptr)->entry.line_length)
#define EZ_EntryTWidth(wptr)           ((wptr)->entry.twidth)
#define EZ_EntryTHeight(wptr)          ((wptr)->entry.theight)
#define EZ_EntryFontAscent(wptr)       ((wptr)->entry.ascent)
#define EZ_EntryLastChar(wptr)         ((wptr)->entry.lastchar)
#define EZ_EntryBgnIndex(wptr)         ((wptr)->entry.bgn)
#define EZ_EntryEndIndex(wptr)         ((wptr)->entry.end)
#define EZ_EntryPosition(wptr)         ((wptr)->entry.position)
#define EZ_EntrySelectionBG(wptr)      ((wptr)->entry.selBG)
#define EZ_EntrySelectionBgn(wptr)     ((wptr)->entry.selectionbgn)
#define EZ_EntrySelectionEnd(wptr)     ((wptr)->entry.selectionend)
#define EZ_EntrySelectionFlag(wptr)    ((wptr)->entry.selectionflag)
#define EZ_EntryRemberHistory(wptr)    ((wptr)->entry.setHistory)
#define EZ_EntryEditable(wptr)         ((wptr)->entry.editable)
#define EZ_EntryMarker(wptr)           ((wptr)->entry.marker)
#define EZ_EntryOptEntry(wptr)         ((wptr)->entry.optEntry)
#define EZ_EntryFSE(wptr)              ((wptr)->entry.fse)
#define EZ_EntrySecrecy(wptr)          ((wptr)->entry.secrecy)

/***********************************************************************
 ***                                                                 ***
 ***                  Optional Entry                                 ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_OptEntryWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  Data for OptionalEntry
   *---------------------------------*/
  union EZ_WWindow_ *entry;           /* the associated listbox */
  union EZ_WWindow_ *button;          /* the associated listbox */
  union EZ_WWindow_ *listbox;         /* the associated listbox */
  union EZ_WWindow_ *popup;           /* the popup (parent of listbox) */  
} EZ_OptEntryWidget;

#define EZ_OptEntryEntry(wptr)            ((wptr)->optEntry.entry)
#define EZ_OptEntryButton(wptr)           ((wptr)->optEntry.button)
#define EZ_OptEntryListbox(wptr)          ((wptr)->optEntry.listbox)
#define EZ_OptEntryPopup(wptr)            ((wptr)->optEntry.popup)

/***********************************************************************
 ***                                                                 ***
 ***                  File Selector                                  ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_FileSelector_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  Data for Entry
   *---------------------------------*/
  union EZ_WWindow_ *patternEntry;    /* optional entries  */
  union EZ_WWindow_ *selectionEntry; 
  union EZ_WWindow_ *dirListbox;      /* the two listboxes */
  union EZ_WWindow_ *fileListbox;
  union EZ_WWindow_ *okButton;        /* a few buttons     */
  union EZ_WWindow_ *filterButton;
  union EZ_WWindow_ *cancelButton;
  char              *currentDir;      /* current Directory */
  char              **selection;      /* pointer to the current Selection */

} EZ_FileSelector;

#define EZ_FileSelectorPatternEntry(wptr)            ((wptr)->fileSelector.patternEntry)
#define EZ_FileSelectorSelectionEntry(wptr)          ((wptr)->fileSelector.selectionEntry)
#define EZ_FileSelectorDirListbox(wptr)              ((wptr)->fileSelector.dirListbox)
#define EZ_FileSelectorFileListbox(wptr)             ((wptr)->fileSelector.fileListbox)
#define EZ_FileSelectorOkButton(wptr)                ((wptr)->fileSelector.okButton)
#define EZ_FileSelectorFilterButton(wptr)            ((wptr)->fileSelector.filterButton)
#define EZ_FileSelectorCancelButton(wptr)            ((wptr)->fileSelector.cancelButton)
#define EZ_FileSelectorCurrentDirectory(wptr)        ((wptr)->fileSelector.currentDir)
#define EZ_FileSelectorCurrentSelection(wptr)        ((wptr)->fileSelector.selection)

/***********************************************************************
 ***                                                                 ***
 ***                     3D Canvas                                   ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_3D_Canvas_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  3D Canvas.
   *---------------------------------*/
  char              releaseMbutton;   /* whether reserve Menu button   */        
  char              backing_store;    /* whether to use X's b-store */
  char              pad1;
  char              pad2;
  
  unsigned long     borderbg;         /* border background color    */
  EZ_GL_Context     *glcontext;       /* the graphics context       */
} EZ_3D_Canvas;

#define EZ_3DCanvasBorderBackground(wptr)     ((wptr)->threedcanvas.borderbg)
#define EZ_3DCanvasReleaseMenuButton(wptr)    ((wptr)->threedcanvas.releaseMbutton)
#define EZ_3DCanvasBackingStore(wptr)         ((wptr)->threedcanvas.backing_store)
#define EZ_3DCanvasGLContext(wptr)            ((wptr)->threedcanvas.glcontext)

/***********************************************************************
 ***                                                                 ***
 ***                Widget Internal List Box                         ***
 ***                                                                 ***
 ***********************************************************************/
typedef struct listboxentry_ {
  int   length;
  char  *data;
} listboxentry;

typedef struct EZ_IListBoxWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  Data for list box
   *---------------------------------*/
  
  int               theight;          /* font height in pixels   */
  int               ascent;           /* font ascent             */
  unsigned long     textbg;           /* bg for main window      */
  unsigned long     selectionBG;      /* highlight selection     */
  /*
   * vertical dimension setup. Measurement in lines, borderwidth
   * excluded. These are also needed to update the V scrollbar.
   */
  int               nlines;           /* total # of lines        */
  int               pagesize;         /* # of lines in a page    */
  int               first;            /* first line in display   */
  int               last;             /* last line in display    */

  /*
   * horizontal dim setup. Measurement are in pixels, 
   * excluding borderwidth. (X clip objects to its windows anyway)
   * These info are not needed for IListBox, they are needed to
   * update the H scrollbar if any.
   */
  int               maximalHsize;     /* maximal h size in page  */
  int               pageHsize;        /* window width - border   */
  int               Hstart;           /* h offset                */

  int               sline;            /* current selected line   */
  int               allocatedsize;    /* # of entries allocated  */
  listboxentry      *data;            /* the list                */
  union EZ_WWindow_ *listbox; 
  union EZ_WWindow_ *hscroll; 
  union EZ_WWindow_ *vscroll; 
  /* for when used as a special popup, in optional entry */
  union EZ_WWindow_ *optEntry;       /* the optional Entry      */
  union EZ_WWindow_ *fsl;            /* the optional Entry      */
  int               slineEnd;       /*  */
  char              takeMotion;
  char              callbackOnRelease; /* release cause callback ? */
} EZ_IListBoxWidget;


#define  EZ_IListBoxMaxHSize(wptr)   ((wptr)->ilistbox.maximalHsize)
#define  EZ_IListBoxHPageSize(wptr)  ((wptr)->ilistbox.pageHsize)
#define  EZ_IListBoxHStart(wptr)     ((wptr)->ilistbox.Hstart)
#define  EZ_IListBoxHScroll(wptr)    ((wptr)->ilistbox.hscroll)
#define  EZ_IListBoxVScroll(wptr)    ((wptr)->ilistbox.vscroll)
#define  EZ_IListBoxListBox(wptr)    ((wptr)->ilistbox.listbox)
#define  EZ_IListBoxTextBG(wptr)     ((wptr)->ilistbox.textbg)
#define  EZ_IListBoxSelectionBG(wptr)   ((wptr)->ilistbox.selectionBG)

#define  EZ_IListBoxForeground(wptr) ((wptr)->common.foreground)
#define  EZ_IListBoxBackground(wptr) ((wptr)->common.background)
#define  EZ_IListBoxFont(wptr)       ((wptr)->common.font)
#define  EZ_IListBoxTHeight(wptr)    ((wptr)->ilistbox.theight)
#define  EZ_IListBoxWidth(wptr)      ((wptr)->ilistbox.width)
#define  EZ_IListBoxHeight(wptr)     ((wptr)->ilistbox.height)
#define  EZ_IListBoxFontAscent(wptr) ((wptr)->ilistbox.ascent)

#define  EZ_IListBoxNLines(wptr)     ((wptr)->ilistbox.nlines)
#define  EZ_IListBoxSLine(wptr)      ((wptr)->ilistbox.sline)
#define  EZ_IListBoxSLineEnd(wptr)   ((wptr)->ilistbox.slineEnd)
#define  EZ_IListBoxFirstLine(wptr)  ((wptr)->ilistbox.first)
#define  EZ_IListBoxVStart(wptr)     ((wptr)->ilistbox.first)
#define  EZ_IListBoxLastLine(wptr)   ((wptr)->ilistbox.last)
#define  EZ_IListBoxData(wptr)       ((wptr)->ilistbox.data)
#define  EZ_IListBoxSpace(wptr)      ((wptr)->ilistbox.allocatedsize)
#define  EZ_IListBoxPageSize(wptr)   ((wptr)->ilistbox.pagesize)
#define  EZ_IListBoxMotionCallBack(wptr)   ((wptr)->common.motionCallbacks)
#define  EZ_IListBoxTakeMotion(wptr)    ((wptr)->ilistbox.takeMotion)
#define  EZ_IListBoxCallBackOnRelease(wptr)    ((wptr)->ilistbox.callbackOnRelease)

#define  EZ_IListBoxOptEntry(wptr)   ((wptr)->ilistbox.optEntry)
#define  EZ_IListBoxFSL(wptr)        ((wptr)->ilistbox.fsl)

/***********************************************************************
 ***                                                                 ***
 ***                Widget List Box                                  ***
 ***                                                                 ***
 ***********************************************************************/
typedef struct EZ_ListBoxWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  Data for list box
   *---------------------------------*/
  union EZ_WWindow_ *Tframe; 
  union EZ_WWindow_ *ilistbox; 
  union EZ_WWindow_ *hscroll; 
  union EZ_WWindow_ *vscroll; 

} EZ_ListBoxWidget;

#define  EZ_ListBoxTFrame(wptr)     ((wptr)->listbox.Tframe)
#define  EZ_ListBoxIListBox(wptr)   ((wptr)->listbox.ilistbox)
#define  EZ_ListBoxHScroll(wptr)    ((wptr)->listbox.hscroll)
#define  EZ_ListBoxVScroll(wptr)    ((wptr)->listbox.vscroll)
#define  EZ_ListBoxFont(wptr)       EZ_IListBoxFont((wptr)->listbox.ilistbox)
#define  EZ_ListBoxTHeight(wptr)    EZ_IListBoxTHeight((wptr)->listbox.ilistbox)
#define  EZ_ListBoxFontAscent(wptr) EZ_IListBoxFontAscent((wptr)->listbox.ilistbox)
#define  EZ_ListBoxNLines(wptr)     EZ_IListBoxNLines((wptr)->listbox.ilistbox)
#define  EZ_ListBoxSLine(wptr)      EZ_IListBoxSLine((wptr)->listbox.ilistbox)
#define  EZ_ListBoxFirstLine(wptr)  EZ_IListBoxFirstLine((wptr)->listbox.ilistbox)
#define  EZ_ListBoxLastLine(wptr)   EZ_IListBoxLastLine((wptr)->listbox.ilistbox)
#define  EZ_ListBoxData(wptr)       EZ_IListBoxData((wptr)->listbox.ilistbox)
#define  EZ_ListBoxSpace(wptr)      EZ_IListBoxSpace((wptr)->listbox.ilistbox)
#define  EZ_ListBoxPageSize(wptr)   EZ_IListBoxPageSize((wptr)->listbox.ilistbox)
#define  EZ_ListBoxMotionCallBack(wptr)   EZ_IListBoxMotionCallBack((wptr)->listbox.ilistbox)
#define  EZ_ListBoxCallBackOnRelease(wptr) EZ_IListBoxCallBackOnRelease((wptr)->listbox.ilistbox)

#define  EZ_ListBoxOptEntry(wptr)   EZ_IListBoxOptEntry((wptr)->listbox.ilistbox)
#define  EZ_ListBoxFSL(wptr)        EZ_IListBoxFSL((wptr)->listbox.ilistbox)
/***********************************************************************
 ***                                                                 ***
 ***                     Widget Scrollbar                            ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_ScrollbarWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  Data for Scrollbar
   *---------------------------------*/
  union EZ_WWindow_ *object;          /* widget to bind to       */
  int               borderwidth;      /* button border width     */
  int               bordertype;       /* button border style     */
  int               bgn;              /* lowest position of top/left edge  */
  int               end;              /* highest position of bottom/right  */
  int               position;         /* current position of top/left edge */
  int               arrowsize;        /* arrow_size = ssize + bw*2 */
  int               ssize;            /* width, cpted dynamically  */
  int               lsize;            /* height, computed          */

  char              arrow1highlight;
  char              arrow2highlight;
  char              arrow1borderstyle;
  char              arrow2borderstyle;

  char              dirty;            /* need to recalculate size etc */
  char              pada,padb,padc;
  /*
   * these are the informations need to setup the scroll.
   */
  int               totalsize;        /* the total size of ...  */
  int               pagesize;         /* page size              */
  int               beginObj;         /* top line or ..,        */
  int               endObj;           /* bottom line or         */

  float             fincrement;       /* scroll increment       */
  int               iincrement;

} EZ_ScrollbarWidget;

#define EZ_ScrollObject(wptr)        ((wptr)->scrollbar.object)
#define EZ_ScrollForeground(wptr)    ((wptr)->common.foreground)
#define EZ_ScrollBackground(wptr)    ((wptr)->common.background)
#define EZ_ScrollBorderWidth(wptr)   ((wptr)->scrollbar.borderwidth)
#define EZ_ScrollBorderStyle(wptr)   ((wptr)->scrollbar.bordertype)
#define EZ_ScrollArrowSize(wptr)     ((wptr)->scrollbar.arrowsize)
#define EZ_ScrollSSize(wptr)         ((wptr)->scrollbar.ssize)
#define EZ_ScrollLSize(wptr)         ((wptr)->scrollbar.lsize)
#define EZ_ScrollPosition(wptr)      ((wptr)->scrollbar.position)
#define EZ_ScrollBgnPosition(wptr)   ((wptr)->scrollbar.bgn)
#define EZ_ScrollEndPosition(wptr)   ((wptr)->scrollbar.end)
#define EZ_ScrollAW1Highlight(wptr)  ((wptr)->scrollbar.arrow1highlight)
#define EZ_ScrollAW2Highlight(wptr)  ((wptr)->scrollbar.arrow2highlight)
#define EZ_ScrollAW1BorderStyle(wptr) ((wptr)->scrollbar.arrow1borderstyle)
#define EZ_ScrollAW2BorderStyle(wptr) ((wptr)->scrollbar.arrow2borderstyle)

#define EZ_ScrollTotalSize(wptr)     ((wptr)->scrollbar.totalsize)
#define EZ_ScrollPageSize(wptr)      ((wptr)->scrollbar.pagesize)
#define EZ_ScrollObjectBegin(wptr)   ((wptr)->scrollbar.beginObj)
#define EZ_ScrollObjectEnd(wptr)     ((wptr)->scrollbar.endObj)
#define EZ_ScrollFIncrement(wptr)    ((wptr)->scrollbar.fincrement)
#define EZ_ScrollIIncrement(wptr)    ((wptr)->scrollbar.iincrement)
#define EZ_ScrollDirty(wptr)         ((wptr)->scrollbar.dirty)

/***********************************************************************
 ***                                                                 ***
 ***                     Widget Internal Text                        ***
 ***                                                                 ***
 ***********************************************************************/
#include "EZ_Text.h"

typedef struct EZ_ITextWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  Data for TextWidget
   *---------------------------------*/
  int               theight;          /* font height in pixels   */
  int               ascent;           /* font ascent             */

  union EZ_WWindow_ *hscroll;         /* scroll bars             */
  union EZ_WWindow_ *vscroll; 
  union EZ_WWindow_ *textW;           /* textwidget assoc. to    */
  unsigned long      textbg;
  unsigned long      selectionBG;     /* highlight selection     */

  int               numlines;         /* total # of lines of text*/
  int               first;            /* the 1st line on display */
  int               last;             /* last line on display    */

  int               maxHSize;         /* maximum line length, in pixels */
  int               pageHSize;        /* x width, width - border */
  int               Hstart;           /* starting X offset       */

  int               yposition;        /* cursor line             */
  int               xposition;        /* cursor position         */
  int               lxpos;            /*  */
  int               xmark;            /* current marker          */
  int               ymark;

  int               selectionYbgn;
  int               selectionYend;
  int               selectionXbgn;
  int               selectionXend;

  ITextLine         **data;
  int                allocatedlines;
  int                vspacing;

  char              selectionFlag;
  char              editable;
  char              hscroll_in_action;
  char              lastcmdiskill;    /* keep track of C-k */

} EZ_ITextWidget;

#define EZ_ITextForeground(wptr)        ((wptr)->common.foreground)
#define EZ_ITextBackground(wptr)        ((wptr)->common.background)
#define EZ_ITextFont(wptr)              ((wptr)->common.font)
#define EZ_ITextTHeight(wptr)           ((wptr)->itext.theight)
#define EZ_ITextFontAscent(wptr)        ((wptr)->itext.ascent)
#define EZ_ITextTextBG(wptr)            ((wptr)->itext.textbg)
#define EZ_ITextTextSelectionBG(wptr)   ((wptr)->itext.selectionBG)
#define EZ_ITextVSpacing(wptr)          ((wptr)->itext.vspacing)

#define EZ_ITextTextWidget(wptr)        ((wptr)->itext.textW)
#define EZ_ITextHScroll(wptr)           ((wptr)->itext.hscroll)
#define EZ_ITextVScroll(wptr)           ((wptr)->itext.vscroll)

#define EZ_ITextMaxHSize(wptr)          ((wptr)->itext.maxHSize)
#define EZ_ITextHPageSize(wptr)         ((wptr)->itext.pageHSize)
#define EZ_ITextHStart(wptr)            ((wptr)->itext.Hstart)

#define EZ_ITextSpace(wptr)             ((wptr)->itext.allocatedlines)
#define EZ_ITextData(wptr)              ((wptr)->itext.data)

#define EZ_ITextXPosition(wptr)         ((wptr)->itext.xposition)
#define EZ_ITextYPosition(wptr)         ((wptr)->itext.yposition)
#define EZ_ITextLXPosition(wptr)        ((wptr)->itext.lxpos)

#define EZ_ITextXMark(wptr)             ((wptr)->itext.xmark)
#define EZ_ITextYMark(wptr)             ((wptr)->itext.ymark)

#define EZ_ITextSelectionYBgn(wptr)     ((wptr)->itext.selectionYbgn)
#define EZ_ITextSelectionYEnd(wptr)     ((wptr)->itext.selectionYend)
#define EZ_ITextSelectionXBgn(wptr)     ((wptr)->itext.selectionXbgn)
#define EZ_ITextSelectionXEnd(wptr)     ((wptr)->itext.selectionXend)
#define EZ_ITextSelectionFlag(wptr)     ((wptr)->itext.selectionFlag)

#define EZ_ITextEditable(wptr)          ((wptr)->itext.editable)
#define EZ_ITextHScrollInAction(wptr)   ((wptr)->itext.hscroll_in_action)
#define EZ_ITextLastCmdIsKill(wptr)     ((wptr)->itext.lastcmdiskill)

#define EZ_ITextNLines(wptr)            ((wptr)->itext.numlines)
#define EZ_ITextVStart(wptr)            ((wptr)->itext.first)
#define EZ_ITextFirstLine(wptr)         ((wptr)->itext.first)
#define EZ_ITextLastLine(wptr)          ((wptr)->itext.last)
#define EZ_ITextPageSize(wptr)          (((wptr)->itext.last) - ((wptr)->itext.first) + 1)


/***********************************************************************
 ***                                                                 ***
 ***                     Widget Text                                 ***
 ***                                                                 ***
 ***********************************************************************/
typedef struct EZ_TextWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  Data for Text
   *---------------------------------*/
  union EZ_WWindow_ *Tframe; 
  union EZ_WWindow_ *itext; 
  union EZ_WWindow_ *hscroll; 
  union EZ_WWindow_ *vscroll; 

} EZ_TextWidget;

#define  EZ_TextTFrame(wptr)     ((wptr)->text.Tframe)
#define  EZ_TextIText(wptr)      ((wptr)->text.itext)
#define  EZ_TextHScroll(wptr)    ((wptr)->text.hscroll)
#define  EZ_TextVScroll(wptr)    ((wptr)->text.vscroll)
#define  EZ_TextFont(wptr)       EZ_ITextFont((wptr)->text.itext)
#define  EZ_TextTHeight(wptr)    EZ_ITextTHeight((wptr)->text.itext)
#define  EZ_TextFontAscent(wptr) EZ_ITextFontAscent((wptr)->text.itext)
#define  EZ_TextNLines(wptr)     EZ_ITextNLines((wptr)->text.itext)
#define  EZ_TextFirstLine(wptr)  EZ_ITextFirstLine((wptr)->text.itext)
#define  EZ_TextLastLine(wptr)   EZ_ITextLastLine((wptr)->text.itext)
#define  EZ_TextData(wptr)       EZ_ITextData((wptr)->text.itext)
#define  EZ_TextPageSize(wptr)   EZ_ITextPageSize((wptr)->text.itext)


/***********************************************************************
 ***                                                                 ***
 ***                     Widget NoteBook Page                        ***
 ***                                                                 ***
 ***********************************************************************/
typedef struct EZ_NBPageWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------------------------------------
   *  Data for notebook data, just like a regular frame
   *-------------------------------------------------------------*/

  int               brokenBdXStart;   /* the piece of bd which   */
  int               brokenBdLength;   /* will not be displayed   */
  union EZ_WWindow_ *notebook;        /* notebook this belongs to*/
  union EZ_WWindow_ *companion;       /* special companion widget*/

} EZ_NBPage;

#define EZ_NBPageNoteBook(wptr)          ((wptr)->nbpage.notebook)
#define EZ_NBPageCompanion(wptr)         ((wptr)->nbpage.companion)

#define EZ_NBPageBrokenBdXBgn(wptr)      ((wptr)->nbpage.brokenBdXStart)
#define EZ_NBPageBrokenBdLength(wptr)    ((wptr)->nbpage.brokenBdLength)

#define EZ_NBPageBackground(wptr)        ((wptr)->common.background) 
#define EZ_NBPageForeground(wptr)        ((wptr)->common.foreground) 
#define EZ_NBPageFont(wptr)              ((wptr)->common.font)

/***********************************************************************
 ***                                                                 ***
 ***                     Widget NoteBook(hack)                       ***
 ***                                                                 ***
 ***********************************************************************/
typedef struct EZ_NoteBookWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  /*----------------------------------
   *  Data for NoteBook.
   *---------------------------------*/
  union EZ_WWindow_ *Frame; 
  union EZ_WWindow_ *TFrame;
  union EZ_WWindow_ *BFrame;
  union EZ_WWindow_ *ActivePage;
  int   maxMinW;
  int   maxMinH;

} EZ_NoteBook;

#define  EZ_NoteBookForeground(wptr)   ((wptr)->common.foreground)
#define  EZ_NoteBookBackground(wptr)   ((wptr)->common.background)
#define  EZ_NoteBookFont(wptr)         ((wptr)->common.font)
#define  EZ_NoteBookFrame(wptr)        ((wptr)->notebook.Frame)
#define  EZ_NoteBookTFrame(wptr)       ((wptr)->notebook.TFrame)
#define  EZ_NoteBookBFrame(wptr)       ((wptr)->notebook.BFrame)
#define  EZ_NoteBookActivePage(wptr)   ((wptr)->notebook.ActivePage)
#define  EZ_NoteBookMaxMinWidth(wptr)  ((wptr)->notebook.maxMinW)
#define  EZ_NoteBookMaxMinHeight(wptr) ((wptr)->notebook.maxMinH)

/***********************************************************************
 ***                                                                 ***
 ***                     Widget PaneHandle                           ***
 ***                                                                 ***
 ***********************************************************************/
typedef struct EZ_PaneHandle_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  int orien;
} EZ_PaneHandle;
#define EZ_PaneHandleOrientation(wptr) ((wptr)->panehandle.orien)

/***********************************************************************
 ***                                                                 ***
 ***                     Widget Embeder                              ***
 ***                                                                 ***
 ***********************************************************************/
typedef struct EZ_Embeder_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  int  confirmed;                       /* has been confirmed ?  */
  int  x, y;                            /* position of the embeded window */
  int  minW, minH;                      /* min dimension of embeded appl  */
  int  width, height;                   /* actual dimen of the embeded win*/
  Window commu;                         /* commu win for external application */
  Window win;                           /* the embeded window    */
  unsigned long widgetAddr;             /* the embeded widget addr  */
  unsigned long  time;                  /* init time of the embeded appl  */

  /* for executor */
  char *command;                        /* the command               */
  char *cargs;                          /* command args              */
  int  pW, pH;                          /* previous size of executor */
  int  mayBeDirty;                      /* size of the embeded window may 
					 * have been changed */
  int depth;                            /* depth of this embeding    */
} EZ_Embeder;

#define EZ_EmbederConfirmed(wptr)      ((wptr)->Embeder.confirmed)
#define EZ_EmbederCommuWin(wptr)       ((wptr)->Embeder.commu)
#define EZ_EmbederWin(wptr)            ((wptr)->Embeder.win)
#define EZ_EmbederId(wptr)             ((wptr)->Embeder.time)
#define EZ_EmbederX(wptr)              ((wptr)->Embeder.x)
#define EZ_EmbederY(wptr)              ((wptr)->Embeder.y)
#define EZ_EmbederWidgetAddr(wptr)     ((wptr)->Embeder.widgetAddr)
#define EZ_EmbederWidth(wptr)          ((wptr)->Embeder.width)
#define EZ_EmbederHeight(wptr)         ((wptr)->Embeder.height)
#define EZ_EmbederCommand(wptr)        ((wptr)->Embeder.command)

#define EZ_ExecutorCommand(wptr)       ((wptr)->Embeder.command)
#define EZ_ExecutorCommandArgs(wptr)   ((wptr)->Embeder.cargs)
#define EZ_ExecutorPreviousW(wptr)     ((wptr)->Embeder.pW)
#define EZ_ExecutorPreviousH(wptr)     ((wptr)->Embeder.pH)
#define EZ_ExecutorMinW(wptr)          ((wptr)->Embeder.minW)
#define EZ_ExecutorMinH(wptr)          ((wptr)->Embeder.minH)
#define EZ_ExecutorMayBeDirty(wptr)    ((wptr)->Embeder.mayBeDirty)
#define EZ_ExecutorDepth(wptr)         ((wptr)->Embeder.depth)


/***********************************************************************
 ***                                                                 ***
 ***                  Internal Tree                                  ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_ITreeWidget_ { 
  char common[sizeof(EZ_WidgetCommon)]; /* common block     */

  EZ_TreeNode         *root;            /* root node        */
  EZ_TreeNode         *selection;       /* the selected item */
  unsigned long       highlightBG; 
  unsigned long       highlightFG; 
  unsigned long       textBG;          /* window background */

  int                 Ysize;          /* size in the vert dir */
  int                 Ypagesize;      /* window height - border - padY */
  int                 Ystart;         /* start pos of display   */

  int                 Xsize;          /* maximal h size in page  */
  int                 Xpagesize;      /* window width - border   */
  int                 Xstart;         /* h offset                */

  union EZ_WWindow_   *hscroll; 
  union EZ_WWindow_   *vscroll; 
  union EZ_WWindow_   *tree;          /* parent: WIDGET_TREE */

  int                 indent;         /* indentation and spacing ?*/
  int                 spacing;     
  char                drawEdge;
  char                treetype;
  char                displayed;
  char                cpad;

} EZ_ITreeWidget;


#define EZ_ITreeWRoot(wptr)               ((wptr)->itree.root)
#define EZ_ITreeWSelection(wptr)          ((wptr)->itree.selection)
#define EZ_ITreeWMotionCallBack(wptr)     ((wptr)->common.motionCallbacks)
#define EZ_ITreeWHighlightBG(wptr)        ((wptr)->itree.highlightBG)
#define EZ_ITreeWHighlightFG(wptr)        ((wptr)->itree.highlightFG)
#define EZ_ITreeWTextBG(wptr)             ((wptr)->itree.textBG)
#define EZ_ITreeWDisplayed(wptr)          ((wptr)->itree.displayed)

#define EZ_ITreeWYSize(wptr)              ((wptr)->itree.Ysize)
#define EZ_ITreeWYPageSize(wptr)          ((wptr)->itree.Ypagesize)
#define EZ_ITreeWYStart(wptr)             ((wptr)->itree.Ystart)

#define EZ_ITreeWXSize(wptr)              ((wptr)->itree.Xsize)
#define EZ_ITreeWXPageSize(wptr)          ((wptr)->itree.Xpagesize)
#define EZ_ITreeWXStart(wptr)             ((wptr)->itree.Xstart)

#define EZ_ITreeWHScroll(wptr)            ((wptr)->itree.hscroll)
#define EZ_ITreeWVScroll(wptr)            ((wptr)->itree.vscroll)
#define EZ_ITreeWTree(wptr)               ((wptr)->itree.tree)

/*****************************************************************************/
typedef struct EZ_TreeWidget_ { 
  char common[sizeof(EZ_WidgetCommon)]; /* common block     */

  union EZ_WWindow_ *Tframe; 
  union EZ_WWindow_ *itree; 
  union EZ_WWindow_ *hscroll; 
  union EZ_WWindow_ *vscroll; 
} EZ_TreeWidget;

#define EZ_TreeWTFrame(wptr)                    ((wptr)->tree.Tframe)
#define EZ_TreeWITree(wptr)                     ((wptr)->tree.itree)
#define EZ_TreeWHScroll(wptr)                   ((wptr)->tree.hscroll)
#define EZ_TreeWVScroll(wptr)                   ((wptr)->tree.vscroll)

/* from ITree */
#define EZ_TreeWIndentation(wptr)       EZ_ITreeWIndentation((wptr)->tree.itree)
#define EZ_TreeWSpacing(wptr)           EZ_ITreeWSpacing((wptr)->tree.itree)
#define EZ_TreeWRoot(wptr)               EZ_ITreeWRoot((wptr)->tree.itree)
#define EZ_TreeWSelection(wptr)          EZ_ITreeWSelection((wptr)->tree.itree)
#define EZ_TreeWMotionCallBack(wptr)     EZ_ITreeWMotionCallBack((wptr)->tree.itree)
#define EZ_TreeWHighlightBG(wptr)        EZ_ITreeWHighlightBG((wptr)->tree.itree)
#define EZ_TreeWHighlightFG(wptr)        EZ_ITreeWHighlightFG((wptr)->tree.itree)
#define EZ_TreeWYSize(wptr)              EZ_ITreeWYSize((wptr)->tree.itree)
#define EZ_TreeWYPageSize(wptr)          EZ_ITreeWYPageSize((wptr)->tree.itree)
#define EZ_TreeWYStart(wptr)             EZ_ITreeWYStart((wptr)->tree.itree)
#define EZ_TreeWXSize(wptr)              EZ_ITreeWXSize((wptr)->tree.itree)
#define EZ_TreeWXPageSize(wptr)          EZ_ITreeWXPageSize((wptr)->tree.itree)
#define EZ_TreeWXStart(wptr)             EZ_ITreeWXStart((wptr)->tree.itree)
#define EZ_TreeWTreeType(wptr)           EZ_ITreeWTreeType((wptr)->tree.itree)

/***********************************************************************
 ***                                                                 ***
 ***                  Internal FancyListBox                          ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_IFancyListBox_ { 
  char common[sizeof(EZ_WidgetCommon)]; /* common block     */

  int                 columns;          /* number of columns */
  int                 rows;             /* n rows */
  int                 allocatedspace;   /* total allocated storage */
  int                 selectionIDX;     /* the selection (row)     */
  int                 selectionCol;     /* the selection (col)     */

  char                selectionType;
  char                dirty;
  char                displayed;
  char                cpad;

  EZ_Item             ***data;           /* the selected item  */
  int                 *hsizes;           /* size of columns  */
  int                 *vsizes;           /* size of the rows */

  unsigned long       highlightBG; 
  unsigned long       highlightFG; 
  unsigned long       textBG;          /* window background */

  int                 Ysize;          /* size in the vert dir */
  int                 Ypagesize;      /* window height - border - padY */
  int                 Ystart;         /* start pos of display   */

  int                 Xsize;          /* maximal h size in page  */
  int                 Xpagesize;      /* window width - border   */
  int                 Xstart;         /* h offset                */

  union EZ_WWindow_   *hscroll; 
  union EZ_WWindow_   *vscroll; 
  union EZ_WWindow_   *flistbox;         /* parent: WIDGET_FANCY_LIST_BOX */

} EZ_IFancyListBox;

#define EZ_IFListBoxDisplayed(wptr)        ((wptr)->iflistbox.displayed)
#define EZ_IFListBoxColumns(wptr)          ((wptr)->iflistbox.columns)
#define EZ_IFListBoxRows(wptr)             ((wptr)->iflistbox.rows)
#define EZ_IFListBoxSpace(wptr)            ((wptr)->iflistbox.allocatedspace)
#define EZ_IFListBoxSelectionIDX(wptr)     ((wptr)->iflistbox.selectionIDX)
#define EZ_IFListBoxSelectionIDX2(wptr)    ((wptr)->iflistbox.selectionIDX2)
#define EZ_IFListBoxSelectionCol(wptr)     ((wptr)->iflistbox.selectionCol)
#define EZ_IFListBoxSelectionCol2(wptr)    ((wptr)->iflistbox.selectionCol2)
#define EZ_IFListBoxData(wptr)             ((wptr)->iflistbox.data)
#define EZ_IFListBoxHighlightBG(wptr)      ((wptr)->iflistbox.highlightBG)
#define EZ_IFListBoxHighlightFG(wptr)      ((wptr)->iflistbox.highlightFG)
#define EZ_IFListBoxTextBG(wptr)           ((wptr)->iflistbox.textBG)
#define EZ_IFListBoxXSize(wptr)            ((wptr)->iflistbox.Xsize)
#define EZ_IFListBoxXPageSize(wptr)        ((wptr)->iflistbox.Xpagesize)
#define EZ_IFListBoxXStart(wptr)           ((wptr)->iflistbox.Xstart)
#define EZ_IFListBoxYSize(wptr)            ((wptr)->iflistbox.Ysize)
#define EZ_IFListBoxYPageSize(wptr)        ((wptr)->iflistbox.Ypagesize)
#define EZ_IFListBoxYStart(wptr)           ((wptr)->iflistbox.Ystart)

#define EZ_IFListBoxDirty(wptr)            ((wptr)->iflistbox.dirty)
#define EZ_IFListBoxHSizes(wptr)            ((wptr)->iflistbox.hsizes)
#define EZ_IFListBoxVSizes(wptr)            ((wptr)->iflistbox.vsizes)

#define EZ_IFListBoxHScroll(wptr)          ((wptr)->iflistbox.hscroll)
#define EZ_IFListBoxVScroll(wptr)          ((wptr)->iflistbox.vscroll)
#define EZ_IFListBoxFListBox(wptr)         ((wptr)->iflistbox.flistbox)
#define EZ_IFListBoxMotionCallBack(wptr)   ((wptr)->common.motionCallbacks)
#define EZ_IFListBoxSelectionType(wptr)    ((wptr)->iflistbox.selectionType)
#define EZ_IFListBoxSItem(wptr)            ((wptr)->iflistbox.sitem)

typedef struct EZ_FancyListBox_ { 
  char common[sizeof(EZ_WidgetCommon)]; /* common block     */

  union EZ_WWindow_ *Tframe; 
  union EZ_WWindow_ *iflistbox; 
  union EZ_WWindow_ *hscroll; 
  union EZ_WWindow_ *vscroll; 
} EZ_FancyListBox;

#define EZ_FListBoxTFrame(wptr)                    ((wptr)->flistbox.Tframe)
#define EZ_FListBoxIFListBox(wptr)                 ((wptr)->flistbox.iflistbox)
#define EZ_FListBoxHScroll(wptr)                   ((wptr)->flistbox.hscroll)
#define EZ_FListBoxVScroll(wptr)                   ((wptr)->flistbox.vscroll)


/***********************************************************************
 ***                                                                 ***
 ***                  Work Area                                      ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_IWorkArea_ { 
  char common[sizeof(EZ_WidgetCommon)]; /* common block     */

  EZ_Item             **items;           /* an array of items */
  EZ_Item             *sitem;            /* selected item     */

  int                 nitems;            /* total number of items */
  int                 space;             /* allocated size of items */

  unsigned long       highlightBG; 
  unsigned long       highlightFG; 
  unsigned long       textBG;          /* window background */

  int                 Ysize;          /* size in the vert dir */
  int                 Ypagesize;      /* window height - border - padY */
  int                 Ystart;         /* start pos of display   */

  int                 Xsize;          /* maximal h size in page  */
  int                 Xpagesize;      /* window width - border   */
  int                 Xstart;         /* h offset                */

  union EZ_WWindow_   *hscroll; 
  union EZ_WWindow_   *vscroll; 
  union EZ_WWindow_   *workArea;

  char                dirty;
  char                dpyed;
  char                movable;
  char                drawn;

  /* this is reserved for geometry manager */
  void                *GMData;
  EZ_WorkAreaGeometryManager    geometryManager;

} EZ_IWorkArea;

#define EZ_IWorkAreaData(wptr)             ((wptr)->iworkArea.items)
#define EZ_IWorkAreaSelection(wptr)        ((wptr)->iworkArea.sitem)
#define EZ_IWorkAreaNItems(wptr)           ((wptr)->iworkArea.nitems)
#define EZ_IWorkAreaDataSpace(wptr)        ((wptr)->iworkArea.space)
#define EZ_IWorkAreaHighlightBG(wptr)      ((wptr)->iworkArea.highlightBG)
#define EZ_IWorkAreaHighlightFG(wptr)      ((wptr)->iworkArea.highlightFG)
#define EZ_IWorkAreaTextBG(wptr)           ((wptr)->iworkArea.textBG)

#define EZ_IWorkAreaDirty(wptr)             ((wptr)->iworkArea.dirty)

#define EZ_IWorkAreaYSize(wptr)            ((wptr)->iworkArea.Ysize)
#define EZ_IWorkAreaYPageSize(wptr)        ((wptr)->iworkArea.Ypagesize)
#define EZ_IWorkAreaYStart(wptr)           ((wptr)->iworkArea.Ystart)

#define EZ_IWorkAreaXSize(wptr)            ((wptr)->iworkArea.Xsize)
#define EZ_IWorkAreaXPageSize(wptr)        ((wptr)->iworkArea.Xpagesize)
#define EZ_IWorkAreaXStart(wptr)           ((wptr)->iworkArea.Xstart)

#define EZ_IWorkAreaHScroll(wptr)          ((wptr)->iworkArea.hscroll)
#define EZ_IWorkAreaVScroll(wptr)          ((wptr)->iworkArea.vscroll)

#define EZ_IWorkAreaWorkArea(wptr)         ((wptr)->iworkArea.workArea)
#define EZ_IWorkAreaGeometryManager(wptr)  ((wptr)->iworkArea.geometryManager)
#define EZ_IWorkAreaGMData(wptr)           ((wptr)->iworkArea.GMData)
#define EZ_IWorkAreaDisplayed(wptr)        ((wptr)->iworkArea.dpyed)
#define EZ_IWorkAreaDrawn(wptr)            ((wptr)->iworkArea.drawn)
#define EZ_IWorkAreaItemMovable(wptr)      ((wptr)->iworkArea.movable)


typedef struct EZ_WorkArea_ { 
  char common[sizeof(EZ_WidgetCommon)]; /* common block     */

  union EZ_WWindow_   *Tframe;
  union EZ_WWindow_   *iworkarea;
  union EZ_WWindow_   *hscroll; 
  union EZ_WWindow_   *vscroll; 

} EZ_WorkArea;

#define EZ_WorkAreaHScroll(wptr)          ((wptr)->workArea.hscroll)
#define EZ_WorkAreaVScroll(wptr)          ((wptr)->workArea.vscroll)
#define EZ_WorkAreaTFrame(wptr)           ((wptr)->workArea.Tframe)
#define EZ_WorkAreaIWorkArea(wptr)        ((wptr)->workArea.iworkarea)

typedef struct EZ_RawXWindow_ { 
  char common[sizeof(EZ_WidgetCommon)]; /* common block     */

} EZ_RawXWindow;


/***********************************************************************
 ***                                                                 ***
 ***                     Row Column                                  ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct rowcol_ {
  int   minWH;      /* minimal size, width or height, configured */
  int   cminWH;     /* minimal size, width or height, computed */
  int   offset;     /* offset in grid bag, from top or left */
  int   weight;     /* weight of the current row or column  */
  int   padding;    /* padding */
  int   tmp;  
} EZ_RowColStruct;

#define EZ_GridBagRCMinSize(ptr)    ((ptr)->minWH)
#define EZ_GridBagRCCMinSize(ptr)   ((ptr)->cminWH)
#define EZ_GridBagRCOffset(ptr)     ((ptr)->offset)
#define EZ_GridBagRCWeight(ptr)     ((ptr)->weight)
#define EZ_GridBagRCPadding(ptr)    ((ptr)->padding)
#define EZ_GridBagRCTmp(ptr)        ((ptr)->tmp)

typedef struct EZ_RowColumnWidget_ {
  char common[sizeof(EZ_WidgetCommon)]; /* common block          */
  EZ_RowColStruct    *rows;
  EZ_RowColStruct    *cols;
  int       nrows;
  int       ncols;
  int       allocedrows;
  int       allocedcols;
  int       xoffset;
  int       yoffset;
} EZ_RowColumnWidget;

#define EZ_RCRowPtr(wptr)        ((wptr)->rowcolumn.rows)
#define EZ_RCColPtr(wptr)        ((wptr)->rowcolumn.cols)
#define EZ_RCNRows(wptr)         ((wptr)->rowcolumn.nrows)
#define EZ_RCNCols(wptr)         ((wptr)->rowcolumn.ncols)
#define EZ_RCRowSpace(wptr)      ((wptr)->rowcolumn.allocedrows)
#define EZ_RCColSpace(wptr)      ((wptr)->rowcolumn.allocedcols)
#define EZ_RCXOffset(wptr)       ((wptr)->rowcolumn.xoffset)
#define EZ_RCYOffset(wptr)       ((wptr)->rowcolumn.yoffset)

/***********************************************************************
 ***                                                                 ***
 ***                     The Widget Union                            ***
 ***                                                                 ***
 ***********************************************************************/

union EZ_WWindow_ {
  EZ_WidgetCommon    common;
  EZ_UnknownWidget   unknownWidget;
  EZ_FrameWidget     frame;
  EZ_LabelWidget     label;
  EZ_ButtonWidget    button;
  EZ_CButtonWidget   cbutton;
  EZ_RButtonWidget   rbutton;
  EZ_MButtonWidget   mbutton;
  EZ_SliderWidget    slider;
  EZ_MenuSeparator   mseparator;
  EZ_MenuSubMenu     msubmenu;
  EZ_PopupMenu       popupmenu;
  EZ_EntryWidget     entry;
  EZ_OptEntryWidget  optEntry;
  EZ_ScrollbarWidget scrollbar;
  EZ_3D_Canvas       threedcanvas;
  EZ_IListBoxWidget  ilistbox;       
  EZ_ListBoxWidget   listbox;       
  EZ_ITextWidget     itext;
  EZ_TextWidget      text;
  EZ_NBPage          nbpage;
  EZ_NoteBook        notebook;
  EZ_PaneHandle      panehandle;
  EZ_SpecialWidget   SpecialWidget;
  EZ_Embeder         Embeder;
  EZ_FileSelector    fileSelector;
  EZ_ITreeWidget     itree;
  EZ_TreeWidget      tree;
  EZ_IFancyListBox   iflistbox;
  EZ_FancyListBox    flistbox;
  EZ_IWorkArea       iworkArea;
  EZ_WorkArea        workArea;
  EZ_RawXWindow      rawxwindow;
  EZ_MenuTearOffBar  tearoffbar;
  EZ_RowColumnWidget rowcolumn;
};

/***********************************************************************
 ***                                                                 ***
 ***        Data Structure for Widget Handling                       ***
 ***                                                                 ***
 ***  There are 4 handling functions for each widget,                ***
 ***                                                                 *** 
 ***  void        ComputeSize();                                     ***
 ***  void        DrawWidget();                                      ***
 ***  void        FreeData();                                        ***
 ***  void        EventsHandle();                                    ***
 ***                                                                 *** 
 ***********************************************************************/

typedef struct EZ_WidgetHandle_ {
  void  (*ComputeSize) MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
  void  (*DrawWidget)  MY_ANSIARGS((EZ_Widget *widget));
  void  (*FreeData)    MY_ANSIARGS((EZ_Widget *widget));
  void  (*EventHandle) MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
} EZ_WidgetHandle;


/***********************************************************************
 ***                                                                 ***
 *** The data structure of two simple hash tables. Used to store     ***
 *** pointers for simple loopup of widgets.                          ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct EZ_WidgetListEntry_ {
  union EZ_WWindow_          *widget;
  struct EZ_WidgetListEntry_ *next;
} EZ_WidgetListEntry;
typedef EZ_WidgetListEntry   EZ_MappedWidgetHTEntry;
typedef EZ_WidgetListEntry   EZ_AllWidgetHTEntry;
typedef EZ_WidgetListEntry   EZ_DnDWidgetListEntry;

/***********************************************************************
 ***                                                                 ***
 ***            Data structure for border pieces.                    ***
 ***                                                                 ***
 ***********************************************************************/

typedef struct {
  XPoint  xp[4];
  GC      gc;
} EZ_BorderPiece;

/***********************************************************************
 ***                                                                 ***
 ***            Data structure used in registry                      ***
 ***                                                                 ***
 ***********************************************************************/
typedef struct _ApplRoster {
  char grabServer;
  char needReset;
  char needXFree;
  char pad;
  unsigned long length;
  char *data;
} EZ_ApplRoster;


/***********************************************************************
 ***                                                                 ***
 ***                    Global Variables                             ***
 ***                                                                 ***
 ***********************************************************************/

/* atoms for Drag and Drop */
#ifndef _EZ_DND_C_
#define EZ_DefineDnDAtom(a,b)  extern Atom a ;
#include "EZ_DnDAtom.h"
#undef EZ_DefineDnDAtom
#endif

#ifndef _EZ_WIDGET_INIT_C_
EXTERN XSInfo  XServerInfo;
EXTERN EZ_WidgetHandle  *EZ_WidgetHandlingFunctions[EZ_TOTAL_NUMBER_OF_WIDGETS];
EXTERN EZ_BitmapHTEntry  *EZ_SnapShotBitmap;
EXTERN EZ_Widget         *EZ_BubbleHelp;
EXTERN EZ_Widget         *EZ_CurrentFlashWidget;
EXTERN int               EZ_WeAreInFocus;
EXTERN Time              EZ_LastButton1ClickTime;
EXTERN EZ_Widget         *EZ_LastDropSite;
EXTERN EZ_DnDInfoStruct  EZ_DnDInfo;

EXTERN char     EZ_HighlightEnabled;
EXTERN char     EZ_OffsetEnabled;
EXTERN char     EZ_DepresionDisabled;
EXTERN char     EZ_BubbleHelpOn;

EXTERN char     EZ_DitherImageOn;
EXTERN char     EZ_PointerGrabed;
EXTERN char     EZ_LabelFontIsBold;

EXTERN int      EZ_ServerGrabed;

EXTERN unsigned long  EZ_ApplicationSetupTime;
EXTERN unsigned long  EZ_KbdFocusHighlightColor;
EXTERN EZ_EventHandlerStruct EZ_ClientMessageHandler;
#endif

#ifndef _EZ_WIDGET_GC_C_
EXTERN GC   EZ_GCList[];
#endif

#ifndef  _EZ_WIDGET_POPUP_C_
EXTERN EZ_Widget        *EZ_CurrentPopupMenu;
EXTERN Cursor           EZ_LeftPtrCursor;
EXTERN Cursor           EZ_RightPtrCursor;
EXTERN Cursor           EZ_EntryCursor;
EXTERN Cursor           EZ_ExpandCursor;
EXTERN Cursor           EZ_WatchCursor;
#endif

#ifndef  _EZ_X11INIT_C_
EXTERN int EZ_XErrorCode;
EXTERN Window EZ_DnDCommuWin, EZ_DnDParentWin;
EXTERN int EZ_GeometryX, EZ_GeometryY, EZ_GeometryW, EZ_GeometryH,EZ_GeometrySet; 
EXTERN int EZ_EmbedingDepth;
#endif

#ifndef _EZ_FOCUS_C_
EXTERN EZ_Widget *EZ_CurrentFocusingWidget;
EXTERN EZ_Widget *EZ_PendingFocus;
#endif

#ifndef _EZ_DND_C_
EXTERN EZ_DnDWidgetListEntry  EZ_DnDWidgetList;
#endif

/*************************************************************************
 *
 */
/*
 *  From EZ_Widget.c
 */
#ifndef _EZ_WIDGET_C_   
EXTERN  EZ_Widget             *EZ_CreateNewWidget MY_ANSIARGS((EZ_Widget *parent));
EXTERN  void                  EZ_DestroyWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void                  EZ_DestroyCloneWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void                  EZ_RemoveWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void                  EZ_DestroyWidgetReal MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void                  EZ_GetWidgetLabelPosition MY_ANSIARGS((EZ_Widget *widget, int *x, int *y));
EXTERN  void                  EZ_MarkAllChildrenWidgetSizeChanged MY_ANSIARGS((EZ_Widget *widget, int flag));
EXTERN  void                  EZ_FigureLabelExtent MY_ANSIARGS((XFontStruct  *font_info,
								char         *string,
								int          length, int linelength,
								int          *numlines, int *twidth
								));
EXTERN  void                  EZ_RenderLabelText MY_ANSIARGS((Drawable drawable,
							      GC       gc,
							      int      x, int y,
							      int height, 
							      char     *string,
							      int length,
							      int linelength, int nlines,
							      int twidth, int justification,
							      XFontStruct  *font_info
							      ));
EXTERN  void                  EZ_RenderLabelTextDisabled MY_ANSIARGS((Drawable drawable,
								      GC       BTgc, GC DKgc, GC Ngc,
								      int      x, int y,
								      int height, 
								      char     *string,
								      int length,
								      int linelength, int nlines,
								      int twidth, int justification,
								      XFontStruct  *font_info
								      ));

EXTERN  void                  EZ_RenderPixmapLabel MY_ANSIARGS((EZ_Widget *wptr,
								EZ_Bitmap *bitmap,
								Drawable  drawable,
								int       x,int y
								));
EXTERN  void                  EZ_RenderPixmapLabelWithGC  MY_ANSIARGS((EZ_Bitmap *bitmap,
								       Drawable  drawable,
								       GC        gc,
								       int       x,int y
								       ));
EXTERN  void                  EZ_InitializeCursors MY_ANSIARGS((void));

EXTERN  void                  EZ_SetWidgetPosition MY_ANSIARGS((EZ_Widget *widget, int x, int y));
EXTERN  void                  EZ_SetWidgetWidth MY_ANSIARGS((EZ_Widget *widget, int width));
EXTERN  void                  EZ_SetWidgetHeight MY_ANSIARGS((EZ_Widget *widget, int height));
EXTERN  void                  EZ_GetWidgetPosition MY_ANSIARGS((EZ_Widget *widget, int *x, int *y));
EXTERN  int                   EZ_GetWidgetWidth MY_ANSIARGS((EZ_Widget *widget));
EXTERN  int                   EZ_GetWidgetHeight MY_ANSIARGS((EZ_Widget *widget));
EXTERN  int                   EZ_GetWidgetMinWidth MY_ANSIARGS((EZ_Widget *widget));
EXTERN  int                   EZ_GetWidgetMinHeight MY_ANSIARGS((EZ_Widget *widget));
EXTERN  int                   EZ_GetWidgetBorderWidth MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void                  EZ_GetWidgetDimension MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN  void                  EZ_GetWidgetGeometry MY_ANSIARGS((EZ_Widget *widget, int *x,int *y, int *w, int *h));
EXTERN  void                  EZ_GetWidgetAbsoluteGeometry MY_ANSIARGS((EZ_Widget *widget, int *x,int *y, int *w, int *h));
EXTERN  void                  EZ_GetWidgetMinDimension MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN  void                  EZ_DisableWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void                  EZ_EnableWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN  int                   EZ_SetWidgetLabelString MY_ANSIARGS((EZ_Widget *widget, char *str));
EXTERN  int                   EZ_GetWidgetIntData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void                  EZ_GetWidgetClientData MY_ANSIARGS((EZ_Widget *widget, int *i, void **p));
EXTERN  void                  *EZ_GetWidgetPtrData MY_ANSIARGS((EZ_Widget *widget));
EXTERN  int                   EZ_GetWidgetReturnedData MY_ANSIARGS((EZ_Widget *widget));
EXTERN  int                   EZ_GetWidgetReturnData MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void                  EZ_SetWidgetIntData MY_ANSIARGS((EZ_Widget *widget, int idata));
EXTERN  void                  EZ_SetWidgetPtrData MY_ANSIARGS((EZ_Widget *widget, void *ptr));
EXTERN void                   EZ_SetWidgetClientData MY_ANSIARGS((EZ_Widget *widget, int i, void *p));
EXTERN  void                  EZ_HideWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void                  EZ_DeActivateWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void                  EZ_ActivateWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void                  EZ_FreezeWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void                  EZ_UnFreezeWidget MY_ANSIARGS((EZ_Widget *widget));

EXTERN  void                  EZ_GetBackgroundGC MY_ANSIARGS((EZ_Widget *widget,
						      GC *gc, unsigned long *pv,
						      int highlight, int specialhighlight));
EXTERN void                   EZ_GetParentBgGCN MY_ANSIARGS((EZ_Widget *widget,
							     GC *gc, unsigned long *pv));
EXTERN  void                  EZ_GetBackgroundPV MY_ANSIARGS((EZ_Widget *widget,
						      unsigned long *pv, 
						      int hlight, int specialhlight));
EXTERN  void                  EZ_GetDarkBDGC MY_ANSIARGS((EZ_Widget *widget, GC *gc));
EXTERN  void                  EZ_GetDarkBDpv MY_ANSIARGS((EZ_Widget *widget, unsigned long *pv));
EXTERN  void                  EZ_GetBrightBDGC MY_ANSIARGS((EZ_Widget *widget, GC *gc));
EXTERN  void                  EZ_GetBrightBDpv MY_ANSIARGS((EZ_Widget *widget, unsigned long *pv));
EXTERN  void                  EZ_GetDarkBrightNormalBDGC MY_ANSIARGS((EZ_Widget *widget, GC *dk, GC *bt, GC *ngc));
EXTERN  int                   EZ_GetLabel2XPosition MY_ANSIARGS((EZ_Widget *widget,int l2width, int offset));
EXTERN  int                   EZ_GetWidgetOrientation MY_ANSIARGS((EZ_Widget *widget));

EXTERN  Window                EZ_GetWidgetWindow MY_ANSIARGS((EZ_Widget *widget));


EXTERN  void                  EZ_SetWidgetCallBack MY_ANSIARGS((EZ_Widget *widget, EZ_CallBack callback, void *data));
EXTERN  void                  EZ_AddWidgetCallBack MY_ANSIARGS((EZ_Widget *widget, int wlist,
							EZ_CallBack callback, void *data,int where));
EXTERN  void                  EZ_AddWidgetCallBackInternal MY_ANSIARGS((EZ_Widget *widget, int wlist,
								EZ_CallBack callback, void *data,int where));
EXTERN  void                  EZ_RemoveWidgetCallBack MY_ANSIARGS((EZ_Widget *widget, int wlist,
							   EZ_CallBack callback, void *data));
EXTERN  void                  EZ_RemoveAllWidgetCallBacks MY_ANSIARGS((EZ_Widget *widget, int wlist));

EXTERN  void                  EZ_AddCallBackWork MY_ANSIARGS((EZ_CallBackStruct **list, EZ_CallBack callback,
						      void *data, int where, int flag));
EXTERN  void                  EZ_RemoveCallBackWork MY_ANSIARGS((EZ_CallBackStruct **list, EZ_CallBack callback, void *data));
EXTERN  void                  EZ_RemoveAllCallBacksWork MY_ANSIARGS((EZ_CallBackStruct **list ));

EXTERN  void                  EZ_AddEventHandler MY_ANSIARGS((EZ_Widget *widget, EZ_EventHandler handler,
						      void *data, int where));
EXTERN  void                  EZ_RemoveEventHandler MY_ANSIARGS((EZ_Widget *widget, EZ_EventHandler handler, void *data));
EXTERN  void                  EZ_RemoveAllEventHandlers MY_ANSIARGS((EZ_Widget *widget));

#endif

/*
 * From EZ_WidgetInit.c
 */
#ifndef _EZ_WIDGET_INIT_C_
EXTERN  void    EZ_Initialize MY_ANSIARGS((int ac, char **av, int flag));
EXTERN  Display *EZ_GetDisplay MY_ANSIARGS((void));
EXTERN  Visual  *EZ_GetVisual MY_ANSIARGS((void));
EXTERN  Colormap EZ_GetColormap MY_ANSIARGS((void));
EXTERN  int      EZ_GetDepth  MY_ANSIARGS((void));
EXTERN  Window   EZ_GetWidgetWindow MY_ANSIARGS((EZ_Widget *widget));
EXTERN  Window  EZ_GetCommunicationWindow MY_ANSIARGS((void));
EXTERN  int     EZ_GetScreen MY_ANSIARGS((void));
EXTERN  void    EZ_GetDisplayInfo MY_ANSIARGS((Display **dpy, int *scrn, Visual **vis, int *depth));
EXTERN  void    EZ_SetApplicationName MY_ANSIARGS((char *name));
EXTERN  char    *EZ_GetApplicationName MY_ANSIARGS((void));
EXTERN  void    EZ_DisableHighlight MY_ANSIARGS((void));
EXTERN  void    EZ_EnableHighlight MY_ANSIARGS((void));
EXTERN  void    EZ_DisableLabelOffset MY_ANSIARGS((void));
EXTERN  void    EZ_EnableLabelOffset MY_ANSIARGS((void));
EXTERN  void    EZ_DisableSliderDepression MY_ANSIARGS((void));
EXTERN  void    EZ_EnableSliderDepression MY_ANSIARGS((void));
EXTERN  void    EZ_Shutdown MY_ANSIARGS((void));
EXTERN  void    EZ_ShutdownA MY_ANSIARGS((void));
EXTERN  void    EZ_DisableImageDithering MY_ANSIARGS((void));
EXTERN  void    EZ_EnableImageDithering MY_ANSIARGS((void));
EXTERN  void    EZ_EnableBubbleHelp MY_ANSIARGS((void));
EXTERN  void    EZ_DisableBubbleHelp MY_ANSIARGS((void));
EXTERN  void    EZ_FlashWidgetWindowBorder MY_ANSIARGS((EZ_Widget *widget, Drawable drawable,
						int x, int y, int w,int h));
EXTERN  void    EZ_FlashWidgetBorder MY_ANSIARGS((EZ_Widget *widget));

EXTERN  void  EZ_ResetGlobalVariables MY_ANSIARGS((void));
EXTERN  void  EZ_SetClientMessageHandler MY_ANSIARGS((EZ_EventHandler handler, void *data ));

EXTERN  void   EZ_ComputeWidgetUnknownSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN  void   EZ_UnkownEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
EXTERN  void   EZ_DrawWidgetUnknown MY_ANSIARGS((EZ_Widget *widget));
EXTERN  void   EZ_FreeUnknownData MY_ANSIARGS((EZ_Widget *widget));

EXTERN  void   EZ_ComputeItemUnknownSize MY_ANSIARGS((EZ_Item *item, int *w, int *h)); 
EXTERN void   EZ_DrawItemUnknown MY_ANSIARGS((EZ_Widget *widget,
				       Drawable  drawable,
				       int       x0, int y0,
				       EZ_Item   *item,
				       int       Rx, int Ry, int Rw, int Rh));
EXTERN  void   EZ_UpdateItemUnknown MY_ANSIARGS((EZ_Widget *widget,
					 Drawable  drawable,
					 EZ_Item   *item,
					 int       Rx, int Ry, int Rw, int Rh));
EXTERN  void   EZ_HighlightItemUnknown MY_ANSIARGS((EZ_Widget *widget,
					    Drawable  drawable,
					    EZ_Item   *item,
					    unsigned long fg, unsigned long bg,
					    int       Rx, int Ry, int Rw, int Rh));       
EXTERN  void   EZ_UnknownItemData  MY_ANSIARGS((EZ_Item *item));
EXTERN  int    EZ_UnknownItemPick   MY_ANSIARGS((EZ_Item *item, int x, int y));
EXTERN  void   EZ_UpdateBgGCs MY_ANSIARGS((void));
EXTERN char    *EZ_LibraryVersion MY_ANSIARGS((void));
EXTERN EZ_Widget *EZ_GetBubbleHelp MY_ANSIARGS((void));
#endif

/*
 * From EZ_WidgetMisc.c
 */
#ifndef _EZ_WIDGET_MISC_C_
EXTERN void *EZ_Malloc MY_ANSIARGS((int nbytes));
EXTERN char *EZ_AllocCopyString    MY_ANSIARGS((char *str));
EXTERN char *EZ_ReallocCopyString  MY_ANSIARGS((char *ptr, char *str));
EXTERN void  EZ_Free MY_ANSIARGS((void *ptr));
EXTERN void  EZ_SitForALittleBit   MY_ANSIARGS((unsigned long length));
EXTERN void  EZ_OutOfMemory        MY_ANSIARGS((char *msg));
#endif

/*
 * From EZ_WidgetFrame.c
 */
#ifndef _EZ_WIDGET_FRAME_C_
EXTERN EZ_Widget         *EZ_CreateFrame MY_ANSIARGS((EZ_Widget *parent, char *label));
EXTERN void              EZ_DrawWidgetFrame  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_FreeWidgetFrameData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_FrameEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
EXTERN void              EZ_ComputeWidgetFrameSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
#endif

/*
 * From EZ_WidgetLabel.c
 */
#ifndef _EZ_WIDGET_LABEL_C_
EXTERN EZ_Widget  *EZ_CreateLabel MY_ANSIARGS((EZ_Widget *parent, char *label));
EXTERN void             EZ_DrawWidgetLabel MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetLabelSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_FreeWidgetLabelData MY_ANSIARGS((EZ_Widget *widget));
#endif
/*
 * From EZ_WidgetButtonN.c
 */
#ifndef _EZ_WIDGET_BUTTONN_C_
EXTERN EZ_Widget  *EZ_CreateButton MY_ANSIARGS((EZ_Widget *parent, char *label, int undline));
EXTERN void             EZ_DrawWidgetButton MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetButtonSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_FreeWidgetNButtonData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_NButtonEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
#endif

/*
 * From EZ_WidgetButtonC.c
 */
#ifndef _EZ_WIDGET_BUTTONC_C_
EXTERN EZ_Widget        *EZ_CreateCheckButton MY_ANSIARGS((EZ_Widget *parent,
							   char *label,
							   int underline,
							   int onvalue, int offvalue, int onff ));
EXTERN void             EZ_DrawWidgetCheckButton MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetCButtonSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_FreeWidgetCButtonData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_CButtonEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
EXTERN void             EZ_SetCheckButtonState MY_ANSIARGS((EZ_Widget *widget, int onoff));
EXTERN int              EZ_GetCheckButtonState MY_ANSIARGS((EZ_Widget *widget, int *value));
#endif
/*
 * From EZ_WidgetButtonR.c
 */
#ifndef _EZ_WIDGET_BUTTONR_C_
EXTERN EZ_Widget         *EZ_CreateRadioButton MY_ANSIARGS((EZ_Widget *parent, char *lab, int ul, int gp, int val));
EXTERN void              EZ_DrawWidgetRadioButton  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_ComputeWidgetRButtonSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void              EZ_FreeWidgetRButtonData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_RButtonEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
EXTERN void              EZ_RemoveRBtnFromItsGroup MY_ANSIARGS(( EZ_Widget *rbutton));
EXTERN void              EZ_SetRadioButtonGroupVariableValue MY_ANSIARGS((EZ_Widget *widget, int value));
EXTERN int               EZ_GetRadioButtonGroupVariableValue MY_ANSIARGS((EZ_Widget *widget));
EXTERN int               EZ_GetRadioButtonGroupID MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_FixRadioButtonList MY_ANSIARGS((EZ_Widget *w, int id));
#endif

/*
 * From EZ_WidgetButtonM.c
 */
#ifndef _EZ_WIDGET_BUTTONM_C_
EXTERN EZ_Widget  *EZ_CreateMenuButton MY_ANSIARGS((EZ_Widget *parent, char *label, int undline));
EXTERN void              EZ_DrawWidgetMenuButton MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_ComputeWidgetMButtonSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void              EZ_FreeWidgetMButtonData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_MButtonEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));

EXTERN void              EZ_SetMenuButtonMenu MY_ANSIARGS((EZ_Widget *widget, EZ_Widget *menu));
EXTERN int               EZ_LookForPopupShortCuts MY_ANSIARGS((EZ_Widget *widget, int modfiers, 
							char *str, int *x, int *y, 
							EZ_Widget **item));
EXTERN int               EZ_MatchCharIgnoreCase MY_ANSIARGS((char c1, char c2));
#endif
/*
 * From EZ_WidgetSlider.c
 */
#ifndef _EZ_WIDGET_SLIDER_C_
EXTERN EZ_Widget   *EZ_CreateSlider  MY_ANSIARGS((EZ_Widget *parent, char *lab, 
					   float mnv, float mxv, float initv, int type));
EXTERN void         EZ_SliserEventHandle  MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
EXTERN void         EZ_SetSliderValue  MY_ANSIARGS((EZ_Widget *widget, float value));
EXTERN float        EZ_GetSliderValue  MY_ANSIARGS((EZ_Widget *widget));

EXTERN void         EZ_ComputeWidgetHSliderSize  MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void         EZ_ComputeWidgetVSliderSize  MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void         EZ_DrawWidgetHorizontalSlider  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void         EZ_DrawWidgetVerticalSlider MY_ANSIARGS((EZ_Widget *widget));
EXTERN void         EZ_FreeWidgetSliderData  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void         EZ_SetSliderRange MY_ANSIARGS((EZ_Widget *widget, float f, float t));
#endif
/*
 * From EZ_WidgetMenuItems.c
 */
#ifndef _EZ_WIDGET_MENU_ITEMS_C_
EXTERN EZ_Widget        *EZ_CreateMenuSeparator MY_ANSIARGS((EZ_Widget *parent));
EXTERN void             EZ_DrawWidgetMenuSeparator MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetMenuSeparatorSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));

EXTERN EZ_Widget        *EZ_CreateMenuSubMenu MY_ANSIARGS((EZ_Widget *parent, char *lab, int udl));
EXTERN void             EZ_DrawWidgetMenuSubMenu MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetMenuSubMenuSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_FreeWidgetMenuSubMenuData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_MenuSubMenuEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));

EXTERN EZ_Widget        *EZ_CreateMenuNormalButton MY_ANSIARGS((EZ_Widget *parent, char *lab, int udl, int ret));
EXTERN void             EZ_MenuNormalButtonEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));

EXTERN EZ_Widget        *EZ_CreateMenuCheckButton MY_ANSIARGS((EZ_Widget *parent, char *lab, int udl, 
							int onv, int offv, int onoff, int ret));
							
EXTERN void             EZ_MenuCheckButtonEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));

EXTERN EZ_Widget        *EZ_CreateMenuRadioButton MY_ANSIARGS((EZ_Widget *parent, char *lab, int udl,
							int gid, int val, int ret));
EXTERN void             EZ_MenuRadioButtonEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));

EXTERN void             EZ_SetSubMenuMenu MY_ANSIARGS((EZ_Widget *widget, EZ_Widget *menu));
#endif

/*
 * From EZ_WidgetGeom.c
 */
#ifndef _EZ_WIDGET_GEOM_C_
EXTERN void                 EZ_ComputeWidgetWindowSize MY_ANSIARGS((EZ_Widget *widget,
							     int *w, int *h,
							     EZ_Widget *dirtyAns));
EXTERN void                 EZ_SetChildrenPositionAndSize MY_ANSIARGS((EZ_Widget *widget, int w, int h));
#endif

/*
 * From EZ_WidgetDisp.c
 */
#ifndef _EZ_WIDGET_DISP_C_
EXTERN void                 EZ_DisplayWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN void                 EZ_ReDisplayWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN void                 EZ_DisplayWidgetWithChoice MY_ANSIARGS((EZ_Widget *widget, int chi, int sib));
EXTERN void                 EZ_DrawWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN void                 EZ_CreateWindowForWidget MY_ANSIARGS((EZ_Widget *widget, int flag));
EXTERN void                 EZ_SetWMHintsAndSizeHints MY_ANSIARGS((EZ_Widget *widget,int flag));
EXTERN void                 EZ_SetWMHintForWindow MY_ANSIARGS((Window win, int x, int y, int w, int h));
#endif

/*
 * From EZ_Focus.c
 */
#ifndef _EZ_FOCUS_C_
EXTERN int  EZ_FocusNextWidget MY_ANSIARGS(( EZ_Widget *widget, int dir));
EXTERN void EZ_SetFocusTo MY_ANSIARGS(( EZ_Widget *widget));
EXTERN void EZ_ResetFocus MY_ANSIARGS((EZ_Widget *widget, int flag));
EXTERN EZ_Widget *EZ_FindFocusingWidget MY_ANSIARGS(( EZ_Widget *widget));
#endif
/*
 * From EZ_WidgetHash.c
 */
#ifndef _EZ_WIDGET_HASH_C_
EXTERN EZ_Bitmap         *EZ_CreateLabelPixmapFromXpmFile MY_ANSIARGS((char *file));
EXTERN EZ_Bitmap         *EZ_CreateLabelPixmapFromXpmData MY_ANSIARGS((char **data));
EXTERN EZ_Bitmap         *EZ_CreateLabelPixmapFromRawRGB MY_ANSIARGS((char *data, int width, int height));
EXTERN EZ_Bitmap         *EZ_CreateLabelPixmapFromXBitmapFile MY_ANSIARGS((char *file));
EXTERN EZ_Bitmap         *EZ_CreateLabelPixmapFromXBitmapData MY_ANSIARGS((char *file, unsigned int w, unsigned int h));
EXTERN EZ_Bitmap         *EZ_CreateLabelPixmapFromImageFile MY_ANSIARGS((char *file));
EXTERN void              EZ_FreeLabelPixmap MY_ANSIARGS((EZ_Bitmap *bitmap));
EXTERN void              EZ_FreeXPixmap MY_ANSIARGS((Pixmap pixmap));
EXTERN void              EZ_InitializeWidgetHT MY_ANSIARGS((void));
EXTERN void              EZ_RemoveWidgetFromMappedHT  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_RemoveWidgetFromAllHT  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_InsertWidgetToMappedHT  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_InsertWidgetToAllHT  MY_ANSIARGS((EZ_Widget *widget));
EXTERN EZ_Widget         *EZ_LookupWidgetFromMappedHT  MY_ANSIARGS((Window win));
EXTERN EZ_Widget         *EZ_LookupWidgetFromAllHT  MY_ANSIARGS((EZ_Widget *widget));
EXTERN EZ_Widget         *EZ_LookupWidgetFromAllHTUL  MY_ANSIARGS((unsigned long addr));

EXTERN EZ_Widget         *EZ_WindowIsWidgetWindow  MY_ANSIARGS((Window window));
EXTERN EZ_Widget         *EZ_WidgetExist  MY_ANSIARGS((EZ_Widget *widget));

EXTERN int               EZ_HashString  MY_ANSIARGS((char *str));
EXTERN EZ_Bitmap         *EZ_GetBitmapFromFile  MY_ANSIARGS((char *file, int ref));

EXTERN EZ_Bitmap         *EZ_GetBitmapFromData  MY_ANSIARGS((char *data, unsigned int w, unsigned int h));
EXTERN EZ_Bitmap         *EZ_GetPixmapFromData  MY_ANSIARGS((char  **data));
EXTERN EZ_Bitmap         *EZ_GetPixmapFromRawRGB  MY_ANSIARGS((char  *data, int width, int height));
EXTERN EZ_Bitmap         *EZ_GetPixmapFromPixmap  MY_ANSIARGS((Pixmap pix, int x, int y, int w, int h));
EXTERN EZ_Bitmap         *EZ_GetImageFromFile  MY_ANSIARGS((char *file, int ref));
EXTERN EZ_Bitmap         *EZ_GetAnyPixmapFromFile  MY_ANSIARGS((char *file));
EXTERN char              *EZ_GetBitmapFileName  MY_ANSIARGS((EZ_Bitmap *bitmap));
EXTERN void              EZ_FreeBitmap  MY_ANSIARGS((EZ_Bitmap *bitmap));

EXTERN void              EZ_DestroyAllWidgets  MY_ANSIARGS((void));
#endif
/*
 * From EZ_WidgetPopup.c
 */
#ifndef _EZ_WIDGET_POPUP_C_
EXTERN EZ_Widget  *EZ_CreatePopupMenu MY_ANSIARGS((char *title));
EXTERN EZ_Widget  *EZ_CreateMenu MY_ANSIARGS((char *title));
EXTERN EZ_Widget  *EZ_CreatePopupMenuInternal MY_ANSIARGS((char *title));

EXTERN void              EZ_ComputeWidgetPopupSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void              EZ_DrawWidgetPopup MY_ANSIARGS((EZ_Widget *widget));
EXTERN int               EZ_DoPopup MY_ANSIARGS((EZ_Widget *widget, int where));
EXTERN int               EZ_DoPopupAt MY_ANSIARGS((EZ_Widget *widget, int x, int y));
EXTERN void              EZ_DisplayPopup MY_ANSIARGS((EZ_Widget *widget, int x, int y));
EXTERN void              EZ_DisplayPopupSubMenuOf MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_HideCurrentPopupMenu MY_ANSIARGS((void));
EXTERN void              EZ_HidePopupMenu MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_HideSubMenuOf MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_HideCurrentPopupMenuA MY_ANSIARGS((void));
EXTERN void              EZ_HidePopupMenuA MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_HideSubMenuOfA MY_ANSIARGS((EZ_Widget *widget));

EXTERN void              EZ_HandlePopupCallBack MY_ANSIARGS((EZ_Widget *widget));
EXTERN EZ_Widget         *EZ_GetSelectedMenuItem MY_ANSIARGS((EZ_Widget *widget));
EXTERN EZ_Widget         *EZ_FindMenuItemOnMenu MY_ANSIARGS((EZ_Widget *menu,
							     EZ_Widget *item, int dir));
EXTERN EZ_Widget         *EZ_MoveMenuSelection MY_ANSIARGS((EZ_Widget *menu, 
							    EZ_Widget *item, int dir));
#endif

/*
 * From EZ_WidgetInput.c
 */
#ifndef _EZ_WIDGET_INPUT_C_
EXTERN EZ_Widget        *EZ_CreateEntry MY_ANSIARGS((EZ_Widget *parent, char *init_str));
EXTERN void             EZ_DrawWidgetEntry MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetEntrySize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_FreeWidgetEntryData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_EntryEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
EXTERN void             EZ_SetEntryString MY_ANSIARGS((EZ_Widget *widget, char *str));
EXTERN char             *EZ_GetEntryString MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_OnOffSecretEntry MY_ANSIARGS((EZ_Widget *widget, int onoff));

EXTERN void   EZ_EntryEditDeleteChar MY_ANSIARGS((EZ_Widget *widget, int dir));
EXTERN void   EZ_EntryEditBeginOfInput MY_ANSIARGS((EZ_Widget *widget));
EXTERN void   EZ_EntryEditEndOfInput MY_ANSIARGS((EZ_Widget *widget));
EXTERN void   EZ_EntryEditForeward MY_ANSIARGS((EZ_Widget *widget));
EXTERN void   EZ_EntryEditBackward MY_ANSIARGS((EZ_Widget *widget));
EXTERN void   EZ_EntryEditSetMarker MY_ANSIARGS((EZ_Widget *widget));
EXTERN void   EZ_EntryEditKillRegion MY_ANSIARGS((EZ_Widget *widget));
EXTERN void   EZ_EntryEditKillEndOfLine MY_ANSIARGS((EZ_Widget *widget, int flag));
EXTERN void   EZ_EntryCopySelectedText MY_ANSIARGS((EZ_Widget *widget, int start, int end));
EXTERN void   EZ_EntryPasteSelection MY_ANSIARGS((EZ_Widget *widget));
EXTERN void   EZ_EntryEditInsertString  MY_ANSIARGS((EZ_Widget *widget, char *str));
EXTERN void   EZ_EntryEditForwardWord MY_ANSIARGS((EZ_Widget *widget));
EXTERN void   EZ_EntryEditBackwardWord MY_ANSIARGS((EZ_Widget *widget));
#endif

/*
 * From EZ_Widget3DCanvas.c
 */

#ifndef _EZ_WIDGET_3D_CANVAS_C_
EXTERN EZ_Widget  *EZ_Create3DCanvas MY_ANSIARGS((EZ_Widget *parent));
EXTERN void             EZ_DrawWidget3DCanvas MY_ANSIARGS(( EZ_Widget *widget));
EXTERN void             EZ_ComputeWidget3DCanvasSize MY_ANSIARGS(( EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_FreeWidget3DCanvasData MY_ANSIARGS(( EZ_Widget *widget));
EXTERN void             EZ_3DCanvasEventHandling MY_ANSIARGS(( EZ_Widget *widget, XEvent *event));

EXTERN void             EZ_Set3DCanvas MY_ANSIARGS(( EZ_Widget *widget));
EXTERN void             EZ_Configure3DCanvas MY_ANSIARGS(( EZ_Widget *widget));
EXTERN void             EZ_SelectRenderFunctions MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_Set3DCanvasEventHandle MY_ANSIARGS((EZ_Widget *widget, EZ_EventHandler handler, void *data));
EXTERN void             EZ_Save3DCanvas2PPMImage MY_ANSIARGS((EZ_Widget *widget, char *fname));
EXTERN void             EZ_Save3DCanvas2PSA MY_ANSIARGS((EZ_Widget *widget, int mode,
						  int dpi, float scale, char *fname));
EXTERN void             EZ_Save3DCanvas2PS MY_ANSIARGS((EZ_Widget *widget, char *fname));
EXTERN XImage           *EZ_Read3DCanvas2XImage MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_Get3DCanvasSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_GLConfig MY_ANSIARGS((void));
EXTERN void             EZ_SelectPolygonRenderFuncs MY_ANSIARGS((void));
#endif

/*
 * From EZ_WidgetIListBox.c
 */
#ifndef _EZ_WIDGET_ILIST_BOX_C_
EXTERN EZ_Widget        *EZ_CreateIListBox MY_ANSIARGS((EZ_Widget *parent));
EXTERN void             EZ_DrawWidgetIListBox MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetIListBoxSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_FreeWidgetIListBoxData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_IListBoxEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));

EXTERN void             EZ_SetIListBoxData MY_ANSIARGS((EZ_Widget *widget, char **items, int nitems));
EXTERN void             EZ_AppendIListBoxItem MY_ANSIARGS((EZ_Widget *widget, char *item));
EXTERN void             EZ_InsertIListBoxItem MY_ANSIARGS((EZ_Widget *widget, char *item, int where));
EXTERN void             EZ_DeleteIListBoxItem MY_ANSIARGS((EZ_Widget *widget, int idx));
EXTERN void             EZ_ClearIListBox MY_ANSIARGS((EZ_Widget *widget));
EXTERN char             *EZ_GetIListBoxSelectedItem MY_ANSIARGS((EZ_Widget *widget));
EXTERN char             *EZ_GetIListBoxSelection MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_GetIListBoxData MY_ANSIARGS((EZ_Widget *widget, listboxentry **dat, int *cont));
EXTERN void             EZ_ModifyIListBoxItem MY_ANSIARGS((EZ_Widget *widget, char *item, int idx));
EXTERN void             EZ_IListBoxSelectItem MY_ANSIARGS((EZ_Widget *widget, char *str));
EXTERN void             EZ_IListBoxSelectItemUsingIdx MY_ANSIARGS((EZ_Widget *widget, int idx));

#endif
/*
 * From EZ_WidgetListBox.c
 */
#ifndef _EZ_WIDGET_LIST_BOX_C_
EXTERN EZ_Widget        *EZ_CreateListBox MY_ANSIARGS((EZ_Widget *parent, int hsc, int vsc));
EXTERN void             EZ_DrawWidgetListBox MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetListBoxSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));

EXTERN void             EZ_ClearListBox MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_SetListBoxItems MY_ANSIARGS((EZ_Widget *widget, char **items, int nitems));
EXTERN void             EZ_AppendListBoxItem MY_ANSIARGS((EZ_Widget *widget, char *item));
EXTERN void             EZ_InsertListBoxItem MY_ANSIARGS((EZ_Widget *widget, char *str, int idx));
EXTERN void             EZ_DeleteListBoxItem MY_ANSIARGS((EZ_Widget *widget, int idx));
EXTERN void             EZ_GetListBoxData MY_ANSIARGS((EZ_Widget *widget, listboxentry **dat, int *cnt));
EXTERN char             *EZ_GetListBoxSelectedItem MY_ANSIARGS((EZ_Widget *widget));
EXTERN char             *EZ_GetListBoxSelection MY_ANSIARGS((EZ_Widget *widget));
EXTERN int              EZ_GetListBoxSelectionLineNumber MY_ANSIARGS((EZ_Widget *widget));

EXTERN void             EZ_GetListBoxVState MY_ANSIARGS((EZ_Widget *widget, int *total, int *page, int *first));
EXTERN void             EZ_GetListBoxHState MY_ANSIARGS((EZ_Widget *widget, int *total, int *page, int *first));
EXTERN void             EZ_SetListBoxVState MY_ANSIARGS((EZ_Widget *widget, int begin));
EXTERN void             EZ_SetListBoxHState MY_ANSIARGS((EZ_Widget *widget, int begin));
EXTERN void             EZ_SetListBoxHScrollbar MY_ANSIARGS((EZ_Widget *widget, EZ_Widget *scr));
EXTERN void             EZ_SetListBoxVScrollbar MY_ANSIARGS((EZ_Widget *widget, EZ_Widget *scr));
EXTERN void             EZ_GetListBoxWidgetComponents MY_ANSIARGS((EZ_Widget *widget, EZ_Widget **ilb, 
						      EZ_Widget **hsc,  EZ_Widget **vsc));
EXTERN void             EZ_ModifyListBoxItem MY_ANSIARGS((EZ_Widget *widget, char *item, int idx));
EXTERN void             EZ_ListBoxSelectItem MY_ANSIARGS((EZ_Widget *widget, char *str));
EXTERN void             EZ_ListBoxSelectItemUsingIdx MY_ANSIARGS((EZ_Widget *widget, int idx));

#endif

/*
 * From EZ_WidgetScroll.c
 */
#ifndef _EZ_WIDGET_SCROLL_C_
EXTERN EZ_Widget        *EZ_CreateScrollbar MY_ANSIARGS((EZ_Widget *widget, int type));
EXTERN void             EZ_UpdateScrollbar MY_ANSIARGS((EZ_Widget *widget, int maxs, int pags, int start));
EXTERN void             EZ_GetScrollbarState MY_ANSIARGS((EZ_Widget *widget, int *ms, int *ps, int *st));

EXTERN void             EZ_UpdateScrollbarI MY_ANSIARGS((EZ_Widget *widget, int maxs, int pags, int start));
EXTERN void             EZ_DoHScroll MY_ANSIARGS((EZ_Widget *widget, int offset, int flag));
EXTERN void             EZ_DoVScroll  MY_ANSIARGS((EZ_Widget *widget, int offset, int flag));

EXTERN void             EZ_ComputeWidgetHScrollBarSize  MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_ComputeWidgetVScrollBarSize  MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_DrawWidgetHScrollBar  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_DrawWidgetVScrollBar  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_HScrollBarEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
EXTERN void             EZ_VScrollBarEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
#endif
/*
 * From EZ_WidgetIToplevel.c
 */
#ifndef _EZ_WIDGET_ITOPLEVEL_C_
EXTERN EZ_Widget       *EZ_CreateFreeLabel MY_ANSIARGS((EZ_Widget *widget, char *label));
EXTERN EZ_Widget       *EZ_CreateIcon MY_ANSIARGS((void));
EXTERN EZ_Widget       *EZ_CreateIToplevelFrame MY_ANSIARGS((EZ_Widget *widget, char *label));
EXTERN void            EZ_IToplevelEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
#endif
/*
 * From EZ_WidgetBorder.c
 */
#ifndef _EZ_WIDGET_BORDER_C_
EXTERN void                EZ_FillRectBorderCoor MY_ANSIARGS((
						       int width, int height, int bdwidth,
						       int xoff, int yoff,
						       XPoint *top, XPoint *bottom,
						       XPoint *left, XPoint *right));
EXTERN void                EZ_FillDiamondBorderCoor MY_ANSIARGS((
							  int width, int height, int bdwidth,
							  int xoff, int yoff,
							  XPoint *tr, XPoint *bl,
							  XPoint *tl, XPoint *br));
EXTERN void                EZ_DrawRectBorder MY_ANSIARGS((EZ_Widget *widget, Drawable drawable));
EXTERN void                EZ_DrawRectBorderWithSize MY_ANSIARGS((
							   EZ_Widget *widget, Drawable drawable,
							   int x, int y, int w, int h, int bw,
							   int bdtype));
EXTERN void                EZ_DrawDiamondBorderWithSize MY_ANSIARGS((
							      EZ_Widget *widget, Drawable drawable,
							      int x, int y, int w, int h, int bw,
							      int bdtype));
EXTERN void                EZ_RenderBorder  MY_ANSIARGS((
						  Drawable  drawable,
						  int       type,
						  EZ_BorderPiece *top, 
						  EZ_BorderPiece *bottom, 
						  EZ_BorderPiece *left,
						  EZ_BorderPiece *right,
						  EZ_BorderPiece *extra,
						  EZ_BorderPiece *extraB  ));

EXTERN void                EZ_FillNBBorderCoor  MY_ANSIARGS((int width, int height, int bwidth, int padb,
							      int xoffset, int yoffset,
							     XPoint *left, XPoint *ul, XPoint *top,
							     XPoint *ur, XPoint *right  ));
EXTERN void                EZ_SetupUpBdGC MY_ANSIARGS((
						EZ_Widget *widget,
						GC        *left,  GC *uleft, GC *top, GC *uright,
						GC *right, GC *bottom));
EXTERN void                EZ_SetupDownBdGC MY_ANSIARGS((
						  EZ_Widget *widget,
						  GC        *left,  GC *uleft, GC *top, GC *uright,
						  GC *right, GC *bottom  ));
EXTERN void                EZ_DrawFocusIndicator MY_ANSIARGS((EZ_Widget *widget, Drawable drawable, 
							      int inout));
#endif

/*
 * From EZ_WidgetFont.c
 */
#ifndef _EZ_WIDGET_FONT_C_
EXTERN XFontStruct    *EZ_GetFontFromId MY_ANSIARGS((int id));
EXTERN XFontStruct    *EZ_GetFontFromName MY_ANSIARGS((char *fname));
EXTERN void           EZ_InitFontList MY_ANSIARGS((void));
EXTERN int            EZ_LoadXFont MY_ANSIARGS((char *fname));
EXTERN void           EZ_SetXFont MY_ANSIARGS((XFontStruct **ptr, int id));
EXTERN char           *EZ_GetFontNameFromId MY_ANSIARGS((int id));
EXTERN char           *EZ_GetFontName MY_ANSIARGS((XFontStruct *fptr));
EXTERN void           EZ_DestroyFontList MY_ANSIARGS((void));
EXTERN void           EZ_SetDefaultLabelFont MY_ANSIARGS((char *fname));
EXTERN void           EZ_SetDefaultEntryTextFont MY_ANSIARGS((char *fname));
EXTERN void           EZ_SetDefaultMenuTitleFont MY_ANSIARGS((char *fname));
EXTERN int            EZ_FontWeightIsBold MY_ANSIARGS((char *fname));
#endif
/*
 * From EZ_WidgetEvent.c
 */
#ifndef _EZ_WIDGET_EVENT_C_
EXTERN void            EZ_WidgetDispatchEvent MY_ANSIARGS((XEvent *event));
EXTERN void            EZ_HandleWidgetWindowEvent MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
EXTERN void            EZ_ServiceEvents MY_ANSIARGS((void));
EXTERN void            EZ_WaitAndServiceNextEvent MY_ANSIARGS((void));
EXTERN void            EZ_EventMainLoop MY_ANSIARGS((void));
EXTERN void            EZ_InvokePrivateEventHandler MY_ANSIARGS((XEvent *event));
EXTERN void            EZ_InitializeEventHT MY_ANSIARGS((void));
EXTERN void            EZ_InsertGlobalKeyPressEvent  MY_ANSIARGS((EZ_Widget *widget,int modif, char *key));
EXTERN void            EZ_RemoveGlobalKeyEvent  MY_ANSIARGS((int modi, char *key, EZ_Widget *widget));
EXTERN void            EZ_RemoveAllKeyShortcutForWidget  MY_ANSIARGS((EZ_Widget *widget));
EXTERN int             EZ_GetGlobalKeyEvent  MY_ANSIARGS((int mod, char *key, EZ_Widget *root, 
							  EZ_Widget **widget_ret));
EXTERN void            EZ_TiePopupMenu  MY_ANSIARGS((EZ_Widget *widget, int btnNm, int where));
EXTERN void            EZ_WarpPointerToWidgetWindow  MY_ANSIARGS((EZ_Widget *widget, int where));
EXTERN void            EZ_RemoveEvent  MY_ANSIARGS((XEvent *event));
EXTERN int             EZ_CheckTimerEvents MY_ANSIARGS((void));
EXTERN void            EZ_HandleGlobalKeyEvent MY_ANSIARGS((EZ_Widget *w));
EXTERN void            EZ_TFEvents MY_ANSIARGS((void));
EXTERN int             EZ_FilterEvent MY_ANSIARGS((XEvent *event));
EXTERN void            EZ_WarpPointer MY_ANSIARGS((int x, int y));
#endif
/*
 * From EZ_WidgetGC.c
 */

#ifndef _EZ_WIDGET_GC_C_
EXTERN void  EZ_InitializeWidgetGC MY_ANSIARGS((void));
EXTERN void  EZ_DestroyWidgetGCsandFonts MY_ANSIARGS((void));
EXTERN GC    EZ_CreateGCFor3DCanvas MY_ANSIARGS((void));
EXTERN void  EZ_GetMovingDashedLineGC MY_ANSIARGS((GC *gcp_ret));
#endif
/*
 * From EZ_WidgetFile.c
 */
#ifndef _EZ_WIDGET_FILE_C_
EXTERN int  EZ_FileReadable  MY_ANSIARGS((char *name));
#endif


/*
 * From EZ_Misc.c
 */
#ifndef _EZ_WIDGET_MISC_C_
EXTERN char *EZ_AllocCopyString    MY_ANSIARGS((char *str));
EXTERN char *EZ_ReallocCopyString  MY_ANSIARGS((char *ptr, char *str));
EXTERN void  EZ_SitForALittleBit   MY_ANSIARGS((unsigned long length));
EXTERN void  EZ_OutOfMemory        MY_ANSIARGS((char *msg));
#endif

/*
 * From EZ_WidgetImage.c
 */
#ifndef _EZ_WIDGET_IMAGE_C_
EXTERN int   EZ_CreateXPixmapFromImageFile MY_ANSIARGS((char *file, unsigned int *w,
							unsigned int *h, Pixmap *pix));
EXTERN int   EZ_CreateXPixmapFromRawRGB MY_ANSIARGS((char *data, int width, int height, Pixmap *pixmap_return));
EXTERN void  EZ_RawRGBData2Pixmap MY_ANSIARGS((char *data, int w, int h, Pixmap *pix));
EXTERN void  EZ_PixelValueData2Pixmap MY_ANSIARGS((unsigned int *data, int w, int h, Pixmap *pix));
#endif
/*
 * From EZ_X11Init.c
 */
#ifndef _EZ_X11INIT_C_
EXTERN void EZ_InitX11 MY_ANSIARGS((int ac, char **av, int flag));
EXTERN int  EZ_XErrorHandler MY_ANSIARGS((Display *dpy, XErrorEvent *error));
#endif
/*
 * From EZ_Text.c
 */
#ifndef _EZ_TEXT_C_
EXTERN void       EZ_ITextLineDimension MY_ANSIARGS((
					      EZ_Widget *widget,
					      ITextLine *line,
					      int       start, int length,
					      int       *w_ret, int *h_ret, int *a_ret));
EXTERN void       EZ_ITextRenderText MY_ANSIARGS((
					   EZ_Widget    *widget,
					   ITextLine    *line,
					   int          x, int y,
					   int maxheight, int  maxAscent,
					   Drawable     drawable,
					   int lineNum, int CurX, int CurY));


EXTERN TextProp   *EZ_GetTextPropertyFromID MY_ANSIARGS((
						  int font_id, 
						  int fg_set, int bg_set, int underline,
						  unsigned long fg, unsigned long bg,
						  EZ_Bitmap *bitmap));

EXTERN TextProp   *EZ_CopyTextPropIgnoreSpecial MY_ANSIARGS((TextProp *tprop));

EXTERN void       EZ_InitializeTxetPropertyHashTable MY_ANSIARGS((void));
EXTERN void       EZ_TPHTCollectGarbage MY_ANSIARGS((void));
EXTERN void       EZ_ClearTextPropHT MY_ANSIARGS((void));
EXTERN void       EZ_CountNewLines MY_ANSIARGS((
					 char *str,
					 int  *len_ret, int *nNewlines));
EXTERN void       EZ_GrowITextLine  MY_ANSIARGS((
					  ITextLine **tline,
					  int       increment));
EXTERN void       EZ_FreeTextLine  MY_ANSIARGS((ITextLine *tline));
					  
EXTERN void       EZ_FreeTextProperty MY_ANSIARGS((TextProp *tprop));
EXTERN void       EZ_GrowITextKillBuffer MY_ANSIARGS((ITextLine *buf, int len));
#endif
/*
 * From EZ_WidgetIText.c
 */
#ifndef _EZ_WIDGET_ITEXT_C_
EXTERN EZ_Widget        *EZ_CreateIText MY_ANSIARGS((EZ_Widget *widget, int editable));
EXTERN void             EZ_DrawWidgetIText MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetITextSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_FreeWidgetITextData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));

EXTERN int              EZ_ITextGetPosition MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextGotoPosition MY_ANSIARGS((EZ_Widget *widget, int pos));
EXTERN int              EZ_ITextSetMarker MY_ANSIARGS((EZ_Widget *widget));
EXTERN char             *EZ_ITextGetRegionString MY_ANSIARGS((EZ_Widget *widget));

EXTERN void             EZ_ITextLoadFile MY_ANSIARGS((EZ_Widget *widget,char *file));
EXTERN void             EZ_ITextLoadAnnotatedFile MY_ANSIARGS((EZ_Widget *widget, char *file));
EXTERN void             EZ_ITextClear MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextNextLine MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextPreviousLine MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextBackwardChar MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextForwardChar MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextForwardWord MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextBackwardWord MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextPreviousPage MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextNextPage MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextEndOfBuffer MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextBeginningOfBuffer MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextEndOfLine MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextBeginningOfLine MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextInsertChar MY_ANSIARGS((EZ_Widget *widget, char c));
EXTERN void             EZ_ITextDeletePreviousChar MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextDeleteNextChar MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextInsertNewLine MY_ANSIARGS((EZ_Widget *widget, int flag));
EXTERN void             EZ_ITextKillEndOfLine MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextKillRegion MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextCopyToKillBuffer MY_ANSIARGS((EZ_Widget *widget,int fx, int fy, int tx, int ty));
EXTERN void             EZ_ITextPasteSelection MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextReDisplay MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ITextInsertString MY_ANSIARGS((EZ_Widget *widget, char *str));

EXTERN void             EZ_ITextGrowBuffer MY_ANSIARGS((EZ_Widget *widget, int incr));
EXTERN void             EZ_ITextInsertStringWithProperty MY_ANSIARGS((EZ_Widget *widget, char *str, 
							       EZ_TextProperty *prop));
EXTERN void             EZ_ITextSetRegionFont MY_ANSIARGS((EZ_Widget *widget, char *fontName));
EXTERN void             EZ_ITextSetRegionForeground MY_ANSIARGS((EZ_Widget *widget, char *clrName));
EXTERN void             EZ_ITextSetRegionBackground  MY_ANSIARGS((EZ_Widget *widget, char *clrName));
EXTERN void             EZ_ITextSetRegionUnderline  MY_ANSIARGS((EZ_Widget *widget, int flag));
EXTERN void             EZ_ITextSetRegionProperty  MY_ANSIARGS((EZ_Widget *widget, EZ_TextProperty *prop));

EXTERN void             EZ_ITextReplaceRegionWithBitmap MY_ANSIARGS((EZ_Widget *widget, char *file));
EXTERN void             EZ_ITextSaveText MY_ANSIARGS((EZ_Widget *widget, char *file));
EXTERN void             EZ_ITextSaveAnnotatedText MY_ANSIARGS((EZ_Widget *widget, char *file));
EXTERN void             EZ_PasteSelection MY_ANSIARGS((EZ_Widget *widget, Window win,
						Atom prop, int del,
						void (*insertF) MY_ANSIARGS((EZ_Widget *widget, char *str)) ));
EXTERN void             EZ_SetSelectionOwner MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_HandleSelectionRequest MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
#endif
/*
 * From EZ_WidgetText.c
 */
#ifndef _EZ_WIDGET_TEXT_C_
EXTERN EZ_Widget        *EZ_CreateTextWidget MY_ANSIARGS((EZ_Widget *parent, int editable, int hs,int vs));
EXTERN void             EZ_DrawWidgetText MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetTextSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));

EXTERN void             EZ_TextLoadFile MY_ANSIARGS((EZ_Widget *widget, char *fname));
EXTERN void             EZ_TextLoadAnnotatedFile MY_ANSIARGS((EZ_Widget *widget, char *fname));
EXTERN void             EZ_TextClear MY_ANSIARGS((EZ_Widget *widget));

EXTERN void             EZ_TextNextLine MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextPreviousLine MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextBackwardChar  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextForwardChar  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextPreviousPage  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextForwardWord  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextBackwardWord  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextNextPage  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextEndOfBuffer  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextBeginningOfBuffer  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextEndOfLine  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextBeginningOfLine  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextInsertChar  MY_ANSIARGS((EZ_Widget *widget, char c));
EXTERN void             EZ_TextDeletePreviousChar  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextDeleteNextChar  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextInsertNewLine  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextKillEndOfLine  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextKillRegion  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextPasteSelection  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextReDisplay  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_TextInsertString  MY_ANSIARGS((EZ_Widget *widget, char *str));

EXTERN void             EZ_TextInsertStringWithProperty  MY_ANSIARGS((EZ_Widget *widget, char *str, 
							       EZ_TextProperty *prop));

EXTERN void             EZ_TextSetRegionFont  MY_ANSIARGS((EZ_Widget *widget, char *fontname));
EXTERN void             EZ_TextSetRegionForeground  MY_ANSIARGS((EZ_Widget *widget, char *clr));
EXTERN void             EZ_TextSetRegionBackground  MY_ANSIARGS((EZ_Widget *widget, char *clr));
EXTERN void             EZ_TextSetRegionUnderline  MY_ANSIARGS((EZ_Widget *widget, int udl));
EXTERN void             EZ_TextSetRegionProperty  MY_ANSIARGS((EZ_Widget *widget, EZ_TextProperty *prop));

EXTERN void             EZ_TextReplaceRegionWithPixmap  MY_ANSIARGS((EZ_Widget *widget, char *file));
EXTERN void             EZ_TextSaveText  MY_ANSIARGS((EZ_Widget *widget, char *file));
EXTERN void             EZ_TextSaveAnnotatedText  MY_ANSIARGS((EZ_Widget *widget, char *file));
EXTERN int              EZ_TextSetMarker  MY_ANSIARGS((EZ_Widget *widget));
EXTERN int              EZ_TextGetPosition  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_TextGotoPosition  MY_ANSIARGS((EZ_Widget *widget, int pos));
EXTERN char             *EZ_TextGetRegionString  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_GetTextWidgetComponents  MY_ANSIARGS((EZ_Widget *widget,
								 EZ_Widget **itxt,
								 EZ_Widget **hscr,
								 EZ_Widget **vscr ));
#endif

/*
 * From EZ_WidgetNBPage.c
 */
#ifndef _EZ_WIDGET_NBPAGE_C_
EXTERN EZ_Widget   *EZ_CreateNoteBookPage  MY_ANSIARGS((EZ_Widget *parent, char *lab, int udl));
EXTERN void        EZ_ComputeWidgetNBPageSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void        EZ_DrawWidgetNBPage MY_ANSIARGS((EZ_Widget *widget));
EXTERN void        EZ_ActivateNoteBookPage MY_ANSIARGS((EZ_Widget *widget));
EXTERN EZ_Widget   *EZ_GetNoteBookPageTab MY_ANSIARGS((EZ_Widget *widget));
#endif
/*
 * From EZ_WidgetNB.c
 */
#ifndef _EZ_WIDGET_NB_C_
EXTERN EZ_Widget   *EZ_CreateNoteBook  MY_ANSIARGS((EZ_Widget *parent));
#endif


/*
 * From EZ_WidgetPaneHandle.c
 */
#ifndef _EZ_WIDGET_PANE_HANDLE_C_
EXTERN EZ_Widget       *EZ_CreatePaneHandle MY_ANSIARGS((EZ_Widget *parent));
EXTERN void            EZ_DrawPaneHandle MY_ANSIARGS((EZ_Widget *widget));
EXTERN void            EZ_PaneHEventHandle MY_ANSIARGS((EZ_Widget *widget,XEvent *event));
EXTERN void            EZ_ComputePaneHandleSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
#endif
							
/*
 * From EZ_Arrow.c
 */
#ifndef _EZ_ARROW_C_
EXTERN void  EZ_DrawHLArrow MY_ANSIARGS((EZ_Widget *widget, 
				  Drawable drawable,
				  int x, int y, int size, 
				  int borderstyle,
				  int borderwidth,
				  int highlight));
EXTERN void  EZ_DrawHRArrow MY_ANSIARGS((EZ_Widget *widget, 
				  Drawable drawable,
				  int x, int y, int size, 
				  int borderstyle,
				  int borderwidth,
				  int highlight));
EXTERN void  EZ_DrawVUArrow MY_ANSIARGS((EZ_Widget *widget, 
				  Drawable drawable,
				  int x, int y, int size, 
				  int borderstyle,
				  int borderwidth,
				  int highlight));
EXTERN void  EZ_DrawVDArrow MY_ANSIARGS((EZ_Widget *widget, 
				  Drawable drawable,
				  int x, int y, int size, 
				  int borderstyle,
				  int borderwidth,
				  int highlight));
#endif

/*
 * From EZ_WidgetGrab.c
 */
#ifndef _EZ_WIDGET_GRAB_C_
EXTERN void            EZ_SetGrab MY_ANSIARGS((EZ_Widget *widget));
EXTERN void            EZ_ReleaseGrab MY_ANSIARGS((void));
EXTERN int             EZ_WidgetIsViewable MY_ANSIARGS((EZ_Widget *widget));
EXTERN void            EZ_RedisplayWidgetTree MY_ANSIARGS((EZ_Widget *widget));

#endif
/*
 * From EZ_Xpm.c
 */
#ifndef _EZ_XPM_C_
EXTERN int EZ_CreateXPixmapFromXpmData MY_ANSIARGS((char **data,
					     unsigned int *w, unsigned int *h, 
					     Pixmap *pix, Pixmap *shape));
EXTERN int EZ_CreateXPixmapFromXpmFile MY_ANSIARGS((char *file,
					     unsigned int *w, unsigned int *h, 
					     Pixmap *pix, Pixmap *shape));
EXTERN int EZ_CreateXPixmapFromBitmapFile MY_ANSIARGS((char *file,
					     unsigned int *w, unsigned int *h, 
					     Pixmap *pix, Pixmap *shape));
#endif

/*
 * From EZ_WidgetArrange.c
 */
#ifndef _EZ_WIDGET_ARRANGE_C_
EXTERN void                  EZ_InsertWidgetBefore MY_ANSIARGS((EZ_Widget *a, EZ_Widget *b));
EXTERN void                  EZ_InsertWidgetAfter MY_ANSIARGS((EZ_Widget *a, EZ_Widget *b));
EXTERN void                  EZ_SwapWidgets MY_ANSIARGS((EZ_Widget *a, EZ_Widget *b));
EXTERN void                  EZ_DestroyWidgetWindows MY_ANSIARGS((EZ_Widget *widget));
EXTERN void                  EZ_MakeWidgetWindowExist MY_ANSIARGS((EZ_Widget *widget));
#endif

/*
 * From EZ_WidgetNWLabel.c
 */
#ifndef _EZ_WIDGET_NWLABEL_C_
EXTERN EZ_Widget        *EZ_CreateNWLabel MY_ANSIARGS((EZ_Widget *parent, char *label));
EXTERN EZ_Widget        *EZ_CreateNWFrame MY_ANSIARGS((EZ_Widget *parent));

EXTERN void              EZ_DisplayNWLabel MY_ANSIARGS((EZ_Widget *widget,
							Pixmap pixmap,
							unsigned long fg, unsigned long bg,
							int disabled, int xoff, int yoff, int laboff, 
							int disp_sib));
#endif

/*
 * From EZ_Timer.c
 */
#ifndef _EZ_TIMER_C_
EXTERN void        EZ_InitializeTimers MY_ANSIARGS((void));
EXTERN EZ_Timer    *EZ_CreateTimer MY_ANSIARGS((long sec, long usec,int repeat,
					 EZ_CallBack callback, void *pdata, int idata));
EXTERN EZ_Timer    *EZ_ResetTimer MY_ANSIARGS((EZ_Timer *timer, long sec, long usec,int repeat,
					EZ_CallBack callback, void *pdata, int idata));

EXTERN int         EZ_CheckRealTimers MY_ANSIARGS((long sec, long usec));
EXTERN void        EZ_GetTimerState MY_ANSIARGS((EZ_Timer *timer, long *sec, long *usec,int *repeat));
EXTERN void        EZ_CancelTimer MY_ANSIARGS((EZ_Timer *timer));
EXTERN void        EZ_DestroyAllTimers  MY_ANSIARGS((void));
EXTERN void        EZ_RestartTimer  MY_ANSIARGS((EZ_Timer *timer));
EXTERN void        EZ_SetTimerPtrData  MY_ANSIARGS((EZ_Timer *timer, void *ptr));
EXTERN void        EZ_SetTimerIntData  MY_ANSIARGS((EZ_Timer *timer,int data));
EXTERN void        EZ_SetTimerClientData  MY_ANSIARGS((EZ_Timer *timer, void *ptr, int idata));      
EXTERN void        EZ_SetTimerCallBack  MY_ANSIARGS((EZ_Timer *timer, EZ_CallBack callback, void *data));
EXTERN void        *EZ_GetTimerPtrData      MY_ANSIARGS((EZ_Timer *timer));
EXTERN int         EZ_GetTimerIntData MY_ANSIARGS((EZ_Timer *timer));
EXTERN void        EZ_GetTimerClientData  MY_ANSIARGS((EZ_Timer *timer, void **ptr, int *idata));      
#endif


/*
 * From EZ_DrawSpecial.c
 */
#ifndef _EZ_DRAW_SPECIAL_C_
EXTERN void  EZ_DrawSpecial MY_ANSIARGS(( EZ_Widget     *widget,
					  Drawable      drawable,
					  GC            tgc,
					  int           type,
					  int           x, int y,
					  int           w, int h));
#endif

/*
 * From EZ_WidgetSpecial.c
 */
#ifndef _EZ_WIDGET_SPECIAL_C_
EXTERN EZ_Widget         *EZ_CreateSpecialWidget MY_ANSIARGS((EZ_Widget *parent, int type));
EXTERN void              EZ_DrawSpecialWidget MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_FreeSpecialWidgetData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_SpecialEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
EXTERN void              EZ_ComputeSpecialWidgetSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
#endif

/*
 * From EZ_Comm.c
 */
#ifndef _EZ_COMM_C_
EXTERN void        *EZ_OpenEZWGLRoster MY_ANSIARGS((int lock));
EXTERN void         EZ_CloseEZWGLRoster MY_ANSIARGS((EZ_ApplRoster *roster));
EXTERN void         EZ_RegisterApplication MY_ANSIARGS((void));
EXTERN void         EZ_UpdateRoster  MY_ANSIARGS((EZ_ApplRoster *roster));
EXTERN int          EZ_WindowExist  MY_ANSIARGS((Window window));
EXTERN int          EZ_SendEmbedingMessage  MY_ANSIARGS((int type,
						  Window fmdummy, Window fmwin,
						  unsigned long fmwidget,
						  Window todummy, Window towin,
						  unsigned long towidget,
						  unsigned long id,
						  int x, int y, int w, int h, 
						  int aux1, int aux2));
						  
EXTERN void         EZ_HandlePropertyNotify MY_ANSIARGS((XEvent *event));
EXTERN void         EZ_GenerateEmbedingRequest MY_ANSIARGS((EZ_Widget *widget,
						     int x, int y, int w, int h));
EXTERN EZ_Widget    *EZ_SearchForEmbder MY_ANSIARGS((Window hint, int x, int y, int w, int h,
					      int *xx, int *yy));
EXTERN EZ_Widget    *EZ_SetupAnEmbederIn MY_ANSIARGS((EZ_Widget *widget,
					       Window ecwin, Window  ewin,
					       unsigned long ewidget,
					       unsigned long timeS,
					       int x, int y, int w, int h ));
EXTERN void         EZ_GrowAllocatedBuffer MY_ANSIARGS((char **buf, int *clength, 
						 int newlen, int unit));
EXTERN void         EZ_HandleEmbedingMessages MY_ANSIARGS((char *data, 
						    unsigned long length));

EXTERN void         EZ_DecodeEmbedingMessage MY_ANSIARGS((char *data, 
						   EZ_EmbedingMessage *msg));
EXTERN void         EZ_EncodeEmbedingMessage MY_ANSIARGS((char *data, 
						   EZ_EmbedingMessage *msg));

EXTERN unsigned long EZ_VerifyExistence  MY_ANSIARGS((Window window));
EXTERN unsigned long EZ_WindowIsDnDTarget  MY_ANSIARGS((Window window));
EXTERN unsigned long EZ_WindowIsDnDSrc  MY_ANSIARGS((Window window));

#endif

/*
 * From EZ_WidgetEmbeder.c
 */
#ifndef _EZ_WIDGET_EMBEDER_C_
EXTERN int             EZ_MakeSnapShot MY_ANSIARGS((EZ_Widget *widget,int type, int x, int y, int w, int h));
EXTERN void            EZ_MoveSnapShotOrOutline MY_ANSIARGS((int which, int x, int y, int w, int h, int flag));
EXTERN void            EZ_SetExecutorCommand MY_ANSIARGS((EZ_Widget *widget, char *cmd, char *args));

EXTERN EZ_Widget       *EZ_CreateEmbeder MY_ANSIARGS((EZ_Widget *parent));
EXTERN EZ_Widget       *EZ_CreateExecutor MY_ANSIARGS((EZ_Widget *parent));
EXTERN void            EZ_EmbederEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
EXTERN void            EZ_DrawEmbeder MY_ANSIARGS((EZ_Widget *widget));
EXTERN void            EZ_ComputeEmbederSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void            EZ_FreeEmbederData MY_ANSIARGS((EZ_Widget *widget));

EXTERN void            EZ_ComputeExecutorSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void            EZ_DrawExecutor MY_ANSIARGS((EZ_Widget *widget));
EXTERN void            EZ_FreeExecutorData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void            EZ_ExecutorEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));

EXTERN void            EZ_IntersectRectangles MY_ANSIARGS((int px, int py, int pw, int ph,
						    int x, int y, int w, int h,
						    int *xr, int *yr, int *wr, int *hr));
#endif

/*
 * From EZ_Indicator.c
 */
#ifndef _EZ_INDICATOR_C_
EXTERN void             EZ_DrawIndicator MY_ANSIARGS((
					       EZ_Widget *wptr,
					       Pixmap pixmap, 
					       int onoff,
					       int type, 
					       int bwidth,
					       int adjust,
					       unsigned long color));

#endif

/*
 * From EZ_WidgetOptInput.c
 */
#ifndef _EZ_WIDGET_OPT_INPUT_C_
EXTERN EZ_Widget        *EZ_CreateOptionalEntry MY_ANSIARGS((EZ_Widget *parent, char *str, int hist, int editable));
EXTERN void              EZ_SetOptionalEntryString MY_ANSIARGS((EZ_Widget *widget, char *str));
EXTERN char             *EZ_GetOptionalEntryString MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_SetOptionalEntryOptionalItems MY_ANSIARGS((EZ_Widget *widget, char **items, int count));
EXTERN void              EZ_GetOptionalEntryWidgetComponents MY_ANSIARGS((EZ_Widget *widget, 
								    EZ_Widget **entry, EZ_Widget **listbox, 
								    EZ_Widget **btn  ));
#endif
/*
 * From EZ_WidgetFileSelector.c
 */
#ifndef _EZ_WIDGET_FILE_SELECT_C_
EXTERN EZ_Widget        *EZ_CreateFileSelector  MY_ANSIARGS((EZ_Widget *parent, char *pattern));
EXTERN void             EZ_GetFileSelectorWidgetComponents  MY_ANSIARGS((EZ_Widget *widget,
								   EZ_Widget **pe, EZ_Widget **se,
								   EZ_Widget **dl, EZ_Widget **fl,
								   EZ_Widget **ok, EZ_Widget **ft,
								   EZ_Widget **cancel));
EXTERN void             EZ_SetFileSelectorInitialPattern MY_ANSIARGS((EZ_Widget *widget, char *pattern));
EXTERN char             *EZ_GetFileSelectorSelection MY_ANSIARGS((EZ_Widget *widget));

EXTERN int              EZ_ProcessFileSelectorPattern MY_ANSIARGS((char **dirName, char *pattern));
EXTERN int              EZ_CmpStr MY_ANSIARGS((CONST void *ptr1, CONST void *ptr2));

EXTERN int              position_of_last_slash_before_glob_chars MY_ANSIARGS((char *str));
EXTERN int              EZ_CountSetFilePatterns MY_ANSIARGS((char *pat, char **patterns));
#endif

/*
 * From EZ_WidgetITree.c
 */
#ifndef _EZ_WIDGET_ITREE_C_
EXTERN EZ_Widget  *EZ_CreateITree  MY_ANSIARGS((EZ_Widget *parent));
EXTERN void       EZ_DrawWidgetITree MY_ANSIARGS((EZ_Widget *widget));
EXTERN void       EZ_ComputeWidgetITreeSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void       EZ_FreeWidgetITreeData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void       EZ_ITreeEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));

EXTERN EZ_TreeNode *EZ_FindPointerOnTreeNode MY_ANSIARGS((int x, int y, EZ_TreeNode *root));
EXTERN EZ_TreeNode *EZ_FindTreeAdjBranch MY_ANSIARGS((EZ_TreeNode *root, EZ_TreeNode *node, int dir));
EXTERN void        EZ_SetITreeWTree MY_ANSIARGS((EZ_Widget *widget, EZ_TreeNode *tree));
EXTERN void        EZ_FlashItemOutline MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item, 
					     int Rx, int Ry, int Rw, int Rh));
EXTERN void        EZ_DnDOutlineItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item, 
					     int Rx, int Ry, int Rw, int Rh));
EXTERN void        EZ_ITreeSelectNode MY_ANSIARGS((EZ_Widget *widget, EZ_TreeNode *theNode, int *location));
EXTERN void        EZ_ITreeSelectNodeUsingItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *theItem, int *location));

#endif
/*
 * From EZ_WidgetTree.c
 */
#ifndef _EZ_WIDGET_TREE_C_
EXTERN EZ_Widget  *EZ_CreateListTree MY_ANSIARGS((EZ_Widget *parent, int hsc, int vsc));
EXTERN void        EZ_DrawWidgetTree  MY_ANSIARGS((EZ_Widget *widget));

EXTERN void           EZ_GetListTreeWidgetComponents MY_ANSIARGS((EZ_Widget *widget,
							   EZ_Widget **itr, EZ_Widget **hsc,
							   EZ_Widget **vsc));
EXTERN void           EZ_SetListTreeWidgetTree MY_ANSIARGS((EZ_Widget *widget, EZ_TreeNode *tree));
EXTERN EZ_TreeNode    *EZ_GetListTreeWidgetTree MY_ANSIARGS((EZ_Widget *widget));
EXTERN EZ_TreeNode    *EZ_GetListTreeWidgetSelection MY_ANSIARGS((EZ_Widget *widget));
EXTERN void           EZ_ListTreeWidgetSelectNode MY_ANSIARGS((EZ_Widget *widget, EZ_TreeNode *theNode, int *location));
EXTERN void           EZ_ListTreeWidgetSelectNodeUsingItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *theItem, int *location));
#endif

/*
 * From EZ_WidgetIFListBox.c
 */
#ifndef _EZ_WIDGET_IFLIST_BOX_C_
EXTERN EZ_Widget        *EZ_CreateIFListBox MY_ANSIARGS((EZ_Widget *parent, int ncols, int seltype));
EXTERN void             EZ_DrawWidgetIFListBox MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetIFListBoxSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_FreeWidgetIFListBoxData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_IFListBoxEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));

EXTERN void             EZ_SetIFListBoxData MY_ANSIARGS((EZ_Widget *widget, EZ_Item **items, int row, int col));
EXTERN void             EZ_InsertIFListBoxRow  MY_ANSIARGS((EZ_Widget *widget, EZ_Item **items, int nitems, int where));
EXTERN void             EZ_DeleteIFListBoxRow  MY_ANSIARGS((EZ_Widget *widget, int idx));
EXTERN void             EZ_ReplaceIFListBoxItem  MY_ANSIARGS((EZ_Widget *widget, EZ_Item *old, EZ_Item *newItem));
EXTERN void             EZ_ReplaceIFListBoxItemUsingIdx MY_ANSIARGS((EZ_Widget *widget, int row, int col, EZ_Item *newItem));
EXTERN void             EZ_ClearIFListBox  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_SetIFListBoxHeader  MY_ANSIARGS((EZ_Widget *widget, EZ_Item **elts, int nelts));

EXTERN EZ_Item          **EZ_GetIFListBoxSelection  MY_ANSIARGS((EZ_Widget *widget));
EXTERN EZ_Item          *EZ_GetIFListBoxItemUsingIdx  MY_ANSIARGS((EZ_Widget *widget, int row, int col));

EXTERN int              EZ_FindPointerOnRowIFL  MY_ANSIARGS((EZ_Item ***array, int nrow, int ncol, int x, int y,
						      int Rx, int Ry, int RW, int RH));
EXTERN void             EZ_FindPointerOnRowAndColIFL  MY_ANSIARGS((EZ_Item ***array, int nrow, int ncol, int x, int y,
							    int *rowR, int *colR, int Rx, int Ry, int RW, int RH));

EXTERN void             EZ_FlashRowOutline MY_ANSIARGS((EZ_Widget *widget, EZ_Item **row, int nelts));
EXTERN void             EZ_DnDOutlineRow MY_ANSIARGS((EZ_Widget *widget, EZ_Item **row, int nelts,
					       int Rx, int Ry, int Rw, int Rh));
EXTERN void             EZ_IFListBoxSelectItemUsingIdx MY_ANSIARGS((EZ_Widget *widget, int Srow, int Scol, int *location));
EXTERN void             EZ_IFListBoxSelectItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item, int *location));
EXTERN void             EZ_IFListBoxAllocNewStorage MY_ANSIARGS((EZ_Widget *widget,int rows, int cols));
#endif
/*
 * From EZ_WidgetFListBox.c
 */
#ifndef _EZ_WIDGET_FLIST_BOX_C_
EXTERN EZ_Widget  *EZ_CreateFancyListBox MY_ANSIARGS((EZ_Widget *parent,
					       int hsc, int vsc, int ncol, int selctype));
EXTERN void       EZ_DrawWidgetFancyListBox MY_ANSIARGS((EZ_Widget *widget));
EXTERN void       EZ_GetFancyListBoxWidgetComponents MY_ANSIARGS((EZ_Widget *widget,
							   EZ_Widget **ifl,
							   EZ_Widget **hsc,
							   EZ_Widget **vsc));

EXTERN EZ_Item    **EZ_GetFancyListBoxSelection MY_ANSIARGS((EZ_Widget *widget));
EXTERN EZ_Item    *EZ_GetFancyListBoxItemUsingIdx  MY_ANSIARGS((EZ_Widget *widget, int row, int col));
EXTERN void       EZ_GetFancyListBoxSelectionIdx  MY_ANSIARGS((EZ_Widget *widget, int *row, int *col));
EXTERN void       EZ_SetFancyListBoxData  MY_ANSIARGS((EZ_Widget *widget, EZ_Item **data, int nrow, int ncol));
EXTERN void       EZ_FancyListBoxClear  MY_ANSIARGS((EZ_Widget *widget));
EXTERN void       EZ_SetFancyListBoxHeader  MY_ANSIARGS((EZ_Widget *widget, EZ_Item **header, int nelts));

EXTERN void       EZ_FancyListBoxInsertRow  MY_ANSIARGS((EZ_Widget *widget, EZ_Item **items, int nitems, int where));
EXTERN void       EZ_FancyListBoxDeleteRow  MY_ANSIARGS((EZ_Widget *widget, int idx));
EXTERN void       EZ_FancyListBoxReplaceItem  MY_ANSIARGS((EZ_Widget *widget, EZ_Item *old, EZ_Item *newItem));
EXTERN void       EZ_FancyListBoxReplaceItemUsingIdx  MY_ANSIARGS((EZ_Widget *widget, int row, int col, EZ_Item *newItem));
EXTERN void       EZ_FancyListBoxSelectItemUsingIdx MY_ANSIARGS((EZ_Widget *widget, int Srow, int Scol, int *location));
EXTERN void       EZ_FancyListBoxSelectItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item, int *location));
#endif
/*
 * From EZ_Item.c
 */
#ifndef _EZ_ITEM_C_
EXTERN EZ_Item *EZ_AllocateNewDisplayItem MY_ANSIARGS((void));
EXTERN void    EZ_ComputeItemSize MY_ANSIARGS((
					EZ_Item *item,
					int *w_ret, int *h_ret));
EXTERN void    EZ_DisplayOneItem MY_ANSIARGS((
				       EZ_Widget *widget,
				       Drawable  drawable,
				       int       x0, int y0,
				       EZ_Item   *item,
				       int       Rx, int Ry, int  Rw, int Rh));
EXTERN void    EZ_UpdateOneItem MY_ANSIARGS((
				      EZ_Widget *widget,
				      Drawable  drawable,
				      EZ_Item   *item,
				      int       Rx, int Ry, int  Rw, int Rh));

EXTERN void    EZ_HighlightOneItem MY_ANSIARGS((
					 EZ_Widget *widget,
					 Drawable  drawable,
					 EZ_Item   *item,
					 unsigned long fg,  unsigned long bg, 
					 int       Rx, int Ry, int  Rw, int Rh));
EXTERN void    EZ_DestroyItem MY_ANSIARGS((EZ_Item *item));

EXTERN void    EZ_GetItemXYOffset MY_ANSIARGS((EZ_Item *item, int *xoff, int *yoff));
EXTERN void    EZ_GetItemBwAndXYPading MY_ANSIARGS((EZ_Item *item, int *bw, int *xpad, int *ypad));

EXTERN void    EZ_GetItemClientData MY_ANSIARGS((EZ_Item *item,
					  void **pdata_ret,
					  int *idata_ret));
EXTERN int     EZ_GetItemIntData MY_ANSIARGS((EZ_Item *item));
EXTERN void    *EZ_GetItemPtrData MY_ANSIARGS((EZ_Item *item));
EXTERN void     EZ_SetItemClientData MY_ANSIARGS((EZ_Item *item,
					  int idata, void *pdata ));
EXTERN void     EZ_SetItemIntData MY_ANSIARGS((EZ_Item *item, int i));
EXTERN void     EZ_SetItemPtrData MY_ANSIARGS((EZ_Item *item, void *p));


EXTERN void    EZ_ComputeItemArrayGeometry MY_ANSIARGS((EZ_Item ***array,
						 int nrows,
						 int ncolumns,
						 int *w_ret, int *h_ret,
						 int *w_det_ret, int *h_det_ret));
EXTERN void    EZ_DisplayOneRowOfItems MY_ANSIARGS((EZ_Widget *widget,
						    Drawable drawable,
						    EZ_Item **row,
						    int nelts,
						    int x0,int y0,int hsep,
						    int *w_sizes,
						    int Rx,int Ry,int Rw,int Rh));
EXTERN void    EZ_UpdateOneRow MY_ANSIARGS((EZ_Widget *widget,
					    Drawable drawable,
					    EZ_Item **row,
					    int nelts,
					    int cx,int cy,int cw, int ch));
EXTERN void    EZ_HighlightOneRow MY_ANSIARGS((EZ_Widget *widget,
					       Drawable drawable,
					       EZ_Item **row,
					       int nelts,
					       unsigned long fg, unsigned long bg,
					       int cx,int cy,int cw, int ch));

EXTERN int     EZ_PickAnItem MY_ANSIARGS(( EZ_Item *item, int x, int y));

EXTERN void    EZ_ItemConfigureSentienl MY_ANSIARGS(( EZ_Item *item, int dirty));


EXTERN void    EZ_AddItemCallBack MY_ANSIARGS((EZ_Item *item, int which,
					EZ_CallBack callback, void *cdata,
					int where));
EXTERN void    EZ_AddItemCallBackInternal MY_ANSIARGS((EZ_Item *item, int which,
						EZ_CallBack callback, void *cdata,
						int where));
EXTERN void    EZ_RemoveItemCallBack MY_ANSIARGS((EZ_Item *item,  int which,
					   EZ_CallBack callback, void *cdata));
EXTERN void    EZ_RemoveAllItemCallBacks MY_ANSIARGS((EZ_Item *item, int which));

EXTERN void    EZ_SetItemPosition MY_ANSIARGS((EZ_Item *item, int x, int y));
EXTERN void    EZ_SetItemWidth MY_ANSIARGS((EZ_Item *item, int width));
EXTERN void    EZ_SetItemHeight MY_ANSIARGS((EZ_Item *item, int height));
EXTERN void    EZ_SetItemDimension MY_ANSIARGS((EZ_Item *item, int w, int h));
EXTERN int     EZ_GetItemWidth MY_ANSIARGS((EZ_Item *item));
EXTERN int     EZ_GetItemHeight MY_ANSIARGS((EZ_Item *item));
EXTERN void    EZ_GetItemDimension MY_ANSIARGS((EZ_Item *item, int *w, int *h));
EXTERN void    EZ_GetItemPosition MY_ANSIARGS((EZ_Item *item, int *x, int *y));
EXTERN void    EZ_SetItemAttributes MY_ANSIARGS((EZ_Item *item, int option, int i1, int i2, 
						 void *p1, void *p2, 
						 unsigned long ul1, unsigned long ul2,
						 int i3, int i4));
#endif
/*
 * From EZ_LabelItem.c
 */
#ifndef _EZ_ITEM_LABEL_C_
EXTERN EZ_Item    *EZ_CreateLabelItem MY_ANSIARGS((char *str, EZ_TextProperty *prop));
EXTERN void        EZ_LabelItemSetProperty MY_ANSIARGS((EZ_Item *item, EZ_TextProperty *prop));
EXTERN void        EZ_GetLabelItemStringInfo MY_ANSIARGS((EZ_Item *item, char **str, int *len));
#endif


/*
 * From EZ_WidgetItem.c
 */
#ifndef _EZ_ITEM_WIDGET_C_
EXTERN EZ_Item    *EZ_CreateWidgetItem  MY_ANSIARGS((EZ_Widget *widget));
EXTERN EZ_Widget  *EZ_GetWidgetItemWidget MY_ANSIARGS((EZ_Item *item));
#endif


/*
 * From EZ_Tree.c
 */
#ifndef _EZ_TREE_C_
EXTERN EZ_TreeNode  *EZ_CreateTreeNode  MY_ANSIARGS((EZ_TreeNode *parent, EZ_Item *item));      
EXTERN EZ_TreeNode  *EZ_TreeNodeGetParent MY_ANSIARGS((EZ_TreeNode *node));      
EXTERN EZ_TreeNode  *EZ_TreeNodeGetChildren MY_ANSIARGS((EZ_TreeNode *node));      
EXTERN EZ_TreeNode  *EZ_TreeNodeGetSibling MY_ANSIARGS((EZ_TreeNode *node));      
EXTERN EZ_TreeNode  *EZ_TreeFindNode MY_ANSIARGS((EZ_TreeNode *root, EZ_TreeNode *node));
EXTERN EZ_TreeNode  *EZ_TreeFindNodeUsingItem MY_ANSIARGS((EZ_TreeNode *root, EZ_Item *item));

EXTERN void     EZ_TreeDestroySubtree MY_ANSIARGS((EZ_TreeNode *node));      
EXTERN void     EZ_TreeDestroyNodeDescendants MY_ANSIARGS((EZ_TreeNode *node));      
EXTERN void     EZ_TreeAttachSubtree MY_ANSIARGS((EZ_TreeNode *node, EZ_TreeNode *subtree));      
EXTERN void     EZ_TreeSetCharacter MY_ANSIARGS((EZ_TreeNode *node,
						     int type, int indent, int spacint, int drawBranch));      
EXTERN void     EZ_TreeTraverseTree MY_ANSIARGS((EZ_TreeNode *node,
					  void (*preF) MY_ANSIARGS((EZ_TreeNode *node)),
						 void (*postF) MY_ANSIARGS((EZ_TreeNode *node))	  ));

EXTERN void     EZ_TreeSetFGColor  MY_ANSIARGS((EZ_TreeNode *node, unsigned long pv));

EXTERN void     EZ_TreeSetBGColor MY_ANSIARGS((EZ_TreeNode *node, unsigned long pv));

EXTERN void     EZ_ComputeSubtreeSize MY_ANSIARGS((EZ_TreeNode *node, int *w, int *h));

EXTERN void     EZ_DisplayTreeInDrawable MY_ANSIARGS((EZ_Widget *widget, Drawable drawable,
					       int x0, int y0,
					       EZ_TreeNode *node,
						      int Rx, int Ry, int Rw, int Rh));

EXTERN EZ_Item *EZ_TreeNodeGetItem MY_ANSIARGS((EZ_TreeNode *node));
#endif
/*
 * From EZ_TreeDir.c
 */
#ifndef _EZ_TREE_DIR_C_
EXTERN EZ_TreeNode      *EZ_CreateDirTree MY_ANSIARGS((char *pattern));
EXTERN void             *(*EZ_SetDirTreeFileNodeCreator()) MY_ANSIARGS((void (*cr) MY_ANSIARGS(( char *name))  ));
EXTERN void             *(*EZ_SetDirTreeDirectoryNodeCreator()) MY_ANSIARGS((void (*cr) MY_ANSIARGS(( char *name))  ));
EXTERN void             *EZ_DefaultDirTreeFileNodeCreator MY_ANSIARGS(( char *name));
EXTERN void             *EZ_DefaultDirTreeDirectoryNodeCreator MY_ANSIARGS(( char *name));

EXTERN char             *EZ_GetDirTreeNodeFullPath MY_ANSIARGS((EZ_TreeNode *name));

EXTERN void             EZ_SetDirTreeOpenDirectoryMode MY_ANSIARGS((int mode));
EXTERN void             EZ_OpenCloseDirTreeDirectoryNodeDefault MY_ANSIARGS((EZ_Item *item, void *data));
EXTERN void             EZ_OpenCloseDirTreeDirectoryNodeCollapse MY_ANSIARGS((EZ_Item *item, void *data));

#endif
/*
 * From EZ_WidgetIWorkArea.c
 */
#ifndef _EZ_WIDGET_IWORK_AREA_C_
EXTERN EZ_Widget        *EZ_CreateIWorkArea MY_ANSIARGS((EZ_Widget *parent));
EXTERN void             EZ_DrawWidgetIWorkArea MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_ComputeWidgetIWorkAreaSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
EXTERN void             EZ_FreeWidgetIWorkAreaData MY_ANSIARGS((EZ_Widget *widget));
EXTERN void             EZ_IWorkAreaEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));

EXTERN void             EZ_GrowIWorkAreaDataSpace MY_ANSIARGS((EZ_Widget *widget, int increment));

EXTERN EZ_Item          *EZ_FindPointerOnItemIWA MY_ANSIARGS((EZ_Item **data, int count,  EZ_Item *guess, 
							     int x, int y));

EXTERN void              EZ_IWorkAreaInsertItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item));
EXTERN void              EZ_IWorkAreaDeleteItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item));
EXTERN void              EZ_IWorkAreaDeleteAllItems MY_ANSIARGS((EZ_Widget *widget));

EXTERN void              EZ_IWorkAreaInsertItemBeforeAfter MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item,
								 EZ_Item *newitem, int BefAft));
EXTERN void              EZ_IWorkAreaInsertItemUsingIdx MY_ANSIARGS((EZ_Widget *widget, int idx, EZ_Item *item));
EXTERN void              EZ_IWorkAreaDeleteItemUsingIdx MY_ANSIARGS((EZ_Widget *widget, int idx));
EXTERN void              EZ_IWorkAreaSelectItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item, int *location));
EXTERN void              EZ_IWorkAreaSelectItemUsingIdx MY_ANSIARGS((EZ_Widget *widget, int idx, int *location));
#endif
/*
 * From EZ_WidgetWorkArea.c
 */
#ifndef _EZ_WIDGET_WORK_AREA_C_
EXTERN EZ_Widget        *EZ_CreateWorkArea MY_ANSIARGS((EZ_Widget *parent, int hsc, int vsc));
EXTERN void             EZ_DrawWidgetWorkArea MY_ANSIARGS((EZ_Widget *widget));

EXTERN EZ_Item          *EZ_GetWorkAreaSelection MY_ANSIARGS((EZ_Widget *widget));
EXTERN void              EZ_SetWorkAreaGeometryManager MY_ANSIARGS((EZ_Widget *widget,
								    EZ_WorkAreaGeometryManager managet,
								    void *pdata  ));

EXTERN void              EZ_WorkAreaInsertItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item));
EXTERN void              EZ_WorkAreaDeleteItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item));
EXTERN void              EZ_WorkAreaClear MY_ANSIARGS((EZ_Widget *widget));

EXTERN void              EZ_WorkAreaRearrange MY_ANSIARGS((EZ_Widget *widget));

EXTERN void              EZ_WorkAreaInsertItemBefore MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item, EZ_Item *newItem));
EXTERN void              EZ_WorkAreaInsertItemAfter  MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item, EZ_Item *newItem));
EXTERN void              EZ_WorkAreaInsertItemUsingIdx MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item, int idx));
EXTERN void              EZ_WorkAreaDeleteItemUsingIdx MY_ANSIARGS((EZ_Widget *widget, int idx));
EXTERN void              EZ_GetWorkAreaWidgetComponents MY_ANSIARGS((EZ_Widget *widget, EZ_Widget **iwa, 
							EZ_Widget **hsc, EZ_Widget **vsc));
EXTERN void              EZ_WorkAreaSelectItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *item, int *location));
EXTERN void              EZ_WorkAreaSelectItemUsingIdx MY_ANSIARGS((EZ_Widget *widget, int idx, int *location));
#endif

/*
 * From EZ_WorkAreaGeom.c
 */
#ifndef _EZ_WORK_AREA_GEOM_C_
EXTERN void             EZ_WorkAreaGeometryManagerDefault MY_ANSIARGS((void *GMData, EZ_Item **data, int nitems,
								       int Rx,int Ry,int Rw, int Rh, int Wxsp, int Wysp, 
								       int *w_ret, int *h_ret));
#endif


/*
 * From EZ_WidgetRawXWin.c
 */
#ifndef _EZ_WIDGET_RAWXWIN_C_
EXTERN EZ_Widget       *EZ_CreateRawXWindow MY_ANSIARGS((EZ_Widget *parent));
#endif

/*
 * From EZ_DnDData.c
 */
#ifndef _EZ_DND_DATA_C_

EXTERN void EZ_ItemAddDnDDataEncoder MY_ANSIARGS((EZ_Item *item, Atom type, unsigned int tag,
						     EZ_DnDEncoder encoder, void *edata,
						     EZ_CallBack callback, void *cdata));
EXTERN void EZ_ItemDeleteDnDDataEncoder MY_ANSIARGS((EZ_Item *item, Atom type));
EXTERN void EZ_ItemDeleteAllDnDDataEncoders MY_ANSIARGS((EZ_Item *item));
EXTERN void EZ_ItemAddDnDDataDecoder MY_ANSIARGS((EZ_Item *item, Atom type, unsigned int tag,
						     EZ_DnDDecoder decoder, void *edata,
						     EZ_CallBack callback, void *cdata));
EXTERN void EZ_ItemDeleteDnDDataDecoder MY_ANSIARGS((EZ_Item *item, Atom type));
EXTERN void EZ_ItemDeleteAllDnDDataDecoders MY_ANSIARGS((EZ_Item *item));


EXTERN void EZ_WidgetAddDnDDataEncoder MY_ANSIARGS((EZ_Widget *widget, Atom type, unsigned int tag,
						         EZ_DnDEncoder encoder, void *edata,
						         EZ_CallBack callback, void *cdata));
EXTERN void EZ_WidgetDeleteDnDDataEncoder MY_ANSIARGS((EZ_Widget *widget, Atom type));
EXTERN void EZ_WidgetDeleteAllDnDDataEncoders MY_ANSIARGS((EZ_Widget *widget));
EXTERN void EZ_WidgetAddDnDDataDecoder MY_ANSIARGS((EZ_Widget *widget,Atom type, unsigned int tag,
						         EZ_DnDDecoder encoder, void *edata,
						         EZ_CallBack callback, void *cdata));
EXTERN void EZ_WidgetDeleteDnDDataDecoder MY_ANSIARGS((EZ_Widget *widget, Atom type));
EXTERN void EZ_WidgetDeleteAllDnDDataDecoders MY_ANSIARGS((EZ_Widget *widget));

#endif
/*
 * From EZ_DnD.c
 */
#ifndef _EZ_DND_C_
EXTERN Atom EZ_GetAtom  MY_ANSIARGS((char *name));
EXTERN int  EZ_DnDTargetTryNextTarget MY_ANSIARGS((void));
EXTERN void EZ_InitializeDnD MY_ANSIARGS((void));
EXTERN void EZ_Insert2DnDWidgetList MY_ANSIARGS((EZ_Widget *widget));
EXTERN void EZ_RemveWidgetFromDnDList MY_ANSIARGS((EZ_Widget *widget));
EXTERN void EZ_DestroyDnDList MY_ANSIARGS((void));
EXTERN void EZ_GrabButtonRelease MY_ANSIARGS((void));
EXTERN void EZ_UngrabButtonRelease MY_ANSIARGS((void));
EXTERN void EZ_DnDSendDataConversionRequest MY_ANSIARGS((void));
EXTERN void EZ_InitDrag MY_ANSIARGS((unsigned long id,
			      int type,
			      Window window,
			      EZ_Widget *widget,
			      void      *item,
			      int x, int y, int w, int h,
			      int px, int py, int xoff, int yoff));
EXTERN void EZ_FinishDrag MY_ANSIARGS((Window cwin, Window win, int px, int py));
EXTERN void EZ_AbortDrag MY_ANSIARGS((void));
EXTERN void EZ_DnDMatchTargetsWithDecoders MY_ANSIARGS((void));
EXTERN void EZ_DnDFindNextDecoder MY_ANSIARGS((void));
EXTERN void EZ_DnDFindDataEncoder MY_ANSIARGS((Atom target));
EXTERN void EZ_DnDSendDataConversionRequest MY_ANSIARGS((void));
EXTERN void  EZ_DnDSendErrorMessage MY_ANSIARGS((int sender, int errType, EZ_DnDMessage *theMsg));
EXTERN void EZ_DnDSendConversion MY_ANSIARGS((Atom type, char *message, int length ));
EXTERN void EZ_HighlightDropSiteWidget MY_ANSIARGS((void));
EXTERN void EZ_DnDInformDeliverError MY_ANSIARGS((int type, EZ_DnDMessage *theMsg));
EXTERN void EZ_EncodeDnDMessageHeader MY_ANSIARGS((int type, char *message, int length, Window *receiver));
EXTERN void EZ_DecodeDnDMessageHeader  MY_ANSIARGS((char *message, EZ_DnDMessage *theMsg));
 
EXTERN void EZ_DnDSendRequestHelpMsg MY_ANSIARGS((void));
EXTERN void EZ_DnDSendCancelHelpMsg MY_ANSIARGS((void));
EXTERN void EZ_DnDShowTargetHelp MY_ANSIARGS((void));
EXTERN void EZ_DnDCancelTargetHelp MY_ANSIARGS((void));
EXTERN void EZ_DnDSendLeaveWindowMsg MY_ANSIARGS((void));

EXTERN void EZ_EnableDnDBubbleHelp MY_ANSIARGS((void));
EXTERN void EZ_DisableDnDBubbleHelp MY_ANSIARGS((void));
EXTERN int  EZ_CheckDnDTimer MY_ANSIARGS((void));
EXTERN void EZ_Insert2DnDWindowList MY_ANSIARGS((EZ_Widget *widget));
EXTERN void EZ_RemoveFromDnDWindowList MY_ANSIARGS((EZ_Widget *widget));
#endif
/*
 * From EZ_DnDMsg.c
 */
#ifndef _EZ_DND_MSG_C_
EXTERN void EZ_HandleDnDMessage MY_ANSIARGS((char *data, unsigned long length));
EXTERN void EZ_SendDnDMessage MY_ANSIARGS((int type, char *msg, int len, int needFree));
EXTERN void EZ_BroadcastDnDMessage MY_ANSIARGS((int type, char *msg, int len, int needFree));
EXTERN void EZ_GenerateDragIsDropedMessage MY_ANSIARGS((char **msg_ret, int *len_ret));
EXTERN void EZ_DnDGetTargetTypesFromMessage MY_ANSIARGS((EZ_DnDMessage *theMsg,
						  Atom *atoms,
						  unsigned int *cont));
EXTERN EZ_DnDDataEncoder *EZ_FindSpecialEncoder MY_ANSIARGS((void));
EXTERN void EZ_GetDnDDropLocation MY_ANSIARGS((int *x, int *y, int *xx, int *yy));
EXTERN void EZ_IWorkAreaDnDHandle MY_ANSIARGS((EZ_Widget *widget, EZ_DnDMessage *theMsg));
EXTERN void EZ_ITreeDnDHandle MY_ANSIARGS((EZ_Widget *widget, EZ_DnDMessage *theMsg));
EXTERN void EZ_IFListBoxDnDHandle MY_ANSIARGS((EZ_Widget *widget, EZ_DnDMessage *theMsg));

#endif

#ifndef _EZ_GIF_C_
int EZ_ReadGIFToPixmap MY_ANSIARGS(( char     *file,   int      *width_return,   int       *height_return,
				     Pixmap   *pixmap_return));
#endif

#ifndef _EZ_INPUT_C_
EXTERN void         EZ_InitializeInputIdList  MY_ANSIARGS((void));
EXTERN void         EZ_DestroyInputIdList  MY_ANSIARGS((void));
EXTERN void         *EZ_AddInput MY_ANSIARGS((int fd, int mask, 
				       EZ_InputCallBack callback,
				       void *data));
EXTERN void         EZ_RemoveInput MY_ANSIARGS((void *id));
EXTERN int          EZ_CheckAppInputs MY_ANSIARGS((unsigned long length));
#endif

/*
 * From EZ_WidgetRowCol.c
 */
#ifndef _EZ_WIDGET_ROWCOL_C_
EXTERN EZ_Widget  *EZ_CreateRowColumn MY_ANSIARGS((EZ_Widget *parent));
EXTERN EZ_Widget  *EZ_CreateGridBag MY_ANSIARGS((EZ_Widget *parent));
#endif

/*
 * From EZ_RowCol.c
 */
#ifndef _EZ_ROWCOL_C_
EXTERN void  EZ_RowColumnComputeGeometry MY_ANSIARGS((EZ_Widget *widget, 
						int *w, int *h,
						EZ_Widget *dirtyAns));
EXTERN void  EZ_RowColSetChildrenPositionAndSize MY_ANSIARGS((EZ_Widget *widget,
						       int w, int h));
EXTERN int   EZ_SetRowColConstrains MY_ANSIARGS((EZ_Widget *widget, 
					  int rc, int idx, int minsize, int weight, 
					  int pad));
#endif

/*
 * From EZ_WidgetTearOff.c
 */
#ifndef _EZ_WIDGET_TEAR_OFF_C_
EXTERN EZ_Widget   *EZ_CreateMenuTearOffItem MY_ANSIARGS((EZ_Widget *parent));
EXTERN void         EZ_HandleToplevelMenuEvents  MY_ANSIARGS((EZ_Widget *widget, XEvent *ev));
EXTERN int          EZ_ConfigureTearOffMenu  MY_ANSIARGS((EZ_Widget *menu, int onoff));
EXTERN void         EZ_DeselectCurrentMenuItem  MY_ANSIARGS((EZ_Widget *item));
#endif

#ifndef _EZ_WIDGET_CONFIGURE_C_
EXTERN int  EZ_SetWidgetAttributes MY_ANSIARGS((EZ_Widget *widget, int opt, 
						int i1, int i2, 
						void *p1, void *p2,
						unsigned long ul1, unsigned long ul2,
						float f1, float f2,
						int i3, int i4));
EXTERN void  EZ_ConfigureError MY_ANSIARGS((EZ_Widget *widget, int option, char *msg));
#endif



#ifndef _EZ_BMP_C_
EXTERN int EZ_ReadBMPToPixmap MY_ANSIARGS((char *filename, int *width_return, int *height_return,
					   Pixmap *pixmap_return));
#endif

#ifndef _EZ_JPEG_C_
EXTERN int EZ_ReadJpegToPixmap MY_ANSIARGS((
					    char     *file,
					    int      *width_return,
					    int       *height_return,
					    Pixmap   *pixmap_return));
#endif

#ifndef _EZ_RESOUCE_C_
EXTERN void EZ_GetResources         MY_ANSIARGS((void));
EXTERN void EZ_SetWidgetResources   MY_ANSIARGS((EZ_Widget *widget));
#endif



/* glob.c and tilde.c */
EXTERN char       **EZ_GlobFileName  MY_ANSIARGS((char *name));
EXTERN char       *EZ_TildeExpand MY_ANSIARGS((char *name));

/*
 * Var arg things
 */
EXTERN EZ_TextProp *EZ_GetTextProperty  MY_VARARGS_D(int, name);
EXTERN void        EZ_ConfigureWidget   MY_VARARGS_D(void, *args);
EXTERN void        EZ_ConfigureItem     MY_VARARGS_D(void, *args);
EXTERN EZ_Widget  *EZ_CreateSimpleMenu  MY_VARARGS_D(char, *args);
EXTERN EZ_Widget  *EZ_CreateWidget      MY_VARARGS_D(int,  the_args);
EXTERN EZ_Item    *EZ_CreateItem        MY_VARARGS_D(int,  the_args);
#endif

