/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */

#ifndef _EZ_WIDGET_CONFIG_H_
#define _EZ_WIDGET_CONFIG_H_
/*******************************************************************
 *
 *  Configuration options for EZ_Widgets.
 */

/*
 *  This is the list of options for EZ_Widgets. For each widget,
 *  only a subset of these options are applicable.
 */
#define EZ_X                      1
#define EZ_Y                      2
#define EZ_WIDTH                  3
#define EZ_HEIGHT                 4
#define EZ_WIDTH_HINT             5
#define EZ_HEIGHT_HINT            6
#define EZ_BORDER_WIDTH           7
#define EZ_BORDERWIDTH            EZ_BORDER_WIDTH
#define EZ_BORDER_TYPE            8
#define EZ_BORDER_STYLE           EZ_BORDER_TYPE
#define EZ_PADX                   9
#define EZ_PADY                   10
#define EZ_IPADX                  11
#define EZ_IPADY                  12
#define EZ_STACKING               13
#define EZ_ORIENTATION            EZ_STACKING
#define EZ_SIDE                   14
#define EZ_LABEL_POSITION         15
#define EZ_LABELPOSITION          EZ_LABEL_POSITION
#define EZ_JUSTIFICATION          16
#define EZ_LABEL_JUSTIFICATION    EZ_JUSTIFICATION
#define EZ_FILL_MODE              17
#define EZ_PROPAGATE              18
#define EZ_CALL_BACK              19
#define EZ_CALLBACK               EZ_CALL_BACK
#define EZ_FOREGROUND             20
#define EZ_BACKGROUND             21
#define EZ_BITMAP_FILE            22
#define EZ_PIXMAP_FILE            EZ_BITMAP_FILE
#define EZ_BITMAP_DATA            23   
#define EZ_PIXMAP_DATA            24
#define EZ_X_PIXMAP               25
#define EZ_LABEL_PIXMAP           26
#define EZ_LABELPIXMAP            EZ_LABEL_PIXMAP
#define EZ_FONT_ID                27
#define EZ_FONT_NAME              28
#define EZ_TEXT_LINE_LENGTH       29
#define EZ_SLIDER_LENGTH          30
#define EZ_SLIDERLENGTH           EZ_SLIDER_LENGTH
#define EZ_SLIDER_WIDTH           31
#define EZ_SLIDERWIDTH            EZ_SLIDER_WIDTH
#define EZ_SLIDER_BORDER_WIDTH    32
#define EZ_SLIDER_BORDERWIDTH     EZ_SLIDER_BORDER_WIDTH
#define EZ_SLIDER_RESOLUTION      33
#define EZ_SLIDER_RANGE           34
#define EZ_INDICATOR_SIZE_ADJUST  35
#define EZ_IMAGE_FILE             36
#define EZ_BUTTON_SHORTCUT        37
#define EZ_SHORTCUT_KEY           EZ_BUTTON_SHORTCUT  
#define EZ_EVENT_HANDLE           38
#define EZ_EVENT_HANDLER          EZ_EVENT_HANDLE
#define EZ_LABEL_STRING           39
#define EZ_RESERVE_MENU_BUTTON    40
#define EZ_BACKING_STORE          41
#define EZ_EXPAND                 42  
#define EZ_TRANSIENT              43
#define EZ_SCROLLBAR_WIDTH        44
#define EZ_SCROLLBAR_BORDER_WIDTH 45
#define EZ_TEXT_SPACING           46
#define EZ_UNDERLINE              47
#define EZ_BUBBLE_HELP            48
#define EZ_FREELABEL_MOVABLE      49
#define EZ_ITEM_MOVABLE           EZ_FREELABEL_MOVABLE
#define EZ_INDICATOR_TYPE         50
#define EZ_INDICATOR_COLOR        51
#define EZ_TEXT_BACKGROUND        52  
#define EZ_SLIDER_DISPLAY_VALUE   53
#define EZ_SELECTION_BACKGROUND   54
#define EZ_SELECTION_FOREGROUND   55
#define EZ_ATTACH_PTR_DATA        56
#define EZ_ATTACH_INT_DATA        57
#define EZ_USER_PTR_DATA          EZ_ATTACH_PTR_DATA    
#define EZ_USER_INT_DATA          EZ_ATTACH_INT_DATA
#define EZ_CLIENT_PTR_DATA        EZ_ATTACH_PTR_DATA    
#define EZ_CLIENT_INT_DATA        EZ_ATTACH_INT_DATA
#define EZ_DESTROY_CALLBACK       58
#define EZ_EMBEDER                59
#define EZ_IS_EMBEDER             EZ_EMBEDER
#define EZ_DND_DRAG_CURSOR        60
#define EZ_DND_BUBBLE_HELP        61
#define EZ_SHAPED_WINDOW          62
#define EZ_MOTION_CALLBACK        63

#define EZ_CHECK_BUTTON_ON_VALUE  64
#define EZ_CHECK_BUTTON_OFF_VALUE 65
#define EZ_CHECK_BUTTON_ON_OFF    66
#define EZ_RADIO_BUTTON_GROUP     67
#define EZ_RADIO_BUTTON_VALUE     68
#define EZ_OPTIONAL_HSCROLLBAR    69
#define EZ_OPTIONAL_VSCROLLBAR    70
#define EZ_FANCY_LIST_BOX_TYPE    71
#define EZ_FANCY_LIST_BOX_COLUMNS 72
#define EZ_GLOB_PATTERN           73
#define EZ_TEXT_WIDGET_EDITABLE   74
#define EZ_ENTRY_STRING           75
#define EZ_RETURN_VALUE           76
#define EZ_SLIDER_INIT_VALUE      77
#define EZ_OPTIONAL_ENTRY_REMEMBER_HISTORY   78
#define EZ_OPTIONAL_ENTRY_EDITABLE  79
#define EZ_ITEM_WIDGET_WIDGET     80
#define EZ_RAW_RGB_DATA           81
#define EZ_MENU_TEAR_OFF          82
#define EZ_GRID_CELL_GEOMETRY     83
#define EZ_GRID_CELL_PLACEMENT    84
#define EZ_GRID_CONSTRAINS        85
#define EZ_GRID_ROW_CONSTRAINS    86
#define EZ_GRID_COLUMN_CONSTRAINS 87

#define EZ_LOCATION               88
#define EZ_SIZE                   89
#define EZ_GEOMETRY               90
#define EZ_SIZE_HINT              91

#define EZ_PADB                   92
#define EZ_HIGHLIGHT_PAD          EZ_PADB
#define EZ_OPAD                   EZ_PADB

#define EZ_NAME                   93

#define EZ_WIDGET_CONFIGURE_LAST_OPTION 94


#ifdef _EZ_WIDGET_CONFIGURE_C_
char *EZ_ConfigureOptionNames[] =
{
  "UNKNOWN",
  "EZ_X",
  "EZ_Y",
  "EZ_WIDTH",
  "EZ_HEIGHT",
  "EZ_WIDTH_HINT",
  "EZ_HEIGHT_HINT",
  "EZ_BORDER_WIDTH",
  "EZ_BORDER_TYPE",
  "EZ_PADX",
  "EZ_PADY",
  "EZ_IPADX",
  "EZ_IPADY",
  "EZ_ORIENTATION",
  "EZ_SIDE",
  "EZ_LABEL_POSITION",
  "EZ_JUSTIFICATION",
  "EZ_FILL_MODE",
  "EZ_PROPAGATE",
  "EZ_CALL_BACK",
  "EZ_FOREGROUND",
  "EZ_BACKGROUND",
  "EZ_BITMAP_FILE/EZ_PIXMAP_FILE",
  "EZ_BITMAP_DATA",
  "EZ_PIXMAP_DATA",
  "EZ_X_PIXMAP",
  "EZ_LABEL_PIXMAP",
  "EZ_FONT_ID",
  "EZ_FONT_NAME",
  "EZ_TEXT_LINE_LENGTH",
  "EZ_SLIDER_LENGTH",
  "EZ_SLIDER_WIDTH",
  "EZ_SLIDER_BORDERWIDTH",
  "EZ_SLIDER_RESOLUTION",
  "EZ_SLIDER_RANGE",
  "EZ_INDICATOR_SIZE_ADJUST",
  "EZ_IMAGE_FILE",
  "EZ_BUTTON_SHORTCUT_KEY",
  "EZ_EVENT_HANDLE",
  "EZ_LABEL_STRING",
  "EZ_RESERVE_MENU_BUTTON",
  "EZ_BACKING_STORE",
  "EZ_EXPAND",
  "EZ_TRANSIENT",
  "EZ_SCROLLBAR_WIDTH",
  "EZ_SCROLLBAR_BORDER_WIDTH",
  "EZ_TEXT_SPACING",
  "EZ_UNDERLINE",
  "EZ_BUBBLE_HELP",
  "EZ_FREELABEL_MOVABLE",
  "EZ_INDICATOR_TYPE",
  "EZ_INDICATOR_COLOR",
  "EZ_TEXT_BACKGROUND",
  "EZ_SLIDER_DISPLAY_VALUE",
  "EZ_SELECTION_BACKGROUND",
  "EZ_SELECTION_FOREGROUND",
  "EZ_ATTATCH_PTR_DATA",
  "EZ_ATTATCH_INT_DATA",
  "EZ_DESTROY_CALLBACK",
  "EZ_EMBEDER",
  "EZ_DND_DRAG_CURSOR",
  "EZ_DND_BUBBLE_HELP",
  "EZ_SHAPED_WINDOW",
  "EZ_MOTION_CALLBACK",

  "EZ_CHECK_BUTTON_ON_VALUE",
  "EZ_CHECK_BUTTON_OFF_VALUE",
  "EZ_CHECK_BUTTON_ON_OFF",
  "EZ_RADIO_BUTTON_GROUP",
  "EZ_RADIO_BUTTON_VALUE",
  "EZ_OPTIONAL_HSCROLLBAR",
  "EZ_OPTIONAL_VSCROLLBAR",
  "EZ_FANCY_LIST_BOX_TYPE",
  "EZ_FANCY_LIST_BOX_COLUMNS",
  "EZ_GLOB_PATTERN",
  "EZ_TEXT_WIDGET_EDITABLE",
  "EZ_ENTRY_STRING",
  "EZ_RETURN_VALUE",
  "EZ_SLIDER_INIT_VALUE",
  "EZ_OPTIONAL_ENTRY_REMEMBER_HISTORY",
  "EZ_OPTIONAL_ENTRY_EDITABLE",
  "EZ_ITEM_WIDGET_WIDGET",
  "EZ_RAW_RGB_DATA",
  "EZ_MENU_TEAR_OFF",
  "EZ_GRID_CELL_GEOMETRY",
  "EZ_GRID_CELL_PLACEMENT",
  "EZ_GRID_CONSTRAINS",
  "EZ_GRID_ROW_CONSTRAINS",
  "EZ_GRID_COLUMN_CONSTRAINS",
  "EZ_LOCATION",
  "EZ_SIZE",
  "EZ_GEOMETRY",
  "EZ_SIZE_HINT",
  "EZ_HIGHLIGHT_PAD",
  "EZ_NAME",
  NULL,
};
#else
extern char *EZ_ConfigureOptionNames[];
#endif

#endif
