/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
/*******************************************************************
 *  
 *  EZ Widget library. 
 *            Simple Local Grabs
 */
#define _EZ_WIDGET_GRAB_C_
#include "EZ_Widget.h"

/*******************************************************************
 *
 * Functions implemented in this file:
 */
void            EZ_SetGrab MY_ANSIARGS((EZ_Widget *widget));
void            EZ_ReleaseGrab MY_ANSIARGS((void));
int             EZ_WidgetIsViewable MY_ANSIARGS((EZ_Widget *widget));
void            EZ_RedisplayWidgetTree MY_ANSIARGS((EZ_Widget *widget));

/*******************************************************************
 *
 * Local Functions:
 */
EZ_Widget *EZ_GrabWidget = (EZ_Widget *)NULL;

void  EZ_SetGrab(widget)
     EZ_Widget *widget;
{
  EZ_GrabWidget = widget;
}

void EZ_ReleaseGrab()
{
  EZ_GrabWidget = NULL;
}

int EZ_WidgetIsViewable(widget)
     EZ_Widget *widget;
{
  if(widget)
    {
      int ok = (EZ_LookupWidgetFromAllHT(widget) &&
		EZ_WidgetWindow(widget) != (Window)NULL &&
		EZ_WidgetMapped(widget));
      if(ok)
	{
	  EZ_Widget *parent = EZ_WidgetParent(widget);
	  while(parent)
	    {
	      if(EZ_WidgetMapped(parent) == 0) return(0);
	      parent = EZ_WidgetParent(parent);
	    }
	  return(1);
	}
    }
  return(0);
}

void EZ_RedisplayWidgetTree(widget)
     EZ_Widget *widget;
{
  if(widget)
    {
      while(EZ_WidgetParent(widget))
	{
	  widget = EZ_WidgetParent(widget);
	}
      EZ_ReDisplayWidget(widget);
    }
}
/******************************************************************/
#undef _EZ_WIDGET_GRAB_C_
