/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
/*****************************************************************
 ***                                                           ***
 ***              Widget Tree                                  ***
 ***                                                           ***
 *****************************************************************/
#define _EZ_WIDGET_TREE_C_
#include "EZ_Widget.h"

/*********************************************************************
 * 
 *  Functions implemented in this file:
 */
EZ_Widget  *EZ_CreateListTree MY_ANSIARGS((EZ_Widget *parent, int hsc, int vsc));
void       EZ_DrawWidgetTree  MY_ANSIARGS((EZ_Widget *widget));

void           EZ_GetListTreeWidgetComponents MY_ANSIARGS((EZ_Widget *widget,
							   EZ_Widget **itr, EZ_Widget **hsc,
							   EZ_Widget **vsc));
void           EZ_SetListTreeWidgetTree MY_ANSIARGS((EZ_Widget *widget, EZ_TreeNode *tree));
EZ_TreeNode    *EZ_GetListTreeWidgetTree MY_ANSIARGS((EZ_Widget *widget));
EZ_TreeNode    *EZ_GetListTreeWidgetSelection MY_ANSIARGS((EZ_Widget *widget));

void        EZ_ListTreeWidgetSelectNode MY_ANSIARGS((EZ_Widget *widget, EZ_TreeNode *theNode, int *location));
void        EZ_ListTreeWidgetSelectNodeUsingItem MY_ANSIARGS((EZ_Widget *widget, EZ_Item *theItem, int *location));
/*********************************************************************
 * 
 *  Local Variables.
 */
static EZ_WidgetHandle EZ_TreeHandle =
{ 
  EZ_ComputeWidgetUnknownSize,
  EZ_DrawWidgetTree,
  EZ_FreeUnknownData,
  EZ_UnkownEventHandle,
};

/*********************************************************************/
EZ_Widget  *EZ_CreateListTree(parent, hscrollbar, vscrollbar)
     EZ_Widget  *parent;     /* parent widget    */
     int hscrollbar, vscrollbar;
{
  EZ_Widget  *wptr, *tframe, *itree, *hscroll=NULL, *vscroll=NULL;

  wptr = EZ_CreateNewWidget(parent);
  EZ_WidgetHandlingFunctions[EZ_WIDGET_TREE] = &EZ_TreeHandle;
  
  EZ_WidgetStacking(wptr) = EZ_VERTICAL;
  EZ_WidgetType(wptr) = EZ_WIDGET_TREE;
  EZ_WidgetBorderStyle(wptr)  = EZ_BORDER_NONE;
  EZ_WidgetBorderWidth(wptr)  = 0;
  EZ_WidgetFillMode(wptr) = EZ_FILL_VERTICALLY;

  EZ_WidgetPadX(wptr) = 0;
  EZ_WidgetPadY(wptr) = 0;
  EZ_WidgetSepX(wptr)= 0;
  EZ_WidgetSepY(wptr)= 0;

  tframe = EZ_TreeWTFrame(wptr) = EZ_CreateFrame(wptr,NULL);
  EZ_WidgetFillMode(tframe) = EZ_FILL_HORIZONTALLY;
  EZ_SetWidgetExpandFlag(tframe);
  EZ_WidgetBorderStyle(tframe)  = EZ_BORDER_NONE;
  EZ_WidgetBorderWidth(tframe)  = 0;
  EZ_WidgetPadX(tframe) = 0;
  EZ_WidgetPadY(tframe) = 0;
  EZ_WidgetSepX(tframe)= 0;
  EZ_WidgetSepY(tframe)= 0;

  itree = EZ_TreeWITree(wptr) = EZ_CreateITree(tframe);
  EZ_SetWidgetExpandFlag(itree);
  EZ_SetDoNotPropagateFlag(itree);
  if(vscrollbar)
    {
      vscroll = EZ_TreeWVScroll(wptr) = EZ_CreateScrollbar(tframe,EZ_WIDGET_VERTICAL_SCROLLBAR);
      EZ_SetWidgetExpandFlag(vscroll);
      EZ_ScrollObject(vscroll) = itree;
    }
  if(hscrollbar)
    {
      hscroll = EZ_TreeWHScroll(wptr) = EZ_CreateScrollbar(wptr,EZ_WIDGET_HORIZONTAL_SCROLLBAR);
      EZ_SetWidgetExpandFlag(hscroll);
      EZ_ScrollObject(hscroll) = itree;
    }
  EZ_ITreeWHScroll(itree) = hscroll;
  EZ_ITreeWVScroll(itree) = vscroll;  
  EZ_ITreeWTree(itree) = wptr;   

  return(wptr);
}
 
/*******************************************************************
 *
 *  Draw A Label Widget.
 */
void  EZ_DrawWidgetTree(wptr)
     EZ_Widget *wptr;
{
  if( EZ_WidgetNumChildren(wptr)> 2 ||
      (EZ_TreeWHScroll(wptr) == NULL &&  EZ_WidgetNumChildren(wptr) > 1))
    {
      int             w, h;
      Pixmap          pixmap;
      Window          win;
      GC              gc;
      unsigned long   bgpv;
      
      win = EZ_WidgetWindow(wptr);
      w   = EZ_WidgetWidth(wptr);
      h   = EZ_WidgetHeight(wptr);
  
      /*-----------------------------------------------------------
       *  Create a pixmap, draw into this pixmap in background and
       *  copy to the button window when finished.
       *----------------------------------------------------------*/
      pixmap = XCreatePixmap(EZ_Display, win, w, h, EZ_Depth);    
      EZ_GetBackgroundGC(wptr, &gc, &bgpv, 0, 0);
      XFillRectangle(EZ_Display, pixmap, gc, 0,0, w, h); 
      
      EZ_DrawRectBorder(wptr, pixmap);     
      XCopyArea(EZ_Display,pixmap,win, EZ_WRITABLEGC,0,0,w,h,0,0); 
      XFreePixmap(EZ_Display, pixmap); 
    }
}

/***************************************************************************
 *
 *  Supporting functions.
 */
void EZ_SetListTreeWidgetTree(widget, root)
     EZ_Widget *widget;
     EZ_TreeNode   *root;
{
  if(widget && root)
    {
      EZ_Widget *twidget = widget;
      switch(EZ_WidgetType(widget))
	{
	case EZ_WIDGET_TREE:
	  twidget = EZ_TreeWITree(widget);
	  break;
	default:
	  break;
	}
      EZ_SetITreeWTree(twidget, root);
    }
}

EZ_TreeNode *EZ_GetListTreeWidgetTree(widget)
     EZ_Widget *widget;
{
  if(widget)
    {
      EZ_Widget *twidget = NULL;
      switch(EZ_WidgetType(widget))
	{
	case EZ_WIDGET_TREE:
	  twidget = EZ_TreeWITree(widget);
	  break;
	case EZ_WIDGET_ITREE:
	  twidget  = widget;
	default:
	  break;
	}
      if(twidget) return(EZ_TreeWRoot(twidget));
    }
  return(NULL);
}
/************************************************************************************/
EZ_TreeNode *EZ_GetListTreeWidgetSelection(widget)
     EZ_Widget *widget;
{
  if(widget)
    {
      EZ_Widget *twidget = NULL;
      switch(EZ_WidgetType(widget))
	{
	case EZ_WIDGET_TREE:
	  twidget = EZ_TreeWITree(widget);
	  break;
	case EZ_WIDGET_ITREE:
	  twidget  = widget;
	default:
	  break;
	}
      if(twidget) return(EZ_ITreeWSelection(twidget));
    }
  return(NULL);
}
/************************************************************************************/
void  EZ_GetListTreeWidgetComponents(widget, itree_ret, h_ret, v_ret)
     EZ_Widget *widget;
     EZ_Widget **itree_ret, **h_ret, **v_ret;
{
  if(widget && EZ_WidgetType(widget) == EZ_WIDGET_TREE)
    {
      *itree_ret = EZ_TreeWITree(widget);
      *h_ret = EZ_TreeWHScroll(widget);
      *v_ret = EZ_TreeWVScroll(widget);
    }
}

void  EZ_ListTreeWidgetSelectNode(widget, node, location)
     EZ_Widget *widget; EZ_TreeNode *node; int *location;
{
  if(widget)
    {
      EZ_Widget *twidget = NULL;
      switch(EZ_WidgetType(widget))
	{
	case EZ_WIDGET_TREE:
	  twidget = EZ_TreeWITree(widget);
	  break;
	case EZ_WIDGET_ITREE:
	  twidget  = widget;
	default:
	  break;
	}
      if(twidget)
	EZ_ITreeSelectNode(twidget, node, location);
    }
}
void EZ_ListTreeWidgetSelectNodeUsingItem(widget, item, location)
     EZ_Widget *widget; EZ_Item *item; int *location;
{
  if(widget)
    {
      EZ_Widget *twidget = NULL;
      switch(EZ_WidgetType(widget))
	{
	case EZ_WIDGET_TREE:
	  twidget = EZ_TreeWITree(widget);
	  break;
	case EZ_WIDGET_ITREE:
	  twidget  = widget;
	default:
	  break;
	}
      if(twidget)
	EZ_ITreeSelectNodeUsingItem(twidget, item, location);
    }
}
/************************************************************************************/
#undef _EZ_WIDGET_TREE_C_
