/************************** Example A *********************************/

#include "EZ.h"

static int border_types[6] = { EZ_BORDER_RAISED, EZ_BORDER_SUNKEN, EZ_BORDER_RIDGE,
			       EZ_BORDER_GROOVE, EZ_BORDER_FLAT,  EZ_BORDER_NONE};

static char *border_names[] = {"EZ_BORDER_RAISED", "EZ_BORDER_SUNKEN",
    "EZ_BORDER_RIDGE", "EZ_BORDER_GROOVE", "EZ_BORDER_FLAT", "EZ_BORDER_NONE"};

static  char *msg = "Different Borders Supported by EZWGL";


main(int ac, char **av)
{
  EZ_Widget  *toplevel, *frame, *tmp;
  int        i, j;
  char       str[32];
  
  EZ_Initialize(ac,av,0);                                 /* Initialize EZWGL   */
  toplevel = EZ_CreateFrame(NULL,NULL); 
  EZ_ConfigureWidget(toplevel, EZ_ORIENTATION, EZ_VERTICAL, 0);
  tmp = EZ_CreateLabel(toplevel, msg);
  EZ_ConfigureWidget(tmp, EZ_FOREGROUND, "red", 
		     EZ_TEXT_LINE_LENGTH, 80,
		     EZ_FONT_NAME,  "-Adobe-Times-Bold-I-Normal--*-180-*-*-*-*-*-*",   
		     0);

  toplevel = EZ_CreateFrame(toplevel,NULL); 
  EZ_ConfigureWidget(toplevel,                            
                     EZ_ORIENTATION, EZ_VERTICAL,         /* vertical orien.    */
		     EZ_SIDE, EZ_RIGHT, 0);               /* align children =>  */

  for(i = 0; i < 6; i++)
    {
      frame = EZ_CreateFrame(toplevel, NULL);
      EZ_ConfigureWidget(frame, EZ_IPADX, 6, 0);
      for(j = 0; j < 5; j++)
        {
          sprintf(str,"Bd width %d",j);
          tmp = EZ_CreateLabel(frame, j == 0 ? border_names[i] : str);
          EZ_ConfigureWidget(tmp, EZ_BORDER_TYPE, border_types[i],
                             EZ_BORDER_WIDTH, j, 0);
	}
    }
  EZ_DisplayWidget(toplevel); 
  EZ_EventMainLoop();
}
/************************** Example A *********************************/
