/************************** Example C *********************************/
#include "EZ.h"

extern void exit();
static EZ_Widget *button;

static void vslider_callback(EZ_Widget *widget, void *data)
{
  EZ_ConfigureWidget(button, 
		     EZ_PADY,(int) EZ_GetSliderValue(widget), 0);
} 
static void hslider_callback(EZ_Widget *widget, void *data)
{
  EZ_ConfigureWidget(button, 
		     EZ_PADX,(int) EZ_GetSliderValue(widget), 0);
} 

static char *msg = "Horizontal and Vertical Paddings";

/**************************************************************************/

main(int ac, char **av)
{
  EZ_Widget *toplevel, *frame1, *frame2,  *hslider, *vslider, *tmp;
  int        i;

  EZ_Initialize(ac,av,0);

  toplevel = EZ_CreateFrame(NULL,NULL);
  EZ_ConfigureWidget(toplevel,  EZ_STACKING, EZ_VERTICAL,
		     EZ_FILL_MODE, EZ_FILL_BOTH,  0);

  tmp = EZ_CreateLabel(toplevel, msg);
  EZ_ConfigureWidget(tmp, EZ_FOREGROUND, "red", 
		     EZ_TEXT_LINE_LENGTH, 80,
		     EZ_FONT_NAME,  "-Adobe-Times-Bold-I-Normal--*-180-*-*-*-*-*-*",   
		     EZ_HEIGHT, 0,
		     0);

  frame1 = EZ_CreateFrame(toplevel, NULL);
  EZ_ConfigureWidget(frame1, EZ_EXPAND, True, 
		     EZ_FILL_MODE, EZ_FILL_BOTH, 0);
  frame2 = EZ_CreateFrame(frame1, NULL);  
  EZ_ConfigureWidget(frame2, EZ_BORDER_TYPE, EZ_BORDER_DOWN,
		     EZ_PROPAGATE, 0,
		     EZ_BORDER_WIDTH,2, 0);
  button = EZ_CreateButton(frame2,"Watch how the space\nbetween button border\nand this label changes\nas you slide the sliders", 0);
  vslider = EZ_CreateSlider(frame1, "PADY", 
			    0.0, 30.0, 4.0, EZ_VERTICAL_SLIDER);
  EZ_ConfigureWidget(vslider, 
		     EZ_SLIDER_BORDER_WIDTH,2,
		     EZ_SLIDER_RESOLUTION, 1.0,
		     EZ_CALL_BACK, vslider_callback, NULL, 0);

  hslider = EZ_CreateSlider(toplevel, "PADX",
    0.0, 40.0, 4.0, EZ_HORIZONTAL_SLIDER);
  EZ_ConfigureWidget(hslider,
		     EZ_HEIGHT, 0,
		     EZ_SLIDER_BORDER_WIDTH,2,
		     EZ_SLIDER_RESOLUTION, 1.0,
		     EZ_CALL_BACK, hslider_callback, NULL, 0);

  EZ_DisplayWidget(toplevel);
  EZ_EventMainLoop();
}
/************************** Example C *********************************/
