/************************** Example G *********************************/
#include "EZ.h"

extern void exit();
static EZ_Widget *Frame;
static int c_orien = EZ_HORIZONTAL;

static int Orientations[] = { 
  EZ_VERTICAL, EZ_VERTICAL_TOP, EZ_VERTICAL_BOTTOM, EZ_VERTICAL_CENTER,
  EZ_HORIZONTAL, EZ_HORIZONTAL_LEFT, EZ_HORIZONTAL_RIGHT, EZ_HORIZONTAL_CENTER};

static char *OrientationNames[] = { 
  "V", "V_TOP", "V_BOTTOM", "V_CENTER",
  "H", "H_LEFT", "H_RIGHT", "H_CENTER" };

static int FillModes[] = { 
  EZ_FILL_NONE, EZ_FILL_HORIZONTALLY, EZ_FILL_VERTICALLY, EZ_FILL_BOTH};

static char *FillModeNames[] = { 
  "NONE", "HORIZONTALLY", "VERTICALLY", "BOTH"};

static void rbuttonsF_callback(EZ_Widget *widget, void *data)
{
  int fmode = EZ_GetRadioButtonGroupVariableValue(widget);
  EZ_ConfigureWidget(Frame, EZ_FILL_MODE, fmode, 0);
} 

static void rbuttons_callback(EZ_Widget *widget, void *data)
{
  int i, j;
  c_orien = EZ_GetRadioButtonGroupVariableValue(widget);
  EZ_ConfigureWidget(Frame, EZ_ORIENTATION, c_orien, 0);
}

main(int ac, char **av)
{
  EZ_Widget *toplevel, *frame1, *frame2, *frame3, *tmp;
  int        i;
  char       str[128];

  EZ_Initialize(ac,av,0);

  toplevel = EZ_CreateFrame(NULL,NULL);
  EZ_ConfigureWidget(toplevel, EZ_ORIENTATION, EZ_VERTICAL,0);

  tmp = EZ_CreateLabel(toplevel, "Test Fill Mode");
  EZ_ConfigureWidget(tmp, EZ_FOREGROUND, "red", 
		     EZ_TEXT_LINE_LENGTH, 80,EZ_HEIGHT, 0,
		     EZ_FONT_NAME,  "-Adobe-Times-Bold-I-Normal--*-180-*-*-*-*-*-*",   
		     0);

  toplevel = EZ_CreateFrame(toplevel,NULL);
  Frame = frame1 = EZ_CreateFrame(toplevel, NULL);
  EZ_ConfigureWidget(frame1, EZ_WIDTH, 500, EZ_HEIGHT, 300, 
		     EZ_BORDER_TYPE, EZ_BORDER_SUNKEN, 
		     EZ_BORDER_WIDTH, 2, 0);

  for(i = 0; i < 4; i++)
    {
      sprintf(str, "Button %d", (1 <<(i*i*2)));
      if(i%2 == 0) strcat(str, "\nLine 2");
      if(i != 1) tmp = EZ_CreateButton(frame1, str,-1);
      else 
	{
	  tmp = EZ_CreateButton(frame1, "Quit", 0);
	  EZ_ConfigureWidget(tmp, EZ_CALLBACK, exit, NULL,
			     EZ_FOREGROUND, "red", EZ_BACKGROUND, "bisque", 0);
	}
      if(i == 0) EZ_ConfigureWidget(tmp,EZ_BITMAP_FILE, "woman",0);
      else if(i == 2) EZ_ConfigureWidget(tmp,EZ_BITMAP_FILE,"xterm.xpm",0);
    }

  frame2 = EZ_CreateFrame(toplevel, "EZ_ORIENTATION");  
  EZ_ConfigureWidget(frame2, EZ_ORIENTATION, EZ_VERTICAL,
		     EZ_SIDE, EZ_LEFT, 0);

  frame3 = EZ_CreateFrame(toplevel, "EZ_FILL_MODE");  
  EZ_ConfigureWidget(frame3, EZ_ORIENTATION, EZ_VERTICAL,
		     EZ_SIDE, EZ_LEFT, 0);

  for(i = 0; i < 8; i++)
    {
      tmp = EZ_CreateRadioButton(frame2, OrientationNames[i], -1, 0, 
				 Orientations[i]);
      EZ_SetWidgetCallBack(tmp, rbuttons_callback, NULL);
    }
  EZ_SetRadioButtonGroupVariableValue(tmp, EZ_HORIZONTAL);

  for(i = 0; i < 4; i++)
    {
      tmp = EZ_CreateRadioButton(frame3, FillModeNames[i], -1, 1, 
				 FillModes[i]);
      EZ_SetWidgetCallBack(tmp, rbuttonsF_callback, NULL);
    }
  EZ_SetRadioButtonGroupVariableValue(tmp, EZ_FILL_NONE);

  EZ_DisplayWidget(toplevel);
  EZ_EventMainLoop();
}
/************************** Example G *********************************/



