/************************** Example I *********************************/
/*
 *   Test EZ_SwapWidgets. 
 */
#include "EZ.h" 

static char font18[] =  "-Adobe-Times-Bold-R-Normal--*-180-*-*-*-*-*-*";
static char *colors[] = {"red","blue","cyan","magenta","yellow",
			   "green", "#7f0000", "#007f7f","#7f007f"};

static char *msg = "Test EZ_SwapWidgets.";

/**********************************************************************/
EZ_Widget *frame[8], *btns[8][10];

static void btns_callback(EZ_Widget *btn, void *data);

main(int argc, char **argv)
{
  int   i,j;
  char  str[128];
  EZ_Widget *toplevel, *toplevelA, *tmp;

  EZ_Initialize(argc,argv,0);       /* initialize EZWGL    */
  toplevel = EZ_CreateFrame(NULL, NULL);
  tmp = EZ_CreateLabel(toplevel, msg);
  EZ_ConfigureWidget(tmp, EZ_FOREGROUND, "red", EZ_FONT_NAME,font18,0);
  EZ_ConfigureWidget(toplevel, EZ_ORIENTATION, EZ_VERTICAL,
		     EZ_WIDTH, 500,
		     EZ_FILL_MODE,EZ_FILL_BOTH,
		     EZ_BORDER_TYPE, EZ_BORDER_SUNKEN, EZ_BORDER_WIDTH, 4,
		     EZ_IPADY, 0, 0);
  toplevelA = EZ_CreateFrame(NULL, NULL);
  EZ_ConfigureWidget(toplevelA, EZ_ORIENTATION, EZ_VERTICAL,
		     EZ_WIDTH, 500,
		     EZ_FILL_MODE,EZ_FILL_BOTH,
		     EZ_BACKGROUND,"bisque",
		     EZ_BORDER_TYPE, EZ_BORDER_SUNKEN, EZ_BORDER_WIDTH, 4,
		     EZ_IPADY, 0, 0);
  
  for(i = 0; i < 4; i++)
    {
      frame[i] = EZ_CreateFrame(toplevel,NULL);
      EZ_ConfigureWidget(frame[i], EZ_FILL_MODE,EZ_FILL_BOTH,
			 EZ_ORIENTATION,EZ_HORIZONTAL_CENTER,
			 EZ_PADX,0,EZ_PADY,0,EZ_IPADX,0,EZ_IPADY,0,
			 0);
      for(j = 0; j < 8; j++)
	{
	  sprintf(str, "%c %d",'A'+i, j);
	  btns[i][j] = EZ_CreateButton(frame[i], str, -1);
	  EZ_ConfigureWidget(btns[i][j],
			     EZ_FONT_NAME, font18,
			     EZ_WIDTH,50,
			     EZ_FOREGROUND, colors[i],
			     EZ_CALL_BACK, btns_callback, NULL, 0);
	}
    }
  for(i = 4; i < 8; i++)
    {
      frame[i] = EZ_CreateFrame(toplevelA,NULL);
      EZ_ConfigureWidget(frame[i], EZ_FILL_MODE,EZ_FILL_BOTH,
			 EZ_ORIENTATION,EZ_HORIZONTAL_CENTER,
			 EZ_BACKGROUND,"bisque",
			 EZ_PADX,0,EZ_PADY,0,EZ_IPADX,0,EZ_IPADY,0,
			 0);
      for(j = 0; j < 8; j++)
	{
	  sprintf(str, "%c %d", 'A'+i,j);
	  btns[i][j] = EZ_CreateButton(frame[i], str, -1);
	  EZ_ConfigureWidget(btns[i][j],
			     EZ_FONT_NAME, font18,
			     EZ_FOREGROUND, colors[i],
			     EZ_CALL_BACK, btns_callback, NULL, 0);
	}
    }
  EZ_ConfigureWidget(btns[0][0],EZ_BACKGROUND, "#007f6f",0);
  EZ_DisplayWidget(toplevel); 
  EZ_DisplayWidget(toplevelA); 
  EZ_EventMainLoop();
} 

static void btns_callback(EZ_Widget *widget,void *data)
{
  int  m,n, k,l;

  m = (rand()>>5) % 8;
  n = (rand()>>5) % 8;
  k = (rand()>>5) % 8;  
  l = (rand()>>5) % 8;  
  return;

  if(widget == btns[0][0]) EZ_SwapWidgets(frame[m],btns[n][l]);  
  else if(k < 2) EZ_SwapWidgets(frame[m],frame[n]);
  else EZ_SwapWidgets(btns[m][k],btns[n][l]);
}
int _test_ = 0; 
