/****************************************************************
 ***                                                          ***
 ***     checkbutton.c                                        ***
 ***          check buttons                                   ***
 ***                                                          ***
 ***************************************************************/
#include "EZ.h"
#define ON  1
#define OFF 0

/*************************************************************************/
static char *colors[] = {
  "red",
  "green",
  "blue",
  "yellow",
  "cyan",
  "magenta",
  "white",
  "grey62",
  "black",
};
#define REDC     0
#define GREENC   1
#define BLUEC    2
#define YELLOWC  3
#define CYANC    4
#define MAGENTAC 5
#define WHITEC   6
#define GRAYC    7
#define BLACKC   8

void my_exit(EZ_Widget *w, void *v)
{
  EZ_Shutdown();
  exit(0);
}
/************************************************************************
 *
 *  fslistbox callback
 */
static void cbutton_callback(widget, data)
     EZ_Widget *widget; void *data;
{
  int onoff, color, k;

  onoff = EZ_GetCheckButtonState(widget, &color);
  k = EZ_GetWidgetIntData(widget);
  if(k == 111)
    my_exit(NULL, NULL);
/*  if(k == 111)
    {
      if(onoff == ON)
	EZ_ConfigureWidget(widget, EZ_FOREGROUND, colors[color], 
			   EZ_BITMAP_FILE, "flagdown", 0);
      else
	EZ_ConfigureWidget(widget, EZ_FOREGROUND, colors[color], 
			   EZ_BITMAP_FILE, "flagup", 0);
    }
  else
    EZ_ConfigureWidget(widget, EZ_FOREGROUND, colors[color], 0);
*/
}    
/**************************************************************************/

static EZ_Widget *create_check_button_box(parent, label_string)
     EZ_Widget *parent;
     char      *label_string;
{
  EZ_Widget *frame, *frame1, *tmp;

  frame = EZ_CreateFrame(parent, label_string);
  EZ_ConfigureWidget(frame,  EZ_STACKING, EZ_VERTICAL, 0);

  tmp = EZ_CreateLabel(frame, "A Set of Check Buttons");
  EZ_ConfigureWidget(tmp, EZ_FONT_NAME, 
		      "-Adobe-Times-Bold-R-Normal--*-180-*-*-*-*-*-*",  0);

  frame1 = EZ_CreateFrame(frame,"Check Buttons");
  EZ_ConfigureWidget(frame1,  EZ_STACKING, EZ_VERTICAL, EZ_SIDE, EZ_LEFT,
		     EZ_FILL_MODE, EZ_FILL_BOTH, 0);
  tmp = EZ_CreateCheckButton(frame1, "Red", -1, REDC, BLACKC, OFF);
  EZ_ConfigureWidget(tmp,EZ_CALL_BACK, cbutton_callback, NULL,
		     EZ_BORDER_TYPE,EZ_BORDER_UP,
		     EZ_BORDER_WIDTH,2,
		     EZ_SHORTCUT_KEY,"C-G",
		     EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_INDICATOR_TYPE, EZ_CIRCLE_INDICATOR,
		     EZ_INDICATOR_COLOR, "red", 0);

  tmp = EZ_CreateCheckButton(frame1, "Green",-1, GREENC, BLACKC, OFF);
  EZ_ConfigureWidget(tmp,EZ_CALL_BACK, cbutton_callback, NULL,
		     EZ_BORDER_TYPE,EZ_BORDER_UP,
		     EZ_BORDER_WIDTH,2,
		     EZ_SHORTCUT_KEY,"C-F",
		     EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_INDICATOR_TYPE, EZ_SQUARE_INDICATOR,
		     EZ_INDICATOR_COLOR, "magenta", 0);

  tmp = EZ_CreateCheckButton(frame1, "Blue",0, BLUEC, BLACKC, OFF);
  EZ_ConfigureWidget(tmp,EZ_CALL_BACK, cbutton_callback, NULL,
		     EZ_BORDER_TYPE,EZ_BORDER_UP,
		     EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_BACKGROUND, "bisque2",
		     EZ_INDICATOR_TYPE, EZ_RECTANGLE_INDICATOR,/* EZ_EMPTY_INDICATOR,*/
		     EZ_INDICATOR_COLOR, "magenta", 0);
  tmp = EZ_CreateCheckButton(frame1, "Blue",0, BLUEC, BLACKC, OFF);
  EZ_ConfigureWidget(tmp,EZ_CALL_BACK, cbutton_callback, NULL,
		     EZ_BORDER_TYPE,EZ_BORDER_UP,
		     EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_BACKGROUND, "bisque2",
		     EZ_INDICATOR_TYPE, EZ_DIAMOND_INDICATOR,
		     EZ_INDICATOR_COLOR, "magenta", 0);

  tmp = EZ_CreateCheckButton(frame1, "Blue",0, BLUEC, BLACKC, OFF);
  EZ_ConfigureWidget(tmp,EZ_CALL_BACK, cbutton_callback, NULL,
		     EZ_BORDER_TYPE,EZ_BORDER_UP,
		     EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_INDICATOR_TYPE, EZ_SUNKEN_SQUARE_INDICATOR,
		     EZ_INDICATOR_COLOR, "magenta",0);
  tmp = EZ_CreateCheckButton(frame1, "Blue",0, BLUEC, BLACKC, OFF);
  EZ_ConfigureWidget(tmp,EZ_CALL_BACK, cbutton_callback, NULL,
		     EZ_BORDER_TYPE,EZ_BORDER_DOWN,
		     EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_INDICATOR_TYPE, EZ_CHECK_INDICATOR,
		     EZ_HEIGHT,100,
		     EZ_INDICATOR_COLOR, "magenta",0);
  tmp = EZ_CreateCheckButton(frame1, "Blue",0, BLUEC, BLACKC, OFF);
  EZ_ConfigureWidget(tmp,EZ_CALL_BACK, cbutton_callback, NULL,
		     EZ_BORDER_TYPE,EZ_BORDER_UP,
		     EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_INDICATOR_TYPE, EZ_SUNKEN_DIAMOND_INDICATOR,
		     EZ_INDICATOR_COLOR, "magenta",0);
  tmp = EZ_CreateCheckButton(frame1, NULL,0, YELLOWC, BLACKC, OFF);
  EZ_ConfigureWidget(tmp, EZ_ORIENTATION, EZ_VERTICAL, 
		     EZ_BORDER_TYPE,EZ_BORDER_UP,
		     EZ_BORDER_WIDTH,2,
		     EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_CALLBACK, cbutton_callback, NULL,
		     /* EZ_INDICATOR_TYPE, EZ_DIAMOND_INDICATOR,*/
		     EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR,
		     EZ_INDICATOR_COLOR, "blue", 0);
  {
    EZ_Widget *abc = EZ_CreateNWLabel(tmp,NULL);
    EZ_ConfigureWidget(abc, EZ_BITMAP_FILE, "dog3.xpm",0);
    abc = EZ_CreateNWLabel(tmp,"Something Yellow");    
  }
  /* A bitmap labeled c button */
  tmp = EZ_CreateCheckButton(frame1, "Cyan", 0, CYANC, BLACKC, OFF);
  EZ_SetWidgetIntData(tmp, 111);
  EZ_ConfigureWidget(tmp, EZ_CALL_BACK, cbutton_callback, NULL,
		     EZ_BITMAP_FILE, "flagup",
		     /* EZ_INDICATOR_TYPE, EZ_CHECK_INDICATOR,*/
		     EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR,
		     EZ_BORDER_TYPE, EZ_BORDER_UP, EZ_BORDER_WIDTH, 2, 0);

  return(frame);
  EZ_EventMainLoop();
}
/************************************************************************/
#ifdef EZ_MAIN
main(ac,av) int ac; char **av;
{
  EZ_Initialize(ac,av,0);
  EZ_DisplayWidget(create_check_button_box(NULL, NULL));
  EZ_EventMainLoop();
}
#endif



