/******************************************************************************
 *
 *  EZ GL Demo. Test dithering. (for Pseudo color visuals)
 */
#include "EZ.h"

static void event_handle();

main(int argc, char **argv)
{
  EZ_Widget *frame, *canvas;
  /*
   * Create a 3DCanvas, configure it and display it.
   * This must be done before invoking any routines
   * from the EZ graphics library.
   */
  EZ_Initialize(argc, argv, 1);
  frame = EZ_CreateFrame(NULL,NULL);
  EZ_ConfigureWidget(frame, EZ_WIDTH, 320, EZ_HEIGHT, 320,EZ_FILL_MODE, EZ_FILL_BOTH, 0);
  canvas = EZ_Create3DCanvas(frame);
  EZ_ConfigureWidget(canvas, EZ_EVENT_HANDLE, event_handle, NULL, 0);
  EZ_DisplayWidget(canvas);

  EZ_RGBMode();                                       /* select color mode    */
  EZ_ShadeModel(EZ_SMOOTH);                           /* select shading model */
  EZ_LoadIdentity();
  EZ_Ortho2(-1.0,1.0,-1.0,1.0);
  EZ_EventMainLoop();        
}

static void draw(EZ_Widget *canvas)
{
  EZ_Clear(EZ_COLOR_BUFFER_BIT);
  EZ_Begin(EZ_POLYGON);
  EZ_Color3f(1.0,0.0,0.0);
  EZ_Vertex2f(1.0,0.0);
  EZ_Color3f(1.0,1.0,0.0);
  EZ_Vertex2f(0.5,0.866);
  EZ_Color3f(0.0,1.0,0.0);
  EZ_Vertex2f(-0.5,0.866);
  EZ_Color3f(0.0,1.0,1.0);
  EZ_Vertex2f(-1.0,0.0);
  EZ_Color3f(0.0,0.0,1.0);
  EZ_Vertex2f(-0.5,-0.866);
  EZ_Color3f(1.0,0.0,1.0);
  EZ_Vertex2f(0.5,-0.866);
  EZ_End();
}

static void event_handle(EZ_Widget *canvas,
			 void *data,
			 int eventType,
			 XEvent *xevent)
{
  switch(eventType) {
  case EZ_REDRAW:
    draw(canvas);
    break;
  case EZ_KEY_PRESS:
    if(EZ_PressedKey == EZ_ESCAPE_KEY) exit(0);
    break;
  default:
    break;
  }
}
/***************************************************************/
  

   

