/****************************************************************
 ***                                                          ***
 ***     menu.c                                               ***
 ***          popup and pulldown menus                        ***
 ***                                                          ***
 ***************************************************************/
#include "EZ.h"
void my_exit(EZ_Widget *w, void *d)
{
  EZ_Shutdown();
  exit(0);
}

static void testPopup(EZ_Widget *, void *);
static void testMCallback(EZ_Widget *, void *);
/*************************************************************************/
static char *colors[] = {
  "red",
  "green",
  "blue",
  "yellow",
  "cyan",
  "magenta",
  "white",
  "grey62",
  "bisque",
  "yellowgreen",
  "yellow2",
};
#define REDC         0
#define GREENC       1

#define YELLOWC      3
#define CYANC        4
#define MAGENTAC     5
#define WHITEC       6
#define GRAYC        7
#define BISQUEC      8
#define YELLOWGREENC 9


static char *borders[] = {
  "Raised",
  "Sunken",
  "ridge",
  "Groove",
  "Flat",
  "None",
};
static int bordertypes[] = {
  EZ_BORDER_UP, EZ_BORDER_DOWN, EZ_BORDER_FRAMED_UP,
  EZ_BORDER_FRAMED_DOWN, EZ_BORDER_FLAT, EZ_BORDER_NONE, };

#define RAISED  0
#define SUNKEN  1
#define RIDGE   2
#define GROOVE  3
#define FLAT    4
#define NONE    5


static char *fonts[] = {
  "fixed",
  "9x15",
 "-Adobe-Helvetica-Medium-R-Normal--*-120-*-*-*-*-*-*",
 "-*-Courier-Medium-R-Normal--*-120-*-*-*-*-*-*",
 "-Adobe-Helvetica-Bold-R-Normal--*-120-*-*-*-*-*-*",
 "-Adobe-Times-Bold-I-Normal--*-120-*-*-*-*-*-*",
 "-Adobe-Helvetica-Medium-R-Normal--*-180-*-*-*-*-*-*",
 "-*-Courier-Medium-R-Normal--*-180-*-*-*-*-*-*",
 "-Adobe-Helvetica-Bold-R-Normal--*-180-*-*-*-*-*-*",
 "-Adobe-Times-Bold-I-Normal--*-180-*-*-*-*-*-*",
 "-Adobe-Helvetica-Medium-R-Normal--*-240-*-*-*-*-*-*",
 "-*-Courier-Medium-R-Normal--*-240-*-*-*-*-*-*",
 "-Adobe-Helvetica-Bold-R-Normal--*-240-*-*-*-*-*-*",
 "-Adobe-Times-Bold-I-Normal--*-240-*-*-*-*-*-*",
};
#define NFONTS 14
  
static EZ_Widget *label;

static void mcbk(mbtn)         /* set the foreground of label */
     EZ_Widget *mbtn;
{
  printf("%lx called ...\n", mbtn);
}


static void colorMCallback(menu)         /* set the foreground of label */
     EZ_Widget *menu;
{
  int i = EZ_GetWidgetReturnData(menu);
  if( i >= REDC && i <= YELLOWGREENC)
    EZ_ConfigureWidget(label, EZ_FOREGROUND, colors[i], 0);
}

static void borderMCallback(menu)        /* set the border type of label */
     EZ_Widget *menu;
{
  int i = EZ_GetWidgetReturnData(menu);
  if( i >= RAISED && i <= NONE)
    EZ_ConfigureWidget(label, EZ_BORDER_TYPE, bordertypes[i], 0);
}

static void bwidthMCallback(menu)        /* set the border width of label */
     EZ_Widget *menu;
{
  int i = EZ_GetWidgetReturnData(menu);
  if( i >= 0 && i <= 30)
    EZ_ConfigureWidget(label, EZ_BORDER_WIDTH, i, 0);
}
     
static void fontMCallback(menu)          /* set the font of label        */
     EZ_Widget *menu;
{
  int i = EZ_GetWidgetReturnData(menu);
  if( i >= 0 && i < NFONTS)
    EZ_ConfigureWidget(label, EZ_FONT_NAME, fonts[i], 0);
}
/**************************************************************************/

main(ac, av)
     int ac; char **av;
{
  EZ_Widget *frame1, *frame2, *tmp, *tmpa, *abc;
  EZ_Widget *colorM, *borderM, *bwidthM, *fontM, *menuM, *testM, *nm1, *nm2;
  int       i;
  char      str[160];

  EZ_Initialize(ac,av,0);
/*  EZ_SetGlobalBackground("#00bfaf");*/

  /*
   *  Create 5 menus.
   */
  colorM = EZ_CreatePopupMenu("test");
  EZ_SetWidgetCallBack(colorM, colorMCallback, NULL);
  for(i = REDC; i <= YELLOWGREENC ; i++)
    {
      tmp = EZ_CreateMenuNormalButton(colorM, colors[i], -1, i);
      sprintf(str, "Ctrl-%c", *colors[i]);
      EZ_ConfigureWidget(tmp, EZ_SHORTCUT_KEY, str,0);
      if(i == WHITEC) (void) EZ_CreateMenuSeparator(colorM);
    }

  borderM = EZ_CreatePopupMenu("Border Types");
  EZ_SetWidgetCallBack(borderM, borderMCallback, NULL);
  for(i = RAISED; i <= NONE; i++)
    {
      tmp = EZ_CreateMenuRadioButton(borderM, borders[i], -1, 0, i, i);
      sprintf(str, "Meta-%c", *borders[i]);
      EZ_ConfigureWidget(tmp, EZ_SHORTCUT_KEY, str,
		     EZ_INDICATOR_TYPE, EZ_CIRCLE_INDICATOR,
			 0);
    }

  nm2 = EZ_CreatePopupMenu("N M 2");
  EZ_SetWidgetCallBack(nm2, fontMCallback, NULL);
  for(i = 0; i < NFONTS; i++)
    {
      tmp = EZ_CreateMenuRadioButton(nm2, fonts[i], -1, 21, i, i);
      EZ_ConfigureWidget(tmp, EZ_TEXT_LINE_LENGTH, 80, 0);
    }


  nm1 = EZ_CreatePopupMenu("N m 1");
  EZ_SetWidgetCallBack(nm1, borderMCallback, NULL);
  for(i = RAISED; i <=  NONE ; i++)
    {
      tmp = EZ_CreateMenuRadioButton(nm1, borders[i], -1,22, i, i);
      sprintf(str, "Meta-%c", *borders[i]);
      EZ_ConfigureWidget(tmp, EZ_SHORTCUT_KEY, str,
		     EZ_INDICATOR_TYPE, EZ_CIRCLE_INDICATOR,
			 0);
    }
  tmp = EZ_CreateMenuSubMenu(nm1, "fdfda", 0);
  EZ_SetSubMenuMenu(tmp,nm2);


  testM = EZ_CreatePopupMenu(NULL);
  for(i = REDC; i <= YELLOWGREENC ; i++)
    {
      tmp = EZ_CreateMenuNormalButton(testM, colors[i], -1, i);
      sprintf(str, "Ctrl-%c", *colors[i]);
      EZ_ConfigureWidget(tmp, EZ_SHORTCUT_KEY, str,0);
      if(i == WHITEC) (void) EZ_CreateMenuSeparator(testM);
    }
  EZ_CreateMenuSeparator(testM);
  /*
  tmp =EZ_CreateTextWidget(testM,1,1,1);
  EZ_ConfigureWidget(tmp, EZ_WIDTH,200, EZ_HEIGHT, 300, 0);
  EZ_TextLoadFile(tmp, "menu.c");
  */
  bwidthM = EZ_CreatePopupMenu("Border Width");
  EZ_SetWidgetCallBack(bwidthM, bwidthMCallback, NULL);
  for(i = 0; i <= 8; i++)
    {
      sprintf(str, "%d pixel(s)", i);
      tmp = EZ_CreateMenuRadioButton(bwidthM, str, -1, 1, i, i);
    }

  fontM = EZ_CreatePopupMenu("Font");
  EZ_SetWidgetCallBack(fontM, fontMCallback, NULL);
  for(i = 0; i < NFONTS; i++)
    {
      tmp = EZ_CreateMenuRadioButton(fontM, fonts[i], -1, 2, i, i);
      EZ_ConfigureWidget(tmp, EZ_TEXT_LINE_LENGTH, 80, 0);
    }

  abc = menuM = EZ_CreatePopupMenu("Sub-Menus");
/*  tmp = EZ_CreateMenuSubMenu(menuM, "Colors", 0); */
  tmp = EZ_CreateMenuSubMenu(menuM, "fdfda", 0);
  {
    EZ_Widget *abc = EZ_CreateButton(tmp,"this is a test", 1);
    abc = EZ_CreateNWLabel(tmp,"Something Yellow");    
    abc  = EZ_CreateNWLabel(tmp,NULL);
    EZ_ConfigureWidget(abc, EZ_BITMAP_FILE, "dog3.xpm",0);
  }

  EZ_ConfigureWidget(tmp, EZ_SHORTCUT_KEY, "Ctrl-c",0);
  EZ_SetSubMenuMenu(tmp,colorM);
  tmp = EZ_CreateMenuSubMenu(menuM, "Border Style", 0);
  EZ_SetSubMenuMenu(tmp,borderM);
  tmp = EZ_CreateMenuNormalButton(menuM, "Disabled Item", 0, -1);
  EZ_DisableWidget(tmp);
  tmp = EZ_CreateMenuSubMenu(menuM, "Border Width", 7);
  EZ_SetSubMenuMenu(tmp,nm1);
  EZ_CreateMenuSeparator(menuM);
  tmp = EZ_CreateMenuNormalButton(menuM, "Exit", 0, -1);
  EZ_SetWidgetCallBack(tmp, my_exit, NULL);


  
  /*
   *  make colorM a popup menu.
   */
  {
    EZ_Widget *tmenu = EZ_CreateSimpleMenu("|whatever %F|%m|BorderW%m||||%l|item2%f%x16|%tThis is a test|",
					   bwidthMCallback,NULL,colorM,bwidthM, bwidthMCallback, NULL, 
					    NULL);
    EZ_TiePopupMenu(tmenu, Button3, EZ_BOTTOM_RIGHT);
  }

  /*
   * the toplevel frame
   */
  frame1 = EZ_CreateFrame(NULL, NULL);
  EZ_ConfigureWidget(frame1, EZ_STACKING,EZ_VERTICAL, 
/*		     EZ_BACKGROUND, "bisque2",*/
		     EZ_FILL_MODE, EZ_FILL_VERTICALLY,
		     EZ_PADY, 0, 0);

  /*
   * create a frame and 5 menubuttons.
   */
  frame2 = EZ_CreateFrame(frame1, NULL);
  EZ_ConfigureWidget(frame2, EZ_EXPAND, True,
		     EZ_PADX, 0, EZ_PADY,0, EZ_X,0,EZ_Y,0,
		     EZ_IPADY, 0, EZ_HEIGHT, 0, /* so it will not be stretched vertically */
		     EZ_BORDER_TYPE, EZ_BORDER_UP,
		     EZ_BORDER_WIDTH, 2, 
		     EZ_STACKING, EZ_HORIZONTAL_LEFT,
		     0);
  tmp = EZ_CreateMenuButton(frame2, "Colors", 0);
  EZ_ConfigureWidget(tmp,  EZ_CALLBACK, mcbk, NULL, 0);
  EZ_SetMenuButtonMenu(tmp, colorM);
  tmp = EZ_CreateMenuButton(frame2, "Border Types", 0);
  EZ_ConfigureWidget(tmp,  EZ_CALLBACK, mcbk, NULL, 0);
  EZ_SetMenuButtonMenu(tmp, borderM);
  tmp = EZ_CreateMenuButton(frame2, "Border Width", 1);
  EZ_ConfigureWidget(tmp,  EZ_CALLBACK, mcbk, NULL, 0);
  EZ_SetMenuButtonMenu(tmp, bwidthM);
  tmp = EZ_CreateMenuButton(frame2, "Fonts", 0);
  EZ_ConfigureWidget(tmp,  EZ_CALLBACK, mcbk, NULL, 0);
  EZ_SetMenuButtonMenu(tmp, fontM);
  tmp = EZ_CreateMenuButton(frame2, "Sub Menus", 0);
  EZ_ConfigureWidget(tmp,  EZ_CALLBACK, mcbk, NULL, 0);
  EZ_SetMenuButtonMenu(tmp, menuM);
  /*
   * finally a label.
   */
  tmp = EZ_CreateFrame(frame1, NULL);
  label = EZ_CreateLabel(tmp, "Use the pulldown menus to modify the\
 appearance of this label.");
  EZ_ConfigureWidget(label, EZ_HEIGHT, 200, EZ_JUSTIFICATION, EZ_CENTER, 0);

  tmp = EZ_CreateFrame(frame1,"Position to post\nthe popup menu");
  tmpa = EZ_CreateRadioButton(tmp, "VLeft", 0, 3, EZ_LEFT);  
  EZ_SetWidgetPtrData(tmpa,menuM);
  EZ_ConfigureWidget(tmpa, EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR, 0);
  EZ_SetWidgetCallBack(tmpa, testPopup, NULL);
  tmpa = EZ_CreateRadioButton(tmp, "URight", 0, 3, EZ_RIGHT);  
  EZ_ConfigureWidget(tmpa, EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR, 0);
  EZ_SetWidgetPtrData(tmpa,menuM);
  EZ_SetWidgetCallBack(tmpa, testPopup, NULL);
  tmpa = EZ_CreateRadioButton(tmp, "QBottom", 0, 3, EZ_BOTTOM);  
  EZ_ConfigureWidget(tmpa, EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR, 0);
  EZ_SetWidgetPtrData(tmpa,menuM);
  EZ_SetWidgetCallBack(tmpa, testPopup, NULL);
  tmpa = EZ_CreateRadioButton(tmp, "PTop", 0, 3, EZ_TOP);  
  EZ_ConfigureWidget(tmpa, EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR, 0);
  EZ_SetWidgetPtrData(tmpa,menuM);
  EZ_SetWidgetCallBack(tmpa, testPopup, NULL);
  tmpa = EZ_CreateRadioButton(tmp, "KTopLeft", 0, 3, EZ_TOP_LEFT);  
  EZ_ConfigureWidget(tmpa, EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR, 0);
  EZ_SetWidgetPtrData(tmpa,menuM);
  EZ_SetWidgetCallBack(tmpa, testPopup, NULL);
  tmpa = EZ_CreateRadioButton(tmp, "JTopRight", 0, 3, EZ_TOP_RIGHT);  
  EZ_ConfigureWidget(tmpa, EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR, 0);
  EZ_SetWidgetPtrData(tmpa,menuM);
  EZ_SetWidgetCallBack(tmpa, testPopup, NULL);
  tmpa = EZ_CreateRadioButton(tmp, "ZBottomLeft",0 , 3, EZ_BOTTOM_LEFT);  
  EZ_ConfigureWidget(tmpa, EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR, 0);
  EZ_SetWidgetPtrData(tmpa,menuM);
  EZ_SetWidgetCallBack(tmpa, testPopup, NULL);
  tmpa = EZ_CreateRadioButton(tmp, "ABottomRight", 0, 3, EZ_BOTTOM_RIGHT);  
  EZ_ConfigureWidget(tmpa, EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR, 0);
  EZ_SetWidgetPtrData(tmpa,menuM);
  EZ_SetWidgetCallBack(tmpa, testPopup, NULL); 

  EZ_SetRadioButtonGroupVariableValue(tmpa, EZ_BOTTOM_RIGHT);
    EZ_DisplayWidget(frame1);
   EZ_DisplayWidget(testM); 
       /*    EZ_DisplayWidget(colorM);*/
  /* EZ_DoPopup(abc, 0);*/
  EZ_EventMainLoop();
}

static void testPopup(widget, dd)
     EZ_Widget *widget; void *dd;
{
  EZ_Widget *menu = (EZ_Widget *)EZ_GetWidgetPtrData(widget);
  int value = EZ_GetRadioButtonGroupVariableValue(widget);
  EZ_TiePopupMenu(menu, Button3, value);  
}
/************************************************************************/
static void testMCallback(widget, dd)
     EZ_Widget *widget; void *dd;
{
  int i = EZ_GetWidgetReturnedData(widget);

  EZ_ConfigureWidget(widget, EZ_MENU_TEAR_OFF, (i < 5), 0);
		     
}

int _test_ = 0; 

