/****************************************************************
 ***                                                          ***
 ***     radiobutton.c                                        ***
 ***          radio buttons                                   ***
 ***                                                          ***
 ***************************************************************/
#include "EZ.h"

/*************************************************************************/
static char *colors[] = {
  "red",
  "green",
  "blue",
  "yellow",
  "cyan",
  "magenta",
  "white",
  "grey62",
  "black",
};
#define REDC     0
#define GREENC   1
#define BLUEC    2
#define YELLOWC  3
#define CYANC    4
#define MAGENTAC 5
#define WHITEC   6
#define GRAYC    7
#define BLACKC   8

static EZ_Widget *label;
void my_exit()
{
  EZ_Shutdown();
  exit(0);
}
/************************************************************************
 *
 *  fslistbox callback
 */
static void rbutton_callback(widget)
     EZ_Widget *widget;
{
  int color;

  color = EZ_GetRadioButtonGroupVariableValue(widget);
  if(color >= REDC && color <= BLACKC)
    EZ_ConfigureWidget(label, EZ_FOREGROUND, colors[color], 0);
}    
/**************************************************************************/

static EZ_Widget *create_radio_button_box(parent, label_string)
     EZ_Widget *parent;
     char      *label_string;
{
  EZ_Widget *frame, *frame1, *tmp;

  frame = EZ_CreateFrame(parent, label_string);
  EZ_ConfigureWidget(frame, 
		     EZ_STACKING, EZ_VERTICAL,
		     0);

  label = EZ_CreateLabel(frame, "A Set of Radio Buttons");
  EZ_ConfigureWidget(label,  EZ_HEIGHT, 0, 
		     EZ_FONT_NAME, "-Adobe-Times-Bold-R-Normal--*-180-*-*-*-*-*-*",  0);

  frame1 = EZ_CreateFrame(frame,NULL);
  EZ_ConfigureWidget(frame1, EZ_FILL_MODE, EZ_FILL_BOTH,
		     EZ_STACKING, EZ_VERTICAL_CENTER, EZ_SIDE, EZ_LEFT, 0);
  tmp = EZ_CreateRadioButton(frame1, "Red",0, 0, REDC);
  EZ_ConfigureWidget(tmp,  EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_CALLBACK, rbutton_callback,NULL,0);
  tmp = EZ_CreateRadioButton(frame1, "Green", -1, 0, GREENC);
  EZ_ConfigureWidget(tmp,  EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_BORDER_TYPE,EZ_BORDER_UP,
		     EZ_BORDER_WIDTH, 3,
		     EZ_BACKGROUND, "bisque2",
		     EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR,
		     EZ_CALLBACK, rbutton_callback,NULL,0);
  EZ_ConfigureWidget(tmp, EZ_SHORTCUT_KEY,"C-G", 0);
  tmp = EZ_CreateRadioButton(frame1, "Blue", -1,0, BLUEC);
  EZ_ConfigureWidget(tmp,  EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_BORDER_TYPE,EZ_BORDER_UP,
		     EZ_BORDER_WIDTH, 3,
		     EZ_BACKGROUND, "bisque2",
		     EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR,
		     EZ_CALLBACK, rbutton_callback,NULL,0);
  tmp = EZ_CreateRadioButton(frame1, "Whatever", 0, 0, MAGENTAC);
  EZ_ConfigureWidget(tmp, EZ_LABEL_POSITION, EZ_LEFT,
		     EZ_INDICATOR_TYPE,EZ_SQUARE_INDICATOR,
		     EZ_CALLBACK, rbutton_callback,NULL,0);
  EZ_ConfigureWidget(tmp,  EZ_CALLBACK, rbutton_callback,NULL,0);
  EZ_ConfigureWidget(tmp, EZ_SHORTCUT_KEY,"C-P", 0);
  tmp = EZ_CreateRadioButton(frame1, "Yellow", 0, 0, YELLOWC);
  EZ_ConfigureWidget(tmp, EZ_CALL_BACK, (EZ_CallBack)my_exit, NULL,
		     EZ_BORDER_TYPE,EZ_BORDER_UP,
		     EZ_BORDER_WIDTH, 3,
		     EZ_BACKGROUND, "bisque2",
		     EZ_INDICATOR_TYPE, EZ_EMPTY_INDICATOR,
/*		     EZ_INDICATOR_TYPE,EZ_CIRCLE_INDICATOR,*/
		     EZ_BITMAP_FILE, "xman.xpm",
		     EZ_BORDER_TYPE, EZ_BORDER_UP, EZ_BORDER_WIDTH, 2, 0);

  return(frame);
}
/************************************************************************/
#ifdef EZ_MAIN
main(ac,av) int ac; char **av;
{
  EZ_Initialize(ac,av,0);
  EZ_DisplayWidget(create_radio_button_box(NULL, NULL));
  EZ_EventMainLoop();
}
#endif

