/************************** Example 3 ***********************/
#include "EZ.h"                     /* the header file      */

extern void showTree(void *);
void shownode(EZ_TreeNode *node)
{
  if(node)
    {
      printf("[%s]\n", EZ_GetDirTreeNodeFullPath(node));
    }
}

void listTreeCallBack(EZ_Widget *widget, void *data) 
{                                  /* callback for listTree */
  EZ_TreeNode  *node = EZ_GetListTreeWidgetSelection(widget);
  EZ_Widget    *textWidget = (EZ_Widget *)data;
  if(node && textWidget)
    {
      EZ_Item *item = EZ_TreeNodeGetItem(node);
      if(item)
	{
	  int w, h;
	  /* EZ_FreezeWidget(tree);*/
	  EZ_ConfigureItem(item, EZ_FONT_NAME,
			   "-Adobe-Helvetica-Medium-R-Normal--*-240-*-*-*-*-*-*",
			   NULL);
	  /*
	  EZ_ComputeSubtreeSize(Root, &w, &h);
	  EZ_UnFreezeWidget(tree);
	  */
	  EZ_TextLoadFile(textWidget, EZ_GetDirTreeNodeFullPath(node));
	}
    }
}

static void rtimer_callback(EZ_Timer *timer, void *pdata)
{
  static int cnt = 0;
  EZ_Widget *ltree = (EZ_Widget *)pdata;
    EZ_UpdateDirTreeWidget(ltree);
}

main(int argc, char **argv)
{
  EZ_Widget *frame, *listTree;
  EZ_Widget *textW, *tmp;
  EZ_TreeNode *root;
  EZ_LabelPixmap *cp, *op;

  EZ_Initialize(argc,argv,0);
  frame = EZ_CreateWidget(EZ_WIDGET_FRAME, NULL,  /* a toplevel frame   */
		     EZ_WIDTH, 600, EZ_HEIGHT, 400,
		     EZ_PADY, 10, EZ_PADX,10, 
		     EZ_BACKGROUND, "bisque2",
		     EZ_FILL_MODE, EZ_FILL_BOTH, 0);

                                         /* a list tree   */
  listTree = EZ_CreateWidget(EZ_WIDGET_TREE, frame,
                             EZ_WIDTH, 200,     /* width  */
                             EZ_OPTIONAL_HSCROLLBAR, False,
                             EZ_OPTIONAL_VSCROLLBAR, True,
                             0);
  EZ_SetVScrollbarDiscreteSpeed(listTree, 10);
  /* add a pane handle so that user can adjust the relative 
   * size of the two sibling widgets */
  tmp = EZ_CreateWidget(EZ_WIDGET_PANE_HANDLE, frame,
                        0);
  textW = EZ_CreateWidget(EZ_WIDGET_TEXT, frame,
                          EZ_OPTIONAL_HSCROLLBAR, True,
                          EZ_OPTIONAL_VSCROLLBAR, True,                 
                          EZ_TEXT_WIDGET_EDITABLE, True,
                          EZ_SELECTION_BACKGROUND, "yellow",

                          0);
  root = EZ_CreateDirTree(NULL, "/d2/tmp/* /d2/.D/*", NULL, 0);  /* open the current dir   */

  EZ_AddWidgetCallBack(listTree, EZ_CALLBACK, 
		       listTreeCallBack, textW, 0);

  EZ_SetListTreeWidgetTree(listTree, /* link root to listTree*/
		       root); 

  (void)EZ_CreateTimer(2, 0, -1, rtimer_callback, listTree, 0);
  EZ_DisplayWidget(frame);
  EZ_EventMainLoop();
}
/************************** Example 3 ***********************/
