/************************** Example Snoop ***********************/
#include "EZ.h"                     /* the header file      */
#include <ctype.h>

static void defaultMessageHandler(void *msgIn, void *client_data)
{
  EZ_Message *msg = (EZ_Message *)msgIn;
  int i, len;
  char *ptr;
  fprintf(stderr, "--- MsgType=[%lx], MsgLen=[%d] MsgId=[%d], ---------\n",
	  msg->messageType, msg->messageLength,msg->replyId);
  ptr = msg->message;
  len = msg->messageLength;
  for(i =0; i < len; i++)
    {
      if(isprint(*ptr)) putc(*ptr, stderr);
      else  putc('.', stderr);
      ptr++;
    }
  putc('\n', stderr);
}

#define LabelStr "This little program prints all messages it received to stderr"

main(int argc, char **argv)
{
  EZ_Widget *label;

  EZ_Initialize(argc,argv,0);
  label = EZ_CreateWidget(EZ_WIDGET_LABEL, NULL,  /* a toplevel frame   */
			  EZ_WIDTH, 400, EZ_HEIGHT, 200,
			  EZ_PADY, 10, EZ_PADX,10, 
			  EZ_BACKGROUND, "bisque2",
			  EZ_FONT_NAME, "-adobe-helvetica-bold-r-normal-*-*-180-*-*-*-*-*-*",
			  EZ_LABEL_STRING, LabelStr,
			  EZ_JUSTIFICATION, EZ_CENTER,
			  0);

  EZ_SetDefaultMessageHandler(defaultMessageHandler, NULL);

  EZ_DisplayWidget(label);
  EZ_EventMainLoop();
}
