/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 *  May 1997. Handling of raw rgb images added by Arno Dabekaussen.
 */
/*****************************************************************
 ***                                                           ***
 ***              Widget Configuration                         ***
 ***                                                           ***
 *****************************************************************/
#define _EZ_WIDGET_CONFIGURE_C_

#include "EZ_Widget.h"
#include "EZ_WidgetConfig.h"
#include  <ctype.h>
/*********************************************************************
 * 
 * global functions
 */
int  EZ_SetWidgetAttributes MY_ANSIARGS((EZ_Widget *widget, int opt, 
					 int i1, int i2, 
					 void *p1, void *p2,
					 unsigned long ul1, unsigned long ul2,
					 float f1, float f2,
					 int i3, int i4));
void  EZ_SetKeyShortcut MY_ANSIARGS((EZ_Widget *widget, char *str));
void  EZ_ConfigureError MY_ANSIARGS((EZ_Widget *widget, int option, char *msg));
int   EZ_SetWidgetPixmap MY_ANSIARGS((EZ_Widget *widget, EZ_Bitmap *bitmap, int option));
/*********************************************************************
 * 
 *  Local functions
 */


static void  EZ_ScanShortcut MY_ANSIARGS((EZ_Widget *widget, char *str, char **list, int *modifier));

/*********************************************************************/
#define EZ_OptionIdNames(_id_, _name_, _c_name_) _c_name_,
char *EZ_ConfigureOptionNames[] = {
  "NULL",  /* options start at 1. */
#include "EZ_WidgetConfig.h"
NULL,
};
#undef EZ_OptionIdNames
/*********************************************************************
 * 
 *  Configure a widget
 */
void  EZ_ConfigureWidget MY_VARARGS(void *,  the_args)
     MY_VARARGS_DECL
{
  EZ_Widget *widget;
  int       size_changed = 0;
  va_list   ap;

  widget = (EZ_Widget *)( MY_VARARGS_START(void *, the_args, ap));

  if(EZ_LookupWidgetFromAllHT(widget) == (EZ_Widget *)NULL)
    {
      (void)fprintf(stderr,"Error: In EZ_ConfigureWidget, widget %lx does not exist.\n",
		    (unsigned long)widget);
      return;
    }
  /* parse the var args */
  {
    int       option, done = 0;
    int       i1,i2,i3,i4;
    void      *p1, *p2;
    float     f1, f2;
    unsigned long ul1, ul2;
#include "EZ_WidgetAttr.h"
  }
  
  /* redisplay if needed */
  if(size_changed >= 0)
    {
      if(size_changed != 0) EZ_ClearWidgetSizeComputedFlag(widget);
      if(EZ_GetWidgetNonActiveFlag(widget) == 0 &&  
	 EZ_GetWidgetFreezedFlag(widget) == 0 && EZ_WidgetMapped(widget))
	EZ_ReDisplayWidget(widget);
    }
  else if( size_changed & (-(1<<30)))
    { EZ_SetWidgetSizeComputedFlag(widget); }
  else {  EZ_ClearWidgetSizeComputedFlag(widget);}
  
  if(EZ_WidgetWindow(widget) != None)
    { 
      if(size_changed & (1 << 20)) EZ_SetWindowShape(widget, 1); /* remove shape */
      if(size_changed & (1 << 21)) EZ_SetWindowShape(widget, 0); /* set shape */
    }
  
  if(EZ_WidgetType(widget) == EZ_WIDGET_LED)
    EZ_LEDStatus(widget) &= ~LED_BLOCKED;
}

int  EZ_SetWidgetAttributes(widget,option, i1,i2,p1,p2,ul1,ul2,f1,f2,i3,i4)
     EZ_Widget *widget;
     int option, i1,i2,i3,i4;
     void *p1, *p2;
     unsigned long ul1, ul2;
     float f1,f2;
{
  int size_changed = 0;
  int shape_changed = 0;

  if(widget)
    {
      int type = EZ_WidgetType(widget);
      int value;

      switch(option)
	{
	case EZ_FORGET_X:
	  if(i1) {EZ_SetWidgetForgetXFlag(widget);}
	  else  {EZ_ClearWidgetForgetXFlag(widget);}
	  break;
	case EZ_FORGET_Y:
	  if(i1) {EZ_SetWidgetForgetYFlag(widget);}
	  else  {EZ_ClearWidgetForgetYFlag(widget);}
	  break;
	case EZ_FORGET_W:
	  if(i1) {EZ_SetWidgetForgetWFlag(widget);}
	  else  {EZ_ClearWidgetForgetWFlag(widget);}
	  break;
	case EZ_FORGET_H:
	  if(i1) {EZ_SetWidgetForgetHFlag(widget);}
	  else  {EZ_ClearWidgetForgetHFlag(widget);}
	  break;
	case EZ_FORGET_POSITION:
	  if(i1) {EZ_SetWidgetForgetXYFlag(widget);}
	  else  {EZ_ClearWidgetForgetXYFlag(widget);}
	  break;
	case EZ_FORGET_SIZE:
	  if(i1) {EZ_SetWidgetForgetWHFlag(widget);}
	  else {EZ_ClearWidgetForgetWHFlag(widget);}
	  break;
	case EZ_FORGET_GEOMETRY:
	  if(i1) {EZ_SetWidgetForgetGFlag(widget);}
	  else {EZ_ClearWidgetForgetGFlag(widget);}
	  break;
	  /* status meter config options. 2/6/98 */
	case EZ_SMETER_STYLE:
	  if(type == EZ_WIDGET_STATUS_BAR)
	    {
	      if(i1 > 0 && i2 > 0 && i1 < 100 && i2 < 100)
		{
		  EZ_SMeterBarWidth(widget) = i1;
		  EZ_SMeterBarSep(widget) = i2;
		  EZ_SMeterStyle(widget) = 1;
		}
	      else EZ_SMeterStyle(widget) = 0;
	    }
	  break;
	case EZ_SMETER_ORIENTATION:
	  if(type == EZ_WIDGET_STATUS_BAR)
	    if(EZ_SMeterOrientation(widget) != i1)
	      {
		EZ_SMeterOrientation(widget) = (char )i1;
		size_changed = 1;
	      }
	  break;
	case EZ_SMETER_FOREGROUND_N:
	    if(type == EZ_WIDGET_STATUS_BAR)
	      {
		if(i1 >= 0 && i1 < 5)
		  {
		    char *color = (char *)p1;
		    unsigned long  pixel_value = EZ_AllocateColorFromName(color);
		    EZ_SMeterFColor(widget)[i1] = pixel_value;
		  }
	      }
	    break;
	case EZ_SMETER_RANGE_N:
	  if(type == EZ_WIDGET_STATUS_BAR)
	    {
	      if(i1 >= 0 && i1 < 5)
		{
		  float *ff = EZ_SMeterValues(widget);
		  ff[ 3*i1] = f1; ff[ 3*i1 +1] = f2;
		  if(EZ_SMeterNControls(widget) <= i1)
		    EZ_SMeterNControls(widget) = i1+1;
		}
	    }
	  break;
	case EZ_SMETER_VALUE_N:
	  if(type == EZ_WIDGET_STATUS_BAR)
	    {
	      if(i1 >= 0 && i1 < 5)
		{
		  float *ff = EZ_SMeterValues(widget);
		  ff[ 3*i1 + 2] = f1;
		  if(EZ_SMeterNControls(widget) <= i1)
		    EZ_SMeterNControls(widget) = i1+1;
		}
	    }
	  break;
	case EZ_SMETER_SHOW_VALUE:
	  if(type == EZ_WIDGET_STATUS_BAR)
	    EZ_SMeterShowValue(widget) = (i1 != 0);
	  break;
	case EZ_SMETER_VALUE:
	  if(type == EZ_WIDGET_STATUS_BAR)
	    {
	      float *ff = EZ_SMeterValues(widget);
	      ff[2] = f1;
	    }
	  break;
	case EZ_SMETER_STOPED:
	  if(type == EZ_WIDGET_STATUS_BAR)
	    EZ_SMeterStoped(widget) = (i1 != 0);
	  break;
	case EZ_SMETER_RANGE:
	  if(type == EZ_WIDGET_STATUS_BAR)
	    {
	      float *ff = EZ_SMeterRange(widget);
	      ff[0] = f1; ff[1] = f2;
	    }
	  break;	  
	case EZ_SMETER_BACKGROUND:
	  if(type == EZ_WIDGET_STATUS_BAR)
	    {
	      char *color = (char *)p1;
	      unsigned long  pixel_value = EZ_AllocateColorFromName(color);
	      EZ_SMeterBColor(widget) = pixel_value;
	    }
	  break;
	case EZ_SMETER_FOREGROUND:
	  if(type == EZ_WIDGET_STATUS_BAR)
	    {
	      char *color = (char *)p1;
	      unsigned long  pixel_value = EZ_AllocateColorFromName(color);
	      EZ_SMeterFColor(widget)[0] = pixel_value;
	    }
	  break;
	  /* end of status meter config options. 2/6/98 */
	  
	case EZ_HSCROLL_INCREMENT:
	  if(i1 > 0) (void) EZ_SetHScrollbarDiscreteSpeed(widget, i1);
	  break;
	case EZ_VSCROLL_INCREMENT:
	  if(i1 > 0) (void) EZ_SetVScrollbarDiscreteSpeed(widget, i1);
	  break;
	case EZ_GEOMETRY_MANAGER:
	  {
	    if(EZ_WidgetGManager(widget) == (EZ_GManager *)NULL)
	      EZ_WidgetGManager(widget) = EZ_AllocateGManager(i1);
	    switch(type)
	      {
	      case EZ_WIDGET_TREE:
	      case EZ_WIDGET_LIST_BOX:
	      case EZ_WIDGET_TEXT:
	      case EZ_WIDGET_WORK_AREA:
	      case EZ_WIDGET_FANCY_LISTBOX:
		EZ_ConfigureError(widget,option, "option not available");
		break;
	      default:
		{
		  EZ_GManager *ptr = EZ_WidgetGManager(widget);
		  EZ_GMType(ptr) = i1;
		}
		break;
	      }
	  }
	break;
	case EZ_LED_COLOR_FUNCTION :
	  if(type == EZ_WIDGET_LED)
	    {
	      EZ_LEDStatus(widget) |= LED_BLOCKED;
	      EZ_LEDColorF(widget) = (EZ_LedPixelColorF)p1;
	    }
	  break;
	case EZ_LED_BACKGROUND:
	  if(type == EZ_WIDGET_LED)
	    {
	      char *color;
	      unsigned long  pixel_value;
	      color     =  (char *)p1;
	      pixel_value = EZ_AllocateColorFromName(color);
	      if(EZ_LEDBG(widget) != pixel_value)
		{
		  EZ_LEDStatus(widget) |= LED_BLOCKED;
		  EZ_LEDBG(widget) = pixel_value;
		  EZ_LEDDirty(widget) |= (LED_PIXMAP_DIRTY | LED_PIXMAPC_DIRTY);
		}
	    }
	  break;
	case EZ_LED_PIXEL_COLOR:
	  if(type == EZ_WIDGET_LED)
	    {
	      char *color;
	      unsigned long  pixel_value;
	      color     =  (char *)p1;
	      pixel_value = EZ_AllocateColorFromName(color);
	      if(EZ_LEDBGL(widget) != pixel_value)
		{
		  EZ_LEDStatus(widget) |= LED_BLOCKED;
		  EZ_LEDBGL(widget) = pixel_value;
		  EZ_LEDDirty(widget) |= (LED_PIXMAP_DIRTY | LED_PIXMAPC_DIRTY);
		}
	    }
	  break;
	case EZ_LED_WIDTH:
	  if(type == EZ_WIDGET_LED)
	    {
	      if(i1 > 0 && i1 != EZ_LEDSCols(widget))
		{
		  EZ_LEDStatus(widget) |= LED_BLOCKED;
		  EZ_LEDSCols(widget) = i1;
		  size_changed = 1;	      
		}
	    }
	  break;
	case EZ_LED_HEIGHT:
	  if(type == EZ_WIDGET_LED)
	    {
	      if(i1 > 0 && i1 != EZ_LEDSRows(widget))
		{
		  EZ_LEDStatus(widget) |= LED_BLOCKED;
		  EZ_LEDSRows(widget) = i1;
		  size_changed = 1;	      
		}
	    }
	  break;
	case EZ_LED_PIXEL_SIZE:
	  if(type == EZ_WIDGET_LED)
	    {
	      if(i1 < 0) i1 = 1; else if(i1 > 4) i1 = 4; i1++;
	      if(EZ_LEDSize(widget) != i1) EZ_LEDSize(widget) = i1;
	      EZ_LEDStatus(widget) |= LED_BLOCKED;
	    }
	  break;
	case EZ_LCD_BACKGROUND:
	  if(type == EZ_WIDGET_LCD)
	    {
	      char *color;
	      unsigned long  pixel_value;
	      color     =  (char *)p1;
	      pixel_value = EZ_AllocateColorFromName(color);
	      if(EZ_LCDBG(widget) != pixel_value)
		EZ_LCDBG(widget) = pixel_value;
	    }
	  break;
	case EZ_LCD_FOREGROUND:
	  if(type == EZ_WIDGET_LCD)
	    {
	      char *color;
	      unsigned long  pixel_value;
	      color     =  (char *)p1;
	      pixel_value = EZ_AllocateNewBackground(color);
	      if(pixel_value != 0) 
		{
		  if(EZ_LCDFG(widget) != pixel_value)
		    {
		      EZ_LCDFG(widget) = pixel_value;
		      EZ_LCDFGBright(widget) = EZ_GetBrightColor(pixel_value);
		      EZ_LCDFGDark(widget) = EZ_GetDarkColor(pixel_value);
		    }
		}
	      else
		{
		  pixel_value = EZ_AllocateColorFromName(color);
		  EZ_LCDFGBright(widget) = ~0;
		  EZ_LCDFGDark(widget) = ~0;
		  EZ_LCDFG(widget) = pixel_value; 
		}
	    }
	  break;	  
	case EZ_LCD_NDIGITS:
	  if(type == EZ_WIDGET_LCD)
	    {
	      if(i1 > 0 && i1 != EZ_LCDNDigits(widget))
		{
		  EZ_LCDNDigits(widget) = i1;
		  size_changed = 1;
		}
	    }
	  break;
	case EZ_LCD_FONT_SIZE:
	  if(type == EZ_WIDGET_LCD)
	    {
	      if(i1 > 0 && i1 != EZ_LCDSize(widget))
		{
		  EZ_LCDSize(widget) = i1;
		  size_changed = 1;
		}
	    }
	  break;
	case EZ_PADB:
	  if(i1 >= 0)
	    {
	      if( type != EZ_WIDGET_3D_CANVAS && i1 != EZ_WidgetPadB(widget))
		{
		  EZ_WidgetPadB(widget) = i1;
		  size_changed = 1;
		}
	    }
	  else EZ_ConfigureError(widget,option, "Value out of range"); 
	  break;
	case EZ_GRID_CELL_GEOMETRY:
	  {
	    int err = 0;
	    EZ_Widget *parent = EZ_WidgetParent(widget);
	    if(parent && EZ_WidgetGManager(parent) == (EZ_GManager *)NULL)
	      EZ_WidgetGManager(parent) = EZ_AllocateGManager(EZ_GB_GEOM_MANAGER);
	    if(i1 < 0) {err++; i1 = 0;}
	    if(i2 < 0) {err++; i2 = 0;}
	    if(i3 <=0) {err++; i3 = 1;}
	    if(i4 <=0) {err++; i4 = 1;}
	    EZ_WidgetGBX(widget) = i1;
	    EZ_WidgetGBY(widget) = i2;
	    EZ_WidgetGBW(widget) = i3;
	    EZ_WidgetGBH(widget) = i4;
	    size_changed = (err != 4);
	    if(err) EZ_ConfigureError(widget,option, "Value out of range"); 
	  }
	break;
	case EZ_GRID_CELL_PLACEMENT:
	  {
	    int err = 0;
	    EZ_Widget *parent = EZ_WidgetParent(widget);
	    if(parent && EZ_WidgetGManager(parent) == (EZ_GManager *)NULL)
	      EZ_WidgetGManager(parent) = EZ_AllocateGManager(EZ_GB_GEOM_MANAGER);

	    if(i1 >= EZ_WIDGET_FILL_BEGIN && i1 <= EZ_WIDGET_FILL_END)
	      EZ_WidgetGBFill(widget) = i1;
	    else err++;
	    if(i2 >= EZ_WIDGET_LABEL_POSITION_BEGIN &&
	       i2 <= EZ_WIDGET_LABEL_POSITION_END -1)
	      EZ_WidgetGBAnchor(widget) = i2;	  
	    else err++;
	    size_changed = (err != 2);
	    if(err)  EZ_ConfigureError(widget,option, "Value out of range"); 
	  }
	break;
	case EZ_GRID_CONSTRAINS:
	  size_changed = EZ_SetRowColConstrains(widget,(int)ul1, i1,i2,i3,i4);
	  break;
	case EZ_GRID_ROW_CONSTRAINS:
	  size_changed = EZ_SetRowColConstrains(widget,EZ_ROW, i1,i2,i3,i4);
	  break;
	case EZ_GRID_COLUMN_CONSTRAINS:
	  size_changed = EZ_SetRowColConstrains(widget,EZ_COLUMN, i1,i2,i3,i4);
	  break;
	case EZ_MENU_TEAR_OFF:
	  if(type == EZ_WIDGET_POPUP_MENU)
	    size_changed = EZ_ConfigureTearOffMenu(widget, i1);
	  break;
	case EZ_UNDERLINE:
	  value = i1;
	  switch(type)
	    {
	    case EZ_WIDGET_NW_LABEL:
	      {
		char *label = EZ_LabelString(widget);
		if(label && value >= 0 && value < EZ_LabelLineLength(widget) && isprint(label[value]))
		  {
		    EZ_LabelUnderline(widget) = value;
		    EZ_LabelModifiers(widget) = Mod1Mask;
		    EZ_LabelShortcut(widget)  = (EZ_LabelString(widget) + value);
		    EZ_InsertGlobalKeyPressEvent(widget, Mod1Mask, (label+ value));
		  }
		else
		  {
		    EZ_LabelUnderline(widget) = -1;
		    EZ_LabelModifiers(widget) = 0;
		    EZ_LabelShortcut(widget)  = (char *)NULL;
		  }
	      }
	    break;
	    case EZ_WIDGET_NORMAL_BUTTON:
	    case EZ_WIDGET_MENU_NORMAL_BUTTON:
	      {
		char *label = EZ_ButtonLabel(widget);
		if(label && value >= 0 && value < EZ_ButtonLabelLength(widget) && isprint(label[value]))
		  {
		    EZ_ButtonUnderLine(widget) = value;
		    EZ_ButtonModifiers(widget) = Mod1Mask;
		    EZ_ButtonShortcut(widget)  = (EZ_ButtonLabel(widget) + value);
		    EZ_InsertGlobalKeyPressEvent(widget, Mod1Mask, (label+ value));
		  }
		else
		  {
		    EZ_ButtonUnderLine(widget) = -1;
		    EZ_ButtonModifiers(widget) = 0;
		    EZ_ButtonShortcut(widget)  = (char *)NULL;
		  }
	      }
	    break;
	    case EZ_WIDGET_CHECK_BUTTON:
	    case EZ_WIDGET_MENU_CHECK_BUTTON:
	      {
		char *label = EZ_CButtonLabel(widget);
		if(label && value >= 0 && value < EZ_CButtonLabelLength(widget) && isprint(label[value]))
		  {
		    EZ_CButtonUnderLine(widget) = value;
		    EZ_CButtonModifiers(widget) = Mod1Mask;
		    EZ_CButtonShortcut(widget)  = (EZ_CButtonLabel(widget) + value);
		    EZ_InsertGlobalKeyPressEvent(widget, Mod1Mask, (label+ value));
		  }
		else
		  {
		    EZ_CButtonUnderLine(widget) = -1;
		    EZ_CButtonModifiers(widget) = 0;
		    EZ_CButtonShortcut(widget)  = (char *)NULL;
		  }
	      }
	    break;
	    case EZ_WIDGET_RADIO_BUTTON:
	    case EZ_WIDGET_MENU_RADIO_BUTTON:
	      {
		char *label = EZ_RButtonLabel(widget);
		if(label && value >= 0 && value < EZ_RButtonLabelLength(widget) && isprint(label[value]))
		  {
		    EZ_RButtonUnderLine(widget) = value;
		    EZ_RButtonModifiers(widget) = Mod1Mask;
		    EZ_RButtonShortcut(widget)  = (EZ_RButtonLabel(widget) + value);
		    EZ_InsertGlobalKeyPressEvent(widget, Mod1Mask, (label+ value));
		  }
		else
		  {
		    EZ_RButtonUnderLine(widget) = -1;
		    EZ_RButtonModifiers(widget) = 0;
		    EZ_RButtonShortcut(widget)  = (char *)NULL;
		  }
	      }
	    break;
	    case EZ_WIDGET_MENU_BUTTON:
	      {
		char *label = EZ_MButtonLabel(widget);
		if(label && value >= 0 && value < EZ_MButtonLabelLength(widget) && isprint(label[value]))
		  {
		    EZ_MButtonUnderLine(widget) = value;
		    EZ_MButtonModifiers(widget) = Mod1Mask;
		    EZ_MButtonShortcut(widget)  = (EZ_MButtonLabel(widget) + value);
		    EZ_InsertGlobalKeyPressEvent(widget, Mod1Mask, (label+ value));
		  }
		else
		  {
		    EZ_MButtonUnderLine(widget) = -1;
		    EZ_MButtonModifiers(widget) = 0;
		    EZ_MButtonShortcut(widget)  = (char *)NULL;
		  }
	      }
	    break;
	    case EZ_WIDGET_MENU_SUBMENU:
	      {
		char *label = EZ_SubMenuLabel(widget);
		if(label && value >= 0 && value < EZ_SubMenuLabelLength(widget) && isprint(label[value]))
		  {
		    EZ_SubMenuUnderLine(widget) = value;
		    EZ_SubMenuModifiers(widget) = Mod1Mask;
		    EZ_SubMenuShortcut(widget)  = (EZ_SubMenuLabel(widget) + value);
		    EZ_InsertGlobalKeyPressEvent(widget, Mod1Mask, (label+value));
		  }
		else
		  {
		    EZ_SubMenuUnderLine(widget) = -1;
		    EZ_SubMenuModifiers(widget) = 0;
		    EZ_SubMenuShortcut(widget)  = (char *)NULL;
		  }
	      }
	    break;
	    case EZ_WIDGET_NB_PAGE:
	      {
		EZ_Widget *btn = EZ_NBPageCompanion(widget);
		if(btn)
		  {
		    char *label = EZ_ButtonLabel(btn);
		    if(label && value >= 0 && value < EZ_ButtonLabelLength(btn) && isprint(label[value]))
		      {
			EZ_ButtonUnderLine(btn) = value;
			EZ_ButtonModifiers(btn) = Mod1Mask;
			EZ_ButtonShortcut(btn)  = (EZ_ButtonLabel(btn) + value);
			EZ_InsertGlobalKeyPressEvent(btn, Mod1Mask, (label+ value));
		      }
		    else
		      {
			EZ_ButtonUnderLine(btn) = -1;
			EZ_ButtonModifiers(btn) = 0;
			EZ_ButtonShortcut(btn)  = (char *)NULL;
		      }
		  }
	      }
	      break;
	    default:
	      break;
	    }
	  break;
	case EZ_FANCY_LIST_BOX_COLUMNS:
	  {
	    EZ_Widget *iflbox = NULL;
	    if(type == EZ_WIDGET_FANCY_LIST_BOX)
	      iflbox = EZ_FListBoxIFListBox(widget);
	    else if(type == EZ_WIDGET_IFANCY_LIST_BOX)
	      iflbox = widget;
	    if(iflbox)
	      {
		EZ_IFListBoxAllocNewStorage(iflbox, 64, i1);  
	      }
	  }
	  break;
	case EZ_RETURN_VALUE:
	  EZ_WidgetRetData(widget) = i1;
	  break;
	case EZ_FANCY_LIST_BOX_TYPE:
	  {
	    EZ_Widget *iflbox = NULL;
	    if(type == EZ_WIDGET_FANCY_LIST_BOX)
	      iflbox = EZ_FListBoxIFListBox(widget);
	    else if(type == EZ_WIDGET_IFANCY_LIST_BOX)
	      iflbox = widget;
	    if(iflbox)  EZ_IFListBoxSelectionType(iflbox) = (i1 != 0);
	  }
	  break;

	case EZ_TEXT_WIDGET_EDITABLE:
	  {
	    EZ_Widget *iText = NULL;
	    if(type == EZ_WIDGET_TEXT)
	      iText = EZ_TextIText(widget);
	    else if(type == EZ_WIDGET_ITEXT)
	      iText = widget;
	    if(iText)
	      {
		if(i1) { EZ_ITextEditable(iText) = 1; EZ_SetWidgetFocusableFlag(iText);}
		else { EZ_ITextEditable(iText) = 0; EZ_ClearWidgetFocusableFlag(iText);}
	      }
	  }
	break;
	case EZ_OPTIONAL_ENTRY_EDITABLE:
	  {
	    EZ_Widget *entry = NULL;
	    if(type == EZ_WIDGET_OPTIONAL_ENTRY)
	      {	entry = EZ_OptEntryEntry(widget);}
	    else if(type == EZ_WIDGET_ENTRY)
	      entry = widget;
	    if(entry)
	      {
		if(i1) { EZ_EntryEditable(entry) = 1; EZ_SetWidgetFocusableFlag(entry);}
		else   { EZ_EntryEditable(entry) = 0; EZ_ClearWidgetFocusableFlag(entry);}
	      }
	  }
	break;
	case EZ_OPTIONAL_ENTRY_REMEMBER_HISTORY:
	  if(type == EZ_WIDGET_OPTIONAL_ENTRY)
	    {
	      EZ_Widget *entry =  EZ_OptEntryEntry(widget);
	      if(entry)EZ_EntryRemberHistory(entry) = (i1 != 0);
	    }
	  break;
	case EZ_SLIDER_INIT_VALUE:
	  if(type == EZ_WIDGET_HORIZONTAL_SLIDER ||
	     type == EZ_WIDGET_VERTICAL_SLIDER)
	    { EZ_SliderValue(widget) = f1; size_changed = 1;}
	  else EZ_ConfigureError(widget,option, "option not applicable"); 
	  break;
	case EZ_ENTRY_STRING:
	  {
	    if(type == EZ_WIDGET_ENTRY)
	      EZ_SetEntryString(widget, (char *)p1);
	    else if(type == EZ_WIDGET_OPTIONAL_ENTRY)
	      EZ_SetOptionalEntryString(widget, (char *)p1);
	  }
	break;
        case EZ_GLOB_PATTERN:
	  switch(type)
	    {
	    case EZ_WIDGET_OPTIONAL_ENTRY:
	      {
		EZ_Widget *twidget =  EZ_OptEntryEntry(widget);
		if(twidget)
		  {
		    EZ_SetEntryString(twidget, (char *)p1);
		    size_changed = 1;
		  }
	      }
	      break;
	    case EZ_WIDGET_FILE_SELECTOR:
	      {
		EZ_SetFileSelectorInitialPattern(widget, (char *)p1);
		size_changed = 1;
	      }
	    break;
	    default:
	      break;
	    }
	  break;
	case EZ_CHECK_BUTTON_ON_VALUE:
	  if(type == EZ_WIDGET_CHECK_BUTTON ||
	     type ==  EZ_WIDGET_MENU_CHECK_BUTTON)
	    {
	      if(EZ_CButtonVarValue(widget) == EZ_CButtonVarOnValue(widget))
		EZ_CButtonVarValue(widget) = i1;
	      EZ_CButtonVarOnValue(widget) = i1;
	      size_changed = 1;
	    }
	  break;

	case EZ_CHECK_BUTTON_OFF_VALUE:
	  if(type == EZ_WIDGET_CHECK_BUTTON ||
	     type ==  EZ_WIDGET_MENU_CHECK_BUTTON)
	    {
	      if(EZ_CButtonVarValue(widget) == EZ_CButtonVarOffValue(widget))
		EZ_CButtonVarValue(widget) = i1;
	      EZ_CButtonVarOffValue(widget) = i1;
	      size_changed = 1;
	    }
	  break;
	case EZ_CHECK_BUTTON_ON_OFF:
	  if(type == EZ_WIDGET_CHECK_BUTTON ||
	     type ==  EZ_WIDGET_MENU_CHECK_BUTTON)
	    {
	      if(i1) EZ_CButtonVarValue(widget) = EZ_CButtonVarOnValue(widget);
	      else EZ_CButtonVarValue(widget) = EZ_CButtonVarOffValue(widget);
	      size_changed = 1;
	    }
	  break;
	case EZ_RADIO_BUTTON_GROUP:
	  if(type == EZ_WIDGET_RADIO_BUTTON ||
	     type == EZ_WIDGET_MENU_RADIO_BUTTON)
	    {
	      EZ_FixRadioButtonList(widget,i1);
	    }
	  break;
	case EZ_RADIO_BUTTON_VALUE:
	  if(type == EZ_WIDGET_RADIO_BUTTON ||
	     type == EZ_WIDGET_MENU_RADIO_BUTTON)
	    {
	      int gid;
	      if(EZ_RButtonGroup(widget) == NULL) gid = 0;
	      else gid = (EZ_RButtonGroup(widget))->id;
	      EZ_RButtonVarValue(widget) = i1;
	      EZ_FixRadioButtonList(widget,gid);
	    }
	  break;
	case EZ_OPTIONAL_HSCROLLBAR:
	  if(i1) 
	    {
	      switch(type)
		{
		case EZ_WIDGET_TEXT:
		  {
		    EZ_Widget *hscroll = EZ_TextHScroll(widget);
		    if(hscroll == NULL)
		      {
			EZ_Widget *itext =  EZ_TextIText(widget);
			hscroll = EZ_TextHScroll(widget) = 
			  EZ_CreateScrollbar(widget,EZ_WIDGET_HORIZONTAL_SCROLLBAR);
			EZ_SetWidgetExpandFlag(hscroll);
			EZ_ScrollObject(hscroll) = itext;
			EZ_ITextHScroll(itext) = hscroll;
			EZ_GetAndUseWidgetResources(hscroll);
		      }
		    else EZ_ActivateWidget(hscroll);
		  }
		break;
		case EZ_WIDGET_LIST_BOX:
		  {
		    EZ_Widget *hscroll = EZ_ListBoxHScroll(widget);
		    if(hscroll == NULL)
		      {
			EZ_Widget *ilistbox = EZ_ListBoxIListBox(widget);
			hscroll = EZ_ListBoxHScroll(widget) = 
			  EZ_CreateScrollbar(widget,EZ_WIDGET_HORIZONTAL_SCROLLBAR);
			EZ_SetWidgetExpandFlag(hscroll);
			EZ_ScrollObject(hscroll) = ilistbox;
			EZ_IListBoxHScroll(ilistbox) = hscroll;
			EZ_GetAndUseWidgetResources(hscroll);
		      }
		    else EZ_ActivateWidget(hscroll);
		  }
		break;
		case EZ_WIDGET_FANCY_LIST_BOX:
		  {
		    EZ_Widget *hscroll = EZ_FListBoxHScroll(widget);
		    if(hscroll == NULL)
		      {
			EZ_Widget *iflistbox = EZ_FListBoxIFListBox(widget);
			hscroll = EZ_FListBoxHScroll(widget) = 
			  EZ_CreateScrollbar(widget,EZ_WIDGET_HORIZONTAL_SCROLLBAR);
			EZ_SetWidgetExpandFlag(hscroll);
			EZ_ScrollObject(hscroll) = iflistbox;
			EZ_IFListBoxHScroll(iflistbox) = hscroll; 
			EZ_GetAndUseWidgetResources(hscroll);
		      }
		    else EZ_ActivateWidget(hscroll);
		  }
		break;
		case EZ_WIDGET_TREE:
		  {
		    EZ_Widget *hscroll = EZ_TreeWHScroll(widget);
		    if(hscroll == NULL)
		      {
			EZ_Widget *itree = EZ_TreeWITree(widget);
			hscroll = EZ_TreeWHScroll(widget) =
			  EZ_CreateScrollbar(widget,EZ_WIDGET_HORIZONTAL_SCROLLBAR);
			EZ_SetWidgetExpandFlag(hscroll);
			EZ_ScrollObject(hscroll) = itree;
			EZ_ITreeWVScroll(itree) = hscroll;  
			EZ_GetAndUseWidgetResources(hscroll);
		      }
		    else EZ_ActivateWidget(hscroll);
		  }
		break;
		case EZ_WIDGET_WORK_AREA:
		  {
		    EZ_Widget *hscroll = EZ_WorkAreaHScroll(widget);
		    if(hscroll == NULL)
		      {
			EZ_Widget *iwa = EZ_WorkAreaIWorkArea(widget);
			hscroll = EZ_WorkAreaHScroll(widget) =
			  EZ_CreateScrollbar(widget,EZ_WIDGET_HORIZONTAL_SCROLLBAR);
			EZ_SetWidgetExpandFlag(hscroll);
			EZ_ScrollObject(hscroll) = iwa;
			EZ_IWorkAreaHScroll(iwa) = hscroll;
			EZ_GetAndUseWidgetResources(hscroll);
		      }
		    else EZ_ActivateWidget(hscroll);
		  }
		break;
		default:
		  break;
		}
	    }
	  else
	    {
	      switch(type)
		{
		case EZ_WIDGET_TEXT:
		  {
		    EZ_Widget *hscroll = EZ_TextHScroll(widget);
		    if(hscroll != NULL) EZ_DeActivateWidget(hscroll);
		  }
		break;
		case EZ_WIDGET_LIST_BOX:
		  {
		    EZ_Widget *hscroll = EZ_ListBoxHScroll(widget);
		    if(hscroll != NULL) EZ_DeActivateWidget(hscroll);
		  }
		break;
		case EZ_WIDGET_FANCY_LIST_BOX:
		  {
		    EZ_Widget *hscroll = EZ_FListBoxHScroll(widget);
		    if(hscroll != NULL) EZ_DeActivateWidget(hscroll);
		  }
		break;
		case EZ_WIDGET_TREE:
		  {
		    EZ_Widget *hscroll = EZ_TreeWHScroll(widget);
		    if(hscroll != NULL) EZ_DeActivateWidget(hscroll);
		  }
		break;
		case EZ_WIDGET_WORK_AREA:
		  {
		    EZ_Widget *hscroll = EZ_WorkAreaHScroll(widget);
		    if(hscroll != NULL) EZ_DeActivateWidget(hscroll);
		  }
		break;
		default:
		  break;
		}
	    }
	  break;
	case EZ_OPTIONAL_VSCROLLBAR:
	  if(i1)
	    {
	      switch(type)
		{
		case EZ_WIDGET_TEXT:
		  {
		    EZ_Widget *vscroll = EZ_TextVScroll(widget);
		    if(vscroll == NULL)
		      {
			EZ_Widget *itext =  EZ_TextIText(widget);
			vscroll = EZ_TextVScroll(widget) = 
			  EZ_CreateScrollbar(widget,EZ_WIDGET_VERTICAL_SCROLLBAR);
			EZ_SetWidgetExpandFlag(vscroll);
			EZ_ScrollObject(vscroll) = itext;
			EZ_ITextVScroll(itext) = vscroll;
			EZ_GetAndUseWidgetResources(vscroll);
		      }
		    else EZ_ActivateWidget(vscroll);
		  }
		case EZ_WIDGET_LIST_BOX:
		  {
		    EZ_Widget *vscroll = EZ_ListBoxVScroll(widget);
		    if(vscroll == NULL)
		      {
			EZ_Widget *ilistbox = EZ_ListBoxIListBox(widget);
			vscroll = EZ_ListBoxVScroll(widget) = 
			  EZ_CreateScrollbar(widget,EZ_WIDGET_VERTICAL_SCROLLBAR);
			EZ_SetWidgetExpandFlag(vscroll);
			EZ_ScrollObject(vscroll) = ilistbox;
			EZ_IListBoxVScroll(ilistbox) = vscroll;
			EZ_GetAndUseWidgetResources(vscroll);
		      }
		    else EZ_ActivateWidget(vscroll);
		  }
		break;
		case EZ_WIDGET_FANCY_LIST_BOX:
		  {
		    EZ_Widget *vscroll = EZ_FListBoxVScroll(widget);
		    if(vscroll == NULL)
		      {
			EZ_Widget *iflistbox = EZ_FListBoxIFListBox(widget);
			vscroll = EZ_FListBoxVScroll(widget) = 
			  EZ_CreateScrollbar(widget,EZ_WIDGET_VERTICAL_SCROLLBAR);
			EZ_SetWidgetExpandFlag(vscroll);
			EZ_ScrollObject(vscroll) = iflistbox;
			EZ_IFListBoxVScroll(iflistbox) = vscroll; 
			EZ_GetAndUseWidgetResources(vscroll);
		      }
		    else EZ_ActivateWidget(vscroll);
		  }
		break;
		case EZ_WIDGET_TREE:
		  {
		    EZ_Widget *vscroll = EZ_TreeWVScroll(widget);
		    if(vscroll == NULL)
		      {
			EZ_Widget *itree = EZ_TreeWITree(widget);
			vscroll = EZ_TreeWVScroll(widget) =
			  EZ_CreateScrollbar(widget,EZ_WIDGET_VERTICAL_SCROLLBAR);
			EZ_SetWidgetExpandFlag(vscroll);
			EZ_ScrollObject(vscroll) = itree;
			EZ_ITreeWVScroll(itree) = vscroll;  
			EZ_GetAndUseWidgetResources(vscroll);
		      }
		    else EZ_ActivateWidget(vscroll);
		  }
		break;
		case EZ_WIDGET_WORK_AREA:
		  {
		    EZ_Widget *vscroll = EZ_WorkAreaVScroll(widget);
		    if(vscroll == NULL)
		      {
			EZ_Widget *iwa = EZ_WorkAreaIWorkArea(widget);
			vscroll = EZ_WorkAreaVScroll(widget) =
			  EZ_CreateScrollbar(widget,EZ_WIDGET_VERTICAL_SCROLLBAR);
			EZ_SetWidgetExpandFlag(vscroll);
			EZ_ScrollObject(vscroll) = iwa;
			EZ_IWorkAreaVScroll(iwa) = vscroll;
			EZ_GetAndUseWidgetResources(vscroll);
		      }
		    else EZ_ActivateWidget(vscroll);
		  }
		break;
		default:
		  break;
		}
	    }
	  else
	    {
	      switch(type)
		{
		case EZ_WIDGET_TEXT:
		  {
		    EZ_Widget *vscroll = EZ_TextVScroll(widget);
		    if(vscroll != NULL) EZ_DeActivateWidget(vscroll);
		  }
		case EZ_WIDGET_LIST_BOX:
		  {
		    EZ_Widget *vscroll = EZ_ListBoxVScroll(widget);
		    if(vscroll != NULL) EZ_DeActivateWidget(vscroll);
		  }
		break;
		case EZ_WIDGET_FANCY_LIST_BOX:
		  {
		    EZ_Widget *vscroll = EZ_FListBoxVScroll(widget);
		    if(vscroll != NULL) EZ_DeActivateWidget(vscroll);
		  }
		break;
		case EZ_WIDGET_TREE:
		  {
		    EZ_Widget *vscroll = EZ_TreeWVScroll(widget);
		    if(vscroll != NULL) EZ_DeActivateWidget(vscroll);
		  }
		break;
		case EZ_WIDGET_WORK_AREA:
		  {
		    EZ_Widget *vscroll = EZ_WorkAreaVScroll(widget);
		    if(vscroll != NULL) EZ_DeActivateWidget(vscroll);
		  }
		break;
		default:
		  break;
		}
	    }
	  break;
	case EZ_SHAPED_WINDOW:
	  {
	    int ii = i1;
	    if(EZ_XServerHasSHAPEExt)
	      {
		if(ii)
		  {
		    EZ_SetWidgetShapedWinFlag(widget);
		    if(ii > 1) EZ_SetWidgetShapeShiftFlag(widget);
		    if(EZ_WidgetWindow(widget) != None) shape_changed = (1<<21);
		  }
		else
		  {
		    EZ_ClearWidgetShapedWinFlag(widget);
		    EZ_ClearWidgetShapeShiftFlag(widget);
		    if(EZ_WidgetWindow(widget) != None) shape_changed = (1<<20);
		  }
		size_changed = 1;
	      }
	  }
	break;
	case EZ_LABELED_ICON:
	  {
	    if(type == EZ_WIDGET_ITOPLEVEL)
	      {
		if(i1)
		  {
		    EZ_WidgetBorderStyle(widget) = EZ_BORDER_UP;
		    EZ_WidgetBorderWidth(widget) = 2;
		    EZ_LabelIsLabeledIcon(widget) = (char)i1;
		    if(EZ_XServerHasSHAPEExt) { EZ_LabelMaskDirty(widget) = 1; }
		  }
		else
		  {
		    EZ_LabelIsLabeledIcon(widget) = 0; 
		    if(EZ_WidgetWindow(widget) != None) shape_changed = (1<<20) | (1<<21);
		  }
		size_changed = 1;
	      }
	  }
	break;
	case  EZ_CURSOR:
	  {
	    Cursor cursor = (Cursor)ul1;
	    if(cursor != None)
	      {
		EZ_Widget *twidget = widget;
		switch(type)
		  {
		  case EZ_WIDGET_TREE:
		    twidget = EZ_TreeWITree(widget);		  
		    break;
		  case EZ_WIDGET_LIST_BOX:
		    twidget = EZ_ListBoxIListBox(widget);
		    break;
		  case EZ_WIDGET_FANCY_LIST_BOX:
		    twidget = EZ_FListBoxIFListBox(widget);
		    break;
		  case EZ_WIDGET_WORK_AREA:
		    twidget = EZ_WorkAreaIWorkArea(widget);
		    break;
		  case EZ_WIDGET_TEXT:
		    twidget = EZ_TextIText(widget);
		    break;
		  default:
		    break;
		  }
		EZ_WidgetCursor(twidget) = cursor;
		if(EZ_WidgetWindow(twidget) != (Cursor)NULL)
		  XDefineCursor(EZ_Display, EZ_WidgetWindow(twidget), cursor);
	      }
	  }
	break;
	case  EZ_DND_DRAG_CURSOR:
	  {
	    Cursor cursor = (Cursor)ul1;
	    EZ_Widget *twidget = widget;
	    switch(type)
	      {
	      case EZ_WIDGET_TREE:
		twidget = EZ_TreeWITree(widget);		  
		break;
	      case EZ_WIDGET_LIST_BOX:
		twidget = EZ_ListBoxIListBox(widget);
		break;
	      case EZ_WIDGET_FANCY_LIST_BOX:
		twidget = EZ_FListBoxIFListBox(widget);
		break;
	      case EZ_WIDGET_WORK_AREA:
		twidget = EZ_WorkAreaIWorkArea(widget);
		break;
	      case EZ_WIDGET_TEXT:
		twidget = EZ_TextIText(widget);
		break;
	      default:
		break;
	      }
	    EZ_WidgetDnDDragCursor(twidget) = cursor;
	  }
	break;
	case  EZ_DND_BUBBLE_HELP:
	  {
	    char *ostr, *str = (char *)p1;
	    int olen, len = str? strlen(str): 0;

	    switch(type)
	      {
	      case EZ_WIDGET_TREE:
		widget = EZ_TreeWITree(widget);		  
		break;
	      case EZ_WIDGET_LIST_BOX:
		widget = EZ_ListBoxIListBox(widget);
		break;
	      case EZ_WIDGET_FANCY_LIST_BOX:
		widget = EZ_FListBoxIFListBox(widget);
		break;
	      case EZ_WIDGET_WORK_AREA:
		widget = EZ_WorkAreaIWorkArea(widget);
		break;
	      case EZ_WIDGET_TEXT:
		widget = EZ_TextIText(widget);
		break;
	      default:
		break;
	      }
	    ostr = EZ_WidgetDnDTargetHelp(widget);
	    if(len == 0) /* disable bubble help */
	      {
		if(ostr) (void)my_free(ostr);
		EZ_WidgetDnDTargetHelp(widget) = (char *)NULL;
	      }
	    else
	      {
		if(ostr)
		  {
		    olen = strlen(ostr);
		    if(olen < len)
		      ostr = EZ_WidgetDnDTargetHelp(widget) = (char *)my_realloc(ostr, len, _BUBBLE_STRING_);
		    if(!ostr) EZ_OutOfMemory("EZ_ConfigureWidget:DnDBubbleString");
		    (void)strcpy(ostr, str);
		  }
		else
		  EZ_WidgetDnDTargetHelp(widget) = EZ_AllocCopyString(str);
	      }
	  }
	  break;
	case EZ_ATTACH_PTR_DATA:
	  {
	    void *ptr =  p1;
	    EZ_Widget *twidget = NULL;
	    switch(type)
	      {
	      case EZ_WIDGET_TREE:
		twidget = EZ_TreeWITree(widget);		  
		break;
	      case EZ_WIDGET_LIST_BOX:
		twidget = EZ_ListBoxIListBox(widget);
		break;
	      case EZ_WIDGET_FANCY_LIST_BOX:
		twidget = EZ_FListBoxIFListBox(widget);
		break;
	      case EZ_WIDGET_WORK_AREA:
		twidget = EZ_WorkAreaIWorkArea(widget);
		break;
	      case EZ_WIDGET_TEXT:
		twidget = EZ_TextIText(widget);
		break;
	      default:
		break;
	      }
	    EZ_WidgetPtrData(widget) = ptr;
	    if(twidget) EZ_WidgetPtrData(twidget) = ptr;
	  }
	  break;
	case EZ_ATTACH_INT_DATA:
	  {
	    int ii =  i1;
	    int type = EZ_WidgetType(widget);
	    EZ_Widget *twidget = NULL;
	    switch(type)
	      {
	      case EZ_WIDGET_TREE:
		twidget = EZ_TreeWITree(widget);		  
		break;
	      case EZ_WIDGET_LIST_BOX:
		twidget = EZ_ListBoxIListBox(widget);
		break;
	      case EZ_WIDGET_FANCY_LIST_BOX:
		twidget = EZ_FListBoxIFListBox(widget);
		break;
	      case EZ_WIDGET_WORK_AREA:
		twidget = EZ_WorkAreaIWorkArea(widget);
		break;
	      case EZ_WIDGET_TEXT:
		twidget = EZ_TextIText(widget);
		break;
	      default:
		break;
	      }
	    EZ_WidgetIntData(widget) = ii;
	    if(twidget) EZ_WidgetIntData(twidget) = ii;
	  }
	  break;
	case EZ_SELECTION_BACKGROUND:
	  {
	    char *color;
	    EZ_Widget *twidget;
	    unsigned long  pixel_value;

	    color     =  (char *)p1;
	    pixel_value = EZ_AllocateColorFromName(color);
	    switch(type)
	      {
	      case EZ_WIDGET_LIST_BOX:
		twidget = EZ_ListBoxIListBox(widget);
		EZ_IListBoxSelectionBG(twidget) = pixel_value;
		break;
	      case EZ_WIDGET_ILIST_BOX:
		EZ_IListBoxSelectionBG(widget) = pixel_value;
		break;
	      case EZ_WIDGET_TEXT:
		twidget = EZ_TextIText(widget); 
		EZ_ITextTextSelectionBG(twidget) = pixel_value;
		break;
	      case EZ_WIDGET_ITEXT:
		EZ_ITextTextSelectionBG(widget) = pixel_value;
		break;
	      case EZ_WIDGET_ENTRY:
		EZ_EntrySelectionBG(widget) = pixel_value;
		break;
	      case EZ_WIDGET_ITREE:
		EZ_ITreeWHighlightBG(widget) = pixel_value;
		break;
	      case EZ_WIDGET_TREE:
		twidget = EZ_TreeWITree(widget);
		EZ_ITreeWHighlightBG(twidget) = pixel_value;
		break;
	      case EZ_WIDGET_IFANCY_LIST_BOX:
		EZ_IFListBoxHighlightBG(widget) = pixel_value;		
		break;
	      case EZ_WIDGET_FANCY_LIST_BOX:
		twidget = EZ_FListBoxIFListBox(widget);
		EZ_IFListBoxHighlightBG(twidget) = pixel_value;		
		break;
	      case EZ_WIDGET_IWORK_AREA:
		EZ_IWorkAreaHighlightBG(widget) = pixel_value;		
		break;
	      case EZ_WIDGET_WORK_AREA:
		twidget = EZ_WorkAreaIWorkArea(widget);
		EZ_IWorkAreaHighlightBG(twidget) = pixel_value;		
		break;
	      case EZ_WIDGET_OPTIONAL_ENTRY:
		{
		  EZ_Widget *listbox = (EZ_Widget *)EZ_OptEntryListbox(widget);
		  twidget = (EZ_Widget *)EZ_OptEntryEntry(widget);
		  EZ_EntrySelectionBG(twidget) = pixel_value;
		  twidget =  EZ_ListBoxIListBox(listbox);
		  EZ_IListBoxSelectionBG(twidget) = pixel_value;
		}
		break;
	      default:
		EZ_ConfigureError(widget,option, "option not applicable"); 
		break;
	      }
	  }
	  break;
	case EZ_SELECTION_FOREGROUND:
	  {
	    char *color;
	    EZ_Widget *twidget;
	    unsigned long  pixel_value;

	    color     = (char *)p1;
	    pixel_value = EZ_AllocateColorFromName(color);
	    switch(type)
	      {
	      case EZ_WIDGET_IWORK_AREA:
		EZ_IWorkAreaHighlightFG(widget) = pixel_value;		
		break;
	      case EZ_WIDGET_WORK_AREA:
		twidget = EZ_WorkAreaIWorkArea(widget);
		EZ_IWorkAreaHighlightFG(twidget) = pixel_value;		
		break;
	      case EZ_WIDGET_IFANCY_LIST_BOX:
		EZ_IFListBoxHighlightFG(widget) = pixel_value;		
		break;
	      case EZ_WIDGET_FANCY_LIST_BOX:
		twidget = EZ_FListBoxIFListBox(widget);
		EZ_IFListBoxHighlightFG(twidget) = pixel_value;		
		break;
	      case EZ_WIDGET_ITREE:
		EZ_ITreeWHighlightFG(widget) = pixel_value;
		break;
	      case EZ_WIDGET_TREE:
		twidget = EZ_TreeWITree(widget);
		EZ_ITreeWHighlightFG(twidget) = pixel_value;
		break;
	      default:
		EZ_ConfigureError(widget,option, "option not applicable"); 
		break;
	      }
	  }
	  break;
	case EZ_X:
	case EZ_Y:
	  value = i1;
	  if(option == EZ_X)
	    {
	      EZ_SetWidgetXSetFlag(widget);
	      EZ_WidgetOriginX(widget) = value;
	    }
	  else
	    {
	      EZ_SetWidgetYSetFlag(widget);
	      EZ_WidgetOriginY(widget) = value;		  
	    }
	  size_changed = 1;
	  break;
	case EZ_LOCATION:
	  {
	    EZ_SetWidgetXYSetFlag(widget);
	    EZ_WidgetOriginX(widget) = i1;
	    EZ_WidgetOriginY(widget) = i2;
	  }
	break;
	case EZ_GEOMETRY:
	  {
	    EZ_SetWidgetXYSetFlag(widget);
	    EZ_SetWidgetSizeSetFlag(widget);
	    EZ_WidgetOriginX(widget) = i1;
	    EZ_WidgetOriginY(widget) = i2;
	    EZ_WidgetWidthHint(widget) = i3;
	    EZ_WidgetHeightHint(widget) = i4;
	    size_changed = 1;
	  }
	break;
	case EZ_SIZE:
	  {
	    EZ_SetWidgetSizeSetFlag(widget);
	    EZ_WidgetWidthHint(widget) = i1;
	    EZ_WidgetHeightHint(widget) = i2;
	    if(EZ_WidgetWidth(widget) != i1 ||
	       EZ_WidgetHeight(widget) != i2)
	      size_changed = 1;
	  }
	break;
	case EZ_SIZE_HINT:
	  {
	    EZ_SetWidgetWidthHintFlag(widget);
	    EZ_SetWidgetHeightHintFlag(widget);
	    EZ_WidgetWidthHint(widget) = i1;
	    EZ_WidgetHeightHint(widget) = i2;
	    if(EZ_WidgetWidth(widget) != i1 ||
	       EZ_WidgetHeight(widget) != i2)
	      size_changed = 1;
	  }
	break;

	case EZ_WIDTH:
	case EZ_WIDTH_HINT:
	  value = i1;
	  if(EZ_WidgetWidthHint(widget) != value)
	    {
	      EZ_WidgetWidthHint(widget) = value;
	      if(EZ_WidgetWidth(widget) != value)  size_changed = 1;
	    }
	  if(option == EZ_WIDTH) { EZ_SetWidgetWidthSetFlag(widget);}
	  else { EZ_SetWidgetWidthHintFlag(widget);}
	  break;

	case EZ_HEIGHT:
	case EZ_HEIGHT_HINT:
	  value = i1;
	  if(EZ_WidgetHeightHint(widget) != value)
	    {
	      EZ_WidgetHeightHint(widget) = value;
	      if(EZ_WidgetHeight(widget) != value)
		size_changed = 1;
	    }
	  if(option == EZ_HEIGHT){ EZ_SetWidgetHeightSetFlag(widget);}
	  else { EZ_SetWidgetHeightHintFlag(widget); }
	  break;
	case EZ_INDICATOR_TYPE:
	  value = i1;
	  if(value >= 0 && value <= EZ_TICK_INDICATOR)
	    {
	      switch(type)
		{
		case EZ_WIDGET_CHECK_BUTTON:
		case EZ_WIDGET_MENU_CHECK_BUTTON:
		  EZ_CButtonCheckType(widget) = value;
		  break;
		case EZ_WIDGET_RADIO_BUTTON:
		case EZ_WIDGET_MENU_RADIO_BUTTON:
		  EZ_RButtonCheckType(widget) = value;
		  break;
		case EZ_WIDGET_MENU_BUTTON:
		  EZ_MButtonCheckType(widget) = value;
		  break;
		default:
		  EZ_ConfigureError(widget,option, "option not applicable"); 
		  break;
		}
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");
	  break;
	case EZ_INDICATOR_COLOR:
	  {
	    char *color;
	    unsigned long  pixel_value;
	    color     = (char *)p1;
	    pixel_value = EZ_AllocateColorFromName(color);
	    switch(type)
	      {
	      case EZ_WIDGET_CHECK_BUTTON:
	      case EZ_WIDGET_MENU_CHECK_BUTTON:
		EZ_CButtonCheckColor(widget) = pixel_value;
		break;
	      case EZ_WIDGET_RADIO_BUTTON:
	      case EZ_WIDGET_MENU_RADIO_BUTTON:
		EZ_RButtonCheckColor(widget) = pixel_value;
		break;
	      case EZ_WIDGET_MENU_BUTTON:
		EZ_MButtonCheckColor(widget) = pixel_value;		
		break;
	      default:
		EZ_ConfigureError(widget,option, "option not applicable"); 
		break;	    
	      }
	  }
	  break;
	case EZ_EMBEDER:
	  value = i1;
	  if(value) { EZ_SetWidgetEmbederFlag(widget);}
	  else { EZ_ClearWidgetEmbederFlag(widget); }
	  break;
	case EZ_BORDER_WIDTH:
	  value = i1;
	  if(value >= 0 && value <= 100 )
	    {
	      EZ_Widget *twidget;
	      switch(type)
		{
		case EZ_WIDGET_WORK_AREA:
		  {
		    twidget = EZ_WorkAreaIWorkArea(widget);
		    if(EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		    twidget = EZ_WorkAreaHScroll(widget);
		    if(twidget && EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ScrollBorderWidth(twidget) = value; /* 6.3.96 */
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		    twidget = EZ_WorkAreaVScroll(widget);
		    if(twidget && EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ScrollBorderWidth(twidget) = value; /* 6.3.96 */
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		  }
		  break;		  
		case EZ_WIDGET_FANCY_LIST_BOX:
		  {
		    twidget = EZ_FListBoxIFListBox(widget);
		    if(EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		    twidget = EZ_FListBoxHScroll(widget);
		    if(twidget && EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ScrollBorderWidth(twidget) = value; /* 6.3.96 */
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		    twidget = EZ_FListBoxVScroll(widget);
		    if(twidget && EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ScrollBorderWidth(twidget) = value; /* 6.3.96 */
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		  }
		  break;
		case EZ_WIDGET_TREE:
		  {
		    twidget = EZ_TreeWITree(widget);
		    if(EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		    twidget = EZ_TreeWHScroll(widget);
		    if(twidget && EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ScrollBorderWidth(twidget) = value; /* 6.3.96 */
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		    twidget = EZ_TreeWVScroll(widget);
		    if(twidget && EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ScrollBorderWidth(twidget) = value; /* 6.3.96 */
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		  }
		  break;
		case EZ_WIDGET_LIST_BOX:
		  {
		    twidget = EZ_ListBoxIListBox(widget);
		    if(EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		    twidget = EZ_ListBoxHScroll(widget);
		    if(twidget && EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ScrollBorderWidth(twidget) = value; /* 6.3.96 */
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		    twidget = EZ_ListBoxVScroll(widget);
		    if(twidget && EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ScrollBorderWidth(twidget) = value; /* 6.3.96 */
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		  }
		  break;
		case EZ_WIDGET_TEXT:
		  {
		    twidget = EZ_TextIText(widget);		
		    if(EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		    twidget = EZ_TextHScroll(widget);	      
		    if(twidget && EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ScrollBorderWidth(twidget) = value;
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		    twidget = EZ_TextVScroll(widget);	      
		    if(twidget && EZ_WidgetBorderWidth(twidget) != value)
		      {
			EZ_WidgetBorderWidth(twidget) = value;
			EZ_ScrollBorderWidth(twidget) = value;
			EZ_ClearWidgetSizeComputedFlag(twidget);  
			size_changed = 1;
		      }
		  }
		  break;
		case EZ_WIDGET_NB_PAGE:
		  {
		    EZ_Widget *twidget = EZ_NBPageCompanion(widget);
		    EZ_WidgetBorderWidth(widget) = value;
		    EZ_WidgetBorderWidth(twidget) = value;
		    EZ_ClearWidgetSizeComputedFlag(twidget);  
		    EZ_ClearWidgetSizeComputedFlag(widget);  
		    size_changed = 1;
		  }
		  break;
		case EZ_WIDGET_HORIZONTAL_SCROLLBAR:
		case EZ_WIDGET_VERTICAL_SCROLLBAR:
		  {
		    if(EZ_WidgetBorderWidth(widget) != value)
		      {
			EZ_WidgetBorderWidth(widget) = value;
			EZ_ScrollBorderWidth(widget) = value; /* 6.3.96 */
			EZ_ClearWidgetSizeComputedFlag(widget);  
			size_changed = 1;
		      }
		  }
		  break;
		case EZ_WIDGET_3D_CANVAS:
		  break;
		default:
		  if(EZ_WidgetBorderWidth(widget) != value)
		    {
		      EZ_WidgetBorderWidth(widget) = value;
		      EZ_ClearWidgetSizeComputedFlag(widget);  
		      size_changed = 1;
		    }
		break;
		}
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");
	  break;

	case EZ_BORDER_TYPE:
	  value = i1;
	  if(value >= EZ_BORDER_STYLE_BEGIN && 
	     value <= EZ_BORDER_STYLE_END &&
	     type != EZ_WIDGET_NB_PAGE)
	    {
	      if(EZ_WidgetBorderStyle(widget) != value)
		{
		  EZ_WidgetBorderStyle(widget) = value;
		  EZ_ClearWidgetSizeComputedFlag(widget);  
		  size_changed = 1;
		}
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");
	  break;
	case EZ_PADX:
	  value = i1;
	  {
	      EZ_Widget *twidget;
	      switch(type)
		{
		case EZ_WIDGET_TREE:
		  twidget = EZ_TreeWITree(widget);		  
		  break;
		case EZ_WIDGET_LIST_BOX:
		  twidget = EZ_ListBoxIListBox(widget);
		  break;
		case EZ_WIDGET_FANCY_LIST_BOX:
		  twidget = EZ_FListBoxIFListBox(widget);
		  break;
		case EZ_WIDGET_WORK_AREA:
		  twidget = EZ_WorkAreaIWorkArea(widget);
		  break;
		default:
		  twidget = widget;
		  break;
		}
	      if(EZ_WidgetPadX(twidget) != value)
		{
		  EZ_WidgetPadX(twidget) = value;
		  EZ_ClearWidgetSizeComputedFlag(twidget);  
		  size_changed = 1;
		}
	    }
	  break;
	case EZ_PADY:
	  value = i1;
	    {
	      EZ_Widget *twidget;
	      switch(type)
		{
		case EZ_WIDGET_TREE:
		  twidget = EZ_TreeWITree(widget);		  
		  break;
		case EZ_WIDGET_LIST_BOX:
		  twidget = EZ_ListBoxIListBox(widget);
		  break;
		case EZ_WIDGET_TEXT:
		  twidget = EZ_TextIText(widget);		
		  break;
		case EZ_WIDGET_FANCY_LIST_BOX:
		  twidget = EZ_FListBoxIFListBox(widget);
		  break;
		case EZ_WIDGET_WORK_AREA:
		  twidget = EZ_WorkAreaIWorkArea(widget);
		  break;
		default:
		  twidget = widget;
		  break;
		}
	      if( EZ_WidgetPadY(twidget) != value)
		{
		  EZ_WidgetPadY(twidget) = value;
		  EZ_ClearWidgetSizeComputedFlag(twidget);  
		  size_changed = 1;
		}
	    }
	  break;
	case EZ_IPADX:
	  value = i1;
	    {
	      EZ_Widget *twidget;
	      switch(type)
		{
		case EZ_WIDGET_LIST_BOX:
		  twidget = EZ_ListBoxIListBox(widget);
		  break;
		case EZ_WIDGET_TEXT:
		  twidget = EZ_TextIText(widget);
		  break;
		case EZ_WIDGET_NOTE_BOOK:
		  twidget = NULL;
		  break;
		case EZ_WIDGET_TREE:
		  twidget = EZ_TreeWITree(widget);
		  break;
		case EZ_WIDGET_FANCY_LIST_BOX:
		  twidget = EZ_FListBoxIFListBox(widget);
		  break;
		case EZ_WIDGET_WORK_AREA:
		  twidget = EZ_WorkAreaIWorkArea(widget);
		  break;
		default:
		  twidget = widget;
		  break;
		}
	      if(twidget && EZ_WidgetSepX(twidget) != value)
		{
		  EZ_WidgetSepX(twidget) = value;
		  size_changed = 1;
		}
	    }
	  break;
	case EZ_IPADY:
	  value = i1;
	    {
	      EZ_Widget *twidget;
	      switch(type)
		{
		case EZ_WIDGET_LIST_BOX:
		  twidget = EZ_ListBoxIListBox(widget);
		  break;
		case EZ_WIDGET_TEXT:
		  twidget = EZ_TextIText(widget);
		  break;
		case EZ_WIDGET_NOTE_BOOK:
		  twidget = NULL;
		  break;
		case EZ_WIDGET_TREE:
		  twidget = EZ_TreeWITree(widget);
		  break;
		case EZ_WIDGET_FANCY_LIST_BOX:
		  twidget = EZ_FListBoxIFListBox(widget);
		  break;
		case EZ_WIDGET_WORK_AREA:
		  twidget = EZ_WorkAreaIWorkArea(widget);
		  break;
		default:
		  twidget = widget;
		  break;
		}
	      if(twidget && EZ_WidgetSepY(twidget) != value)
		{
		  EZ_WidgetSepY(twidget) = value;
		  size_changed = 1;
		}
	    }
	  break;
	case EZ_STACKING:
	  value = i1;
	  if(value >= EZ_WIDGET_STACKING_BEGIN &&
	     value <= EZ_WIDGET_STACKING_END)
	    {
	      switch(type)
		{
		case EZ_WIDGET_TREE:
		case EZ_WIDGET_LIST_BOX:
		case EZ_WIDGET_TEXT:
		case EZ_WIDGET_WORK_AREA:
		case EZ_WIDGET_NOTE_BOOK:
		case EZ_WIDGET_OPTIONAL_ENTRY:
		case EZ_WIDGET_FILE_SELECTOR:
		  EZ_ConfigureError(widget,option, "option not available");
		  break;
		default:
		  if(EZ_WidgetStacking(widget) != value)
		    {
		      EZ_WidgetStacking(widget) = value;
		      size_changed = 1;
		    }
		  break;
		}
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");
	  break;
	case EZ_SIDE:
	  value = i1;
	  if(value >= EZ_WIDGET_SIDE_BEGIN &&
	     value <= EZ_WIDGET_SIDE_END)
	    {
	      if(type != EZ_WIDGET_LIST_BOX && type != EZ_WIDGET_TEXT &&
		 type != EZ_WIDGET_NOTE_BOOK && type != EZ_WIDGET_TREE)
		if(EZ_WidgetAlignment(widget) != value)
		  {
		    EZ_WidgetAlignment(widget) = value;	  
		    size_changed = 1;
		  }
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");
	  break;
	case EZ_LABEL_POSITION:
	  value = i1;
	  if(value >= EZ_WIDGET_LABEL_POSITION_BEGIN &&
	     value <= EZ_WIDGET_LABEL_POSITION_END)
	    {
	      if(EZ_WidgetLabelPosition(widget) != value)
		{
		  EZ_WidgetLabelPosition(widget) = value;	  
		  size_changed = 1;
		}
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");
	  break;
	case EZ_JUSTIFICATION:
	  value = i1;
	  if(value >= EZ_CENTER &&   value <= EZ_RIGHT)  /* 0, 1, 2 :: CENTER, LEFT, RIGHT */
	    {
	      if(EZ_WidgetJustification(widget) != value)
		{
		  EZ_WidgetJustification(widget) = value;	  
		  size_changed = 1;
		}
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");
	  break;
	case EZ_FILL_MODE:
	  value = i1;
	  if(value >= EZ_WIDGET_FILL_BEGIN &&
	     value <= EZ_WIDGET_FILL_END)
	    {
	      switch(type)
		{
		case EZ_WIDGET_TREE:
		case EZ_WIDGET_LIST_BOX:
		case EZ_WIDGET_TEXT:
		case EZ_WIDGET_NOTE_BOOK:
		case EZ_WIDGET_FILE_SELECTOR:
		case EZ_WIDGET_OPTIONAL_ENTRY:
		  break;
		default:
		  if(EZ_WidgetFillMode(widget) != value)
		    {
		      EZ_WidgetFillMode(widget) = value; 
		      size_changed = 1;
		    }
		}
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");
	  break;
	case EZ_TEXT_SPACING:
	  {
	    EZ_Widget *twidget = NULL;
	    int        value;
	    value    = i1;
	    if(type == EZ_WIDGET_TEXT)
	      {twidget = EZ_TextIText(widget);}
	    else if(type == EZ_WIDGET_ITEXT)
	      { twidget = widget;}
	    if(twidget)
	      {
		EZ_ITextVSpacing(twidget) = value;
		size_changed = 1;
	      }
	    else
	      EZ_ConfigureError(widget,option, "option not applicable"); 
	  }
	  break;
	case EZ_FOREGROUND:
	  {
	    char *color;
	    EZ_Widget *twidget = widget;
	    unsigned long  pixel_value;

	    color     = (char *)p1;
	    pixel_value = EZ_AllocateColorFromName(color);
	    if(pixel_value == 0) pixel_value = EZ_DefaultForeground;
	    switch(type)
	      {
	      case EZ_WIDGET_TREE:
		twidget = EZ_TreeWITree(widget);		  
		break;
	      case EZ_WIDGET_LIST_BOX:
		twidget = EZ_ListBoxIListBox(widget);
		break;
	      case EZ_WIDGET_TEXT:
		twidget = EZ_TextIText(widget); 
		break;
	      case  EZ_WIDGET_NOTE_BOOK:
		{
		  EZ_Widget *tframe = EZ_NoteBookTFrame(widget);
		  EZ_Widget *stub = EZ_WidgetChildren(tframe);
		  while(stub)
		    {
		      if(EZ_WidgetForeground(stub) == EZ_DefaultForeground)
			EZ_WidgetForeground(stub) = pixel_value;
		      stub = EZ_WidgetSibling(stub);
		    }
		}
		break;
	      case EZ_WIDGET_NB_PAGE:
		{
		  EZ_Widget *companion = EZ_NBPageCompanion(widget);
		  EZ_WidgetForeground(companion) = pixel_value;
		}
		break;
	      case  EZ_WIDGET_OPTIONAL_ENTRY:
		{
		  EZ_Widget *entry = (EZ_Widget *)EZ_OptEntryEntry(widget);
		  EZ_Widget *listbox = (EZ_Widget *)EZ_OptEntryListbox(widget);
		  EZ_WidgetForeground(entry) = pixel_value;
		  twidget =  EZ_ListBoxIListBox(listbox);
		}
		break;
	      default:
		break;
	      }
	    EZ_WidgetForeground(twidget) = pixel_value;
	  }
	  break;
	case EZ_TEXT_BACKGROUND:
	  {
	    char *color;
	    unsigned long  pixel_value;
	    EZ_Widget *twidget;

	    color = (char *)p1;
	    pixel_value = EZ_AllocateNewBackground(color);
	    switch(type)
	      {
	      case EZ_WIDGET_TREE:
		twidget = EZ_TreeWITree(widget); 
		if(EZ_ITreeWTextBG(twidget) != pixel_value)
		  {
		    EZ_ITreeWTextBG(twidget) = pixel_value;
		    size_changed = 1;
		  }
		break;
	      case EZ_WIDGET_ITREE:
		if(EZ_ITreeWTextBG(widget) != pixel_value)
		  {
		    EZ_ITreeWTextBG(widget) = pixel_value;
		    size_changed = 1;
		  }
		break;
	      case EZ_WIDGET_TEXT:
		twidget = EZ_TextIText(widget);
		if(EZ_ITextTextBG(twidget) != pixel_value)
		  {
		    EZ_ITextTextBG(twidget) = pixel_value;
		    size_changed = 1;
		  }
		break;
	      case EZ_WIDGET_ITEXT:
		if(EZ_ITextTextBG(widget) != pixel_value)
		  {
		    EZ_ITextTextBG(widget) = pixel_value;
		    size_changed = 1;
		  }		
		break;
	      case EZ_WIDGET_LIST_BOX:
		twidget = EZ_ListBoxIListBox(widget);
		if(EZ_IListBoxTextBG(twidget) != pixel_value)
		  {
		    EZ_IListBoxTextBG(twidget) = pixel_value;
		    size_changed = 1;
		  }
		break;
	      case EZ_WIDGET_ILIST_BOX:
		if(EZ_IListBoxTextBG(widget) != pixel_value)
		  {
		    EZ_IListBoxTextBG(widget) = pixel_value;
		    size_changed = 1;
		  }
		break;
	      case EZ_WIDGET_IFANCY_LIST_BOX:
		if(EZ_IFListBoxTextBG(widget) != pixel_value)
		  {
		    EZ_IFListBoxTextBG(widget) = pixel_value;
		    size_changed = 1;
		  }
		break;
	      case EZ_WIDGET_FANCY_LIST_BOX:
		twidget = EZ_FListBoxIFListBox(widget);
		if(EZ_IFListBoxTextBG(twidget) != pixel_value)
		  {
		    EZ_IFListBoxTextBG(twidget) = pixel_value;
		    size_changed = 1;
		  }
		break;
	      case EZ_WIDGET_IWORK_AREA:
		if(EZ_IWorkAreaTextBG(widget) != pixel_value)
		    {
		      EZ_IFListBoxTextBG(widget) = pixel_value;
		      size_changed = 1;
		    }
		break;		
	      case EZ_WIDGET_WORK_AREA:
		twidget = EZ_WorkAreaIWorkArea(widget);
		if(EZ_IWorkAreaTextBG(twidget) != pixel_value)
		  {
		    EZ_IWorkAreaTextBG(twidget) = pixel_value;
		    size_changed = 1;
		  }
		break;
	      default:
		EZ_ConfigureError(widget,option, "Optional not available");
		break;
	      }
	  }
	  break;
	case EZ_BACKGROUND:
	  {
	    char *color;
	    unsigned long  pixel_value;

	    color     = (char *)p1;
	    pixel_value = EZ_AllocateNewBackground(color);
	    if(type == EZ_WIDGET_NB_PAGE)
	      {
		EZ_Widget *companion = EZ_NBPageCompanion(widget);
		EZ_WidgetBackground(companion) = pixel_value;
	      }
	    EZ_WidgetBackground(widget) = pixel_value; 
	  }
	  break;
	case EZ_BITMAP_FILE:
	  {
	    char *file = (char *)p1;
	    EZ_Bitmap *bitmap = (file && file[0] ? EZ_GetBitmapFromFile(file, 1):
				 (EZ_Bitmap *)NULL);
	    shape_changed |= EZ_SetWidgetPixmap(widget,bitmap,option);
	  }
	  break;
	case EZ_BITMAP_DATA:  /* this is the only option which needs 3 values */
	  {
	    char *data = (char *)p1;
	    int width = (unsigned int) i1;
	    int height = (unsigned int) i2;
	    if(width > 0 && height > 0)
	      {
		EZ_Bitmap *bitmap = EZ_GetBitmapFromData(data, 
							 (unsigned int)width,
							 (unsigned int)height);
		shape_changed |= EZ_SetWidgetPixmap(widget,bitmap,option);
	      }
	  }
	  break;
	case EZ_PIXMAP_DATA:
	  {
	    char **file = (char **)p1;
	    EZ_Bitmap *bitmap = (file == (char **)NULL? (EZ_Bitmap *)NULL:
				 EZ_GetPixmapFromData(file));
	    shape_changed |= EZ_SetWidgetPixmap(widget,bitmap,option);
	  }
	  break;
	case EZ_X_PIXMAP:
	  {
	    Pixmap pixmap = (Pixmap)ul1;
	    int    x = i1;
	    int    y = i2;
	    int width = i3;
	    int height = i4;
	    EZ_Bitmap *bitmap = EZ_GetPixmapFromPixmap(pixmap,x,y,width,height);
	    shape_changed |= EZ_SetWidgetPixmap(widget,bitmap,option);
	  }
	  break;

	  /*
	   * Allow raw rgb data to be displayed.
	   * Arno Dabekaussen, 03-05-97, Maastricht, NL.
	   */

	case EZ_RAW_RGB_DATA:
	  {
	    char *RGBmap = (char *) p1;
	    int width = (int) i1;
	    int height = (int) i2;
	    
	    EZ_Bitmap *bitmap = EZ_GetPixmapFromRawRGB(RGBmap, width, height);
	    shape_changed |= EZ_SetWidgetPixmap(widget, bitmap, option);
	  }
	  break;
	case EZ_LABEL_PIXMAP:
	  {
	    char *tmp =  ( char *)p1;
	    EZ_Bitmap *bitmap = (EZ_Bitmap *)tmp;
	    if(bitmap)	bitmap->ref += 1;
	    shape_changed |= EZ_SetWidgetPixmap(widget,bitmap,option); 
	  }
	  break;
	case EZ_IMAGE_FILE:
	  {
	    char *file = (char *)p1;
	    EZ_Bitmap *bitmap = (file == (char *)NULL? (EZ_Bitmap *)NULL:
				 EZ_GetImageFromFile(file, 1));
	    if(bitmap || file == (char *)NULL)
	      shape_changed |= EZ_SetWidgetPixmap(widget,bitmap,option);
	  }
	  break;
	case EZ_FONT_ID:
	case EZ_FONT_NAME:
	  {
	    EZ_Widget *twidget = widget;
	    XFontStruct *tmpfont;
	    int boldfont;

	    if(option == EZ_FONT_ID)
	      {
		value =  i1;
		tmpfont = EZ_GetFontFromId(value);
		boldfont = EZ_FontWeightIsBold(EZ_GetFontNameFromId(value));
	      }
	    else
	      {
		char *fontname = (char *)p1;
		tmpfont = EZ_GetFontFromName(fontname);
		boldfont = EZ_FontWeightIsBold(fontname);
	      }

	    switch(type)
	      {
	      case EZ_WIDGET_TREE: 
		twidget = EZ_TreeWITree(widget);
		break;
	      case EZ_WIDGET_WORK_AREA:
		twidget = EZ_WorkAreaIWorkArea(widget);
		break;
	      case EZ_WIDGET_FANCY_LIST_BOX: 
		twidget = EZ_FListBoxIFListBox(widget);
		break;
	      case EZ_WIDGET_TEXT: 
		twidget = EZ_TextIText(widget);
		break;
	      case EZ_WIDGET_LIST_BOX:
		twidget = EZ_ListBoxIListBox(widget);
		break;
	      case EZ_WIDGET_NOTE_BOOK:
		{
		  EZ_Widget *tframe = EZ_NoteBookTFrame(widget);
		  EZ_Widget *stub = EZ_WidgetChildren(tframe);
		  while(stub)
		    {
		      if(EZ_WidgetFont(stub) != tmpfont && 
			 EZ_WidgetFont(stub) == EZ_GetFontFromId(EZ_ITALIC_FONT))
			{
			  EZ_WidgetFont(stub) = tmpfont;
			  EZ_ClearWidgetSizeComputedFlag(stub);
			  if(boldfont) {EZ_ClearWidgetThinFontFlag(stub);}
			  else {EZ_SetWidgetThinFontFlag(stub);}
			  EZ_ClearWidgetSizeComputedFlag(tframe);
			  size_changed = 1;
			}
		      stub = EZ_WidgetSibling(stub);
		    }
		}
		break;
	      case EZ_WIDGET_NB_PAGE:
		{
		  EZ_Widget *companion = EZ_NBPageCompanion(widget);
		  if(EZ_WidgetFont(companion) != tmpfont)
		    {
		      EZ_WidgetFont(companion) = tmpfont;
		      EZ_ClearWidgetSizeComputedFlag(companion);
		      EZ_ClearWidgetSizeComputedFlag(EZ_WidgetParent(companion));
		      if(boldfont) {EZ_ClearWidgetThinFontFlag(companion);}
		      else {EZ_SetWidgetThinFontFlag(companion);}
		      size_changed = 1;
		    }
		}
		break;
	      case  EZ_WIDGET_OPTIONAL_ENTRY:
		{
		  EZ_Widget *entry = (EZ_Widget *)EZ_OptEntryEntry(widget);
		  EZ_Widget *listbox = (EZ_Widget *)EZ_OptEntryListbox(widget);
		  if(EZ_WidgetFont(entry) != tmpfont)
		    {
		      EZ_WidgetFont(entry) = tmpfont;
		      EZ_ClearWidgetSizeComputedFlag(entry);
		      if(boldfont) {EZ_ClearWidgetThinFontFlag(entry);}
		      else {EZ_SetWidgetThinFontFlag(entry);}
		    }
		  twidget =  EZ_ListBoxIListBox(listbox);
		}
		break;
	      case EZ_WIDGET_LED:
		if(EZ_WidgetFont(widget) != tmpfont)
		  {
		    EZ_LEDStatus(widget) |= LED_BLOCKED;
		    EZ_LEDDirty(widget) |= (LED_MASK_DIRTY | LED_PIXMAP_DIRTY);
		  }
		break;
	      default:
		break;
	      }
	    if(EZ_WidgetFont(twidget) != tmpfont)
	      {
		EZ_WidgetFont(twidget) = tmpfont;
		EZ_ClearWidgetSizeComputedFlag(twidget);
		if(boldfont) {EZ_ClearWidgetThinFontFlag(twidget);}
		else {EZ_SetWidgetThinFontFlag(twidget);}
		size_changed = 1;		    
	      }
	  }
	  break;
	case EZ_TEXT_LINE_LENGTH:
	  value = i1;
	  if(value > 0)
	    {
	      switch(type)
		{
		case EZ_WIDGET_LED:
		  if(EZ_LEDLineLength(widget) != value)
		    {
		      EZ_LEDLineLength(widget) = value;
		      size_changed = 1;
		    }
		  break;
		case EZ_WIDGET_LABEL:
		case EZ_WIDGET_ITOPLEVEL:
		case EZ_WIDGET_NW_LABEL:
		  if(EZ_LabelLineLength(widget) != value)
		    {
		      EZ_LabelLineLength(widget) = value;
		      size_changed = 1;
		    }
		  break;
		case EZ_WIDGET_NORMAL_BUTTON:
		case EZ_WIDGET_MENU_NORMAL_BUTTON:
		  if(EZ_ButtonLineLength(widget) != value)
		    {
		      EZ_ButtonLineLength(widget) = value;
		      size_changed = 1;
		    }
		  break;
		case EZ_WIDGET_CHECK_BUTTON:
		case EZ_WIDGET_MENU_CHECK_BUTTON:
		  if(EZ_CButtonLineLength(widget) != value)
		    {
		      EZ_CButtonLineLength(widget) = value;
		      size_changed = 1;
		    }
		  break;
		case EZ_WIDGET_RADIO_BUTTON:
		case EZ_WIDGET_MENU_RADIO_BUTTON:
		  if(EZ_RButtonLineLength(widget) != value)
		    {
		      EZ_RButtonLineLength(widget) = value;
		      size_changed = 1;
		    }
		  break;
		case EZ_WIDGET_MENU_BUTTON:
		  if(EZ_MButtonLineLength(widget) != value)
		    {
		      EZ_MButtonLineLength(widget) = value;
		      size_changed = 1;
		    }
		  break;
		case EZ_WIDGET_MENU_SUBMENU:
		  if(EZ_SubMenuLineLength(widget) != value)
		    {
		      EZ_SubMenuLineLength(widget) = value;
		      size_changed = 1;
		    }
		  break;
		case EZ_WIDGET_FRAME:
		  {
		    if(EZ_FrameLineLength(widget) != value)
		      {
			EZ_FrameLineLength(widget) = value;
			size_changed = 1;
		      }
		  }
		  break;
		case EZ_WIDGET_ENTRY:
		  if(EZ_EntryLineLength(widget) != value)
		    {
		      EZ_EntryLineLength(widget) = value;
		      size_changed = 1;
		    }
		  break;
		case  EZ_WIDGET_OPTIONAL_ENTRY:
		  {
		    EZ_Widget *entry = (EZ_Widget *)EZ_OptEntryEntry(widget);
		    if(EZ_EntryLineLength(entry) != value)
		      {
			EZ_EntryLineLength(entry) = value;
			size_changed = 1;
		      }
		  }
		  break;
		case EZ_WIDGET_NOTE_BOOK:
		  {
		    EZ_Widget *tframe = EZ_NoteBookTFrame(widget);
		    EZ_Widget *stub = EZ_WidgetChildren(tframe);
		    while(stub)
		      {
			if(EZ_ButtonLineLength(stub) != value &&
			   EZ_ButtonLineLength(stub) == EZ_DEFAULT_LABEL_LINE_LENGTH)
			  {
			    EZ_ButtonLineLength(stub) = value;
			    EZ_ClearWidgetSizeComputedFlag(stub);
			    EZ_ClearWidgetSizeComputedFlag(tframe);
			    size_changed = 1;
			  }
			stub = EZ_WidgetSibling(stub);
		      }
		  }
		  break;
		case EZ_WIDGET_NB_PAGE:		  
		  {
		    EZ_Widget *companion = EZ_NBPageCompanion(widget);
		    if(EZ_ButtonLineLength(companion) != value)
		      {
			EZ_ButtonLineLength(companion) = value;
			EZ_ClearWidgetSizeComputedFlag(companion);
			EZ_ClearWidgetSizeComputedFlag(EZ_WidgetParent(companion));
			size_changed = 1;
		      }
		  }
		  break;
		default:
		  EZ_ConfigureError(widget,option, "option not applicable");	  
		  break;
		}
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");	  
	  break;
	case EZ_SLIDER_DISPLAY_VALUE:
	  value = i1;
	  if(type == EZ_WIDGET_HORIZONTAL_SLIDER ||
	     type == EZ_WIDGET_VERTICAL_SLIDER )
	    {
	      EZ_SliderDisplayValue(widget) = (value != 0);
	      size_changed = 1;
	    }
	  else EZ_ConfigureError(widget,option, "option not applicable");	  
	  break;
	case EZ_SLIDER_LENGTH:
	  value = i1;
	  if(value > 0)
	    {
	      if(type == EZ_WIDGET_HORIZONTAL_SLIDER ||
		 type == EZ_WIDGET_VERTICAL_SLIDER )
		{
		  if(EZ_SliderSliderLength(widget) != value)
		    {
		      EZ_SliderSliderLength(widget) = value;
		      size_changed = 1;
		    }
		}
	      else EZ_ConfigureError(widget,option, "option not applicable");	  
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");	  
	  break;
	case EZ_SLIDER_WIDTH:
	  value = i1;
	  if(value > 0)
	    {
	      if(type == EZ_WIDGET_HORIZONTAL_SLIDER ||
		 type == EZ_WIDGET_VERTICAL_SLIDER )
		{
		  if(EZ_SliderWidth(widget) != value)
		    {
		      EZ_SliderWidth(widget) = value;
		      EZ_SliderWidthSet(widget) = 1;
		      size_changed = 1;
		    }
		}
	      else   EZ_ConfigureError(widget,option, "option not applicable");	  
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");	  
	  break;
	case EZ_SLIDER_BORDER_WIDTH:
	  value = i1;
	  if(value > 0)
	    {
	      if(type == EZ_WIDGET_HORIZONTAL_SLIDER ||
		 type == EZ_WIDGET_VERTICAL_SLIDER )
		{
		  
		  if(EZ_SliderBorderWidth(widget)  != value)
		    {
		      EZ_SliderBorderWidth(widget) = value;
		      size_changed = 1;
		    }
		}
	      else  EZ_ConfigureError(widget,option, "option not applicable");	  
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");	  
	  break;
	case EZ_SLIDER_RESOLUTION: 
	  {
	    float fvalue = (float)f1;
	    if(fvalue > 0.0)
	      {
		if(type == EZ_WIDGET_HORIZONTAL_SLIDER ||
		   type == EZ_WIDGET_VERTICAL_SLIDER )
		  {
		    EZ_SliderResolution(widget) = fvalue;
		    size_changed = 1;
		  }
		else EZ_ConfigureError(widget,option, "option not applicable");
	      }
	    else EZ_ConfigureError(widget,option, "Value Out of range");
	  }
	  break;
	case EZ_SLIDER_RANGE: 
	  {
	    float from, to;
	    from = f1;
	    to =  f2;
	    if(type == EZ_WIDGET_HORIZONTAL_SLIDER ||
	       type == EZ_WIDGET_VERTICAL_SLIDER )
	      {
		EZ_SliderMinValue(widget) = (float)from;
		EZ_SliderMaxValue(widget) = (float)to;
		size_changed = 1;
	      }
	    else EZ_ConfigureError(widget,option, "option not applicable");
	  }
	  break;
	case EZ_INDICATOR_SIZE_ADJUST:
	  value = i1;
	  if(value >= -4 )
	    {
	      switch(type)
		{
		case EZ_WIDGET_CHECK_BUTTON:  case EZ_WIDGET_MENU_CHECK_BUTTON:
		  if(EZ_CButtonCheckSizeAdjust(widget) != value)
		    {
		      EZ_CButtonCheckSizeAdjust(widget) = value;
		      size_changed = 1;
		    }
		  break;
		case EZ_WIDGET_RADIO_BUTTON: case EZ_WIDGET_MENU_RADIO_BUTTON:
		  if(EZ_RButtonCheckSizeAdjust(widget) != value)
		    {
		      EZ_RButtonCheckSizeAdjust(widget) = value;
		      size_changed = 1;
		    }
		  break;
		case EZ_WIDGET_MENU_BUTTON:
		  if(EZ_MButtonCheckSizeAdjust(widget) != value)
		    {
		      EZ_MButtonCheckSizeAdjust(widget) = value;
		      size_changed = 1;
		    }
		  break;
		default:
		  EZ_ConfigureError(widget,option, "option not applicable");	  
		  break;
		}
	    }
	  else EZ_ConfigureError(widget,option, "Value Out of range");	  
	  break; 
	case EZ_BUTTON_SHORTCUT:
	  {
	    char *str = (char *)p1;
	    EZ_SetKeyShortcut(widget, str);
	    size_changed = 1;
	  }
	  break;
	case EZ_CALL_BACK:
	  {
	    EZ_CallBack tmpfunc = (EZ_CallBack)p1;
	    void *data = p2;
	    EZ_RemoveAllWidgetCallBacks(widget, EZ_CALLBACK);
	    EZ_AddWidgetCallBack(widget,EZ_CALLBACK, tmpfunc, data, 0);
	  }
	break;
	case EZ_MOTION_CALLBACK:
	  {
	    EZ_CallBack tmpfunc = (EZ_CallBack)p1;
	    void *data = p2;
	    EZ_RemoveAllWidgetCallBacks(widget, EZ_MOTION_CALLBACK);
	    EZ_AddWidgetCallBack(widget,EZ_MOTION_CALLBACK, tmpfunc,data, 0);
	  }
	  break;
	case EZ_EVENT_HANDLE:
	  {
	    EZ_EventHandler tmpfunc = (EZ_EventHandler)p1;
	    void *data = p2;
	    EZ_RemoveAllEventHandlers(widget);
	    EZ_AddEventHandler(widget, tmpfunc, data, 0);
	  }
	break;
	case EZ_DESTROY_CALLBACK:
	  {
	    EZ_CallBack tmpfunc = (EZ_CallBack)p1;
	    void *data = p2;
	    EZ_RemoveAllWidgetCallBacks(widget, EZ_DESTROY_CALLBACK);
	    EZ_AddWidgetCallBack(widget,EZ_DESTROY_CALLBACK, tmpfunc, data, 0);
	  }
	break;
	case EZ_BUBBLE_HELP:
	  {
	    char *ostr, *str = (char *)p1;
	    int olen, len = str? strlen(str): 0;
	    
	    ostr = EZ_WidgetBubbleString(widget);
	    if(len == 0) /* disable bubble help */
	      {
		if(ostr) (void)my_free(ostr);
		EZ_WidgetBubbleString(widget) = (char *)NULL;
	      }
	    else
	      {
		if(ostr)
		  {
		    olen = strlen(ostr);
		    if(olen < len)
		      ostr = EZ_WidgetBubbleString(widget) = (char *)my_realloc(ostr, len, _BUBBLE_STRING_);
		    if(!ostr) EZ_OutOfMemory("EZ_ConfigureWidget:BubbelString");
		    (void)strcpy(ostr, str);
		  }
		else
		  EZ_WidgetBubbleString(widget) = EZ_AllocCopyString(str);
		size_changed = 1;
	      }
	  }
	  break;
	case EZ_FREELABEL_MOVABLE:
	  value = i1;
	  switch(type)
	    {
	    case EZ_WIDGET_ITOPLEVEL:
	      EZ_LabelMovable(widget) = (value == 0? 0: 1);
	      break;
	    case EZ_WIDGET_WORK_AREA:
	      {
		EZ_Widget *tw = EZ_WorkAreaIWorkArea(widget);
		EZ_IWorkAreaItemMovable(tw) = (value == 0? 0: 1);
	      }
	    break;
	    case EZ_WIDGET_IWORK_AREA:
	      {
		EZ_IWorkAreaItemMovable(widget) = (value == 0? 0: 1);
	      }
	    break;
	    default:
	      EZ_ConfigureError(widget,option, "option not applicable"); 
	    }
	  break;	  
	case EZ_LABEL_STRING:
	  {
	    char *str = (char *)p1;
	    size_changed = EZ_SetWidgetLabelString(widget,str);
	  }
	  break;
	case EZ_NAME:
	  {
	    char *str = (char *)p1;
	    if(str && *str) 
	      EZ_WidgetIName(widget) = EZ_StringToQuark(str);
	  }
	  break;
	case EZ_POPUP_NAME:
	  if(type == EZ_WIDGET_OPTIONAL_ENTRY)
	    {
	      EZ_Widget *tmp = EZ_OptEntryPopup(widget);
	      char *str = (char *)p1;
	      if(str && *str)
		EZ_WidgetIName(tmp) = EZ_StringToQuark(str);
	    }
	  else if(type == EZ_WIDGET_FILE_SELECTOR)
	    {
	      char *ptr = (char *)p1;
	      if(ptr && *ptr)
		{
		  char str[256];
		  int len = 0;
		  EZ_Widget *ee,*pp;
		  while(*ptr) str[len++] = *ptr++;
		  str[len] = str[len+1] = 0;
		  ee = EZ_FileSelectorPatternEntry(widget);
		  pp = EZ_OptEntryPopup(ee);
		  str[len]='A';
		  EZ_WidgetIName(pp) = EZ_StringToQuark(str);
		  ee = EZ_FileSelectorSelectionEntry(widget);
		  pp = EZ_OptEntryPopup(ee);
		  str[len]='B';
		  EZ_WidgetIName(pp) = EZ_StringToQuark(str);
		}
	    }
	  break;
	case EZ_CLASS:
	  {
	    char *str = (char *)p1;
	    if(str && *str)
	      EZ_WidgetCName(widget) = EZ_StringToQuark(str);
	  }
	  break;
	case EZ_RESERVE_MENU_BUTTON:
	  value = i1;
	  if(type == EZ_WIDGET_3D_CANVAS)
	    EZ_3DCanvasReleaseMenuButton(widget) = (value == 0? 1: 0);
	  else
	    EZ_ConfigureError(widget,option, "option not applicable"); 
	  break;
	case EZ_BACKING_STORE:
	  value = i1;
	  if(type == EZ_WIDGET_3D_CANVAS)
	    EZ_3DCanvasBackingStore(widget) = (value == 0? 0:1);
	  else
	    EZ_ConfigureError(widget,option, "option not applicable"); 
	  break;
	case EZ_EXPAND:
	  value = i1;
	  if(value == 0) {EZ_ClearWidgetExpandFlag(widget);}
	  else   EZ_SetWidgetExpandFlag(widget);
	  break;
	case EZ_TRANSIENT:
	  value = i1;
	  if(value == 0) { EZ_ClearWidgetTransientFlag(widget);}
	  else  {EZ_SetWidgetTransientFlag(widget);}
	  break;
	case EZ_SCROLLBAR_WIDTH:
	  value = i1;
	  {
	    EZ_Widget *hwidget = (EZ_Widget *)NULL;
	    EZ_Widget *vwidget = (EZ_Widget *)NULL;

	    switch( type )
	      {
	      case EZ_WIDGET_TREE: 
		hwidget = EZ_TreeWHScroll(widget);
		vwidget = EZ_TreeWVScroll(widget);
		break;
	      case EZ_WIDGET_WORK_AREA:
		hwidget = EZ_WorkAreaHScroll(widget);
		vwidget = EZ_WorkAreaVScroll(widget);
		break;
	      case EZ_WIDGET_FANCY_LIST_BOX:
		hwidget = EZ_FListBoxHScroll(widget);
		vwidget = EZ_FListBoxVScroll(widget);
		break;
	      case EZ_WIDGET_LIST_BOX:
		hwidget = EZ_ListBoxHScroll(widget);
		vwidget = EZ_ListBoxVScroll(widget);
		break;
	      case EZ_WIDGET_TEXT:
		hwidget = EZ_TextHScroll(widget);
		vwidget = EZ_TextVScroll(widget);
		break;
	      case EZ_WIDGET_HORIZONTAL_SCROLLBAR:
		hwidget = widget;
		break;
	      case EZ_WIDGET_VERTICAL_SCROLLBAR:
		vwidget = widget;
		break;
	      case  EZ_WIDGET_OPTIONAL_ENTRY:
		{
		  EZ_Widget *listbox = EZ_OptEntryListbox(widget);
		  hwidget = EZ_ListBoxHScroll(listbox);
		  vwidget = EZ_ListBoxVScroll(listbox);
		}
		break;
	      default:
		break;
	      }
	    if(hwidget) 
	      {
		if(EZ_ScrollSSize(hwidget) != value)
		  {
		    EZ_ScrollSSize(hwidget) = value;
		    EZ_ClearWidgetSizeComputedFlag(hwidget);  
		    size_changed = 1;
		  }
	      }
	    if(vwidget) 
	      {
		if(EZ_ScrollSSize(vwidget) != value)
		  {
		    EZ_ScrollSSize(vwidget) = value;
		    EZ_ClearWidgetSizeComputedFlag(vwidget);  
		    size_changed = 1;
		  }
	      }
	  }
	  break;
	case EZ_SCROLLBAR_BORDER_WIDTH:
	  value = i1;
	  if(value >= 0 && value <= 100)
	    {
	      EZ_Widget *hwidget = (EZ_Widget *)NULL;
	      EZ_Widget *vwidget = (EZ_Widget *)NULL;

	      switch( type )
		{
		case EZ_WIDGET_TREE: 
		  hwidget = EZ_TreeWHScroll(widget);
		  vwidget = EZ_TreeWVScroll(widget);
		  break;
		case EZ_WIDGET_WORK_AREA:
		  hwidget = EZ_WorkAreaHScroll(widget);
		  vwidget = EZ_WorkAreaVScroll(widget);
		  break;
		case EZ_WIDGET_FANCY_LIST_BOX:
		  hwidget = EZ_FListBoxHScroll(widget);
		  vwidget = EZ_FListBoxVScroll(widget);
		  break;
		case EZ_WIDGET_LIST_BOX:
		  hwidget = EZ_ListBoxHScroll(widget);
		  vwidget = EZ_ListBoxVScroll(widget);
		  break;
		case EZ_WIDGET_TEXT:
		  hwidget = EZ_TextHScroll(widget);
		  vwidget = EZ_TextVScroll(widget);
		  break;
		case EZ_WIDGET_HORIZONTAL_SCROLLBAR:
		  hwidget = widget;
		  break;
		case EZ_WIDGET_VERTICAL_SCROLLBAR:
		  vwidget = widget;
		  break;
		case  EZ_WIDGET_OPTIONAL_ENTRY:
		  {
		    EZ_Widget *listbox = EZ_OptEntryListbox(widget);
		    hwidget = EZ_ListBoxHScroll(listbox);
		    vwidget = EZ_ListBoxVScroll(listbox);
		  }
		  break;
		default:
		  break;
		}
	      if(hwidget) 
		{
		  if(EZ_WidgetBorderWidth(hwidget) != value)
		    {
		      EZ_WidgetBorderWidth(hwidget) = value;
		      EZ_ScrollBorderWidth(hwidget) = value; /* 6.3.96 */
		      EZ_ClearWidgetSizeComputedFlag(hwidget);  
		      size_changed = 1;
		    }
		}
	      if(vwidget) 
		{
		  if(EZ_WidgetBorderWidth(vwidget) != value)
		    {
		      EZ_WidgetBorderWidth(vwidget) = value;
		      EZ_ScrollBorderWidth(vwidget) = value; /* 6.3.96 */
		      EZ_ClearWidgetSizeComputedFlag(vwidget);  
		      size_changed = 1;
		    }
		}
	    }
	  break;
	case EZ_PROPAGATE:
	  value = i1;
	  if(value==0) { EZ_SetDoNotPropagateFlag(widget);}
	  else  {EZ_ClearDoNotPropagateFlag(widget);}
	  break;
	case EZ_WMHINTS: /* inherited from previous versions: sizeHints */
	case EZ_WM_WINDOW_NAME:
	case EZ_WM_ICON_NAME:
	case EZ_WM_ICON_XPM_FILE:
	case EZ_WM_ICON_PIXMAP:
	case EZ_WM_ICON_LOCATION:
	case EZ_WM_LOCATION_HINT:
	case EZ_WM_SIZE_HINT:
	case EZ_WM_MAX_SIZE_HINT:
	case EZ_WM_MIN_SIZE_HINT:
	case EZ_WM_INITIAL_STATE:
	  EZ_SetWidgetWMHints(widget,option, i1, i2, p1 );
	  break;
	case EZ_MARK_CLEAN:
	  if(i1 > 0) size_changed = -(1<<30);
	  else if(i1 < 0) size_changed = -(1<<29);

	  break;
	case 0:
	  break;
	default:
	  EZ_ConfigureError(widget,option, "Unknown configuration option.");
	  break;
	}
    }
  return(size_changed | shape_changed);
}

/*****************************************************************
 *
 *  Print an error message or warning message for invalid
 *  configure options.
 */
void  EZ_ConfigureError(widget,option, message)
     EZ_Widget *widget;
     int             option;
     char            *message;
{
  int  type;
  char *name;
  char *option_name;
  extern int silenceOnConfigError;
  
  if(silenceOnConfigError) return;
  type = EZ_WidgetType(widget);
  name = EZ_WidgetDefaultClassNames[type];
  if(option > 0 && option <= EZ_WIDGET_CONFIGURE_LAST_OPTION)
    option_name = EZ_ConfigureOptionNames[option];
  else
    option_name = (char *)NULL;
  
  (void)fprintf(stderr,"Warning: In function EZ_ConfigureWidget, '%s'.\n\t Widget type is '%s'[%d], configure option is '%s'[%d]\n",
		message,name, type, option_name, option);
}
/***************************************************************************
 * 
 *   Set the background bitmap/pixmap if applicable.
 */

int  EZ_SetWidgetPixmap(widget,bitmap,option)
     EZ_Widget *widget;
     EZ_Bitmap       *bitmap;
     int             option;  /* EZ_bitmap or EZ_image */
{
  EZ_Widget *twidget;
  EZ_Bitmap *oldbmp;      
  int shapeChanged = 0;

  switch(EZ_WidgetType(widget))
    {
    case EZ_WIDGET_NB_PAGE:
      twidget = EZ_NBPageCompanion(widget);
     break;
    case EZ_WIDGET_TEXT:
      twidget = EZ_TextIText(widget);
      break;
    case EZ_WIDGET_LIST_BOX:
      twidget = EZ_ListBoxIListBox(widget);
      break;
    case  EZ_WIDGET_TREE:
      twidget = EZ_TreeWITree(widget);
      break;
    case EZ_WIDGET_FANCY_LIST_BOX:
      twidget = EZ_FListBoxIFListBox(widget);
      break;
    case EZ_WIDGET_WORK_AREA:
      twidget = EZ_WorkAreaIWorkArea(widget);
      break;
    default:
      twidget = widget;
      break;
    }
  oldbmp = EZ_WidgetPixmap(twidget);
  if(oldbmp == NULL && bitmap == NULL) return(0);
  EZ_FreeBitmap(oldbmp);
  EZ_WidgetPixmap(twidget) = bitmap;
  /* if widget has a shape mask, update it. */
  if(EZ_GetWidgetShapedWinFlag(twidget))
    {
      /* labeled icon is treated separately */
      if(EZ_WidgetType(twidget) == EZ_WIDGET_ITOPLEVEL)
	{  EZ_LabelMaskDirty(twidget) = 1;}
      if(EZ_WidgetWindow(twidget) != None)
	{
	  if(bitmap && bitmap->shape) shapeChanged = (1<<21); /* set shape */
	  else shapeChanged = (1<<20);  /* remove shape */
	}
    }
  return(1 | shapeChanged);
}
/*********************************************************************************/
void EZ_SetKeyShortcut(widget, str) EZ_Widget *widget; char *str;
{
  if( str != (char *)NULL)
    {
      switch(EZ_WidgetType(widget))
	{
	case EZ_WIDGET_MENU_NORMAL_BUTTON: 
	case EZ_WIDGET_NORMAL_BUTTON:
	  EZ_ButtonLabel2(widget) = EZ_AllocCopyString(str);
	  EZ_ButtonLabel2Length(widget) = strlen(str);
	  EZ_ScanShortcut(widget, EZ_ButtonLabel2(widget),
			  &(EZ_ButtonShortcut(widget)), &(EZ_ButtonModifiers(widget)));
	  break;
	case EZ_WIDGET_MENU_CHECK_BUTTON:
	case EZ_WIDGET_CHECK_BUTTON:
	  EZ_CButtonLabel2(widget) = EZ_AllocCopyString(str);
	  EZ_CButtonLabel2Length(widget) = strlen(str);
	  EZ_ScanShortcut(widget, EZ_CButtonLabel2(widget),
			  &(EZ_CButtonShortcut(widget)), &(EZ_CButtonModifiers(widget)));
	  break;
	case EZ_WIDGET_MENU_RADIO_BUTTON:
	case EZ_WIDGET_RADIO_BUTTON:
	  EZ_RButtonLabel2(widget) = EZ_AllocCopyString(str);
	  EZ_RButtonLabel2Length(widget) = strlen(str);
	  EZ_ScanShortcut(widget, EZ_RButtonLabel2(widget),
			  &(EZ_RButtonShortcut(widget)), &(EZ_RButtonModifiers(widget)));
	  break;
	case EZ_WIDGET_MENU_BUTTON:
	  EZ_MButtonLabel2(widget) = EZ_AllocCopyString(str);
	  EZ_MButtonLabel2Length(widget) = strlen(str);
	  EZ_ScanShortcut(widget, EZ_MButtonLabel2(widget),
			  &(EZ_MButtonShortcut(widget)), &(EZ_MButtonModifiers(widget)));
	  EZ_MButtonUnderLine(widget) = -1;
	  break;		
	case EZ_WIDGET_MENU_SUBMENU:
	  EZ_SubMenuLabel2(widget) = EZ_AllocCopyString(str);
	  EZ_SubMenuLabel2Length(widget) = strlen(str);
	  EZ_ScanShortcut(widget, EZ_SubMenuLabel2(widget),
			  &(EZ_SubMenuShortcut(widget)), &(EZ_SubMenuModifiers(widget)));
	  EZ_SubMenuUnderLine(widget) = -1;
	  break;		
	default:
	  EZ_ConfigureError(widget, EZ_BUTTON_SHORTCUT, "option not applicable"); 
	  break;
	}
    }
  else  /* str = NULL, remove key shortcut for widget */
    EZ_RemoveAllKeyShortcutForWidget(widget);
}
/***********************************************************************************
 *
 *  Given a string, figure out the exact shortcut keystroke.
 *   Accepted combinations are:
 *
 *    Control-letter, ctrl-letter, Meta-letter
 *    C-letter,    M-letter
 * or <anyone of the above>
 *
 * Note: str must not be a tmp string or ...
 */
static void EZ_ScanShortcut(widget,str, shortcut, modifier)
     EZ_Widget *widget;
     char            *str, **shortcut;
     int             *modifier;
{
  char  *tmp = str;
  int   fail = 0;
  int   mode = 0;

  /*---------------------
   * skip spaces or '<'
   *--------------------*/
  while( *tmp != '\0' && (*tmp == ' ' || *tmp == '\t' || *tmp == '<'))  tmp++;
  /*---------------------
   * get the modifier 
   *--------------------*/
  if(*tmp == 'C' || *tmp == 'c' || *tmp == '^')
    mode = ControlMask;
  else  if(*tmp == 'M' || *tmp == 'm')  
    mode =  Mod1Mask;
  else fail = 1;

  if(!fail)
    {
      while( *tmp != '-' && *tmp != '\0')
	tmp++;
      if(*tmp != '\0' && isprint(*(tmp+1)))
	{
	  *modifier = mode;
	  *shortcut = (tmp+1);
	  /*-------------------------------------------------
	   * register it in the global KeyPress Event table
	   *------------------------------------------------*/
	  EZ_InsertGlobalKeyPressEvent(widget, mode, tmp+1);
	}
      else fail = 1;
    }
  if(fail)
    (void)fprintf(stderr,"Invalid keybord shortcut: %s\n",str);
}
/***********************************************************************************/

