/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
/*****************************************************************
 ***                                                           ***
 ***              Special Widget                               ***
 ***                                                           ***
 *****************************************************************/
#define _EZ_WIDGET_SPECIAL_C_
/*
 *  For internal use only.
 */
#include "EZ_Widget.h"

/*********************************************************************
 * 
 *  Functions implemented in this file:
 */
EZ_Widget         *EZ_CreateSpecialWidget MY_ANSIARGS((EZ_Widget *parent, int type));
void              EZ_DrawSpecialWidget MY_ANSIARGS((EZ_Widget *widget));
void              EZ_FreeSpecialWidgetData MY_ANSIARGS((EZ_Widget *widget));
void              EZ_SpecialEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
void              EZ_ComputeSpecialWidgetSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));

/*********************************************************************
 * 
 *  Local Variables.
 */
static EZ_WidgetHandle EZ_SpecialWidgetHandle =
{ 
  EZ_ComputeSpecialWidgetSize,
  EZ_DrawSpecialWidget,
  EZ_FreeSpecialWidgetData,
  EZ_SpecialEventHandle,
};

/*********************************************************************/

EZ_Widget  *EZ_CreateSpecialWidget(parent, type)
     EZ_Widget  *parent;     /* parent widget  */
     int type;               /* type  */
{
  EZ_Widget  *tmp;

  tmp = EZ_CreateNewWidget(parent);
  /*--------------------------------------------------
   * Register the handling functions for Frame.
   *  has to be done after  EZ_CreateNewWiget.
   *-------------------------------------------------*/
  EZ_WidgetHandlingFunctions[EZ_WIDGET_SPECIAL] = &EZ_SpecialWidgetHandle;

  EZ_SetWidgetTypeAndNames(tmp,EZ_WIDGET_SPECIAL);
  EZ_WidgetBorderWidth(tmp) = 0;
  EZ_WidgetBorderStyle(tmp)  = EZ_BORDER_NONE;;
  EZ_WidgetPadX(tmp) = 0;
  EZ_WidgetPadY(tmp) = 0;
  EZ_SpecialWidgetC1(tmp)  = (char )type;
  EZ_SpecialWidgetC2(tmp) = 0;
  EZ_SpecialWidgetEventHandle(tmp) = NULL;
  EZ_SpecialWidgetRedrawFunc(tmp) = NULL;
  EZ_SpecialWidgetFreeFunc(tmp)   = NULL;

  {
    int i;
    for(i = 0; i < SPECIAL_WIDGET_PRIVATE_DATA_SIZE; i++)
      {
	EZ_SpecialWidgetCI(tmp, i) = 0;
	EZ_SpecialWidgetII(tmp, i) = 0;
	EZ_SpecialWidgetPI(tmp, i) = NULL;	
      }
  }
  EZ_SetWidgetFocusableFlag(tmp);  
  return(tmp);
}

void  EZ_FreeSpecialWidgetData(widget)
     EZ_Widget *widget;
{
  if(EZ_SpecialWidgetFreeFunc(widget))
    (EZ_SpecialWidgetFreeFunc(widget))(widget);
}
/*******************************************************************
 *
 * Compute Frame size.
 */
void  EZ_ComputeSpecialWidgetSize(widget, w,h)
     EZ_Widget *widget;
     int             *w, *h;
{
  int cw, ch, bw, ww, hh;

  if(!(EZ_GetWidgetSizeComputedFlag(widget)))
    {
      EZ_SetWidgetSizeComputedFlag(widget);
    }
  /* for special buttons */
  switch(EZ_SpecialWidgetC1(widget))
    {
    case   EZ_UP_TRIANGLE:   
    case   EZ_DOWN_TRIANGLE: 
      ww = 6; hh = 8;
      break;
    case   EZ_LEFT_TRIANGLE: 
    case   EZ_RIGHT_TRIANGLE:
      ww = 8; hh = 6;
      break;
    case   EZ_UP_ARROW:      
    case   EZ_DOWN_ARROW: 
      ww = 8; hh = 12;
      break;
    case   EZ_LEFT_ARROW:    
    case   EZ_RIGHT_ARROW:   
      ww = 15; hh = 12;
      break;
    case   EZ_UP_ARROW_BAR:
    case   EZ_DOWN_ARROW_BAR:
      ww = 10; hh = 12;
      break;
    case   EZ_DOWN_TRIANGLE_BAR:
      ww = 10; hh = 10;
      break;
    default:
      ww = hh = 0;
    }
  bw = EZ_WidgetBorderWidth(widget);
  cw = bw + EZ_WidgetPadX(widget);
  ch = bw + EZ_WidgetPadY(widget);
  *w =  cw + cw + ww;
  *h =  ch + ch + hh;
}
/*******************************************************************
 *
 *  Draw A Frame Widget. 
 */
void  EZ_DrawSpecialWidget(wptr)
     EZ_Widget *wptr;
{
  if(wptr && EZ_SpecialWidgetRedrawFunc(wptr))
    (EZ_SpecialWidgetRedrawFunc(wptr))(wptr);
}
/*******************************************************************
 *
 *  Event handle
 */

void EZ_SpecialEventHandle(widget, event)
     EZ_Widget *widget;
     XEvent *event;
{
  if(widget && EZ_SpecialWidgetEventHandle(widget) &&
     EZ_LookupWidgetFromAllHT(widget) && EZ_WidgetMapped(widget) !=0)
    {
      EZ_SpecialWidgetEventHandle(widget)(widget, event);
    }
}

/*******************************************************************/
#undef _EZ_WIDGET_SPECIAL_C_
