/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef MAPDITHER_H
#define MAPDITHER_H	1

#include "earthmisc.h"
#include "mapscan.h"

typedef struct		s_map_dither_output
{
  u_char		*level;
  u_short		grn_idx[256];
  u_short		blu_idx[256];
  t_s32			*curr;
  t_s32			*next;
  int			even_row;
  int			dither_ncolors;
  u_char		*dither_colormap;
} t_map_dither_output;

/* PROTO mapdither.c */
/* mapdither.c */
void dither_setup P((t_map_scan_input *msi, t_map_dither_output *mdo, int ncolors));
void dither_row P((t_map_scan_input *msi, t_map_dither_output *mdo, u_char *row, t_u32 *rslt));
void mdo_cleanup P((t_map_dither_output *mdo));
void dither_row_ltor P((t_map_scan_input *msi, t_map_dither_output *mdo, u_char *row, t_u32 *rslt));
void dither_row_rtol P((t_map_scan_input *msi, t_map_dither_output *mdo, u_char *row, t_u32 *rslt));
void mono_dither_setup P((t_map_scan_input *msi, t_map_dither_output *mdo));
void mono_dither_row P((t_map_scan_input *msi, t_map_dither_output *mdo, u_char *row, t_u32 *rslt));
void mono_dither_cleanup P((t_map_dither_output *mdo));
void mono_dither_row_ltor P((t_map_scan_input *msi, t_map_dither_output *mdo, t_u32 *row));
void mono_dither_row_rtol P((t_map_scan_input *msi, t_map_dither_output *mdo, t_u32 *row));
#endif
