/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef MAPRENDER_H
#define MAPRENDER_H	1

#include "earthmisc.h"
#include "mapscan.h"

typedef struct		s_map_render_input
{
  int			do_shade;
  double		sun_lon;
  double		sun_lat;
  int			do_stars;
  double		star_freq;
  int			big_stars;
  int			do_grid;
  int			grid_big;
  int			grid_small;
  int			day;
  int			night;
  int			terminator;
} t_map_render_input;

typedef struct		s_map_render_output
{
  int			scanbitcnt;
  ScanBit		*scanbit;
  t_s32			scan_to_pix[256];
  int			night_val;
  int			day_val_base;
  double		day_val_delta;
  int			dotcnt;
  ScanDot		*dot;
  t_arr			*dots;
} t_map_render_output;

typedef void		(*t_row_proc) P((u_char *row,int idx,void *data));

/* PROTO maprender.c */
/* maprender.c */
int dot_comp P((const void *a, const void *b));
void render_rows_setup P((t_map_scan_output *mso, t_map_render_input *mri, t_map_render_output *mro));
void render_next_row P((t_map_scan_input *msi, t_map_render_output *mro, t_s32 *buf, int idx));
void no_shade_row P((t_map_scan_input *msi, t_s32 *scanbuf, u_char *rslt));
void compute_sun_vector P((t_map_scan_output *mso, t_map_render_input *mri, double *rslt));
void orth_compute_inv_x P((t_map_scan_input *msi, t_map_scan_output *mso, double *inv_x));
void orth_shade_row P((t_map_scan_input *msi, t_map_scan_output *mso, t_map_render_output *mro, int idx, t_s32 *scanbuf, double *sol, double *inv_x, u_char *rslt));
void merc_shade_row P((t_map_scan_input *msi, t_map_scan_output *mso, t_map_render_output *mro, int idx, t_s32 *scanbuf, double *sol, u_char *rslt));
void render P((t_map_scan_input *msi, t_map_scan_output *mso, t_map_render_input *mri, t_map_render_output *mro, t_row_proc rowfunc, void *data));
void do_dots P((t_map_scan_input *msi, t_map_scan_output *mso, t_map_render_input *mri, t_map_render_output *mro));
void mro_alloc P((t_map_render_output *mro));
void mro_reset P((t_map_render_output *mro));
void mro_cleanup P((t_map_render_output *mro));
void new_stars P((t_map_scan_input *msi, t_map_render_input *mri, t_map_render_output *mro, double freq));
void new_grid P((t_map_scan_input *msi, t_map_scan_output *mso, t_map_render_input *mri, t_map_render_output *mro, int big, int small));
void new_grid_dot P((t_map_scan_input *msi, t_map_scan_output *mso, t_map_render_input *mri, t_map_render_output *mro, double *cs_lat, double *cs_lon));
#endif
