/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef XEARTH_I_H
#define XEARTH_I_H	1

#include "a.h"

#ifdef DEBUG_MALLOC
# include "gdm.h"
# define XEARTH_ALLOC_ALGORITHM		gdm_alloc_algorithm
# define XEARTH_ALLOC_PROC		gdm_alloc
# define XEARTH_FREE_PROC		gdm_free
# define XEARTH_REALLOC_PROC		gdm_realloc
#else
# define XEARTH_ALLOC_ALGORITHM		alloc_algorithm_factor2
# define XEARTH_ALLOC_PROC		alloc_malloc
# define XEARTH_FREE_PROC		free_free
# define XEARTH_REALLOC_PROC		realloc_realloc
#endif

#define XEARTH_ARR_NEW(EltSize,Comment,StatusPtr)	arr_new((EltSize),\
							ARR_BASE,\
							FALSE,\
						       XEARTH_ALLOC_ALGORITHM,\
							XEARTH_ALLOC_PROC,\
							XEARTH_REALLOC_PROC,\
							XEARTH_FREE_PROC,\
							    (Comment),\
							(StatusPtr))

#ifdef DEBUG
extern t_mask			xearth_verb_level;

#define VERB_MAPSCAN		(1L<<0)
#define VERB_MAPRENDER		(1L<<1)
#define VERB_MAPDITHER		(1L<<2)
#define VERB_WIDGET		(1L<<3)

# define XEARTH_VERB(level)	((xearth_verb_level != 0L)?\
				 (level) & xearth_verb_level:FALSE) 

#endif

/* PROTO xearth_i.c */
/* xearth_i.c */
void xearth_debug_init P((void));
#endif
