/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

#ifndef NBBY
# define NBBY	8
#endif 

#define BITFIELDGET(proc,type) \
type		*proc(valp,from,to)\
type		*valp;\
int		from;\
int		to;\
{\
  static type	staticval;\
\
  staticval = *valp;\
  staticval <<= from;\
  staticval >>= from;\
  staticval >>= (((sizeof (type) * NBBY) - 1) - to);\
  return (&staticval);\
}

#define BITFIELDSET(proc,type) \
VOID_FUNC	proc(valp,from,to,value)\
type		*valp;\
int		from;\
int		to;\
int		value;\
{\
  type		val;\
  int		nbits;\
  type		mask;\
\
  nbits = to - from;\
  val = *valp;\
  mask = ~0;\
  value <<= (((sizeof (type) * NBBY) - 1) - nbits);\
  mask <<= (((sizeof (type) * NBBY) - 1) - nbits);\
  value >>= (((sizeof (type) * NBBY) - 1) - nbits);\
  mask >>= (((sizeof (type) * NBBY) - 1) - nbits);\
  value <<= (((sizeof (type) * NBBY) - 1) - to);\
  mask <<= (((sizeof (type) * NBBY) - 1) - to);\
  mask = ~mask;\
  val &= mask;\
  val |= value;\
  *valp = val;\
}

#define BITPRINT(proc,type) \
VOID_FUNC	proc(valp)\
type		*valp;\
{\
  int		i;\
\
  i = 0;\
  while (i < (sizeof (type) * NBBY))\
    {\
      if (BIT_ISSET(*valp,((sizeof (type) * NBBY) - 1) - i))\
	fprintf(stderr,"1");\
      else\
	fprintf(stderr,"0");\
      i++;\
    }\
  fprintf(stderr,"\n");\
}

BITFIELDGET(bit_field_u8_get,t_u8)
BITFIELDGET(bit_field_u16_get,t_u16)
BITFIELDGET(bit_field_u32_get,t_u32)

BITFIELDSET(bit_field_u8_set,t_u8)
BITFIELDSET(bit_field_u16_set,t_u16)
BITFIELDSET(bit_field_u32_set,t_u32)

#ifdef DEBUG
BITPRINT(bit_print_u8,t_u8)
BITPRINT(bit_print_u16,t_u16)
BITPRINT(bit_print_u32,t_u32)
#endif
