/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

char		*err_list[] = 
{
  "OK",							/* 0	*/
  "Undefined error",					/* 1	*/
  "Entry already exists",				/* 2	*/
  "Not aligned",					/* 3	*/
  "No memory",						/* 4	*/
  "No entry",						/* 5	*/
  "Buffer overflow",					/* 6	*/
  "Bad format",						/* 7	*/
  "Read error",						/* 8	*/
  "Invalid argument",					/* 9	*/
  "Not dynamical",					/* 10	*/
  "Syntax error",					/* 11	*/
  "Mismatched parentheses",				/* 12	*/
  "Not yet implemented",				/* 13	*/
  "Bad match",						/* 14	*/
  "Brace error",					/* 15	*/
  "Not a digit",					/* 16	*/
  "Trailing backslash",					/* 17	*/
  "Not a function",					/* 18	*/
  "Truncated",						/* 19	*/
  "No method",						/* 20	*/
  "Malformed",						/* 21	*/
  "Unresolvable",					/* 22	*/
  "Too many arguments",					/* 23	*/
  "Need more arguments",				/* 24	*/
  "Can't go on",					/* 25	*/
  "Can't open it",					/* 26	*/
  "Syscall has failed",					/* 27	*/
  "Write error",					/* 28	*/
  "Bad arguments",					/* 29	*/
  "Need equal",						/* 30	*/
  "Need more data",					/* 31	*/
  "No such variable",					/* 32	*/
  "Too much data",					/* 33	*/
  "Bad argument type",					/* 34	*/
  "No such field",					/* 35	*/
  "No such key",					/* 36	*/
  "Parse error",					/* 37	*/
  "Division by zero",					/* 38	*/
  "No match",						/* 39	*/
  "Bad backslash sequence",				/* 40	*/
  "Bad vector",						/* 41	*/
  "In use",						/* 42	*/
  "Error occured in a subroutine",			/* 43	*/
  "Buffer has a zero length",				/* 44	*/
  "Operation may lead to unpredictable results",	/* 45	*/
  "Bad length",						/* 46	*/
  "Bad element",					/* 47	*/
  "Bad id",						/* 48	*/
  "Empty container",					/* 49	*/
  "Bad event",						/* 50	*/
  "Too big",						/* 51	*/
  "Bad class",						/* 52	*/
  "There is a hole",					/* 53	*/
  "Bad count",						/* 54	*/
  "Not initialized",					/* 55	*/
  "Not found",						/* 56	*/
  "Missing variable",					/* 57	*/
  "Break",						/* 58	*/
  "Element is a root",					/* 59	*/
  "Parent is child",					/* 60	*/
  "Objects are identical",				/* 61	*/
  "No such property",					/* 62	*/
  "No property",					/* 63	*/
  "Not enought room",					/* 64	*/
  "Bad slot",						/* 65	*/
  "No choice",						/* 66	*/
  "Can't reply",					/* 67	*/
  "Bad header",						/* 68	*/
};

char		*err_msg(errcode)
t_status	errcode;
{
  assert(errcode >= 0);
  if (ERR_SYS(errcode))
    errcode -= ERR_MAGICSYS;
  assert(errcode < ARRAY_COUNT(err_list));
  return (err_list[errcode]);
}

#ifdef HAVE_STDARG_H
VOID_FUNC	err_print(int errcode,char *fmt,...)
#else
VOID_FUNC	err_print(errcode,fmt,va_alist)
t_status	errcode;
char		*fmt;
va_dcl
#endif
{
  va_list	ap;
  char		buf[BUFSIZ];
  
  assert(errcode >= 0);
  assert(fmt);
#ifdef HAVE_STDARG_H
  va_start(ap,fmt);
#else
  va_start(ap);
  va_arg(ap,int);
  va_arg(ap,char *);
#endif
  vsnprintf(buf,sizeof (buf),fmt,ap);
  fprintf(stderr,"%s: %s",buf,err_msg(errcode));
  if (ERR_SYS(errcode))
    fprintf(stderr,": %s\n",strerror(errno));
  else
    fprintf(stderr,"\n");
  va_end(ap);
}
