/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * 
 */

#include "a.h"

t_status		vec_alloc(vec,n)
t_vec			*vec;
int			n;
{
  t_status		status;
  size_t		real_size;
  VOID_PTR		ptr;
  
  if (n < vec->base)
    n = vec->base;
  if ((status = vec->alloc_algorithm_proc(vec->allocated * sizeof (VOID_PTR),
					  n * sizeof (VOID_PTR),
					  &real_size)) < 0)
    return (status);
  if (vec->elts == NULL)
    {
      if ((ptr = vec->alloc_proc(real_size,
				 vec->comment,
				 "vec_alloc:elts",
				 &status)) == NULL)
	return (status);
    }
  else
    {
      if ((ptr = vec->realloc_proc(vec->elts,
				   real_size,
				   vec->comment,
				   "vec_alloc:elts",
				   &status)) == NULL)
	return (status);
    }
  vec->elts = ptr;
  vec->allocated = real_size / sizeof (VOID_PTR);
  return (0);
}

t_vec			*vec_new(base,
				 now,
				 alloc_algorithm_proc,
				 alloc_proc,
				 realloc_proc,
				 free_proc,
				 comment,
				 status)
int			base;
t_boolean		now;
t_alloc_algorithm_proc	alloc_algorithm_proc;
t_alloc_proc		alloc_proc;
t_realloc_proc		realloc_proc;
t_free_proc		free_proc;
char			*comment;
t_status		*status;
{
  t_vec			*vec;

  if ((vec = alloc_proc(sizeof (t_vec),
			comment,
			"vec_new:vec",
			status)) == NULL)
    return (NULL);
  vec->base = base;
  vec->elts = NULL;
  vec->count = 0;
  vec->allocated = 0;
  vec->alloc_algorithm_proc = alloc_algorithm_proc;
  vec->alloc_proc = alloc_proc; 
  vec->realloc_proc = realloc_proc;
  vec->free_proc = free_proc;
  vec->comment = comment;
  if (now)
    if (((*status) = vec_alloc(vec,base)) < 0)
      {
	vec->free_proc(vec,
		       comment,
		       "vec_new:vec");
	return (NULL);
      }
  return (vec);
}

VOID_FUNC		vec_destroy(vec)
t_vec			*vec;
{
  if (vec->elts)
    vec->free_proc(vec->elts,
		   vec->comment,
		   "*:elts");
  vec->elts = NULL;
  vec->count = 0;
  vec->allocated = 0;
}

VOID_FUNC		vec_delete(vec)
t_vec			*vec;
{
  vec_destroy(vec);
  vec->free_proc(vec,
		 vec->comment,
		 "*:vec");
}

int			vec_add(vec,elt)
t_vec			*vec;
VOID_PTR		elt;
{
  t_status		status;

  if (vec->allocated < (vec->count + 1))
    if ((status = vec_alloc(vec,vec->count + 1)) < 0)
      return (status);
  vec->elts[vec->count] = elt;
  return (vec->count++);
}

VOID_FUNC		vec_rm(vec,idx)
t_vec			*vec;
int			idx;
{
  bcopy((char *)(vec->elts + idx + 1),
	(char *)(vec->elts + idx),
	(vec->count - idx - 1) * sizeof (VOID_PTR));
  vec->count--;
}

int			vec_index(vec,elt)
t_vec			*vec;
VOID_PTR		elt;
{
  int			idx;
  
  idx = 0;
  while (idx < vec->count)
    {
      if (vec->elts[idx] == elt)
	return (idx);
      idx++;
    }
  return (-ERR_NOENT);
}

VOID_FUNC		vec_reverse(vec)
t_vec			*vec;
{
  VEC_FOR(vec,VOID_PTR elt)
    {
      VOID_PTR		tmp;

      if (VEC_IDX >= (VEC_COUNT(vec) - VEC_IDX - 1))
	break ;
      tmp = VEC_AT(vec,VEC_IDX);
      VEC_AT(vec,VEC_IDX) = VEC_AT(vec,VEC_COUNT(vec) - VEC_IDX - 1);
      VEC_AT(vec,VEC_COUNT(vec) - VEC_IDX - 1) = tmp;
    }
  VEC_ENDFOR;
}

#ifdef HAVE_QSORT
VOID_FUNC		vec_sort(vec,cmp)
t_vec			*vec;
t_vec_cmp_proc		cmp;
{
  qsort(vec->elts,vec->count,sizeof (VOID_PTR),cmp);
}
#endif

#ifdef DEBUG
VOID_FUNC		vec_show(vec)
t_vec			*vec;
{
  fprintf(stderr,"base=%d\n",vec->base);
  fprintf(stderr,"count=%d\n",vec->count);
  fprintf(stderr,"allocated=%d\n",vec->allocated);
  fprintf(stderr,"elts=%p\n",vec->elts);
}
#endif
