/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

int		vec_buf_add(vec,buf,len)
t_vec		*vec;
char		*buf;
int		len;
{
  t_buf		*b;
  t_status	status;

  if ((b = vec->alloc_proc(sizeof (t_buf),
			   vec->comment,
			   "vec_buf_add:b",
			   &status)) == NULL)
    return (status);
  if ((b->buf = vec->alloc_proc(len,
				vec->comment,
				"vec_buf_add:buf",
				&status)) == NULL)
    {
      vec->free_proc(b,
		     vec->comment,
		     "vec_buf_add:b");
      return (status);
    }
  bcopy(buf,b->buf,len);
  b->len = len;
  if ((status = vec_add(vec,b)) < 0)
    {
      vec->free_proc(b->buf,
		     vec->comment,
		     "vec_buf_add:buf");
      vec->free_proc(b,
		     vec->comment,
		     "vec_buf_add:b");
      return (status);
    }
  return (0);
}

char		*vec_buf_str(vec,status)
t_vec		*vec;
t_status	*status;	
{
  int		total_len;
  size_t	size;
  char		*str;
  int		offset;

  total_len = 0;
  VEC_FOR(vec,t_buf *b)
    {
      total_len += b->len;
    }
  VEC_ENDFOR;
  size = (total_len + 1) * sizeof (char);
  if ((str = vec->alloc_proc(size,
			     vec->comment,
			     "vec_buf_str:str",
			     status)) == NULL)
    return (NULL);
  offset = 0;
  VEC_FOR(vec,t_buf *b)
    {
      bcopy(b->buf,str + offset,b->len);
      offset += b->len;
    }
  VEC_ENDFOR;
  str[offset] = 0;
  return (str);
}

VOID_FUNC	vec_buf_destroy(vec)
t_vec		*vec;
{
  VEC_FOR(vec,t_buf *b)
    {
      vec->free_proc(b->buf,
		     vec->comment,
		     "*:buf");
      vec->free_proc(b,
		     vec->comment,
		     "*:b");
    }
  VEC_ENDFOR;
  vec_destroy(vec);
}

VOID_FUNC	vec_buf_delete(vec)
t_vec		*vec;
{
  vec_buf_destroy(vec);
  vec_delete(vec);
}	

#ifdef DEBUG
VOID_FUNC	vec_buf_show(vec)
t_vec		*vec;
{
  VEC_FOR(vec,t_buf *b)
    {
      printf("%p %d\n",b->buf,b->len);
      write(2,b->buf,b->len);
    }
  VEC_ENDFOR;
}
#endif
