/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "gdm.h"
#include "a_dm.h"

t_boolean		global_debug_malloc = FALSE;

t_dm			gdm;

t_status		gdm_alloc_algorithm(old_size,
					    request_size,
					    new_size)
size_t			old_size;
size_t			request_size;
size_t			*new_size;
{
  return (alloc_algorithm_factor2(old_size,request_size,new_size));
}

VOID_FUNC		gdm_init(VOID_DECL)
{
  t_status		status;
  
  if ((gdm.id = id_new(HASH_BASE,
		       VEC_BASE,
		       alloc_algorithm_factor2,
		       alloc_malloc,
		       realloc_realloc,
		       free_free,
		       "gdm",
		       &status)) == NULL)
    {
      err_print(-status,"ID_NEW");
      exit(1);
    }
  dm_init(&gdm);
}

VOID_PTR		gdm_alloc(size,comment1,comment2,status)
size_t			size;
char			*comment1;
char			*comment2;
t_status		*status;
{
  if (global_debug_malloc)
    return (dm_malloc(&gdm,size,comment1,comment2,status));
  else
    return (alloc_malloc(size,comment1,comment2,status));
}

VOID_PTR		gdm_realloc(old_ptr,
				    size,
				    comment1,
				    comment2,
				    status)
VOID_PTR		old_ptr;
size_t			size;
char			*comment1;
char			*comment2;
t_status		*status;
{
  if (global_debug_malloc)
    return (dm_realloc(&gdm,old_ptr,size,comment1,comment2,status));
  else
    return (realloc_realloc(old_ptr,size,comment1,comment2,status));
}

VOID_FUNC		gdm_free(ptr,comment1,comment2)
VOID_PTR		ptr;
char			*comment1;
char			*comment2;
{
  if (global_debug_malloc)
    dm_free(&gdm,ptr,comment1,comment2);
  else
    free_free(ptr,comment1,comment2);
}

VOID_FUNC		gdm_unmark(ptr,comment1,comment2)
VOID_PTR		ptr;
char			*comment1;
char			*comment2;
{
  if (global_debug_malloc)
    dm_unmark(&gdm,ptr,comment1,comment2);
}

VOID_FUNC		gdm_status(VOID_DECL)
{
  dm_show(&gdm);
}
