/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef GDM_H
#define GDM_H	1

#include "a_dm.h"

extern t_boolean	global_debug_malloc;
extern t_dm		gdm;

/* PROTO gdm.c */
/* gdm.c */
t_status gdm_alloc_algorithm P((size_t old_size, size_t request_size, size_t *new_size));
void gdm_init P((void));
void *gdm_alloc P((size_t size, char *comment1, char *comment2, t_status *status));
void *gdm_realloc P((void *old_ptr, size_t size, char *comment1, char *comment2, t_status *status));
void gdm_free P((void *ptr, char *comment1, char *comment2));
void gdm_unmark P((void *ptr, char *comment1, char *comment2));
void gdm_status P((void));
#endif
