." $Id: Ruler.man,v 1.4 1999/09/01 15:56:02 falk Exp $
." view with "tbl | nroff -man"
."
.TH "Ruler" 3 "Aug 1999" "Version 1.0" ""
.SH NAME
Ruler
.SH DESCRIPTION
The Ruler widget displays a ruler with numeric labels and tic marks.
It is intended to be displayed alongside the edge of any kind of
graphics window, such as in a CAD application.
.P
A pointer may also be displayed inside the ruler, used to indicate
any value.  This is typically used to show the numeric value of the
cursor position within the drawing window.
.P
Finally, the ruler may be grabbed with the mouse and used as a scrollbar.

.SH CLASS
Core => Ruler

Ruler does not require any specific widget set, and may be combined with
any other widget set.

.SH RESOURCES

.ps -2
.TS
center box;
cBsss
lBlBlBlB
- - - -
l|l|l|l.
Ruler
Name	Class	Type	Default
markStep	Step	int	1
markDiv	Divisions	int	32
labelStep	Step	int	1
labelDiv	Divisions	int	32
labelStyle	LabelStyle	XtLabelStyle	Fraction
orientation	Orientation	int	North
foreground	Foreground	Pixel	XtDefaultForeground
pointerColor	Foreground	Pixel	XtDefaultForeground
minValue	MinValue	float	0.0
scale	Scale	float	100.0
value	Value	float	0.0
iValue	IValue	int	0
showPointer	ShowPointer	Boolean	False
font	Font	XFontStruct*	XtDefaultFont
fracFont	Font	XFontStruct*	font
cursor	Cursor	Cursor*
internalWidth	Width	Dimension	4
internalHeight	Height	Dimension	4
callback	Callback	XtCallbackList	NULL
userData	UserData	XtPointer	NULL
.TE
.ps +2

.LP
See the \fBCore\fP widget for more resources.

.SS Descriptions.

.TP
.I markStep
is the number of units along the ruler per major tic mark.  Default value
is 1, meaning draw a tick mark at each unit along the ruler.  If the
ruler scale factor is small enough to cause the tic marks to be
overcrowded; the ruler will be drawn with a larger mark step.
.TP
.I markDiv
is the number of minor tic marks to be drawn between major tic marks.
Default value is 32, meaning divide each major step along the ruler
into 32 equal parts (drawing 31 minor tic marks.)
If a small scale factor would cause overcrowding, the ruler will be
drawn with fewer minor tic marks.
.TP
.I labelStep
is similar to \fImarkStep\fP, except that it controls the drawing
of ruler labels.
.TP
.I labelDiv
is similar to \fImarkDiv\fP, except that it controls the drawing
of ruler labels.
.TP
.I labelStyle
controls the drawing of labels.  Value is either Fraction or Decimal.
.TP
.I orientation
controls the display of the ruler.  Value is one of North, South,
East or West.  North produces horizontal rulers with tic marks at
the bottom, suitable for displaying along the North edge of a
canvas.  South produces horizontal rulers with tic marks at the
top.   West produces vertical rulers with tic marks on the right.
East produces vertical rulers with tic marks on the left.
.TP
.I foreground
is the color for tic marks and labels.
.TP
.I pointerColor
is the color for the index pointer.
.TP
.I minValue
is the ruler value at the left or top of the ruler.
.TP
.I scale
is the scale factor of the ruler, expressed in pixels per
ruler unit.  Scale may be negative.
.TP
.I value
is the value currently indicated by the index pointer.
.TP
.I iValue
is the index pointer position in pixels.
.TP
.I showPointer
controls whether or not the index pointer is displayed.  Initial value
is False (the assumption being that the application will show the pointer
at the same time it sets the pointer value.)
.TP
.I font
font used to draw major labels.
.TP
.I fracFont
font used to draw minor labels.
.TP
.I cursor
is the cursor to display for the ruler.  Default is XC_sb_h_double_arrow or
XC_sb_v_double_arrow, depending on orientation.
.TP
.I InternalWidth, InternalHeight
Specifies the margins around the labels.
.TP
.I callback
is a list of callback procedures to be called as the ruler is
scrolled.  Call_data is a pointer to a RulerReport structure.
.TP
.I userData
is any arbitrary value.  Ignored by ruler widget.

.SH FUNCTIONS

.TP
.B void RulerSetMinScale(Widget, double minval, double scale)
Sets the minimum ruler value and scale factor.  Ruler is redrawn.

.TP
.B void RulerSetMin(Widget, double minval)
Sets the minimum ruler value.  Ruler is redrawn.

.TP
.B void RulerSetMinPosition(Widget, double minval, int position)
Sets the minimum ruler value for a pixel position other than the
left/top edge.

.TP
.B void RulerSetScale(Widget, double scale)
Sets the ruler scale.  Ruler is redrawn.

.TP
.B void RulerSetValue(Widget, double value)
Sets the index pointer position.

.TP
.B void RulerSetIValue(Widget, int position)
Sets the index pointer position.

.TP
.B void RulerShowPointer(Widget, Bool show)
Control index pointer display.

.TP
.B double RulerGetValue(Widget)
Return index pointer value.

.TP
.B int RulerGetIValue(Widget)
Return index pointer position.

.TP
.B double RulerPosition2Value(Widget, int position)
Converts a pixel position to value.  This function is preferred
over computing the value manually, as great care is taken to
eliminate round-off error.

.TP
.B int RulerValue2Position(Widget, double value)
Converts a value to pixel position.  This function is preferred
over computing the value manually, as great care is taken to
eliminate round-off error.

.SH PROGRAMMING NOTES
This widget looks much better when wrapped with a decorative frame.
The Frame widget & documentation is available at ftp.x.org/contrib/widgets.

.SH BUGS
Initial size is set correctly for the numbers which are initially displayed,
but if the user scrolls the ruler until very large numbers are displayed,
it will look pretty bad.
.P
Currently no way to set limit stops on scrolling.
.P
Pointers are not very pretty; they could use improvement.  Perhaps allow
the resources to specify an X pixmap?

.SH AUTHOR
Edward Falk <falk@falconer.vip.best.com>

.SH COPYRIGHT
Copyright  1999 by Edward A. Falk.  This widget may be used freely in any
free software.  Source code is freely distributable provided that my name
is not removed from it.

The X Consortium, and any party obtaining a copy of these files from the X
Consortium, directly or indirectly, is granted, free of charge, a full and
unrestricted irrevocable, world-wide, paid up, royalty-free, nonexclusive
right and license to deal in this software and documentation files (the
"Software"), including without limitation the rights to use, copy, modify,
merge, publish, distribute, sublicense, and sell copies of the Software,
and to permit persons who receive copies from any such party to do so.


