static char rcsid[] = "$Id: Scrollbar2.c,v 1.3 1999/04/30 22:47:59 falk Rel $" ;


/* Scrollbar2.c -- add some functionality to Athena Scrollbar
 *
 * Author: Edward A. Falk
 *	   falk@falconer.vip.best.com
 *
 * Date: 22 April 1999
 *
 * $Log: Scrollbar2.c,v $
 * Revision 1.3  1999/04/30 22:47:59  falk
 * Added copyright notice in preperation for distribution
 *
 * Revision 1.2  1999/04/30 21:27:35  falk
 * Add setArrow() function
 *
 * Revision 1.1  1999/04/24 22:03:35  falk
 * Initial revision
 *
 * Copyright 1999 by Edward A. Falk.  This widget may be used freely in any
 * software.  Source code is freely distributable provided that my name
 * is not removed from it.
 *
 * The X Consortium, and any party obtaining a copy of these files
 * from the X Consortium, directly or indirectly, is granted, free of
 * charge, a full and unrestricted irrevocable, world-wide, paid up,
 * royalty-free, nonexclusive right and license to deal in this
 * software and documentation files (the "Software"), including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and sell copies of the Software, and to
 * permit persons who receive copies from any such party to do so.
 *
 */

#include <ctype.h>
#include <stdlib.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xmu/CharSet.h>

#include "Scrollbar2P.h"


static	float	dfltJump = 0.05 ;

#define Offset(field) XtOffsetOf(Scrollbar2Rec, field)

static XtResource resources[] = {
  {XtNarrowJump, XtCArrowJump, XtRFloat, sizeof(float),
       Offset(scrollbar2.arrowJump), XtRFloat, (XtPointer) &dfltJump},
  {XtNcallback, XtCCallback, XtRCallback, sizeof(XtPointer),
       Offset(scrollbar2.notifyProc), XtRCallback, NULL},
};

#undef Offset


	/* Improved translation table.
	   Note:  wheel mice map wheel clicks to button 4,5 */

#ifdef ARROW_SCROLLBAR
static char defaultTranslations[] =
    "<Btn1Down>:	Notify(start) NotifyScroll()			\n\
     <Btn2Down>:	Notify(start) MoveThumb() NotifyThumb()		\n\
     <Btn3Down>:	Notify(start) NotifyScroll()			\n\
     <Btn4Down>:	Notify(start) NotifyScroll(BackwardArrow)	\n\
     <Btn5Down>:	Notify(start) NotifyScroll(ForwardArrow)	\n\
     <Btn1Motion>:	HandleThumb()					\n\
     <Btn2Motion>:	MoveThumb() NotifyThumb()			\n\
     <Btn3Motion>:	HandleThumb()					\n\
     <BtnUp>:		EndScroll() Notify(done)			\n\
     <Key>Left:		NotifyScroll(BackwardArrow) Notify(jump)	\n\
     <Key>Up:		NotifyScroll(BackwardArrow) Notify(jump)	\n\
     <Key>Right:	NotifyScroll(ForwardArrow) Notify(jump)		\n\
     <Key>Down:		NotifyScroll(ForwardArrow) Notify(jump)		\n\
     <Key>Page_Up:	NotifyScroll(BackwardPage) Notify(jump)		\n\
     <Key>Page_Down:	NotifyScroll(ForwardPage) Notify(jump)		\n\
     <Key>Home:		NotifyScroll(Home) Notify(jump)			\n\
     <Key>End:		NotifyScroll(End) Notify(jump)			\n\
     <Key>KP_Left:	NotifyScroll(BackwardArrow) Notify(jump)	\n\
     <Key>KP_Up:	NotifyScroll(BackwardArrow) Notify(jump)	\n\
     <Key>KP_Right:	NotifyScroll(ForwardArrow) Notify(jump)		\n\
     <Key>KP_Down:	NotifyScroll(ForwardArrow) Notify(jump)		\n\
     <Key>KP_Page_Up:	NotifyScroll(BackwardPage) Notify(jump)		\n\
     <Key>KP_Page_Down:	NotifyScroll(ForwardPage) Notify(jump)		\n\
     <Key>KP_Home:	NotifyScroll(Home) Notify(jump)			\n\
     <Key>KP_End:	NotifyScroll(End) Notify(jump)			";

#else
static char defaultTranslations[] =
  "<Btn1Down>:   Notify(start) StartScroll(Forward) \n\
   <Btn2Down>:   Notify(start) StartScroll(Continuous) MoveThumb() NotifyThumb()\n\
   <Btn3Down>:   Notify(start) StartScroll(Backward) \n\
   <Btn2Motion>: MoveThumb() NotifyThumb() \n\
   <BtnUp>:      NotifyScroll(Proportional) EndScroll() Notify(done)";
#endif

static	void	Notify() ;

static XtActionsRec actions[] = {
    {"Notify",		Notify},
};


Scrollbar2ClassRec scrollbar2ClassRec = {
  { /* core fields */
    /* superclass       */	(WidgetClass) &scrollbarClassRec,
    /* class_name       */	"Scrollbar2",
    /* size             */	sizeof(Scrollbar2Rec),
    /* class_initialize	*/	NULL,
    /* class_part_init  */	NULL,
    /* class_inited	*/	FALSE,
    /* initialize       */	NULL,
    /* initialize_hook  */	NULL,
    /* realize          */	XtInheritRealize,
    /* actions          */	actions,
    /* num_actions	*/	XtNumber(actions),
    /* resources        */	resources,
    /* num_resources    */	XtNumber(resources),
    /* xrm_class        */	NULLQUARK,
    /* compress_motion	*/	TRUE,
    /* compress_exposure*/	TRUE,
    /* compress_enterleave*/	TRUE,
    /* visible_interest */	FALSE,
    /* destroy          */	NULL,
    /* resize           */	XtInheritResize,
    /* expose           */	XtInheritExpose,
    /* set_values       */	NULL,
    /* set_values_hook  */	NULL,
    /* set_values_almost */	XtInheritSetValuesAlmost,
    /* get_values_hook  */	NULL,
    /* accept_focus     */	NULL,
    /* version          */	XtVersion,
    /* callback_private */	NULL,
    /* tm_table         */	defaultTranslations,
    /* query_geometry	*/	XtInheritQueryGeometry,
    /* display_accelerator*/	XtInheritDisplayAccelerator,
    /* extension        */	NULL
  },
  { /* simple fields */
    /* change_sensitive	*/	XtInheritChangeSensitive
  },
#ifdef	_ThreeDP_h
  { /* threeD fields */
    /* shadowdraw	*/	XtInheritXaw3dShadowDraw /*,*/
    /* shadowboxdraw	*/	/*XtInheritXaw3dShadowBoxDraw*/
  },
#endif
  { /* scrollbar fields */
    /* ignore		*/	0
  },
  { /* scrollbar2 fields */
    /* not used		*/	NULL
  }
};

WidgetClass scrollbar2WidgetClass = (WidgetClass)&scrollbar2ClassRec;



	/* application wants to know what's going on */

static	void
Notify (w, event, params, num_params )
    Widget w;
    XEvent *event;
    String *params;		/* direction: Back|Forward|Smooth */
    Cardinal *num_params;	/* we only support 1 */
{
    Scrollbar2Widget sbw = (Scrollbar2Widget) w;
    Scrollbar2Rep report ;

    if (*num_params <= 0) 
      return ;

    XFlush(XtDisplay(w)) ;

    if( XmuCompareISOLatin1(*params,"start") == 0 )
      report.what = SC_START ;
    if( XmuCompareISOLatin1(*params,"done") == 0 )
      report.what = SC_DONE ;
    if( XmuCompareISOLatin1(*params,"jump") == 0 )
      report.what = SC_JUMP ;
    report.top = sbw->scrollbar.top ;

    /* try to eliminate roundoff error.  See Athena Scrollbar.c for
     * full explanation.
     */
    if( report.top > 0.9 )
      report.top += .0001 ;

    report.shown = sbw->scrollbar.shown ;
    XtCallCallbackList (w, sbw->scrollbar2.notifyProc, (XtPointer)&report);
}




#if NeedFunctionPrototypes
void
Scrollbar2Callback(Widget w, XtPointer client, XtPointer call_data)
#else
void
Scrollbar2Callback(w, client, call_data)
    Widget	w ;
    XtPointer	client, call_data ;
#endif
{
    Scrollbar2Widget sbw ;
    int		len ;
    float	top ;

    if( !XtIsSubclass(w, scrollbar2WidgetClass) )
      return ;

    sbw = (Scrollbar2Widget) w ;
    len = (int)call_data ;
    top = sbw->scrollbar.top ;

    if( len == sbw->scrollbar.length ) {
      /* forward one page */
      top += sbw->scrollbar.shown ;
    }

    else if( len == -(sbw->scrollbar.length) ) {
      /* back one page */
      if( (top -= sbw->scrollbar.shown) < 0. )
	top = 0. ;
    }

    else if( len > 0 ) {
      /* forward one arrow */
      top += sbw->scrollbar2.arrowJump ;
    }

    else if( len < 0 ) {
      /* back one arrow */
      if( (top -= sbw->scrollbar2.arrowJump) < 0. )
	top = 0. ;
    }

    XawScrollbarSetThumb(w, top, -1) ;
    if( top > 0.9 )
      top += .0001;
    XtCallCallbackList (w, sbw->scrollbar.jumpProc, (XtPointer)&top);
}

#if NeedFunctionPrototypes
void
Scrollbar2SetArrow( Widget w, double arrowJump)
#else
void
Scrollbar2SetArrow( w, arrowJump)
    Widget w ;
    double arrowJump ;
#endif
{
    Scrollbar2Widget sbw = (Scrollbar2Widget)w ;

    if( !XtIsSubclass(w, scrollbar2WidgetClass) )
      return ;

    sbw->scrollbar2.arrowJump = arrowJump ;
}
