." $Id: Scrollbar2.man,v 1.3 1999/04/30 22:42:20 falk Rel $
." view with "tbl | nroff -man"
."
.TH "Scrollbar2" 3 "April 1999" "Version 1.0" ""
.SH NAME
Scrollbar2 - Scrollbar widget with improved callbacks.
.SH DESCRIPTION
The Scrollbar2 widget is subclassed from the Athena (or Athena-3d)
Scrollbar widget and adds functionality to make it more useful:

.HP
.B ArrowJump
resource which indicates how far to move the scrollbar for arrow key presses
or clicks in the arrow buttons.  (Athena-3d default was to move 1/20th of
the scrollbar length which was an arbitrary amount.)

.HP
.B Callback
callback list which notifies the application when a scroll action begins or
ends.  The callback procedures are called with
.B call_data
set to a pointer
to a
.B Scrollbar2Rep
structure which indicates the type of interaction
which has taken place, and the new location of the scroll thumb.

.HP
New translation table which allows arrow keys and page-up/page-down keys
to act on the scrollbar.  Also makes use of new
.B Notify()
action, which calls the
.B callback
list.

.HP
.B Scrollbar2Callback()
utility function which may be added to the
.B XtNscrollProc
callback list.  This function adjusts the scrollbar thumb in response to
clicks in the scrollbar background or arrow clicks.  The
.B XtNjumpProc
callback list is also called with the new thumb position.


.SH CLASS
Core => Scrollbar => Scrollbar2

Scrollbar2 requires Athena or Athena-3d widget set.  It may work with
other Athena clones, but this has not been tested.

.SH RESOURCES

.ps -2
.TS
center box;
cBsss
lB|lB|lB|lB
l|l|l|l.
Scrollbar2
Name	Class	Type	Default
=
arrowJump	ArrowJump	float	.05
callback	Callback	Callback	NULL
.TE
.ps +2

.LP
See the \fBCore\fP and \fBScrollbar\fP widgets for more resources.

.SS Descriptions.

.TP
.I ArrowJump
Amount to adjust scrollbar in response to an arrow key or press of an
arrow button.  Range is 0. to 1.  Default is .05.

.TP
.I Callback
Callback list.  Notifies application of changes in Scrollbar position.
Passes pointer to a Scrollbar2Rep structure in call_data:

.DT
.nf
  typedef struct {
      enum scrollWhat {SC_JUMP, SC_START, SC_DONE} what;
      float	  top ;		  /* thumb position, [0. 1.] */
      float	  shown ;	  /* size of thumb [0. 1.] */
  } Scrollbar2Rep ;
.fi

.B What
has the following meanings:

.RS 1.5i
.TP
.B SC_JUMP
Scrollbar has moved as a result of a keypress or mouse wheel motion.
.TP
.B SC_START
Scrollbar has begun scrolling as a result of a mouse press.  Application
need not react until SC_DONE is received.
.TP
.B SC_DONE
User has released mouse button.  Application should now update display
if it has not done so in response to XtNjumpProc callbacks.
.RE


.SH FUNCTIONS

Scrollbar2 contains the following utility functions:

.TP
.B Scrollbar2Callback()
Add this function to the Scrollbar
.B XtNscrollProc
callback list.  This provides for automatic adjustment of the scrollbar
in response to clicks in the endzones and arrow buttons.

.TP
.B Scrollbar2SetArrow()
This function is a convenience function for quickly setting the
.B arrowJump
resource.


.SH AUTHOR
Edward Falk <falk@falconer.vip.best.com>

.SH COPYRIGHT
Copyright 1999 by Edward A. Falk.  This widget may be used freely in any
software.  Source code is freely distributable provided that my name
is not removed from it.
