/*
** MamCoding.c
**	The basic base64 or Quoted Printable encoder and decoder
**	functions.
**
** Copyright 1993-1995 by Markku Savela and
**	Technical Research Centre of Finland
**
**	This is code originally based on 'codes.c' module from the
**	metamail package (by Nathaniel Borenstein), but is *very*
**	heavily modified for the special needs of MAM. The copyright
**	below applied to the original codes.c
*/

/*
  Copyright (c) 1991 Bell Communications Research, Inc. (Bellcore)
  
  Permission to use, copy, modify, and distribute this material 
  for any purpose and without fee is hereby granted, provided 
  that the above copyright notice and this permission notice 
  appear in all copies, and that the name of Bellcore not be 
  used in advertising or publicity pertaining to this 
  material without the specific, prior written permission 
  of an authorized representative of Bellcore.  BELLCORE 
  MAKES NO REPRESENTATIONS ABOUT THE ACCURACY OR SUITABILITY 
  OF THIS MATERIAL FOR ANY PURPOSE.  IT IS PROVIDED "AS IS", 
  WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES.
*/
#include <stdio.h>
#include <ctype.h>
#include <string.h>

static char basis_64[] =
	"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";

static char index_64[256] =
    {
	99,99,99,99, 99,99,99,99, 99,99,99,99, 99,99,99,99,
	99,99,99,99, 99,99,99,99, 99,99,99,99, 99,99,99,99,
	99,99,99,99, 99,99,99,99, 99,99,99,62, 99,99,99,63,
	52,53,54,55, 56,57,58,59, 60,61,99,99, 99,99,99,99,
	99, 0, 1, 2,  3, 4, 5, 6,  7, 8, 9,10, 11,12,13,14,
	15,16,17,18, 19,20,21,22, 23,24,25,99, 99,99,99,99,
	99,26,27,28, 29,30,31,32, 33,34,35,36, 37,38,39,40,
	41,42,43,44, 45,46,47,48, 49,50,51,99, 99,99,99,99,

	99,99,99,99, 99,99,99,99, 99,99,99,99, 99,99,99,99,
	99,99,99,99, 99,99,99,99, 99,99,99,99, 99,99,99,99,
	99,99,99,99, 99,99,99,99, 99,99,99,99, 99,99,99,99,
	99,99,99,99, 99,99,99,99, 99,99,99,99, 99,99,99,99,
	99,99,99,99, 99,99,99,99, 99,99,99,99, 99,99,99,99,
	99,99,99,99, 99,99,99,99, 99,99,99,99, 99,99,99,99,
	99,99,99,99, 99,99,99,99, 99,99,99,99, 99,99,99,99,
	99,99,99,99, 99,99,99,99, 99,99,99,99, 99,99,99,99,
    };

#define char64(c) index_64[(c)]
#define INVALID_char64 99


/*
** Convert from memory into base64 (to output file)
*/
void Mam_to64(unsigned char *s, unsigned char *e, FILE *out)
    {
	int c1, c2, c3, pads, ct=0;

	while (s < e)
	    {
		c1 = *s++;
		if (s < e)
		    {
			c2 = *s++;
			if (s < e)
			    {
				c3 = *s++;
				pads = 0;
			    }
			else
			    {
				c3 = 0;
				pads = 1;
			    }
		    }
		else
		    {
			c2 = c3 = 0;
			pads = 2;
		    }
		putc(basis_64[c1>>2], out);
		putc(basis_64[((c1&0x3)<< 4) | ((c2 & 0xF0) >> 4)], out);
		if (pads == 2)
		    {
			putc('=', out);
			putc('=', out);
		    }
		else if (pads)
		    {
			putc(basis_64[((c2&0xF)<<2) | ((c3&0xC0)>>6)],out);
			putc('=', out);
		    }
		else
		    {
			putc(basis_64[((c2&0xF)<<2) | ((c3&0xC0)>>6)],out);
			putc(basis_64[c3 & 0x3F], out);
		    }
		ct += 4;
		if (ct > 71)
		    {
			putc('\n', out);
			ct = 0;
		    }
	    }
	if (ct)
		putc('\n', out);
    }


/*
** Convert from base64 to binary within memory buffer.
**
** Return the length of binary content (or -1 if error)
*/
int Mam_from64(unsigned char *s, unsigned char *e) 
    {
	unsigned char *p = s;
	unsigned char *r = s;

	int c1, c2, c3, c4;
	
	while (r < e)
	    {
		c1 = *r++;
		if (isspace(c1))
			continue;
		do
		    {
			if (r >= e)
				goto premature_end;
			c2 = *r++;
		    }
		while (isspace(c2));
		do
		    {
			if (r >= e)
				goto premature_end;
			c3 = *r++;
		    }
		while (isspace(c3));
		do
		    {
			if (r >= e)
				goto premature_end;
			c4 = *r++;
		    }
		while (isspace(c4));
		if (c1 == '=' || c2 == '=')
			break;
		if ((c1 = char64(c1)) == INVALID_char64)
			goto invalid_char;
		if ((c2 = char64(c2)) == INVALID_char64)
			goto invalid_char;
		*p++ = (c1<<2) | ((c2&0x30)>>4);
		if (c3 == '=')
			break;
		if ((c3 = char64(c3)) == INVALID_char64)
			goto invalid_char;
		*p++ = ((c2&0XF) << 4) | ((c3&0x3C) >> 2);
		if (c4 == '=')
			break;
		if ((c4 = char64(c4)) == INVALID_char64)
			goto invalid_char;
		*p++ = ((c3&0x03) <<6) | c4;
	    }
	return p - s;
premature_end:
	printf("Premature end of content\n");
	return p - s;
invalid_char:
	printf("Invalid base64 character encountered\n");
	return p - s;
    }

static char basis_hex[] = "0123456789ABCDEF";
static char index_hex[256] =
    {
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	 0, 1, 2, 3,  4, 5, 6, 7,  8, 9,-1,-1, -1,-1,-1,-1,
	-1,10,11,12, 13,14,15,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,10,11,12, 13,14,15,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,

	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
	-1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1, -1,-1,-1,-1,
    };

#define hexchar(c)  index_hex[(c)]

void Mam_toqp(unsigned char *s, unsigned char *e, FILE *out)
    {
	int c, ct=0, prevc=255;
	while (s < e)
	    {
		c = *s++;
		if (c == '\n')
		    {
			if (prevc == ' ' || prevc == '\t')
			    {
				putc('=', out); /* soft & hard lines */
				putc(c, out);
			    }
			putc(c, out);
			ct = 0;
			prevc = c;
		    }
		else if ((c < 32 && c != '\t') || (c =='=') || (c >= 127) ||
			 /*
			 ** ..for sendmail and smtp. Avoid lone "." in line
			 ** and lines beginning with "From ". [This was in 
			 ** original code, is this really needed? --msa]
			 */
			 (ct == 0 &&
			  (c == '.' ||
			   (c == 'F' && e - s > 3 &&
			    strncmp((char *)s,"rom ",4)==0))))
		    {
			putc('=', out);
			putc(basis_hex[c>>4], out);
			putc(basis_hex[c&0xF], out);
			ct += 3;
			prevc = 'A'; /* close enough */
		    }
		else
		    {
			putc(c, out);
			++ct;
			prevc = c;
		    }
		if (ct > 72)
		    {
			putc('=', out);
			putc('\n', out);
			ct = 0;
			prevc = '\n';
		    }
	    }
	if (ct)
	    {
		putc('=', out);
		putc('\n', out);
	    }
    }

int Mam_fromqp(unsigned char *s, unsigned char *e)
    {
	unsigned char *p = s;
	unsigned char *r = s;
	int c;
	
	while (r < e)
	    {
		if ((c = *r++) == '=')
		    {
			if ((c = *r++) == '\n')
				continue;
			c = hexchar(c) << 4;
			c |= hexchar(*r++);
		    }
		*p++ = c;
	    }
	return p - s;
    }
