/*
** Copyright 1992, 1993 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <stdio.h>

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/AudioP.h>
#include "AudioSUN.h"

static char defaultTranslations[] =
"\
<Btn1Down>,<Btn1Up>:	notify()\n\
<Btn1Down>:		toggle-play()\n\
<Btn3Down>:		restart-play()\n\
<EnterWindow>:		enter-window()\n\
<LeaveWindow>:		leave-window()\n\
";

static void TogglePlay();
static void RestartPlay();

static XtActionsRec actions[] =
    {
	{"toggle-play",		TogglePlay},
	{"restart-play",	RestartPlay},
    };

#define offset(field) XtOffsetOf(XeAudioRec, audio.field)

static XtResource resources[] =
    {
	{XtNvolume, XtCVolume, XtRInt, sizeof(int),
		 offset(volume), XtRImmediate, (long)0},
    };
#undef offset

static void ClassPartInitialize(), ClassInitialize();
static void Initialize(), Destroy();
static Boolean SetValues();

#ifdef USING_MOTIF_122
static XmNavigability WidgetNavigable() ;

/*******************************************/
/*  Declaration of class extension records */

XmBaseClassExtRec _XeAudiobaseClassExtRec = {
    NULL,
    NULLQUARK,
    XmBaseClassExtVersion,
    sizeof(XmBaseClassExtRec),
    NULL,				/* InitializePrehook	*/
    NULL,				/* SetValuesPrehook	*/
    NULL,				/* InitializePosthook	*/
    NULL,				/* SetValuesPosthook	*/
    NULL,				/* secondaryObjectClass	*/
    NULL,				/* secondaryCreate	*/
    NULL,		                /* getSecRes data	*/
    { 0 },				/* fastSubclass flags	*/
    NULL,				/* get_values_prehook	*/
    NULL,				/* get_values_posthook	*/
    NULL,                               /* classPartInitPrehook */
    NULL,                               /* classPartInitPosthook*/
    NULL,                               /* ext_resources        */
    NULL,                               /* compiled_ext_resources*/
    0,                                  /* num_ext_resources    */
    FALSE,                              /* use_sub_resources    */
    WidgetNavigable,                    /* widgetNavigable      */
    NULL,                               /* focusChange          */
};
#endif

XeAudioClassRec xeAudioClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &xeAnimationClassRec,
    /* class_name		*/	"XeAudio",
    /* widget_size		*/	sizeof(XeAudioRec),
    /* class_initialize		*/	ClassInitialize,
    /* class_part_initialize	*/	ClassPartInitialize,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	NULL,
    /* expose			*/	XtInheritExpose,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
#ifdef USING_MOTIF_122
    /* extension		*/	(XtPointer)&_XeAudiobaseClassExtRec,
#else
    /* extension		*/	NULL,
#endif
  },
  { /* composite class fields */
    /* geometry_manager		*/   XtInheritGeometryManager,
    /* change_managed		*/   XtInheritChangeManaged,
    /* insert_child		*/   XtInheritInsertChild,
    /* delete_child		*/   XtInheritDeleteChild,
    /* extension		*/   NULL
  },
  { /* constraint class fields */
    /* subresources		*/   NULL,
    /* subresource_count	*/   0,
    /* constraint_size		*/   0,
    /* initialize		*/   NULL,
    /* destroy			*/   NULL,
    /* set_values		*/   NULL,
    /* extension		*/   NULL
   },
#ifdef USING_MOTIF_122
    {  /* manager class record */
       /* translations */                 XtInheritTranslations,
       /* syn_resources */                NULL,
       /* num_syn_resources */            0,
       /* syn_constraint_resources */     NULL,
       /* num_syn_constraint_resources */ 0,
       /* parent_process */               XmInheritParentProcess,
       /* extension */                    NULL  
    },
#endif
  { /* XeBasic fields */
    /* not used			*/	0
  },
  { /* XeAnimation fields */
    /* not used			*/	0
  },
  { /* XeAudio fields */
    /* not used			*/	0
  }
};

WidgetClass xeAudioWidgetClass = (WidgetClass)&xeAudioClassRec;

static void ClassInitialize()
    {
	XewInitializeWidgetSet();
#ifdef USING_MOTIF_122
        _XeAudiobaseClassExtRec.record_type = XmQmotif;
#endif
    }

static void ClassPartInitialize(class)
WidgetClass class;
    {
    }

static void ShowStatus(w)
XeAudioWidget w;
    {
	XePixmapSet *p = w->audio.pixmap_set;
	
	if (p == NULL)
		return;
	if (w->audio.playing == 0)
		if (w->animation.play == XePlay_FORWARD)
			w->core.background_pixmap = p->done;
		else
			w->core.background_pixmap = p->hold;
	else if (w->animation.play == XePlay_FORWARD)
		w->core.background_pixmap = p->play;
	else
		w->core.background_pixmap = p->pause;
	if (XtIsRealized((Widget)w))
	    {
		XSetWindowBackgroundPixmap
			(XtDisplay(w), XtWindow(w), w->core.background_pixmap);
		XClearArea(XtDisplay(w), XtWindow(w), 0,0,0,0, True);
		XFlush(XtDisplay(w));
	    }
    }

/*
** AudioOuputReady
**	This function is called when the output flow is ready to
**	receive more bytes.
**
**	Returns:
**		> 0, some bytes transferred, keep calling this function
**		= 0, hold off calling this function
**		< 0, close output stream permanently
*/
static int AudioOutputReady(out)
XeDataFlow *out;
    {
	XeDataFlow *in;
	XeAudioWidget w = (XeAudioWidget)out->w;

	if (w->animation.play != XePlay_FORWARD)
		return 0;

	if ((in = w->audio.flow_in) == NULL)
		return -1;
	return (*in->more)(in);
    }


static void DonePlaying(w)
XeAudioWidget w;
    {
	w->audio.playing = 0;
	ShowStatus(w);
    }

/*
** AudioOutputDone
**	This function is called pwhen output should be detached from
**	the widget.
*/
static void AudioOutputDone(out)
XeDataFlow *out;
    {
	XeDataFlow *in;
	XeAudioWidget w = (XeAudioWidget)out->w;

	if (out->fd >= 0)
	    {
		(*w->audio.close_play)(w, DonePlaying);
		out->fd = -1;
	    }
	w->audio.flow_out = NULL;
	in = w->audio.flow_in;
	if (in != NULL)
	    {
		w->audio.flow_in = NULL;
		(*in->done)(in);
	    }
    }

/*
** AudioInput
**	This function is called when there is incoming audio stream.
**	Process the received bytes (uncompress/volume/etc) and feed
**	them as simple u-law stream to the output. (This is prototype
**	implementation, only /dev/audio supported).
**
**	Returns:
**		> 0, the number of bytes actually processed
**		= 0, no bytes send, try to hold input source
**		< 0, error, close input	source
*/
static int AudioInput(in, data, length)
XeDataFlow *in;
char *data;
int length;
    {
	XeDataFlow *out;
	XeAudioWidget w = (XeAudioWidget)in->w;
	int n;

	if (w->animation.play != XePlay_FORWARD)
		return 0; /* Hold input flow */
	if ((out = w->audio.flow_out) == NULL)
	    {
		/* No output flow set, initialize one */

		int fd = (*w->audio.open_play)(w);

		if (fd < 0)
			return 0;
		w->audio.playing = 1;
		ShowStatus(w);
		out = w->audio.flow_out = XeFileOutFlow
			(in->w, AudioOutputReady, AudioOutputDone,fd);
		if (out == NULL)
			return -1; /* Cannot do Audio output! */
	    }
	/*
	** Simple output: just copy all input directly to output.
	** (In real implementation, this should contain decompression,
	** format conversions, volume control etc. No output buffering!
	*/
	n = (*out->feed)(out, data, length);
	/*
	** ..and just return the number of octets actually written.
	*/
	return n;
    }

/*
** AudioInputDone
**	This function is called when the incoming audio stream is
**	terminated (EOF, error or similar is detected). This function
**	will clean out Audio widget specific references to the input
**	input and initiate closing of output, if any active.
*/
static void AudioInputDone(in)
XeDataFlow *in;
    {
	XeAudioWidget w = (XeAudioWidget)in->w;
	XeDataFlow *out;

	/* Should assert in == w->audio.flow_in ??? */

	w->audio.flow_in = NULL;
	out = w->audio.flow_out;
	if (out != NULL)
	    {
		w->audio.flow_out = NULL;
		(*out->done)(out);
	    }
    }

static void SetupContent(w)
XeAudioWidget w;
    {
	XeDataFlow *in;
	int flush = 0;

	if (w->basic.content_loaded == False)
	    {
		if ((in = w->audio.flow_in) != NULL)
		    {
			/*
			** clean out previous flows, if any active.. 
			*/
			w->audio.flow_in = NULL;
			(*in->done)(in);
		    }
		w->audio.flow_in =
			XeStartInputFlow((XeBasicWidget)w,
					 AudioInput,
					 AudioInputDone);
		w->basic.content_loaded = True;
		flush = 1;
	    }
	(*w->audio.audio_control)(w, flush);
	if (w->animation.play == XePlay_FORWARD &&
	    w->audio.flow_in != NULL)
	    {
		/* Assuming resource Play has been changed... */

		if ((*w->audio.flow_in->more)(w->audio.flow_in) < 0)
			(*w->audio.flow_in->done)(w->audio.flow_in);
	    }
	ShowStatus(w);
    }


#include "bitmaps/Loudspeaker"
#include "bitmaps/Mutespeaker"

static void GetPixmap(w)
XeAudioWidget w;
    {
	static XePixmapSet *maps = NULL;
	XePixmapSet *p;

	if (w->core.background_pixmap != XtUnspecifiedPixmap)
		w->audio.pixmap_set = NULL;
	else
	    {
		for (p = maps; ; p = p->next)
			if (p == NULL)
			    {
				p = (XePixmapSet *)XtMalloc(sizeof(*p));
				p->display = XtDisplay(w);
				p->next = maps;
				maps = p;
				p->done = XCreatePixmapFromBitmapData
					(XtDisplay(w),
					 RootWindowOfScreen(XtScreen(w)),
					 (char *)XewLoudspeaker_bits,
					 XewLoudspeaker_width,
					 XewLoudspeaker_height,
					 w->basic.foreground_pixel,
					 w->core.background_pixel,
					 w->core.depth);
				p->play = XCreatePixmapFromBitmapData
					(XtDisplay(w),
					 RootWindowOfScreen(XtScreen(w)),
					 (char *)XewLoudspeaker_bits,
					 XewLoudspeaker_width,
					 XewLoudspeaker_height,
					 w->core.background_pixel,
					 w->basic.foreground_pixel,
					 w->core.depth);
				p->hold = XCreatePixmapFromBitmapData
					(XtDisplay(w),
					 RootWindowOfScreen(XtScreen(w)),
					 (char *)XewMutespeaker_bits,
					 XewMutespeaker_width,
					 XewMutespeaker_height,
					 w->basic.foreground_pixel,
					 w->core.background_pixel,
					 w->core.depth);
				p->pause = XCreatePixmapFromBitmapData
					(XtDisplay(w),
					 RootWindowOfScreen(XtScreen(w)),
					 (char *)XewMutespeaker_bits,
					 XewMutespeaker_width,
					 XewMutespeaker_height,
					 w->core.background_pixel,
					 w->basic.foreground_pixel,
					 w->core.depth);
			    }
			else if (XtDisplay(w) == p->display)
				break;
		w->audio.pixmap_set = p;
	    }
    }


static void Initialize(request, new)
Widget request, new;
    {
	XeAudioWidget w = (XeAudioWidget)new;

	w->audio.flow_in = NULL;
	w->audio.flow_out = NULL;
	w->audio.playing = 0;
	/*
	** Only one audio driver now available (SUN)
	*/
	XeAudio_SUN(w);
	GetPixmap(w);
	if (w->core.width == 0)
		w->core.width = XewLoudspeaker_width;
	if (w->core.height == 0)
		w->core.height = XewLoudspeaker_height;
	SetupContent((XeAudioWidget)w);
    }

static Boolean SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
    {
	SetupContent((XeAudioWidget)new);
	return True;
    }

static void Destroy(w)
Widget w;
    {
	XeAudioWidget a = (XeAudioWidget)w;
	XeDataFlow *df;

	if ((df = a->audio.flow_in) != NULL)
	    {
		a->audio.flow_in = 0;
		(*df->done)(df);
	    }
	if ((df = a->audio.flow_out) != NULL)
	    {
		a->audio.flow_out = 0;
		(*df->done)(df);
	    }
	(*a->audio.audio_cleanup)(a);

	/* Note: audio.pixmap_set is not owned by the widget. It must
	   not be released */
    }


static void TogglePlay(w, e, s, n)
Widget w;
XEvent *e;
String *s;
Cardinal *n;
    {
	XeAudioWidget a = (XeAudioWidget)w;
	
	if (a->animation.play == XePlay_FREEZE)
		a->animation.play = XePlay_FORWARD;
	else if (a->animation.play == XePlay_FORWARD)
		if (a->audio.playing == 0)
			a->basic.content_loaded = False; /* Restart */
		else
			a->animation.play = XePlay_FREEZE;
	else
		return;
	SetupContent(a);
    }


static void RestartPlay(w, e, s, n)
Widget w;
XEvent *e;
String *s;
Cardinal *n;
    {
	XeAudioWidget a = (XeAudioWidget)w;
	
	a->basic.content_loaded = False;
	SetupContent(a);
    }

#ifdef USING_MOTIF_122
/*
** WidgetNavigable
**	routine to handle traversal to children of this widget, if
**	there are any, or else the widget itself, if no children. 
*/
static XmNavigability WidgetNavigable(wid)
Widget wid;
    {   
	if(wid->core.sensitive && wid->core.ancestor_sensitive &&
	   ((XmManagerWidget) wid)->manager.traversal_on)
	    {
		XmNavigationType nav_type =
			((XmManagerWidget) wid)->manager.navigation_type;

		if(nav_type == XmSTICKY_TAB_GROUP ||
		   nav_type == XmEXCLUSIVE_TAB_GROUP ||
		   (nav_type == XmTAB_GROUP && !_XmShellIsExclusive( wid)))
			return XmTAB_NAVIGABLE;
		return XmCONTROL_NAVIGABLE;
	    }
	return XmNOT_NAVIGABLE;
    }
#endif
