/*
** Import module for importing RLE images into Xew
** internal raster format. 
**
** This file added by Jim Barber, barberjd@cs.curtin.edu.au
**	Curtin University of Western Australia
**	During March 1994.
*/
#include <stdio.h>
#if SYSV_INCLUDES
#	include <memory.h>
#	include <malloc.h>
#else
#if ANSI_INCLUDES
#	include <stddef.h>
#	include <stdlib.h>
#else
char *malloc();
void free();
#endif
#endif
#include <string.h>
#include <setjmp.h>
#include <X11/Xlib.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/RasterP.h>
#include "ImageTools.h"
#include "RasterRLE.h"

#ifndef NO_RLE
#define NO_DECLARE_MALLOC
#include "rle.h"
#include "rle_raw.h"
#endif

static void RasterImportWarning(w, msg)
XeRasterWidget w;
char *msg;
    {
	XeWidgetWarningMsg
		((Widget)w, "rasterImportWarning", msg, (String *)NULL, 0);
    }

#ifndef NO_RLE
/* Source code depending on the URT goes here. */
#endif

/*
** XeImport_RLE
**
*/
XeRawImage *XeImport_RLE(w)
XeRasterWidget w;
    {
#ifdef NO_RLE
	RasterImportWarning(w, "RLE support not compiled.");
	return NULL;
#else
	unsigned char	*rows[3];
	rle_hdr 	hdr;
	XeRawImage 	*raw = NULL;
	unsigned char	*data;
	unsigned long	row;
	int		x;
	XeDataContent content;

	_XeOpenContent((XeBasicWidget)w, &content);

	if (content.type && content.source.stream != NULL )
		hdr.rle_file = content.source.stream;
	else
	    {
		RasterImportWarning(w, "No RLE stream opened.");
		_XeDestroyRawImage(raw);
		_XeCloseContent(&content);
		return NULL;
	    }
	/* Read header from input file */
	rle_get_setup( &hdr );
	
	/* Set up raw image */
	raw = _XeCreateRawImage(hdr.ncolors);

	/* Set up parameters for raw image. */
	raw->num_channels = hdr.ncolors;
	raw->samples_per_pixel =hdr.ncolors; 
	raw->bits_per_sample = 8; 	
        raw->bits_per_component = 8;
	/* raw->width = hdr.xmax - hdr.xmin + 1; */
	raw->width = hdr.xmax + 1;
	raw->height = hdr.ymax - hdr.ymin + 1;
	raw->bytes_per_line = raw->samples_per_pixel * raw->width;
	raw->x_resolution = 1.0;
	raw->y_resolution = 1.0;
	raw->resolution_unit = XeImageUnit_NONE;
	raw->color_space = XeImageSpace_RGB;

        if (raw->bits_per_sample == 1)
        	raw->class = XeImageClass_PALETTE;
        else
                raw->class = XeImageClass_FULLCOLOR;

	/* Allocate memory for raw pixel data */
	raw->data = data = (unsigned char *)
			malloc(raw->bytes_per_line*raw->height);
	if (data == NULL)
	    {
		RasterImportWarning(w, "Out of memory at RLE import");
		_XeDestroyRawImage(raw);
		raw = NULL;
		goto clean_up;
	    }
	raw->alloc_data = True;
	/* Read in colour map if necessary. */
	/* This is untested */
	if(hdr.ncmap != 0)
	{
                int mapsize = (1<<raw->bits_per_sample);

		XtFree((char *)raw->color_map);
		raw->alloc_map = True;
                raw->color_map = (unsigned char *)XtMalloc(3 * mapsize);
		raw->color_map = (unsigned char *)
				buildmap(&hdr, hdr.ncmap, 0, 1); 
	}

	for (x = 0; x < raw->num_channels; ++x)
       	    {
          	raw->channel[x].addr = raw->data + x * raw->width;
               	raw->channel[x].w = raw->width;
               	raw->channel[x].h = raw->height;
              	raw->channel[x].inc = 1;
               	raw->channel[x].line = raw->bytes_per_line;
            }

	/* Read in raw data. */
	/* Note that I read from the bottom so that the file isn't inverted */
	data+=raw->bytes_per_line * raw->height -raw->width;
        for (row = 0; row < raw->height; row++)
 	    {
                for (x = raw->num_channels-1; x >= 0; --x, data-=raw->width)
			rows[x] = data;

               	rle_getrow( &hdr, rows );
	    }
    clean_up:
	_XeCloseContent(&content);
	return raw;
#endif
    }

