#ifndef TextImport_h
#define TextImport_h
/*
** Copyright 1992-1995 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/Xew/TextP.h>

/*
** XeTextInsertMode
**	Is used to control the initial mode of insertion for the
**	 _XeTextInsertContent function.
*/
typedef enum
    {
	XeTextInsertMode_RESET = 0,	/* From initial state only */
	XeTextInsertMode_CURRENT = -1,	/* From insert pnt + initial state */
	XeTextInsertMode_FOLLOWING = 1	/* Following insert pnt + init.state */
    } XeTextInsertMode;


_XFUNCPROTOBEGIN

XeTextInsertContext _XeTextBeginContent
	(
#if NeedFunctionPrototypes
	 XeTextWidget
#endif
	 );

XeTextInsertContext _XeTextInsertContent
	(
#if NeedFunctionPrototypes
	 XeTextWidget,	/* Text Widget */
	 Snip *,	/* Insert Point: Snip */
	 int,		/* Insert Point: Offset within Snip */
	 int		/* Initial mode selection flag */
#endif
	 );

/*
** _XeTextInsertWidget
**	create and insert a Snip containing a reference to a child
**	widget.
*/
Snip *_XeTextInsertWidget
	(
#if NeedFunctionPrototypes
	 XeTextInsertContext,	/* Context Pointer */
	 Widget			/* Widget to insert */
#endif
	 );

/*
** _XeTextDeleteWidget
**	Remove reference to a widget from a Snip.
*/
void _XeTextDeleteWidget
	(
#if NeedFunctionPrototypes
	 XeTextWidget,	/* Text Widget */
	 Snip *		/* Widget to remove */
#endif
	 );

Snip *_XeTextDeleteContent
	(
#if NeedFunctionPrototypes
	 XeTextInsertContext,	/* Context Pointer */
	 long			/* Characters to Delete */
#endif
	 );

Snip *_XeTextEndContent
	(
#if NeedFunctionPrototypes
	 XeTextInsertContext,	/* Context Pointer */
	 Region,		/* Expose area */
	 long *			/* Current virtual position change */
#endif
	 );
void _XeTextInsertLocation
	(
#if NeedFunctionPrototypes
	 XeTextInsertContext,	/* Context Pointer */
	 XeTextLocation *,	/* Return TextLocation here */
	 Region,		/* Expose area */
	 long *			/* Current virtual position change */
#endif
	 );
/*
** Feeding Character Content
*/
int _XeTextFeedContent
	(
#if NeedFunctionPrototypes
	 XeTextInsertContext,	/* Context Pointer */
	 char *,		/* Pointer to content byte stream */
	 long			/* Number of bytes to feed from pointer */
#endif
	 );
/*
** Setting and reading current tag value (*open* insert point)
*/
XeTextTag _XeTextSetTag
	(
#if NeedFunctionPrototypes
	 XeTextInsertContext,	/* Context Pointer */
	 XeTextTag		/* New tag value */
#endif
	 );

/*
** Reading current tag value (from *open*) insert point)
*/
XeTextTag _XeTextGetTag
	(
#if NeedFunctionPrototypes
	 XeTextInsertContext	/* Context Pointer */
#endif
	 );

/*
** _XeMakeLayoutContext
**	Utility function used from TextLayout. It will create insert
**	context such that all data inserted with it will be marked as
**	layout content.
*/
XeTextInsertContext _XeMakeLayoutContext
	(
#if NeedFunctionPrototypes
	 XeTextWidget,
	 Snip **
#endif
	 );

/*
** _XeTextLock
**	Set the value of the "mode lock" in the context.
*/
void _XeTextLock
	(
#if NeedFunctionPrototypes
	 XeTextInsertContext,
	 int
#endif
	 );

_XFUNCPROTOEND


/*
** ISO 2022 Charset changling support (for TextExport.h)
** =====================================================
**	These definitions don't seem to belong to here and
**	are provided only temporarily, until a proper
**	XeTextCharset module gets designed and constructed.
*/

/*
** XeCharsetDesignation
**	identifies a registered characterset uniquely by listing
**	the following components (these are sufficient for the
**	currently supported set):
*/
#define XeCharset_F	0xFF	/* Final character Mask */
#define XeCharset_96	0x100	/* 96 characterset */
#define XeCharset_M	0x200	/* Multibyte characterset */
#define XeCharset_G0	0x400	/* Always use G0 for this */

typedef unsigned short XeCharsetDesignation;
/*
** XeCharsetIdentifier
**	identifies internally the character set used in the
**	SnipData. (Currently this is just a plain pointer to a
**	constant character string representing X11 font
**	encoding. [ This will change at some point --msa]
*/
typedef char * XeCharsetIdentifier;

_XFUNCPROTOBEGIN
/*
** XeTextCharsetSelect
**	returns a pointer to two character sets (XeCharsetDesignation)
**	which describe the ISO 2022 state that matches the codes used
**	in data. The order of entries is significant:
**
**		0	GL
**		1	GR
*/
XeCharsetDesignation *XeTextCharsetSelect
	(
#if NeedFunctionPrototypes
	 XeCharsetIdentifier	/* Internal Charset Identifier */
#endif
	 );
/*
** XeTextCharsetDefault
**	returns unique charset idenfier for the default character
**	set.
*/
XeCharsetIdentifier XeTextCharsetDefault
	(
#if NeedFunctionPrototypes
	 void
#endif
	 );
_XFUNCPROTOEND

#endif

