/*
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/VideoP.h>
#include "VideoImage.h"
#include "VideoMPEG.h"

/*
** These defines are just a stopgap measure to get the initial
** window created, in case user didn't define any dimensions.
** The final dimensions should be taken from video stream.
*/
#define VIDEO_DEFAULT_WIDTH 128
#define VIDEO_DEFAULT_HEIGHT 128

#define offset(field) XtOffsetOf(XeVideoRec, video.field)

static XtResource resources[] =
    {
        {XtNdither, XtCDither, XtRXeDither, sizeof(XeDither), offset(dither),
		 XtRImmediate, (XtPointer)XeDither_FS4 },
        {XtNminFrameDelay, XtCMinFrameDelay, XtRInt, sizeof(int),
                 offset(min_frame_delay), XtRImmediate, (XtPointer)1},
	{XtNcolorQuantize, XtCColorQuantize, XtRXeColorQuantize,
		 sizeof(XeColorQuantize), offset(color_quantize),
		 XtRImmediate, (XtPointer)XeColorQuantize_FAST},
    };
#undef offset

static void ClassPartInitialize(), ClassInitialize();
static void Initialize(), Redisplay(), Destroy(), Resize(), Realize();
static Boolean SetValues();
static XtGeometryResult QueryGeometry();

static char defaultTranslations[] =
"\
<Btn1Down>,<Btn1Up>:	notify()\n\
<Btn1Down>:		toggle-play()\n\
<Btn3Down>:		restart-play()\n\
<EnterWindow>:		enter-window()\n\
<LeaveWindow>:		leave-window()\n\
";

static void TogglePlay();
static void RestartPlay();

static XtActionsRec actions[] =
    {
	{"toggle-play",		TogglePlay},
	{"restart-play",	RestartPlay},
    };

#ifdef USING_MOTIF_122
static XmNavigability WidgetNavigable() ;

/*******************************************/
/*  Declaration of class extension records */

XmBaseClassExtRec _XeVideobaseClassExtRec = {
    NULL,
    NULLQUARK,
    XmBaseClassExtVersion,
    sizeof(XmBaseClassExtRec),
    NULL,				/* InitializePrehook	*/
    NULL,				/* SetValuesPrehook	*/
    NULL,				/* InitializePosthook	*/
    NULL,				/* SetValuesPosthook	*/
    NULL,				/* secondaryObjectClass	*/
    NULL,				/* secondaryCreate	*/
    NULL,		                /* getSecRes data	*/
    { 0 },				/* fastSubclass flags	*/
    NULL,				/* get_values_prehook	*/
    NULL,				/* get_values_posthook	*/
    NULL,                               /* classPartInitPrehook */
    NULL,                               /* classPartInitPosthook*/
    NULL,                               /* ext_resources        */
    NULL,                               /* compiled_ext_resources*/
    0,                                  /* num_ext_resources    */
    FALSE,                              /* use_sub_resources    */
    WidgetNavigable,                    /* widgetNavigable      */
    NULL,                               /* focusChange          */
};
#endif

#define superclass (&xeAnimationClassRec)

XeVideoClassRec xeVideoClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) superclass,
    /* class_name		*/	"XeVideo",
    /* widget_size		*/	sizeof(XeVideoRec),
    /* class_initialize		*/	ClassInitialize,
    /* class_part_initialize	*/	ClassPartInitialize,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	actions,
    /* num_actions		*/	XtNumber(actions),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	XtExposeCompressMaximal,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	Resize,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultTranslations,
    /* query_geometry		*/	QueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
#ifdef USING_MOTIF_122
    /* extension		*/	(XtPointer)&_XeVideobaseClassExtRec,
#else
    /* extension		*/	NULL,
#endif
  },
  { /* composite class fields */
    /* geometry_manager		*/   XtInheritGeometryManager,
    /* change_managed		*/   XtInheritChangeManaged,
    /* insert_child		*/   XtInheritInsertChild,
    /* delete_child		*/   XtInheritDeleteChild,
    /* extension		*/   NULL
  },
  { /* constraint class fields */
    /* subresources		*/   NULL,
    /* subresource_count	*/   0,
    /* constraint_size		*/   0,
    /* initialize		*/   NULL,
    /* destroy			*/   NULL,
    /* set_values		*/   NULL,
    /* extension		*/   NULL
   },
#ifdef USING_MOTIF_122
    {  /* manager class record */
       /* translations */                 XtInheritTranslations,
       /* syn_resources */                NULL,
       /* num_syn_resources */            0,
       /* syn_constraint_resources */     NULL,
       /* num_syn_constraint_resources */ 0,
       /* parent_process */               XmInheritParentProcess,
       /* extension */                    NULL  
    },
#endif
  { /* XeBasic fields */
    /* not used			*/	0
  },
  { /* XeAnimation fields */
    /* not used			*/	0
  },
  { /* XeVideo fields */
    /* not used			*/	0
  }
};

WidgetClass xeVideoWidgetClass = (WidgetClass)&xeVideoClassRec;


static void ClassInitialize()
    {
	XewInitializeWidgetSet();
#ifdef USING_MOTIF_122
        _XeVideobaseClassExtRec.record_type = XmQmotif;
#endif
    }

static void ClassPartInitialize(class)
WidgetClass class;
    {
    }

static XtGeometryResult QueryGeometry(w, request, preferred)
Widget w;
XtWidgetGeometry *request;
XtWidgetGeometry *preferred;
    {
	XeVideoWidget v = (XeVideoWidget)w;
	int width, height;

	preferred->request_mode = CWWidth | CWHeight;
	width = (request->request_mode&CWWidth) ? request->width : 0;
	height = (request->request_mode&CWHeight) ? request->height : 0;
	_XeBasicScaling((XeBasicWidget)v, v->video.width, v->video.height,
			width, height,
			&preferred->width, &preferred->height);
	if (((request->request_mode&(CWWidth|CWHeight))==(CWWidth|CWHeight)) &&
	    request->width == preferred->width &&
	    request->height == preferred->height)
		return XtGeometryYes;
	else
		return XtGeometryAlmost;
    }

static void DonePlaying(w)
XeVideoWidget w;
    {
	XeAnimationDoneCallbackData data;

	data.reason = XeCR_ANIMATION_DONE;
	data.frame = w->animation.frame_num;
	XtCallCallbackList((Widget)w, w->animation.done_callbacks,
			   (XtPointer)&data);
    }	

#if NeedFunctionPrototypes
static void VideoWork(XtPointer, XtIntervalId *);
#else
static void VideoWork();
#endif

/*
** VideoInput
**	This function is called when there is incoming video stream.
**
**	The current Video implementation is driven by timer and not
**	by the input stream. Thus, this function will not process any
**	input (it will get queued). [And in reality, this should not
**	get called at all, because flow_in 'more' method is never called
**	either].
**
**	Returns:
**		> 0, the number of bytes actually processed
**		= 0, no bytes send, try to hold input source
**		< 0, error, close input	source
*/
static int VideoInput(in, data, length)
XeDataFlow *in;
char *data;
int length;
    {
	return 0;
    }

/*
** VideoInputDone
**	This function is called when the incoming video stream is
**	terminated (EOF, error or similar is detected). This function
**	will clean out video widget specific references to the
**	input.
*/
static void VideoInputDone(in)
XeDataFlow *in;
    {
	XeVideoWidget w = (XeVideoWidget)in->w;

	w->video.flow_in = NULL;
    }

/*
** VideoWork
**	This function is causes the decoder to process the stream.
**	(Currently called via timer)
*/
static void VideoWork(client_data, id)
XtPointer client_data;
XtIntervalId *id;
    {
	XeVideoWidget w = (XeVideoWidget)client_data;
	XtAppContext app = XtWidgetToApplicationContext((Widget)w);
	
	if (w->video.hold)
		w->video.work_id = 0;	/* Hold Image */
	else if ((*w->video.decode_play)(w) >= 0)
		w->video.work_id = XtAppAddTimeOut
			(app, w->video.min_frame_delay,VideoWork, client_data);
	else
	    {
		w->video.work_id = 0;
		(*w->video.close_play)(w, 0);
		DonePlaying(w);
	    }
    }

#if NeedFunctionPrototypes
static void SetupContent(XeVideoWidget w)
#else
static void SetupContent(w)
XeVideoWidget w;
#endif
    {
	XeDataFlow *in;

	if (w->basic.content_loaded == False)
	    {
		w->video.done = False;
		if ((in = w->video.flow_in) != NULL)
		    {
			/*
			** clean out previous flows, if any active.. 
			*/
			w->video.flow_in = NULL;
			(*in->done)(in);
		    }
		(*w->video.close_play)(w, 0);
		DonePlaying(w);
		w->video.flow_in =
			XeStartInputFlow((XeBasicWidget)w,
					 VideoInput, VideoInputDone);
		w->basic.content_loaded = True;
		w->animation.frame_num = 0; /* no frame shown yet */
		(*w->video.open_play)(w);
		(*w->video.decode_play)(w); /* decode first frame */
	    }
	if (w->video.raw_image)
	    {
		Dimension width, height;

		_XeBasicScaling((XeBasicWidget)w,
				w->video.raw_image->width,
				w->video.raw_image->height,
				w->core.width, w->core.height,
				&width, &height);
		if (w->basic.resize || w->core.width == 0)
			w->core.width = width;
		if (w->basic.resize || w->core.height == 0)
			w->core.height = height;
		if (w->video.dsp_image == NULL ||
		    w->video.dsp_image->image == NULL ||
		    w->video.dsp_image->image->width != width ||
		    w->video.dsp_image->image->height != height)
			w->video.done = False;
	    }
	if (w->core.width == 0)
	    {
		w->core.width = VIDEO_DEFAULT_WIDTH;
		w->video.set_width = True;
	    }
	if (w->core.height == 0)
	    {
		w->video.set_height = True;
		w->core.height = VIDEO_DEFAULT_HEIGHT;
	    }
	w->video.hold = w->animation.play != XePlay_FORWARD;
	if (!w->video.hold && w->video.flow_in && w->video.work_id == 0)
		w->video.work_id =
			XtAppAddTimeOut
				(XtWidgetToApplicationContext((Widget)w),
				 w->video.min_frame_delay, VideoWork,
				 (XtPointer)w);
	XSetBackground(XtDisplay(w),w->video.mygc,w->core.background_pixel);
	XSetForeground(XtDisplay(w),w->video.mygc,w->basic.foreground_pixel);
    }


static void Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;
Cardinal *num_args;
    {
        XeVideoWidget w = (XeVideoWidget)new;

	w->video.mygc  =
		XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), 0, 0);
	w->video.work_id = 0;
	w->video.flow_in = NULL;
	w->video.decoder = NULL;
	w->video.dsp_image = NULL;
	w->video.raw_image = NULL;
	w->video.done = False;
	w->video.set_width = False;
	w->video.set_height = False;
	w->video.hold = w->animation.play != XePlay_FORWARD;
	XeVideo_MPEG(w);
	SetupContent(w);
    }

static void Realize(w, value_mask, attributes)
Widget w;
Mask *value_mask;
XSetWindowAttributes *attributes;
    {
	XeVideoWidget v = (XeVideoWidget)w;

	(*superclass->core_class.realize)(w, value_mask, attributes);
	if (!v->video.hold &&
	    v->video.flow_in != NULL && v->video.work_id == 0)
		v->video.work_id =
			XtAppAddTimeOut
				(XtWidgetToApplicationContext((Widget)w),
				 v->video.min_frame_delay, VideoWork,
				 (XtPointer)v);
    }

static Boolean SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
    {
	XeVideoWidget cw = (XeVideoWidget)current;
	XeVideoWidget nw = (XeVideoWidget)new;

	if (cw->basic.max_colors != nw->basic.max_colors ||
	    cw->basic.color_mode != nw->basic.color_mode ||
	    cw->basic.colormap_use != nw->basic.colormap_use ||
	    cw->basic.rotation != nw->basic.rotation ||
	    cw->basic.scaling != nw->basic.scaling ||
	    cw->basic.use_shm != nw->basic.use_shm ||
	    cw->basic.mirror_image != nw->basic.mirror_image ||
	    cw->video.dither != nw->video.dither ||
	    cw->video.color_quantize != nw->video.color_quantize)
		nw->video.done = False;
	SetupContent(nw);
	return (!nw->video.done ||
		cw->core.background_pixel != nw->core.background_pixel ||
		cw->basic.foreground_pixel != nw->basic.foreground_pixel);
    }

static void Redisplay(w, event, r)
Widget w;
XExposeEvent *event;
Region r;
    {
	XeVideoWidget v = (XeVideoWidget)w;
	if (!XtIsRealized(w))
		return;
	if (!v->video.done)
		XeVideoImage(v);
	if (v->video.dsp_image != NULL)
		_XePutImage((XeBasicWidget)w,v->video.mygc,v->video.dsp_image,
			    0, 0, 0, 0,
			    v->video.dsp_image->image->width,
			    v->video.dsp_image->image->height);
	if (v->basic.expose_callbacks &&
	    v->core.widget_class == xeVideoWidgetClass)
	    {
		XeExposeCallbackData data;
		data.reason = XeCR_EXPOSE;
		data.event = event;
		data.region = r;
		XtCallCallbackList
			(w, v->basic.expose_callbacks, (XtPointer)&data);
	    }
    }

static void Resize(w)
Widget w;
    {
	XeVideoWidget v = (XeVideoWidget)w;

	v->video.done = False;
    }

static void Destroy(wid)
Widget wid;
    {
	XeVideoWidget w = (XeVideoWidget)wid;
	XeDataFlow *df;

	if ((df = w->video.flow_in) != NULL)
	    {
		w->video.flow_in = 0;
		(*df->done)(df);
	    }
	(*w->video.close_play)(w, 0);
	(*w->video.video_cleanup)(w);
	XFreeGC(XtDisplay(w), w->video.mygc);
	_XeDestroyImage((XeBasicWidget)w, w->video.dsp_image);
	_XeDestroyRawImage(w->video.raw_image);
	w->video.dsp_image = NULL;
    }


static void TogglePlay(w, e, s, n)
Widget w;
XEvent *e;
String *s;
Cardinal *n;
    {
	XeVideoWidget v = (XeVideoWidget)w;
	
	if (v->animation.play == XePlay_FREEZE)
		v->animation.play = XePlay_FORWARD;
	else if (v->animation.play == XePlay_FORWARD)
		v->animation.play = XePlay_FREEZE;
	else
		return;
	SetupContent(v);
    }


static void RestartPlay(w, e, s, n)
Widget w;
XEvent *e;
String *s;
Cardinal *n;
    {
	XeVideoWidget v = (XeVideoWidget)w;
	
	v->basic.content_loaded = False;
	SetupContent(v);
    }

#ifdef USING_MOTIF_122
/*
** WidgetNavigable
**	routine to handle traversal to children of this widget, if
**	there are any, or else the widget itself, if no children. 
*/
static XmNavigability WidgetNavigable(wid)
Widget wid;
    {   
	if(wid->core.sensitive && wid->core.ancestor_sensitive &&
	   ((XmManagerWidget) wid)->manager.traversal_on)
	    {
		XmNavigationType nav_type =
			((XmManagerWidget) wid)->manager.navigation_type;

		if(nav_type == XmSTICKY_TAB_GROUP ||
		   nav_type == XmEXCLUSIVE_TAB_GROUP ||
		   (nav_type == XmTAB_GROUP && !_XmShellIsExclusive( wid)))
			return XmTAB_NAVIGABLE;
		return XmCONTROL_NAVIGABLE;
	    }
	return XmNOT_NAVIGABLE;
    }
#endif
