/*-
|> File
|| handlreq.c
||
|> Description
||
|> Comments
||
|> History
|| 95061 _mf Created.
|| Oct/Nov 1995 modified by msa
||
||==================================================================|>
*/
#ifndef _NOIDENT
#ident "$Id: handlreq.c,v 2.0 1995/06/05 16:52:12 reynolds Exp $"
#endif

#include <stdio.h>
#include <malloc.h>
#include <string.h>

#define NEED_REPLIES    /* because Xproto.h is stupid and needs this */
#include <X11/Xproto.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#include "printer.h"
#include "printlib.h"
#include "printlibP.h"

#include "drawcmd.h"
#include "global.h"
#include "afm.h"

/*
** Predefine some own Atoms in addition to the standard ones
** (deliberately use the same define name syntax as standard, just
** to catch redefines, which should not occur!)
*/
#define XA_PIXEL_SIZE		(XA_LAST_PREDEFINED+1)
#define XA_AVERAGE_WIDTH	(XA_LAST_PREDEFINED+2)
#define XA_FIGURE_WIDTH		(XA_LAST_PREDEFINED+3)
#define XA_SUBSCRIPT_SIZE	(XA_LAST_PREDEFINED+4)
#define XA_SUPERSCRIPT_SIZE	(XA_LAST_PREDEFINED+5)

#define MY_LAST_PREDEFINED XA_SUPERSCRIPT_SIZE

static char *predefined_atoms[MY_LAST_PREDEFINED+1] = 
    {
	NULL,		/* Don't use 0 as atom */
	"PRIMARY",
	"SECONDARY",
	"XA_ARC",
	"ATOM",
	"BITMAP",
	"CARDINAL",
	"COLORMAP",
	"CURSOR",
	"CUT_BUFFER0",
	"CUT_BUFFER1",
	"CUT_BUFFER2",
	"CUT_BUFFER3",
	"CUT_BUFFER4",
	"CUT_BUFFER5",
	"CUT_BUFFER6",
	"CUT_BUFFER7",
	"DRAWABLE",
	"FONT",
	"INTEGER",
	"PIXMAP",
	"POINT",
	"RECTANGLE",
	"RESOURCE_MANAGER",
	"RGB_COLOR_MAP",
	"RGB_BEST_MAP",
	"RGB_BLUE_MAP",
	"RGB_DEFAULT_MAP",
	"RGB_GRAY_MAP",
	"RGB_GREEN_MAP",
	"RGB_RED_MAP",
	"STRING",
	"VISUALID",
	"WINDOW",
	"WM_COMMAND",
	"WM_HINTS",
	"WM_CLIENT_MACHINE",
	"WM_ICON_NAME",
	"WM_ICON_SIZE",
	"WM_NAME",
	"WM_NORMAL_HINTS",
	"WM_SIZE_HINTS",
	"WM_ZOOM_HINTS",
	"MIN_SPACE",
	"NORM_SPACE",
	"MAX_SPACE",
	"END_SPACE",
	"SUPERSCRIPT_X",
	"SUPERSCRIPT_Y",
	"SUBSCRIPT_X",
	"SUBSCRIPT_Y",
	"UNDERLINE_POSITION",
	"UNDERLINE_THICKNESS",
	"STRIKEOUT_ASCENT",
	"STRIKEOUT_DESCENT",
	"ITALIC_ANGLE",
	"X_HEIGHT",
	"QUAD_WIDTH",
	"WEIGHT",
	"POINT_SIZE",
	"RESOLUTION",
	"COPYRIGHT",
	"NOTICE",
	"FONT_NAME",
	"FAMILY_NAME",
	"FULL_NAME",
	"CAP_HEIGHT",
	"WM_CLASS",
	"WM_TRANSIENT_FOR",

/*
**	Private predefined atom names (take care to keep the order aligned
**	with the XA_ names...!!!
*/
	"PIXEL_SIZE",
	"AVERAGE_WIDTH",
	"FIGURE_WIDTH",
	"SUBSCRIPT_SIZE",
	"SUPERSCRIPT_SIZE",
    };

/*-=================================================================|>
||
|> Local functions
||
||==================================================================|>
||
*/

/* set window attributes from a request */

static void
setWinattrs (
              XWindowAttributes *attr,
              unsigned long value_mask,
              unsigned long *request,
	      XWindowAttributes *parent)

{
  if (value_mask & CWBitGravity)
  {
    attr->bit_gravity = *request++;
  }
  if (value_mask & CWWinGravity)
  {
    attr->win_gravity = *request++;
  }
  if (value_mask & CWBackingStore)
  {
    attr->backing_store = *request++;
  }
  if (value_mask & CWBackingPlanes)
  {
    attr->backing_planes = *request++;
  }
  if (value_mask & CWBackingPixel)
  {
    attr->backing_pixel = *request++;
  }
  if (value_mask & CWOverrideRedirect)
  {
    attr->override_redirect = *request++;
  }
  if (value_mask & CWSaveUnder)
  {
    attr->save_under = *request++;
  }
  if (value_mask & CWDontPropagate)
  {
    attr->do_not_propagate_mask = *request++;
  }
  if (value_mask & CWColormap)
  {
    attr->colormap = *request++;
    if (!attr->colormap)
	    attr->colormap = parent->colormap;
  }
  /*- Why are these commented out? because we don't care about cursors and
    event masks.
  */
#if 0
  if (value_mask & CWEventMask)
  {
    attr->event_mask = *request++;
  }
#endif
#if 0
  if (value_mask & CWCursor)
  {
    attr->cursor = *request++;
  }
#endif
  /*
  ** NOTE! Current printing does not really draw windows backgrounds and
  ** borders. The code below is just for reference now... -- msa
  */
  if (value_mask & CWBackPixmap)
  {
      /* nothing */;
  }
  if (value_mask & CWBackPixel)
  {
      /* nothing */;
  }
  if (value_mask & CWBorderPixmap)
  {
      /* nothing */;
  }
}

/* delete a window from a table of windows */
static void
deleteWin (
            const winfoTablePtr table,
            const unsigned long win)

{
  int                     ii = 0,
                          jj = 0;

  for (; ii < table->numWin; ii++)
    if (table->winTable[ii].win != win)
      table->winTable[jj++] = table->winTable[ii];

  table->numWin = jj;
}

/* delete a GC from a table of GCs */

/* note also similar function removegcs in pserver.c! merge? -- msa */

static void deleteGc (const gcinfoTablePtr table, const unsigned long gcid)
    {
	int ii = 0, jj = 0;

	for (; ii < table->numGc; ii++)
		if (table->gcTable[ii].gcid != gcid)
			table->gcTable[jj++] = table->gcTable[ii];
		else
		    {
			if (table->gcTable[ii].clipRects)
				free((char *)table->gcTable[ii].clipRects);
			if (table->gcTable[ii].dashes)
				free((char *)table->gcTable[ii].dashes);
		    }
	table->numGc = jj;
    }

/* delete a colormap from a table of colormaps */

static void
deleteCmap (
             const cmapinfoTablePtr table,
             const unsigned long cmap)

{
  int                     ii = 0,
                          jj = 0;

  for (; ii < table->numCmap; ii++)
    if (table->cmapTable[ii].cmap != cmap)
      table->cmapTable[jj++] = table->cmapTable[ii];

  table->numCmap = jj;
}


/*
** createColormap
**	for a client (fd) using resource id (cmap) and visual
*/
cmapinfoPtr createColormap(long cmap, long visual, int fd)
    {
	int i, ind;

	if (cmapinfoTable->numCmap == cmapinfoTable->numAlloc)
	    {
		cmapinfoTable->numAlloc += NUMCMAP;
		cmapinfoTable->cmapTable = (cmapinfoPtr)realloc
			((char *)cmapinfoTable->cmapTable,
			 cmapinfoTable->numAlloc * sizeof(cmapinfoTableRec));
	    }
	ind = cmapinfoTable->numCmap++;
	
	/* ...what about TRUECOLOR_VISUAL??? Needs fixing! -- msa */

	cmapinfoTable->cmapTable[ind].numColors = NUM_COLORS;
	cmapinfoTable->cmapTable[ind].cmap = cmap;
	cmapinfoTable->cmapTable[ind].visualID = visual;
	cmapinfoTable->cmapTable[ind].fd = fd;
	for (i = 0; i < NUM_COLORS; i++)
	    {
		cmapinfoTable->cmapTable[ind].colors[i].pixel = i;
		cmapinfoTable->cmapTable[ind].numAlloc[i] = 0;
		/* ..writeable is not really tested anywhere?? -- msa */
		cmapinfoTable->cmapTable[ind].writeable[i] = TRUE;
	    }
	return &cmapinfoTable->cmapTable[ind];
    }

/*
** createWindow
**	for a client (fd) using resource id (window).
**
** *NOTE*
**	This function only allocates winfo and initializes it with the
**	defaults.
*/
winfoPtr createWindow(long window, long parent, long visual, int fd)
    {
	int ind;

	if (winfoTable->numWin == winfoTable->numAlloc)
	    {
		winfoTable->numAlloc += NUMWIN;
		winfoTable->winTable = (winfoPtr)realloc
			((char *)winfoTable->winTable,
			 winfoTable->numAlloc * sizeof(winfoRec));
	    }
	ind = winfoTable->numWin++;

	winfoTable->winTable[ind].win = window;
	winfoTable->winTable[ind].parent = parent;
	winfoTable->winTable[ind].fd = fd;
	winfoTable->winTable[ind].visualID = visual;
	winfoTable->winTable[ind].attr = initial_Attrs;
	return &winfoTable->winTable[ind];
    }

/*
** allocColor
**	returns pixel or -1, if allocation fails
*/
long allocColor(int cmap, unsigned *red, unsigned *green, unsigned *blue)
    {
	cmapinfoPtr cmapinfo;
	int i;
	long pixel = -1;

	*red = COLOR_VALUE(*red);
	*green = COLOR_VALUE(*green);
	*blue = COLOR_VALUE(*blue);

	cmapinfo = getcmapinfo (cmap);
	if (cmapinfo == NULL)
		return pixel;
	if (cmapinfo->visualID == TRUECOLOR_VISUAL)
		return (*red >> 8) | *green | (*blue << 8);
	else if (cmapinfo->visualID == PSEUDOCOLOR_VISUAL)
	    {
		for (i = 0; i < NUM_COLORS; i++)
			if (cmapinfo->numAlloc[i] > 0)
			    {
				if (cmapinfo->colors[i].red == *red &&
				    cmapinfo->colors[i].green == *green &&
				    cmapinfo->colors[i].blue == *blue)
				    {
					cmapinfo->numAlloc[i] += 1;
					return i;
				    }
			    }
			else if (pixel == -1)
				pixel = i;
	    }

	if (pixel != -1)
	    {
		cmapinfo->colors[pixel].red = *red;
		cmapinfo->colors[pixel].green = *green;
		cmapinfo->colors[pixel].blue = *blue;
		cmapinfo->numAlloc[pixel] += 1;
	    }
	return pixel;
    }


/*-=================================================================|>
||
|> Public functions
||
||==================================================================|>
*/

/*
** getcmapinfo
**	find cmapinfo by resource id. Return NULL, if not found.
*/
cmapinfoPtr getcmapinfo(long cmap)
    {
	int i;

	for (i = 0; i < cmapinfoTable->numCmap; i++)
		if (cmapinfoTable->cmapTable[i].cmap == cmap)
			return &cmapinfoTable->cmapTable[i];
	return NULL;
    }

/* create a new internal atom symbol (or return an existing one) */

int internAtom (char *name)
    {
	int i;
	
	for (i = 0; ; ++i)
	    {
		if (i == atomTable->numAtoms)
		    {
			if (i == atomTable->numAlloc)
			    {
				atomTable->numAlloc += NUMATOM;
				atomTable->name = (char **)
					realloc((char *)atomTable->name,
						atomTable->numAlloc *
						sizeof(char *));
			    }
			atomTable->name[i] = strdup(name);
			return i;
		    }
		else if (atomTable->name[i] &&
			 strcmp(atomTable->name[i], name) == 0)
			return i;
	    }
	return 0;
    }


/* initialize the window, GC, colormap, atom, and font tables */

void initTables(int true_color)
{
    /* 'true_color' parameter ignored for now... does not work! --msa */

    cmapinfoTable = (cmapinfoTablePtr)malloc(sizeof(cmapinfoTableRec));
    cmapinfoTable->cmapTable = (cmapinfoPtr)malloc
	    (sizeof(cmapinfoRec) * NUMCMAP);
    cmapinfoTable->numAlloc = NUMCMAP;
    cmapinfoTable->numCmap = 0;

    winfoTable = (winfoTablePtr) malloc (sizeof (winfoTableRec));
    winfoTable->winTable = (winfoPtr) malloc (sizeof (winfoRec) * NUMWIN);
    winfoTable->numWin = 0;
    winfoTable->numAlloc = NUMWIN;

    gcinfoTable = (gcinfoTablePtr) malloc (sizeof (gcinfoTableRec));
    gcinfoTable->gcTable = (gcinfoPtr) malloc (sizeof (gcinfoRec) * NUMGC);
    gcinfoTable->numAlloc = NUMGC;
    gcinfoTable->numGc = 0;

    atomTable = (atomTablePtr) malloc (sizeof (atomTableRec));
    atomTable->name = 
	    (char **)malloc(sizeof(char *) * (NUMATOM+MY_LAST_PREDEFINED + 1));
    atomTable->numAtoms = MY_LAST_PREDEFINED + 1;
    atomTable->numAlloc = MY_LAST_PREDEFINED + NUMATOM + 1;
    memcpy((char *)atomTable->name, (char *)predefined_atoms,
	   sizeof(predefined_atoms));

    fontTable = (fontTablePtr) malloc (sizeof (fontTableRec));
    fontTable->fontTable = (fontPtr) malloc (sizeof (fontRec) * NUMFONT);
    fontTable->numFonts = 0;
    fontTable->numAlloc = NUMFONT;
}

/*-
|> Function
|| getgcinfo
||
|> Description
|| get the GC attributes corresponding to a GC id.
||
|> Comments
|| None.
||
|> Parameters
|| -void.
||
|> Returns
|| Returns void.
||
|> Exits
|| Exits if:
||
|> Limits
||   
||
||==================================================================|>
*/

gcinfoPtr
getgcinfo (
            const unsigned long gcid,
            const gcinfoTablePtr table)

{
  int                     i;

  for (i = 0; i < table->numGc; i++)
    if (table->gcTable[i].gcid == gcid)
      return (&(table->gcTable[i]));

  return 0;
}

/* get the window attributes corresponding to a window */

winfoPtr
getwinfo (
           const unsigned long win,
           const winfoTablePtr table)

{
  int                     ii = 0;

  for (; ii < table->numWin; ii++)
    if (table->winTable[ii].win == win)
      return (&(table->winTable[ii]));

/* this probably indicates that the window is on the REAL server */

  return 0;
}

/*
** ReplyCharInfo
*/
static void ReplyCharInfo
	(xCharInfo *reply, XCharStruct *info, FontData *f, int size)
    {
	reply->leftSideBearing = PIXELS(f, info->lbearing, size);
	reply->rightSideBearing = PIXELS(f, info->rbearing, size);
	reply->characterWidth = PIXELS(f, info->width, size);
	reply->ascent = PIXELS(f, info->ascent, size);
	reply->descent =
		PIXELS(f, info->ascent+info->descent, size) - reply->ascent;
	reply->attributes = info->attributes;
    }

/*
** ReplyFontProp
*/
static void ReplyFontProp
	(xFontProp *reply, XFontProp *info, FontData *f, int size)
    {
	reply->name = info->name;
	/*
	** Need to scale some properties by size...
	*/
	if (info->name == XA_PIXEL_SIZE ||
	    info->name == XA_AVERAGE_WIDTH ||
	    info->name == XA_MIN_SPACE ||
	    info->name == XA_NORM_SPACE ||
	    info->name == XA_MAX_SPACE ||
	    info->name == XA_END_SPACE ||
	    info->name == XA_FIGURE_WIDTH ||
	    info->name == XA_SUPERSCRIPT_X ||
	    info->name == XA_SUPERSCRIPT_Y ||
	    info->name == XA_SUBSCRIPT_X ||
	    info->name == XA_SUBSCRIPT_Y ||
	    info->name == XA_SUPERSCRIPT_SIZE ||
	    info->name == XA_SUBSCRIPT_SIZE ||
	    info->name == XA_UNDERLINE_POSITION ||
	    info->name == XA_UNDERLINE_THICKNESS ||
	    info->name == XA_STRIKEOUT_ASCENT ||
	    info->name == XA_STRIKEOUT_DESCENT)
	    {
		reply->value = PIXELS(f, info->card32, size);
	    }
	
    }

static void ErrorGContext(unsigned char *newmsg, int *newlen,
			  unsigned char *buf, char *msg, unsigned long gcid)
    {
	xReq *req = (xReq *)buf;
	xError *reply = (xError *)newmsg;
	
	reply->type = X_Error;
	reply->errorCode = 13; /* "GContext" (where is define for this?) */
	reply->resourceID = gcid;
	reply->minorCode = 0;
	reply->majorCode = req->reqType;
	*newlen = sizeof(*reply);
	fprintf(stderr, msg, gcid); 
   }

/*-
|> Function
|| HandleX_Request
||
|> Description
|| lib. 
||
|> Comments
|| None.
||
|> Parameters
|| -void.
||
|> Returns
|| Returns int
||
|> Exits
|| Exits if:
||
|> Limits
||   
||
||==================================================================|>
*/

int
HandleX_Request (
                  unsigned char *const buf,
                  unsigned char *newmsg,
                  int *newlen,
                  const int request,
                  const FD fd)

{
  unsigned char           flag;
  int                     nrect;
  winfoPtr                winfo;
  gcinfoPtr               gc;
  cmapinfoPtr             cmapinfo;
  FILE                   *printFp = PCS[fd].printfp;

  switch (request)
  {
  case X_CreateWindow:
    {
      xCreateWindowReq       *req = (xCreateWindowReq *) buf;
      XWindowAttributes      *attr;
      winfoPtr               parent;

      parent = getwinfo(req->parent, winfoTable);
      if (!parent)
	  {
	      xError *err = (xError *)newmsg;
	      err->type = X_Error;
	      err->errorCode = 3; /* "Window" error */
	      err->minorCode = 0;
	      err->majorCode = req->reqType;
	      err->resourceID = req->parent;
	      *newlen = sizeof(*err);
	      return 0;
	  }
      winfo = createWindow(req->wid, req->parent,
			   req->visual ? req->visual : parent->visualID,
			   fd);
      attr = &winfo->attr;
      attr->x = req->x;
      attr->y = req->y;
      attr->width = req->width;
      attr->height = req->height;
      attr->class = req->class;
      attr->colormap = parent->attr.colormap;
      setWinattrs (attr, req->mask,
                   (unsigned long *)(buf + sizeof (xCreateWindowReq)),
		   &parent->attr);
    }
    return 0;                   /* don't forward the request */
    break;

  case X_ChangeWindowAttributes:
    {
      xChangeWindowAttributesReq *req = (xChangeWindowAttributesReq *) buf;
      winfoPtr               parent;

      if ((winfo = getwinfo (req->window, winfoTable)) &&
	  (parent = getwinfo (winfo->parent, winfoTable)))
      {
        setWinattrs (&winfo->attr, req->valueMask,
                     (unsigned long *)
                     (buf + sizeof (xChangeWindowAttributesReq)),
		     &parent->attr);
      }
      else
        fprintf (stderr,
                 "X_ChangeWindowAttributes bad window %ld\n",
                 req->window);
    }
    break;

  case X_GetWindowAttributes:
    {
      xResourceReq           *req = (xResourceReq *) buf;
      xGetWindowAttributesReply *reply =
      (xGetWindowAttributesReply *) newmsg;

      if ((winfo = getwinfo (req->id, winfoTable)))
      {
	reply->visualID = winfo->visualID;
        reply->backingStore = winfo->attr.backing_store;
        reply->length = 3;
        reply->class = winfo->attr.class;
        reply->bitGravity = winfo->attr.bit_gravity;
        reply->winGravity = winfo->attr.win_gravity;
        reply->backingBitPlanes = winfo->attr.backing_planes;
        reply->backingPixel = winfo->attr.backing_pixel;
        reply->saveUnder = winfo->attr.save_under;
        reply->colormap = winfo->attr.colormap;
        reply->allEventMasks = winfo->attr.all_event_masks;
        reply->doNotPropagateMask =
          winfo->attr.do_not_propagate_mask;
        *newlen = sizeof (*reply);
      }
      else
        fprintf (stderr, "X_GetWindowAttributes bad window %ld\n",
                 req->id);
    }
    break;

  case X_DestroyWindow:
    {
      xResourceReq           *req = (xResourceReq *) buf;

      deleteWin (winfoTable, req->id);
    }
    break;

  case X_GetGeometry:
    {
      xResourceReq           *req = (xResourceReq *) buf;
      xGetGeometryReply      *reply = (xGetGeometryReply *) newmsg;

      if ((winfo = getwinfo (req->id, winfoTable)))
      {
        reply->x = winfo->attr.x;
        reply->y = winfo->attr.y;
        reply->width = winfo->attr.width;
        reply->height = winfo->attr.height;
        reply->depth = winfo->attr.depth;
        reply->length = 0;
        reply->root = winfoTable->winTable[0].win;
        reply->borderWidth = winfo->attr.border_width;
        *newlen = sizeof (*reply);
      }
      else
        fprintf (stderr, "X_GetGeometry bad window id %ld\n",
                 req->id);
    }
    break;

  case X_QueryTree:
    {
      xResourceReq           *req = (xResourceReq *) buf;
      xQueryTreeReply        *reply = (xQueryTreeReply *) newmsg;

      if ((winfo = getwinfo (req->id, winfoTable)))
      {
        reply->root = winfoTable->winTable[0].win;
        reply->parent = winfo->parent;

/* FTM, number of children is zero */

        reply->nChildren = 0;
        reply->length = 0;
        *newlen = sizeof (*reply);
      }
      else
        fprintf (stderr, "X_QueryTree bad window id %ld\n",
                 req->id);
    }
    break;

  case X_InternAtom:
    {
      xInternAtomReq         *req = (xInternAtomReq *) buf;
      xInternAtomReply       *reply = (xInternAtomReply *) newmsg;

      char *aname = malloc(req->nbytes+1);

      memcpy(aname, (char *)buf + sizeof(*req), req->nbytes);
      aname[req->nbytes] = 0;

      reply->atom = 0;
      reply->length = 0;
      reply->atom = internAtom(aname);
      *newlen = sizeof (*reply);
    }
    break;

  case X_GetAtomName:
    {
      xResourceReq           *req = (xResourceReq *) buf;
      xGetAtomNameReply      *reply = (xGetAtomNameReply *) newmsg;


      if (req->id > 0 &&
	  req->id < atomTable->numAtoms && atomTable->name[req->id])
	  {
	      reply->nameLength = strlen (atomTable->name[req->id]);
	      memcpy((char *) newmsg + sizeof (*reply),
		     (char *) atomTable->name[req->id], reply->nameLength);
	      reply->length = (reply->nameLength + 3) / 4;
	      *newlen = sizeof (*reply) + (reply->length << 2);
	  }
      else
	  {
	      xError *err = (xError *)reply;
	      err->type = X_Error;
	      err->errorCode = 5; /* "Atom" error */
	      err->minorCode = 0;
	      err->majorCode = req->reqType;
	      err->resourceID = req->id;
	      *newlen = sizeof(*err);
	  }
    }
    break;

  case X_GetProperty:
    {
/* FTM, don't return ANY properties */
      xGetPropertyReply      *reply = (xGetPropertyReply *) newmsg;

      reply->propertyType = None;
      reply->bytesAfter = 0;
      reply->length = 0;
      reply->format = 0;
      reply->nItems = 0;
      *newlen = sizeof (*reply);
    }
    break;

  case X_ListProperties:
    {
      xListPropertiesReply   *reply =
      (xListPropertiesReply *) newmsg;

      reply->nProperties = 0;
      *newlen = sizeof (*reply);
    }
    break;

  case X_GetSelectionOwner:
    {
      xGetSelectionOwnerReply *reply =
      (xGetSelectionOwnerReply *) newmsg;

      reply->owner = 0;
      *newlen = sizeof (*reply);
    }
    break;

  case X_GrabPointer:
    {
      xGrabPointerReply      *reply = (xGrabPointerReply *) newmsg;

      reply->status = False;
      *newlen = sizeof (*reply);
    }
    break;

  case X_GrabKeyboard:
    {
      xGrabKeyboardReply     *reply = (xGrabKeyboardReply *) newmsg;

      reply->status = False;
      *newlen = sizeof (*reply);
    }
    break;

	/* obviously, this is truly bogus, but they shouldn't be querying */
	/* the pointer from this server anyway */
	  
  case X_QueryPointer:
    {
      xQueryPointerReply     *reply = (xQueryPointerReply *) newmsg;

      reply->root = reply->child = 0,
        reply->rootX = reply->rootY =
        reply->winX = reply->winY = 0;

      *newlen = sizeof (*reply);
    }
    break;

  case X_GetMotionEvents:
    {
      xGetMotionEventsReply  *reply =
      (xGetMotionEventsReply *) newmsg;

      reply->nEvents = 0;
      *newlen = sizeof (*reply);
    }
    break;

  case X_TranslateCoords:
    {
      xTranslateCoordsReply  *reply =
      (xTranslateCoordsReply *) newmsg;

      reply->dstX = 0;
      reply->dstY = 0;
      *newlen = sizeof (*reply);
    }
    break;

  case X_GetInputFocus:
    {
      xGetInputFocusReply    *reply =
      (xGetInputFocusReply *) newmsg;

      reply->focus = 0;         /* make it the root window */
      reply->revertTo = None;
      reply->length = 0;        /* the documentation says this is 0 */
      *newlen = sizeof (*reply);
    }
    break;

  case X_OpenFont:
    {
      xOpenFontReq           *req = (xOpenFontReq *) buf;
      char                   *fontName = (char *) buf + sizeof (xOpenFontReq);
      fontPtr                 font;
      FontData                **fonts, *f;
      char                    **aliases;
      int                     num, i, n;

      /*
      ** First check if the name is aliased
      */
      n = req->nbytes;
      aliases = GetFontAliases(&num);
      for (i = 0; i < num; ++i)
	      if (aliases[2*i] &&
		  aliases[2*i+1] &&
		  FontMatch(fontName, n, aliases[2*i]))
		  {
		      fontName = aliases[2*i+1];
		      n = strlen(fontName);
		      break;
		  }
      /*
      ** Now, find the real font
      */
      /* Need to substitute PIXELSIZE with * ? */
      fonts = GetFontsList(&num);
      for (f = NULL, i = 0; i < num; ++i)
	      if (fonts[i]->xlfd && FontMatch(fontName, n, fonts[i]->xlfd))
		  {
		      f = fonts[i];
		      break;
		  }

      if (!f)
	  {
	      /* No such font found! return xError */

	      xError    *reply = (xError *) newmsg;

	      reply->type = X_Error;
	      reply->errorCode = 15; /* "Name" (where is define for this?) */
	      reply->minorCode = 0;
	      reply->majorCode = req->reqType;
	      *newlen = sizeof (*reply);
	      break;
	  }

      /* save the name, font ID and size */

      if (fontTable->numFonts == fontTable->numAlloc)
	  {
	      fontTable->numAlloc += NUMFONT;
	      fontTable->fontTable = (fontPtr)realloc
		      ((char *)fontTable->fontTable,
		       fontTable->numAlloc * sizeof(*fontTable->fontTable));
	  }
      /* ..should it be checked that fid by this client is not already
      ** used? --msa
      */
      font = &fontTable->fontTable[fontTable->numFonts++];
      font->fd = fd;
      font->fid = req->fid;
      font->size = GetFontSize(fontName);
      font->font_data = ReferenceFont(f);
    }
    break;

  case X_QueryFont:           /* needs reply */
    {
      xResourceReq           *req = (xResourceReq *) buf;
      xQueryFontReply        *reply = (xQueryFontReply *) newmsg;
      XFontStruct            *font_struct;
      fontPtr                font;
      int                    ii = 0;
      char		     *ptr;

      for (font = NULL; ii < fontTable->numFonts; ii++)
	  {
	      font = &fontTable->fontTable[ii];
	      if (font->fid == req->id)
		      break;
	  }

      /* if the font is not loaded on the server */

      if (!font || !font->font_data)
	  {
	      xError    *reply = (xError *) newmsg;

	      fprintf (stderr, "font ID %ld not found\n", req->id);

	      reply->type = X_Error;
	      reply->errorCode = 7; /* "Font" (where is define for this?) */
	      reply->minorCode = 0;
	      reply->majorCode = req->reqType;
	      reply->resourceID = req->id;
	      *newlen = sizeof (*reply);
	      break;
	  }
      else
	  {
	      FontData  *f = font->font_data;
	      font_struct = f->font_info;
	
	      /* copy the the fontInfo from the font_struct */

	      ReplyCharInfo(&reply->minBounds, &font_struct->min_bounds,
			    f, font->size);
	      ReplyCharInfo(&reply->maxBounds, &font_struct->max_bounds,
			    f, font->size);
	      reply->minCharOrByte2 = font_struct->min_char_or_byte2;
	      reply->maxCharOrByte2 = font_struct->max_char_or_byte2;
	      reply->defaultChar = font_struct->default_char;
	      reply->nFontProps = font_struct->n_properties;
	      reply->drawDirection = font_struct->direction;
	      reply->minByte1 = font_struct->min_byte1;
	      reply->maxByte1 = font_struct->max_byte1;
	      reply->allCharsExist = font_struct->all_chars_exist;
	      reply->fontAscent = PIXELS(f, font_struct->ascent, font->size);
	      reply->fontDescent = PIXELS(f, font_struct->descent, font->size);
	      reply->nCharInfos = font_struct->max_char_or_byte2 -
		      font_struct->min_char_or_byte2;

	      /* copy the fontprop + charinfo structures */
 
	      ptr = (( char *) reply) + sizeof( xQueryFontReply);
	      for (ii = 0; ii < reply->nFontProps; ++ii)
		  {
		      ReplyFontProp((xFontProp *)ptr,
				    &font_struct->properties[ii],
				    f, font->size);
		      ptr += sizeof(xFontProp);
		  }
	      for (ii = 0; ii < reply->nCharInfos; ++ii)
		  {
		      ReplyCharInfo((xCharInfo *)ptr,
				    &font_struct->per_char[ii],
				    f, font->size);
		      ptr += sizeof(xCharInfo);
		  }
	      *newlen = sizeof (*reply) +
		      sizeof(xCharInfo)*reply->nCharInfos +
			      sizeof(xFontProp)*reply->nFontProps;
	      reply->length =
		      7 + reply->nFontProps * 2 + reply->nCharInfos * 3;
	  }
    }
    break;

  case X_QueryTextExtents:      /* needs reply */
    {
      xQueryTextExtentsReq   *req =
      (xQueryTextExtentsReq *) buf;
      xQueryTextExtentsReply *reply =
      (xQueryTextExtentsReply *) newmsg;
      int                     nchars,
                              dir,
                              ascent,
                              descent;
      XCharStruct             overall;
      int                     ii = 0;
      fontPtr                 font;

      for (font = NULL; ii < fontTable->numFonts; ii++)
	  {
	      font = &fontTable->fontTable[ii];
	      if (font->fid == req->fid)
		      break;
	  }
      if (font)
	  {
	      FontData *f = font->font_data;

	      nchars = (req->length >> 1) - req->oddLength;
	      XTextExtents16(f->font_info,
			     (XChar2b *) buf + sizeof (*req),
			     nchars, &dir, &ascent, &descent, &overall);
	      reply->fontAscent = PIXELS(f, ascent, font->size);
	      reply->fontDescent = PIXELS(f, descent, font->size);
	      reply->overallAscent = PIXELS(f, overall.ascent, font->size);
	      reply->overallDescent = PIXELS(f, overall.descent, font->size);
	      reply->overallWidth = PIXELS(f, overall.width, font->size);
	      reply->overallLeft = PIXELS(f, overall.lbearing, font->size);
	      reply->overallRight = PIXELS(f, overall.rbearing, font->size);
	      *newlen = sizeof (*reply);
	  }
      else
	  {
	      xError    *reply = (xError *) newmsg;

	      reply->type = X_Error;
	      reply->errorCode = 7; /* "Font" (where is define for this?) */
	      reply->minorCode = 0;
	      reply->majorCode = req->reqType;
	      reply->resourceID = req->fid;
	      *newlen = sizeof (*reply);
	  }
    }
    break;

  case X_ListFonts:           /* needs reply */
    {
      xListFontsReq          *req = (xListFontsReq *) buf;
      xListFontsReply        *reply = (xListFontsReply *) newmsg;
      FontData               **fonts;
      char                   **aliases, *pattern;
      unsigned char          *ptr = newmsg + sizeof (*reply);
      int                     ii, length = 0, nfonts, n;

      pattern = (char *)buf + sizeof(*req);
      reply->nFonts = 0;

      fonts = GetFontsList(&nfonts);
      for ( ii = 0; reply->nFonts < req->maxNames && ii < nfonts; ii++)
	      if (fonts[ii]->xlfd &&
		  FontMatch(pattern, req->nbytes, fonts[ii]->xlfd))
		  {
		      n = strlen(fonts[ii]->xlfd);
		      ptr[ length++] = n;
		      memcpy(( void *)&ptr[length], (void *)fonts[ii]->xlfd,n);
		      reply->nFonts += 1;
		      length += n;
		  }
      
      aliases = GetFontAliases(&nfonts);
      for ( ii = 0; reply->nFonts < req->maxNames && ii < nfonts; ii++)
	      if (aliases[2*ii] &&
		  FontMatch(pattern, req->nbytes, aliases[2*ii]))
		  {
		      n = strlen(aliases[2*ii]);
		      ptr[ length++] = n;
		      memcpy(( void *)&ptr[length], (void *)aliases[2*ii], n);
		      reply->nFonts += 1;
		      length += n;
		  }
      reply->length = (length + 3) >> 2;
      *newlen = sizeof (*reply) + (reply->length << 2);
    }
    break;

  case X_ListFontsWithInfo:   /* needs reply */
    {
      xListFontsWithInfoReq  *req =  (xListFontsWithInfoReq *) buf;
      xListFontsWithInfoReply *reply = (xListFontsWithInfoReply *) newmsg;
      FontData                **fonts;
      char                    **aliases, *pattern, *ptr;
      int                     ii = 0, i,
                              nfonts, num_done;
      XFontStruct            *fs;

      *newlen = 0;
      pattern = (char *)buf + sizeof(*req);

      fonts = GetFontsList(&nfonts);

/* Should also match things through aliases? But, what to do if the same
   font is matched by alias and real name? Give it out twice? Now, only
   match real names as quick and dirty... -- msa */
      
/* this generates a set of replies.  Right now, all I do is write then,
   but there's a high likelihood of overflow */

      for (num_done = 0; num_done < req->maxNames && ii < nfonts; ii++)
	  {
	      int font_size;

	      if (!fonts[ii]->xlfd ||
		  !FontMatch(pattern, req->nbytes, fonts[ii]->xlfd))
		      continue;
	      fs = fonts[ii]->font_info;
	      reply->nameLength = strlen (fonts[ii]->xlfd) + 1;
	      num_done += 1;

	      font_size = GetFontSize(fonts[ii]->xlfd);

	      ReplyCharInfo(&reply->minBounds, &fs->min_bounds,
			    fonts[ii], font_size);
	      ReplyCharInfo(&reply->maxBounds, &fs->max_bounds,
			    fonts[ii], font_size);
	      reply->minCharOrByte2 = fs->min_char_or_byte2;
	      reply->maxCharOrByte2 = fs->max_char_or_byte2;
	      reply->defaultChar = fs->default_char;
	      reply->nFontProps = fs->n_properties;
	      reply->drawDirection = fs->direction;
	      reply->minByte1 = fs->min_byte1;
	      reply->maxByte1 = fs->max_byte1;
	      reply->allCharsExist = fs->all_chars_exist;
	      reply->fontAscent = PIXELS(fonts[ii], fs->ascent, font_size);
	      reply->fontDescent = PIXELS(fonts[ii], fs->descent, font_size);
	      reply->nReplies = nfonts - ii;

	      /* copy the propertyu structures, but not char infos */

	      ptr = (( char *)reply) + sizeof(*reply);
	      for (i = 0; i < reply->nFontProps; ++i)
		  {
		      ReplyFontProp((xFontProp *)ptr, &fs->properties[i],
				    fonts[ii], font_size);
		      ptr += sizeof(xFontProp);
		  }

	      /* copy the name of the font */

	      strcpy ((char *)ptr, fonts[ii]->xlfd);
	      *newlen += sizeof (*reply) + strlen(fonts[ii]->xlfd) + 1 +
		      sizeof (xFontProp) * reply->nFontProps;
	      reply = (xListFontsWithInfoReply *) (buf + pad (*newlen));
	  }

      /* nameLength = 0 implies end of sequence */

      reply->nameLength = 0;
      *newlen += sizeof (reply);
    }
    break;

  case X_GetFontPath:         /* needs reply */
    {
      xReq                   *req = (xReq *) buf;
      xGetFontPathReply      *reply =
      (xGetFontPathReply *) newmsg;
      char                  **paths;
      unsigned char          *ptr = newmsg + sizeof (*reply);
      int                    n, length = 0;

      paths = GetFontPath ();
      reply->nPaths = 0;
      for (length = 0; *paths; ++paths)
      {
	n = strlen(*paths);
	ptr[length++] = n;
        memcpy((char *)&ptr[length], *paths, n);
	reply->nPaths += 1;
	length += n;
      }
      reply->length = (length + 3) >> 2;
      *newlen = sizeof (*reply) + (reply->length << 2);
    }
    break;

  case X_FreePixmap:
    {
      xResourceReq           *req = (xResourceReq *) buf;

      deleteWin (winfoTable, req->id);
    }
    break;

/*- Copy the standard GC, then use the flags to get the
|| attributes from the message.
*/
  case X_CreateGC:
    {
      xCreateGCReq           *req = (xCreateGCReq *) buf;
      const int               ind = gcinfoTable->numGc++;

      static gcinfoRec init_gcinfo;
      
      if (gcinfoTable->numAlloc == ind)
	  {
	      gcinfoTable->numAlloc += NUMGC;
	      gcinfoTable->gcTable = (gcinfoPtr)realloc
		      ((char *)gcinfoTable->gcTable,
		       gcinfoTable->numAlloc * sizeof(gcinfoRec));
	  }
      gc = &gcinfoTable->gcTable[ind];
      *gc = init_gcinfo;
      gc->attr = initial_GC;
      gc->attr.line_width = 1;	/* Force 1 as default! */
      gc->gcid = req->gc;
      gc->fd = fd;

/* pull out the value mask and use it to get the values from the request, 
   set a pointer into the values section of the request */

      if ((winfo = getwinfo (req->drawable, winfoTable)))
        setGcvalues (fd, printFp, gc, req->mask,
                     (unsigned long *)
                     (buf + sizeof (xCreateGCReq)),
                     winfo->attr.colormap);
      else
        fprintf (stderr, "X_CreateGC: bad window id %ld\n",
                 req->drawable);
    }
    break;

  case X_ChangeGC:
    {
      xChangeGCReq           *req = (xChangeGCReq *) buf;

/* have to intercept these, because there's no other way to get the info 
   send the print window down for the colormap for setcolor */

      if ((gc = getgcinfo (req->gc, gcinfoTable)))
      {
        winfo = getwinfo (PCS[fd].win, winfoTable);
        setGcvalues (fd, printFp, gc, req->mask,
                     (unsigned long *)(buf + sizeof (xChangeGCReq)),
                     winfo->attr.colormap);
      }
      else
        fprintf (stderr, "X_ChangeGC bad GC %ld\n", req->gc);
    }
    break;

  case X_CopyGC:
    {
      xCopyGCReq             *req = (xCopyGCReq *) buf;
      gcinfoPtr               gc2 = getgcinfo (req->dstGC, gcinfoTable);

      gc = getgcinfo (req->srcGC, gcinfoTable);

      if (gc && gc2)
        copyGcvalues (gc, gc2, req->mask);
    }
    break;

  case X_SetDashes:
    {
      xSetDashesReq          *req = (xSetDashesReq *) buf;

      if ((gc = getgcinfo (req->gc, gcinfoTable)))
      {
        gc->attr.dash_offset = req->dashOffset;
        gc->numDashes = req->nDashes;
	if (gc->dashes)
		free((char *)gc->dashes);
        gc->dashes = (char *) malloc (req->nDashes);
        memcpy (gc->dashes, buf + sizeof (*req), gc->numDashes);
	if (PCS[fd].gc == gc)  /* A kludge to get GC updated on next draw */
		PCS[fd].gc = NULL;
      }
      else
        fprintf (stderr, "X_SetDashes bad GC %ld\n", req->gc);
    }
    break;

  case X_SetClipRectangles:
    {
      xSetClipRectanglesReq  *req = (xSetClipRectanglesReq *) buf;

      if ((gc = getgcinfo (req->gc, gcinfoTable)))
      {

/* set the clip x and y origin */

        gc->attr.clip_x_origin = req->xOrigin;
        gc->attr.clip_y_origin = req->yOrigin;

/* then copy the clip rectangles */

        if (gc->clipRects)
          free ((char *)gc->clipRects);
        nrect = (req->length - 3) >> 1;
        gc->clipRects = (XRectangle *) malloc (sizeof (XRectangle) * nrect);
        memcpy ((char *)gc->clipRects,
                buf + sizeof (xSetClipRectanglesReq),
                nrect * sizeof (XRectangle));
        gc->numClipRects = nrect;
      }
      else
        fprintf (stderr, "X_SetClipRectangles bad GC %ld\n",
                 req->gc);
    }
    break;

  case X_FreeGC:
    {
      xResourceReq           *req = (xResourceReq *) buf;

      deleteGc (gcinfoTable, req->id);
      break;
    }
    break;

  case X_ClearArea:
    {
      xClearAreaReq          *req = (xClearAreaReq *) buf;

      if ((winfo = getwinfo (req->window, winfoTable)))
        cleararea (fd, printFp, req->window, &(winfo->attr),
                   req->x, req->y, req->width, req->height);
      else
        fprintf (stderr, "X_ClearArea: bad window ID %ld\n",
                 req->window);
    }
    break;

  case X_CopyArea:
    {
      xCopyAreaReq           *req = (xCopyAreaReq *) buf;

      if ((winfo = getwinfo (req->dstDrawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo(winfo->attr.colormap)) != NULL)
      {
	  copyarea (fd, printFp, req->srcDrawable, req->dstDrawable,
		    req->srcX, req->srcY, req->dstX, req->dstY,
		    req->width, req->height,
		    NUM_COLORS, cmapinfo->colors);
      }
      else
        fprintf (stderr, "X_CopyArea: bad window ID %ld\n",
                 req->dstDrawable);
    }
    break;

  case X_PolyPoint:
    {
      xPolyPointReq          *req = (xPolyPointReq *) buf;

      flag = req->coordMode;
      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
      {
	  ErrorGContext
		  (newmsg, newlen, buf, "X_PolyPoint bad GC %ld\n", req->gc);
	  break;
      }

      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
        polypoint (fd, printFp, req->drawable, gc,
                   req->length - 3, (int) req->coordMode,
                   (XPoint *) (buf + sizeof (xPolyPointReq)));
      }
      else
        fprintf (stderr, "X_PolyPoint: bad window ID %ld\n",
                 req->drawable);
    }
    break;

  case X_PolyLine:
    {
      xPolyLineReq           *req = (xPolyLineReq *) buf;

      flag = req->coordMode;
      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
      {
	  ErrorGContext
		  (newmsg, newlen, buf, "X_Polyline bad GC %ld\n", req->gc);
	  break;
      }

      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
        polyline (fd, printFp, req->drawable, gc,
                  req->length - 3, (int) req->coordMode,
                  (XPoint *) (buf + sizeof (xPolyLineReq)));
      }
      else
        fprintf (stderr, "X_PolyLine: bad window ID %ld\n",
                 req->drawable);
    }
    break;

  case X_PolySegment:
    {
      xPolySegmentReq        *req = (xPolySegmentReq *) buf;

      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
      {
	  ErrorGContext
		  (newmsg, newlen, buf, "X_PolySegment bad GC %ld\n", req->gc);
	  break;
      }

      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
        polysegment (fd, printFp, req->drawable, gc,
                     (req->length - 3) >> 1,
                     (XSegment *)
                     (buf + sizeof (xPolySegmentReq)));
      }
      else
        fprintf (stderr, "X_PolySegment: bad window ID %ld\n",
                 req->drawable);
    }
    break;

  case X_PolyRectangle:
    {
      xPolyRectangleReq      *req = (xPolyRectangleReq *) buf;

      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
      {
	  ErrorGContext(newmsg, newlen, buf,
			"X_PolyRectangle bad GC %ld\n", req->gc);
	  break;
      }

      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
        polyrectangle (fd, printFp, req->drawable, gc,
                       (req->length - 3) >> 1,
                       (XRectangle *)
                       (buf + sizeof (xPolyRectangleReq)));
      }
      else
        fprintf (stderr, "X_PolyRectangle: bad window ID %ld\n",
                 req->drawable);
    }
    break;

  case X_PolyArc:
    {
      xPolyArcReq            *req = (xPolyArcReq *) buf;

      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
      {
        ErrorGContext
		(newmsg, newlen, buf, "X_PolyArc bad GC %ld\n", req->gc);
	break;
      }

      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
        polyarc (fd, printFp, req->drawable, gc, (req->length - 3) / 3,
                 (xArc *) (buf + sizeof (xPolyArcReq)));
      }
      else
        fprintf (stderr, "X_PolyArc: bad window ID %ld\n",
                 req->drawable);
    }
    break;

  case X_FillPoly:
    {
      xFillPolyReq           *req = (xFillPolyReq *) buf;

/* flag for coordinate mode */

      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
      {
	  ErrorGContext
		  (newmsg, newlen, buf, "X_FillPoly bad GC %ld\n", req->gc);
	  break;
      }

      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
        fillpoly (fd, printFp, req->drawable, gc,
                  req->length - 4, req->coordMode,
                  (XPoint *) (buf + sizeof (xFillPolyReq)));
      }
      else
      {
        fprintf (stderr, "X_PolyRectangle: bad window ID %ld\n",
                 req->drawable);
      }
    }
    break;

  case X_PolyFillRectangle:
    {
      xPolyRectangleReq      *req = (xPolyRectangleReq *) buf;

      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
      {
	  ErrorGContext
		  (newmsg, newlen, buf, "X_PolyFillRectangle bad GC %ld\n",
		   req->gc);
	  break;
      }

      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
        polyfillrectangle (fd, printFp, req->drawable, gc,
                           (req->length - 3) >> 1,
                           (XRectangle *)
                           (buf + sizeof (xPolyRectangleReq)));
      }
      else
        fprintf (stderr, "X_PolyFillRectangle: bad window ID %ld\n",
                 req->drawable);
    }
    break;

  case X_PutImage:
    {
      xPutImageReq           *req = (xPutImageReq *) buf;

      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
	  {
	      ErrorGContext(newmsg, newlen, buf,
			     "X_PutImage bad GC %ld\n", req->gc);
	      break;
	  }

/* get the window's colormap so we know what colors to use for the image */

      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
	putimage (fd, printFp, req->drawable, gc,
		  req->depth, req->width, req->height,
		  req->dstX, req->dstY, req->pad, req->format,
		  NUM_COLORS, cmapinfo->colors,
		  buf + sizeof (xPutImageReq));
      } else {
        fprintf (stderr, "X_PutImage: bad window ID %ld\n",
                 req->drawable);
      }
    }
    break;

/* GetImage is totally kludged,  It sends back an entirely blank image */

  case X_GetImage:              /* needs reply */
    {
      xGetImageReq           *req = (xGetImageReq *) buf;
      xGetImageReply         *reply = (xGetImageReply *) newmsg;

      reply->depth = 8;
      reply->length = req->width * req->height * 2;
      *newlen = sizeof (*reply) + reply->length * 2;
    }
    break;

  case X_PolyText8:
    {
      xPolyText8Req          *req = (xPolyText8Req *) buf;

      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
      {
	  ErrorGContext(newmsg, newlen, buf,
			"X_PolyText8 bad GC %ld\n", req->gc);
	  break;
      }
      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
        polytext8 (fd, printFp, req->drawable, gc, req->x, req->y,
                   (req->length * 4) - sizeof (xPolyText8Req),
                   buf + sizeof (xPolyText8Req));
      }
      else
        fprintf (stderr, "X_PolyText8: bad window ID %ld\n",
                 req->drawable);
    }
    break;

  case X_PolyText16:
    {
      xPolyText16Req         *req = (xPolyText16Req *) buf;

      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
      {
        ErrorGContext(newmsg, newlen, buf, 
		      "X_PolyText16 bad GC %ld\n", req->gc);
	break;
      }
      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
        polytext16 (fd, printFp, req->drawable, gc, req->x, req->y,
                    (req->length - 4) >> 2,
                    buf + sizeof (xPolyText16Req));
      }
      else
        fprintf (stderr, "X_PolyText8: bad window ID %ld\n",
                 req->drawable);
    }
    break;

  case X_ImageText8:
    {
      xImageText8Req         *req = (xImageText8Req *) buf;

      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
      {
	  ErrorGContext(newmsg, newlen, buf,
			"X_ImageText8 bad GC %ld\n", req->gc);
	  break;
      }
      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
        imagetext8 (fd, printFp, req->drawable, gc, req->x, req->y,
                    req->nChars, buf + sizeof (xImageText8Req));
      }
      else
        fprintf (stderr, "X_ImageText8: bad window ID %ld\n",
                 req->drawable);
    }
    break;

  case X_ImageText16:
    {
      xImageText16Req        *req = (xImageText16Req *) buf;

      if ((gc = getgcinfo (req->gc, gcinfoTable)) == NULL)
      {
	  ErrorGContext(newmsg, newlen, buf, 
			"X_ImageText16 bad GC %ld\n", req->gc);
	  break;
      }

      if ((winfo = getwinfo (req->drawable, winfoTable)) != NULL &&
	  (cmapinfo = getcmapinfo (winfo->attr.colormap)) != NULL)
      {
        setCurrGc (fd, printFp, gc, cmapinfo->cmap);
        imagetext16 (fd, printFp, req->drawable, gc, req->x, req->y,
                     (req->length - 4) >> 2,
                     buf + sizeof (xImageText16Req));
      }
      else
        fprintf (stderr, "X_ImageText16: bad window ID %ld\n",
                 req->drawable);
    }
    break;

  case X_CreateColormap:
    {
      xCreateColormapReq     *req = (xCreateColormapReq *) buf;

      (void)createColormap(req->mid, req->visual, fd);
    }
    break;

  case X_FreeColormap:
    {
      xResourceReq           *req = (xResourceReq *) buf;

      deleteCmap (cmapinfoTable, req->id);
    }
    break;

  case X_CopyColormapAndFree:
    {

/* create a new colormap and copy the old colormap to it */

      xCopyColormapAndFreeReq *req = (xCopyColormapAndFreeReq *) buf;
      int i;
      cmapinfoPtr src, dst;

      /* ...the code is incomplete, what about freeing the old? ..and
	 new numAlloc should only include counts from this client!! -- msa */

      src = getcmapinfo(req->srcCmap);
      if (src == NULL)
	      break;
      dst = createColormap(req->mid, src->visualID, fd);
      if (dst == NULL)
	      break;
      for (i = 0; i < NUM_COLORS; i++)
      {
        dst->colors[i] = src->colors[i];
        dst->numAlloc[i] = src->numAlloc[i];
      }
    }
    break;

  case X_AllocColor:            /* needs reply */
    {
      xAllocColorReq         *req = (xAllocColorReq *) buf;
      xAllocColorReply       *reply = (xAllocColorReply *) newmsg;
      unsigned               red, green, blue;
      long                   pixel;

      red = req->red;
      green = req->green;
      blue = req->blue;
      
      pixel = allocColor(req->cmap, &red, &green, &blue);
      if (pixel == -1)
	  {
	      xError *err = (xError *)reply;
	      err->type = X_Error;
	      err->errorCode = 11; /* "Alloc" error */
	      err->minorCode = 0;
	      err->majorCode = req->reqType;
	      *newlen = sizeof(*err);
	  }
      else
	  {
	      reply->pixel = pixel;
	      reply->red = red;
	      reply->green = green;
	      reply->blue = blue;
	      reply->length = 0;
	      *newlen = sizeof (*reply);
	  }
    }
    break;

  case X_AllocNamedColor:     /* needs reply */
    {
      xAllocNamedColorReq    *req = (xAllocNamedColorReq *) buf;
      xAllocNamedColorReply  *reply =
      (xAllocNamedColorReply *) newmsg;
      char                    name[256];
      XColor                  exact;
      unsigned                red, green, blue;
      long                    pixel;

/* use the real server to get the mapping from the name to RGB values */

      /* needs to get rid of THE_DISPLAY! -- msa */

      strncpy (name, (char *) buf + sizeof (*req),
	       sizeof(name) < req->nbytes ? sizeof(name) : req->nbytes);
      name[sizeof(name)-1] = 0;
      XParseColor (THE_DISPLAY,
                   DefaultColormap (THE_DISPLAY, DefaultScreen (THE_DISPLAY)),
                   name, &exact);
      red = exact.red;
      green = exact.green;
      blue = exact.blue;

      pixel = allocColor(req->cmap, &red, &green, &blue);
      if (pixel == -1)
	  {
	      xError *err = (xError *)reply;
	      err->type = X_Error;
	      err->errorCode = 11; /* "Alloc" error */
	      err->minorCode = 0;
	      err->majorCode = req->reqType;
	      *newlen = sizeof(*err);
	  }
      else
	  {
	      reply->pixel = pixel;
	      reply->exactRed = exact.red;
	      reply->exactGreen = exact.green;
	      reply->exactBlue = exact.blue;
	      reply->screenRed = red;
	      reply->screenGreen = green;
	      reply->screenBlue = blue;
	      reply->length = 0;
	      *newlen = sizeof (*reply);
	  }
    }
    break;

/* both of these are just hacked so that I've got a reply */

  case X_AllocColorCells:     /* needs reply */
    {
      xAllocColorCellsReq    *req = (xAllocColorCellsReq *) buf;
      xAllocColorCellsReply  *reply =
      (xAllocColorCellsReply *) newmsg;
      unsigned long          *pixel;
      int                     ii = 0;

      cmapinfo = getcmapinfo (req->cmap);
      reply->nPixels = req->colors;
      reply->nMasks = req->planes;
      pixel = (unsigned long *) buf + sizeof (*req);

      for (; ii < reply->nPixels; ii++)
        *pixel++ = ii;

      for (ii = 0; ii < reply->nMasks; ii++)
        *pixel++ = (1 << ii);

      reply->length = reply->nPixels + reply->nMasks;
      *newlen = sizeof (*reply) + (reply->nPixels << 2) +
        (reply->nMasks << 2);
    }
    break;

  case X_AllocColorPlanes:      /* needs reply */
    {
      xAllocColorPlanesReq   *req = (xAllocColorPlanesReq *) buf;
      xAllocColorPlanesReply *reply =
      (xAllocColorPlanesReply *) newmsg;
      unsigned long          *pixel;
      int                     ii = 0;

      cmapinfo = getcmapinfo (req->cmap);
      reply->nPixels = req->colors;
      pixel = (unsigned long *) (buf + sizeof (*req));

      for (; ii < reply->nPixels; ii++) {
        *pixel++ = ii;
      }

      reply->redMask = reply->greenMask = reply->blueMask = 0;
      reply->length = reply->nPixels;

      *newlen = sizeof (*reply) + (reply->nPixels << 2);
    }
    break;

  case X_FreeColors:
    {
      xFreeColorsReq         *req = (xFreeColorsReq *) buf;
      unsigned long          *pixel;
      int                     ii = 0;

      pixel = (unsigned long *) (buf + sizeof (*req));
      cmapinfo = getcmapinfo (req->cmap);
      if (cmapinfo == NULL)
	      break;
      if ( cmapinfo->visualID == PSEUDOCOLOR_VISUAL) {
	for (; ii < req->length - 3; ii++) {
	  if (pixel[ii] < NUM_COLORS) {
	    cmapinfo->numAlloc[pixel[ii]] -= 1;
	  } else {
	    fprintf (stderr, "pixel out of range %ld\n", *pixel);
	  }
	}
      } 
	

    }
    break;

/* both store colors and store named colors should give errors for true color
   visuals, but we might as well be nicer than the standard X server. */

  case X_StoreColors:
    {
      xStoreColorsReq        *req = (xStoreColorsReq *) buf;
      int                     ncolors = (req->length - 2) / 3;
      xColorItem             *color = (xColorItem *) (buf + sizeof (*req));
      int                     ii;

      cmapinfo = getcmapinfo (req->cmap);
      if (cmapinfo == NULL)
	      break;
      if ( cmapinfo->visualID == PSEUDOCOLOR_VISUAL) {
	for ( ii = 0; ii < ncolors; ii++) {
	  if ( color->pixel < NUM_COLORS) {
	    cmapinfo->colors[ color->pixel].red = COLOR_VALUE(color->red);
	    cmapinfo->colors[ color->pixel].green = COLOR_VALUE(color->green);
	    cmapinfo->colors[ color->pixel].blue = COLOR_VALUE(color->blue);
	    cmapinfo->colors[ color->pixel].pixel = color->pixel;
	  } else {
	    fprintf (stderr, "pixel out of range %lu\n", ( unsigned long) color->pixel);
	  }
	  color++;
	}
      } 

/* this request is simply ignored by the TrueColor Visual */
    }
    break;

  case X_StoreNamedColor:
    {
      xStoreNamedColorReq    *req = (xStoreNamedColorReq *) buf;
      XColor                  exact,
                              screen;
      int                     ind = req->pixel;
      char                    colorname[256];

      strncpy (colorname, (char *) buf + sizeof (*req), req->nbytes);
      XLookupColor (THE_DISPLAY,
                    DefaultColormap (THE_DISPLAY,
                                     DefaultScreen (THE_DISPLAY)),
                    colorname, &exact, &screen);
      cmapinfo = getcmapinfo (req->cmap);
      if (cmapinfo == NULL)
	      break;
      if ( cmapinfo->visualID == PSEUDOCOLOR_VISUAL) {
	if ((ind >= 0) && (ind < NUM_COLORS)) {
	  cmapinfo->colors[ind].red = COLOR_VALUE(exact.red),
	  cmapinfo->colors[ind].green = COLOR_VALUE(exact.green),
	  cmapinfo->colors[ind].blue = COLOR_VALUE(exact.blue),
	  cmapinfo->colors[ind].pixel = ind;
	} else {
	  fprintf (stderr, "pixel out of range %d\n", ind);
	}
      } 

/* this request is ignored by the truecolor visual */

    }
    break;

  case X_QueryColors:         /* needs reply */
    {
      xQueryColorsReq        *req = (xQueryColorsReq *) buf;
      xQueryColorsReply      *reply = (xQueryColorsReply *) newmsg;
      xrgb		     *rgb = (xrgb *)(newmsg+sizeof(xQueryColorsReply));
      int		     nColors = req->length - 2, ii;
      long		     *pixels = (long *)(buf + sizeof(xQueryColorsReq));

      cmapinfo = getcmapinfo (req->cmap);
      if (cmapinfo == NULL)
	      /* should give error reply here! -- msa */;
      else if ( cmapinfo->visualID == PSEUDOCOLOR_VISUAL)
      {
	for ( ii = 0; ii < nColors; ii++)
        {
	  if (pixels[ii] >=0 && pixels[ii] < NUM_COLORS)
	      {
		  rgb->red = cmapinfo->colors[pixels[ii]].red;
		  rgb->green = cmapinfo->colors[pixels[ii]].green;
		  rgb->blue = cmapinfo->colors[pixels[ii]].blue;
	      }
	  else
		  fprintf(stderr, "pixel out of range %ld\n", pixels[ii]);
	  rgb++;
	}
      }
      else if ( cmapinfo->visualID == TRUECOLOR_VISUAL)
      {
/* just pull the colors out of the pixel */

	for ( ii = 0; ii < nColors; ii++)
	{
	  rgb->red = (pixels[ ii] & 0xff) << 8;
	  rgb->green = pixels[ ii] & 0xff00;
	  rgb->blue = (pixels[ ii] & 0xff0000) >> 8;
	  rgb++;
	}
      }
      reply->nColors = nColors;
      reply->length = 2 * nColors;
      *newlen = sizeof(*reply) + nColors * sizeof(xrgb);
    }
    break;

  case X_LookupColor:         /* needs reply */
    {
      xLookupColorReq        *req = (xLookupColorReq *) buf;
      xLookupColorReply      *reply = (xLookupColorReply *) newmsg;
      char                   *colorname = (char *) buf + sizeof (*req);
      XColor                  exact,
                              screen;

      XLookupColor (THE_DISPLAY,
                    DefaultColormap (THE_DISPLAY, DefaultScreen (THE_DISPLAY)),
                    colorname, &exact, &screen);
      reply->exactRed = exact.red;
      reply->exactGreen = exact.green;
      reply->exactBlue = exact.blue;
      reply->screenRed = screen.red;
      reply->screenGreen = screen.green;
      reply->screenBlue = screen.blue;
      *newlen = sizeof (*reply);
    }
    break;

  case X_QueryBestSize:       /* needs reply */
    {
      xQueryBestSizeReply    *reply =
      (xQueryBestSizeReply *) newmsg;

      reply->width = 16;        /* guesses.. */
      reply->height = 16;
      reply->length = 0;
      *newlen = sizeof (*reply);
    }
    break;

/* delete the extension request from the client and insert our reply that
   the extension exists */

  case X_QueryExtension:
    {
      xQueryExtensionReply   *reply =
      (xQueryExtensionReply *) newmsg;
      char                   *extname;

      extname = (char *) buf + sizeof (xQueryExtensionReq);
      if (strncmp (extname, PRINTNAME, strlen (PRINTNAME)) == 0)
      {

        reply->length = 0;
        reply->present = True;
        reply->major_opcode = EXTENSION_BASE + 1;
        THE_OPCODE = EXTENSION_BASE + 1;
        reply->first_event = 0;
        reply->first_error = 0;
      }
      else
      {
        reply->length = 0;
        reply->present = False;
      }
      *newlen = sizeof (*reply);
    }
    break;

  case X_ListExtensions:        /* needs reply */
    {
      xListExtensionsReply   *reply =
      (xListExtensionsReply *) newmsg;
      int		     n;

      reply->nExtensions = 1;   /* just this extension */

/* the length of the string for the name of the extension is preceded by
   a 1 character length */

      n = sizeof( *reply);
      newmsg[ n++] = strlen( PRINTNAME);
      strcpy ((char *) &newmsg[ n], PRINTNAME);
      reply->length = (strlen (PRINTNAME) + 1 + 3) >> 2;
      *newlen = sizeof (*reply) + (reply->length << 2);
    }
    break;

  case X_GetKeyboardMapping:    /* needs reply */
    {
      xGetKeyboardMappingReq *req =
      (xGetKeyboardMappingReq *) buf;
      xGetKeyboardMappingReply *reply =
      (xGetKeyboardMappingReply *) newmsg;

      reply->keySymsPerKeyCode = 1;
      reply->length = req->count;
      *newlen = sizeof (*reply) + (reply->length << 2);
    }
    break;

  case X_GetKeyboardControl:    /* needs reply */
    {
      xGetKeyboardControlReply *reply =
      (xGetKeyboardControlReply *) newmsg;

/* fake it totally, don't even bother with the masks */

      reply->globalAutoRepeat = False;
      reply->ledMask = 0;
      reply->keyClickPercent = 0;
      reply->bellPercent = 0;
      reply->bellPitch = 0;
      reply->bellDuration = 0;
      reply->length = 5;
      *newlen = sizeof (*reply); /* length bytes already included in *reply */
    }
    break;

  case X_GetPointerControl:   /* needs reply */
    {
      xGetPointerControlReply *reply =
      (xGetPointerControlReply *) newmsg;

      reply->accelNumerator = 1;
      reply->accelDenominator = 1;
      reply->threshold = 1;
      reply->length = 0;
      *newlen = sizeof (*reply);
    }
    break;

  case X_GetScreenSaver:        /* needs reply */
    {
      xGetScreenSaverReply   *reply =
      (xGetScreenSaverReply *) newmsg;

      reply->timeout = 10;
      reply->interval = 10;
      reply->preferBlanking = FALSE;
      reply->allowExposures = FALSE;
      reply->length = 0;
      *newlen = sizeof (*reply);
    }
    break;

  case X_ListHosts:           /* no other hosts */
    {
      xListHostsReply        *reply = (xListHostsReply *) newmsg;

      reply->nHosts = 0;
      reply->length = 0;
      *newlen = sizeof (*reply);
    }
    break;

  case X_GetPointerMapping:   /* generate a totally bogus response */
    {
      xGetPointerMappingReply *reply =
      (xGetPointerMappingReply *) newmsg;

      reply->nElts = 0;
      reply->length = 0;
      *newlen = sizeof (*reply);
    }
    break;

  case X_GetModifierMapping:    /* needs reply */
    {
      xGetModifierMappingReply *reply =
      (xGetModifierMappingReply *) newmsg;

      reply->numKeyPerModifier = 0;
      reply->length = 0;
      *newlen = sizeof (*reply);
    }
    break;

/*- Unimplemented. */
  case X_AllowEvents:
  case X_Bell:
  case X_ChangeActivePointerGrab:
  case X_ChangeHosts:
  case X_ChangeKeyboardControl:
  case X_ChangeKeyboardMapping:
  case X_ChangePointerControl:
  case X_ChangeProperty:
  case X_ChangeSaveSet:
  case X_CirculateWindow:
  case X_CloseFont:
  case X_ConfigureWindow:
  case X_ConvertSelection:
  case X_CopyPlane:
  case X_CreateCursor:
  case X_CreateGlyphCursor:
  case X_CreatePixmap:          /* FTM, these are ignored */
  case X_DeleteProperty:
  case X_DestroySubwindows:   /* I really should do something here */
  case X_ForceScreenSaver:
  case X_FreeCursor:
  case X_GrabButton:
  case X_GrabKey:
  case X_GrabServer:
  case X_InstallColormap:
  case X_KillClient:
  case X_ListInstalledColormaps:    /* needs reply */
  case X_MapSubwindows:
  case X_MapWindow:
  case X_NoOperation:
  case X_PolyFillArc:
  case X_QueryKeymap:         /* needs reply */
  case X_RecolorCursor:
  case X_ReparentWindow:
  case X_RotateProperties:
  case X_SendEvent:
  case X_SetAccessControl:
  case X_SetCloseDownMode:
  case X_SetFontPath:
  case X_SetInputFocus:
  case X_SetModifierMapping:
  case X_SetPointerMapping:
  case X_SetScreenSaver:
  case X_SetSelectionOwner:
  case X_UngrabButton:
  case X_UngrabKey:
  case X_UngrabKeyboard:
  case X_UngrabPointer:
  case X_UngrabServer:
  case X_UninstallColormap:
  case X_UnmapSubwindows:
  case X_UnmapWindow:
  case X_WarpPointer:

  default:
    fprintf (stderr, "Unimplemented request opcode.\n");
    break;
  }

  return True;                  /* maybe this will be useful in the future */
}

/*- end handlreq.c
*/
