/*
** Copyright 1992, 1993, 1994 by Markku Savela and
**	Technical Research Centre of Finland
*/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xew/XewInit.h>
#include <X11/Xew/AnimationP.h>


#define offset(field) XtOffsetOf(XeAnimationRec, animation.field)

static XtResource resources[] =
    {
	{XtNfirstFrame, XtCFirstFrame, XtRLong, sizeof(long),
		 offset(first_frame), XtRImmediate, (XtPointer)1},
	{XtNlastFrame, XtCLastFrame, XtRLong, sizeof(long),
		 offset(last_frame), XtRImmediate, (long)0},
	{XtNcurrentFrame, XtCCurrentFrame, XtRLong, sizeof(long),
		 offset(current_frame), XtRImmediate, (long)0},
	{XtNdoneCallback, XtCDoneCallback, XtRCallback, sizeof(XtPointer),
		 offset(done_callbacks), XtRCallback, (XtPointer)NULL},
	{XtNframeCallback, XtCFrameCallback, XtRCallback, sizeof(XtPointer),
		 offset(frame_callbacks), XtRCallback, (XtPointer)NULL},
	{XtNplay, XtCPlay, XtRXePlay, sizeof(XePlay),
		 offset(play), XtRImmediate, XePlay_FORWARD},
	{XtNrate, XtCRate, XtRLong, sizeof(long),
		 offset(rate), XtRImmediate, (long)0},
	{XtNloop, XtCLoop, XtRBoolean, sizeof(Boolean),
		 offset(loop), XtRImmediate, (Boolean)0},
    };
#undef offset

static void ClassPartInitialize(), ClassInitialize(), Initialize();
static Boolean SetValues();

#ifdef USING_MOTIF_122
static XmNavigability WidgetNavigable() ;

/*******************************************/
/*  Declaration of class extension records */

XmBaseClassExtRec _XeAnimationbaseClassExtRec = {
    NULL,
    NULLQUARK,
    XmBaseClassExtVersion,
    sizeof(XmBaseClassExtRec),
    NULL,				/* InitializePrehook	*/
    NULL,				/* SetValuesPrehook	*/
    NULL,				/* InitializePosthook	*/
    NULL,				/* SetValuesPosthook	*/
    NULL,				/* secondaryObjectClass	*/
    NULL,				/* secondaryCreate	*/
    NULL,		                /* getSecRes data	*/
    { 0 },				/* fastSubclass flags	*/
    NULL,				/* get_values_prehook	*/
    NULL,				/* get_values_posthook	*/
    NULL,                               /* classPartInitPrehook */
    NULL,                               /* classPartInitPosthook*/
    NULL,                               /* ext_resources        */
    NULL,                               /* compiled_ext_resources*/
    0,                                  /* num_ext_resources    */
    FALSE,                              /* use_sub_resources    */
    WidgetNavigable,                    /* widgetNavigable      */
    NULL,                               /* focusChange          */
};
#endif

XeAnimationClassRec xeAnimationClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &xeBasicClassRec,
    /* class_name		*/	"XeAnimation",
    /* widget_size		*/	sizeof(XeAnimationRec),
    /* class_initialize		*/	ClassInitialize,
    /* class_part_initialize	*/	ClassPartInitialize,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	NULL,
    /* num_actions		*/	0,
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	NULL,
    /* resize			*/	NULL,
    /* expose			*/	NULL,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	XtInheritTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
#ifdef USING_MOTIF_122
    /* extension		*/	(XtPointer)&_XeAnimationbaseClassExtRec,
#else
    /* extension		*/	NULL,
#endif
  },
  { /* composite class fields	*/
    /* geometry_manager		*/	XtInheritGeometryManager,
    /* change_managed		*/	XtInheritChangeManaged,
    /* insert_child		*/	XtInheritInsertChild,
    /* delete_child		*/	XtInheritDeleteChild,
    /* extension		*/	NULL
  },
  { /* constraint class fields	*/
    /* subresources		*/	NULL,
    /* subresource_count	*/	0,
    /* constraint_size		*/	0,
    /* initialize		*/	NULL,
    /* destroy			*/	NULL,
    /* set_values		*/	NULL,
    /* extension		*/	NULL
   },
#ifdef USING_MOTIF_122
   {/* manager class record	*/
    /* translations		*/	XtInheritTranslations,
    /* syn_resources		*/	NULL,
    /* num_syn_resources	*/	0,
    /* syn_constraint_resources	*/	NULL,
    /* num_syn_constraint_resources */	0,
    /* parent_process		*/	XmInheritParentProcess,
    /* extension		*/	NULL  
   },
#endif
   { /* basic fields */
     /* print_initialize	*/	NULL,
     /* print			*/	XeInheritPrint,
     /* print_cancel		*/	XeInheritPrintCancel,
     /* print_destroy		*/	NULL,
     /* print_constraint_initialize */	NULL,
     /* print_constraint_destroy */	NULL
   },
   { /* XeAnimation fields */
     /* not used			*/	0
   }
};

WidgetClass xeAnimationWidgetClass = (WidgetClass)&xeAnimationClassRec;


static CvtEnumInfo cvtPlay[] =
    {
	{"forward",	XePlay_FORWARD },
	{"reverse",	XePlay_REVERSE },
	{"freeze",	XePlay_FREEZE },
	{NULL,		sizeof(XePlay) },
    };

static void ClassInitialize()
    {
	static XtConvertArgRec convertPlayArg[] =
	    {
		{
		    XtAddress,
		    (XtPointer) &cvtPlay[0],
		    sizeof(XtPointer),
		}
	    };

	XewInitializeWidgetSet();
	XtSetTypeConverter(XtRString, XtRXePlay,
			   XeCvtStringToEnum,
			   convertPlayArg, XtNumber(convertPlayArg),
			   XtCacheNone,
			   (XtDestructor)NULL);
#ifdef USING_MOTIF_122
        _XeAnimationbaseClassExtRec.record_type = XmQmotif;
#endif
    }

static void ClassPartInitialize(class)
WidgetClass class;
    {
    }

static void Initialize(request, new, args, num_args)
Widget request, new;
ArgList args;
Cardinal *num_args;
    {
        XeAnimationWidget w = (XeAnimationWidget)new;
	w->animation.frame_num = 0;
    }

static Boolean SetValues(current, request, new, args, num_args)
Widget current, request, new;
ArgList args;
Cardinal *num_args;
    {
	return False;   
    }

#ifdef USING_MOTIF_122
/*
** WidgetNavigable
**	routine to handle traversal to children of this widget, if
**	there are any, or else the widget itself, if no children. 
*/
static XmNavigability WidgetNavigable(wid)
Widget wid;
    {   
	if(wid->core.sensitive && wid->core.ancestor_sensitive &&
	   ((XmManagerWidget) wid)->manager.traversal_on)
	    {
		XmNavigationType nav_type =
			((XmManagerWidget) wid)->manager.navigation_type;

		if(nav_type == XmSTICKY_TAB_GROUP ||
		   nav_type == XmEXCLUSIVE_TAB_GROUP ||
		   (nav_type == XmTAB_GROUP && !_XmShellIsExclusive( wid)))
			return XmTAB_NAVIGABLE;
		return XmCONTROL_NAVIGABLE;
	    }
	return XmNOT_NAVIGABLE;
    }
#endif
